/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.expression;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.expression.InvalidExpressionException;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DSLExpressionResolver
implements DSLExpression.DSLExpressionVisitor {
    private static final List<String> LOGIC_OPERATORS = Arrays.asList("||");
    public static final List<String> COMPARABLE_OPERATORS = Arrays.asList("<", "<=", ">", ">=");
    public static final List<String> IDENTITY_OPERATORS = Arrays.asList("==", "!=");
    private static final String CONSTRUCTOR_KEYWORD = "new";
    private final Map<String, List<ExecutableElement>> methods = new HashMap<String, List<ExecutableElement>>();
    private final Map<String, List<VariableElement>> variables = new HashMap<String, List<VariableElement>>();
    private final ProcessorContext context;
    private final DSLExpressionResolver parent;
    private final TypeElement accessType;

    private DSLExpressionResolver(ProcessorContext context, TypeElement accessType, DSLExpressionResolver parent, List<? extends Element> lookupElements) {
        this.context = context;
        this.parent = parent;
        this.accessType = accessType;
        this.processElements(lookupElements);
    }

    public TypeElement getAccessType() {
        return this.accessType;
    }

    public void addVariable(String variableName, VariableElement element) {
        this.variables.computeIfAbsent(variableName, l -> new ArrayList()).add(element);
    }

    private void processElements(List<? extends Element> lookupElements) {
        for (Element element : lookupElements) {
            TypeMirror type;
            ElementKind kind = element.getKind();
            if (kind == ElementKind.METHOD || kind == ElementKind.CONSTRUCTOR) {
                this.methods.computeIfAbsent(DSLExpressionResolver.getMethodName((ExecutableElement)element), l -> new ArrayList()).add((ExecutableElement)element);
                continue;
            }
            if (kind != ElementKind.LOCAL_VARIABLE && kind != ElementKind.PARAMETER && kind != ElementKind.FIELD && kind != ElementKind.ENUM_CONSTANT) continue;
            String simpleName = element.getSimpleName().toString();
            if (kind == ElementKind.PARAMETER && simpleName.equals("this") && (type = element.asType()).getKind() == TypeKind.DECLARED) {
                this.processElements(this.getMembers((TypeElement)((DeclaredType)type).asElement()));
            }
            this.variables.computeIfAbsent(simpleName, l -> new ArrayList()).add((VariableElement)element);
        }
    }

    public DSLExpressionResolver(ProcessorContext context, TypeElement accessType, List<? extends Element> lookupElements) {
        this(context, accessType, null, lookupElements);
    }

    public DSLExpressionResolver copy(List<? extends Element> prefixElements) {
        return new DSLExpressionResolver(this.context, this.accessType, this, prefixElements);
    }

    private static String getMethodName(ExecutableElement method) {
        if (method.getKind() == ElementKind.CONSTRUCTOR) {
            return CONSTRUCTOR_KEYWORD;
        }
        return method.getSimpleName().toString();
    }

    @Override
    public void visitCast(DSLExpression.Cast binary) {
    }

    @Override
    public void visitClassLiteral(DSLExpression.ClassLiteral classLiteral) {
    }

    @Override
    public void visitBinary(DSLExpression.Binary binary) {
        boolean valid;
        TypeMirror rightType;
        String operator = binary.getOperator();
        TypeMirror leftType = binary.getLeft().getResolvedType();
        if (!ElementUtils.areTypesCompatible(leftType, rightType = binary.getRight().getResolvedType())) {
            throw new InvalidExpressionException(String.format("Incompatible operand types %s and %s.", ElementUtils.getSimpleName(leftType), ElementUtils.getSimpleName(rightType)));
        }
        TypeMirror booleanType = this.context.getType(Boolean.TYPE);
        if (LOGIC_OPERATORS.contains(operator)) {
            valid = ElementUtils.typeEquals(leftType, booleanType);
        } else if (COMPARABLE_OPERATORS.contains(operator)) {
            valid = ElementUtils.isPrimitive(leftType);
        } else if (IDENTITY_OPERATORS.contains(operator)) {
            valid = leftType.getKind().isPrimitive() || leftType.getKind() == TypeKind.DECLARED || leftType.getKind() == TypeKind.ARRAY;
        } else {
            throw new InvalidExpressionException(String.format("The operator %s is undefined.", operator));
        }
        binary.setResolvedType(booleanType);
        if (!valid) {
            throw new InvalidExpressionException(String.format("The operator %s is undefined for the argument type(s) %s %s.", operator, ElementUtils.getSimpleName(leftType), ElementUtils.getSimpleName(rightType)));
        }
    }

    @Override
    public void visitNegate(DSLExpression.Negate negate) {
        TypeMirror booleanType = this.context.getType(Boolean.TYPE);
        TypeMirror resolvedType = negate.getResolvedType();
        if (!ElementUtils.typeEquals(resolvedType, booleanType)) {
            throw new InvalidExpressionException(String.format("The operator %s is undefined for the argument type %s.", "!", ElementUtils.getSimpleName(resolvedType)));
        }
    }

    private ExecutableElement resolveCall(DSLExpression.Call call) {
        ExecutableElement parentResult;
        List<ExecutableElement> methodsWithName = this.methods.get(call.getName());
        ExecutableElement foundWithName = null;
        if (methodsWithName != null) {
            for (ExecutableElement method : methodsWithName) {
                if (DSLExpressionResolver.matchExecutable(call, method) && ElementUtils.isVisible(this.accessType, method)) {
                    return method;
                }
                foundWithName = method;
            }
        }
        if (this.parent != null && (parentResult = this.parent.resolveCall(call)) != null) {
            return parentResult;
        }
        return foundWithName;
    }

    private static boolean matchExecutable(DSLExpression.Call call, ExecutableElement method) {
        if (!DSLExpressionResolver.getMethodName(method).equals(call.getName())) {
            return false;
        }
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() != call.getParameters().size()) {
            return false;
        }
        int parameterIndex = 0;
        for (DSLExpression expression : call.getParameters()) {
            TypeMirror targetType;
            TypeMirror sourceType = expression.getResolvedType();
            if (!ElementUtils.isAssignable(sourceType, targetType = parameters.get(parameterIndex).asType())) {
                return false;
            }
            expression.setResolvedTargetType(targetType);
            ++parameterIndex;
        }
        return true;
    }

    private VariableElement resolveVariable(DSLExpression.Variable variable) {
        String name;
        switch (name = variable.getName()) {
            case "null": {
                return new CodeVariableElement(new CodeTypeMirror(TypeKind.NULL), "null");
            }
            case "false": {
                return new CodeVariableElement(new CodeTypeMirror(TypeKind.BOOLEAN), "false");
            }
            case "true": {
                return new CodeVariableElement(new CodeTypeMirror(TypeKind.BOOLEAN), "true");
            }
        }
        List<VariableElement> vars = this.variables.get(name);
        if (vars != null && vars.size() > 0) {
            for (VariableElement var : vars) {
                if (!ElementUtils.isVisible(this.accessType, var)) continue;
                return var;
            }
            return vars.iterator().next();
        }
        if (this.parent != null) {
            return this.parent.resolveVariable(variable);
        }
        return null;
    }

    @Override
    public void visitCall(DSLExpression.Call call) {
        DSLExpressionResolver resolver;
        DSLExpression receiver = call.getReceiver();
        if (receiver == null) {
            resolver = this;
        } else {
            ArrayList<Element> elements = new ArrayList<Element>();
            TypeMirror type = receiver.getResolvedType();
            if (type.getKind() == TypeKind.DECLARED) {
                type = this.context.reloadType(type);
                TypeElement t = (TypeElement)((DeclaredType)type).asElement();
                for (Element element : this.getMembers(t)) {
                    ElementKind kind = element.getKind();
                    if (kind != ElementKind.METHOD && kind != ElementKind.CONSTRUCTOR) continue;
                    elements.add(element);
                }
            }
            resolver = new DSLExpressionResolver(this.context, this.accessType, elements);
        }
        ExecutableElement resolvedMethod = resolver.resolveCall(call);
        if (resolvedMethod == null) {
            String message = String.format("The method %s is undefined for the enclosing scope.", call.getName());
            throw new InvalidExpressionException(message);
        }
        if (!ElementUtils.isVisible(this.accessType, resolvedMethod)) {
            throw new InvalidExpressionException(String.format("The method %s is not visible.", ElementUtils.getReadableSignature(resolvedMethod)));
        }
        if (!DSLExpressionResolver.matchExecutable(call, resolvedMethod)) {
            StringBuilder arguments = new StringBuilder();
            String sep = "";
            for (DSLExpression dSLExpression : call.getParameters()) {
                arguments.append(sep).append(ElementUtils.getSimpleName(dSLExpression.getResolvedType()));
                sep = ", ";
            }
            throw new InvalidExpressionException(String.format("The method %s in the type %s is not applicable for the arguments %s.", ElementUtils.getReadableSignature(resolvedMethod), ElementUtils.getSimpleName((TypeElement)resolvedMethod.getEnclosingElement()), arguments.toString()));
        }
        call.setResolvedMethod(resolvedMethod);
    }

    @Override
    public void visitVariable(DSLExpression.Variable variable) {
        DSLExpressionResolver resolver;
        DSLExpression receiver = variable.getReceiver();
        if (receiver == null) {
            resolver = this;
        } else {
            ArrayList<Element> elements = new ArrayList<Element>();
            TypeMirror type = receiver.getResolvedType();
            if (type.getKind() == TypeKind.DECLARED) {
                type = this.context.reloadType(type);
                TypeElement t = (TypeElement)((DeclaredType)type).asElement();
                for (Element element : this.getMembers(t)) {
                    ElementKind kind = element.getKind();
                    if (kind != ElementKind.LOCAL_VARIABLE && kind != ElementKind.PARAMETER && kind != ElementKind.FIELD && kind != ElementKind.ENUM_CONSTANT) continue;
                    elements.add(element);
                }
            } else if (type.getKind() == TypeKind.ARRAY) {
                elements.add(new CodeVariableElement(this.context.getType(Integer.TYPE), "length"));
            }
            resolver = new DSLExpressionResolver(this.context, this.accessType, elements);
        }
        VariableElement var = resolver.resolveVariable(variable);
        if (var == null) {
            throw new InvalidExpressionException(String.format("%s cannot be resolved.", variable.getName()));
        }
        if (!ElementUtils.isVisible(this.accessType, var)) {
            throw new InvalidExpressionException(String.format("%s is not visible.", variable.getName()));
        }
        variable.setResolvedVariable(var);
    }

    private List<? extends Element> getMembers(TypeElement t) {
        return this.context.getEnvironment().getElementUtils().getAllMembers(t);
    }

    @Override
    public void visitBooleanLiteral(DSLExpression.BooleanLiteral binary) {
        binary.setResolvedType(this.context.getType(Boolean.TYPE));
    }

    @Override
    public void visitIntLiteral(DSLExpression.IntLiteral binary) {
        try {
            String literal;
            int base;
            binary.setResolvedType(this.context.getType(Integer.TYPE));
            if (binary.getLiteral().startsWith("0x")) {
                base = 16;
                literal = binary.getLiteral().substring(2);
            } else if (binary.getLiteral().startsWith("0b")) {
                base = 2;
                literal = binary.getLiteral().substring(2);
            } else if (binary.getLiteral().startsWith("0")) {
                base = 8;
                literal = binary.getLiteral();
            } else {
                base = 10;
                literal = binary.getLiteral();
            }
            binary.setResolvedValueInt(Integer.parseInt(literal, base));
        }
        catch (NumberFormatException e) {
            throw new InvalidExpressionException(String.format("Type mismatch: cannot convert from String '%s' to int", binary.getLiteral()));
        }
    }
}

