/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.compiler;

import com.oracle.truffle.dsl.processor.java.compiler.Compiler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.tools.Diagnostic;

public abstract class AbstractCompiler
implements Compiler {
    protected static Object method(Object o, String methodName) throws ReflectiveOperationException {
        Method method = o.getClass().getMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke(o, new Object[0]);
    }

    protected static Object method(Object o, String methodName, Class<?>[] paramTypes, Object ... values) throws ReflectiveOperationException {
        Method method = o.getClass().getMethod(methodName, paramTypes);
        method.setAccessible(true);
        return method.invoke(o, values);
    }

    protected static Object staticMethod(Class<?> clz, String methodName, Class<?>[] paramTypes, Object ... values) throws ReflectiveOperationException {
        Method method = clz.getMethod(methodName, paramTypes);
        method.setAccessible(true);
        return method.invoke(null, values);
    }

    protected static Object field(Object o, String fieldName) throws ReflectiveOperationException {
        Field field;
        block6: {
            Class<?> clazz;
            if (o == null) {
                return null;
            }
            field = null;
            try {
                field = clazz.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                for (clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        field = clazz.getDeclaredField(fieldName);
                        break;
                    }
                    catch (NoSuchFieldException e1) {
                        continue;
                    }
                }
                if (field != null) break block6;
                throw e;
            }
        }
        field.setAccessible(true);
        return field.get(o);
    }

    @Override
    public final void emitDeprecationWarning(ProcessingEnvironment environment, Element element) {
        if (!this.emitDeprecationWarningImpl(environment, element)) {
            ElementKind kind;
            CharSequence ownerQualifiedName = "";
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement != null && ((kind = enclosingElement.getKind()).isClass() || kind.isInterface() || kind == ElementKind.PACKAGE)) {
                ownerQualifiedName = ((QualifiedNameable)enclosingElement).getQualifiedName();
            }
            environment.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("%s in %s has been deprecated", element.getSimpleName(), ownerQualifiedName), element);
        }
    }

    protected abstract boolean emitDeprecationWarningImpl(ProcessingEnvironment var1, Element var2);
}

