/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.compiler;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.AbstractCompiler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class JDTCompiler
extends AbstractCompiler {
    public static boolean isValidElement(Element currentElement) {
        try {
            Class<?> elementClass = currentElement.getClass().getClassLoader().loadClass("org.eclipse.jdt.internal.compiler.apt.model.ElementImpl");
            return elementClass.isAssignableFrom(currentElement.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static List<Element> newElementList(List<? extends Element> src) {
        ArrayList<Element> workaround = new ArrayList<Element>(src);
        return workaround;
    }

    @Override
    public List<? extends Element> getAllMembersInDeclarationOrder(ProcessingEnvironment environment, TypeElement type) {
        return JDTCompiler.sortBySourceOrder(JDTCompiler.newElementList(environment.getElementUtils().getAllMembers(type)));
    }

    @Override
    public List<? extends Element> getEnclosedElementsInDeclarationOrder(TypeElement type) {
        return JDTCompiler.sortBySourceOrder(JDTCompiler.newElementList(type.getEnclosedElements()));
    }

    private static List<? extends Element> sortBySourceOrder(List<Element> elements) {
        HashMap<TypeElement, ArrayList<Element>> groupedByEnclosing = new HashMap<TypeElement, ArrayList<Element>>();
        for (Element element : elements) {
            Element enclosing = element.getEnclosingElement();
            ArrayList<Element> grouped = (ArrayList<Element>)groupedByEnclosing.get(enclosing);
            if (grouped == null) {
                grouped = new ArrayList<Element>();
                groupedByEnclosing.put((TypeElement)enclosing, grouped);
            }
            grouped.add(element);
        }
        for (TypeElement enclosing : groupedByEnclosing.keySet()) {
            Collections.sort((List)groupedByEnclosing.get(enclosing), JDTCompiler.createSourceOrderComparator(enclosing));
        }
        if (groupedByEnclosing.size() == 1) {
            return (List)groupedByEnclosing.get(groupedByEnclosing.keySet().iterator().next());
        }
        ArrayList enclosingTypes = new ArrayList(groupedByEnclosing.keySet());
        Collections.sort(enclosingTypes, new Comparator<TypeElement>(){

            @Override
            public int compare(TypeElement o1, TypeElement o2) {
                if (ElementUtils.isSubtype(o1.asType(), o2.asType())) {
                    return 1;
                }
                return -1;
            }
        });
        ArrayList sourceOrderElements = new ArrayList();
        for (TypeElement typeElement : enclosingTypes) {
            sourceOrderElements.addAll((Collection)groupedByEnclosing.get(typeElement));
        }
        return sourceOrderElements;
    }

    private static Comparator<Element> createSourceOrderComparator(final TypeElement enclosing) {
        Comparator<Element> comparator = new Comparator<Element>(){
            final List<Object> declarationOrder;
            {
                this.declarationOrder = JDTCompiler.lookupDeclarationOrder(enclosing);
            }

            @Override
            public int compare(Element o1, Element o2) {
                try {
                    Element enclosing1Element = o1.getEnclosingElement();
                    Element enclosing2Element = o2.getEnclosingElement();
                    if (!ElementUtils.typeEquals(enclosing1Element.asType(), enclosing2Element.asType())) {
                        throw new AssertionError();
                    }
                    Object o1Binding = AbstractCompiler.field(o1, "_binding");
                    Object o2Binding = AbstractCompiler.field(o2, "_binding");
                    int i1 = this.declarationOrder.indexOf(o1Binding);
                    int i2 = this.declarationOrder.indexOf(o2Binding);
                    if (i1 == -1 || i2 == -1) {
                        return 0;
                    }
                    return i1 - i2;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return comparator;
    }

    private static List<Object> lookupDeclarationOrder(TypeElement type) {
        List<Object> declarationOrder;
        try {
            Object binding = JDTCompiler.field(type, "_binding");
            ClassLoader classLoader = binding.getClass().getClassLoader();
            Class<?> sourceTypeBinding = classLoader.loadClass("org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding");
            Class<?> binaryTypeBinding = classLoader.loadClass("org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding");
            declarationOrder = null;
            if (sourceTypeBinding.isAssignableFrom(binding.getClass())) {
                declarationOrder = JDTCompiler.findSourceTypeOrder(binding);
            } else if (binaryTypeBinding.isAssignableFrom(binding.getClass())) {
                declarationOrder = JDTCompiler.findBinaryTypeOrder(binding);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return declarationOrder;
    }

    private static List<Object> findBinaryTypeOrder(Object binding) throws Exception {
        Object[] sortedTypes;
        Object[] sortedFields;
        Object binaryType = JDTCompiler.lookupBinaryType(binding);
        Object[] sortedMethods = (Object[])JDTCompiler.method(binaryType, "getMethods");
        ArrayList<Object> sortedElements = new ArrayList<Object>();
        if (sortedMethods != null) {
            sortedElements.addAll(Arrays.asList(sortedMethods));
        }
        if ((sortedFields = (Object[])JDTCompiler.method(binaryType, "getFields")) != null) {
            sortedElements.addAll(Arrays.asList(sortedFields));
        }
        if ((sortedTypes = (Object[])JDTCompiler.method(binaryType, "getMemberTypes", new Class[0], new Object[0])) != null) {
            sortedElements.addAll(Arrays.asList(sortedTypes));
        }
        Collections.sort(sortedElements, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                try {
                    int structOffset1 = (Integer)AbstractCompiler.field(o1, "structOffset");
                    int structOffset2 = (Integer)AbstractCompiler.field(o2, "structOffset");
                    return structOffset1 - structOffset2;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ClassLoader classLoader = binding.getClass().getClassLoader();
        Class<?> binaryMethod = classLoader.loadClass("org.eclipse.jdt.internal.compiler.env.IBinaryMethod");
        Class<?> binaryField = classLoader.loadClass("org.eclipse.jdt.internal.compiler.env.IBinaryField");
        Class<?> nestedType = classLoader.loadClass("org.eclipse.jdt.internal.compiler.env.IBinaryNestedType");
        ArrayList<Object> bindings = new ArrayList<Object>();
        block0: for (Object e : sortedElements) {
            char[] selector;
            Class<?> elementClass = e.getClass();
            if (binaryMethod.isAssignableFrom(elementClass)) {
                selector = (char[])JDTCompiler.method(e, "getSelector");
                Object[] foundBindings = (Object[])JDTCompiler.method(binding, "getMethods", new Class[]{char[].class}, new Object[]{selector});
                if (foundBindings == null || foundBindings.length == 0) continue;
                if (foundBindings.length == 1) {
                    bindings.add(foundBindings[0]);
                    continue;
                }
                char[] idescriptor = (char[])JDTCompiler.method(e, "getMethodDescriptor");
                for (Object foundBinding : foundBindings) {
                    char[] descriptor = (char[])JDTCompiler.method(foundBinding, "signature");
                    if ((descriptor != null || idescriptor != null) && !Arrays.equals(descriptor, idescriptor)) continue;
                    bindings.add(foundBinding);
                    continue block0;
                }
                continue;
            }
            if (binaryField.isAssignableFrom(elementClass)) {
                selector = (char[])JDTCompiler.method(e, "getName");
                Object foundField = JDTCompiler.method(binding, "getField", new Class[]{char[].class, Boolean.TYPE}, selector, true);
                if (foundField == null) continue;
                bindings.add(foundField);
                continue;
            }
            if (nestedType.isAssignableFrom(elementClass)) {
                selector = (char[])JDTCompiler.method(e, "getSourceName");
                Object foundType = JDTCompiler.method(binding, "getMemberType", new Class[]{char[].class}, new Object[]{selector});
                if (foundType == null) continue;
                bindings.add(foundType);
                continue;
            }
            throw new AssertionError((Object)("Unexpected encountered type " + elementClass));
        }
        return bindings;
    }

    private static Object lookupBinaryType(Object binding) throws Exception {
        Object lookupEnvironment = JDTCompiler.field(binding, "environment");
        Object compoundClassName = JDTCompiler.field(binding, "compoundName");
        Object nameEnvironment = JDTCompiler.field(lookupEnvironment, "nameEnvironment");
        Object nameEnvironmentAnswer = JDTCompiler.method(nameEnvironment, "findType", new Class[]{char[][].class}, compoundClassName);
        Object binaryType = JDTCompiler.method(nameEnvironmentAnswer, "getBinaryType", new Class[0], new Object[0]);
        return binaryType;
    }

    private static List<Object> findSourceTypeOrder(Object binding) throws Exception {
        Object referenceContext = JDTCompiler.field(JDTCompiler.field(binding, "scope"), "referenceContext");
        TreeMap<Integer, Object> orderedBindings = new TreeMap<Integer, Object>();
        JDTCompiler.collectSourceOrder(orderedBindings, referenceContext, "methods");
        JDTCompiler.collectSourceOrder(orderedBindings, referenceContext, "fields");
        JDTCompiler.collectSourceOrder(orderedBindings, referenceContext, "memberTypes");
        return new ArrayList<Object>(orderedBindings.values());
    }

    private static void collectSourceOrder(TreeMap<Integer, Object> orderedBindings, Object referenceContext, String fieldName) throws Exception {
        Object[] declarations = (Object[])JDTCompiler.field(referenceContext, fieldName);
        if (declarations != null) {
            for (int i = 0; i < declarations.length; ++i) {
                Integer declarationSourceStart = (Integer)JDTCompiler.field(declarations[i], "declarationSourceStart");
                orderedBindings.put(declarationSourceStart, JDTCompiler.field(declarations[i], "binding"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean emitDeprecationWarningImpl(ProcessingEnvironment environment, Element element) {
        boolean bl;
        Object binding = JDTCompiler.field(element, "_binding");
        if (binding == null) {
            return false;
        }
        Object astNode = JDTCompiler.getASTNode(element);
        if (astNode == null) {
            return false;
        }
        Object problemReporter = JDTCompiler.field(JDTCompiler.method(environment, "getCompiler"), "problemReporter");
        Object prev = JDTCompiler.useSource(problemReporter, astNode);
        try {
            bl = JDTCompiler.reportProblem(problemReporter, element.getKind(), binding, astNode);
        }
        catch (Throwable throwable) {
            try {
                JDTCompiler.useSource(problemReporter, prev);
                throw throwable;
            }
            catch (ReflectiveOperationException e) {
                return false;
            }
        }
        JDTCompiler.useSource(problemReporter, prev);
        return bl;
    }

    private static Object getASTNode(Element element) throws ReflectiveOperationException {
        Class<?> baseMessagerImplClass = Class.forName("org.eclipse.jdt.internal.compiler.apt.dispatch.BaseMessagerImpl", false, element.getClass().getClassLoader());
        Object problem = JDTCompiler.staticMethod(baseMessagerImplClass, "createProblem", new Class[]{Diagnostic.Kind.class, CharSequence.class, Element.class, AnnotationMirror.class, AnnotationValue.class}, new Object[]{Diagnostic.Kind.WARNING, "", element, null, null});
        return JDTCompiler.field(problem, "_referenceContext");
    }

    private static Object useSource(Object problemReporter, Object astNode) throws ReflectiveOperationException {
        Field referenceContextField = problemReporter.getClass().getField("referenceContext");
        Object res = referenceContextField.get(problemReporter);
        referenceContextField.set(problemReporter, astNode);
        return res;
    }

    private static boolean reportProblem(Object problemReporter, ElementKind kind, Object binding, Object astNode) throws ReflectiveOperationException {
        ClassLoader cl = binding.getClass().getClassLoader();
        Class<?> astNodeClass = Class.forName("org.eclipse.jdt.internal.compiler.ast.ASTNode", false, cl);
        if (kind.isClass() || kind.isInterface()) {
            Class<?> typeBindingClass = Class.forName("org.eclipse.jdt.internal.compiler.lookup.TypeBinding", false, cl);
            JDTCompiler.method(problemReporter, "deprecatedType", new Class[]{typeBindingClass, astNodeClass}, binding, astNode);
            return true;
        }
        if (kind.isField()) {
            Class<?> fieldBindingClass = Class.forName("org.eclipse.jdt.internal.compiler.lookup.FieldBinding", false, cl);
            JDTCompiler.method(problemReporter, "deprecatedField", new Class[]{fieldBindingClass, astNodeClass}, binding, astNode);
            return true;
        }
        if (kind == ElementKind.METHOD || kind == ElementKind.CONSTRUCTOR) {
            Class<?> methodBindingClass = Class.forName("org.eclipse.jdt.internal.compiler.lookup.MethodBinding", false, cl);
            JDTCompiler.method(problemReporter, "deprecatedMethod", new Class[]{methodBindingClass, astNodeClass}, binding, astNode);
            return true;
        }
        return false;
    }
}

