/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.AnnotationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.generator.DSLExpressionGenerator;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedTypeMirror;
import com.oracle.truffle.dsl.processor.library.ExportMessageData;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryGenerator;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class ExportsGenerator
extends CodeTypeElementFactory<ExportsData> {
    private static final String ACCEPTS = "accepts";
    private static final String ACCEPTS_METHOD_NAME = "accepts_";
    private static final String ENABLED_MESSAGES_NAME = "ENABLED_MESSAGES";
    private final ProcessorContext context = ProcessorContext.getInstance();
    private final Map<String, CodeVariableElement> libraryConstants;
    private static final String INVALID_LIBRARY_USAGE_MESSAGE = "Invalid library usage. Library does not accept given receiver.";

    public ExportsGenerator(Map<String, CodeVariableElement> libraryConstants) {
        this.libraryConstants = libraryConstants;
    }

    @Override
    public List<CodeTypeElement> create(ProcessorContext context1, AnnotationProcessor<?> processor, ExportsData exports) {
        this.libraryConstants.clear();
        String className = exports.getTemplateType().getSimpleName().toString() + "Gen";
        CodeTypeElement genClass = GeneratorUtils.createClass(exports, null, ElementUtils.modifiers(Modifier.FINAL), className, null);
        CodeTreeBuilder statics = genClass.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.STATIC), null, "<cinit>", new CodeVariableElement[0])).createBuilder();
        statics.startStatement();
        statics.startStaticCall(this.types.LibraryExport, "register");
        statics.typeLiteral(exports.getTemplateType().asType());
        genClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(Modifier.PRIVATE), genClass));
        for (ExportsLibrary libraryExports : exports.getExportedLibraries().values()) {
            if (libraryExports.hasErrors()) continue;
            if (libraryExports.needsDefaultExportProvider()) {
                ElementUtils.setVisibility(genClass.getModifiers(), Modifier.PUBLIC);
                CodeTypeElement provider = this.createDefaultExportProvider(libraryExports);
                genClass.add(provider);
                String serviceBinaryName = this.context.getEnvironment().getElementUtils().getBinaryName(ElementUtils.castTypeElement(this.context.getTypes().DefaultExportProvider)).toString();
                String serviceImplName = ElementUtils.getBinaryName(provider);
                processor.registerService(serviceBinaryName, serviceImplName, libraryExports.getTemplateType());
            }
            TypeElement libraryBaseTypeElement = libraryExports.getLibrary().getTemplateType();
            DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
            CodeTypeElement uncachedClass = this.createUncached(libraryExports);
            CodeTypeElement cacheClass = this.createCached(libraryExports);
            CodeTypeElement resolvedExports = this.createResolvedExports(libraryExports, ElementUtils.getSimpleName(libraryBaseType) + "Exports", cacheClass, uncachedClass);
            resolvedExports.add(cacheClass);
            resolvedExports.add(uncachedClass);
            genClass.add(resolvedExports);
            statics.startNew(resolvedExports.asType()).end();
        }
        statics.end();
        statics.end();
        genClass.addAll(this.libraryConstants.values());
        return Arrays.asList(genClass);
    }

    private static void groupMergedLibraries(Collection<SpecializationData> specializations, Map<CacheKey, List<CacheExpression>> mergedLibraries) {
        for (SpecializationData specialization : specializations) {
            if (!specialization.isReachable()) continue;
            for (CacheExpression cache : specialization.getCaches()) {
                if (!cache.isMergedLibrary()) continue;
                mergedLibraries.computeIfAbsent(new CacheKey(cache), b -> new ArrayList()).add(cache);
            }
        }
    }

    private static boolean useSingleton(ExportsLibrary library, boolean cached) {
        return library.isFinalReceiver() && !library.needsRewrites() && !library.needsDynamicDispatch() && !ExportsGenerator.needsReceiver(library, cached);
    }

    CodeTypeElement createResolvedExports(ExportsLibrary library, String className, CodeTypeElement cacheClass, CodeTypeElement uncachedClass) {
        TypeElement libraryBaseTypeElement = library.getLibrary().getTemplateType();
        DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
        TypeMirror exportReceiverType = library.getReceiverType();
        CodeTypeMirror.DeclaredCodeTypeMirror baseType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(this.types.LibraryExport), Arrays.asList(libraryBaseType));
        CodeTypeElement exportsClass = GeneratorUtils.createClass(library, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), className, baseType);
        CodeExecutableElement constructor = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), null, exportsClass.getSimpleName().toString(), new CodeVariableElement[0]);
        CodeTreeBuilder builder = constructor.createBuilder();
        builder.startStatement().startSuperCall().typeLiteral(libraryBaseType).typeLiteral(library.getReceiverType()).string(Boolean.valueOf(library.isBuiltinDefaultExport()).toString()).end().end();
        exportsClass.add(constructor);
        if (library.hasExportDelegation()) {
            CodeVariableElement enabledMessagesVariable = exportsClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.STATIC, Modifier.FINAL), this.types.FinalBitSet, ENABLED_MESSAGES_NAME));
            CodeTreeBuilder init = enabledMessagesVariable.createInitBuilder();
            init.startCall("createMessageBitSet");
            init.staticReference(this.useLibraryConstant(library.getLibrary().getTemplateType().asType()));
            for (String message : library.getExportedMessages().keySet()) {
                if (message.equals(ACCEPTS)) continue;
                init.doubleQuote(message);
            }
            init.end();
        }
        CodeVariableElement uncachedSingleton = null;
        if (ExportsGenerator.useSingleton(library, false)) {
            GeneratedTypeMirror uncachedType = new GeneratedTypeMirror("", uncachedClass.getSimpleName().toString());
            uncachedSingleton = exportsClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), uncachedType, "UNCACHED"));
            builder = uncachedSingleton.createInitBuilder();
            builder.startNew(uncachedType).end();
        }
        CodeExecutableElement createUncached = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport, "createUncached"));
        createUncached.setReturnType(libraryBaseType);
        createUncached.getModifiers().remove((Object)Modifier.ABSTRACT);
        createUncached.renameArguments("receiver");
        builder = createUncached.createBuilder();
        if (!ElementUtils.typeEquals(exportReceiverType, this.context.getType(Object.class))) {
            builder.startAssert().string("receiver instanceof ").type(exportReceiverType).end();
        }
        builder.startStatement();
        builder.type(library.getLibrary().getTemplateType().asType());
        builder.string(" uncached = ");
        if (library.hasExportDelegation()) {
            builder.startCall("createDelegate");
            builder.staticReference(this.useLibraryConstant(library.getLibrary().getTemplateType().asType()));
        }
        if (uncachedSingleton != null) {
            builder.staticReference(uncachedSingleton);
        } else {
            ExecutableElement uncachedClassConstructor;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(uncachedClass.getEnclosedElements());
            builder.startNew(uncachedClass.getSimpleName().toString());
            if (!constructors.isEmpty() && (uncachedClassConstructor = constructors.iterator().next()).getParameters().size() == 1) {
                builder.string("receiver");
            }
            builder.end();
        }
        if (library.hasExportDelegation()) {
            builder.end();
        }
        builder.end();
        builder.startReturn().string("uncached").end();
        exportsClass.add(createUncached);
        CodeVariableElement cacheSingleton = null;
        if (ExportsGenerator.useSingleton(library, true)) {
            GeneratedTypeMirror cachedType = new GeneratedTypeMirror("", cacheClass.getSimpleName().toString());
            cacheSingleton = exportsClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), cachedType, "CACHE"));
            builder = cacheSingleton.createInitBuilder();
            builder.startNew(cachedType).end();
        }
        CodeExecutableElement createCached = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport, "createCached"));
        createCached.setReturnType(libraryBaseType);
        createCached.getModifiers().remove((Object)Modifier.ABSTRACT);
        createCached.renameArguments("receiver");
        builder = createCached.createBuilder();
        if (!ElementUtils.typeEquals(exportReceiverType, this.context.getType(Object.class))) {
            builder.startAssert().string("receiver instanceof ").type(exportReceiverType).end();
        }
        builder.startReturn();
        if (library.hasExportDelegation()) {
            builder.startCall("createDelegate");
            builder.staticReference(this.useLibraryConstant(library.getLibrary().getTemplateType().asType()));
        }
        if (cacheSingleton != null) {
            builder.staticReference(cacheSingleton);
        } else {
            ExecutableElement cacheClassConstructor;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(cacheClass.getEnclosedElements());
            builder.startNew(cacheClass.getSimpleName().toString());
            if (!constructors.isEmpty() && (cacheClassConstructor = constructors.iterator().next()).getParameters().size() == 1) {
                builder.string("receiver");
            }
            builder.end();
        }
        if (library.hasExportDelegation()) {
            builder.end();
        }
        builder.end();
        exportsClass.add(createCached);
        return exportsClass;
    }

    private static CodeTree writeExpression(CacheExpression cache, String receiverName, TypeMirror receiverSourceType, TypeMirror receiverTargetType) {
        DSLExpression expression = cache.getDefaultExpression();
        Set<DSLExpression.Variable> boundVariables = expression.findBoundVariables();
        HashMap<DSLExpression.Variable, CodeTree> parameters = new HashMap<DSLExpression.Variable, CodeTree>();
        for (DSLExpression.Variable variable : boundVariables) {
            boolean needsCast;
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            boolean bl = needsCast = !variable.equals(expression);
            if (needsCast && !ElementUtils.isAssignable(receiverSourceType, receiverTargetType)) {
                builder.startParantheses();
                builder.cast(receiverTargetType);
            }
            builder.string(receiverName);
            if (needsCast && !ElementUtils.isAssignable(receiverSourceType, receiverTargetType)) {
                builder.end();
            }
            parameters.put(variable, builder.build());
        }
        return DSLExpressionGenerator.write(expression, null, parameters);
    }

    CodeTypeElement createDefaultExportProvider(ExportsLibrary libraryExports) {
        String libraryName = libraryExports.getLibrary().getTemplateType().getSimpleName().toString();
        CodeTypeElement providerClass = GeneratorUtils.createClass(libraryExports, null, ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), libraryName + "Provider", null);
        providerClass.getImplements().add(this.context.getTypes().DefaultExportProvider);
        for (ExecutableElement method : ElementFilter.methodsIn(this.context.getTypes().DefaultExportProvider.asElement().getEnclosedElements())) {
            CodeExecutableElement m = null;
            switch (method.getSimpleName().toString()) {
                case "getLibraryClassName": {
                    m = CodeExecutableElement.cloneNoAnnotations(method);
                    m.createBuilder().startReturn().doubleQuote(this.context.getEnvironment().getElementUtils().getBinaryName(libraryExports.getLibrary().getTemplateType()).toString()).end();
                    break;
                }
                case "getDefaultExport": {
                    m = CodeExecutableElement.cloneNoAnnotations(method);
                    m.createBuilder().startReturn().typeLiteral(libraryExports.getTemplateType().asType()).end();
                    break;
                }
                case "getReceiverClass": {
                    m = CodeExecutableElement.cloneNoAnnotations(method);
                    m.createBuilder().startReturn().typeLiteral(libraryExports.getReceiverType()).end();
                    break;
                }
                case "getPriority": {
                    m = CodeExecutableElement.cloneNoAnnotations(method);
                    m.createBuilder().startReturn().string(String.valueOf(libraryExports.getDefaultExportPriority())).end();
                }
            }
            if (m == null) continue;
            m.getModifiers().remove((Object)Modifier.ABSTRACT);
            providerClass.add(m);
        }
        if (providerClass.getEnclosedElements().size() != 4) {
            throw new AssertionError();
        }
        return providerClass;
    }

    CodeTypeElement createCached(ExportsLibrary libraryExports) {
        CodeTreeBuilder builder;
        TypeMirror exportReceiverType = libraryExports.getReceiverType();
        TypeElement libraryBaseTypeElement = libraryExports.getLibrary().getTemplateType();
        DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
        LinkedHashMap<CacheKey, List<CacheExpression>> mergedLibraries = new LinkedHashMap<CacheKey, List<CacheExpression>>();
        for (ExportMessageData message : libraryExports.getExportedMessages().values()) {
            if (message.getSpecializedNode() == null) continue;
            ExportsGenerator.groupMergedLibraries(message.getSpecializedNode().getSpecializations(), mergedLibraries);
        }
        ExportMessageData acceptsMessage = libraryExports.getExportedMessages().get(ACCEPTS);
        Map<CacheKey, List<CacheExpression>> eagerCaches = ExportsGenerator.initializeEagerCaches(libraryExports);
        CodeTypeElement cacheClass = GeneratorUtils.createClass(libraryExports, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Cached", libraryBaseType);
        CodeTree acceptsAssertions = this.createDynamicDispatchAssertions(libraryExports);
        LinkedHashSet<NodeData> cachedSharedNodes = new LinkedHashSet<NodeData>();
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            if (export.getSpecializedNode() == null) continue;
            cachedSharedNodes.add(export.getSpecializedNode());
        }
        CodeExecutableElement constructor = cacheClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), cacheClass));
        if (ExportsGenerator.needsReceiver(libraryExports, true)) {
            String receiverName = "receiver";
            CodeTreeBuilder builder2 = constructor.appendBuilder();
            if (ElementUtils.needsCastTo(this.context.getType(Object.class), libraryExports.getReceiverType())) {
                constructor.addParameter(new CodeVariableElement(this.context.getType(Object.class), "originalReceiver"));
                builder2.declaration(libraryExports.getReceiverType(), "receiver", CodeTreeBuilder.createBuilder().maybeCast(this.context.getType(Object.class), libraryExports.getReceiverType(), "originalReceiver").build());
            } else {
                constructor.addParameter(new CodeVariableElement(this.context.getType(Object.class), "receiver"));
            }
            for (Object key : mergedLibraries.keySet()) {
                CodeTree mergedLibraryIdentifier = ExportsGenerator.writeExpression(((CacheKey)key).cache, "receiver", libraryExports.getReceiverType(), libraryExports.getReceiverType());
                String identifier = ((CacheKey)key).getCache().getMergedLibraryIdentifier();
                builder2.startStatement();
                builder2.string("this.", identifier, " = super.insert(");
                builder2.staticReference(this.useLibraryConstant(((CacheKey)key).libraryType)).startCall(".create").tree(mergedLibraryIdentifier).end();
                builder2.string(")").end();
                CodeVariableElement codeVariableElement = cacheClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), ((CacheKey)key).libraryType, identifier));
                codeVariableElement.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.Node_Child));
            }
            if (acceptsMessage != null && acceptsMessage.getSpecializedNode() != null) {
                SpecializationData firstSpecialization = null;
                for (SpecializationData s : acceptsMessage.getSpecializedNode().getSpecializations()) {
                    if (!s.isSpecialized() || !s.isReachable()) continue;
                    firstSpecialization = s;
                    break;
                }
                FlatNodeGenFactory factory = new FlatNodeGenFactory(this.context, FlatNodeGenFactory.GeneratorMode.EXPORTED_MESSAGE, acceptsMessage.getSpecializedNode(), cachedSharedNodes, libraryExports.getSharedExpressions(), this.libraryConstants);
                ArrayList<CacheExpression> caches = new ArrayList<CacheExpression>();
                for (CacheKey cacheKey : eagerCaches.keySet()) {
                    caches.add(cacheKey.cache);
                }
                if (firstSpecialization == null) {
                    throw new AssertionError();
                }
                builder2.tree(factory.createInitializeCaches(firstSpecialization, caches, constructor, "receiver"));
            }
        }
        if (libraryExports.hasExportDelegation()) {
            cacheClass.getImplements().add(this.types.LibraryExport_DelegateExport);
            CodeExecutableElement getExportMessages = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport_DelegateExport, "getDelegateExportMessages"));
            getExportMessages.getModifiers().remove((Object)Modifier.ABSTRACT);
            builder = getExportMessages.createBuilder();
            builder.startReturn().string(ENABLED_MESSAGES_NAME).end();
            cacheClass.add(getExportMessages);
            CodeExecutableElement readDelegate = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport_DelegateExport, "readDelegateExport"));
            readDelegate.getModifiers().remove((Object)Modifier.ABSTRACT);
            readDelegate.renameArguments("receiver_");
            builder = readDelegate.createBuilder();
            builder.startReturn();
            builder.tree(this.createReceiverCast(libraryExports, readDelegate.getParameters().get(0).asType(), libraryExports.getReceiverType(), CodeTreeBuilder.singleString("receiver_"), true));
            builder.string(".").string(libraryExports.getDelegationVariable().getSimpleName().toString());
            builder.end();
            cacheClass.add(readDelegate);
            CodeExecutableElement acceptsMethod = (CodeExecutableElement)libraryExports.getExportedMessages().get(ACCEPTS).getMessageElement();
            VariableElement delegateLibraryParam = acceptsMethod.getParameters().get(1);
            String mergedLibraryId = null;
            block5: for (Map.Entry entry : mergedLibraries.entrySet()) {
                for (CacheExpression cache : (List)entry.getValue()) {
                    if (!ElementUtils.variableEquals(cache.getParameter().getVariableElement(), delegateLibraryParam)) continue;
                    mergedLibraryId = ((CacheKey)entry.getKey()).getCache().getMergedLibraryIdentifier();
                    break block5;
                }
            }
            if (mergedLibraryId == null) {
                throw new AssertionError((Object)"Could not find merged library for export delegation.");
            }
            CodeExecutableElement codeExecutableElement = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport_DelegateExport, "getDelegateExportLibrary"));
            codeExecutableElement.getModifiers().remove((Object)Modifier.ABSTRACT);
            builder = codeExecutableElement.createBuilder();
            builder.startReturn().string("this.", mergedLibraryId).end();
            cacheClass.add(codeExecutableElement);
        }
        CodeTree defaultAccepts = this.createDefaultAccepts(cacheClass, constructor, libraryExports, exportReceiverType, "receiver", true);
        CodeExecutableElement accepts = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Library, ACCEPTS));
        accepts.getModifiers().remove((Object)Modifier.ABSTRACT);
        accepts.renameArguments("receiver");
        builder = accepts.createBuilder();
        if (acceptsAssertions != null) {
            builder.tree(acceptsAssertions);
        }
        if (mergedLibraries.isEmpty()) {
            builder.startReturn();
            if (acceptsMessage == null || acceptsMessage.isGenerated()) {
                builder.tree(defaultAccepts);
            } else {
                builder.tree(defaultAccepts).string(" && accepts_(receiver)");
            }
            builder.end();
        } else {
            builder.startIf().string("!(").tree(defaultAccepts).string(")").end();
            builder.startBlock();
            builder.returnFalse();
            builder.end();
            for (CacheKey key : mergedLibraries.keySet()) {
                CodeTree mergedLibraryInitializer = ExportsGenerator.writeExpression(key.cache, "receiver", this.context.getType(Object.class), libraryExports.getReceiverType());
                String string = key.getCache().getMergedLibraryIdentifier();
                builder.startElseIf();
                builder.string("!this.", string);
                builder.startCall(".accepts").tree(mergedLibraryInitializer).end();
                builder.end().startBlock();
                builder.returnFalse();
                builder.end();
            }
            builder.startElseBlock();
            if (acceptsMessage != null && !acceptsMessage.isGenerated()) {
                builder.startReturn();
                builder.string("accepts_(receiver)");
                builder.end();
            } else {
                builder.returnTrue();
            }
            builder.end();
        }
        cacheClass.addOptional(this.createCastMethod(libraryExports, exportReceiverType, true));
        cacheClass.add(accepts);
        if (!libraryExports.needsRewrites() && ExportsGenerator.useSingleton(libraryExports, true)) {
            CodeExecutableElement isAdoptable = cacheClass.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "isAdoptable")));
            builder = isAdoptable.createBuilder();
            if (libraryExports.needsDynamicDispatch()) {
                builder.startReturn();
                builder.startCall("dynamicDispatch_", "isAdoptable").end();
                builder.end();
            } else {
                builder.returnFalse();
            }
        }
        if (libraryExports.isAllowTransition()) {
            TypeMirror libraryType = libraryExports.getLibrary().getTemplateType().asType();
            CodeExecutableElement fallback = cacheClass.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), libraryType, "getFallback_", new CodeVariableElement[0]));
            fallback.addParameter(new CodeVariableElement(libraryExports.getLibrary().getSignatureReceiverType(), "receiver"));
            CodeVariableElement fallbackVar = cacheClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), libraryType, "fallback_"));
            fallbackVar.addAnnotationMirror(new CodeAnnotationMirror(this.types.Node_Child));
            builder = fallback.createBuilder();
            builder.declaration(libraryType, "localFallback", "this.fallback_");
            builder.startIf().string("localFallback == null").end().startBlock();
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            builder.startStatement();
            CodeTree codeTree = DSLExpressionGenerator.write(libraryExports.getTransitionLimit(), null, Collections.emptyMap());
            builder.string("this.fallback_ = localFallback = insert(").staticReference(this.useLibraryConstant(libraryType)).startCall(".createDispatched").tree(codeTree).end().string(")");
            builder.end();
            builder.end();
            builder.startReturn().string("localFallback").end();
        }
        HashMap<NodeData, CodeTypeElement> sharedNodes = new HashMap<NodeData, CodeTypeElement>();
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            CodeTree customAcceptsAssertion;
            if (export.isGenerated()) continue;
            LibraryMessage libraryMessage = export.getResolvedMessage();
            TypeMirror typeMirror = export.getExportsLibrary().getReceiverType();
            NodeData cachedSpecializedNode = export.getSpecializedNode();
            CodeExecutableElement cachedExecute = null;
            if (cachedSpecializedNode == null) {
                if (!export.isMethod()) {
                    throw new AssertionError((Object)("Missing method export. Missed validation for " + export.getResolvedMessage().getSimpleName()));
                }
                boolean isAccepts = libraryMessage.getMessageElement().getSimpleName().toString().equals(ACCEPTS);
                TypeMirror modelReceiverType = isAccepts ? this.context.getType(Object.class) : libraryMessage.getLibrary().getSignatureReceiverType();
                ExecutableElement exportMethod = (ExecutableElement)export.getMessageElement();
                CodeTree cachedReceiverAccess = this.createReceiverCast(libraryExports, modelReceiverType, typeMirror, CodeTreeBuilder.singleString("receiver"), true);
                cachedReceiverAccess = CodeTreeBuilder.createBuilder().startParantheses().tree(cachedReceiverAccess).end().build();
                cachedExecute = cacheClass.add(this.createDirectCall(cachedReceiverAccess, libraryMessage, exportMethod));
            } else {
                CodeTypeElement dummyNodeClass = (CodeTypeElement)sharedNodes.get(cachedSpecializedNode);
                boolean shared = true;
                if (dummyNodeClass == null) {
                    FlatNodeGenFactory factory = new FlatNodeGenFactory(this.context, FlatNodeGenFactory.GeneratorMode.EXPORTED_MESSAGE, cachedSpecializedNode, cachedSharedNodes, libraryExports.getSharedExpressions(), this.libraryConstants);
                    dummyNodeClass = GeneratorUtils.createClass(libraryExports, null, ElementUtils.modifiers(new Modifier[0]), "Dummy", this.types.Node);
                    factory.create(dummyNodeClass);
                    sharedNodes.put(cachedSpecializedNode, dummyNodeClass);
                    shared = false;
                }
                for (Object element : dummyNodeClass.getEnclosedElements()) {
                    String simpleName = element.getSimpleName().toString();
                    if (element.getKind() == ElementKind.METHOD) {
                        if (!simpleName.endsWith("AndSpecialize") && simpleName.startsWith("execute") && simpleName.endsWith("_")) {
                            CodeExecutableElement executable = (CodeExecutableElement)element;
                            executable.setVarArgs(libraryMessage.getExecutable().isVarArgs());
                            cachedExecute = CodeExecutableElement.clone(executable);
                            cachedExecute.setSimpleName(CodeNames.of(libraryMessage.getName()));
                            this.injectReceiverType(cachedExecute, libraryExports, typeMirror, true);
                            cacheClass.getEnclosedElements().add(cachedExecute);
                            continue;
                        }
                    } else if (element.getKind() == ElementKind.CONSTRUCTOR) continue;
                    if (shared) continue;
                    cacheClass.getEnclosedElements().add((Element)element);
                }
            }
            if (cachedExecute == null) {
                throw new AssertionError((Object)"execute not found");
            }
            if (libraryMessage.getName().equals(ACCEPTS)) {
                if (export.getExportsLibrary().isFinalReceiver() && (cachedSpecializedNode == null || !cachedSpecializedNode.needsRewrites(this.context)) && eagerCaches.isEmpty()) {
                    cachedExecute.getModifiers().add(Modifier.STATIC);
                }
                cachedExecute.setSimpleName(CodeNames.of(ACCEPTS_METHOD_NAME));
                ElementUtils.setVisibility(cachedExecute.getModifiers(), Modifier.PRIVATE);
                continue;
            }
            if (libraryExports.needsRewrites()) {
                ExportsGenerator.injectCachedAssertions(export.getExportsLibrary().getLibrary(), cachedExecute);
            }
            CodeTree originalBody = cachedExecute.getBodyTree();
            CodeTreeBuilder b = cachedExecute.createBuilder();
            if (libraryExports.isAllowTransition()) {
                Object element;
                b.startAssert();
                String name = cachedExecute.getParameters().get(0).getSimpleName().toString();
                b.tree(this.createDefaultAccepts(null, null, libraryExports, libraryExports.getReceiverType(), name, true));
                b.string(" : ").doubleQuote(INVALID_LIBRARY_USAGE_MESSAGE);
                b.end();
                b.startIf().startCall("this.accepts").string(name).end().end().startBlock();
                b.tree(originalBody);
                b.end();
                b.startElseBlock();
                b.startReturn();
                b.startCall("getFallback_").string(name).end().string(".");
                b.startCall(cachedExecute.getSimpleName().toString());
                element = cachedExecute.getParameters().iterator();
                while (element.hasNext()) {
                    VariableElement param = (VariableElement)element.next();
                    b.string(param.getSimpleName().toString());
                }
                b.end();
                b.end();
                b.end();
                continue;
            }
            if (mergedLibraries.isEmpty()) {
                customAcceptsAssertion = null;
            } else {
                String name = b.findMethod().getParameters().get(0).getSimpleName().toString();
                customAcceptsAssertion = this.createDefaultAccepts(null, null, libraryExports, exportReceiverType, name, true);
            }
            ExportsGenerator.addAcceptsAssertion(b, customAcceptsAssertion);
            b.tree(originalBody);
        }
        return cacheClass;
    }

    private static Map<CacheKey, List<CacheExpression>> initializeEagerCaches(ExportsLibrary libraryExports) {
        ExportMessageData acceptsMessage = libraryExports.getExportedMessages().get(ACCEPTS);
        LinkedHashMap<CacheKey, List<CacheExpression>> eagerCaches = new LinkedHashMap<CacheKey, List<CacheExpression>>();
        if (acceptsMessage != null && acceptsMessage.getSpecializedNode() != null) {
            int specializationCount = 0;
            for (SpecializationData s : acceptsMessage.getSpecializedNode().getSpecializations()) {
                if (!s.isReachable() || !s.isSpecialized()) continue;
                ++specializationCount;
                for (CacheExpression cache : s.getCaches()) {
                    if (!ExportsGenerator.isEagerInitialize(acceptsMessage, cache)) continue;
                    eagerCaches.computeIfAbsent(new CacheKey(cache), b -> new ArrayList()).add(cache);
                }
            }
            if (specializationCount > 1) {
                Iterator iterator = eagerCaches.values().iterator();
                while (iterator.hasNext()) {
                    List caches = (List)iterator.next();
                    if (caches.size() == specializationCount) continue;
                    iterator.remove();
                }
            }
        }
        HashSet<String> eagerSharedGroups = new HashSet<String>();
        for (List caches : eagerCaches.values()) {
            for (CacheExpression cache : caches) {
                if (cache.isMergedLibrary()) continue;
                cache.setEagerInitialize(true);
                if (cache.getSharedGroup() == null) continue;
                eagerSharedGroups.add(cache.getSharedGroup());
            }
        }
        if (eagerSharedGroups.size() > 0) {
            for (ExportMessageData message : libraryExports.getExportedMessages().values()) {
                if (message.getSpecializedNode() == null) continue;
                for (SpecializationData specialization : message.getSpecializedNode().getSpecializations()) {
                    if (!specialization.isReachable()) continue;
                    for (CacheExpression cache : specialization.getCaches()) {
                        if (cache.getSharedGroup() == null || !eagerSharedGroups.contains(cache.getSharedGroup())) continue;
                        cache.setEagerInitialize(true);
                    }
                }
            }
        }
        return eagerCaches;
    }

    private static boolean needsReceiver(ExportsLibrary libraryExports, boolean cached) {
        if (cached) {
            for (ExportMessageData message : libraryExports.getExportedMessages().values()) {
                if (message.getSpecializedNode() == null) continue;
                for (SpecializationData specialization : message.getSpecializedNode().getSpecializations()) {
                    if (!specialization.isReachable()) continue;
                    for (CacheExpression cache : specialization.getCaches()) {
                        if (cache.isMergedLibrary()) {
                            return true;
                        }
                        if (!ExportsGenerator.isEagerInitialize(message, cache)) continue;
                        return true;
                    }
                }
            }
        }
        return libraryExports.needsDynamicDispatch() || !libraryExports.isFinalReceiver();
    }

    private static boolean isEagerInitialize(ExportMessageData message, CacheExpression cache) {
        return message.getResolvedMessage().getName().equals(ACCEPTS);
    }

    private CodeExecutableElement createCastMethod(ExportsLibrary libraryExports, TypeMirror exportReceiverType, boolean cached) {
        if (!libraryExports.getLibrary().isDynamicDispatch()) {
            return null;
        }
        CodeExecutableElement castMethod = CodeExecutableElement.cloneNoAnnotations(ElementUtils.findMethod(this.types.DynamicDispatchLibrary, "cast"));
        castMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
        castMethod.renameArguments("receiver");
        CodeTreeBuilder builder = castMethod.createBuilder();
        if ((!cached || libraryExports.isFinalReceiver()) && ElementUtils.needsCastTo(castMethod.getParameters().get(0).asType(), exportReceiverType)) {
            GeneratorUtils.mergeSupressWarnings(castMethod, "cast");
        }
        if (!cached) {
            GeneratorUtils.addBoundaryOrTransferToInterpreter(castMethod, builder);
        }
        builder.startReturn().tree(this.createReceiverCast(libraryExports, castMethod.getParameters().get(0).asType(), exportReceiverType, CodeTreeBuilder.singleString("receiver"), cached)).end();
        return castMethod;
    }

    private CodeTree createDefaultAccepts(CodeTypeElement libraryGen, CodeExecutableElement constructor, ExportsLibrary libraryExports, TypeMirror exportReceiverType, String receiverName, boolean cached) {
        CodeTreeBuilder constructorBuilder = null;
        CodeTreeBuilder acceptsBuilder = CodeTreeBuilder.createBuilder();
        if (libraryExports.needsDynamicDispatch()) {
            if (libraryGen != null) {
                CodeVariableElement dynamicDispatchLibrary = libraryGen.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), this.types.DynamicDispatchLibrary, "dynamicDispatch_"));
                dynamicDispatchLibrary.addAnnotationMirror(new CodeAnnotationMirror(this.types.Node_Child));
            }
            if (constructor != null) {
                CodeVariableElement dispatchLibraryConstant = this.useDispatchLibraryConstant();
                constructorBuilder = constructor.appendBuilder();
                if (cached) {
                    constructorBuilder.startStatement().string("this.dynamicDispatch_ = insert(").staticReference(dispatchLibraryConstant).string(".create(receiver))").end();
                } else {
                    constructorBuilder.startStatement().string("this.dynamicDispatch_ = ").staticReference(dispatchLibraryConstant).string(".getUncached(receiver)").end();
                }
            }
            acceptsBuilder.string("dynamicDispatch_.accepts(" + receiverName + ") && dynamicDispatch_.dispatch(" + receiverName + ") == ");
            if (libraryExports.isDynamicDispatchTarget()) {
                acceptsBuilder.typeLiteral(libraryExports.getTemplateType().asType());
            } else {
                String name = "dynamicDispatchTarget_";
                if (libraryGen != null) {
                    libraryGen.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), this.context.getType(Class.class), name));
                }
                if (constructor != null) {
                    CodeVariableElement dispatchLibraryConstant = this.useDispatchLibraryConstant();
                    if (cached) {
                        constructorBuilder.startStatement();
                        constructorBuilder.string("this.dynamicDispatchTarget_ = ").staticReference(dispatchLibraryConstant).string(".getUncached(receiver).dispatch(receiver)");
                        constructorBuilder.end();
                    } else {
                        constructorBuilder.statement("this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(" + receiverName + ")");
                    }
                }
                acceptsBuilder.string(name);
            }
        } else if (libraryExports.isFinalReceiver() || !cached && libraryExports.getLibrary().isDynamicDispatch()) {
            if (ElementUtils.isObject(exportReceiverType)) {
                acceptsBuilder.string("true");
            } else {
                acceptsBuilder.string(receiverName, " instanceof ").type(exportReceiverType);
            }
        } else {
            TypeMirror receiverType = libraryExports.getReceiverType();
            CodeTypeMirror.DeclaredCodeTypeMirror receiverClassType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(Class.class), Arrays.asList(new CodeTypeMirror.WildcardTypeMirror(receiverType, null)));
            if (libraryGen != null) {
                libraryGen.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), receiverClassType, "receiverClass_"));
            }
            if (constructor != null) {
                boolean doCast = !((TypeElement)((DeclaredType)receiverType).asElement()).getTypeParameters().isEmpty();
                CodeTreeBuilder builder = constructor.appendBuilder().startStatement().string("this.receiverClass_ = ");
                if (doCast) {
                    builder.cast(receiverClassType);
                    constructor.addAnnotationMirror(LibraryGenerator.createSuppressWarningsUnchecked(this.context));
                }
                if (cached || ElementUtils.isObject(receiverType)) {
                    builder.string(receiverName + ".getClass()").end();
                } else {
                    builder.string("(").cast(receiverType).string(receiverName + ").getClass()").end();
                }
            }
            acceptsBuilder.string(receiverName, ".getClass() == this.receiverClass_");
        }
        CodeTree defaultAccepts = acceptsBuilder.build();
        return defaultAccepts;
    }

    private CodeVariableElement useLibraryConstant(TypeMirror typeConstant) {
        return FlatNodeGenFactory.createLibraryConstant(this.libraryConstants, typeConstant);
    }

    private CodeVariableElement useDispatchLibraryConstant() {
        return this.useLibraryConstant(this.types.DynamicDispatchLibrary);
    }

    private CodeTree createDynamicDispatchAssertions(ExportsLibrary libraryExports) {
        if (libraryExports.needsDynamicDispatch() || libraryExports.getLibrary().isDynamicDispatch()) {
            return null;
        }
        if (!libraryExports.getLibrary().isDynamicDispatchEnabled()) {
            return null;
        }
        CodeVariableElement dispatchLibraryConstant = this.useDispatchLibraryConstant();
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startAssert();
        if (libraryExports.isFinalReceiver()) {
            builder.string("!(receiver instanceof ").type(libraryExports.getReceiverType()).string(")");
        } else {
            builder.string("receiver.getClass() != this.receiverClass_");
        }
        builder.string(" || ");
        builder.staticReference(dispatchLibraryConstant).string(".getUncached().dispatch(receiver) == null : ").doubleQuote("Invalid library export. Exported receiver with dynamic dispatch found but not expected.");
        builder.end();
        return builder.build();
    }

    CodeTypeElement createUncached(ExportsLibrary libraryExports) {
        ExportMessageData accepts;
        CodeTreeBuilder builder;
        TypeMirror exportReceiverType = libraryExports.getReceiverType();
        TypeElement libraryBaseTypeElement = libraryExports.getLibrary().getTemplateType();
        DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
        CodeTypeElement uncachedClass = GeneratorUtils.createClass(libraryExports, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Uncached", libraryBaseType);
        CodeExecutableElement constructor = uncachedClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), uncachedClass));
        if (ExportsGenerator.needsReceiver(libraryExports, false)) {
            constructor.addParameter(new CodeVariableElement(this.context.getType(Object.class), "receiver"));
        }
        if (libraryExports.hasExportDelegation()) {
            uncachedClass.getImplements().add(this.types.LibraryExport_DelegateExport);
            CodeExecutableElement getExportMessages = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport_DelegateExport, "getDelegateExportMessages"));
            getExportMessages.getModifiers().remove((Object)Modifier.ABSTRACT);
            builder = getExportMessages.createBuilder();
            builder.startReturn().string(ENABLED_MESSAGES_NAME).end();
            uncachedClass.add(getExportMessages);
            CodeExecutableElement readDelegate = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport_DelegateExport, "readDelegateExport"));
            readDelegate.getModifiers().remove((Object)Modifier.ABSTRACT);
            readDelegate.renameArguments("receiver_");
            builder = readDelegate.createBuilder();
            builder.startReturn();
            builder.string("(");
            builder.tree(this.createReceiverCast(libraryExports, readDelegate.getParameters().get(0).asType(), libraryExports.getReceiverType(), CodeTreeBuilder.singleString("receiver_"), false));
            builder.string(")");
            builder.string(".").string(libraryExports.getDelegationVariable().getSimpleName().toString());
            builder.end();
            uncachedClass.add(readDelegate);
            CodeExecutableElement getDelegateLibrary = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryExport_DelegateExport, "getDelegateExportLibrary"));
            getDelegateLibrary.renameArguments("delegate_");
            getDelegateLibrary.getModifiers().remove((Object)Modifier.ABSTRACT);
            builder = getDelegateLibrary.createBuilder();
            builder.startReturn();
            builder.staticReference(this.useLibraryConstant(libraryExports.getLibrary().getTemplateType().asType()));
            builder.string(".getUncached(delegate_)");
            builder.end();
            uncachedClass.add(getDelegateLibrary);
        }
        CodeTree acceptsAssertions = this.createDynamicDispatchAssertions(libraryExports);
        CodeTree defaultAccepts = this.createDefaultAccepts(uncachedClass, constructor, libraryExports, exportReceiverType, "receiver", false);
        CodeExecutableElement acceptUncached = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Library, ACCEPTS));
        acceptUncached.getModifiers().remove((Object)Modifier.ABSTRACT);
        acceptUncached.renameArguments("receiver");
        builder = acceptUncached.createBuilder();
        GeneratorUtils.addBoundaryOrTransferToInterpreter(acceptUncached, builder);
        if (acceptsAssertions != null) {
            builder.tree(acceptsAssertions);
        }
        if ((accepts = libraryExports.getExportedMessages().get(ACCEPTS)) == null || accepts.isGenerated()) {
            builder.startReturn().tree(defaultAccepts).end();
        } else {
            builder.startReturn().tree(defaultAccepts).string(" && accepts_(receiver)").end();
        }
        builder.end();
        uncachedClass.add(acceptUncached);
        uncachedClass.addOptional(this.createCastMethod(libraryExports, exportReceiverType, false));
        LinkedHashSet<NodeData> uncachedSharedNodes = new LinkedHashSet<NodeData>();
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            if (export.getSpecializedNode() == null) continue;
            uncachedSharedNodes.add(export.getSpecializedNode());
        }
        CodeExecutableElement isAdoptable = uncachedClass.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "isAdoptable")));
        isAdoptable.createBuilder().returnFalse();
        CodeExecutableElement getCost = uncachedClass.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "getCost")));
        getCost.createBuilder().startReturn().staticReference(ElementUtils.findVariableElement(this.types.NodeCost, "MEGAMORPHIC")).end();
        boolean firstNode = true;
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            CodeExecutableElement uncachedExecute;
            if (export.isGenerated()) continue;
            LibraryMessage message = export.getResolvedMessage();
            TypeMirror uncachedReceiverType = export.getReceiverType();
            TypeMirror messageReceiverType = message.getExecutable().getParameters().get(0).asType();
            CodeTree uncachedReceiverExport = CodeTreeBuilder.createBuilder().maybeCast(messageReceiverType, uncachedReceiverType, "receiver").build();
            NodeData uncachedSpecializedNode = export.getSpecializedNode();
            if (uncachedSpecializedNode == null) {
                if (!export.isMethod()) {
                    throw new AssertionError((Object)("Missing method export. Missed validation for " + export.getResolvedMessage().getSimpleName()));
                }
                ExecutableElement exportMethod = (ExecutableElement)export.getMessageElement();
                CodeExecutableElement directCall = this.createDirectCall(uncachedReceiverExport, message, exportMethod);
                uncachedExecute = uncachedClass.add(directCall);
                if (message.getName().equals(ACCEPTS)) {
                    directCall.getModifiers().add(Modifier.STATIC);
                }
            } else {
                FlatNodeGenFactory factory = new FlatNodeGenFactory(this.context, FlatNodeGenFactory.GeneratorMode.EXPORTED_MESSAGE, uncachedSpecializedNode, uncachedSharedNodes, Collections.emptyMap(), this.libraryConstants);
                CodeExecutableElement generatedUncached = factory.createUncached();
                if (firstNode) {
                    uncachedClass.getEnclosedElements().addAll(factory.createUncachedFields());
                    firstNode = false;
                }
                generatedUncached.getModifiers().remove((Object)Modifier.STATIC);
                ElementUtils.setVisibility(generatedUncached.getModifiers(), Modifier.PUBLIC);
                generatedUncached.setSimpleName(CodeNames.of(message.getName()));
                generatedUncached.setVarArgs(message.getExecutable().isVarArgs());
                this.injectReceiverType(generatedUncached, libraryExports, uncachedReceiverType, false);
                uncachedExecute = uncachedClass.add(generatedUncached);
            }
            if (message.getName().equals(ACCEPTS)) {
                uncachedExecute.getModifiers().add(Modifier.STATIC);
                uncachedExecute.setSimpleName(CodeNames.of(ACCEPTS_METHOD_NAME));
                ElementUtils.setVisibility(uncachedExecute.getModifiers(), Modifier.PRIVATE);
                continue;
            }
            CodeTree originalBody = uncachedExecute.getBodyTree();
            CodeTreeBuilder b = uncachedExecute.createBuilder();
            GeneratorUtils.addBoundaryOrTransferToInterpreter(uncachedExecute, b);
            ExportsGenerator.addAcceptsAssertion(b, null);
            b.tree(originalBody);
        }
        return uncachedClass;
    }

    static void injectCachedAssertions(LibraryData libraryData, CodeExecutableElement cachedExecute) {
        CodeTree body = cachedExecute.getBodyTree();
        CodeTreeBuilder builder = cachedExecute.createBuilder();
        ExecutableElement element = ElementUtils.findExecutableElement((DeclaredType)libraryData.getTemplateType().asType(), "assertAdopted");
        if (element != null) {
            builder.startAssert().string("assertAdopted()").end();
        } else {
            builder.startAssert().string("getRootNode() != null : ").doubleQuote("Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.").end();
        }
        builder.tree(body);
    }

    private CodeExecutableElement createDirectCall(CodeTree receiverAccess, LibraryMessage message, ExecutableElement targetMethod) {
        CodeExecutableElement cachedExecute = CodeExecutableElement.cloneNoAnnotations(message.getExecutable());
        cachedExecute.renameArguments("receiver");
        cachedExecute.getModifiers().remove((Object)Modifier.DEFAULT);
        cachedExecute.getModifiers().remove((Object)Modifier.ABSTRACT);
        CodeTreeBuilder builder = cachedExecute.createBuilder();
        if (targetMethod == null && message.getMessageElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            GeneratorUtils.addBoundaryOrTransferToInterpreter(cachedExecute, builder);
            builder.startThrow().startNew(this.context.getType(AbstractMethodError.class)).end().end();
        } else {
            builder.startReturn();
            if (targetMethod == null) {
                builder.startCall("super", message.getName());
                builder.tree(receiverAccess);
            } else if (targetMethod.getModifiers().contains((Object)Modifier.STATIC)) {
                builder.startStaticCall(targetMethod);
                builder.tree(receiverAccess);
            } else {
                builder.startCall(receiverAccess, targetMethod.getSimpleName().toString());
            }
            List<? extends VariableElement> parameters = message.getExecutable().getParameters();
            for (VariableElement variableElement : parameters.subList(1, parameters.size())) {
                builder.string(variableElement.getSimpleName().toString());
            }
            builder.end();
            builder.end();
        }
        return cachedExecute;
    }

    private void injectReceiverType(CodeExecutableElement executable, ExportsLibrary library, TypeMirror receiverType, boolean cached) {
        boolean isAccepts = executable.getSimpleName().toString().equals(ACCEPTS);
        TypeMirror modelReceiverType = isAccepts ? this.context.getType(Object.class) : library.getLibrary().getSignatureReceiverType();
        if (!ElementUtils.needsCastTo(modelReceiverType, receiverType)) {
            return;
        }
        CodeVariableElement receiverParam = (CodeVariableElement)executable.getParameters().get(0);
        receiverParam.setType(modelReceiverType);
        String originalReceiverParamName = receiverParam.getName();
        String newReceiverParamName = originalReceiverParamName + "_";
        receiverParam.setName(newReceiverParamName);
        CodeTree tree = executable.getBodyTree();
        CodeTreeBuilder executeBody = executable.createBuilder();
        CodeTree cast = this.createReceiverCast(library, modelReceiverType, receiverType, CodeTreeBuilder.singleString(newReceiverParamName), cached);
        executeBody.declaration(receiverType, originalReceiverParamName, cast);
        executeBody.tree(tree);
    }

    private CodeTree createReceiverCast(ExportsLibrary library, TypeMirror sourceType, TypeMirror targetType, CodeTree receiver, boolean cached) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        if (!cached || library.isFinalReceiver()) {
            builder.string("(").maybeCast(sourceType, targetType).tree(receiver).string(")");
        } else if (library.needsDynamicDispatch()) {
            builder.maybeCast(this.context.getType(Object.class), targetType).startCall("dynamicDispatch_.cast").tree(receiver).end();
        } else {
            builder.startStaticCall(this.types.CompilerDirectives, "castExact").tree(receiver).string("receiverClass_").end();
        }
        return builder.build();
    }

    private static void addAcceptsAssertion(CodeTreeBuilder executeBody, CodeTree customAccept) {
        String name = executeBody.findMethod().getParameters().get(0).getSimpleName().toString();
        CodeTree accepts = customAccept != null ? customAccept : executeBody.create().string("this.accepts(", name, ")").build();
        executeBody.startAssert().tree(accepts).string(" : ").doubleQuote(INVALID_LIBRARY_USAGE_MESSAGE).end();
    }

    static class CacheKey {
        private final TypeMirror libraryType;
        private final DSLExpression expressionKey;
        private final CacheExpression cache;

        CacheKey(CacheExpression cache) {
            this.libraryType = cache.getParameter().getType();
            this.expressionKey = cache.getDefaultExpression().reduce(new DSLExpression.DSLExpressionReducer(){

                @Override
                public DSLExpression visitVariable(DSLExpression.Variable binary) {
                    if (binary.getReceiver() == null) {
                        DSLExpression.Variable newVar = new DSLExpression.Variable(null, "receiver");
                        TypeMirror newReceiverType = ProcessorContext.getInstance().getType(Object.class);
                        newVar.setResolvedTargetType(newReceiverType);
                        newVar.setResolvedVariable(new CodeVariableElement(newReceiverType, "receiver"));
                        return newVar;
                    }
                    return binary;
                }

                @Override
                public DSLExpression visitNegate(DSLExpression.Negate negate) {
                    return negate;
                }

                @Override
                public DSLExpression visitCall(DSLExpression.Call binary) {
                    return binary;
                }

                @Override
                public DSLExpression visitBinary(DSLExpression.Binary binary) {
                    return binary;
                }
            });
            this.cache = cache;
        }

        public int hashCode() {
            return Objects.hash(ElementUtils.getTypeId(this.libraryType), this.expressionKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.libraryType, other.libraryType) && Objects.equals(this.expressionKey, other.expressionKey);
            }
            return false;
        }

        public CacheExpression getCache() {
            return this.cache;
        }
    }
}

