/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.CompileErrorException;
import com.oracle.truffle.dsl.processor.Log;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleProcessorOptions;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.expression.DSLExpressionResolver;
import com.oracle.truffle.dsl.processor.expression.InvalidExpressionException;
import com.oracle.truffle.dsl.processor.generator.NodeCodeGenerator;
import com.oracle.truffle.dsl.processor.generator.NodeFactoryFactory;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import com.oracle.truffle.dsl.processor.library.ExportsParser;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryParser;
import com.oracle.truffle.dsl.processor.model.AssumptionExpression;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.GuardExpression;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.NodeFieldData;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.model.SpecializationThrowsData;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.CreateCastParser;
import com.oracle.truffle.dsl.processor.parser.FallbackParser;
import com.oracle.truffle.dsl.processor.parser.SpecializationMethodParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public final class NodeParser
extends AbstractParser<NodeData> {
    public final List<DeclaredType> annotations;
    private boolean nodeOnly;
    private final ParseMode mode;
    private final TypeMirror exportLibraryType;
    private final TypeElement exportDeclarationType;
    private final boolean substituteThisToParent;
    private final List<TypeMirror> cachedAnnotations;
    private final Map<ImportsKey, List<Element>> importCache;

    private NodeParser(ParseMode mode, TypeMirror exportLibraryType, TypeElement exportDeclarationType, boolean substituteThisToParent) {
        this.annotations = Arrays.asList(this.types.Fallback, this.types.TypeSystemReference, this.types.Specialization, this.types.NodeChild, this.types.Executed, this.types.NodeChildren, this.types.ReportPolymorphism);
        this.importCache = ProcessorContext.getInstance().getCacheMap(ImportsKey.class);
        this.mode = mode;
        this.exportLibraryType = exportLibraryType;
        this.exportDeclarationType = exportDeclarationType;
        this.cachedAnnotations = NodeParser.getCachedAnnotations();
        this.substituteThisToParent = substituteThisToParent;
    }

    public static List<TypeMirror> getCachedAnnotations() {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        return Arrays.asList(types.Cached, types.CachedLibrary, types.CachedContext, types.CachedLanguage, types.Bind);
    }

    public static NodeParser createExportParser(TypeMirror exportLibraryType, TypeElement exportDeclarationType, boolean substituteThisToParent) {
        NodeParser parser = new NodeParser(ParseMode.EXPORTED_MESSAGE, exportLibraryType, exportDeclarationType, substituteThisToParent);
        parser.setGenerateSlowPathOnly(false);
        return parser;
    }

    public static NodeParser createDefaultParser() {
        return new NodeParser(ParseMode.DEFAULT, null, null, false);
    }

    @Override
    protected NodeData parse(Element element, List<AnnotationMirror> mirror) {
        NodeData node = this.parseRootType((TypeElement)element);
        if (Log.isDebug() && node != null) {
            String dump = node.dump();
            this.log.message(Diagnostic.Kind.ERROR, null, null, null, dump, new Object[0]);
        }
        return node;
    }

    @Override
    protected NodeData filterErrorElements(NodeData model) {
        Iterator<NodeData> iterator = model.getEnclosingNodes().iterator();
        while (iterator.hasNext()) {
            NodeData node = this.filterErrorElements(iterator.next());
            if (node != null) continue;
            iterator.remove();
        }
        if (model.hasErrors()) {
            return null;
        }
        return model;
    }

    @Override
    public boolean isDelegateToRootDeclaredType() {
        return true;
    }

    @Override
    public DeclaredType getAnnotationType() {
        return null;
    }

    @Override
    public List<DeclaredType> getTypeDelegatedAnnotationTypes() {
        return this.annotations;
    }

    private NodeData parseRootType(TypeElement rootType) {
        NodeData node;
        ArrayList<NodeData> enclosedNodes = new ArrayList<NodeData>();
        for (TypeElement enclosedType : ElementFilter.typesIn(rootType.getEnclosedElements())) {
            NodeData enclosedChild = this.parseRootType(enclosedType);
            if (enclosedChild == null) continue;
            enclosedNodes.add(enclosedChild);
        }
        try {
            node = this.parseNode(rootType);
        }
        catch (CompileErrorException e) {
            throw e;
        }
        catch (Throwable e) {
            RuntimeException e2 = new RuntimeException(String.format("Parsing of Node %s failed.", ElementUtils.getQualifiedName(rootType)));
            e.addSuppressed(e2);
            throw e;
        }
        if (node == null && !enclosedNodes.isEmpty()) {
            node = new NodeData(this.context, rootType);
        }
        if (node != null) {
            for (NodeData enclosedNode : enclosedNodes) {
                node.addEnclosedNode(enclosedNode);
            }
        }
        return node;
    }

    private NodeData parseNode(TypeElement originalTemplateType) {
        Boolean generateProperty;
        TypeElement templateType = originalTemplateType instanceof CodeTypeElement ? originalTemplateType : ElementUtils.fromTypeMirror(this.context.reloadTypeElement(originalTemplateType));
        if (!(originalTemplateType instanceof CodeTypeElement) && ElementUtils.findAnnotationMirror((Element)originalTemplateType, (TypeMirror)this.types.GeneratedBy) != null) {
            return null;
        }
        if (!ElementUtils.isAssignable(templateType.asType(), this.types.Node)) {
            return null;
        }
        if (this.mode == ParseMode.DEFAULT && !ElementUtils.getRepeatedAnnotation(templateType.getAnnotationMirrors(), this.types.ExportMessage).isEmpty()) {
            return null;
        }
        List<TypeElement> lookupTypes = NodeParser.collectSuperClasses(new ArrayList<TypeElement>(), templateType);
        NodeData node = this.parseNodeData(templateType, lookupTypes);
        List<Element> members = this.loadMembers(templateType);
        if (!this.containsSpecializations(members)) {
            return null;
        }
        if (this.nodeOnly) {
            return node;
        }
        if (node.hasErrors()) {
            return node;
        }
        AnnotationMirror introspectable = NodeParser.findFirstAnnotation(lookupTypes, this.types.Introspectable);
        if (introspectable != null) {
            node.setGenerateIntrospection(true);
        }
        if ((generateProperty = TruffleProcessorOptions.generateSpecializationStatistics(ProcessorContext.getInstance().getEnvironment())) != null) {
            node.setGenerateStatistics(generateProperty);
        }
        if (NodeParser.findFirstAnnotation(lookupTypes, this.types.SpecializationStatistics_AlwaysEnabled) != null) {
            node.setGenerateStatistics(true);
        }
        AnnotationMirror reportPolymorphism = NodeParser.findFirstAnnotation(lookupTypes, this.types.ReportPolymorphism);
        AnnotationMirror excludePolymorphism = NodeParser.findFirstAnnotation(lookupTypes, this.types.ReportPolymorphism_Exclude);
        if (reportPolymorphism != null && excludePolymorphism == null) {
            node.setReportPolymorphism(true);
        }
        node.getFields().addAll(this.parseFields(lookupTypes, members));
        node.getChildren().addAll(this.parseChildren(node, lookupTypes, members));
        node.getChildExecutions().addAll(this.parseExecutions(node, node.getFields(), node.getChildren(), members));
        node.getExecutableTypes().addAll(this.parseExecutableTypeData(node, members, node.getSignatureSize(), this.context.getFrameTypes(), false));
        this.initializeExecutableTypes(node);
        this.initializeImportGuards(node, lookupTypes, members);
        this.initializeChildren(node);
        if (node.hasErrors()) {
            return node;
        }
        node.getSpecializations().addAll(new SpecializationMethodParser(this.context, node, this.mode == ParseMode.EXPORTED_MESSAGE).parse(members));
        node.getSpecializations().addAll(new FallbackParser(this.context, node).parse(members));
        node.getCasts().addAll(new CreateCastParser(this.context, node).parse(members));
        if (node.hasErrors()) {
            return node;
        }
        this.initializeSpecializations(members, node);
        NodeParser.initializeExecutableTypeHierarchy(node);
        this.initializeReceiverBound(node);
        if (node.hasErrors()) {
            return node;
        }
        this.initializeUncachable(node);
        if (this.mode == ParseMode.DEFAULT) {
            boolean emitWarnings = TruffleProcessorOptions.cacheSharingWarningsEnabled(this.processingEnv) && !TruffleProcessorOptions.generateSlowPathOnly(this.processingEnv);
            node.setSharedCaches(NodeParser.computeSharing(node.getTemplateType(), Arrays.asList(node), emitWarnings));
        }
        NodeParser.verifySpecializationSameLength(node);
        this.verifyVisibilities(node);
        NodeParser.verifyMissingAbstractMethods(node, members);
        NodeParser.verifyConstructors(node);
        NodeParser.verifySpecializationThrows(node);
        NodeParser.verifyFrame(node);
        if (this.isGenerateSlowPathOnly(node)) {
            NodeParser.removeFastPathSpecializations(node);
        }
        return node;
    }

    public static Map<CacheExpression, String> computeSharing(Element templateType, Collection<NodeData> nodes, boolean emitSharingWarnings) {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        Map<SharableCache, Collection<CacheExpression>> groups = NodeParser.computeSharableCaches(nodes);
        HashMap<String, List> declaredGroups = new HashMap<String, List>();
        for (NodeData node : nodes) {
            for (SpecializationData specialization : node.getSpecializations()) {
                for (CacheExpression cache : specialization.getCaches()) {
                    String group;
                    if (cache.isAlwaysInitialized() || (group = cache.getSharedGroup()) == null) continue;
                    declaredGroups.computeIfAbsent(group, v -> new ArrayList()).add(new SharableCache(specialization, cache));
                }
            }
        }
        LinkedHashMap<CacheExpression, String> sharedExpressions = new LinkedHashMap<CacheExpression, String>();
        for (NodeData node : nodes) {
            for (SpecializationData specialization : node.getSpecializations()) {
                for (CacheExpression cache : specialization.getCaches()) {
                    Object reason;
                    Element declaringElement;
                    if (cache.isAlwaysInitialized()) continue;
                    if (node.getTemplateType() instanceof GeneratedElement) {
                        declaringElement = node.getTemplateType().getEnclosingElement();
                        if (!declaringElement.getKind().isClass() && !declaringElement.getKind().isInterface()) {
                            throw new AssertionError((Object)("Unexpected declared element for generated element: " + declaringElement.toString()));
                        }
                    } else {
                        declaringElement = node.getTemplateType();
                    }
                    String group = cache.getSharedGroup();
                    SharableCache sharable = new SharableCache(specialization, cache);
                    Collection<CacheExpression> expressions = groups.get(sharable);
                    List declaredSharing = (List)declaredGroups.get(group);
                    if (group != null) {
                        if (declaredSharing.size() <= 1 && !ElementUtils.elementEquals(templateType, declaringElement)) continue;
                        if (declaredSharing.size() <= 1 && (expressions == null || expressions.size() <= 1)) {
                            cache.addError(cache.getSharedGroupMirror(), cache.getSharedGroupValue(), "Could not find any other cached parameter that this parameter could be shared. Cached parameters are only sharable if they declare the same type and initializer expressions and if the specialization only has a single instance. Remove the @%s annotation or make the parameter sharable to resolve this.", types.Cached_Shared.asElement().getSimpleName().toString());
                            continue;
                        }
                        if (declaredSharing.size() <= 1) {
                            String error = String.format("No other cached parameters are specified as shared with the group '%s'.", group);
                            LinkedHashSet similarGroups = new LinkedHashSet(declaredGroups.keySet());
                            similarGroups.remove(group);
                            List<String> fuzzyMatches = ExportsParser.fuzzyMatch(similarGroups, group, 0.7f);
                            if (!fuzzyMatches.isEmpty()) {
                                StringBuilder appendix = new StringBuilder(" Did you mean ");
                                String sep = "";
                                for (String string : fuzzyMatches) {
                                    appendix.append(sep);
                                    appendix.append('\'').append(string).append('\'');
                                    sep = ", ";
                                }
                                error = error + appendix.toString() + "?";
                            }
                            cache.addError(cache.getSharedGroupMirror(), cache.getSharedGroupValue(), error, new Object[0]);
                            continue;
                        }
                        StringBuilder b = new StringBuilder();
                        for (SharableCache otherCache : declaredSharing) {
                            if (cache == otherCache.expression || (reason = sharable.equalsWithReason(otherCache)) == null) continue;
                            String signature = NodeParser.formatCacheExpression(otherCache.expression);
                            b.append(String.format("  - %s : %s%n", signature, reason));
                        }
                        if (b.length() != 0) {
                            cache.addError(cache.getSharedGroupMirror(), cache.getSharedGroupValue(), "Could not share some of the cached parameters in group '%s': %n%sRemove the @%s annotation or resolve the described issues to allow sharing.", group, b.toString(), types.Cached_Shared.asElement().getSimpleName().toString());
                            continue;
                        }
                        sharedExpressions.put(sharable.expression, group);
                        continue;
                    }
                    if (expressions == null || expressions.size() <= 1 || !emitSharingWarnings) continue;
                    ArrayList<CacheExpression> declaredInExpression = new ArrayList<CacheExpression>();
                    for (CacheExpression expression : expressions) {
                        if (!ElementUtils.isDeclaredIn(expression.getParameter().getVariableElement(), declaringElement)) continue;
                        declaredInExpression.add(expression);
                    }
                    if (declaredInExpression.size() <= 1 || ElementUtils.findAnnotationMirror((Element)cache.getParameter().getVariableElement(), (TypeMirror)types.Cached_Exclusive) != null) continue;
                    StringBuilder sharedCaches = new StringBuilder();
                    LinkedHashSet<String> recommendedGroups = new LinkedHashSet<String>();
                    reason = declaredInExpression.iterator();
                    while (reason.hasNext()) {
                        CacheExpression cacheExpression = (CacheExpression)reason.next();
                        if (cacheExpression == cache) continue;
                        String signature = NodeParser.formatCacheExpression(cacheExpression);
                        sharedCaches.append(String.format("  - %s%n", signature));
                        String otherGroup = cacheExpression.getSharedGroup();
                        if (otherGroup == null) continue;
                        recommendedGroups.add(otherGroup);
                    }
                    String recommendedGroup = recommendedGroups.size() == 1 ? (String)recommendedGroups.iterator().next() : "group";
                    cache.addWarning("The cached parameter may be shared with: %n%s Annotate the parameter with @%s(\"%s\") or @%s to allow or deny sharing of the parameter.", sharedCaches, types.Cached_Shared.asElement().getSimpleName().toString(), recommendedGroup, types.Cached_Exclusive.asElement().getSimpleName().toString());
                }
            }
        }
        return sharedExpressions;
    }

    private static String formatCacheExpression(CacheExpression cacheExpression) {
        VariableElement cacheParameter = cacheExpression.getParameter().getVariableElement();
        ExecutableElement method = (ExecutableElement)cacheParameter.getEnclosingElement();
        StringBuilder builder = new StringBuilder();
        builder.append(method.getSimpleName().toString());
        builder.append("(");
        int index = method.getParameters().indexOf(cacheParameter);
        if (index != 0) {
            builder.append("..., ");
        }
        String annotationName = cacheExpression.getMessageAnnotation().getAnnotationType().asElement().getSimpleName().toString();
        builder.append(String.format("@%s(...) ", annotationName));
        builder.append(ElementUtils.getSimpleName(cacheParameter.asType()));
        builder.append(" ");
        builder.append(cacheParameter.getSimpleName().toString());
        if (index != method.getParameters().size() - 1) {
            builder.append(",...");
        }
        builder.append(")");
        return builder.toString();
    }

    private void initializeReceiverBound(NodeData node) {
        boolean requireNodeUnbound = this.mode == ParseMode.EXPORTED_MESSAGE;
        boolean nodeBound = false;
        for (SpecializationData specialization : node.getSpecializations()) {
            if (!specialization.isReachable() || specialization.getMethod() == null) continue;
            ExecutableElement specializationMethod = specialization.getMethod();
            if (!specializationMethod.getModifiers().contains((Object)Modifier.STATIC)) {
                nodeBound = true;
                if (!requireNodeUnbound) break;
                specialization.addError("@%s annotated nodes must declare static @%s methods. Add a static modifier to the method to resolve this.", this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.Specialization.asElement().getSimpleName().toString());
                break;
            }
            for (GuardExpression guard : specialization.getGuards()) {
                if (!guard.getExpression().isNodeReceiverBound()) continue;
                nodeBound = true;
                if (!requireNodeUnbound) break;
                guard.addError("@%s annotated nodes must only refer to static guard methods or fields. Add a static modifier to the bound guard method or field to resolve this.", this.types.ExportMessage.asElement().getSimpleName().toString());
                break;
            }
            for (CacheExpression cache : specialization.getCaches()) {
                if (cache.getDefaultExpression() == null || cache.isMergedLibrary() || !cache.getDefaultExpression().isNodeReceiverBound()) continue;
                nodeBound = true;
                if (!requireNodeUnbound) break;
                cache.addError("@%s annotated nodes must only refer to static cache initializer methods or fields. Add a static modifier to the bound cache initializer method or field or use the keyword 'this' to refer to the receiver type explicitely.", this.types.ExportMessage.asElement().getSimpleName().toString());
                break;
            }
            if (specialization.getLimitExpression() == null || !specialization.getLimitExpression().isNodeReceiverBound()) continue;
            nodeBound = true;
            if (!requireNodeUnbound) break;
            specialization.addError("@%s annotated nodes must only refer to static limit initializer methods or fields. Add a static modifier to the bound cache initializer method or field or use the keyword 'this' to refer to the receiver type explicitely.", this.types.ExportMessage.asElement().getSimpleName().toString());
            break;
        }
        node.setNodeBound(nodeBound);
    }

    private void initializeUncachable(NodeData node) {
        AnnotationMirror generateUncached = ElementUtils.findAnnotationMirror(node.getTemplateType().getAnnotationMirrors(), (TypeMirror)this.types.GenerateUncached);
        boolean requireUncachable = node.isGenerateUncached();
        boolean uncachable = true;
        TypeElement type = node.getTemplateType();
        while (type != null && !ElementUtils.typeEquals(type.asType(), this.types.Node)) {
            for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
                if (field.getModifiers().contains((Object)Modifier.STATIC) || ElementUtils.typeEquals(field.getEnclosingElement().asType(), this.types.Node)) continue;
                uncachable = false;
                if (!requireUncachable) break;
                node.addError(generateUncached, null, "Failed to generate code for @%s: The node must not declare any instance variables. Found instance variable %s.%s. Remove instance variable to resolve this.", this.types.GenerateUncached.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(field.getEnclosingElement().asType()), field.getSimpleName().toString());
                break;
            }
            type = ElementUtils.getSuperType(type);
        }
        for (SpecializationData specialization : node.computeUncachedSpecializations(node.getSpecializations())) {
            if (!specialization.isReachable()) continue;
            for (CacheExpression cache : specialization.getCaches()) {
                if (cache.getUncachedExpression() != null) continue;
                uncachable = false;
                if (!requireUncachable) break;
                cache.addError("Failed to generate code for @%s: The specialization uses @%s without valid uncached expression. %s. To resolve this specify the uncached or allowUncached attribute in @%s.", this.types.GenerateUncached.asElement().getSimpleName().toString(), this.types.Cached.asElement().getSimpleName().toString(), cache.getUncachedExpresionError() != null ? cache.getUncachedExpresionError().getText() : "", this.types.Cached.asElement().getSimpleName().toString());
                break;
            }
            for (GuardExpression guard : specialization.getGuards()) {
                if (!guard.getExpression().isNodeReceiverBound()) continue;
                uncachable = false;
                if (!requireUncachable) break;
                guard.addError("Failed to generate code for @%s: One of the guards bind non-static methods or fields . Add a static modifier to the bound guard method or field to resolve this.", this.types.GenerateUncached.asElement().getSimpleName().toString());
                break;
            }
            if (specialization.getExceptions().isEmpty()) continue;
            uncachable = false;
            if (!requireUncachable) continue;
            specialization.addError(ElementUtils.getAnnotationValue(specialization.getMarkerAnnotation(), "rewriteOn"), "Failed to generate code for @%s: The specialization rewrites on exceptions and there is no specialization that replaces it. Add a replaces=\"%s\" class to specialization below to resolve this problem.", this.types.GenerateUncached.asElement().getSimpleName().toString(), specialization.getMethodName());
        }
        ArrayList<ExecutableTypeData> validExecutableType = new ArrayList<ExecutableTypeData>();
        for (ExecutableTypeData executableType : node.getExecutableTypes()) {
            if (executableType.getMethod() == null || executableType.getEvaluatedCount() < node.getExecutionCount()) continue;
            validExecutableType.add(executableType);
            break;
        }
        if (validExecutableType.isEmpty()) {
            uncachable = false;
            if (requireUncachable) {
                node.addError(generateUncached, null, "Failed to generate code for @%s: The node does not declare any execute method with %s evaluated argument(s). The generated uncached node does not declare an execute method that can be generated by the DSL. Declare a non-final method that starts with 'execute' and takes %s argument(s) or variable arguments to resolve this.", this.types.GenerateUncached.asElement().getSimpleName().toString(), node.getExecutionCount(), node.getExecutionCount());
            }
        }
        node.setUncachable(uncachable);
    }

    private static void initializeFallbackReachability(NodeData node) {
        SpecializationData specialization;
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        List<SpecializationData> specializations = node.getSpecializations();
        SpecializationData fallback = null;
        for (int i = specializations.size() - 1; i >= 0; --i) {
            specialization = specializations.get(i);
            if (!specialization.isFallback() || specialization.getMethod() == null) continue;
            fallback = specialization;
            break;
        }
        if (fallback == null) {
            return;
        }
        for (int index = 0; index < specializations.size(); ++index) {
            SpecializationData search;
            SpecializationData lastReachable = specialization = specializations.get(index);
            for (int searchIndex = index + 1; searchIndex < specializations.size() && (search = specializations.get(searchIndex)) != fallback; ++searchIndex) {
                assert (lastReachable != search);
                if (!lastReachable.isReachableAfter(search)) {
                    lastReachable = search;
                    continue;
                }
                if (!search.getReplaces().contains(specialization)) continue;
                lastReachable = search;
            }
            specialization.setReachesFallback(lastReachable == specialization);
            ArrayList<SpecializationData> failedSpecializations = null;
            if (specialization.isReachesFallback() && !specialization.getCaches().isEmpty() && !specialization.getGuards().isEmpty()) {
                boolean failed = false;
                if (specialization.getMaximumNumberOfInstances() > 1) {
                    for (GuardExpression guard : specialization.getGuards()) {
                        if (!specialization.isGuardBoundWithCache(guard)) continue;
                        failed = true;
                        break;
                    }
                }
                for (CacheExpression cache : specialization.getCaches()) {
                    if (!cache.isGuardForNull()) continue;
                    failed = true;
                    break;
                }
                if (failed) {
                    if (failedSpecializations == null) {
                        failedSpecializations = new ArrayList<SpecializationData>();
                    }
                    failedSpecializations.add(specialization);
                }
            }
            if (failedSpecializations == null) continue;
            List specializationIds = failedSpecializations.stream().map(e -> e.getId()).collect(Collectors.toList());
            fallback.addError("Some guards for the following specializations could not be negated for the @%s specialization: %s. Guards cannot be negated for the @%s when they bind @%s parameters and the specialization may consist of multiple instances or if any of the @%s parameters is configured as weak. To fix this limit the number of instances to '1' or introduce a more generic specialization declared between this specialization and the fallback. Alternatively the use of @%s can be avoided by declaring a @%s with manually specified negated guards.", ElementUtils.getSimpleName(types.Fallback), specializationIds, ElementUtils.getSimpleName(types.Fallback), ElementUtils.getSimpleName(types.Cached), ElementUtils.getSimpleName(types.Cached), ElementUtils.getSimpleName(types.Fallback), ElementUtils.getSimpleName(types.Specialization));
        }
    }

    private static void initializeExecutableTypeHierarchy(NodeData node) {
        SpecializationData polymorphic = node.getPolymorphicSpecialization();
        if (polymorphic != null) {
            boolean polymorphicSignatureFound = false;
            List<TypeMirror> dynamicTypes = polymorphic.getDynamicTypes();
            TypeMirror frame = null;
            if (polymorphic.getFrame() != null) {
                frame = dynamicTypes.remove(0);
            }
            ExecutableTypeData polymorphicType = new ExecutableTypeData(node, polymorphic.getReturnType().getType(), "execute", frame, dynamicTypes);
            String genericName = ExecutableTypeData.createName(polymorphicType) + "_";
            polymorphicType.setUniqueName(genericName);
            for (ExecutableTypeData type : node.getExecutableTypes()) {
                if (!polymorphicType.sameSignature(type)) continue;
                polymorphicSignatureFound = true;
                break;
            }
            if (!polymorphicSignatureFound) {
                node.getExecutableTypes().add(polymorphicType);
            }
        }
        List<ExecutableTypeData> rootTypes = NodeParser.buildExecutableHierarchy(node);
        ArrayList<ExecutableTypeData> additionalAbstractRootTypes = new ArrayList<ExecutableTypeData>();
        for (int i = 1; i < rootTypes.size(); ++i) {
            ExecutableTypeData rootType = rootTypes.get(i);
            if (rootType.isAbstract()) {
                additionalAbstractRootTypes.add(rootType);
                continue;
            }
            node.getExecutableTypes().remove(rootType);
        }
        if (!additionalAbstractRootTypes.isEmpty()) {
            node.addError("Incompatible abstract execute methods found %s.", additionalAbstractRootTypes);
        }
        NodeParser.namesUnique(node.getExecutableTypes());
    }

    private static List<ExecutableTypeData> buildExecutableHierarchy(NodeData node) {
        List<ExecutableTypeData> executes = node.getExecutableTypes();
        if (executes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExecutableTypeData> hierarchyExecutes = new ArrayList<ExecutableTypeData>(executes);
        Collections.sort(hierarchyExecutes);
        ExecutableTypeData parent = (ExecutableTypeData)hierarchyExecutes.get(0);
        ListIterator<ExecutableTypeData> executesIterator = hierarchyExecutes.listIterator(1);
        NodeParser.buildExecutableHierarchy(node, parent, executesIterator);
        return hierarchyExecutes;
    }

    private static void buildExecutableHierarchy(NodeData node, ExecutableTypeData parent, ListIterator<ExecutableTypeData> executesIterator) {
        while (executesIterator.hasNext()) {
            ExecutableTypeData other = executesIterator.next();
            if (!other.canDelegateTo(parent)) continue;
            parent.addDelegatedFrom(other);
            executesIterator.remove();
        }
        for (int i = 1; i < parent.getDelegatedFrom().size(); ++i) {
            NodeParser.buildExecutableHierarchy(node, parent.getDelegatedFrom().get(i - 1), parent.getDelegatedFrom().listIterator(i));
        }
    }

    private List<Element> loadMembers(TypeElement templateType) {
        List<Element> elements = NodeParser.newElementList(CompilerFactory.getCompiler(templateType).getAllMembersInDeclarationOrder(this.context.getEnvironment(), templateType));
        Iterator<Element> elementIterator = elements.iterator();
        while (elementIterator.hasNext()) {
            Element element = elementIterator.next();
            if (ElementUtils.typeEquals(element.getEnclosingElement().asType(), this.types.Node)) {
                elementIterator.remove();
            }
            if (!ElementUtils.typeEquals(element.getEnclosingElement().asType(), this.context.getType(Object.class))) continue;
            elementIterator.remove();
        }
        return elements;
    }

    private boolean containsSpecializations(List<Element> elements) {
        boolean foundSpecialization = false;
        for (ExecutableElement method : ElementFilter.methodsIn(elements)) {
            if (ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)this.types.Specialization) == null) continue;
            foundSpecialization = true;
            break;
        }
        return foundSpecialization;
    }

    private Element getVisibiltySource(NodeData nodeData) {
        if (this.mode == ParseMode.DEFAULT) {
            return nodeData.getTemplateType();
        }
        return this.exportDeclarationType;
    }

    private void initializeImportGuards(NodeData node, List<TypeElement> lookupTypes, List<Element> elements) {
        for (TypeElement lookupType : lookupTypes) {
            AnnotationMirror importAnnotation = ElementUtils.findAnnotationMirror((Element)lookupType, (TypeMirror)this.types.ImportStatic);
            if (importAnnotation == null) continue;
            AnnotationValue importClassesValue = ElementUtils.getAnnotationValue(importAnnotation, "value");
            List<TypeMirror> importClasses = ElementUtils.getAnnotationValueList(TypeMirror.class, importAnnotation, "value");
            if (importClasses.isEmpty()) {
                node.addError(importAnnotation, importClassesValue, "At least one import class must be specified.", new Object[0]);
                continue;
            }
            for (TypeMirror importClass : importClasses) {
                if (importClass.getKind() != TypeKind.DECLARED) {
                    node.addError(importAnnotation, importClassesValue, "The specified static import class '%s' is not a declared type.", ElementUtils.getQualifiedName(importClass));
                    continue;
                }
                TypeElement importClassElement = ElementUtils.fromTypeMirror(this.context.reloadType(importClass));
                if (!ElementUtils.isVisible(this.getVisibiltySource(node), importClassElement)) {
                    node.addError(importAnnotation, importClassesValue, "The specified static import class '%s' is not visible.", ElementUtils.getQualifiedName(importClass));
                }
                elements.addAll(this.importVisibleStaticMembersImpl(node.getTemplateType(), importClassElement, false));
            }
        }
    }

    private List<Element> importVisibleStaticMembersImpl(TypeElement relativeTo, TypeElement importType, boolean includeConstructors) {
        ImportsKey key = new ImportsKey(relativeTo, importType, includeConstructors);
        List<Element> elements = this.importCache.get(key);
        if (elements != null) {
            return elements;
        }
        List<Element> members = NodeParser.importVisibleStaticMembers(relativeTo, importType, includeConstructors);
        this.importCache.put(key, members);
        return members;
    }

    public static List<Element> importVisibleStaticMembers(TypeElement relativeTo, TypeElement importType, boolean includeConstructors) {
        ProcessorContext context = ProcessorContext.getInstance();
        TypeElement importElement = ElementUtils.fromTypeMirror(context.reloadType(importType.asType()));
        ArrayList<Element> members = new ArrayList<Element>();
        List<? extends Element> importMembers = context.getEnvironment().getElementUtils().getAllMembers(importType);
        if (includeConstructors && ElementUtils.isVisible(relativeTo, importElement) && ElementFilter.constructorsIn(importMembers).isEmpty()) {
            CodeExecutableElement executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), importElement.asType(), null, new CodeVariableElement[0]);
            executable.setEnclosingElement(importType);
            members.add(executable);
        }
        for (Element element : importMembers) {
            ElementKind kind;
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            if (includeConstructors && element.getKind() == ElementKind.CONSTRUCTOR) {
                members.add(element);
                continue;
            }
            if (!element.getModifiers().contains((Object)Modifier.STATIC) || !(kind = element.getKind()).isField() && kind != ElementKind.METHOD) continue;
            members.add(element);
        }
        Collections.sort(members, new Comparator<Element>(){
            Map<TypeMirror, Set<String>> cachedQualifiedNames = new HashMap<TypeMirror, Set<String>>();

            @Override
            public int compare(Element o1, Element o2) {
                TypeMirror e1 = ElementUtils.findNearestEnclosingType(o1).orElseThrow(AssertionError::new).asType();
                TypeMirror e2 = ElementUtils.findNearestEnclosingType(o2).orElseThrow(AssertionError::new).asType();
                Set<String> e1SuperTypes = this.getCachedSuperTypes(e1);
                Set<String> e2SuperTypes = this.getCachedSuperTypes(e2);
                return ElementUtils.compareByTypeHierarchy(e1, e1SuperTypes, e2, e2SuperTypes);
            }

            private Set<String> getCachedSuperTypes(TypeMirror e) {
                if (e == null) {
                    return Collections.emptySet();
                }
                Set<String> superTypes = this.cachedQualifiedNames.get(e);
                if (superTypes == null) {
                    superTypes = new HashSet<String>(ElementUtils.getQualifiedSuperTypeNames(ElementUtils.fromTypeMirror(e)));
                    this.cachedQualifiedNames.put(e, superTypes);
                }
                return superTypes;
            }
        });
        return members;
    }

    private NodeData parseNodeData(TypeElement templateType, List<TypeElement> typeHierarchy) {
        AnnotationMirror typeSystemMirror = NodeParser.findFirstAnnotation(typeHierarchy, this.types.TypeSystemReference);
        TypeSystemData typeSystem = null;
        if (typeSystemMirror != null) {
            TypeMirror typeSystemType = ElementUtils.getAnnotationValue(TypeMirror.class, typeSystemMirror, "value");
            typeSystem = (TypeSystemData)this.context.getTemplate(typeSystemType, true);
            if (typeSystem == null) {
                NodeData nodeData = new NodeData(this.context, templateType);
                nodeData.addError("The used type system '%s' is invalid. Fix errors in the type system first.", ElementUtils.getQualifiedName(typeSystemType));
                return nodeData;
            }
        } else {
            typeSystem = new TypeSystemData(this.context, templateType, null, true);
        }
        boolean useNodeFactory = NodeParser.findFirstAnnotation(typeHierarchy, this.types.GenerateNodeFactory) != null;
        AnnotationMirror generateUncachedMirror = null;
        boolean needsInherit = false;
        for (Element element : typeHierarchy) {
            AnnotationMirror mirror = ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.GenerateUncached);
            if (mirror != null) {
                generateUncachedMirror = mirror;
                break;
            }
            needsInherit = true;
        }
        boolean generateUncached = generateUncachedMirror != null ? (needsInherit ? ElementUtils.getAnnotationValue(Boolean.class, generateUncachedMirror, "inherit") : true) : false;
        return new NodeData(this.context, templateType, typeSystem, useNodeFactory, generateUncached);
    }

    private List<NodeFieldData> parseFields(List<TypeElement> typeHierarchy, List<? extends Element> elements) {
        HashSet<String> names = new HashSet<String>();
        ArrayList<NodeFieldData> fields = new ArrayList<NodeFieldData>();
        for (VariableElement field : ElementFilter.fieldsIn(elements)) {
            if (field.getModifiers().contains((Object)Modifier.STATIC) || ElementUtils.findAnnotationMirror((Element)field, (TypeMirror)this.types.Executed) != null || !field.getModifiers().contains((Object)Modifier.PUBLIC) && !field.getModifiers().contains((Object)Modifier.PROTECTED)) continue;
            String name = field.getSimpleName().toString();
            fields.add(new NodeFieldData(field, null, field, false));
            names.add(name);
        }
        ArrayList<TypeElement> reversedTypeHierarchy = new ArrayList<TypeElement>(typeHierarchy);
        Collections.reverse(reversedTypeHierarchy);
        for (TypeElement typeElement : reversedTypeHierarchy) {
            AnnotationMirror nodeChildrenMirror = ElementUtils.findAnnotationMirror((Element)typeElement, (TypeMirror)this.types.NodeFields);
            List<AnnotationMirror> children = ElementUtils.collectAnnotations(nodeChildrenMirror, "value", typeElement, this.types.NodeField);
            for (AnnotationMirror mirror : children) {
                String name = ElementUtils.firstLetterLowerCase(ElementUtils.getAnnotationValue(String.class, mirror, "name"));
                TypeMirror type = ElementUtils.getAnnotationValue(TypeMirror.class, mirror, "type");
                if (type == null) continue;
                NodeFieldData field = new NodeFieldData(typeElement, mirror, new CodeVariableElement(type, name), true);
                if (name.isEmpty()) {
                    field.addError(ElementUtils.getAnnotationValue(mirror, "name"), "Field name cannot be empty.", new Object[0]);
                } else if (names.contains(name)) {
                    field.addError(ElementUtils.getAnnotationValue(mirror, "name"), "Duplicate field name '%s'.", name);
                }
                names.add(name);
                fields.add(field);
            }
        }
        for (NodeFieldData nodeFieldData : fields) {
            nodeFieldData.setGetter(this.findGetter(elements, nodeFieldData.getName(), nodeFieldData.getType()));
            nodeFieldData.setSetter(NodeParser.findSetter(elements, nodeFieldData.getName(), nodeFieldData.getType()));
        }
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    private List<NodeChildData> parseChildren(NodeData node, List<TypeElement> typeHierarchy, List<? extends Element> elements) {
        NodeChildData child;
        HashMap<String, TypeMirror> castNodeTypes = new HashMap<String, TypeMirror>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(elements)) {
            List<String> children;
            AnnotationMirror mirror = ElementUtils.findAnnotationMirror((Element)executableElement, (TypeMirror)this.types.CreateCast);
            if (mirror == null || (children = ElementUtils.getAnnotationValueList(String.class, mirror, "value")) == null) continue;
            for (String child2 : children) {
                castNodeTypes.put(child2, executableElement.getReturnType());
            }
        }
        ArrayList<NodeChildData> executedFieldChildren = new ArrayList<NodeChildData>();
        for (VariableElement field : ElementFilter.fieldsIn(elements)) {
            Object executed;
            if (field.getModifiers().contains((Object)Modifier.STATIC) || (executed = ElementUtils.findAnnotationMirror(field.getAnnotationMirrors(), (TypeMirror)this.types.Executed)) == null) continue;
            TypeMirror type = field.asType();
            String name = field.getSimpleName().toString();
            NodeChildData.Cardinality cardinality = NodeChildData.Cardinality.ONE;
            if (type.getKind() == TypeKind.ARRAY) {
                cardinality = NodeChildData.Cardinality.MANY;
            }
            AnnotationValue executedWith = ElementUtils.getAnnotationValue((AnnotationMirror)executed, "with");
            child = new NodeChildData(field, (AnnotationMirror)executed, name, type, type, field, cardinality, executedWith);
            executedFieldChildren.add(child);
            if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                child.addError("Field annotated with @%s must be visible for the generated subclass to execute.", this.types.Executed.asElement().getSimpleName().toString());
            }
            if (cardinality == NodeChildData.Cardinality.ONE) {
                if (ElementUtils.findAnnotationMirror((Element)field, (TypeMirror)this.types.Node_Child) != null) continue;
                child.addError("Field annotated with @%s must also be annotated with @%s.", this.types.Executed.asElement().getSimpleName().toString(), this.types.Node_Child.asElement().getSimpleName().toString());
                continue;
            }
            assert (cardinality == NodeChildData.Cardinality.MANY);
            if (ElementUtils.findAnnotationMirror((Element)field, (TypeMirror)this.types.Node_Children) != null) continue;
            child.addError("Field annotated with @%s must also be annotated with @%s.", this.types.Executed.asElement().getSimpleName().toString(), this.types.Node_Children.asElement().getSimpleName().toString());
        }
        Object var6_8 = null;
        HashSet<String> names = new HashSet<String>();
        for (NodeChildData child3 : executedFieldChildren) {
            void var6_9;
            if (child3.needsGeneratedField()) {
                throw new AssertionError((Object)"Should not need generated field.");
            }
            if (names.contains(child3.getName())) {
                child3.addError("Field annotated with @%s has duplicate name '%s'. Executed children must have unique names.", this.types.Executed.asElement().getSimpleName().toString(), child3.getName());
            } else if (var6_9 != null) {
                child3.addError("Field annotated with @%s is hidden by executed field '%s'. Executed child fields with multiple children hide all following executed child declarations. Reorder or remove this executed child declaration.", this.types.Executed.asElement().getSimpleName().toString(), var6_9.getName());
            } else if (child3.getCardinality().isMany()) {
                NodeChildData nodeChildData = child3;
            }
            names.add(child3.getName());
        }
        ArrayList<NodeChildData> nodeChildren = new ArrayList<NodeChildData>();
        ArrayList<TypeElement> typeHierarchyReversed = new ArrayList<TypeElement>(typeHierarchy);
        Collections.reverse(typeHierarchyReversed);
        for (TypeElement type : typeHierarchyReversed) {
            AnnotationMirror nodeChildrenMirror = ElementUtils.findAnnotationMirror((Element)type, (TypeMirror)this.types.NodeChildren);
            TypeMirror nodeClassType = type.getSuperclass();
            if (nodeClassType.getKind() == TypeKind.NONE || !ElementUtils.isAssignable(nodeClassType, this.types.Node)) {
                nodeClassType = null;
            }
            List<AnnotationMirror> children = ElementUtils.collectAnnotations(nodeChildrenMirror, "value", type, this.types.NodeChild);
            int index = 0;
            for (AnnotationMirror childMirror : children) {
                String name = ElementUtils.getAnnotationValue(String.class, childMirror, "value");
                if (name.equals("")) {
                    name = "child" + index;
                }
                NodeChildData.Cardinality cardinality = NodeChildData.Cardinality.ONE;
                TypeMirror childNodeType = this.inheritType(childMirror, "type", nodeClassType);
                if (childNodeType.getKind() == TypeKind.ARRAY) {
                    cardinality = NodeChildData.Cardinality.MANY;
                }
                TypeMirror originalChildType = childNodeType;
                TypeMirror castNodeType = (TypeMirror)castNodeTypes.get(name);
                if (castNodeType != null) {
                    childNodeType = castNodeType;
                }
                ExecutableElement getter = this.findGetter(elements, name, childNodeType);
                AnnotationValue executeWith = ElementUtils.getAnnotationValue(childMirror, "executeWith");
                NodeChildData nodeChild = new NodeChildData(type, childMirror, name, childNodeType, originalChildType, getter, cardinality, executeWith);
                nodeChildren.add(nodeChild);
                if (nodeChild.getNodeType() == null) {
                    nodeChild.addError("No valid node type could be resoleved.", new Object[0]);
                }
                if (nodeChild.hasErrors()) continue;
                ++index;
            }
        }
        if (!nodeChildren.isEmpty() && !executedFieldChildren.isEmpty()) {
            node.addError("The use of @%s and @%s at the same time is not supported.", this.types.NodeChild.asElement().getSimpleName().toString(), this.types.Executed.asElement().getSimpleName().toString());
            return executedFieldChildren;
        }
        if (!executedFieldChildren.isEmpty()) {
            return executedFieldChildren;
        }
        ArrayList<NodeChildData> filteredChildren = new ArrayList<NodeChildData>();
        HashSet<String> encounteredNames = new HashSet<String>();
        for (int i = nodeChildren.size() - 1; i >= 0; --i) {
            child = (NodeChildData)nodeChildren.get(i);
            if (encounteredNames.contains(child.getName())) continue;
            filteredChildren.add(0, child);
            encounteredNames.add(child.getName());
        }
        return filteredChildren;
    }

    /*
     * WARNING - void declaration
     */
    private List<NodeExecutionData> parseExecutions(NodeData node, List<NodeFieldData> fields, List<NodeChildData> children, List<? extends Element> elements) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        boolean hasVarArgs = false;
        int maxSignatureSize = 0;
        if (!children.isEmpty()) {
            int lastIndex = children.size() - 1;
            hasVarArgs = children.get(lastIndex).getCardinality() == NodeChildData.Cardinality.MANY;
            maxSignatureSize = hasVarArgs ? lastIndex : children.size();
        }
        ArrayList<NodeFieldData> nonGetterFields = new ArrayList<NodeFieldData>();
        for (NodeFieldData nodeFieldData : fields) {
            if (nodeFieldData.getGetter() != null || !nodeFieldData.isGenerated()) continue;
            nonGetterFields.add(nodeFieldData);
        }
        List<TypeMirror> frameTypes = this.context.getFrameTypes();
        for (ExecutableElement method : methods) {
            AnnotationMirror mirror = ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)this.types.Specialization);
            if (mirror == null) continue;
            int currentArgumentIndex = 0;
            block2: for (VariableElement variableElement : method.getParameters()) {
                TypeMirror type = variableElement.asType();
                if (currentArgumentIndex == 0) {
                    for (TypeMirror typeMirror : frameTypes) {
                        if (!ElementUtils.typeEquals(type, typeMirror)) continue;
                        continue block2;
                    }
                }
                if (currentArgumentIndex < nonGetterFields.size()) {
                    for (NodeFieldData nodeFieldData : nonGetterFields) {
                        if (!ElementUtils.typeEquals(variableElement.asType(), nodeFieldData.getType())) continue;
                        continue block2;
                    }
                }
                for (TypeMirror typeMirror : this.cachedAnnotations) {
                    if (ElementUtils.findAnnotationMirror(variableElement.getAnnotationMirrors(), typeMirror) == null) continue;
                    continue block2;
                }
                ++currentArgumentIndex;
            }
            maxSignatureSize = Math.max(maxSignatureSize, currentArgumentIndex);
        }
        ArrayList<NodeExecutionData> arrayList = new ArrayList<NodeExecutionData>();
        for (int i = 0; i < maxSignatureSize; ++i) {
            void var15_25;
            boolean varArgParameter = false;
            int childIndex = i;
            if (i >= children.size() - 1) {
                if (hasVarArgs) {
                    varArgParameter = hasVarArgs;
                    childIndex = Math.min(i, children.size() - 1);
                } else if (i >= children.size()) {
                    childIndex = -1;
                }
            }
            int varArgsIndex = -1;
            Object var15_23 = null;
            if (childIndex != -1) {
                varArgsIndex = varArgParameter ? Math.abs(childIndex - i) : -1;
                NodeChildData nodeChildData = children.get(childIndex);
            }
            arrayList.add(new NodeExecutionData((NodeChildData)var15_25, i, varArgsIndex));
        }
        return arrayList;
    }

    private List<ExecutableTypeData> parseExecutableTypeData(NodeData node, List<? extends Element> elements, int signatureSize, List<TypeMirror> frameTypes, boolean includeFinals) {
        ArrayList<ExecutableTypeData> typeData = new ArrayList<ExecutableTypeData>();
        for (ExecutableElement method : ElementFilter.methodsIn(elements)) {
            Set<Modifier> modifiers = method.getModifiers();
            if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC) || !includeFinals && modifiers.contains((Object)Modifier.FINAL) || !method.getSimpleName().toString().startsWith("execute") || ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)this.types.Specialization) != null) continue;
            boolean ignoreUnexpected = this.mode == ParseMode.EXPORTED_MESSAGE;
            ExecutableTypeData executableType = new ExecutableTypeData(node, method, signatureSize, this.context.getFrameTypes(), ignoreUnexpected);
            if (executableType.getFrameParameter() != null) {
                boolean supportedType = false;
                for (TypeMirror type : frameTypes) {
                    if (!ElementUtils.isAssignable(type, executableType.getFrameParameter())) continue;
                    supportedType = true;
                    break;
                }
                if (!supportedType) continue;
            }
            typeData.add(executableType);
        }
        NodeParser.namesUnique(typeData);
        return typeData;
    }

    private static void namesUnique(List<ExecutableTypeData> typeData) {
        ArrayList<String> names = new ArrayList<String>();
        for (ExecutableTypeData type : typeData) {
            names.add(type.getUniqueName());
        }
        while (NodeParser.renameDuplicateIds(names)) {
        }
        for (int i = 0; i < typeData.size(); ++i) {
            typeData.get(i).setUniqueName((String)names.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initializeExecutableTypes(NodeData node) {
        void var6_10;
        List<ExecutableTypeData> allExecutes = node.getExecutableTypes();
        HashSet<String> inconsistentFrameTypes = new HashSet<String>();
        TypeMirror frameType = null;
        for (ExecutableTypeData executableTypeData : allExecutes) {
            TypeMirror frame = executableTypeData.getFrameParameter();
            if (frame == null) continue;
            TypeMirror resolvedFrameType = frame;
            if (frameType == null) {
                frameType = resolvedFrameType;
                continue;
            }
            if (ElementUtils.typeEquals(frameType, resolvedFrameType)) continue;
            inconsistentFrameTypes.add(ElementUtils.getSimpleName(frameType));
            inconsistentFrameTypes.add(ElementUtils.getSimpleName(resolvedFrameType));
        }
        if (!inconsistentFrameTypes.isEmpty()) {
            ArrayList inconsistentFrameTypesList = new ArrayList(inconsistentFrameTypes);
            Collections.sort(inconsistentFrameTypesList);
            node.addError("Invalid inconsistent frame types %s found for the declared execute methods. The frame type must be identical for all execute methods.", inconsistentFrameTypesList);
        }
        if (frameType == null) {
            frameType = this.context.getType(Void.TYPE);
        }
        node.setFrameType(frameType);
        boolean genericFound = false;
        for (ExecutableTypeData type : node.getExecutableTypes()) {
            if (this.mode != ParseMode.EXPORTED_MESSAGE && type.hasUnexpectedValue()) continue;
            genericFound = true;
            break;
        }
        if (!genericFound) {
            node.addError("No accessible and overridable generic execute method found. Generic execute methods usually have the signature 'public abstract {Type} execute(VirtualFrame)'.", new Object[0]);
        }
        boolean bl = false;
        int nodeChildDeclarationsRequired = 0;
        List<NodeExecutionData> executions = node.getChildExecutions();
        for (NodeExecutionData nodeExecutionData : executions) {
            if (nodeExecutionData.getChild() == null) {
                nodeChildDeclarationsRequired = nodeExecutionData.getIndex() + 1;
                continue;
            }
            ++var6_10;
        }
        ArrayList<String> requireNodeChildDeclarations = new ArrayList<String>();
        for (ExecutableTypeData type : allExecutes) {
            if (type.getEvaluatedCount() >= nodeChildDeclarationsRequired) continue;
            requireNodeChildDeclarations.add(ElementUtils.createReferenceName(type.getMethod()));
        }
        if (!requireNodeChildDeclarations.isEmpty()) {
            node.addError("Not enough child node declarations found. Please annotate the node class with addtional @NodeChild annotations or remove all execute methods that do not provide all evaluated values. The following execute methods do not provide all evaluated values for the expected signature size %s: %s.", executions.size(), requireNodeChildDeclarations);
        }
        if (var6_10 > 0 && executions.size() == node.getMinimalEvaluatedParameters()) {
            for (NodeChildData child : node.getChildren()) {
                child.addError("Unnecessary @NodeChild declaration. All evaluated child values are provided as parameters in execute methods.", new Object[0]);
            }
        }
        TypeMirror typeMirror = this.context.getType(RuntimeException.class);
        LinkedHashSet allowedCheckedExceptions = null;
        for (ExecutableTypeData type : allExecutes) {
            List<? extends TypeMirror> thrownTypes = type.getMethod().getThrownTypes();
            ArrayList<String> checkedTypes = null;
            for (TypeMirror typeMirror2 : thrownTypes) {
                if (type.hasUnexpectedValue() || ElementUtils.isAssignable(typeMirror2, typeMirror)) continue;
                if (checkedTypes == null) {
                    checkedTypes = new ArrayList<String>();
                }
                checkedTypes.add(ElementUtils.getQualifiedName(typeMirror2));
            }
            if (allowedCheckedExceptions == null) {
                if (checkedTypes != null) {
                    allowedCheckedExceptions = new LinkedHashSet(checkedTypes);
                }
            } else if (checkedTypes != null) {
                allowedCheckedExceptions.retainAll(checkedTypes);
            }
            if (allowedCheckedExceptions == null || !allowedCheckedExceptions.isEmpty()) continue;
            break;
        }
        node.setAllowedCheckedExceptions(allowedCheckedExceptions == null ? Collections.emptySet() : allowedCheckedExceptions);
    }

    private void initializeChildren(NodeData node) {
        for (NodeChildData child : node.getChildren()) {
            AnnotationValue executeWithValue1 = child.getExecuteWithValue();
            List executeWithValues = ElementUtils.resolveAnnotationValue(List.class, executeWithValue1);
            ArrayList<NodeExecutionData> executeWith = new ArrayList<NodeExecutionData>();
            for (AnnotationValue executeWithValue : executeWithValues) {
                String executeWithString = ElementUtils.resolveAnnotationValue(String.class, executeWithValue);
                if (child.getName().equals(executeWithString)) {
                    child.addError(executeWithValue1, "The child node '%s' cannot be executed with itself.", executeWithString);
                    continue;
                }
                NodeExecutionData found = null;
                boolean before = true;
                for (NodeExecutionData resolveChild : node.getChildExecutions()) {
                    if (resolveChild.getChild() == child) {
                        before = false;
                        continue;
                    }
                    if (!resolveChild.getIndexedName().equals(executeWithString)) continue;
                    found = resolveChild;
                    break;
                }
                if (found == null) {
                    child.addError(executeWithValue1, "The child node '%s' cannot be executed with '%s'. The child node was not found.", child.getName(), executeWithString);
                    continue;
                }
                if (!before) {
                    child.addError(executeWithValue1, "The child node '%s' cannot be executed with '%s'. The node %s is executed after the current node.", child.getName(), executeWithString, executeWithString);
                    continue;
                }
                executeWith.add(found);
            }
            child.setExecuteWith(executeWith);
        }
        for (NodeChildData child : node.getChildren()) {
            TypeMirror nodeType = child.getNodeType();
            NodeData fieldNodeData = this.parseChildNodeData(node, child, ElementUtils.fromTypeMirror(nodeType));
            child.setNode(fieldNodeData);
            if (fieldNodeData == null || fieldNodeData.hasErrors()) {
                child.addError("Node type '%s' is invalid or not a subclass of Node.", ElementUtils.getQualifiedName(nodeType));
                continue;
            }
            List<ExecutableTypeData> foundTypes = child.findGenericExecutableTypes();
            if (!foundTypes.isEmpty()) continue;
            AnnotationValue executeWithValue = child.getExecuteWithValue();
            child.addError(executeWithValue, "No generic execute method found with %s evaluated arguments for node type %s and frame types %s.", child.getExecuteWith().size(), ElementUtils.getSimpleName(nodeType), ElementUtils.getUniqueIdentifiers(this.createAllowedChildFrameTypes(node)));
        }
    }

    private NodeData parseChildNodeData(NodeData parentNode, NodeChildData child, TypeElement originalTemplateType) {
        TypeElement templateType = ElementUtils.fromTypeMirror(this.context.reloadTypeElement(originalTemplateType));
        if (ElementUtils.findAnnotationMirror((Element)originalTemplateType, (TypeMirror)this.types.GeneratedBy) != null) {
            return null;
        }
        if (!ElementUtils.isAssignable(templateType.asType(), this.types.Node)) {
            return null;
        }
        List<TypeElement> lookupTypes = NodeParser.collectSuperClasses(new ArrayList<TypeElement>(), templateType);
        List<? extends Element> members = this.processingEnv.getElementUtils().getAllMembers(templateType);
        NodeData node = this.parseNodeData(templateType, lookupTypes);
        if (node.hasErrors()) {
            return node;
        }
        List<TypeMirror> frameTypes = Collections.emptyList();
        if (parentNode.getFrameType() != null) {
            frameTypes = Arrays.asList(parentNode.getFrameType());
        }
        node.getExecutableTypes().addAll(this.parseExecutableTypeData(node, members, child.getExecuteWith().size(), frameTypes, true));
        node.setFrameType(parentNode.getFrameType());
        return node;
    }

    private List<TypeMirror> createAllowedChildFrameTypes(NodeData parentNode) {
        ArrayList<TypeMirror> allowedFrameTypes = new ArrayList<TypeMirror>();
        for (TypeMirror frameType : this.context.getFrameTypes()) {
            if (!ElementUtils.isAssignable(parentNode.getFrameType(), frameType)) continue;
            allowedFrameTypes.add(frameType);
        }
        return allowedFrameTypes;
    }

    private void initializeSpecializations(List<? extends Element> elements, NodeData node) {
        if (node.getSpecializations().isEmpty()) {
            return;
        }
        NodeParser.initializeReplaces(node);
        this.resolveReplaces(node);
        this.initializeExpressions(elements, node);
        if (node.hasErrors()) {
            return;
        }
        this.initializeGeneric(node);
        NodeParser.initializeUninitialized(node);
        NodeParser.initializeOrder(node);
        this.initializePolymorphism(node);
        NodeParser.initializeReachability(node);
        NodeParser.initializeFallbackReachability(node);
        this.initializeCheckedExceptions(node);
        NodeParser.initializeExcludeBy(node);
        NodeParser.initializeSpecializationIdsWithMethodNames(node.getSpecializations());
    }

    private void initializeCheckedExceptions(NodeData node) {
        for (SpecializationData specialization : node.getSpecializations()) {
            TypeMirror runtimeException = this.context.getType(RuntimeException.class);
            Set<String> exceptionTypeNames = NodeParser.getExceptionTypes(specialization.getMethod(), runtimeException);
            for (GuardExpression guard : specialization.getGuards()) {
                for (ExecutableElement executableElement : guard.getExpression().findBoundExecutableElements()) {
                    exceptionTypeNames.addAll(NodeParser.getExceptionTypes(executableElement, runtimeException));
                }
            }
            for (CacheExpression cache : specialization.getCaches()) {
                if (cache.getDefaultExpression() != null) {
                    for (ExecutableElement executableElement : cache.getDefaultExpression().findBoundExecutableElements()) {
                        exceptionTypeNames.addAll(NodeParser.getExceptionTypes(executableElement, runtimeException));
                    }
                }
                if (cache.getUncachedExpression() == null) continue;
                for (ExecutableElement executableElement : cache.getUncachedExpression().findBoundExecutableElements()) {
                    exceptionTypeNames.addAll(NodeParser.getExceptionTypes(executableElement, runtimeException));
                }
            }
            LinkedHashSet<String> allowedCheckedExceptions = new LinkedHashSet<String>(node.getAllowedCheckedExceptions());
            for (SpecializationThrowsData t : specialization.getExceptions()) {
                allowedCheckedExceptions.add(ElementUtils.getQualifiedName(t.getJavaClass()));
            }
            exceptionTypeNames.removeAll(allowedCheckedExceptions);
            if (exceptionTypeNames.isEmpty()) continue;
            specialization.addError("Specialization guard method or cache initializer declares an undeclared checked exception %s. Only checked exceptions are allowed that were declared in the execute signature. Allowed exceptions are: %s.", exceptionTypeNames, allowedCheckedExceptions);
        }
    }

    private static Set<String> getExceptionTypes(ExecutableElement method, TypeMirror runtimeException) {
        if (method == null) {
            return Collections.emptySet();
        }
        return method.getThrownTypes().stream().filter(t -> !ElementUtils.isAssignable(t, runtimeException)).map(ElementUtils::getQualifiedName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void initializeOrder(NodeData node) {
        int i;
        List<SpecializationData> specializations = node.getSpecializations();
        Collections.sort(specializations);
        for (SpecializationData specialization : specializations) {
            TypeMirror insertBeforeEnclosedType;
            String searchName = specialization.getInsertBeforeName();
            if (searchName == null || specialization.getMethod() == null) continue;
            List<SpecializationData> found = NodeParser.lookupSpecialization(node, searchName);
            if (found.isEmpty() || found.get(0).getMethod() == null) {
                AnnotationValue value = ElementUtils.getAnnotationValue(specialization.getMarkerAnnotation(), "insertBefore");
                specialization.addError(value, "The referenced specialization '%s' could not be found.", searchName);
                continue;
            }
            SpecializationData first = found.iterator().next();
            ExecutableElement currentMethod = specialization.getMethod();
            ExecutableElement insertBeforeMethod = first.getMethod();
            TypeMirror currentEnclosedType = currentMethod.getEnclosingElement().asType();
            if (ElementUtils.typeEquals(currentEnclosedType, insertBeforeEnclosedType = insertBeforeMethod.getEnclosingElement().asType()) || !ElementUtils.isSubtype(currentEnclosedType, insertBeforeEnclosedType)) {
                AnnotationValue value = ElementUtils.getAnnotationValue(specialization.getMarkerAnnotation(), "insertBefore");
                specialization.addError(value, "Specializations can only be inserted before specializations in superclasses.", searchName);
                continue;
            }
            specialization.setInsertBefore(first);
        }
        for (i = 0; i < specializations.size(); ++i) {
            int insertIndex;
            SpecializationData specialization;
            specialization = specializations.get(i);
            SpecializationData insertBefore = specialization.getInsertBefore();
            if (insertBefore == null || (insertIndex = specializations.indexOf(insertBefore)) >= i) continue;
            specializations.remove(i);
            specializations.add(insertIndex, specialization);
        }
        for (i = 0; i < specializations.size(); ++i) {
            specializations.get(i).setIndex(i);
        }
    }

    private static void initializeReplaces(NodeData node) {
        for (SpecializationData specialization : node.getSpecializations()) {
            Set<SpecializationData> resolvedSpecializations = specialization.getReplaces();
            Set<String> includeNames = specialization.getReplacesNames();
            for (String includeName : includeNames) {
                List<SpecializationData> foundSpecializations = NodeParser.lookupSpecialization(node, includeName);
                AnnotationValue value = ElementUtils.getAnnotationValue(specialization.getMarkerAnnotation(), "replaces");
                if (foundSpecializations.isEmpty()) {
                    specialization.addError(value, "The referenced specialization '%s' could not be found.", includeName);
                    continue;
                }
                resolvedSpecializations.addAll(foundSpecializations);
                for (SpecializationData foundSpecialization : foundSpecializations) {
                    if (foundSpecialization.compareTo(specialization) <= 0) continue;
                    specialization.addError(value, "The replaced specialization '%s' must be declared before the replacing specialization.", includeName);
                }
            }
        }
    }

    private void resolveReplaces(NodeData node) {
        for (SpecializationData specialization : node.getSpecializations()) {
            if (specialization.getReplaces().isEmpty()) continue;
            for (SpecializationData replaced : specialization.getReplaces()) {
                replaced.setReplaced(true);
            }
            HashSet<SpecializationData> foundSpecializations = new HashSet<SpecializationData>();
            this.collectIncludes(specialization, foundSpecializations, new HashSet<SpecializationData>());
            specialization.getReplaces().addAll(foundSpecializations);
        }
    }

    private static List<SpecializationData> lookupSpecialization(NodeData node, String includeName) {
        ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>();
        for (SpecializationData searchSpecialization : node.getSpecializations()) {
            if (!searchSpecialization.getMethodName().equals(includeName)) continue;
            specializations.add(searchSpecialization);
        }
        return specializations;
    }

    private void collectIncludes(SpecializationData specialization, Set<SpecializationData> found, Set<SpecializationData> visited) {
        if (visited.contains(specialization)) {
            specialization.addError("Circular replaced specialization '%s' found.", specialization.createReferenceName());
            return;
        }
        visited.add(specialization);
        for (SpecializationData included : specialization.getReplaces()) {
            this.collectIncludes(included, found, new HashSet<SpecializationData>(visited));
            found.add(included);
        }
    }

    private static void initializeReachability(NodeData node) {
        List<SpecializationData> specializations = node.getSpecializations();
        for (int i = specializations.size() - 1; i >= 0; --i) {
            SpecializationData current = specializations.get(i);
            if (current.isPolymorphic()) {
                current.setReachable(true);
                continue;
            }
            ArrayList<SpecializationData> shadowedBy = null;
            for (int j = i - 1; j >= 0; --j) {
                SpecializationData prev = specializations.get(j);
                if (prev.isPolymorphic() || current.isReachableAfter(prev)) continue;
                if (shadowedBy == null) {
                    shadowedBy = new ArrayList<SpecializationData>();
                }
                shadowedBy.add(prev);
            }
            if (shadowedBy != null) {
                StringBuilder name = new StringBuilder();
                String sep = "";
                for (SpecializationData shadowSpecialization : shadowedBy) {
                    name.append(sep);
                    name.append(shadowSpecialization.createReferenceName());
                    sep = ", ";
                }
                current.addError("%s is not reachable. It is shadowed by %s.", current.isFallback() ? "Generic" : "Specialization", name);
            }
            current.setReachable(shadowedBy == null);
        }
    }

    private static void initializeExcludeBy(NodeData node) {
        List<SpecializationData> specializations = node.getSpecializations();
        for (SpecializationData cur : specializations) {
            for (SpecializationData contained : cur.getReplaces()) {
                if (contained == cur) continue;
                contained.getExcludedBy().add(cur);
            }
        }
    }

    public static void removeFastPathSpecializations(NodeData node) {
        List<SpecializationData> specializations = node.getSpecializations();
        ArrayList<SpecializationData> toRemove = new ArrayList<SpecializationData>();
        for (SpecializationData cur : specializations) {
            for (SpecializationData contained : cur.getReplaces()) {
                if (contained == cur || contained.getUncachedSpecialization() == cur) continue;
                toRemove.add(contained);
            }
        }
        specializations.removeAll(toRemove);
    }

    private static void initializeSpecializationIdsWithMethodNames(List<SpecializationData> specializations) {
        ArrayList<String> signatures = new ArrayList<String>();
        for (SpecializationData specialization : specializations) {
            String filteredDo;
            if (specialization.isFallback()) {
                signatures.add("Fallback");
                continue;
            }
            if (specialization.isUninitialized()) {
                signatures.add("Uninitialized");
                continue;
            }
            if (specialization.isPolymorphic()) {
                signatures.add("Polymorphic");
                continue;
            }
            String name = specialization.getMethodName();
            if (name.equalsIgnoreCase("base")) {
                name = name + "0";
            } else if (name.startsWith("do") && !(filteredDo = name.substring(2, name.length())).isEmpty() && Character.isJavaIdentifierStart(filteredDo.charAt(0))) {
                name = filteredDo;
            }
            signatures.add(ElementUtils.firstLetterUpperCase(name));
        }
        while (NodeParser.renameDuplicateIds(signatures)) {
        }
        for (int i = 0; i < specializations.size(); ++i) {
            specializations.get(i).setId((String)signatures.get(i));
        }
    }

    private static boolean renameDuplicateIds(List<String> signatures) {
        boolean changed = false;
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String s1 : signatures) {
            Integer count = (Integer)counts.get(s1.toLowerCase());
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            counts.put(s1.toLowerCase(), count);
        }
        for (String s : counts.keySet()) {
            int count = (Integer)counts.get(s);
            if (count <= 1) continue;
            changed = true;
            int number = 0;
            ListIterator<String> iterator = signatures.listIterator();
            while (iterator.hasNext()) {
                String s2 = iterator.next();
                if (!s.equalsIgnoreCase(s2)) continue;
                iterator.set(s2 + number);
                ++number;
            }
        }
        return changed;
    }

    private void initializeExpressions(List<? extends Element> elements, NodeData node) {
        List<? extends Element> members = elements;
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        for (NodeFieldData field : node.getFields()) {
            fields.add(field.getVariable());
        }
        ArrayList<? extends Element> globalMembers = new ArrayList<Element>(members.size() + fields.size());
        globalMembers.addAll(fields);
        globalMembers.addAll(members);
        DSLExpressionResolver originalResolver = new DSLExpressionResolver(this.context, node.getTemplateType(), globalMembers);
        List<SpecializationData> specializations = node.getSpecializations();
        int i = 0;
        while (i < specializations.size()) {
            SpecializationData specialization = specializations.get(i);
            if (specialization.getMethod() == null || specialization.hasErrors()) {
                ++i;
                continue;
            }
            ArrayList<VariableElement> specializationMembers = new ArrayList<VariableElement>();
            for (Parameter p : specialization.getParameters()) {
                specializationMembers.add(p.getVariableElement());
            }
            DSLExpressionResolver resolver = originalResolver.copy(specializationMembers);
            SpecializationData uncached = this.initializeCaches(specialization, resolver);
            this.initializeGuards(specialization, resolver);
            this.initializeLimit(specialization, resolver, false);
            this.initializeAssumptions(specialization, resolver);
            if (uncached != null) {
                specializations.add(++i, uncached);
                this.initializeGuards(uncached, resolver);
                this.initializeLimit(uncached, resolver, true);
                this.initializeAssumptions(uncached, resolver);
            }
            ++i;
        }
    }

    private void initializeAssumptions(SpecializationData specialization, DSLExpressionResolver resolver) {
        DeclaredType assumptionType = this.types.Assumption;
        CodeTypeMirror.ArrayCodeTypeMirror assumptionArrayType = new CodeTypeMirror.ArrayCodeTypeMirror(assumptionType);
        List<String> assumptionDefinitions = ElementUtils.getAnnotationValueList(String.class, specialization.getMarkerAnnotation(), "assumptions");
        ArrayList<AssumptionExpression> assumptionExpressions = new ArrayList<AssumptionExpression>();
        int assumptionId = 0;
        for (String assumption : assumptionDefinitions) {
            AssumptionExpression assumptionExpression;
            DSLExpression expression = null;
            try {
                expression = DSLExpression.parse(assumption);
                expression.accept(resolver);
                assumptionExpression = new AssumptionExpression(specialization, expression, "assumption" + assumptionId);
                if (!ElementUtils.isAssignable(expression.getResolvedType(), assumptionType) && !ElementUtils.isAssignable(expression.getResolvedType(), assumptionArrayType)) {
                    assumptionExpression.addError("Incompatible return type %s. Assumptions must be assignable to %s or %s.", ElementUtils.getSimpleName(expression.getResolvedType()), ElementUtils.getSimpleName(assumptionType), ElementUtils.getSimpleName(assumptionArrayType));
                }
                if (specialization.isDynamicParameterBound(expression, true)) {
                    specialization.addError("Assumption expressions must not bind dynamic parameter values.", new Object[0]);
                }
            }
            catch (InvalidExpressionException e) {
                assumptionExpression = new AssumptionExpression(specialization, null, "assumption" + assumptionId);
                assumptionExpression.addError("Error parsing expression '%s': %s", assumption, e.getMessage());
            }
            assumptionExpressions.add(assumptionExpression);
            ++assumptionId;
        }
        specialization.setAssumptionExpressions(assumptionExpressions);
    }

    private void initializeLimit(SpecializationData specialization, DSLExpressionResolver resolver, boolean uncached) {
        AnnotationValue annotationValue = ElementUtils.getAnnotationValue(specialization.getMessageAnnotation(), "limit", false);
        String limitValue = annotationValue == null ? "3" : (String)annotationValue.getValue();
        if (!uncached && annotationValue != null && !specialization.hasMultipleInstances()) {
            if (!specialization.hasErrors()) {
                specialization.addWarning(annotationValue, "The limit expression has no effect. Multiple specialization instantiations are impossible for this specialization.", new Object[0]);
            }
            return;
        }
        TypeMirror expectedType = this.context.getType(Integer.TYPE);
        try {
            DSLExpression expression = DSLExpression.parse(limitValue);
            expression.accept(resolver);
            if (!ElementUtils.typeEquals(expression.getResolvedType(), expectedType)) {
                specialization.addError(annotationValue, "Incompatible return type %s. Limit expressions must return %s.", ElementUtils.getSimpleName(expression.getResolvedType()), ElementUtils.getSimpleName(expectedType));
            }
            if (specialization.isDynamicParameterBound(expression, true)) {
                specialization.addError(annotationValue, "Limit expressions must not bind dynamic parameter values.", new Object[0]);
            }
            specialization.setLimitExpression(expression);
        }
        catch (InvalidExpressionException e) {
            specialization.addError(annotationValue, "Error parsing expression '%s': %s", limitValue, e.getMessage());
        }
    }

    private SpecializationData initializeCaches(SpecializationData specialization, DSLExpressionResolver resolver) {
        Parameter[] parameters;
        ArrayList<CacheExpression> caches = new ArrayList<CacheExpression>();
        ArrayList<CacheExpression> cachedLibraries = new ArrayList<CacheExpression>();
        block0: for (Parameter parameter : parameters = specialization.getParameters().toArray(new Parameter[0])) {
            if (!parameter.getSpecification().isCached()) continue;
            AnnotationMirror foundCached = null;
            for (TypeMirror cachedAnnotation : this.cachedAnnotations) {
                AnnotationMirror found = ElementUtils.findAnnotationMirror(parameter.getVariableElement().getAnnotationMirrors(), cachedAnnotation);
                if (found == null) continue;
                if (foundCached == null) {
                    foundCached = found;
                    continue;
                }
                StringBuilder b = new StringBuilder();
                String sep = "";
                for (TypeMirror stringCachedAnnotation : this.cachedAnnotations) {
                    b.append(sep);
                    b.append("@");
                    b.append(ElementUtils.getSimpleName(stringCachedAnnotation));
                    sep = ", ";
                }
                specialization.addError(parameter.getVariableElement(), "The following annotations are mutually exclusive for a parameter: %s.", b.toString());
                continue block0;
            }
            if (foundCached == null) continue;
            CacheExpression cache = new CacheExpression(parameter, foundCached);
            caches.add(cache);
            if (cache.isCached()) {
                boolean weakReference = ElementUtils.getAnnotationValue(Boolean.class, foundCached, "weak");
                if (weakReference) {
                    if (ElementUtils.isPrimitive(cache.getParameter().getType())) {
                        cache.addError("Cached parameters with primitive types cannot be weak. Set weak to false to resolve this.", new Object[0]);
                    }
                    this.parseCached(cache, specialization, resolver, parameter);
                    if (cache.hasErrors()) continue;
                    DSLExpression sourceExpression = cache.getDefaultExpression();
                    String weakName = "weak" + ElementUtils.firstLetterUpperCase(parameter.getLocalName()) + "Gen_";
                    CodeTypeMirror.DeclaredCodeTypeMirror weakType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(this.types.TruffleWeakReference), Arrays.asList(cache.getParameter().getType()));
                    CodeVariableElement weakVariable = new CodeVariableElement(weakType, weakName);
                    weakVariable.setEnclosingElement(specialization.getMethod());
                    Parameter weakParameter = new Parameter(parameter, weakVariable);
                    DSLExpression.Call newWeakReference = new DSLExpression.Call(null, "new", Arrays.asList(sourceExpression));
                    newWeakReference.setResolvedTargetType(weakType);
                    this.resolveCachedExpression(resolver, cache, weakType, newWeakReference, null);
                    CacheExpression weakCache = new CacheExpression(weakParameter, foundCached);
                    weakCache.setDefaultExpression(newWeakReference);
                    weakCache.setUncachedExpression(newWeakReference);
                    weakCache.setWeakReference(true);
                    caches.add(0, weakCache);
                    DSLExpressionResolver weakResolver = resolver.copy(Arrays.asList(new Element[0]));
                    weakResolver.addVariable(weakName, weakVariable);
                    specialization.addParameter(specialization.getParameters().size(), weakParameter);
                    DSLExpression parsedDefaultExpression = this.parseCachedExpression(weakResolver, cache, parameter.getType(), weakName + ".get()");
                    cache.setDefaultExpression(parsedDefaultExpression);
                    cache.setUncachedExpression(sourceExpression);
                    cache.setAlwaysInitialized(true);
                    cache.setGuardForNull(true);
                    continue;
                }
                this.parseCached(cache, specialization, resolver, parameter);
                continue;
            }
            if (cache.isCachedLibrary()) {
                String expression = cache.getCachedLibraryExpression();
                String limit = cache.getCachedLibraryLimit();
                if (expression == null) {
                    if (limit == null) {
                        cache.addError("A specialized value expression or limit must be specified for @%s. Use @%s(\"value\") for a specialized or @%s(limit=\"\") for a dispatched library. See the javadoc of @%s for further details.", this.types.CachedLibrary.asElement().getSimpleName().toString(), this.types.CachedLibrary.asElement().getSimpleName().toString(), this.types.CachedLibrary.asElement().getSimpleName().toString(), this.types.CachedLibrary.asElement().getSimpleName().toString());
                        continue;
                    }
                    DSLExpression limitExpression = this.parseCachedExpression(resolver, cache, this.context.getType(Integer.TYPE), limit);
                    if (limitExpression == null) continue;
                    DeclaredType libraryType = this.types.Library;
                    DSLExpressionResolver cachedResolver = this.importStatics(resolver, this.types.LibraryFactory);
                    TypeMirror usedLibraryType = parameter.getType();
                    DSLExpression.Call resolveCall = new DSLExpression.Call(null, "resolve", Arrays.asList(new DSLExpression.ClassLiteral(usedLibraryType)));
                    DSLExpression.Call defaultExpression = new DSLExpression.Call(resolveCall, "createDispatched", Arrays.asList(limitExpression));
                    DSLExpression.Call uncachedExpression = new DSLExpression.Call(resolveCall, "getUncached", Arrays.asList(new DSLExpression[0]));
                    cache.setDefaultExpression(this.resolveCachedExpression(cachedResolver, cache, libraryType, defaultExpression, null));
                    cache.setUncachedExpression(this.resolveCachedExpression(cachedResolver, cache, libraryType, uncachedExpression, null));
                    continue;
                }
                if (limit != null) {
                    cache.addError("The limit and specialized value expression cannot be specified at the same time. They are mutually exclusive.", new Object[0]);
                    continue;
                }
                cachedLibraries.add(cache);
                continue;
            }
            if (cache.isCachedLanguage()) {
                TypeMirror supplierType;
                TypeMirror languageType = cache.getParameter().getType();
                boolean isLanguage = ElementUtils.isAssignable(languageType, this.types.TruffleLanguage);
                boolean isLanguageReference = ElementUtils.isAssignable(languageType, this.types.TruffleLanguage_LanguageReference);
                if (!isLanguage && !isLanguageReference) {
                    cache.addError("Invalid @%s specification. The parameter type must be a subtype of %s or of type LanguageReference<%s>.", this.types.CachedLanguage.asElement().getSimpleName().toString(), this.types.TruffleLanguage.asElement().getSimpleName().toString(), this.types.TruffleLanguage.asElement().getSimpleName().toString());
                    continue;
                }
                if (isLanguageReference) {
                    TypeMirror typeArgument = NodeParser.getFirstTypeArgument(languageType);
                    if (typeArgument == null || !ElementUtils.isAssignable(typeArgument, this.types.TruffleLanguage)) {
                        cache.addError("Invalid @%s specification. The first type argument of the LanguageReference must be a subtype of '%s'.", this.types.CachedLanguage.asElement().getSimpleName().toString(), this.types.TruffleLanguage.asElement().getSimpleName().toString());
                    } else {
                        this.verifyLanguageType(this.types.CachedLanguage, cache, typeArgument);
                    }
                    supplierType = languageType;
                    languageType = typeArgument;
                } else {
                    this.verifyLanguageType(this.types.CachedLanguage, cache, languageType);
                    supplierType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(this.types.TruffleLanguage_LanguageReference), Arrays.asList(languageType));
                }
                if (cache.hasErrors()) continue;
                String fieldName = ElementUtils.firstLetterLowerCase(ElementUtils.getSimpleName(languageType)) + "Reference_";
                CodeVariableElement variableElement = new CodeVariableElement(supplierType, fieldName);
                List<CodeVariableElement> elements = Arrays.asList(variableElement);
                DSLExpressionResolver localResolver = resolver.copy(elements);
                DSLExpression.Variable accessReference = new DSLExpression.Variable(null, "null");
                cache.setReferenceType(supplierType);
                cache.setLanguageType(languageType);
                cache.setDefaultExpression(this.resolveCachedExpression(localResolver, cache, null, accessReference, null));
                cache.setUncachedExpression(this.resolveCachedExpression(localResolver, cache, null, accessReference, null));
                cache.setAlwaysInitialized(true);
                continue;
            }
            if (cache.isCachedContext()) {
                AnnotationMirror cachedContext = cache.getMessageAnnotation();
                TypeMirror languageType = ElementUtils.getAnnotationValue(TypeMirror.class, cachedContext, "value");
                if (!ElementUtils.isAssignable(languageType, languageType)) {
                    cache.addError("Invalid @%s specification. The value type must be a subtype of %s.", this.types.CachedContext.asElement().getSimpleName().toString(), this.types.TruffleLanguage.asElement().getSimpleName().toString());
                    continue;
                }
                this.verifyLanguageType(this.types.CachedContext, cache, languageType);
                if (cache.hasErrors()) continue;
                TypeMirror contextType = null;
                TypeElement languageTypeElement = ElementUtils.fromTypeMirror(languageType);
                TypeMirror superType = languageTypeElement.getSuperclass();
                while (languageTypeElement != null) {
                    superType = languageTypeElement.getSuperclass();
                    languageTypeElement = ElementUtils.fromTypeMirror(superType);
                    if (!ElementUtils.elementEquals(this.context.getTypeElement(this.types.TruffleLanguage), languageTypeElement)) continue;
                    contextType = NodeParser.getFirstTypeArgument(superType);
                    break;
                }
                if (contextType == null || contextType.getKind() != TypeKind.DECLARED) {
                    cache.addError("Invalid @%s specification. The context type could not be inferred from super type '%s' in language '%s'.", this.types.CachedContext.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(superType), ElementUtils.getSimpleName(languageType));
                    continue;
                }
                TypeMirror declaredContextType = parameter.getType();
                if (ElementUtils.typeEquals(ElementUtils.eraseGenericTypes(parameter.getType()), ElementUtils.eraseGenericTypes(this.types.TruffleLanguage_ContextReference))) {
                    declaredContextType = NodeParser.getFirstTypeArgument(parameter.getType());
                }
                if (!ElementUtils.typeEquals(contextType, declaredContextType)) {
                    cache.addError("Invalid @%s specification. The parameter type must match the context type '%s' or 'ContextReference<%s>'.", this.types.CachedContext.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(contextType), ElementUtils.getSimpleName(contextType));
                    continue;
                }
                CodeTypeMirror.DeclaredCodeTypeMirror referenceType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(this.types.TruffleLanguage_ContextReference), Arrays.asList(contextType));
                DSLExpression.Variable accessReference = new DSLExpression.Variable(null, "null");
                cache.setReferenceType(referenceType);
                cache.setLanguageType(languageType);
                cache.setDefaultExpression(this.resolveCachedExpression(resolver, cache, null, accessReference, null));
                cache.setUncachedExpression(this.resolveCachedExpression(resolver, cache, null, accessReference, null));
                cache.setAlwaysInitialized(true);
                continue;
            }
            if (!cache.isBind()) continue;
            AnnotationMirror dynamic = cache.getMessageAnnotation();
            String expression = ElementUtils.getAnnotationValue(String.class, dynamic, "value", false);
            DSLExpression parsedExpression = this.parseCachedExpression(resolver, cache, parameter.getType(), expression);
            cache.setDefaultExpression(parsedExpression);
            cache.setUncachedExpression(parsedExpression);
            cache.setAlwaysInitialized(true);
        }
        specialization.setCaches(caches);
        SpecializationData uncachedSpecialization = null;
        if (!cachedLibraries.isEmpty()) {
            uncachedSpecialization = this.parseCachedLibraries(specialization, resolver, cachedLibraries);
        }
        if (specialization.hasErrors()) {
            return null;
        }
        block4: for (int i = 0; i < caches.size(); ++i) {
            CacheExpression currentExpression = (CacheExpression)caches.get(i);
            HashSet<VariableElement> boundVariables = new HashSet<VariableElement>();
            if (currentExpression.getDefaultExpression() != null) {
                boundVariables.addAll(currentExpression.getDefaultExpression().findBoundVariableElements());
            }
            if (currentExpression.getUncachedExpression() != null) {
                boundVariables.addAll(currentExpression.getUncachedExpression().findBoundVariableElements());
            }
            for (int j = i + 1; j < caches.size(); ++j) {
                CacheExpression boundExpression = (CacheExpression)caches.get(j);
                if (!boundVariables.contains(boundExpression.getParameter().getVariableElement())) continue;
                currentExpression.addError("The initializer expression of parameter '%s' binds uninitialized parameter '%s. Reorder the parameters to resolve the problem.", currentExpression.getParameter().getLocalName(), boundExpression.getParameter().getLocalName());
                continue block4;
            }
        }
        return uncachedSpecialization;
    }

    private static TypeMirror getFirstTypeArgument(TypeMirror languageType) {
        Iterator<? extends TypeMirror> iterator = ((DeclaredType)languageType).getTypeArguments().iterator();
        if (iterator.hasNext()) {
            TypeMirror currentTypeArgument = iterator.next();
            return currentTypeArgument;
        }
        return null;
    }

    private void verifyLanguageType(DeclaredType annotationType, CacheExpression cache, TypeMirror languageType) {
        if (ElementUtils.typeEquals(this.types.HostLanguage, languageType)) {
            return;
        }
        AnnotationMirror registration = ElementUtils.findAnnotationMirror((Element)ElementUtils.fromTypeMirror(languageType), (TypeMirror)this.types.TruffleLanguage_Registration);
        if (registration == null) {
            cache.addError("Invalid @%s specification. The type '%s' is not a valid language type. Valid language types must be annotated with @%s.", annotationType.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(ElementUtils.eraseGenericTypes(languageType)), this.types.TruffleLanguage_Registration.asElement().getSimpleName().toString());
        }
    }

    private SpecializationData parseCachedLibraries(SpecializationData specialization, DSLExpressionResolver resolver, List<CacheExpression> libraries) {
        int i;
        SpecializationData uncachedSpecialization = null;
        ArrayList<CacheExpression> uncachedLibraries = null;
        if (!specialization.isReplaced()) {
            uncachedSpecialization = specialization.copy();
            uncachedLibraries = new ArrayList<CacheExpression>();
            uncachedSpecialization.getReplaces().add(specialization);
            List<CacheExpression> caches = uncachedSpecialization.getCaches();
            for (i = 0; i < caches.size(); ++i) {
                CacheExpression expression = caches.get(i);
                if (expression.getCachedLibraryExpression() == null) continue;
                expression = expression.copy();
                caches.set(i, expression);
                uncachedLibraries.add(expression);
            }
            specialization.setUncachedSpecialization(uncachedSpecialization);
        }
        if (uncachedLibraries != null && uncachedLibraries.size() != libraries.size()) {
            throw new AssertionError((Object)"Unexpected number of uncached libraries.");
        }
        boolean seenDynamicParameterBound = false;
        for (i = 0; i < libraries.size(); ++i) {
            CacheExpression cachedLibrary = libraries.get(i);
            CacheExpression uncachedLibrary = uncachedLibraries != null ? (CacheExpression)uncachedLibraries.get(i) : null;
            TypeMirror parameterType = cachedLibrary.getParameter().getType();
            TypeElement type = ElementUtils.fromTypeMirror(parameterType);
            if (type == null) {
                cachedLibrary.addError("Invalid library type %s. Must be a declared type.", ElementUtils.getSimpleName(parameterType));
                continue;
            }
            if (!ElementUtils.isAssignable(parameterType, this.types.Library)) {
                cachedLibrary.addError("Invalid library type %s. Library is not a subclass of %s.", ElementUtils.getSimpleName(parameterType), this.types.Library.asElement().getSimpleName().toString());
                continue;
            }
            if (ElementUtils.findAnnotationMirror((Element)cachedLibrary.getParameter().getVariableElement(), (TypeMirror)this.types.Cached_Shared) != null) {
                cachedLibrary.addError("Specialized cached libraries cannot be shared yet.", new Object[0]);
                continue;
            }
            LibraryParser parser = new LibraryParser();
            LibraryData parsedLibrary = (LibraryData)parser.parse(type);
            if (parsedLibrary == null || parsedLibrary.hasErrors()) {
                cachedLibrary.addError("Library '%s' has errors. Please resolve them first.", ElementUtils.getSimpleName(parameterType));
                continue;
            }
            cachedLibrary.setCachedLibrary(parsedLibrary);
            if (uncachedLibrary != null) {
                uncachedLibrary.setCachedLibrary(parsedLibrary);
            }
            String expression = cachedLibrary.getCachedLibraryExpression();
            DSLExpression receiverExpression = this.parseCachedExpression(resolver, cachedLibrary, parsedLibrary.getSignatureReceiverType(), expression);
            if (receiverExpression == null) continue;
            DSLExpression substituteCachedExpression = null;
            DSLExpression substituteUncachedExpression = null;
            if (this.mode == ParseMode.EXPORTED_MESSAGE) {
                VariableElement resolvedVariable;
                DSLExpression.Variable variable;
                Parameter receiverParameter = specialization.findParameterOrDie(specialization.getNode().getChildExecutions().get(0));
                if (receiverExpression instanceof DSLExpression.Variable && (variable = (DSLExpression.Variable)receiverExpression).getReceiver() == null && ElementUtils.variableEquals(resolvedVariable = variable.getResolvedVariable(), receiverParameter.getVariableElement()) && ElementUtils.typeEquals(type.asType(), this.exportLibraryType)) {
                    DSLExpression.Variable nodeReceiver = new DSLExpression.Variable(null, "this");
                    nodeReceiver.setResolvedTargetType(this.exportLibraryType);
                    nodeReceiver.setResolvedVariable(new CodeVariableElement(this.exportLibraryType, "this"));
                    if (this.substituteThisToParent) {
                        DSLExpression.Call call = new DSLExpression.Call(nodeReceiver, "getParent", Collections.emptyList());
                        call.setResolvedMethod(ElementUtils.findMethod(this.types.Node, "getParent"));
                        call.setResolvedTargetType(this.context.getType(Object.class));
                        substituteCachedExpression = new DSLExpression.Cast(call, this.exportLibraryType);
                    } else {
                        substituteCachedExpression = nodeReceiver;
                    }
                }
                if (substituteCachedExpression == null && NodeParser.supportsLibraryMerge(receiverExpression, receiverParameter.getVariableElement())) {
                    substituteCachedExpression = receiverExpression;
                    cachedLibrary.setMergedLibrary(true);
                }
            }
            if (substituteCachedExpression != null) {
                if (substituteUncachedExpression == null) {
                    substituteUncachedExpression = substituteCachedExpression;
                }
                cachedLibrary.setDefaultExpression(substituteCachedExpression);
                cachedLibrary.setUncachedExpression(substituteUncachedExpression);
                cachedLibrary.setAlwaysInitialized(true);
                continue;
            }
            seenDynamicParameterBound |= specialization.isDynamicParameterBound(receiverExpression, true);
            cachedLibrary.setDefaultExpression(receiverExpression);
            String receiverName = cachedLibrary.getParameter().getVariableElement().getSimpleName().toString();
            DSLExpression acceptGuard = new DSLExpression.Call(new DSLExpression.Variable(null, receiverName), "accepts", Arrays.asList(receiverExpression));
            acceptGuard = this.resolveCachedExpression(resolver, cachedLibrary, this.context.getType(Boolean.TYPE), acceptGuard, expression);
            if (acceptGuard != null) {
                GuardExpression guard = new GuardExpression(specialization, acceptGuard);
                guard.setLibraryAcceptsGuard(true);
                specialization.getGuards().add(guard);
            }
            DeclaredType libraryType = this.types.Library;
            TypeMirror usedLibraryType = parameterType;
            DSLExpression.Call resolveCall = new DSLExpression.Call(null, "resolve", Arrays.asList(new DSLExpression.ClassLiteral(usedLibraryType)));
            DSLExpressionResolver cachedResolver = this.importStatics(resolver, this.types.LibraryFactory);
            DSLExpression defaultExpression = new DSLExpression.Call(resolveCall, "create", Arrays.asList(receiverExpression));
            defaultExpression = this.resolveCachedExpression(cachedResolver, cachedLibrary, libraryType, defaultExpression, expression);
            cachedLibrary.setDefaultExpression(defaultExpression);
            DSLExpression uncachedExpression = new DSLExpression.Call(resolveCall, "getUncached", Arrays.asList(receiverExpression));
            cachedLibrary.setUncachedExpression(uncachedExpression);
            uncachedExpression = this.resolveCachedExpression(cachedResolver, cachedLibrary, libraryType, uncachedExpression, expression);
            if (uncachedLibrary == null) continue;
            uncachedLibrary.setDefaultExpression(uncachedExpression);
            uncachedLibrary.setUncachedExpression(uncachedExpression);
            uncachedLibrary.setAlwaysInitialized(true);
            uncachedLibrary.setRequiresBoundary(true);
        }
        if (!libraries.isEmpty() && !specialization.hasErrors() && ElementUtils.getAnnotationValue(specialization.getMarkerAnnotation(), "limit", false) == null && specialization.hasMultipleInstances()) {
            specialization.addError("The limit attribute must be specified if @%s is used with a dynamic parameter. E.g. add limit=\"3\" to resolve this.", this.types.CachedLibrary.asElement().getSimpleName().toString());
        }
        if (!seenDynamicParameterBound) {
            return null;
        }
        return uncachedSpecialization;
    }

    private static boolean supportsLibraryMerge(DSLExpression receiverExpression, VariableElement receiverParameter) {
        Set<VariableElement> vars = receiverExpression.findBoundVariableElements();
        if (vars.size() == 1 && vars.contains(receiverParameter)) {
            final AtomicBoolean supportsMerge = new AtomicBoolean(true);
            receiverExpression.accept(new DSLExpression.AbstractDSLExpressionVisitor(){

                @Override
                public void visitCall(DSLExpression.Call binary) {
                    supportsMerge.set(false);
                }

                @Override
                public void visitVariable(DSLExpression.Variable binary) {
                    if (binary.getReceiver() != null && binary.getResolvedVariable().getKind() == ElementKind.FIELD && !binary.getResolvedVariable().getModifiers().contains((Object)Modifier.FINAL)) {
                        supportsMerge.set(false);
                    }
                }
            });
            return supportsMerge.get();
        }
        return false;
    }

    private void parseCached(CacheExpression cache, SpecializationData specialization, DSLExpressionResolver originalResolver, Parameter parameter) {
        TypeMirror type;
        boolean uncachedSpecified;
        boolean requireUncached;
        DSLExpressionResolver resolver = originalResolver;
        AnnotationMirror cachedAnnotation = cache.getMessageAnnotation();
        AnnotationValue adopt = null;
        if (!cache.hasErrors()) {
            boolean disabledAdopt;
            adopt = ElementUtils.getAnnotationValue(cachedAnnotation, "adopt", false);
            AnnotationMirror cached = ElementUtils.findAnnotationMirror((Element)cache.getParameter().getVariableElement(), (TypeMirror)this.types.Cached);
            cache.setDimensions(ElementUtils.getAnnotationValue(Integer.class, cached, "dimensions"));
            boolean bl = disabledAdopt = adopt != null && Boolean.FALSE.equals(adopt.getValue());
            if (parameter.getType().getKind() == TypeKind.ARRAY && (disabledAdopt || !ElementUtils.isSubtype(((ArrayType)parameter.getType()).getComponentType(), this.types.NodeInterface))) {
                if (cache.getDimensions() == -1) {
                    cache.addWarning("The cached dimensions attribute must be specified for array types.", new Object[0]);
                }
            } else if (!disabledAdopt && cache.getDimensions() != -1) {
                cache.addError("The dimensions attribute has no affect for the type %s.", ElementUtils.getSimpleName(parameter.getType()));
            }
        }
        List<String> expressionParameters = ElementUtils.getAnnotationValueList(String.class, cachedAnnotation, "parameters");
        String initializer = ElementUtils.getAnnotationValue(String.class, cachedAnnotation, "value");
        String uncached = ElementUtils.getAnnotationValue(String.class, cachedAnnotation, "uncached");
        String parameters = "";
        if (!expressionParameters.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < expressionParameters.size(); ++i) {
                String param = expressionParameters.get(i);
                b.append(param);
                if (i == 0) continue;
                b.append(", ");
            }
            parameters = b.toString();
        }
        initializer = initializer.replace("$parameters", parameters);
        uncached = uncached.replace("$parameters", parameters);
        if (ElementUtils.isAssignable(parameter.getType(), this.types.Library) && !ElementUtils.typeEquals(parameter.getType(), this.types.Library)) {
            cache.addError("The use of @%s is not supported for libraries. Use @%s instead.", this.types.Cached.asElement().getSimpleName().toString(), this.types.CachedLibrary.asElement().getSimpleName().toString());
        } else if (NodeCodeGenerator.isSpecializedNode(parameter.getType())) {
            NodeData parsedNode;
            NodeParser parser = NodeParser.createDefaultParser();
            parser.nodeOnly = true;
            TypeElement element = ElementUtils.castTypeElement(parameter.getType());
            if (!this.nodeOnly && (parsedNode = (NodeData)parser.parse(element)) != null) {
                List<CodeExecutableElement> executables = NodeFactoryFactory.createFactoryMethods(parsedNode, ElementFilter.constructorsIn(element.getEnclosedElements()));
                TypeElement type2 = ElementUtils.castTypeElement(NodeCodeGenerator.factoryOrNodeType(parsedNode));
                for (CodeExecutableElement executableElement : executables) {
                    executableElement.setEnclosingElement(type2);
                }
                resolver = resolver.copy(executables);
            }
        }
        if (!cache.hasErrors()) {
            cache.setDefaultExpression(this.parseCachedExpression(resolver, cache, parameter.getType(), initializer));
        }
        boolean bl = requireUncached = specialization.getNode().isGenerateUncached() || this.mode == ParseMode.EXPORTED_MESSAGE;
        if (cache.hasErrors()) {
            return;
        }
        boolean bl2 = uncachedSpecified = ElementUtils.getAnnotationValue(cachedAnnotation, "uncached", false) != null;
        if (requireUncached) {
            boolean allowUncached = ElementUtils.getAnnotationValue(Boolean.class, cachedAnnotation, "allowUncached");
            if (uncachedSpecified && allowUncached) {
                cache.addError("The attributes 'allowUncached' and 'uncached' are mutually exclusive. Remove one of the attributes to resolve this.", new Object[0]);
            } else if (allowUncached) {
                cache.setUncachedExpression(cache.getDefaultExpression());
            } else if (!uncachedSpecified && cache.getDefaultExpression() != null && !cache.getDefaultExpression().mayAllocate()) {
                cache.setUncachedExpression(cache.getDefaultExpression());
            } else {
                cache.setUncachedExpression(this.parseCachedExpression(resolver, cache, parameter.getType(), uncached));
                if (!uncachedSpecified && cache.hasErrors()) {
                    cache.setUncachedExpressionError(cache.getMessages().iterator().next());
                    cache.getMessages().clear();
                }
            }
        }
        if (requireUncached && cache.getUncachedExpression() == null && cache.getDefaultExpression() != null && specialization.isTrivialExpression(cache.getDefaultExpression())) {
            cache.setUncachedExpression(cache.getDefaultExpression());
        }
        if (!(adopt == null || (type = parameter.getType()) != null && (ElementUtils.isAssignable(type, this.types.NodeInterface) || type.getKind() == TypeKind.ARRAY && ElementUtils.isAssignable(((ArrayType)type).getComponentType(), this.types.NodeInterface)))) {
            cache.addError("Type '%s' is neither a NodeInterface type, nor an array of NodeInterface types and therefore it can not be adopted. Remove the adopt attribute to resolve this.", Objects.toString(type));
        }
        cache.setAdopt(ElementUtils.getAnnotationValue(Boolean.class, cachedAnnotation, "adopt", true));
    }

    private DSLExpression resolveCachedExpression(DSLExpressionResolver resolver, CacheExpression cache, TypeMirror targetType, DSLExpression expression, String originalString) {
        DSLExpressionResolver localResolver = targetType == null ? resolver : this.importStatics(resolver, targetType);
        try {
            expression.accept(localResolver);
        }
        catch (InvalidExpressionException e) {
            cache.addError("Error parsing expression '%s': %s", originalString, e.getMessage());
            return null;
        }
        if (targetType == null || ElementUtils.isAssignable(expression.getResolvedType(), targetType)) {
            return expression;
        }
        cache.addError("Incompatible return type %s. The expression type must be equal to the parameter type %s.", ElementUtils.getSimpleName(expression.getResolvedType()), ElementUtils.getSimpleName(targetType));
        return null;
    }

    private DSLExpressionResolver importStatics(DSLExpressionResolver resolver, TypeMirror targetType) {
        DSLExpressionResolver localResolver = resolver;
        if (targetType.getKind() == TypeKind.DECLARED) {
            List<Element> prefixedImports = this.importVisibleStaticMembersImpl(resolver.getAccessType(), ElementUtils.fromTypeMirror(targetType), true);
            localResolver = localResolver.copy(prefixedImports);
        }
        return localResolver;
    }

    private DSLExpression parseCachedExpression(DSLExpressionResolver resolver, CacheExpression cache, TypeMirror targetType, String string) {
        try {
            return this.resolveCachedExpression(resolver, cache, targetType, DSLExpression.parse(string), string);
        }
        catch (InvalidExpressionException e) {
            cache.addError("Error parsing expression '%s': %s", string, e.getMessage());
            return null;
        }
    }

    private void initializeGuards(SpecializationData specialization, DSLExpressionResolver resolver) {
        List<String> guardDefinitions = ElementUtils.getAnnotationValueList(String.class, specialization.getMarkerAnnotation(), "guards");
        HashSet<CacheExpression> handledCaches = new HashSet<CacheExpression>();
        ArrayList<GuardExpression> guards = new ArrayList<GuardExpression>();
        for (String guardExpression : guardDefinitions) {
            GuardExpression guard = this.parseGuard(resolver, specialization, guardExpression);
            if (guard.getExpression() != null) {
                Set<CacheExpression> caches = specialization.getBoundCaches(guard.getExpression(), false);
                for (CacheExpression cache : caches) {
                    if (handledCaches.contains(cache) || !cache.isGuardForNull()) continue;
                    guards.add(this.createWeakReferenceGuard(resolver, specialization, cache));
                }
                handledCaches.addAll(caches);
            }
            guards.add(guard);
        }
        for (CacheExpression cache : specialization.getCaches()) {
            if (!cache.isGuardForNull() || handledCaches.contains(cache)) continue;
            guards.add(this.createWeakReferenceGuard(resolver, specialization, cache));
        }
        specialization.getGuards().addAll(guards);
    }

    private GuardExpression createWeakReferenceGuard(DSLExpressionResolver resolver, SpecializationData specialization, CacheExpression cache) {
        GuardExpression guard = this.parseGuard(resolver, specialization, cache.getParameter().getLocalName() + " != null");
        guard.setWeakReferenceGuard(true);
        return guard;
    }

    private GuardExpression parseGuard(DSLExpressionResolver resolver, SpecializationData specialization, String guard) {
        GuardExpression guardExpression;
        TypeMirror booleanType = this.context.getType(Boolean.TYPE);
        try {
            DSLExpression expression = DSLExpression.parse(guard);
            expression.accept(resolver);
            guardExpression = new GuardExpression(specialization, expression);
            if (!ElementUtils.typeEquals(expression.getResolvedType(), booleanType)) {
                guardExpression.addError("Incompatible return type %s. Guards must return %s.", ElementUtils.getSimpleName(expression.getResolvedType()), ElementUtils.getSimpleName(booleanType));
            }
        }
        catch (InvalidExpressionException e) {
            guardExpression = new GuardExpression(specialization, null);
            guardExpression.addError("Error parsing expression '%s': %s", guard, e.getMessage());
        }
        return guardExpression;
    }

    private void initializeGeneric(NodeData node) {
        ArrayList<SpecializationData> generics = new ArrayList<SpecializationData>();
        for (SpecializationData spec : node.getSpecializations()) {
            if (!spec.isFallback()) continue;
            generics.add(spec);
        }
        if (generics.size() == 1 && node.getSpecializations().size() == 1) {
            for (SpecializationData generic : generics) {
                generic.addError("@%s defined but no @%s.", this.types.Fallback.asElement().getSimpleName().toString(), this.types.Specialization.asElement().getSimpleName().toString());
            }
        }
        if (generics.isEmpty()) {
            node.getSpecializations().add(this.createGenericSpecialization(node));
        } else if (generics.size() > 1) {
            for (SpecializationData generic : generics) {
                generic.addError("Only one @%s is allowed per operation.", this.types.Fallback.asElement().getSimpleName().toString());
            }
        }
    }

    private SpecializationData createGenericSpecialization(NodeData node) {
        FallbackParser parser = new FallbackParser(this.context, node);
        MethodSpec specification = parser.createDefaultMethodSpec(node.getSpecializations().iterator().next().getMethod(), null, true, null);
        ArrayList<VariableElement> parameterTypes = new ArrayList<VariableElement>();
        int signatureIndex = 1;
        for (ParameterSpec spec : specification.getRequired()) {
            parameterTypes.add(new CodeVariableElement(this.createGenericType(node, spec), "arg" + signatureIndex));
            if (!spec.isSignature()) continue;
            ++signatureIndex;
        }
        TypeMirror returnType = this.createGenericType(node, specification.getReturnType());
        SpecializationData generic = (SpecializationData)parser.create("Generic", -1, null, null, returnType, parameterTypes);
        if (generic == null) {
            throw new RuntimeException("Unable to create generic signature for node " + node.getNodeId() + " with " + parameterTypes + ". Specification " + specification + ".");
        }
        return generic;
    }

    private TypeMirror createGenericType(NodeData node, ParameterSpec spec) {
        NodeExecutionData execution = spec.getExecution();
        Collection<TypeMirror> allowedTypes = execution == null ? spec.getAllowedTypes() : Arrays.asList(node.getGenericType(execution));
        if (allowedTypes.size() == 1) {
            return allowedTypes.iterator().next();
        }
        return ElementUtils.getCommonSuperType(this.context, allowedTypes);
    }

    private static void initializeUninitialized(NodeData node) {
        SpecializationData generic = node.getGenericSpecialization();
        if (generic == null) {
            return;
        }
        TemplateMethod uninializedMethod = new TemplateMethod("Uninitialized", -1, node, generic.getSpecification(), null, null, generic.getReturnType(), generic.getParameters());
        uninializedMethod.getMessages().clear();
        node.getSpecializations().add(new SpecializationData(node, uninializedMethod, SpecializationData.SpecializationKind.UNINITIALIZED));
    }

    private void initializePolymorphism(NodeData node) {
        SpecializationData generic = node.getGenericSpecialization();
        ArrayList<VariableElement> foundTypes = new ArrayList<VariableElement>();
        Collection<TypeMirror> frameTypes = new HashSet<TypeMirror>();
        for (SpecializationData specialization : node.getSpecializations()) {
            if (specialization.getFrame() == null) continue;
            frameTypes.add(specialization.getFrame().getType());
        }
        if (node.supportsFrame()) {
            frameTypes.add(node.getFrameType());
        }
        if (!frameTypes.isEmpty()) {
            TypeMirror frameType = (frameTypes = ElementUtils.uniqueSortedTypes(frameTypes, false)).size() == 1 ? frameTypes.iterator().next() : this.types.Frame;
            foundTypes.add(new CodeVariableElement(frameType, "frameValue"));
        }
        TypeMirror returnType = null;
        int index = 0;
        for (Parameter genericParameter : generic.getReturnTypeAndParameters()) {
            TypeMirror polymorphicType;
            boolean isReturnParameter;
            if (genericParameter.getLocalName().equals("frameValue")) continue;
            boolean bl = isReturnParameter = genericParameter == generic.getReturnType();
            if (!genericParameter.getSpecification().isSignature()) {
                polymorphicType = genericParameter.getType();
            } else {
                NodeExecutionData execution = genericParameter.getSpecification().getExecution();
                Collection<TypeMirror> usedTypes = new HashSet<TypeMirror>();
                for (SpecializationData specialization : node.getSpecializations()) {
                    Parameter parameter;
                    if (specialization.isUninitialized() || (parameter = specialization.findParameter(genericParameter.getLocalName())) == specialization.getReturnType() && specialization.isFallback() && specialization.getMethod() == null) continue;
                    if (parameter == null) {
                        throw new AssertionError((Object)("Parameter existed in generic specialization but not in specialized. param = " + genericParameter.getLocalName()));
                    }
                    if (isReturnParameter && specialization.hasUnexpectedResultRewrite()) {
                        if (!ElementUtils.isSubtypeBoxed(this.context, this.context.getType(Object.class), node.getGenericType(execution))) {
                            specialization.addError("Implicit 'Object' return type from UnexpectedResultException not compatible with generic type '%s'.", node.getGenericType(execution));
                        } else {
                            usedTypes.add(this.context.getType(Object.class));
                        }
                    }
                    usedTypes.add(parameter.getType());
                }
                polymorphicType = (usedTypes = ElementUtils.uniqueSortedTypes(usedTypes, false)).size() == 1 ? usedTypes.iterator().next() : ElementUtils.getCommonSuperType(this.context, usedTypes);
                if (execution != null && !ElementUtils.isSubtypeBoxed(this.context, polymorphicType, node.getGenericType(execution))) {
                    throw new AssertionError((Object)String.format("Polymorphic types %s not compatible to generic type %s.", polymorphicType, node.getGenericType(execution)));
                }
            }
            if (isReturnParameter) {
                returnType = polymorphicType;
            } else {
                foundTypes.add(new CodeVariableElement(polymorphicType, "param" + index));
            }
            ++index;
        }
        SpecializationMethodParser parser = new SpecializationMethodParser(this.context, node, this.mode == ParseMode.EXPORTED_MESSAGE);
        SpecializationData polymorphic = (SpecializationData)parser.create("Polymorphic", -1, null, null, returnType, foundTypes);
        if (polymorphic == null) {
            throw new AssertionError((Object)("Failed to parse polymorphic signature. " + parser.createDefaultMethodSpec(null, null, false, null) + " Types: " + returnType + " - " + foundTypes));
        }
        polymorphic.setKind(SpecializationData.SpecializationKind.POLYMORPHIC);
        node.getSpecializations().add(polymorphic);
    }

    private static boolean verifySpecializationSameLength(NodeData nodeData) {
        int lastArgs = -1;
        for (SpecializationData specializationData : nodeData.getSpecializations()) {
            int signatureArgs = specializationData.getSignatureSize();
            if (lastArgs == signatureArgs) continue;
            if (lastArgs != -1) {
                for (SpecializationData specialization : nodeData.getSpecializations()) {
                    specialization.addError("All specializations must have the same number of arguments.", new Object[0]);
                }
                return false;
            }
            lastArgs = signatureArgs;
        }
        return true;
    }

    private void verifyVisibilities(NodeData node) {
        if (node.getTemplateType().getModifiers().contains((Object)Modifier.PRIVATE) && node.getSpecializations().size() > 0) {
            node.addError("Classes containing a @%s annotation must not be private.", this.types.Specialization.asElement().getSimpleName().toString());
        }
    }

    private static List<Element> newElementList(List<? extends Element> src) {
        ArrayList<Element> workaround = new ArrayList<Element>(src);
        return workaround;
    }

    private static void verifyMissingAbstractMethods(NodeData nodeData, List<? extends Element> originalElements) {
        if (!nodeData.needsFactory()) {
            return;
        }
        List<Element> elements = NodeParser.newElementList(originalElements);
        HashSet<Element> unusedElements = new HashSet<Element>(elements);
        for (ExecutableElement method : nodeData.getAllTemplateMethods()) {
            unusedElements.remove(method);
        }
        for (NodeFieldData field : nodeData.getFields()) {
            if (field.getGetter() != null) {
                unusedElements.remove(field.getGetter());
            }
            if (field.getSetter() == null) continue;
            unusedElements.remove(field.getSetter());
        }
        for (NodeChildData child : nodeData.getChildren()) {
            if (child.getAccessElement() == null) continue;
            unusedElements.remove(child.getAccessElement());
        }
        HashMap<String, ArrayList<ExecutableElement>> methodsByName = null;
        block3: for (ExecutableElement unusedMethod : ElementFilter.methodsIn(unusedElements)) {
            if (!unusedMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            if (methodsByName == null) {
                methodsByName = new HashMap<String, ArrayList<ExecutableElement>>();
                for (ExecutableElement m : ElementFilter.methodsIn(unusedElements)) {
                    String name = m.getSimpleName().toString();
                    ArrayList<ExecutableElement> groupedElements = (ArrayList<ExecutableElement>)methodsByName.get(name);
                    if (groupedElements == null) {
                        groupedElements = new ArrayList<ExecutableElement>();
                        methodsByName.put(name, groupedElements);
                    }
                    groupedElements.add(m);
                }
            }
            for (ExecutableElement otherMethod : (List)methodsByName.get(unusedMethod.getSimpleName().toString())) {
                if (unusedMethod == otherMethod || !ProcessorContext.getInstance().getEnvironment().getElementUtils().overrides(otherMethod, unusedMethod, nodeData.getTemplateType())) continue;
                continue block3;
            }
            nodeData.addError("The type %s must implement the inherited abstract method %s.", ElementUtils.getSimpleName(nodeData.getTemplateType()), ElementUtils.getReadableSignature(unusedMethod));
        }
    }

    private static void verifySpecializationThrows(NodeData node) {
        HashMap<String, SpecializationData> specializationMap = new HashMap<String, SpecializationData>();
        for (SpecializationData spec : node.getSpecializations()) {
            specializationMap.put(spec.getMethodName(), spec);
        }
        for (SpecializationData sourceSpecialization : node.getSpecializations()) {
            if (sourceSpecialization.getExceptions() == null) continue;
            for (SpecializationThrowsData throwsData : sourceSpecialization.getExceptions()) {
                for (SpecializationThrowsData otherThrowsData : sourceSpecialization.getExceptions()) {
                    if (otherThrowsData == throwsData || !ElementUtils.typeEquals(otherThrowsData.getJavaClass(), throwsData.getJavaClass())) continue;
                    throwsData.addError("Duplicate exception type.", new Object[0]);
                }
            }
        }
    }

    private static void verifyFrame(NodeData node) {
        List<NodeExecutionData> childExecutions = node.getChildExecutions();
        ExecutableTypeData[] requiresFrameParameter = new ExecutableTypeData[childExecutions.size()];
        boolean needsCheck = false;
        block0: for (int i = 0; i < childExecutions.size(); ++i) {
            NodeChildData childExecution = childExecutions.get(i).getChild();
            if (childExecution == null) continue;
            for (ExecutableTypeData executable : childExecution.getNodeData().getExecutableTypes()) {
                if (executable.getFrameParameter() == null) continue;
                requiresFrameParameter[i] = executable;
                needsCheck = true;
                continue block0;
            }
        }
        if (needsCheck) {
            for (ExecutableTypeData executable : node.getExecutableTypes()) {
                if (executable.getFrameParameter() != null) continue;
                for (int executionIndex = executable.getEvaluatedCount(); executionIndex < node.getExecutionCount(); ++executionIndex) {
                    if (requiresFrameParameter[executionIndex] == null) continue;
                    node.addError(String.format("Child execution method: %s called from method: %s requires a frame parameter.", NodeParser.createMethodSignature(requiresFrameParameter[executionIndex].getMethod()), NodeParser.createMethodSignature(executable.getMethod())), new Object[0]);
                }
            }
        }
    }

    private static String createMethodSignature(ExecutableElement method) {
        StringBuilder result = new StringBuilder();
        result.append(ElementUtils.getSimpleName(method.getReturnType())).append(' ').append(ElementUtils.getSimpleName((TypeElement)method.getEnclosingElement())).append("::").append(method.getSimpleName()).append('(');
        boolean first = true;
        for (VariableElement variableElement : method.getParameters()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(ElementUtils.getSimpleName(variableElement.asType()));
        }
        result.append(')');
        return result.toString();
    }

    private static void verifyConstructors(NodeData nodeData) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(nodeData.getTemplateType().getEnclosedElements());
        if (constructors.isEmpty()) {
            return;
        }
        boolean oneNonPrivate = false;
        for (ExecutableElement constructor : constructors) {
            if (ElementUtils.getVisibility(constructor.getModifiers()) == Modifier.PRIVATE) continue;
            oneNonPrivate = true;
            break;
        }
        if (!oneNonPrivate && !nodeData.getTemplateType().getModifiers().contains((Object)Modifier.PRIVATE)) {
            nodeData.addError("At least one constructor must be non-private.", new Object[0]);
        }
    }

    private static AnnotationMirror findFirstAnnotation(List<? extends Element> elements, DeclaredType annotation) {
        for (Element element : elements) {
            AnnotationMirror mirror = ElementUtils.findAnnotationMirror(element, (TypeMirror)annotation);
            if (mirror == null) continue;
            return mirror;
        }
        return null;
    }

    private TypeMirror inheritType(AnnotationMirror annotation, String valueName, TypeMirror parentType) {
        DeclaredType inhertNodeType = this.types.Node;
        TypeMirror value = ElementUtils.getAnnotationValue(TypeMirror.class, annotation, valueName);
        if (ElementUtils.typeEquals(inhertNodeType, value)) {
            return parentType;
        }
        return value;
    }

    private ExecutableElement findGetter(List<? extends Element> elements, String variableName, TypeMirror type) {
        if (type == null) {
            return null;
        }
        String methodName = ElementUtils.typeEquals(type, this.context.getType(Boolean.TYPE)) ? "is" + ElementUtils.firstLetterUpperCase(variableName) : "get" + ElementUtils.firstLetterUpperCase(variableName);
        for (ExecutableElement method : ElementFilter.methodsIn(elements)) {
            if (!method.getSimpleName().toString().equals(methodName) || method.getParameters().size() != 0 || !ElementUtils.isAssignable(type, method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    private static ExecutableElement findSetter(List<? extends Element> elements, String variableName, TypeMirror type) {
        if (type == null) {
            return null;
        }
        String methodName = "set" + ElementUtils.firstLetterUpperCase(variableName);
        for (ExecutableElement method : ElementFilter.methodsIn(elements)) {
            if (!method.getSimpleName().toString().equals(methodName) || method.getParameters().size() != 1 || !ElementUtils.typeEquals(type, method.getParameters().get(0).asType())) continue;
            return method;
        }
        return null;
    }

    private static List<TypeElement> collectSuperClasses(List<TypeElement> collection, TypeElement element) {
        if (element != null) {
            collection.add(element);
            if (element.getSuperclass() != null) {
                NodeParser.collectSuperClasses(collection, ElementUtils.fromTypeMirror(element.getSuperclass()));
            }
        }
        return collection;
    }

    private static Map<SharableCache, Collection<CacheExpression>> computeSharableCaches(Collection<NodeData> nodes) {
        LinkedHashMap<SharableCache, Collection<CacheExpression>> sharableCaches = new LinkedHashMap<SharableCache, Collection<CacheExpression>>();
        for (NodeData node : nodes) {
            for (SpecializationData specialization : node.getSpecializations()) {
                if (specialization == null) continue;
                for (CacheExpression cache : specialization.getCaches()) {
                    if (cache.isAlwaysInitialized() || cache.isCachedLibrary()) continue;
                    SharableCache sharable = new SharableCache(specialization, cache);
                    sharableCaches.computeIfAbsent(sharable, c -> new ArrayList()).add(cache);
                }
            }
        }
        return sharableCaches;
    }

    private static final class SharableCache {
        private final SpecializationData specialization;
        private final CacheExpression expression;
        private final int hashCode;

        SharableCache(SpecializationData specialization, CacheExpression expression) {
            this.specialization = specialization;
            this.expression = expression;
            this.hashCode = Objects.hash(expression.getParameter().getType(), DSLExpressionHash.compute(expression.getDefaultExpression()), DSLExpressionHash.compute(expression.getUncachedExpression()));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SharableCache)) {
                return false;
            }
            SharableCache other = (SharableCache)obj;
            if (this == obj) {
                return true;
            }
            if (ElementUtils.executableEquals(this.specialization.getMethod(), other.specialization.getMethod()) && !this.specialization.hasMultipleInstances() && !other.specialization.hasMultipleInstances() && ElementUtils.variableEquals(this.expression.getParameter().getVariableElement(), other.expression.getParameter().getVariableElement())) {
                return true;
            }
            String reason = this.equalsWithReasonImpl(other, false);
            if (reason == null) {
                if (this.hashCode != other.hashCode) {
                    throw new AssertionError();
                }
                return true;
            }
            return false;
        }

        private String equalsWithReasonImpl(SharableCache other, boolean generateMessage) {
            TypeMirror thisParametertype = this.expression.getParameter().getType();
            TypeMirror otherParametertype = other.expression.getParameter().getType();
            if (this.specialization == other.specialization) {
                if (!generateMessage) {
                    return "";
                }
                return "Cannot share caches within the same specialization.";
            }
            if (!ElementUtils.typeEquals(thisParametertype, otherParametertype)) {
                if (!generateMessage) {
                    return "";
                }
                return String.format("The cache parameter type does not match. Expected '%s' but was '%s'.", ElementUtils.getSimpleName(thisParametertype), ElementUtils.getSimpleName(otherParametertype));
            }
            if (!this.equalsExpression(this.expression.getDefaultExpression(), other.specialization, other.expression.getDefaultExpression())) {
                if (!generateMessage) {
                    return "";
                }
                return String.format("The cache initializer does not match.", new Object[0]);
            }
            if (!this.equalsExpression(this.expression.getUncachedExpression(), other.specialization, other.expression.getUncachedExpression())) {
                if (!generateMessage) {
                    return "";
                }
                return String.format("The uncached initializer does not match.", new Object[0]);
            }
            if (this.specialization.hasMultipleInstances()) {
                if (!generateMessage) {
                    return "";
                }
                return String.format("The specialization '%s' has multiple instances.", ElementUtils.getReadableSignature(this.specialization.getMethod()));
            }
            if (other.specialization.hasMultipleInstances()) {
                if (!generateMessage) {
                    return "";
                }
                return String.format("The specialization '%s' has multiple instances.", ElementUtils.getReadableSignature(other.specialization.getMethod()));
            }
            return null;
        }

        String equalsWithReason(SharableCache other) {
            return this.equalsWithReasonImpl(other, true);
        }

        private boolean equalsExpression(DSLExpression thisExpression, SpecializationData otherSpecialization, DSLExpression otherExpression) {
            if (thisExpression == null && otherExpression == null) {
                return true;
            }
            if (thisExpression == null || otherExpression == null) {
                return false;
            }
            List<DSLExpression> otherExpressions = thisExpression.flatten();
            List<DSLExpression> expressions = otherExpression.flatten();
            if (otherExpressions.size() != expressions.size()) {
                return false;
            }
            Iterator<DSLExpression> otherExpressionIterator = expressions.iterator();
            Iterator<DSLExpression> thisExpressionIterator = otherExpressions.iterator();
            while (otherExpressionIterator.hasNext()) {
                Object var2;
                Object var1;
                DSLExpression e1 = thisExpressionIterator.next();
                DSLExpression e2 = otherExpressionIterator.next();
                if (e1.getClass() != e2.getClass()) {
                    return false;
                }
                if (e1 instanceof DSLExpression.Variable) {
                    var1 = ((DSLExpression.Variable)e1).getResolvedVariable();
                    var2 = ((DSLExpression.Variable)e2).getResolvedVariable();
                    if (var1.getKind() == ElementKind.PARAMETER && var2.getKind() == ElementKind.PARAMETER) {
                        Parameter p1 = this.specialization.findByVariable((VariableElement)var1);
                        Parameter p2 = otherSpecialization.findByVariable((VariableElement)var2);
                        if (p1 != null && p2 != null) {
                            NodeExecutionData execution1 = p1.getSpecification().getExecution();
                            NodeExecutionData execution2 = p2.getSpecification().getExecution();
                            if (execution1 != null && execution2 != null && execution1.getIndex() == execution2.getIndex()) continue;
                        }
                    }
                    if (ElementUtils.variableEquals((VariableElement)var1, (VariableElement)var2)) continue;
                    return false;
                }
                if (e1 instanceof DSLExpression.Call) {
                    var1 = ((DSLExpression.Call)e1).getResolvedMethod();
                    if (ElementUtils.executableEquals((ExecutableElement)var1, (ExecutableElement)(var2 = ((DSLExpression.Call)e2).getResolvedMethod()))) continue;
                    return false;
                }
                if (e1 instanceof DSLExpression.Binary) {
                    var1 = ((DSLExpression.Binary)e1).getOperator();
                    if (Objects.equals(var1, var2 = ((DSLExpression.Binary)e2).getOperator())) continue;
                    return false;
                }
                if (e1 instanceof DSLExpression.Negate) {
                    assert (e2 instanceof DSLExpression.Negate);
                    continue;
                }
                if (e1.equals(e2)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static class DSLExpressionHash
        implements DSLExpression.DSLExpressionVisitor {
            private int hash = 1;

            private DSLExpressionHash() {
            }

            @Override
            public void visitCast(DSLExpression.Cast binary) {
                this.hash *= binary.getCastType().hashCode();
            }

            @Override
            public void visitVariable(DSLExpression.Variable binary) {
                this.hash *= 31;
            }

            @Override
            public void visitNegate(DSLExpression.Negate negate) {
                this.hash *= 31;
            }

            @Override
            public void visitIntLiteral(DSLExpression.IntLiteral binary) {
                this.hash *= 31 + binary.getResolvedValueInt();
            }

            @Override
            public void visitClassLiteral(DSLExpression.ClassLiteral classLiteral) {
                this.hash *= 31 + Objects.hash(classLiteral.getResolvedType());
            }

            @Override
            public void visitCall(DSLExpression.Call binary) {
                this.hash *= 31 + Objects.hash(binary.getName());
            }

            @Override
            public void visitBooleanLiteral(DSLExpression.BooleanLiteral binary) {
                this.hash *= 31 + Objects.hash(binary.getLiteral());
            }

            @Override
            public void visitBinary(DSLExpression.Binary binary) {
                this.hash *= 31 + Objects.hash(binary.getOperator());
            }

            static int compute(DSLExpression e) {
                if (e == null) {
                    return 1;
                }
                DSLExpressionHash hash = new DSLExpressionHash();
                e.accept(hash);
                return hash.hash;
            }
        }
    }

    private static class ImportsKey {
        private final TypeElement relativeTo;
        private final TypeElement importGuardsClass;
        private final boolean includeConstructors;

        ImportsKey(TypeElement relativeTo, TypeElement importGuardsClass, boolean includeConstructors) {
            this.relativeTo = relativeTo;
            this.importGuardsClass = importGuardsClass;
            this.includeConstructors = includeConstructors;
        }

        public int hashCode() {
            return Objects.hash(this.relativeTo, this.importGuardsClass, this.includeConstructors);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImportsKey) {
                ImportsKey other = (ImportsKey)obj;
                return Objects.equals(this.relativeTo, other.relativeTo) && Objects.equals(this.importGuardsClass, other.importGuardsClass) && Objects.equals(this.includeConstructors, other.includeConstructors);
            }
            return false;
        }
    }

    public static enum ParseMode {
        DEFAULT,
        EXPORTED_MESSAGE;

    }
}

