/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeImport;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner8;

public abstract class CodeElementScanner<R, P>
extends ElementScanner8<R, P> {
    @Override
    public final R visitExecutable(ExecutableElement e, P p) {
        if (!(e instanceof CodeExecutableElement)) {
            throw new ClassCastException(e.toString());
        }
        return this.visitExecutable(CodeElementScanner.cast(e, CodeExecutableElement.class), p);
    }

    public R visitExecutable(CodeExecutableElement e, P p) {
        Object ret = super.visitExecutable(e, p);
        if (e.getBodyTree() != null) {
            this.visitTree(e.getBodyTree(), p, e);
        }
        return ret;
    }

    @Override
    public R visitVariable(VariableElement e, P p) {
        CodeTree init;
        if (e instanceof CodeVariableElement && (init = ((CodeVariableElement)e).getInit()) != null) {
            this.visitTree(init, p, e);
        }
        return super.visitVariable(e, p);
    }

    @Override
    public R visitPackage(PackageElement e, P p) {
        return super.visitPackage(e, p);
    }

    @Override
    public final R visitType(TypeElement e, P p) {
        return this.visitType(CodeElementScanner.cast(e, CodeTypeElement.class), p);
    }

    public R visitType(CodeTypeElement e, P p) {
        return super.visitType(e, p);
    }

    @Override
    public R visitTypeParameter(TypeParameterElement e, P p) {
        return super.visitTypeParameter(e, p);
    }

    private static <E> E cast(Element element, Class<E> clazz) {
        return clazz.cast(element);
    }

    public void visitTree(CodeTree e, P p, Element parent) {
        List<CodeTree> elements = e.getEnclosedElements();
        if (elements != null) {
            for (CodeTree tree : e.getEnclosedElements()) {
                this.visitTree(tree, p, parent);
            }
        }
    }

    public void visitImport(CodeImport e, P p) {
    }
}

