/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.model.CodeTreeKind;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public class CodeTree {
    private final CodeTreeKind kind;
    private CodeTree parent;
    private TypeMirror type;
    private final String string;
    private List<CodeTree> children;

    CodeTree(CodeTree parent, CodeTreeKind kind, TypeMirror type, String string) {
        this.parent = parent;
        this.kind = kind;
        this.type = type;
        this.string = string;
    }

    public void setParent(CodeTree parent) {
        this.parent = parent;
    }

    public CodeTree getParent() {
        return this.parent;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public void add(CodeTree element) {
        if (this.children == null) {
            this.children = new ArrayList<CodeTree>();
        }
        element.setParent(this);
        this.children.add(element);
    }

    public final List<CodeTree> getEnclosedElements() {
        return this.children;
    }

    public final CodeTreeKind getCodeKind() {
        return this.kind;
    }

    public String getString() {
        return this.string;
    }

    public void setType(TypeMirror type) {
        this.type = type;
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    public boolean containsKind(CodeTreeKind k) {
        if (this.kind == k) {
            return true;
        }
        if (this.children != null) {
            for (CodeTree child : this.children) {
                if (!child.containsKind(k)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSingleLine() {
        return !this.containsKind(CodeTreeKind.NEW_LINE);
    }
}

