/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import java.util.Arrays;
import java.util.Collection;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class ParameterSpec {
    private final String name;
    private final Collection<TypeMirror> allowedTypes;
    private final boolean anyType;
    private boolean local;
    private boolean signature;
    private boolean allowSubclasses = true;
    private NodeExecutionData execution;
    private MethodSpec.TypeDef typeDefinition;

    public ParameterSpec(String name, Collection<TypeMirror> allowedTypes) {
        this.name = name;
        this.allowedTypes = allowedTypes;
        boolean anyTypeTemp = false;
        for (TypeMirror type : allowedTypes) {
            if (!ElementUtils.isObject(type)) continue;
            anyTypeTemp = true;
            break;
        }
        this.anyType = anyTypeTemp;
    }

    public boolean isCached() {
        return false;
    }

    public ParameterSpec(String name, TypeMirror type) {
        this(name, Arrays.asList(type));
    }

    public void setAllowSubclasses(boolean allowSubclasses) {
        this.allowSubclasses = allowSubclasses;
    }

    public NodeExecutionData getExecution() {
        return this.execution;
    }

    public void setExecution(NodeExecutionData executionData) {
        this.execution = executionData;
        this.signature = this.execution != null;
    }

    public void setSignature(boolean signature) {
        this.signature = signature;
    }

    void setTypeDefinition(MethodSpec.TypeDef typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    MethodSpec.TypeDef getTypeDefinition() {
        return this.typeDefinition;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isSignature() {
        return this.signature;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getName() {
        return this.name;
    }

    public Collection<TypeMirror> getAllowedTypes() {
        return this.allowedTypes;
    }

    public boolean matches(VariableElement variable) {
        if (this.anyType) {
            return this.allowSubclasses || this.allowedTypes.size() <= 0 || ElementUtils.typeEquals(this.allowedTypes.iterator().next(), variable.asType());
        }
        for (TypeMirror type : this.allowedTypes) {
            if (!ElementUtils.typeEquals(variable.asType(), type)) continue;
            return true;
        }
        if (this.allowSubclasses) {
            for (TypeMirror type : this.allowedTypes) {
                if (!ElementUtils.isSubtypeBoxed(ProcessorContext.getInstance(), variable.asType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.toSignatureString(false);
    }

    public String toSignatureString(boolean typeOnly) {
        StringBuilder builder = new StringBuilder();
        if (this.typeDefinition != null) {
            builder.append("<" + this.typeDefinition.getName() + ">");
        } else if (this.getAllowedTypes().size() >= 1) {
            builder.append(ElementUtils.getSimpleName(this.getAllowedTypes().iterator().next()));
        } else {
            builder.append("void");
        }
        if (!typeOnly) {
            builder.append(" ");
            builder.append(this.getName());
        }
        return builder.toString();
    }
}

