/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleProcessorOptions;
import com.oracle.truffle.dsl.processor.TruffleSuppressedWarnings;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.generator.BitSet;
import com.oracle.truffle.dsl.processor.generator.BitStateList;
import com.oracle.truffle.dsl.processor.generator.DSLExpressionGenerator;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.generator.MultiBitSet;
import com.oracle.truffle.dsl.processor.generator.NodeCodeGenerator;
import com.oracle.truffle.dsl.processor.generator.NodeConstants;
import com.oracle.truffle.dsl.processor.generator.StateQuery;
import com.oracle.truffle.dsl.processor.generator.StaticConstants;
import com.oracle.truffle.dsl.processor.generator.TypeSystemCodeGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedTypeMirror;
import com.oracle.truffle.dsl.processor.model.AssumptionExpression;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.CreateCastData;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.GuardExpression;
import com.oracle.truffle.dsl.processor.model.ImplicitCastData;
import com.oracle.truffle.dsl.processor.model.InlineFieldData;
import com.oracle.truffle.dsl.processor.model.InlinedNodeData;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.NodeFieldData;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.model.SpecializationThrowsData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.NodeParser;
import com.oracle.truffle.dsl.processor.parser.SpecializationGroup;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class FlatNodeGenFactory {
    public static final int DEFAULT_MAX_BIT_WIDTH = 32;
    private static final String FRAME_VALUE = "frameValue";
    private static final String NAME_SUFFIX = "_";
    public static final int INLINED_NODE_INDEX = 0;
    private static final String VARARGS_NAME = "args";
    static final StateQuery AOT_PREPARED = StateQuery.create(BitStateList.AOTPreparedState.class, "aot-prepared");
    private final ProcessorContext context;
    private final TruffleTypes types = ProcessorContext.getInstance().getTypes();
    private final NodeData node;
    private final TypeSystemData typeSystem;
    private final TypeMirror genericType;
    private final Set<TypeMirror> expectedTypes = new HashSet<TypeMirror>();
    private final Collection<NodeData> sharingNodes;
    private final boolean boxingEliminationEnabled;
    private int boxingSplitIndex = 0;
    private final MultiStateBitSet multiState;
    private final MultiStateBitSet allMultiState;
    private final ExecutableTypeData executeAndSpecializeType;
    private boolean fallbackNeedsState = false;
    private boolean fallbackNeedsFrame = false;
    private final Map<SpecializationData, CodeTypeElement> specializationClasses = new LinkedHashMap<SpecializationData, CodeTypeElement>();
    private final boolean primaryNode;
    private final Map<CacheExpression, String> sharedCaches;
    private final Map<CacheExpression, CacheExpression> sharedCacheKey;
    private final ParentInlineData parentInlineAccess;
    private final Map<ExecutableElement, Function<DSLExpression.Call, DSLExpression>> substitutions = new LinkedHashMap<ExecutableElement, Function<DSLExpression.Call, DSLExpression>>();
    private final StaticConstants constants;
    private NodeConstants nodeConstants;
    private final GeneratorMode generatorMode;
    private final NodeStateResult state;
    private static final String AOT_STATE = "$aot";
    private final Map<SpecializationData, MultiStateBitSet> specializationStates = new HashMap<SpecializationData, MultiStateBitSet>();
    private static final String OLD_PREFIX = "old";
    private static final String COUNT_SUFIX = "Count";
    private static final String OLD_CACHE_COUNT = "oldCacheCount";
    private static final String REPORT_POLYMORPHIC_SPECIALIZE = "reportPolymorphicSpecialize";
    private static final String CHECK_FOR_POLYMORPHIC_SPECIALIZE = "checkForPolymorphicSpecialize";
    private static final String COUNT_CACHES = "countCaches";
    private int boundaryIndex = 0;
    private final Set<String> usedBoundaryNames = new HashSet<String>();
    private final Map<SpecializationData, CodeExecutableElement> removeThisMethods = new LinkedHashMap<SpecializationData, CodeExecutableElement>();
    private Map<String, List<Parameter>> uniqueCachedParameterLocalNames = new HashMap<String, List<Parameter>>();

    public FlatNodeGenFactory(ProcessorContext context, GeneratorMode mode, NodeData node, StaticConstants constants, NodeConstants nodeConstants) {
        this(context, mode, node, Arrays.asList(node), node.getSharedCaches(), constants, nodeConstants);
    }

    public FlatNodeGenFactory(ProcessorContext context, GeneratorMode mode, NodeData node, Collection<NodeData> stateSharingNodes, Map<CacheExpression, String> sharedCaches, StaticConstants constants, NodeConstants nodeConstants) {
        Objects.requireNonNull(node);
        this.generatorMode = mode;
        this.context = context;
        this.sharingNodes = stateSharingNodes;
        this.node = node;
        this.typeSystem = node.getTypeSystem();
        this.genericType = context.getType(Object.class);
        this.boxingEliminationEnabled = !TruffleProcessorOptions.generateSlowPathOnly(context.getEnvironment());
        this.primaryNode = stateSharingNodes.iterator().next() == node;
        this.sharedCaches = sharedCaches;
        this.sharedCacheKey = FlatNodeGenFactory.computeSharedCacheKeys(stateSharingNodes, sharedCaches);
        this.parentInlineAccess = this.computeParentInlineAccess();
        this.state = this.createNodeState();
        this.multiState = this.state.activeState;
        this.allMultiState = this.state.allState;
        this.executeAndSpecializeType = this.createExecuteAndSpecializeType();
        this.constants = constants;
        this.nodeConstants = nodeConstants;
        this.substitutions.put(ElementUtils.findExecutableElement(this.types.LibraryFactory, "resolve"), binary -> this.substituteLibraryCall((DSLExpression.Call)binary));
        this.substitutions.put(ElementUtils.findExecutableElement(this.types.TruffleLanguage_ContextReference, "create"), binary -> this.substituteContextReference((DSLExpression.Call)binary));
        this.substitutions.put(ElementUtils.findExecutableElement(this.types.TruffleLanguage_LanguageReference, "create"), binary -> this.substituteLanguageReference((DSLExpression.Call)binary));
    }

    public static List<InlineFieldData> createInlinedFields(NodeData node) {
        FlatNodeGenFactory factory = new FlatNodeGenFactory(ProcessorContext.getInstance(), GeneratorMode.DEFAULT, node, new StaticConstants(), new NodeConstants());
        return factory.createInlineFields(true);
    }

    private List<InlineFieldData> createInlineFields(boolean pruneInternalClasses) {
        CodeVariableElement var;
        ArrayList<InlineFieldData> fields = new ArrayList<InlineFieldData>();
        for (BitSet bitSet : this.state.activeState.getSets()) {
            String name = bitSet.getName() + NAME_SUFFIX;
            DeclaredType referenceType = ProcessorContext.types().InlineSupport_StateField;
            var = MultiStateBitSet.createCachedField(bitSet);
            fields.add(new InlineFieldData(var, name, referenceType, bitSet.getBitCount(), null, 0));
        }
        NodeConstants savedConstants = this.nodeConstants;
        this.nodeConstants = new NodeConstants();
        List<Element> elements = this.createCachedFields(null);
        for (Element element : elements) {
            if (!(element instanceof CodeVariableElement) || (var = (CodeVariableElement)element).getModifiers().contains((Object)Modifier.STATIC)) continue;
            TypeMirror type = var.asType();
            String name = var.getName();
            if (ElementUtils.isPrimitive(type)) {
                fields.add(new InlineFieldData(element, name, InlineFieldData.resolvePrimitiveFieldType(type), null, type, 0));
                continue;
            }
            int dimensions = 0;
            if (pruneInternalClasses) {
                if (ElementUtils.isAssignable(type, this.types.Node)) {
                    type = this.types.Node;
                } else if (ElementUtils.isAssignable(type, this.types.NodeInterface)) {
                    type = this.types.NodeInterface;
                } else if (FlatNodeGenFactory.isNodeArray(type)) {
                    type = new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Node);
                } else if (type.getKind() == TypeKind.ARRAY) {
                    type = this.context.getType(Object[].class);
                    AnnotationMirror annotationMirror = ElementUtils.findAnnotationMirror((Element)var, (TypeMirror)this.types.CompilerDirectives_CompilationFinal);
                    if (annotationMirror != null) {
                        dimensions = ElementUtils.getAnnotationValue(Integer.class, annotationMirror, "dimensions");
                    }
                } else {
                    type = this.context.getType(Object.class);
                }
            }
            fields.add(new InlineFieldData(element, name, ProcessorContext.types().InlineSupport_ReferenceField, null, type, dimensions));
        }
        this.nodeConstants = savedConstants;
        return fields;
    }

    private static boolean isImplicitCastUsed(ExecutableTypeData executable, Collection<SpecializationData> usedSpecializations, SpecializationGroup.TypeGuard guard) {
        int signatureIndex = guard.getSignatureIndex();
        TypeMirror polymorphicParameter = executable.getSignatureParameters().get(signatureIndex);
        for (SpecializationData specialization : usedSpecializations) {
            TypeMirror specializationType = specialization.getSignatureParameters().get(signatureIndex).getType();
            if (!ElementUtils.needsCastTo(polymorphicParameter, specializationType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    BitStateList computeNodeState() {
        ArrayList stateObjects = new ArrayList();
        boolean aotStateAdded = false;
        HashSet<String> handledCaches = new HashSet<String>();
        for (NodeData stateNode : this.sharingNodes) {
            LinkedHashSet<SpecializationGroup.TypeGuard> implicitCasts = new LinkedHashSet<SpecializationGroup.TypeGuard>();
            boolean needsRewrites = stateNode.needsRewrites(this.context);
            List<SpecializationData> specializations = stateNode.getReachableSpecializations();
            for (SpecializationData specialization : specializations) {
                Object cache2;
                if (!aotStateAdded && FlatNodeGenFactory.needsAOTReset(this.node, this.sharingNodes)) {
                    stateObjects.add(new BitStateList.AOTPreparedState(this.node));
                    aotStateAdded = true;
                }
                if (needsRewrites) {
                    stateObjects.add(new BitStateList.SpecializationActive(specialization));
                }
                if (FlatNodeGenFactory.hasExcludeBit(specialization)) {
                    stateObjects.add(new BitStateList.SpecializationExcluded(specialization));
                }
                for (GuardExpression guardExpression : specialization.getGuards()) {
                    if (!FlatNodeGenFactory.guardNeedsNodeStateBit(specialization, guardExpression)) continue;
                    stateObjects.add(new BitStateList.GuardActive(specialization, guardExpression));
                }
                boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
                for (Object cache2 : specialization.getCaches()) {
                    String string;
                    if (useSpecializationClass && FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass((CacheExpression)cache2) || !((CacheExpression)cache2).isEncodedEnum() || (string = ((CacheExpression)cache2).getSharedGroup()) != null && handledCaches.contains(string)) continue;
                    stateObjects.add(new BitStateList.EncodedEnumState(this.node, (CacheExpression)cache2));
                    if (string == null) continue;
                    handledCaches.add(string);
                }
                boolean bl = false;
                cache2 = specialization.getSignatureParameters().iterator();
                while (cache2.hasNext()) {
                    void var12_16;
                    Parameter parameter = (Parameter)cache2.next();
                    TypeMirror targetType = parameter.getType();
                    Collection<TypeMirror> sourceTypes = stateNode.getTypeSystem().lookupSourceTypes(targetType);
                    if (sourceTypes.size() > 1) {
                        implicitCasts.add(new SpecializationGroup.TypeGuard(stateNode.getTypeSystem(), targetType, (int)var12_16));
                    }
                    ++var12_16;
                }
            }
            for (SpecializationGroup.TypeGuard cast : implicitCasts) {
                if (!FlatNodeGenFactory.isImplicitCastUsed(stateNode.getPolymorphicExecutable(), specializations, cast)) continue;
                stateObjects.add(new BitStateList.ImplicitCastState(stateNode, cast));
            }
        }
        for (NodeData stateNode : this.sharingNodes) {
            for (SpecializationData specialization : stateNode.getReachableSpecializations()) {
                boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
                BitStateList specializationState = FlatNodeGenFactory.computeSpecializationState(specialization);
                for (CacheExpression cache : specialization.getCaches()) {
                    InlinedNodeData inlinedNodeData = cache.getInlinedNode();
                    if (inlinedNodeData == null) continue;
                    String cacheGroup = cache.getSharedGroup();
                    if (cacheGroup != null) {
                        if (handledCaches.contains(cacheGroup)) continue;
                        handledCaches.add(cacheGroup);
                    }
                    if (cacheGroup == null && useSpecializationClass) {
                        for (InlineFieldData fieldData : cache.getInlinedNode().getFields()) {
                            if (fieldData.isState() && !specializationState.contains(BitStateList.InlinedNodeState.class, fieldData)) {
                                throw new AssertionError((Object)"Detected unhandled state");
                            }
                        }
                        continue;
                    }
                    Object var14_27 = null;
                    if (cache.isUsedInGuard()) {
                        SpecializationData specializationData = specialization;
                    }
                    for (InlineFieldData fieldData : cache.getInlinedNode().getFields()) {
                        void var14_29;
                        if (!fieldData.isState()) continue;
                        stateObjects.add(new BitStateList.InlinedNodeState(stateNode, cache, fieldData, (SpecializationData)var14_29));
                    }
                }
            }
        }
        return new BitStateList(stateObjects);
    }

    private static BitStateList computeSpecializationState(SpecializationData specialization) {
        ArrayList stateObjects = new ArrayList();
        if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
            for (GuardExpression guard : specialization.getGuards()) {
                if (!FlatNodeGenFactory.guardNeedsSpecializationStateBit(specialization, guard)) continue;
                stateObjects.add(new BitStateList.GuardActive(specialization, guard));
            }
            if (FlatNodeGenFactory.specializationNeedsInitializedBit(specialization)) {
                stateObjects.add(new BitStateList.SpecializationCachesInitialized(specialization));
            }
            for (CacheExpression cache : specialization.getCaches()) {
                if (!FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache)) continue;
                if (cache.getInlinedNode() != null) {
                    for (InlineFieldData field : cache.getInlinedNode().getFields()) {
                        if (!field.isState()) continue;
                        stateObjects.add(new BitStateList.InlinedNodeState(specialization.getNode(), cache, field, null));
                    }
                    continue;
                }
                if (!cache.isEncodedEnum()) continue;
                stateObjects.add(new BitStateList.EncodedEnumState(specialization.getNode(), cache));
            }
        }
        return new BitStateList(stateObjects);
    }

    NodeStateResult createNodeState() {
        BitStateList list = this.computeNodeState();
        MultiStateBitSet state = FlatNodeGenFactory.createMultiStateBitset("", this.node, list);
        MultiStateBitSet allState = new MultiStateBitSet(state.all, state.all);
        return new NodeStateResult(state, allState);
    }

    private static MultiStateBitSet createMultiStateBitset(String namePrefix, NodeData activeNode, BitStateList objects) {
        int maxBits = TruffleProcessorOptions.stateBitWidth(activeNode);
        return objects.splitBitSets(namePrefix, activeNode, maxBits);
    }

    private boolean needsRewrites() {
        if (this.node.needsRewrites(this.context)) {
            return true;
        }
        for (SpecializationData specialization : this.node.getReachableSpecializations()) {
            if (!FlatNodeGenFactory.useSpecializationClass(specialization)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsAOTReset(NodeData node, Collection<NodeData> stateSharingNodes) {
        if (!node.isGenerateAOT()) {
            return false;
        }
        for (NodeData currentNode : stateSharingNodes) {
            if (!currentNode.needsRewrites(node.getContext())) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultipleNodes() {
        return this.sharingNodes.size() > 1;
    }

    private String createSpecializationTypeName(SpecializationData s) {
        if (this.sharingNodes.size() > 1) {
            return ElementUtils.firstLetterUpperCase(FlatNodeGenFactory.getNodePrefix(s.getNode())) + ElementUtils.firstLetterUpperCase(s.getId()) + "Data";
        }
        return ElementUtils.firstLetterUpperCase(s.getId()) + "Data";
    }

    private static TypeMirror createCacheClassType(CacheExpression cache) {
        return new GeneratedTypeMirror("", FlatNodeGenFactory.createCacheClassName(cache));
    }

    private static String createCacheClassName(CacheExpression cache) {
        return ElementUtils.firstLetterUpperCase(cache.getSharedGroup()) + "SharedWrapper";
    }

    private String createSpecializationFieldName(SpecializationData s) {
        if (this.sharingNodes.size() > 1) {
            return ElementUtils.firstLetterLowerCase(FlatNodeGenFactory.getNodePrefix(s.getNode())) + NAME_SUFFIX + ElementUtils.firstLetterLowerCase(s.getId()) + "_cache";
        }
        return ElementUtils.firstLetterLowerCase(s.getId()) + "_cache";
    }

    private String createStaticInlinedCacheName(SpecializationData specialization, CacheExpression cache) {
        String sharedName = this.sharedCaches.get(cache);
        Object baseName = sharedName != null && specialization != null && this.hasCacheParentAccess(cache) ? specialization.getId() + NAME_SUFFIX + sharedName : this.createFieldName(specialization, cache);
        return "INLINED_" + ElementUtils.createConstantName((String)baseName);
    }

    private String createFieldName(SpecializationData specialization, CacheExpression cache) {
        String sharedName = this.sharedCaches.get(cache);
        if (sharedName != null) {
            return sharedName;
        }
        if (specialization == null) {
            throw new AssertionError((Object)"if specialization is null it must be shared cache");
        }
        Parameter parameter = cache.getParameter();
        if (FlatNodeGenFactory.useSpecializationClass(specialization) && cache.getInlinedNode() == null) {
            return parameter.getLocalName() + NAME_SUFFIX;
        }
        Object prefix = "";
        if (this.sharingNodes.size() > 1) {
            prefix = ElementUtils.firstLetterLowerCase(FlatNodeGenFactory.getNodePrefix(specialization.getNode())) + NAME_SUFFIX + ElementUtils.firstLetterLowerCase(specialization.getId()) + NAME_SUFFIX;
        } else if (specialization.getNode().getReachableSpecializations().size() > 1) {
            prefix = ElementUtils.firstLetterLowerCase(specialization.getId()) + NAME_SUFFIX;
        }
        return (String)prefix + parameter.getLocalName() + NAME_SUFFIX;
    }

    private static String getNodePrefix(NodeData node) {
        String name = node.getNodeId();
        if (name.endsWith("Node")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    private static String createAssumptionFieldName(SpecializationData specialization, AssumptionExpression assumption) {
        if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
            return assumption.getId() + NAME_SUFFIX;
        }
        return ElementUtils.firstLetterLowerCase(specialization.getId()) + NAME_SUFFIX + assumption.getId() + NAME_SUFFIX;
    }

    private static String createSpecializationLocalName(SpecializationData s) {
        if (s == null) {
            return null;
        }
        return "s" + s.getIndex() + NAME_SUFFIX;
    }

    private static String createSpecializationLocalOriginalName(SpecializationData s) {
        if (s == null) {
            return null;
        }
        return "s" + s.getIndex() + "_original";
    }

    private static String nodeFieldName(NodeExecutionData execution) {
        if (execution.getChild() == null || execution.getChild().needsGeneratedField()) {
            return execution.getName() + NAME_SUFFIX;
        }
        return execution.getName();
    }

    private static String accessNodeField(NodeExecutionData execution) {
        if (execution.getChild() == null || execution.getChild().needsGeneratedField()) {
            return "this." + FlatNodeGenFactory.nodeFieldName(execution);
        }
        String access = "super." + execution.getChild().getName();
        if (execution.hasChildArrayIndex()) {
            access = access + "[" + execution.getChildArrayIndex() + "]";
        }
        return access;
    }

    private CacheExpression lookupSharedCacheKey(CacheExpression cache) {
        if (!this.sharedCaches.containsKey(cache)) {
            return cache;
        }
        CacheExpression key = this.sharedCacheKey.get(cache);
        if (key == null) {
            return cache;
        }
        return key;
    }

    private static Map<CacheExpression, CacheExpression> computeSharedCacheKeys(Collection<NodeData> stateSharingNodes, Map<CacheExpression, String> sharedCaches) {
        LinkedHashMap<CacheExpression, CacheExpression> foundCaches = new LinkedHashMap<CacheExpression, CacheExpression>();
        LinkedHashMap<String, CacheExpression> firstCache = new LinkedHashMap<String, CacheExpression>();
        for (NodeData n : stateSharingNodes) {
            for (SpecializationData specialization : n.getReachableSpecializations()) {
                for (CacheExpression cache : specialization.getCaches()) {
                    String cacheName = sharedCaches.get(cache);
                    if (cacheName == null) continue;
                    CacheExpression key = (CacheExpression)firstCache.get(cacheName);
                    if (key != null) {
                        foundCaches.put(cache, key);
                        continue;
                    }
                    firstCache.put(cacheName, cache);
                    foundCaches.put(cache, cache);
                }
            }
        }
        return foundCaches;
    }

    private boolean hasCacheParentAccess(CacheExpression cache) {
        return this.parentInlineAccess.foundSharedParentAccess.contains(cache);
    }

    private boolean hasSharedCacheDirectAccess(CacheExpression cache) {
        return this.parentInlineAccess.foundSharedDirectAccess.contains(cache);
    }

    private ParentInlineData computeParentInlineAccess() {
        ParentInlineData data = new ParentInlineData();
        for (NodeData n : this.sharingNodes) {
            for (SpecializationData specialization : n.getReachableSpecializations()) {
                boolean parentInlinedAccess = FlatNodeGenFactory.useParentInlinedAccess(specialization);
                for (CacheExpression cache : specialization.getCaches()) {
                    if (!this.sharedCaches.containsKey(cache) || cache.getInlinedNode() == null) continue;
                    if (parentInlinedAccess) {
                        data.foundSharedParentAccess.add(cache);
                        continue;
                    }
                    data.foundSharedDirectAccess.add(this.lookupSharedCacheKey(cache));
                }
            }
        }
        return data;
    }

    private static boolean useParentInlinedAccess(SpecializationData specialization) {
        if (!FlatNodeGenFactory.useSpecializationClass(specialization)) {
            return false;
        }
        boolean hasSharedInlined = false;
        boolean hasSpecializationClassInlined = false;
        for (CacheExpression cache : specialization.getCaches()) {
            if (cache.getInlinedNode() != null) {
                if (FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache)) {
                    hasSpecializationClassInlined = true;
                } else if (cache.getSharedGroup() != null) {
                    hasSharedInlined = true;
                }
            }
            if (!hasSharedInlined || !hasSpecializationClassInlined) continue;
            return true;
        }
        return false;
    }

    public static boolean isLayoutBenefittingFromNeverDefault(SpecializationData specialization) {
        if (specialization.hasMultipleInstances()) {
            return false;
        }
        if (specialization.isGuardBindsCache() && FlatNodeGenFactory.guardUseInstanceField(specialization)) {
            return false;
        }
        return !FlatNodeGenFactory.shouldUseSpecializationClassBySize(specialization);
    }

    public static boolean useSpecializationClass(SpecializationData specialization) {
        if (FlatNodeGenFactory.shouldUseSpecializationClassBySize(specialization)) {
            return true;
        }
        if (specialization.hasMultipleInstances()) {
            return true;
        }
        if (specialization.isGuardBindsCache() && FlatNodeGenFactory.guardUseInstanceField(specialization)) {
            return true;
        }
        for (CacheExpression cache : specialization.getCaches()) {
            if (cache.isEncodedEnum() || !FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache) || cache.isNeverDefault()) continue;
            return true;
        }
        return false;
    }

    private static boolean guardUseInstanceField(SpecializationData s) {
        for (GuardExpression guard : s.getGuards()) {
            if (guard.isLibraryAcceptsGuard()) continue;
            for (CacheExpression cache : s.getBoundCaches(guard.getExpression(), false)) {
                if (!FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache) || cache.isEncodedEnum() || cache.getInlinedNode() != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldUseSpecializationClassBySize(SpecializationData specialization) {
        SpecializationClassSizeEstimate result = FlatNodeGenFactory.computeSpecializationClassSizeEstimate(specialization);
        return result.sizeWithClass < result.sizeWithoutClass;
    }

    private static SpecializationClassSizeEstimate computeSpecializationClassSizeEstimate(SpecializationData specialization) {
        boolean needsNode = FlatNodeGenFactory.specializationClassIsNode(specialization);
        int fieldsSize = 0;
        int stateBits = 0;
        for (CacheExpression cache : specialization.getCaches()) {
            if (!FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache)) continue;
            if (cache.getInlinedNode() != null) {
                for (InlineFieldData field : cache.getInlinedNode().getFields()) {
                    if (field.isState()) {
                        stateBits += field.getBits();
                        continue;
                    }
                    fieldsSize += ElementUtils.getCompressedReferenceSize(field.getType());
                }
                continue;
            }
            TypeMirror type = cache.getParameter().getType();
            fieldsSize += ElementUtils.getCompressedReferenceSize(type);
        }
        int stateBytesByInt = (int)Math.ceil((double)stateBits / 32.0) * 4;
        int stateBytesByByte = (int)Math.ceil((double)stateBits / 8.0);
        int instanceOverhead = 12;
        if (needsNode) {
            instanceOverhead += 4;
        }
        if (specialization.hasMultipleInstances()) {
            instanceOverhead += 4;
        }
        int sizeWithClass = 4 + (int)((double)(instanceOverhead + fieldsSize + stateBytesByInt) * specialization.getActivationProbability());
        int sizeWithoutClass = fieldsSize + stateBytesByByte;
        return new SpecializationClassSizeEstimate(sizeWithClass, sizeWithoutClass);
    }

    static boolean canCacheBeStoredInSpecialializationClass(CacheExpression cache) {
        if (cache.isBind()) {
            return false;
        }
        if (cache.isAlwaysInitialized()) {
            return false;
        }
        if (cache.getSharedGroup() != null) {
            return false;
        }
        return !cache.isEagerInitialize();
    }

    private static boolean needsFrameToExecute(List<SpecializationData> specializations) {
        for (SpecializationData specialization : specializations) {
            if (specialization.getFrame() == null) continue;
            return true;
        }
        return false;
    }

    private static String createImplicitTypeStateLocalName(Parameter execution) {
        String name = ElementUtils.firstLetterLowerCase(ElementUtils.getTypeId(execution.getType()));
        return name + "Cast" + execution.getSpecification().getExecution().getIndex();
    }

    private static boolean hasExcludeBit(SpecializationData specialization) {
        return !specialization.getExceptions().isEmpty();
    }

    private static boolean hasExcludes(SpecializationData specialization) {
        return !specialization.getExceptions().isEmpty() || !specialization.getReplacedBy().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public CodeTypeElement create(CodeTypeElement clazz) {
        CodeExecutableElement method;
        TypeMirror genericReturnType = this.node.getPolymorphicExecutable().getReturnType();
        List<ExecutableTypeData> executableTypes = this.filterExecutableTypes(this.node.getExecutableTypes(), this.node.getReachableSpecializations());
        ArrayList<ExecutableTypeData> genericExecutableTypes = new ArrayList<ExecutableTypeData>();
        ArrayList<ExecutableTypeData> specializedExecutableTypes = new ArrayList<ExecutableTypeData>();
        ArrayList<ExecutableTypeData> voidExecutableTypes = new ArrayList<ExecutableTypeData>();
        AnnotationMirror nodeInfo = null;
        try {
            nodeInfo = ElementUtils.findAnnotationMirror((Element)this.node.getTemplateType(), (TypeMirror)this.types.NodeInfo);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String cost = nodeInfo != null ? ElementUtils.getAnnotationValue(VariableElement.class, nodeInfo, "cost").getSimpleName().toString() : null;
        GeneratorUtils.mergeSuppressWarnings(clazz, "javadoc");
        for (ExecutableTypeData executableTypeData : executableTypes) {
            if (ElementUtils.isVoid(executableTypeData.getReturnType())) {
                voidExecutableTypes.add(executableTypeData);
                continue;
            }
            if (executableTypeData.hasUnexpectedValue() && !ElementUtils.typeEquals(genericReturnType, executableTypeData.getReturnType())) {
                specializedExecutableTypes.add(executableTypeData);
                continue;
            }
            genericExecutableTypes.add(executableTypeData);
        }
        if (genericExecutableTypes.size() > 1) {
            boolean hasGenericTypeMatch = false;
            for (ExecutableTypeData executableTypeData : genericExecutableTypes) {
                if (!ElementUtils.typeEquals(executableTypeData.getReturnType(), genericReturnType)) continue;
                hasGenericTypeMatch = true;
                break;
            }
            if (hasGenericTypeMatch) {
                ListIterator listIterator = genericExecutableTypes.listIterator();
                while (listIterator.hasNext()) {
                    ExecutableTypeData executableTypeData = (ExecutableTypeData)listIterator.next();
                    if (ElementUtils.isAssignable(genericReturnType, executableTypeData.getReturnType())) continue;
                    listIterator.remove();
                    specializedExecutableTypes.add(executableTypeData);
                }
            }
        }
        if (this.node.isGenerateCached()) {
            if (this.primaryNode) {
                for (NodeChildData nodeChildData : this.node.getChildren()) {
                    clazz.addOptional(this.createAccessChildMethod(nodeChildData, false));
                }
                for (NodeFieldData nodeFieldData : this.node.getFields()) {
                    void var11_47;
                    if (!nodeFieldData.isGenerated()) continue;
                    if (nodeFieldData.isSettable()) {
                        Set<Modifier> set = ElementUtils.modifiers(Modifier.PRIVATE);
                    } else {
                        Set<Modifier> set = ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL);
                    }
                    clazz.add(new CodeVariableElement((Set<Modifier>)var11_47, nodeFieldData.getType(), nodeFieldData.getName()));
                    if (nodeFieldData.getGetter() != null && nodeFieldData.getGetter().getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        method = CodeExecutableElement.clone(nodeFieldData.getGetter());
                        method.getModifiers().remove((Object)Modifier.ABSTRACT);
                        method.createBuilder().startReturn().string("this.").string(nodeFieldData.getName()).end();
                        clazz.add(method);
                    }
                    if (!nodeFieldData.isSettable()) continue;
                    method = CodeExecutableElement.clone(nodeFieldData.getSetter());
                    method.renameArguments(nodeFieldData.getName());
                    method.getModifiers().remove((Object)Modifier.ABSTRACT);
                    method.createBuilder().startStatement().string("this.").string(nodeFieldData.getName()).string(" = ", nodeFieldData.getName()).end();
                    clazz.add(method);
                }
                for (ExecutableElement executableElement : GeneratorUtils.findUserConstructors(this.node.getTemplateType().asType())) {
                    clazz.add(this.createNodeConstructor(clazz, executableElement));
                }
                for (NodeExecutionData nodeExecutionData : this.node.getChildExecutions()) {
                    if (nodeExecutionData.getChild() == null || !nodeExecutionData.getChild().needsGeneratedField()) continue;
                    clazz.add(FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, nodeExecutionData.getNodeType(), FlatNodeGenFactory.nodeFieldName(nodeExecutionData), this.types.Node_Child, new Modifier[0]));
                }
            }
            if (this.primaryNode && this.state.activeState.getAllCapacity() > 0) {
                clazz.getEnclosedElements().addAll(this.state.activeState.createCachedFields());
            }
            clazz.getEnclosedElements().addAll(this.createCachedFields(clazz));
            this.generateStatisticsFields(clazz);
            SpecializationData fallback = this.node.getFallbackSpecialization();
            if (fallback.getMethod() != null && fallback.isReachable()) {
                clazz.add(this.createFallbackGuard(false));
            }
            for (ExecutableTypeData executableTypeData : genericExecutableTypes) {
                this.wrapWithTraceOnReturn(this.createExecute(clazz, executableTypeData, Collections.emptyList(), false));
            }
            for (ExecutableTypeData executableTypeData : specializedExecutableTypes) {
                this.wrapWithTraceOnReturn(this.createExecute(clazz, executableTypeData, genericExecutableTypes, false));
            }
            for (ExecutableTypeData executableTypeData : voidExecutableTypes) {
                ArrayList<ExecutableTypeData> genericAndSpecialized = new ArrayList<ExecutableTypeData>();
                genericAndSpecialized.addAll(genericExecutableTypes);
                genericAndSpecialized.addAll(specializedExecutableTypes);
                this.wrapWithTraceOnReturn(this.createExecute(clazz, executableTypeData, genericAndSpecialized, false));
            }
            clazz.addOptional(this.createExecuteAndSpecialize(false));
            ReportPolymorphismAction reportPolymorphismAction = FlatNodeGenFactory.reportPolymorphismAction(this.node, this.node.getReachableSpecializations());
            if (reportPolymorphismAction.required()) {
                clazz.addOptional(this.createCheckForPolymorphicSpecialize(reportPolymorphismAction, false));
                if (this.requiresCacheCheck(reportPolymorphismAction)) {
                    clazz.addOptional(this.createCountCaches(false));
                }
            }
            if ((cost == null || cost.equals("MONOMORPHIC")) && FlatNodeGenFactory.isUndeclaredOrOverrideable(clazz, "getCost") && this.primaryNode) {
                clazz.add(this.createGetCostMethod(false));
            }
            for (TypeMirror type : ElementUtils.uniqueSortedTypes(this.expectedTypes, false)) {
                if (this.typeSystem.hasType(type)) continue;
                clazz.addOptional(TypeSystemCodeGenerator.createExpectMethod(Modifier.PRIVATE, this.typeSystem, this.context.getType(Object.class), type));
            }
            clazz.getEnclosedElements().addAll(this.removeThisMethods.values());
            if (this.isGenerateIntrospection()) {
                this.generateIntrospectionInfo(clazz, false);
            }
            if (this.isGenerateAOT()) {
                this.generateAOT(clazz, false);
            }
        }
        this.removeThisMethods.clear();
        if (this.node.isGenerateInline()) {
            SpecializationData fallback;
            CodeTypeElement inlined = GeneratorUtils.createClass(this.node, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Inlined", this.node.getTemplateType().asType());
            inlined.addAnnotationMirror(new CodeAnnotationMirror(this.types.DenyReplace));
            List<InlineFieldData> list = this.createInlineFields(false);
            CodeExecutableElement codeExecutableElement = inlined.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(Modifier.PRIVATE), inlined));
            CodeTreeBuilder builder = codeExecutableElement.appendBuilder();
            CodeVariableElement inlineTarget = new CodeVariableElement(this.types.InlineSupport_InlineTarget, "target");
            codeExecutableElement.addParameter(inlineTarget);
            builder.startAssert().string("target.getTargetClass().isAssignableFrom(").typeLiteral(this.node.getTemplateType().asType()).string(")").end();
            if (this.primaryNode) {
                int index = 0;
                for (InlineFieldData inlineFieldData : list) {
                    CodeVariableElement codeVariableElement = inlined.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), inlineFieldData.getFieldType(), inlineFieldData.getName()));
                    if (index < this.state.activeState.getSets().size()) {
                        CodeTreeBuilder docBuilder = codeVariableElement.createDocBuilder();
                        docBuilder.startJavadoc();
                        FlatNodeGenFactory.addStateDoc(docBuilder, this.state.activeState.getSets().get(index));
                        docBuilder.end();
                    }
                    builder.startStatement();
                    builder.string("this.", codeVariableElement.getName(), " = ");
                    if (inlineFieldData.isReference()) {
                        GeneratorUtils.mergeSuppressWarnings(codeExecutableElement, "unchecked");
                        builder.startCall(inlineTarget.getName(), "getReference").string(String.valueOf(index)).typeLiteral(inlineFieldData.getType()).end();
                    } else if (inlineFieldData.isState()) {
                        builder.startCall(inlineTarget.getName(), "getState").string(String.valueOf(index)).string(String.valueOf(inlineFieldData.getBits())).end();
                    } else {
                        builder.startCall(inlineTarget.getName(), "getPrimitive").string(String.valueOf(index)).typeLiteral(inlineFieldData.getFieldType()).end();
                    }
                    builder.end();
                    ++index;
                }
                Iterator<String> expressions = new HashSet();
                for (Map.Entry<CacheExpression, String> entry : this.sharedCaches.entrySet()) {
                    CacheExpression cache = entry.getKey();
                    String fieldName = entry.getValue();
                    if (expressions.contains(fieldName)) continue;
                    expressions.add(fieldName);
                    if (cache.getInlinedNode() == null || !this.hasSharedCacheDirectAccess(cache)) continue;
                    inlined.add(this.createCacheInlinedField(builder, null, null, cache));
                }
            }
            if ((fallback = this.node.getFallbackSpecialization()).getMethod() != null && fallback.isReachable()) {
                inlined.add(this.createFallbackGuard(true));
            }
            for (SpecializationData specializationData : this.node.getReachableSpecializations()) {
                MultiStateBitSet multiStateBitSet = this.lookupSpecializationState(specializationData);
                for (CacheExpression cache : specializationData.getCaches()) {
                    if (cache.getInlinedNode() == null || this.sharedCaches.containsKey(cache) && !this.hasCacheParentAccess(cache)) continue;
                    inlined.add(this.createCacheInlinedField(builder, specializationData, multiStateBitSet, cache));
                }
            }
            for (ExecutableTypeData executableTypeData : genericExecutableTypes) {
                this.wrapWithTraceOnReturn(this.createExecute(inlined, executableTypeData, Collections.emptyList(), true));
            }
            for (ExecutableTypeData executableTypeData : specializedExecutableTypes) {
                this.wrapWithTraceOnReturn(this.createExecute(inlined, executableTypeData, genericExecutableTypes, true));
            }
            for (ExecutableTypeData executableTypeData : voidExecutableTypes) {
                ArrayList<ExecutableTypeData> arrayList = new ArrayList<ExecutableTypeData>();
                arrayList.addAll(genericExecutableTypes);
                arrayList.addAll(specializedExecutableTypes);
                this.wrapWithTraceOnReturn(this.createExecute(inlined, executableTypeData, arrayList, true));
            }
            inlined.addOptional(this.createExecuteAndSpecialize(true));
            ReportPolymorphismAction reportPolymorphismAction = FlatNodeGenFactory.reportPolymorphismAction(this.node, this.node.getReachableSpecializations());
            if (reportPolymorphismAction.required()) {
                inlined.addOptional(this.createCheckForPolymorphicSpecialize(reportPolymorphismAction, true));
                if (this.requiresCacheCheck(reportPolymorphismAction)) {
                    inlined.addOptional(this.createCountCaches(true));
                }
            }
            inlined.getEnclosedElements().addAll(this.removeThisMethods.values());
            CodeExecutableElement codeExecutableElement2 = CodeExecutableElement.cloneNoAnnotations(ElementUtils.findExecutableElement(this.types.Node, "isAdoptable"));
            codeExecutableElement2.createBuilder().returnFalse();
            inlined.add(codeExecutableElement2);
            if (this.isGenerateIntrospection()) {
                this.generateIntrospectionInfo(inlined, true);
            }
            if (this.isGenerateAOT()) {
                this.generateAOT(inlined, true);
            }
            this.generateStatisticsFields(inlined);
            clazz.add(inlined);
        }
        for (CodeTypeElement codeTypeElement : this.specializationClasses.values()) {
            clazz.add(codeTypeElement);
        }
        if (this.node.isUncachable() && this.node.isGenerateUncached()) {
            CodeTypeElement uncached = GeneratorUtils.createClass(this.node, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Uncached", this.node.getTemplateType().asType());
            uncached.getEnclosedElements().addAll(this.createUncachedFields());
            uncached.addAnnotationMirror(new CodeAnnotationMirror(this.types.DenyReplace));
            for (NodeFieldData nodeFieldData : this.node.getFields()) {
                if (!nodeFieldData.isGenerated()) continue;
                if (nodeFieldData.getGetter() != null && nodeFieldData.getGetter().getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    method = CodeExecutableElement.clone(nodeFieldData.getGetter());
                    method.getModifiers().remove((Object)Modifier.ABSTRACT);
                    method.addAnnotationMirror(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
                    method.createBuilder().startThrow().startNew(this.context.getType(UnsupportedOperationException.class)).end().end();
                    uncached.add(method);
                }
                if (!nodeFieldData.isSettable()) continue;
                method = CodeExecutableElement.clone(nodeFieldData.getSetter());
                method.getModifiers().remove((Object)Modifier.ABSTRACT);
                method.addAnnotationMirror(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
                method.createBuilder().startThrow().startNew(this.context.getType(UnsupportedOperationException.class)).end().end();
                uncached.add(method);
            }
            this.generateStatisticsFields(uncached);
            for (NodeChildData nodeChildData : this.node.getChildren()) {
                uncached.addOptional(this.createAccessChildMethod(nodeChildData, true));
            }
            for (ExecutableTypeData executableTypeData : genericExecutableTypes) {
                this.wrapWithTraceOnReturn(uncached.add(this.createUncachedExecute(executableTypeData)));
            }
            for (ExecutableTypeData executableTypeData : specializedExecutableTypes) {
                this.wrapWithTraceOnReturn(uncached.add(this.createUncachedExecute(executableTypeData)));
            }
            for (ExecutableTypeData executableTypeData : voidExecutableTypes) {
                this.wrapWithTraceOnReturn(uncached.add(this.createUncachedExecute(executableTypeData)));
            }
            if ((cost == null || cost.equals("MONOMORPHIC")) && FlatNodeGenFactory.isUndeclaredOrOverrideable(uncached, "getCost")) {
                uncached.add(this.createGetCostMethod(true));
            }
            CodeExecutableElement codeExecutableElement = CodeExecutableElement.cloneNoAnnotations(ElementUtils.findExecutableElement(this.types.Node, "isAdoptable"));
            codeExecutableElement.createBuilder().returnFalse();
            uncached.add(codeExecutableElement);
            clazz.add(uncached);
            GeneratedTypeMirror generatedTypeMirror = new GeneratedTypeMirror("", uncached.getSimpleName().toString());
            CodeVariableElement uncachedField = clazz.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), generatedTypeMirror, "UNCACHED"));
            uncachedField.createInitBuilder().startNew(generatedTypeMirror).end();
        }
        CodeTreeBuilder debug = clazz.createDocBuilder();
        debug.startJavadoc();
        debug.string("Debug Info: <pre>").newLine();
        for (SpecializationData specializationData : this.node.getReachableSpecializations()) {
            debug.string("  Specialization ").javadocLink(specializationData.getMethod(), null).newLine();
            SpecializationClassSizeEstimate estimate = FlatNodeGenFactory.computeSpecializationClassSizeEstimate(specializationData);
            debug.string("    Activation probability: ").string(String.format("%.5f", specializationData.getActivationProbability())).newLine();
            debug.string("    With/without class size: ").string(String.valueOf(estimate.sizeWithClass)).string("/", String.valueOf(estimate.sizeWithoutClass), " bytes").newLine();
        }
        debug.string("</pre>");
        debug.end();
        return clazz;
    }

    private CodeVariableElement createCacheInlinedField(CodeTreeBuilder init, SpecializationData specialization, MultiStateBitSet specializationState, CacheExpression cache) {
        Parameter parameter = cache.getParameter();
        String fieldName = this.createLocalCachedInlinedName(specialization, cache);
        CacheExpression sharedCache = this.lookupSharedCacheKey(cache);
        init.startStatement();
        init.string("this.", fieldName, " = ");
        init.startStaticCall(cache.getInlinedNode().getMethod());
        init.startStaticCall(ProcessorContext.types().InlineSupport_InlineTarget, "create");
        init.typeLiteral(cache.getParameter().getType());
        boolean parentAccess = this.hasCacheParentAccess(cache);
        for (InlineFieldData field : sharedCache.getInlinedNode().getFields()) {
            if (field.isState()) {
                BitSet bitSet = this.allMultiState.findSet(BitStateList.InlinedNodeState.class, field);
                if (bitSet == null) {
                    bitSet = this.findInlinedState(specializationState, field);
                    CodeVariableElement var = this.createStateUpdaterField(specialization, specializationState, field, this.specializationClasses.get(specialization).getEnclosedElements());
                    init.startCall(var.getName(), "subUpdater");
                    BitSet.BitRange range = bitSet.getStates().queryRange(StateQuery.create(BitStateList.InlinedNodeState.class, field));
                    init.string(String.valueOf(range.offset));
                    init.string(String.valueOf(range.length));
                    init.end();
                    continue;
                }
                if (specializationState != null && specializationState.findSet(BitStateList.InlinedNodeState.class, field) != null) {
                    throw new AssertionError((Object)"Inlined field in specializationState and regular state at the same time.");
                }
                init.startGroup();
                init.startCall(bitSet.getName() + NAME_SUFFIX, "subUpdater");
                BitSet.BitRange range = bitSet.getStates().queryRange(StateQuery.create(BitStateList.InlinedNodeState.class, field));
                init.string(String.valueOf(range.offset));
                init.string(String.valueOf(range.length));
                init.end();
                if (specialization != null && parentAccess) {
                    init.startGroup();
                    init.startCall(".createParentAccessor");
                    init.typeLiteral(this.createSpecializationClassReferenceType(specialization));
                    init.end();
                    init.end();
                }
                init.end();
                continue;
            }
            String inlinedFieldName = this.createCachedInlinedFieldName(specialization, cache, field);
            if (specialization != null && FlatNodeGenFactory.useSpecializationClass(specialization)) {
                if (parentAccess) {
                    init.startGroup();
                    init.string("this.", inlinedFieldName);
                    init.startCall(".createParentAccessor");
                    init.typeLiteral(this.createSpecializationClassReferenceType(specialization));
                    init.end();
                    init.end();
                    continue;
                }
                init.startStaticCall(field.getFieldType(), "create");
                init.startGroup();
                init.tree(this.createLookupNodeType(this.createSpecializationClassReferenceType(specialization), this.specializationClasses.get(specialization).getEnclosedElements()));
                init.end();
                init.doubleQuote(inlinedFieldName);
                if (field.isReference()) {
                    init.typeLiteral(field.getType());
                }
                init.end();
                continue;
            }
            init.string(inlinedFieldName);
        }
        init.end();
        init.end();
        init.end();
        CodeVariableElement var = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), parameter.getType(), fieldName);
        CodeTreeBuilder builder = var.createDocBuilder();
        builder.startJavadoc();
        FlatNodeGenFactory.addSourceDoc(builder, specialization, cache, null);
        builder.end();
        return var;
    }

    private String createLocalCachedInlinedName(SpecializationData specialization, CacheExpression cache) {
        String sharedName = this.sharedCaches.get(cache);
        if (sharedName != null && specialization != null && this.hasCacheParentAccess(cache)) {
            return specialization.getId().toLowerCase() + NAME_SUFFIX + sharedName + NAME_SUFFIX;
        }
        return this.createFieldName(specialization, cache);
    }

    private String createCachedInlinedFieldName(SpecializationData specialization, CacheExpression cache, InlineFieldData field) {
        return this.createFieldName(specialization, cache) + NAME_SUFFIX + field.getName() + NAME_SUFFIX;
    }

    static void addStateDoc(CodeTreeBuilder docBuilder, BitSet set) {
        docBuilder.string("State Info: <pre>").newLine();
        for (BitStateList.BitRangedState value : set.getStates().getEntries()) {
            BitSet.BitRange range = value.bitRange;
            docBuilder.string("  ");
            docBuilder.string(String.valueOf(range.offset));
            if (range.length != 1) {
                docBuilder.string("-").string(String.valueOf(range.offset + range.length - 1));
            }
            docBuilder.string(": ");
            value.state.addStateDoc(docBuilder);
            docBuilder.newLine();
        }
        docBuilder.string("</pre>");
    }

    private static void addSourceDoc(CodeTreeBuilder builder, SpecializationData specialization, CacheExpression cache, InlineFieldData inlinedField) {
        builder.string("Source Info: <pre>").newLine();
        FlatNodeGenFactory.addCacheInfo(builder, "  ", specialization, cache, inlinedField);
        builder.string("</pre>");
    }

    static void addCacheInfo(CodeTreeBuilder builder, String linePrefix, SpecializationData specialization, CacheExpression cache, InlineFieldData inlinedField) {
        Element specializationSource = FlatNodeGenFactory.resolveSpecializationSource(specialization, cache);
        if (specializationSource != null) {
            builder.string(linePrefix).string("Specialization: ").javadocLink(specializationSource, null);
        }
        if (cache != null) {
            builder.newLine();
            builder.string(linePrefix).string("Parameter: ");
            FlatNodeGenFactory.linkParameter(builder, cache.getParameter().getType(), cache.getParameter().getVariableElement().getSimpleName().toString());
            if (cache.getInlinedNode() != null) {
                builder.newLine();
                builder.string(linePrefix).string("Inline method: ");
                builder.javadocLink(cache.getInlinedNode().getMethod(), null);
            }
        }
        if (inlinedField != null && !inlinedField.isState()) {
            builder.newLine();
            builder.string(linePrefix).string("Inline field: ");
            FlatNodeGenFactory.linkParameter(builder, inlinedField.getType(), inlinedField.getName());
        }
    }

    static Element resolveSpecializationSource(SpecializationData specialization, CacheExpression cache) {
        Element specializationSource = specialization != null && specialization.getMethod() != null ? specialization.getMethod() : (cache != null ? cache.getParameter().getVariableElement().getEnclosingElement() : null);
        return specializationSource;
    }

    private static void linkParameter(CodeTreeBuilder builder, TypeMirror type, String name) {
        TypeElement typeElement = ElementUtils.fromTypeMirror(type);
        if (typeElement != null) {
            builder.javadocLink(typeElement, null);
        } else {
            builder.string(ElementUtils.getSimpleName(type));
        }
        builder.string(" ").string(name);
    }

    private void generateAOT(CodeTypeElement clazz, boolean inlined) {
        BitSet set4;
        GeneratedTypeMirror aotProviderType = new GeneratedTypeMirror(ElementUtils.getPackageName(this.types.GenerateAOT_Provider), "GenerateAOT.Provider");
        clazz.getImplements().add(aotProviderType);
        CodeExecutableElement prepare = clazz.add(CodeExecutableElement.cloneNoAnnotations(ElementUtils.findMethod(this.types.GenerateAOT_Provider, "prepareForAOT", inlined ? 3 : 2)));
        prepare.getModifiers().remove((Object)Modifier.DEFAULT);
        GeneratorUtils.addOverride(prepare);
        prepare.getModifiers().remove((Object)Modifier.ABSTRACT);
        CodeTreeBuilder builder = prepare.createBuilder();
        ArrayList<SpecializationData> filteredSpecializations = new ArrayList<SpecializationData>();
        for (NodeData currentNode : this.sharingNodes) {
            for (SpecializationData specializationData : currentNode.getReachableSpecializations()) {
                if (specializationData.getMethod() == null || !specializationData.isPrepareForAOT()) continue;
                filteredSpecializations.add(specializationData);
            }
        }
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, prepare);
        frameState.setBoolean(AOT_STATE, true);
        frameState.setInlinedNode(inlined);
        if (inlined) {
            prepare.renameArguments("language", "root", frameState.getValue(this.node.getChildExecutions().get(0)).getName());
        } else {
            prepare.renameArguments("language", "root");
        }
        LinkedHashMap<BitSet, List> stateGroup = new LinkedHashMap<BitSet, List>();
        LinkedHashSet<SpecializationGroup.TypeGuard> implicitCasts = new LinkedHashSet<SpecializationGroup.TypeGuard>();
        for (SpecializationData specializationData : filteredSpecializations) {
            for (BitSet bitSet : this.allMultiState.getSets()) {
                if (bitSet.contains(AOT_PREPARED)) {
                    stateGroup.computeIfAbsent(bitSet, s -> new ArrayList());
                }
                if (!bitSet.contains(StateQuery.create(BitStateList.SpecializationActive.class, specializationData))) continue;
                stateGroup.computeIfAbsent(bitSet, s -> new ArrayList()).add(specializationData);
                break;
            }
            int index = 0;
            for (Parameter p : specializationData.getSignatureParameters()) {
                TypeMirror targetType = p.getType();
                Collection<TypeMirror> collection = this.node.getTypeSystem().lookupSourceTypes(targetType);
                if (collection.size() > 1) {
                    implicitCasts.add(new SpecializationGroup.TypeGuard(this.node.getTypeSystem(), targetType, index));
                }
                ++index;
            }
        }
        builder.startAssert();
        builder.string("!isAdoptable() || ");
        builder.string("(").cast(this.context.getType(ReentrantLock.class), CodeTreeBuilder.singleString("getLock()"));
        builder.string(").isHeldByCurrentThread()");
        builder.string(" : ").doubleQuote("During prepare AST lock must be held.");
        builder.end();
        for (BitSet bitSet : this.multiState.getSets()) {
            if (!bitSet.contains(AOT_PREPARED)) continue;
            builder.startIf();
            builder.tree(bitSet.createContains(frameState, AOT_PREPARED));
            builder.end().startBlock();
            builder.returnDefault();
            builder.end();
            break;
        }
        ArrayList<GuardExpression> arrayList = new ArrayList<GuardExpression>();
        for (SpecializationData specialization : filteredSpecializations) {
            builder.startBlock();
            FrameState frameState2 = frameState.copy();
            SpecializationGroup specializationGroup = SpecializationGroup.create(Arrays.asList(specialization));
            for (CacheExpression cacheExpression : specialization.getCaches()) {
                if (!cacheExpression.isAlwaysInitialized()) continue;
                this.setCacheInitialized(frameState2, specialization, cacheExpression, true);
            }
            ArrayList<IfTriple> tripples = new ArrayList<IfTriple>();
            for (AssumptionExpression assumption : specialization.getAssumptionExpressions()) {
                tripples.addAll(this.createAssumptionSlowPathTriples(frameState2, specializationGroup, assumption));
            }
            for (Object triple : tripples) {
                ((IfTriple)triple).condition = null;
            }
            ArrayList<GuardExpression> arrayList2 = new ArrayList<GuardExpression>();
            for (GuardExpression guard : specialization.getGuards()) {
                if (FlatNodeGenFactory.guardNeedsStateBit(specialization, guard)) {
                    arrayList.add(guard);
                }
                if (specialization.isDynamicParameterBound(guard.getExpression(), true)) continue;
                arrayList2.add(guard);
            }
            tripples.addAll(this.createMethodGuardChecks(frameState2, specializationGroup, arrayList2, NodeExecutionMode.SLOW_PATH));
            BlockState blockState = IfTriple.materialize(builder, tripples, false);
            builder.tree(this.createSpecialize(builder, frameState2, null, specializationGroup, specialization, true));
            for (CacheExpression cache3 : specialization.getCaches()) {
                if (cache3.isAlwaysInitialized()) continue;
                boolean cachedLibrary = cache3.isCachedLibrary();
                if (cachedLibrary) {
                    builder.startIf().tree(this.createCacheAccess(frameState2, specialization, cache3, null)).instanceOf(aotProviderType).end().startBlock();
                }
                if (NodeCodeGenerator.isSpecializedNode(cache3.getParameter().getType()) || cachedLibrary) {
                    builder.startAssert().startStaticCall(this.types.NodeUtil, "assertRecursion");
                    builder.tree(this.createCacheAccess(frameState2, specialization, cache3, null));
                    builder.string("1");
                    builder.end().end();
                    builder.startStatement();
                    builder.string("(");
                    builder.cast(aotProviderType);
                    builder.tree(this.createCacheAccess(frameState2, specialization, cache3, null));
                    builder.string(")");
                    builder.startCall(".prepareForAOT");
                    builder.string("language").string("root");
                    if (cache3.getInlinedNode() != null) {
                        if (frameState.isInlinedNode()) {
                            builder.tree(frameState2.getValue(0).createReference());
                        } else {
                            builder.string("this");
                        }
                    }
                    builder.end();
                    builder.end();
                }
                if (!cachedLibrary) continue;
                builder.end();
            }
            builder.tree(this.multiState.createSet(frameState2, null, StateQuery.create(BitStateList.SpecializationActive.class, specialization), true, true));
            builder.end(blockState.blockCount);
            builder.end();
        }
        MultiBitSet.StateTransaction stateTransaction = new MultiBitSet.StateTransaction();
        builder.tree(this.multiState.createForceLoad(frameState, AOT_PREPARED, StateQuery.create(BitStateList.GuardActive.class, arrayList), StateQuery.create(BitStateList.ImplicitCastState.class, implicitCasts)));
        builder.tree(this.multiState.createSet(frameState, stateTransaction, AOT_PREPARED, true, false));
        builder.tree(this.multiState.createSet(frameState, stateTransaction, StateQuery.create(BitStateList.GuardActive.class, arrayList), true, false));
        builder.tree(this.multiState.createSet(frameState, stateTransaction, StateQuery.create(BitStateList.ImplicitCastState.class, implicitCasts), true, false));
        builder.tree(this.multiState.persistTransaction(frameState, stateTransaction));
        if (!FlatNodeGenFactory.needsAOTReset(this.node, this.sharingNodes)) {
            return;
        }
        CodeExecutableElement reset = clazz.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), this.context.getType(Void.TYPE), "resetAOT_", new CodeVariableElement[0]));
        frameState = FrameState.load(this, NodeExecutionMode.FAST_PATH, reset);
        frameState.setInlinedNode(inlined);
        if (inlined) {
            reset.addParameter(new CodeVariableElement(this.types.Node, frameState.getValue(this.node.getChildExecutions().get(0)).getName()));
        }
        reset.getModifiers().remove((Object)Modifier.ABSTRACT);
        builder = reset.createBuilder();
        Iterator<BitSet> iterator = this.multiState.all.iterator();
        if (iterator.hasNext() && (set4 = iterator.next()).contains(AOT_PREPARED)) {
            builder.tree(set4.createLoad(frameState));
            builder.startIf();
            builder.tree(set4.createNotContains(frameState, AOT_PREPARED));
            builder.end().startBlock();
            builder.returnDefault();
            builder.end();
        }
        for (BitSet set : this.multiState.getSets()) {
            builder.tree(set.createSetZero(frameState, true));
        }
        for (SpecializationData specialization : filteredSpecializations) {
            if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
                builder.startStatement();
                builder.tree(this.createSpecializationFieldAccess(frameState, specialization, true, true, null, CodeTreeBuilder.singleString("null")));
                builder.end();
                continue;
            }
            for (CacheExpression cacheExpression : specialization.getCaches()) {
                if (cacheExpression.isAlwaysInitialized() || cacheExpression.isEagerInitialize() || cacheExpression.isBind()) continue;
                if (this.types.Profile != null && (ElementUtils.isAssignable(cacheExpression.getParameter().getType(), this.types.Profile) || ElementUtils.isAssignable(cacheExpression.getParameter().getType(), this.types.InlinedProfile))) {
                    builder.startStatement();
                    builder.tree(this.createCacheAccess(frameState, specialization, cacheExpression, null));
                    builder.startCall(".reset");
                    if (cacheExpression.getInlinedNode() != null) {
                        builder.tree(FlatNodeGenFactory.createNodeAccess(frameState, specialization));
                    }
                    builder.end();
                    builder.end();
                    continue;
                }
                if (cacheExpression.getInlinedNode() != null) continue;
                builder.startStatement();
                builder.tree(this.createCacheAccess(frameState, specialization, cacheExpression, CodeTreeBuilder.singleString(ElementUtils.defaultValue(cacheExpression.getParameter().getType()))));
                builder.end();
            }
        }
    }

    public List<CodeVariableElement> createUncachedFields() {
        ArrayList<CodeVariableElement> fields = new ArrayList<CodeVariableElement>();
        return fields;
    }

    public CodeTree createInitializeCaches(SpecializationData specialization, List<CacheExpression> expressions, CodeExecutableElement method, String receiverName) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, method);
        NodeExecutionData execution = specialization.getNode().getChildExecutions().get(0);
        frameState.set(execution, frameState.getValue(execution).accessWith(CodeTreeBuilder.singleString(receiverName)));
        for (CacheExpression cache : expressions) {
            ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
            triples.addAll(this.persistAndInitializeCache(frameState, NodeExecutionMode.SLOW_PATH, specialization, cache, false, true));
            IfTriple.materialize(b, triples, true);
        }
        return b.build();
    }

    private static ReportPolymorphismAction reportPolymorphismAction(NodeData node, List<SpecializationData> reachableSpecializations) {
        if (reachableSpecializations.size() == 1 && reachableSpecializations.get(0).getMaximumNumberOfInstances() == 1) {
            return new ReportPolymorphismAction(false, false);
        }
        boolean reportMegamorphism = reachableSpecializations.stream().anyMatch(SpecializationData::isReportMegamorphism);
        if (reachableSpecializations.stream().noneMatch(SpecializationData::isReportPolymorphism)) {
            return new ReportPolymorphismAction(false, reportMegamorphism);
        }
        return new ReportPolymorphismAction(node.isReportPolymorphism(), reportMegamorphism);
    }

    private void generateIntrospectionInfo(CodeTypeElement clazz, boolean inlined) {
        clazz.getImplements().add(new GeneratedTypeMirror(ElementUtils.getPackageName(this.types.Introspection_Provider), "Introspection.Provider"));
        CodeExecutableElement reflection = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), this.types.Introspection, "getIntrospectionData", new CodeVariableElement[0]);
        GeneratorUtils.addOverride(reflection);
        CodeTreeBuilder builder = reflection.createBuilder();
        ArrayList<SpecializationData> filteredSpecializations = new ArrayList<SpecializationData>();
        for (SpecializationData s : this.node.getSpecializations()) {
            if (s.getMethod() == null) continue;
            filteredSpecializations.add(s);
        }
        CodeTypeMirror.ArrayCodeTypeMirror objectArray = new CodeTypeMirror.ArrayCodeTypeMirror(this.context.getType(Object.class));
        builder.declaration((TypeMirror)objectArray, "data", builder.create().startNewArray(objectArray, CodeTreeBuilder.singleString(String.valueOf(filteredSpecializations.size() + 1))).end().build());
        builder.declaration((TypeMirror)objectArray, "s", (CodeTree)null);
        builder.statement("data[0] = 0");
        boolean needsRewrites = this.needsRewrites();
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, reflection);
        frameState.setInlinedNode(inlined);
        if (inlined) {
            reflection.addParameter(frameState.getValue(0).createParameter());
        }
        StateQuery specializationsActive = StateQuery.create(BitStateList.SpecializationActive.class, filteredSpecializations);
        StateQuery specializationsExcluded = StateQuery.create(BitStateList.SpecializationExcluded.class, filteredSpecializations);
        if (needsRewrites) {
            builder.tree(this.multiState.createLoad(frameState, specializationsActive, specializationsExcluded));
        }
        int index = 1;
        for (SpecializationData specialization : filteredSpecializations) {
            FrameState innerFrameState = frameState.copy();
            builder.startStatement().string("s = ").startNewArray(objectArray, CodeTreeBuilder.singleString("3")).end().end();
            builder.startStatement().string("s[0] = ").doubleQuote(specialization.getMethodName()).end();
            BlockState blocks = BlockState.NONE;
            if (needsRewrites) {
                builder.startIf().tree(this.createSpecializationActiveCheck(frameState, Arrays.asList(specialization))).end().startBlock();
                List<IfTriple> tripples = this.createFastPathNeverDefaultGuards(innerFrameState, specialization);
                blocks = IfTriple.materialize(builder, tripples, false);
            }
            builder.startStatement().string("s[1] = (byte)0b01 /* active */").end();
            CodeTypeMirror.DeclaredCodeTypeMirror listType = new CodeTypeMirror.DeclaredCodeTypeMirror((TypeElement)this.context.getDeclaredType(ArrayList.class).asElement(), Arrays.asList(this.context.getType(Object.class)));
            if (!specialization.getCaches().isEmpty()) {
                builder.declaration((TypeMirror)listType, "cached", "new ArrayList<>()");
                boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
                String name = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                if (useSpecializationClass) {
                    builder.tree(this.loadSpecializationClass(innerFrameState, specialization, false));
                    if (specialization.hasMultipleInstances()) {
                        builder.startWhile();
                    } else {
                        builder.startIf();
                    }
                    builder.string(name, " != null");
                    builder.end();
                    builder.startBlock();
                }
                builder.startStatement().startCall("cached", "add");
                builder.startStaticCall(this.context.getType(Arrays.class), "<Object>asList");
                for (CacheExpression cache : specialization.getCaches()) {
                    if (cache.isAlwaysInitialized()) continue;
                    builder.startGroup();
                    if (cache.isAlwaysInitialized() && cache.isCachedLibrary()) {
                        builder.staticReference(FlatNodeGenFactory.createLibraryConstant(this.constants, cache.getParameter().getType()));
                        builder.startCall(".getUncached").end();
                    } else {
                        builder.tree(this.createCacheAccess(innerFrameState, specialization, cache, null));
                    }
                    builder.end();
                }
                builder.end();
                builder.end().end();
                if (useSpecializationClass) {
                    if (specialization.getMaximumNumberOfInstances() > 1) {
                        builder.startStatement().string(name, " = ", name, ".next_").end();
                    }
                    builder.end();
                }
                builder.statement("s[2] = cached");
            }
            if (needsRewrites) {
                CodeTree excludeCheck;
                builder.end(blocks.blockCount);
                builder.end();
                builder.startIf().string("s[1] == null").end().startBlock();
                ArrayList<IfTriple> excludeTripples = new ArrayList<IfTriple>();
                if (FlatNodeGenFactory.hasExcludeBit(specialization)) {
                    excludeCheck = this.multiState.createNotContains(frameState, StateQuery.create(BitStateList.SpecializationExcluded.class, specialization));
                    excludeTripples.add(0, new IfTriple(null, excludeCheck, null));
                }
                if (FlatNodeGenFactory.hasExcludes(specialization)) {
                    excludeCheck = this.multiState.createContains(frameState, StateQuery.create(BitStateList.SpecializationActive.class, specialization.getReplacedBy()));
                    excludeTripples.add(0, new IfTriple(null, excludeCheck, null));
                }
                BlockState excludeBlocks = BlockState.NONE;
                if (!excludeTripples.isEmpty()) {
                    excludeBlocks = IfTriple.materialize(builder, IfTriple.optimize(excludeTripples), false);
                    builder.startStatement().string("s[1] = (byte)0b10 /* excluded */").end();
                    builder.end(excludeBlocks.blockCount);
                    builder.startElseBlock();
                }
                builder.startStatement().string("s[1] = (byte)0b00 /* inactive */").end();
                if (!excludeTripples.isEmpty()) {
                    builder.end();
                }
                builder.end();
            }
            builder.startStatement().string("data[", String.valueOf(index), "] = s").end();
            ++index;
        }
        builder.startReturn().startStaticCall(this.types.Introspection_Provider, "create").string("data").end().end();
        clazz.add(reflection);
    }

    private List<Element> createCachedFields(CodeTypeElement baseType) {
        ArrayList<Element> nodeElements = new ArrayList<Element>();
        HashSet<String> expressions = new HashSet<String>();
        if (this.primaryNode) {
            for (Map.Entry entry : this.sharedCaches.entrySet()) {
                CacheExpression cache = (CacheExpression)entry.getKey();
                String fieldName = (String)entry.getValue();
                if (expressions.contains(fieldName)) continue;
                expressions.add(fieldName);
                this.createCachedFieldsImpl(nodeElements, nodeElements, null, null, cache, true);
            }
        }
        for (SpecializationData specializationData : this.node.getReachableSpecializations()) {
            boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specializationData);
            MultiStateBitSet specializationState = this.lookupSpecializationState(specializationData);
            ArrayList<Element> specializationClassElements = useSpecializationClass ? new ArrayList<Element>() : nodeElements;
            for (CacheExpression cache : specializationData.getCaches()) {
                boolean shared = this.sharedCaches.containsKey(cache);
                if (shared && !this.hasCacheParentAccess(cache)) continue;
                this.createCachedFieldsImpl(nodeElements, specializationClassElements, specializationData, specializationState, cache, !shared);
            }
            for (AssumptionExpression assumption : specializationData.getAssumptionExpressions()) {
                int compilationFinalDimensions;
                ReferenceType type;
                if (!assumption.needsCaching()) continue;
                String fieldName = FlatNodeGenFactory.createAssumptionFieldName(specializationData, assumption);
                if (assumption.getExpression().getResolvedType().getKind() == TypeKind.ARRAY) {
                    type = new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Assumption);
                    compilationFinalDimensions = 1;
                } else {
                    type = this.types.Assumption;
                    compilationFinalDimensions = -1;
                }
                CodeVariableElement assumptionField = useSpecializationClass ? FlatNodeGenFactory.createNodeField(null, type, fieldName, null, new Modifier[0]) : FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, type, fieldName, null, new Modifier[0]);
                FlatNodeGenFactory.addCompilationFinalAnnotation(assumptionField, compilationFinalDimensions);
                if (useSpecializationClass) {
                    specializationClassElements.add(assumptionField);
                    continue;
                }
                nodeElements.add(assumptionField);
            }
            if (!useSpecializationClass) continue;
            this.createSpecializationClass(baseType, specializationData, specializationState, specializationClassElements);
            CodeVariableElement specializationClassVar = FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, this.createSpecializationClassReferenceType(specializationData), this.createSpecializationFieldName(specializationData), null, new Modifier[0]);
            if (FlatNodeGenFactory.needsUpdater(specializationData) && baseType != null) {
                GeneratorUtils.markUnsafeAccessed(specializationClassVar);
            }
            if (FlatNodeGenFactory.specializationClassIsNode(specializationData)) {
                specializationClassVar.getAnnotationMirrors().add(new CodeAnnotationMirror(ProcessorContext.types().Node_Child));
            } else {
                specializationClassVar.getAnnotationMirrors().add(new CodeAnnotationMirror(ProcessorContext.types().CompilerDirectives_CompilationFinal));
            }
            nodeElements.add(specializationClassVar);
        }
        return nodeElements;
    }

    private static boolean needsUpdater(SpecializationData specialization) {
        if (!specialization.getNode().isGenerateCached()) {
            return false;
        }
        return FlatNodeGenFactory.needsDuplicationCheck(specialization);
    }

    private static boolean needsDuplicationCheck(SpecializationData specialization) {
        if (specialization.hasMultipleInstances()) {
            return true;
        }
        return specialization.isGuardBindsCache();
    }

    private CodeTypeElement createCacheClass(CacheExpression cache, CodeVariableElement wrappedField, boolean needsAdoption) {
        TypeMirror baseType = needsAdoption ? this.types.Node : this.context.getType(Object.class);
        CodeTypeElement specializationClass = GeneratorUtils.createClass(this.node, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC), FlatNodeGenFactory.createCacheClassName(cache), baseType);
        specializationClass.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.DenyReplace));
        specializationClass.add(wrappedField);
        wrappedField.setName("delegate");
        return specializationClass;
    }

    private CodeTree createLookupNodeType(TypeMirror lookupType, List<? extends Element> elements) {
        List<? extends Element> enclosingElements = elements;
        ExecutableElement found = null;
        for (ExecutableElement method : ElementFilter.methodsIn(enclosingElements)) {
            if (!method.getSimpleName().toString().equals("lookup_")) continue;
            found = method;
            break;
        }
        if (found == null) {
            found = this.createLookupMethod();
            enclosingElements.add(found);
        }
        return FlatNodeGenFactory.createLookupCall(lookupType);
    }

    private static CodeTree createLookupCall(TypeMirror type) {
        return CodeTreeBuilder.createBuilder().startStaticCall(type, "lookup_").end().build();
    }

    private ExecutableElement createLookupMethod() {
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC), this.context.getType(MethodHandles.Lookup.class), "lookup_", new CodeVariableElement[0]);
        CodeTreeBuilder builder = method.createBuilder();
        builder.startReturn().startStaticCall(this.context.getType(MethodHandles.class), "lookup").end().end();
        return method;
    }

    private String createSpecializationClassUpdaterName(SpecializationData specialization) {
        return ElementUtils.createConstantName(this.createSpecializationFieldName(specialization)) + "_UPDATER";
    }

    private void createSpecializationClass(CodeTypeElement enclosingType, SpecializationData specialization, MultiStateBitSet specializationState, List<Element> specializationClassElements) {
        DeclaredType annotationType;
        CodeTypeElement specializationClass = this.specializationClasses.get(specialization);
        if (specializationClass != null) {
            return;
        }
        if (specializationClassElements.isEmpty() && specializationState != null && specializationState.getCapacity() == 0) {
            throw new AssertionError((Object)"Should not create an empty specialization class.");
        }
        boolean useNode = FlatNodeGenFactory.specializationClassIsNode(specialization);
        TypeMirror baseType = useNode ? this.types.Node : this.context.getType(Object.class);
        specializationClass = GeneratorUtils.createClass(this.node, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC), this.createSpecializationTypeName(specialization), baseType);
        specializationClass.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.DenyReplace));
        this.specializationClasses.put(specialization, specializationClass);
        TypeMirror referenceType = this.createSpecializationClassReferenceType(specialization);
        if (FlatNodeGenFactory.needsUpdater(specialization) && enclosingType != null) {
            CodeTypeMirror.DeclaredCodeTypeMirror fieldType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(this.types.InlineSupport_ReferenceField), Arrays.asList(referenceType));
            CodeVariableElement updater = new CodeVariableElement(ElementUtils.modifiers(Modifier.STATIC, Modifier.FINAL), fieldType, this.createSpecializationClassUpdaterName(specialization));
            CodeTreeBuilder init = updater.createInitBuilder();
            init.startStaticCall(this.types.InlineSupport_ReferenceField, "create");
            init.startStaticCall(this.context.getType(MethodHandles.class), "lookup").end();
            init.doubleQuote(this.createSpecializationFieldName(specialization));
            init.typeLiteral(referenceType);
            init.end();
            enclosingType.getEnclosedElements().add(updater);
        }
        if (useNode) {
            annotationType = this.types.Node_Child;
            CodeExecutableElement getNodeCost = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), this.types.NodeCost, "getCost", new CodeVariableElement[0]);
            getNodeCost.createBuilder().startReturn().staticReference(this.types.NodeCost, "NONE").end();
            specializationClass.add(getNodeCost);
        } else {
            annotationType = this.types.CompilerDirectives_CompilationFinal;
        }
        String nextName = "next_";
        if (specialization.getMaximumNumberOfInstances() > 1) {
            CodeVariableElement var = FlatNodeGenFactory.createNodeField(null, referenceType, nextName, annotationType, new Modifier[0]);
            if (annotationType != this.types.Node_Child) {
                var.getModifiers().add(Modifier.FINAL);
            }
            specializationClass.add(var);
        }
        specializationClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), specializationClass));
        if (specializationState != null) {
            specializationClass.addAll(specializationState.createCachedFields());
        }
        specializationClass.getEnclosedElements().addAll(specializationClassElements);
        if (FlatNodeGenFactory.specializationClassNeedsCopyConstructor(specialization)) {
            if (specialization.getMaximumNumberOfInstances() > 1) {
                throw new AssertionError((Object)"Copy constructor with next_ field is dangerous.");
            }
            specializationClass.add(GeneratorUtils.createCopyConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), specializationClass, Collections.emptySet()));
        }
        if (specialization.hasMultipleInstances() && !specialization.getAssumptionExpressions().isEmpty()) {
            CodeExecutableElement remove = specializationClass.add(new CodeExecutableElement(referenceType, "remove"));
            remove.addParameter(new CodeVariableElement(referenceType, "search"));
            CodeTreeBuilder builder = remove.createBuilder();
            builder.declaration(referenceType, "newNext", "this.next_");
            builder.startIf().string("newNext != null").end().startBlock();
            builder.startIf().string("search == newNext").end().startBlock();
            builder.statement("newNext = newNext.next_");
            builder.end().startElseBlock();
            builder.statement("newNext = newNext.remove(search)");
            builder.end();
            builder.end();
            builder.declaration(referenceType, "copy", builder.create().startNew(referenceType).string("newNext").end());
            for (Element element : specializationClassElements) {
                if (!(element instanceof VariableElement) || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                String name = element.getSimpleName().toString();
                builder.startStatement().string("copy.", name, " = this.", name).end();
            }
            builder.startReturn().string("copy").end();
        }
    }

    private TypeMirror createSpecializationClassReferenceType(SpecializationData specialization) {
        CodeTypeElement type = this.specializationClasses.get(specialization);
        if (type == null) {
            TypeMirror baseType = FlatNodeGenFactory.specializationClassIsNode(specialization) ? this.types.Node : this.context.getType(Object.class);
            return new GeneratedTypeMirror("", this.createSpecializationTypeName(specialization), baseType);
        }
        return new GeneratedTypeMirror("", type.getSimpleName().toString(), type.getSuperclass());
    }

    private MultiStateBitSet lookupSpecializationState(SpecializationData specialization) {
        MultiStateBitSet specializationState = this.specializationStates.get(specialization);
        if (!this.specializationStates.containsKey(specialization)) {
            BitStateList list = FlatNodeGenFactory.computeSpecializationState(specialization);
            if (list.getBitCount() > 0) {
                specializationState = FlatNodeGenFactory.createMultiStateBitset(ElementUtils.firstLetterLowerCase(specialization.getId()) + NAME_SUFFIX, specialization.getNode(), list);
            }
            this.specializationStates.put(specialization, specializationState);
        }
        return specializationState;
    }

    private void createCachedFieldsImpl(List<Element> nodeElements, List<Element> specializationClassElements, SpecializationData specialization, MultiStateBitSet specializationState, CacheExpression cache, boolean generateInlinedFields) {
        if (cache.isAlwaysInitialized()) {
            return;
        }
        if (cache.isEncodedEnum()) {
            return;
        }
        CacheExpression sharedCache = this.lookupSharedCacheKey(cache);
        InlinedNodeData inline = sharedCache.getInlinedNode();
        if (inline != null) {
            boolean parentAccess = this.hasCacheParentAccess(cache);
            Parameter parameter = cache.getParameter();
            String fieldName = this.createStaticInlinedCacheName(specialization, cache);
            ExecutableElement cacheMethod = cache.getInlinedNode().getMethod();
            CodeVariableElement cachedField = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), parameter.getType(), fieldName);
            CodeTreeBuilder builder = cachedField.createInitBuilder();
            builder.startStaticCall(cacheMethod);
            builder.startStaticCall(ProcessorContext.types().InlineSupport_InlineTarget, "create");
            builder.typeLiteral(cache.getParameter().getType());
            for (InlineFieldData field : inline.getFields()) {
                builder.startGroup();
                if (field.isState()) {
                    BitSet specializationBitSet = this.findInlinedState(specializationState, field);
                    CodeVariableElement updaterField = this.createStateUpdaterField(specialization, specializationState, field, specializationClassElements);
                    String updaterFieldName = updaterField.getName();
                    builder.startCall(updaterFieldName, "subUpdater");
                    BitSet.BitRange range = specializationBitSet.getStates().queryRange(StateQuery.create(BitStateList.InlinedNodeState.class, field));
                    builder.string(String.valueOf(range.offset));
                    builder.string(String.valueOf(range.length));
                    builder.end();
                } else {
                    String inlinedFieldName = this.createCachedInlinedFieldName(specialization, cache, field);
                    TypeMirror type = field.getType();
                    if (generateInlinedFields) {
                        CodeVariableElement inlinedCacheField;
                        if (ElementUtils.isAssignable(type, ProcessorContext.types().Node)) {
                            inlinedCacheField = FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, this.types.Node, inlinedFieldName, ProcessorContext.types().Node_Child, new Modifier[0]);
                        } else if (ElementUtils.isAssignable(type, ProcessorContext.types().NodeInterface)) {
                            inlinedCacheField = FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, this.types.NodeInterface, inlinedFieldName, ProcessorContext.types().Node_Child, new Modifier[0]);
                        } else if (FlatNodeGenFactory.isNodeArray(type)) {
                            inlinedCacheField = FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Node), inlinedFieldName, ProcessorContext.types().Node_Children, new Modifier[0]);
                        } else {
                            inlinedCacheField = FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, type, inlinedFieldName, null, new Modifier[0]);
                            FlatNodeGenFactory.addCompilationFinalAnnotation(inlinedCacheField, field.getDimensions());
                        }
                        if (specialization != null && FlatNodeGenFactory.useSpecializationClass(specialization) && FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache)) {
                            specializationClassElements.add(inlinedCacheField);
                        } else {
                            nodeElements.add(inlinedCacheField);
                        }
                        GeneratorUtils.markUnsafeAccessed(inlinedCacheField);
                        CodeTreeBuilder javadoc = inlinedCacheField.createDocBuilder();
                        javadoc.startJavadoc();
                        FlatNodeGenFactory.addSourceDoc(javadoc, specialization, cache, field);
                        javadoc.end();
                        GeneratorUtils.mergeSuppressWarnings(inlinedCacheField, "unused");
                    }
                    builder.startStaticCall(field.getFieldType(), "create");
                    if (specialization != null && FlatNodeGenFactory.useSpecializationClass(specialization) && FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache)) {
                        builder.tree(this.createLookupNodeType(this.createSpecializationClassReferenceType(specialization), specializationClassElements));
                    } else {
                        builder.startStaticCall(this.context.getType(MethodHandles.class), "lookup").end();
                    }
                    builder.doubleQuote(inlinedFieldName);
                    if (field.isReference()) {
                        builder.typeLiteral(field.getType());
                    }
                    builder.end();
                }
                if (specialization != null && parentAccess) {
                    builder.startCall(".createParentAccessor");
                    builder.typeLiteral(this.createSpecializationClassReferenceType(specialization));
                    builder.end();
                }
                builder.end();
            }
            builder.end();
            builder.end();
            CodeTreeBuilder javadoc = cachedField.createDocBuilder();
            javadoc.startJavadoc();
            FlatNodeGenFactory.addSourceDoc(javadoc, specialization, cache, null);
            javadoc.end();
            nodeElements.add(cachedField);
        } else {
            boolean needsAdoption;
            CodeVariableElement cachedField;
            Modifier visibility;
            Parameter parameter = cache.getParameter();
            String fieldName = this.createFieldName(specialization, cache);
            TypeMirror type = parameter.getType();
            boolean useSpecializationClass = specialization != null ? FlatNodeGenFactory.useSpecializationClass(specialization) : false;
            Modifier modifier = visibility = useSpecializationClass ? null : Modifier.PRIVATE;
            if (ElementUtils.isAssignable(type, ProcessorContext.types().NodeInterface) && cache.isAdopt()) {
                cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, ProcessorContext.types().Node_Child, new Modifier[0]);
                needsAdoption = true;
            } else if (FlatNodeGenFactory.isNodeArray(type) && cache.isAdopt()) {
                cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, ProcessorContext.types().Node_Children, new Modifier[0]);
                needsAdoption = true;
            } else {
                needsAdoption = false;
                cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, null, new Modifier[0]);
                if (cache.isCached()) {
                    AnnotationMirror mirror = cache.getMessageAnnotation();
                    int dimensions = ElementUtils.getAnnotationValue(Integer.class, mirror, "dimensions");
                    FlatNodeGenFactory.addCompilationFinalAnnotation(cachedField, dimensions);
                }
            }
            CodeTreeBuilder javadoc = cachedField.createDocBuilder();
            javadoc.startJavadoc();
            FlatNodeGenFactory.addSourceDoc(javadoc, specialization, cache, null);
            javadoc.end();
            if (FlatNodeGenFactory.useCacheClass(specialization, sharedCache)) {
                String name = cachedField.getSimpleName().toString();
                CodeTypeElement cacheClass = this.createCacheClass(sharedCache, cachedField, needsAdoption);
                specializationClassElements.add(cacheClass);
                GeneratedTypeMirror generatedType = new GeneratedTypeMirror("", cacheClass.getSimpleName().toString(), cacheClass.asType());
                CodeVariableElement var = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), generatedType, name);
                FlatNodeGenFactory.addCompilationFinalAnnotation(var, 0, needsAdoption);
                javadoc = var.createDocBuilder();
                javadoc.startJavadoc();
                FlatNodeGenFactory.addSourceDoc(javadoc, specialization, cache, null);
                javadoc.newLine().string("Note: Shared cache value requires a wrapper class for thread-safety.");
                javadoc.newLine().string("Set Cached(neverDefault = true) to avoid the wrapper class.");
                javadoc.end();
                specializationClassElements.add(var);
            } else {
                specializationClassElements.add(cachedField);
            }
        }
    }

    private BitSet findInlinedState(MultiStateBitSet specializationState, InlineFieldData field) throws AssertionError {
        BitSet bitSet = this.state.allState.findSet(BitStateList.InlinedNodeState.class, field);
        if (bitSet == null) {
            bitSet = specializationState.findSet(BitStateList.InlinedNodeState.class, field);
        }
        if (bitSet == null) {
            throw new AssertionError((Object)"Bits not contained.");
        }
        return bitSet;
    }

    private CodeVariableElement createStateUpdaterField(SpecializationData specialization, MultiStateBitSet specializationState, InlineFieldData field, List<Element> specializationClassElements) {
        String updaterFieldName;
        TypeMirror nodeType;
        BitSet bitSet = this.state.allState.findSet(BitStateList.InlinedNodeState.class, field);
        if (bitSet == null) {
            bitSet = this.findInlinedState(specializationState, field);
            if (bitSet == null) {
                throw new AssertionError((Object)"Inlined bits not contained.");
            }
            nodeType = this.createSpecializationClassReferenceType(specialization);
            updaterFieldName = ElementUtils.createConstantName(specialization.getId() + NAME_SUFFIX + bitSet.getName()) + "_UPDATER";
        } else {
            nodeType = null;
            updaterFieldName = ElementUtils.createConstantName(bitSet.getName()) + "_UPDATER";
        }
        CodeVariableElement var = this.nodeConstants.updaterReferences.get(updaterFieldName);
        if (var == null) {
            var = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), field.getFieldType(), updaterFieldName);
            CodeTreeBuilder b = var.createInitBuilder();
            b.startStaticCall(ProcessorContext.types().InlineSupport_StateField, "create");
            if (nodeType == null) {
                b.startStaticCall(this.context.getType(MethodHandles.class), "lookup").end();
            } else {
                b.tree(this.createLookupNodeType(nodeType, specializationClassElements));
            }
            b.doubleQuote(bitSet.getName() + NAME_SUFFIX);
            b.end();
            this.nodeConstants.updaterReferences.put(updaterFieldName, var);
        }
        return var;
    }

    private void generateStatisticsFields(CodeTypeElement clazz) {
        if (this.isGenerateStatistics()) {
            CodeTypeMirror.ArrayCodeTypeMirror stringArray = new CodeTypeMirror.ArrayCodeTypeMirror(this.context.getType(String.class));
            CodeTreeBuilder b = clazz.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), stringArray, "SPECIALIZATION_NAMES")).createInitBuilder();
            b.startNewArray(stringArray, null);
            for (SpecializationData specialization : this.node.getReachableSpecializations()) {
                if (specialization.getMethod() == null) continue;
                b.doubleQuote(specialization.getMethodName());
            }
            b.end();
            b = clazz.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), this.types.SpecializationStatistics_NodeStatistics, "statistics_")).createInitBuilder();
            b.startStaticCall(this.types.SpecializationStatistics_NodeStatistics, "create").string("this").string("SPECIALIZATION_NAMES").end();
        }
    }

    private boolean isGenerateAOT() {
        return this.primaryNode && this.node.isGenerateAOT();
    }

    private boolean isGenerateStatistics() {
        return this.generatorMode == GeneratorMode.DEFAULT && this.primaryNode && this.node.isGenerateStatistics();
    }

    private boolean isGenerateIntrospection() {
        return this.generatorMode == GeneratorMode.DEFAULT && this.primaryNode && this.node.isGenerateIntrospection();
    }

    private static boolean isNodeArray(TypeMirror type) {
        if (type == null) {
            return false;
        }
        return type.getKind() == TypeKind.ARRAY && ElementUtils.isAssignable(((ArrayType)type).getComponentType(), ProcessorContext.getInstance().getTypes().NodeInterface);
    }

    private static void addCompilationFinalAnnotation(CodeVariableElement field, int dimensions, boolean adopt) {
        TypeMirror type = field.getType();
        if (adopt && ElementUtils.isAssignable(type, ProcessorContext.types().NodeInterface)) {
            field.getAnnotationMirrors().add(new CodeAnnotationMirror(ProcessorContext.types().Node_Child));
        } else if (adopt && FlatNodeGenFactory.isNodeArray(type)) {
            field.getAnnotationMirrors().add(new CodeAnnotationMirror(ProcessorContext.types().Node_Children));
        } else {
            if (field.getModifiers().contains((Object)Modifier.FINAL) && dimensions <= 0) {
                return;
            }
            CodeAnnotationMirror annotation = new CodeAnnotationMirror(ProcessorContext.getInstance().getTypes().CompilerDirectives_CompilationFinal);
            if (dimensions > 0 || field.getType().getKind() == TypeKind.ARRAY) {
                annotation.setElementValue(annotation.findExecutableElement("dimensions"), new CodeAnnotationValue(dimensions < 0 ? 0 : dimensions));
            }
            field.getAnnotationMirrors().add(annotation);
        }
    }

    private static void addCompilationFinalAnnotation(CodeVariableElement field, int dimensions) {
        FlatNodeGenFactory.addCompilationFinalAnnotation(field, dimensions, false);
    }

    private static boolean useCacheClass(SpecializationData specialization, CacheExpression cache) {
        return specialization == null && cache.getSharedGroup() != null && !cache.isNeverDefault() && !cache.isEncodedEnum();
    }

    private static boolean specializationClassIsNode(SpecializationData specialization) {
        for (CacheExpression cache : specialization.getCaches()) {
            if (cache.getInlinedNode() != null) {
                return true;
            }
            if (!FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache)) continue;
            TypeMirror type = cache.getParameter().getType();
            if (ElementUtils.isAssignable(type, ProcessorContext.types().NodeInterface)) {
                return true;
            }
            if (!FlatNodeGenFactory.isNodeArray(type)) continue;
            return true;
        }
        return false;
    }

    private List<SpecializationData> getFallbackSpecializations() {
        ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>(this.node.getReachableSpecializations());
        ListIterator iterator = specializations.listIterator();
        while (iterator.hasNext()) {
            SpecializationData specialization = (SpecializationData)iterator.next();
            if (specialization.isFallback()) {
                iterator.remove();
                continue;
            }
            if (specialization.isReachesFallback()) continue;
            iterator.remove();
        }
        return specializations;
    }

    private List<GuardExpression> getFallbackGuards() {
        ArrayList<GuardExpression> fallbackState = new ArrayList<GuardExpression>();
        List<SpecializationData> specializations = this.getFallbackSpecializations();
        for (SpecializationData specialization : specializations) {
            for (GuardExpression guard : specialization.getGuards()) {
                if (!FlatNodeGenFactory.guardNeedsStateBit(specialization, guard)) continue;
                fallbackState.add(guard);
            }
        }
        return fallbackState;
    }

    private Element createFallbackGuard(boolean inlined) {
        boolean frameUsed = false;
        List<SpecializationData> specializations = this.getFallbackSpecializations();
        for (SpecializationData specialization : specializations) {
            if (!specialization.isFrameUsedByGuard()) continue;
            frameUsed = true;
        }
        SpecializationGroup group = SpecializationGroup.create(specializations);
        ExecutableTypeData executableType = this.node.findAnyGenericExecutableType(this.context, -1);
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), this.getType(Boolean.TYPE), this.createFallbackName(), new CodeVariableElement[0]);
        FrameState frameState = FrameState.load(this, NodeExecutionMode.FALLBACK_GUARD, method);
        if (!frameUsed) {
            frameState.removeValue(FRAME_VALUE);
        }
        this.fallbackNeedsState = false;
        this.fallbackNeedsFrame = frameUsed;
        this.multiState.createLoad(frameState, StateQuery.create(BitStateList.SpecializationActive.class, this.getFallbackSpecializations()), StateQuery.create(BitStateList.GuardActive.class, this.getFallbackGuards()));
        this.multiState.addParametersTo(frameState, method);
        frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE);
        frameState.setInlinedNode(inlined);
        LinkedHashSet<? extends TypeMirror> thrownTypes = new LinkedHashSet<TypeMirror>();
        for (SpecializationData specialization : specializations) {
            for (GuardExpression expression : specialization.getGuards()) {
                for (ExecutableElement boundMethod : expression.getExpression().findBoundExecutableElements()) {
                    thrownTypes.addAll(boundMethod.getThrownTypes());
                }
            }
        }
        method.getThrownTypes().addAll(thrownTypes);
        CodeTree result = this.visitSpecializationGroup(CodeTreeBuilder.createBuilder(), null, group, executableType, frameState, null);
        if (!this.fallbackNeedsState) {
            this.multiState.removeParametersFrom(method);
        }
        CodeTreeBuilder builder = method.createBuilder();
        for (SpecializationData implemented : specializations) {
            if (implemented.getMaximumNumberOfInstances() <= 1) continue;
            method.getAnnotationMirrors().add(this.createExplodeLoop());
            break;
        }
        builder.tree(result);
        builder.returnTrue();
        GeneratorUtils.mergeSuppressWarnings(method, "static-method");
        return method;
    }

    private DSLExpression substituteContextReference(DSLExpression.Call call) {
        DSLExpression.ClassLiteral literal = (DSLExpression.ClassLiteral)call.getParameters().get(0);
        CodeVariableElement var = FlatNodeGenFactory.createContextReferenceConstant(this.constants, literal.getLiteral());
        String constantName = var.getSimpleName().toString();
        DSLExpression.Variable singleton = new DSLExpression.Variable(null, constantName);
        singleton.setResolvedTargetType(var.asType());
        singleton.setResolvedVariable(var);
        return singleton;
    }

    private DSLExpression substituteLanguageReference(DSLExpression.Call call) {
        DSLExpression.ClassLiteral literal = (DSLExpression.ClassLiteral)call.getParameters().get(0);
        CodeVariableElement var = FlatNodeGenFactory.createLanguageReferenceConstant(this.constants, literal.getLiteral());
        String constantName = var.getSimpleName().toString();
        DSLExpression.Variable singleton = new DSLExpression.Variable(null, constantName);
        singleton.setResolvedTargetType(var.asType());
        singleton.setResolvedVariable(var);
        return singleton;
    }

    public static CodeVariableElement createLanguageReferenceConstant(StaticConstants constants, TypeMirror languageType) {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        String constantName = ElementUtils.createConstantName(ElementUtils.getSimpleName(languageType) + "Lref");
        TypeElement languageReference = (TypeElement)types.TruffleLanguage_LanguageReference.asElement();
        CodeTypeMirror.DeclaredCodeTypeMirror constantType = new CodeTypeMirror.DeclaredCodeTypeMirror(languageReference, Arrays.asList(languageType));
        return FlatNodeGenFactory.lookupConstant(constants.languageReferences, constantName, name -> {
            CodeVariableElement newVar = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), constantType, (String)name);
            newVar.createInitBuilder().startStaticCall(languageReference.asType(), "create").typeLiteral(languageType).end();
            return newVar;
        });
    }

    public static CodeVariableElement createContextReferenceConstant(StaticConstants constants, TypeMirror languageType) {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        String constantName = ElementUtils.createConstantName(ElementUtils.getSimpleName(languageType) + "Cref");
        TypeElement contextReference = (TypeElement)types.TruffleLanguage_ContextReference.asElement();
        CodeTypeMirror.DeclaredCodeTypeMirror constantType = new CodeTypeMirror.DeclaredCodeTypeMirror(contextReference, Arrays.asList(NodeParser.findContextTypeFromLanguage(languageType)));
        return FlatNodeGenFactory.lookupConstant(constants.languageReferences, constantName, name -> {
            CodeVariableElement newVar = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), constantType, (String)name);
            newVar.createInitBuilder().startStaticCall(contextReference.asType(), "create").typeLiteral(languageType).end();
            return newVar;
        });
    }

    private DSLExpression substituteLibraryCall(DSLExpression.Call call) {
        DSLExpression.ClassLiteral literal = (DSLExpression.ClassLiteral)call.getParameters().get(0);
        CodeVariableElement var = FlatNodeGenFactory.createLibraryConstant(this.constants, literal.getLiteral());
        String constantName = var.getSimpleName().toString();
        DSLExpression.Variable singleton = new DSLExpression.Variable(null, constantName);
        singleton.setResolvedTargetType(var.asType());
        singleton.setResolvedVariable(var);
        return singleton;
    }

    public static CodeVariableElement createLibraryConstant(StaticConstants constants, TypeMirror libraryTypeMirror) {
        TypeElement libraryType = ElementUtils.castTypeElement(libraryTypeMirror);
        String constantName = ElementUtils.createConstantName(libraryType.getSimpleName().toString());
        TypeElement resolvedLibrary = (TypeElement)ProcessorContext.getInstance().getTypes().LibraryFactory.asElement();
        CodeTypeMirror.DeclaredCodeTypeMirror constantType = new CodeTypeMirror.DeclaredCodeTypeMirror(resolvedLibrary, Arrays.asList(libraryType.asType()));
        return FlatNodeGenFactory.lookupConstant(constants.libraries, constantName, name -> {
            CodeVariableElement newVar = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), constantType, (String)name);
            newVar.createInitBuilder().startStaticCall(resolvedLibrary.asType(), "resolve").typeLiteral(libraryType.asType()).end();
            return newVar;
        });
    }

    private static CodeVariableElement lookupConstant(Map<String, CodeVariableElement> constants, String constantName, Function<String, CodeVariableElement> factory) {
        String useConstantName = constantName + NAME_SUFFIX;
        while (true) {
            CodeVariableElement prev = constants.get(useConstantName);
            CodeVariableElement var = factory.apply(useConstantName);
            if (prev == null) {
                constants.put(useConstantName, var);
                return var;
            }
            if (ElementUtils.variableEquals(prev, var)) {
                return prev;
            }
            useConstantName = useConstantName + NAME_SUFFIX;
        }
    }

    private DSLExpression optimizeExpression(DSLExpression expression) {
        return expression.reduce(new DSLExpression.DSLExpressionReducer(){

            @Override
            public DSLExpression visitVariable(DSLExpression.Variable binary) {
                return binary;
            }

            @Override
            public DSLExpression visitNegate(DSLExpression.Negate negate) {
                return negate;
            }

            @Override
            public DSLExpression visitCall(DSLExpression.Call binary) {
                for (ExecutableElement substitution : FlatNodeGenFactory.this.substitutions.keySet()) {
                    if (!ElementUtils.executableEquals(binary.getResolvedMethod(), substitution)) continue;
                    return FlatNodeGenFactory.this.substitutions.get(substitution).apply(binary);
                }
                return binary;
            }

            @Override
            public DSLExpression visitBinary(DSLExpression.Binary binary) {
                return binary;
            }
        });
    }

    private CodeAnnotationMirror createExplodeLoop() {
        return new CodeAnnotationMirror(this.types.ExplodeLoop);
    }

    private List<SpecializationData> filterCompatibleSpecializations(Collection<SpecializationData> specializations, ExecutableTypeData forType) {
        ArrayList<SpecializationData> filteredSpecializations = new ArrayList<SpecializationData>();
        block0: for (SpecializationData specialization : specializations) {
            if (specialization.isFallback() && specialization.getMethod() == null) continue;
            List<TypeMirror> signatureParameters = forType.getSignatureParameters();
            for (int i = 0; i < signatureParameters.size(); ++i) {
                Parameter specializedParameter;
                TypeMirror specializedType;
                TypeMirror evaluatedType = signatureParameters.get(i);
                if (this.typeSystem.lookupCast(evaluatedType, specializedType = (specializedParameter = specialization.findParameter(this.node.getChildExecutions().get(i))) == null ? evaluatedType : specializedParameter.getType()) == null && !ElementUtils.isSubtypeBoxed(this.context, specializedType, evaluatedType) && !ElementUtils.isSubtypeBoxed(this.context, evaluatedType, specializedType)) continue block0;
            }
            TypeMirror returnType = forType.getReturnType();
            if (!ElementUtils.isVoid(returnType) && !ElementUtils.isSubtypeBoxed(this.context, specialization.getReturnType().getType(), returnType) && !ElementUtils.isSubtypeBoxed(this.context, returnType, specialization.getReturnType().getType())) continue;
            filteredSpecializations.add(specialization);
        }
        return filteredSpecializations;
    }

    private List<SpecializationData> filterImplementedSpecializations(List<SpecializationData> specializations, TypeMirror expectedReturnType) {
        ArrayList<SpecializationData> filteredSpecializations = new ArrayList<SpecializationData>();
        TypeMirror returnType = ElementUtils.boxType(this.context, expectedReturnType);
        for (SpecializationData specialization : specializations) {
            TypeMirror specializationReturnType = ElementUtils.boxType(this.context, specialization.getReturnType().getType());
            if (!ElementUtils.typeEquals(specializationReturnType, returnType)) continue;
            filteredSpecializations.add(specialization);
        }
        return filteredSpecializations;
    }

    private List<ExecutableTypeData> filterCompatibleExecutableTypes(ExecutableTypeData type, List<ExecutableTypeData> genericExecutes) {
        ArrayList<ExecutableTypeData> compatible = new ArrayList<ExecutableTypeData>();
        block0: for (ExecutableTypeData genericExecute : genericExecutes) {
            if (genericExecute.getEvaluatedCount() != type.getEvaluatedCount()) continue;
            for (int i = 0; i < genericExecute.getEvaluatedCount(); ++i) {
                TypeMirror targetType;
                TypeMirror sourceType = type.getSignatureParameters().get(i);
                if (!ElementUtils.isAssignable(sourceType, targetType = genericExecute.getSignatureParameters().get(i))) continue block0;
            }
            if (!ElementUtils.isVoid(type.getReturnType()) && !ElementUtils.isSubtypeBoxed(this.context, type.getReturnType(), genericExecute.getReturnType()) && !ElementUtils.isSubtypeBoxed(this.context, genericExecute.getReturnType(), type.getReturnType())) continue;
            compatible.add(genericExecute);
        }
        return compatible;
    }

    private CodeExecutableElement createExecute(CodeTypeElement clazz, ExecutableTypeData type, List<ExecutableTypeData> delegateableTypes, boolean inlined) {
        List<SpecializationData> allSpecializations = this.node.getReachableSpecializations();
        List<SpecializationData> compatibleSpecializations = this.filterCompatibleSpecializations(allSpecializations, type);
        List<SpecializationData> implementedSpecializations = delegateableTypes.isEmpty() ? compatibleSpecializations : this.filterImplementedSpecializations(compatibleSpecializations, type.getReturnType());
        CodeExecutableElement method = this.createExecuteMethod(type);
        FrameState frameState = FrameState.load(this, type, Integer.MAX_VALUE, NodeExecutionMode.FAST_PATH, method);
        frameState.setInlinedNode(inlined);
        if (type.getMethod() == null) {
            frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE);
        } else {
            this.renameOriginalParameters(type, method, frameState);
        }
        clazz.add(method);
        CodeTreeBuilder builder = method.createBuilder();
        if (compatibleSpecializations.size() != implementedSpecializations.size()) {
            ExecuteDelegationResult delegation = this.createExecuteDelegation(builder, frameState, type, delegateableTypes, compatibleSpecializations, implementedSpecializations);
            builder.tree(delegation.tree);
            if (!delegation.hasFallthrough) {
                return method;
            }
        }
        if (implementedSpecializations.isEmpty()) {
            implementedSpecializations = compatibleSpecializations;
        }
        if (implementedSpecializations.isEmpty()) {
            builder.tree(GeneratorUtils.createShouldNotReachHere("Delegation failed."));
        } else {
            SpecializationGroup group = SpecializationGroup.create(implementedSpecializations);
            builder.tree(this.createFastPath(builder, implementedSpecializations, group, type, frameState));
        }
        return method;
    }

    public CodeExecutableElement createUncached() {
        SpecializationData fallback = this.node.getFallbackSpecialization();
        TypeMirror returnType = fallback.getReturnType().getType();
        ArrayList<TypeMirror> parameterTypes = new ArrayList<TypeMirror>();
        for (Parameter parameter : fallback.getSignatureParameters()) {
            parameterTypes.add(parameter.getType());
        }
        ExecutableTypeData forType = new ExecutableTypeData(this.node, returnType, "uncached", null, parameterTypes);
        return this.createUncachedExecute(forType);
    }

    private CodeExecutableElement createUncachedExecute(ExecutableTypeData forType) {
        boolean isExecutableInUncached;
        NodeExecutionData childExecution;
        int effectiveEvaluatedCount;
        Collection<SpecializationData> allSpecializations = this.node.computeUncachedSpecializations(this.node.getReachableSpecializations());
        List<SpecializationData> compatibleSpecializations = this.filterCompatibleSpecializations(allSpecializations, forType);
        CodeExecutableElement method = this.createExecuteMethod(forType);
        FrameState frameState = FrameState.load(this, forType, Integer.MAX_VALUE, NodeExecutionMode.UNCACHED, method);
        if (forType.getMethod() == null) {
            frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE);
        } else {
            this.renameOriginalParameters(forType, method, frameState);
        }
        CodeTreeBuilder builder = method.createBuilder();
        for (effectiveEvaluatedCount = forType.getEvaluatedCount(); effectiveEvaluatedCount < this.node.getExecutionCount() && (childExecution = this.node.getChildExecutions().get(effectiveEvaluatedCount)).getChild() != null && childExecution.getChild().isAllowUncached(); ++effectiveEvaluatedCount) {
            ExecutableTypeData type = childExecution.getChild().findAnyGenericExecutableType(this.context);
            LocalVariable local = frameState.createValue(childExecution, type.getReturnType());
            CodeTree init = this.callUncachedChildExecuteMethod(childExecution, type, frameState);
            builder.declaration(type.getReturnType(), local.getName(), init);
            frameState.set(childExecution, local);
        }
        boolean bl = isExecutableInUncached = effectiveEvaluatedCount != this.node.getExecutionCount() && !this.node.getChildren().isEmpty();
        if (!isExecutableInUncached) {
            GeneratorUtils.addBoundaryOrTransferToInterpreter(method, builder);
        }
        if (forType.getMethod() != null) {
            method.getModifiers().addAll(forType.getMethod().getModifiers());
            method.getModifiers().remove((Object)Modifier.ABSTRACT);
        }
        if (isExecutableInUncached) {
            builder.tree(GeneratorUtils.createShouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters."));
        } else {
            this.generateTraceOnEnterCall(builder, frameState);
            this.generateTraceOnExceptionStart(builder);
            SpecializationGroup group = SpecializationGroup.create(compatibleSpecializations);
            FrameState originalFrameState = frameState.copy();
            builder.tree(this.visitSpecializationGroup(builder, null, group, forType, frameState, allSpecializations));
            if (group.hasFallthrough()) {
                builder.tree(this.createThrowUnsupported(builder, originalFrameState));
            }
            this.generateTraceOnExceptionEnd(builder);
        }
        return method;
    }

    private ExecuteDelegationResult createExecuteDelegation(CodeTreeBuilder parent, FrameState frameState, ExecutableTypeData type, List<ExecutableTypeData> delegateableTypes, List<SpecializationData> compatibleSpecializations, List<SpecializationData> implementedSpecializations) {
        CodeTreeBuilder builder = parent.create();
        ArrayList<SpecializationData> notImplemented = new ArrayList<SpecializationData>(compatibleSpecializations);
        for (SpecializationData specialization : implementedSpecializations) {
            notImplemented.remove(specialization);
        }
        if (notImplemented.isEmpty()) {
            throw new AssertionError();
        }
        List<ExecutableTypeData> compatibleDelegateTypes = this.filterCompatibleExecutableTypes(type, delegateableTypes);
        ArrayList<ExecutableTypeData> delegatedDelegateTypes = new ArrayList<ExecutableTypeData>();
        CodeTreeBuilder delegateBuilder = builder.create();
        boolean elseIf = false;
        boolean coversAllSpecializations = false;
        if (this.boxingEliminationEnabled) {
            HashSet<TypeMirror> optimizeTypes = new HashSet<TypeMirror>();
            for (SpecializationData specialization : this.node.getReachableSpecializations()) {
                TypeMirror returnType = specialization.getReturnType().getType();
                if (!ElementUtils.isPrimitive(returnType)) continue;
                optimizeTypes.add(returnType);
            }
            for (TypeMirror optimizedType : ElementUtils.uniqueSortedTypes(optimizeTypes, true)) {
                ExecutableTypeData delegateType = null;
                for (ExecutableTypeData compatibleType : compatibleDelegateTypes) {
                    if (!ElementUtils.typeEquals(compatibleType.getReturnType(), optimizedType)) continue;
                    delegateType = compatibleType;
                    break;
                }
                if (delegateType == null) continue;
                List<SpecializationData> delegateSpecializations = this.filterImplementedSpecializations(this.filterCompatibleSpecializations(this.node.getReachableSpecializations(), delegateType), delegateType.getReturnType());
                boolean bl = coversAllSpecializations = delegateSpecializations.size() == this.node.getReachableSpecializations().size();
                if (!coversAllSpecializations) {
                    builder.tree(this.multiState.createLoadFastPath(frameState, delegateSpecializations));
                    elseIf = delegateBuilder.startIf(elseIf);
                    delegateBuilder.startGroup();
                    CodeTree tree = this.multiState.createContainsOnly(frameState, 0, -1, StateQuery.create(BitStateList.SpecializationActive.class, delegateSpecializations), StateQuery.create(BitStateList.SpecializationActive.class, this.node.getReachableSpecializations()));
                    if (!tree.isEmpty()) {
                        delegateBuilder.tree(tree);
                        delegateBuilder.string(" && ");
                    }
                    delegateBuilder.tree(this.multiState.createIsNotAny(frameState, StateQuery.create(BitStateList.SpecializationActive.class, this.node.getReachableSpecializations())));
                    delegateBuilder.end();
                    delegateBuilder.end();
                    delegateBuilder.startBlock();
                }
                delegatedDelegateTypes.add(delegateType);
                delegateBuilder.tree(this.createCallExecute(type, delegateType, frameState));
                if (!coversAllSpecializations) {
                    delegateBuilder.end();
                }
                if (!coversAllSpecializations) continue;
                break;
            }
        }
        if (!compatibleDelegateTypes.isEmpty() && !coversAllSpecializations) {
            ExecutableTypeData delegateType = compatibleDelegateTypes.get(0);
            boolean bl = coversAllSpecializations = notImplemented.size() == this.node.getReachableSpecializations().size();
            if (!coversAllSpecializations) {
                builder.tree(this.multiState.createLoadFastPath(frameState, notImplemented));
                elseIf = delegateBuilder.startIf(elseIf);
                delegateBuilder.tree(this.multiState.createContains(frameState, StateQuery.create(BitStateList.SpecializationActive.class, notImplemented))).end();
                delegateBuilder.startBlock();
            }
            delegatedDelegateTypes.add(delegateType);
            delegateBuilder.tree(this.createCallExecute(type, delegateType, frameState));
            if (!coversAllSpecializations) {
                delegateBuilder.end();
            }
        }
        boolean hasUnexpected = false;
        for (ExecutableTypeData delegateType : delegatedDelegateTypes) {
            if (!this.needsUnexpectedResultException(delegateType)) continue;
            hasUnexpected = true;
            break;
        }
        if (hasUnexpected) {
            builder.startTryBlock();
            builder.tree(delegateBuilder.build());
            builder.end().startCatchBlock(this.types.UnexpectedResultException, "ex");
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            if (ElementUtils.isVoid(type.getReturnType())) {
                builder.returnStatement();
            } else {
                builder.startReturn();
                builder.tree(this.expectOrCast(this.getType(Object.class), type, CodeTreeBuilder.singleString("ex")));
                builder.end();
            }
            builder.end();
        } else {
            builder.tree(delegateBuilder.build());
        }
        return new ExecuteDelegationResult(builder.build(), !coversAllSpecializations);
    }

    private String createFallbackName() {
        if (this.hasMultipleNodes()) {
            String messageName = this.node.getNodeId();
            if (messageName.endsWith("Node")) {
                messageName = messageName.substring(0, messageName.length() - 4);
            }
            return ElementUtils.firstLetterLowerCase(messageName) + "FallbackGuard_";
        }
        return "fallbackGuard_";
    }

    private String createExecuteAndSpecializeName() {
        if (this.hasMultipleNodes()) {
            String messageName = this.node.getNodeId();
            if (messageName.endsWith("Node")) {
                messageName = messageName.substring(0, messageName.length() - 4);
            }
            return ElementUtils.firstLetterLowerCase(messageName) + "AndSpecialize";
        }
        return "executeAndSpecialize";
    }

    private CodeExecutableElement createExecuteAndSpecialize(boolean inlined) {
        if (!this.needsRewrites()) {
            return null;
        }
        String frame = null;
        if (FlatNodeGenFactory.needsFrameToExecute(this.node.getReachableSpecializations())) {
            frame = FRAME_VALUE;
        }
        TypeMirror returnType = this.executeAndSpecializeType.getReturnType();
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), returnType, this.createExecuteAndSpecializeName(), new CodeVariableElement[0]);
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, method);
        frameState.setInlinedNode(inlined);
        frameState.addParametersTo(method, Integer.MAX_VALUE, frame);
        CodeTreeBuilder builder = method.createBuilder();
        ReportPolymorphismAction reportPolymorphismAction = FlatNodeGenFactory.reportPolymorphismAction(this.node, this.node.getReachableSpecializations());
        builder.tree(this.multiState.createLoadSlowPath(frameState, this.node.getReachableSpecializations(), false));
        if (FlatNodeGenFactory.needsAOTReset(this.node, this.sharingNodes)) {
            builder.startIf();
            builder.tree(this.allMultiState.createContains(frameState, AOT_PREPARED));
            builder.end().startBlock();
            builder.startStatement().startCall("this.resetAOT_");
            if (inlined) {
                builder.tree(frameState.getValue(0).createReference());
            }
            builder.end().end();
            builder.tree(this.multiState.createLoadSlowPath(frameState, this.node.getReachableSpecializations(), true));
            builder.end();
        }
        if (reportPolymorphismAction.required()) {
            this.generateSaveOldPolymorphismState(builder, frameState, reportPolymorphismAction);
            builder.startTryBlock();
        }
        FrameState originalFrameState = frameState.copy();
        SpecializationGroup group = this.createSpecializationGroups();
        CodeTree execution = this.visitSpecializationGroup(builder, null, group, this.executeAndSpecializeType, frameState, null);
        builder.tree(execution);
        if (group.hasFallthrough()) {
            builder.tree(this.createThrowUnsupported(builder, originalFrameState));
        }
        if (reportPolymorphismAction.required()) {
            builder.end().startFinallyBlock();
            if (reportPolymorphismAction.required()) {
                this.generateCheckNewPolymorphismState(builder, frameState, reportPolymorphismAction);
            }
            builder.end();
        }
        return method;
    }

    private String createName(String defaultName) {
        if (this.hasMultipleNodes()) {
            String messageName = this.node.getNodeId();
            if (messageName.endsWith("Node")) {
                messageName = messageName.substring(0, messageName.length() - 4);
            }
            return ElementUtils.firstLetterLowerCase(messageName) + NAME_SUFFIX + defaultName;
        }
        return defaultName;
    }

    private boolean requiresCacheCheck(ReportPolymorphismAction reportPolymorphismAction) {
        if (!reportPolymorphismAction.polymorphism) {
            return false;
        }
        for (SpecializationData specialization : this.node.getReachableSpecializations()) {
            if (!FlatNodeGenFactory.useSpecializationClass(specialization) || specialization.getMaximumNumberOfInstances() <= 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Element createCheckForPolymorphicSpecialize(ReportPolymorphismAction reportPolymorphismAction, boolean inlined) {
        TypeMirror returnType = this.getType(Void.TYPE);
        CodeExecutableElement executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), returnType, this.createName(CHECK_FOR_POLYMORPHIC_SPECIALIZE), new CodeVariableElement[0]);
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, executable);
        frameState.setInlinedNode(inlined);
        boolean requiresCacheCheck = this.requiresCacheCheck(reportPolymorphismAction);
        SpecializationData[] relevantSpecializations = this.getSpecalizationsForReportAction(reportPolymorphismAction);
        StateQuery specializationActive = StateQuery.create(BitStateList.SpecializationActive.class, relevantSpecializations);
        StateQuery specializationExcluded = StateQuery.create(BitStateList.SpecializationExcluded.class, relevantSpecializations);
        if (inlined) {
            executable.addParameter(frameState.getValue(0).createParameter());
        }
        ArrayList<BitSet> relevantSets = new ArrayList<BitSet>();
        for (BitSet bitSet : this.multiState.getSets()) {
            if (!bitSet.contains(specializationActive, specializationExcluded)) continue;
            relevantSets.add(bitSet);
        }
        for (BitSet bitSet : relevantSets) {
            executable.addParameter(new CodeVariableElement(bitSet.getType(), FlatNodeGenFactory.getSetOldName(bitSet)));
        }
        if (requiresCacheCheck) {
            executable.addParameter(new CodeVariableElement(this.getType(Integer.TYPE), OLD_CACHE_COUNT));
        }
        CodeTreeBuilder builder = executable.createBuilder();
        if (reportPolymorphismAction.polymorphism) {
            builder.tree(this.multiState.createLoad(frameState, specializationActive, specializationExcluded));
            for (BitSet s : relevantSets) {
                builder.declaration(s.getType(), FlatNodeGenFactory.getSetNewName(s), s.createMaskedReference(frameState, specializationActive, specializationExcluded));
            }
        }
        builder.startIf();
        if (reportPolymorphismAction.polymorphism) {
            String string = "";
            for (BitSet s : relevantSets) {
                void var12_18;
                builder.string((String)var12_18);
                builder.string("((", FlatNodeGenFactory.getSetOldName(s), " ^ ", FlatNodeGenFactory.getSetNewName(s), ") != 0)");
                String string2 = " || ";
            }
            if (requiresCacheCheck) {
                builder.string(" || ", OLD_CACHE_COUNT, " < ");
                builder.startCall(this.createName(COUNT_CACHES));
                if (inlined) {
                    builder.tree(frameState.getValue(0).createReference());
                }
                builder.end();
            }
            if (reportPolymorphismAction.megamorphism) {
                builder.string(" || ");
            }
        }
        if (reportPolymorphismAction.megamorphism) {
            String string = "";
            for (BitSet s : relevantSets) {
                void var12_22;
                builder.string((String)var12_22);
                builder.string("(");
                builder.string("(", FlatNodeGenFactory.getSetOldName(s), " & ", s.formatMask(s.createMask(specializationActive, specializationExcluded)));
                builder.string(") == 0");
                builder.string(" && ");
                builder.tree(s.createMaskedReference(frameState, specializationActive, specializationExcluded));
                builder.string(" != 0");
                builder.string(")");
                String string3 = " || ";
            }
        }
        builder.end();
        builder.startBlock().startStatement();
        if (inlined) {
            builder.tree(frameState.getValue(0).createReference());
        } else {
            builder.string("this");
        }
        builder.string(".");
        builder.startCall(REPORT_POLYMORPHIC_SPECIALIZE).end();
        builder.end(2);
        return executable;
    }

    private SpecializationData[] getSpecalizationsForReportAction(ReportPolymorphismAction reportPolymorphismAction) {
        if (reportPolymorphismAction.polymorphism) {
            return (SpecializationData[])this.node.getReachableSpecializations().stream().filter(SpecializationData::isReportPolymorphism).toArray(SpecializationData[]::new);
        }
        if (reportPolymorphismAction.megamorphism) {
            return (SpecializationData[])this.node.getReachableSpecializations().stream().filter(SpecializationData::isReportMegamorphism).toArray(SpecializationData[]::new);
        }
        return new SpecializationData[0];
    }

    private Element createCountCaches(boolean inlined) {
        TypeMirror returnType = this.getType(Integer.TYPE);
        CodeExecutableElement executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), returnType, this.createName(COUNT_CACHES), new CodeVariableElement[0]);
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, executable);
        frameState.setInlinedNode(inlined);
        if (inlined) {
            executable.addParameter(frameState.getValue(0).createParameter());
        }
        CodeTreeBuilder builder = executable.createBuilder();
        String cacheCount = "cacheCount";
        builder.declaration(this.context.getType(Integer.TYPE), "cacheCount", "0");
        for (SpecializationData specialization : (SpecializationData[])this.node.getReachableSpecializations().stream().filter(SpecializationData::isReportPolymorphism).toArray(SpecializationData[]::new)) {
            if (!FlatNodeGenFactory.useSpecializationClass(specialization) || specialization.getMaximumNumberOfInstances() <= 1) continue;
            builder.tree(this.loadSpecializationClass(frameState, specialization, false));
            CodeTree specializationClass = this.createGetSpecializationClass(frameState, specialization, true);
            builder.startWhile().tree(specializationClass).string(" != null");
            builder.end();
            builder.startBlock();
            builder.statement("cacheCount++");
            builder.startStatement().tree(specializationClass).string(" = ").tree(specializationClass).string(".next_").end();
            builder.end();
            builder.end();
        }
        builder.startReturn().statement("cacheCount");
        return executable;
    }

    private void generateCheckNewPolymorphismState(CodeTreeBuilder builder, FrameState frameState, ReportPolymorphismAction reportPolymorphismAction) {
        SpecializationData[] relevantSpecializations = this.getSpecalizationsForReportAction(reportPolymorphismAction);
        StateQuery query = StateQuery.create(BitStateList.SpecializationActive.class, relevantSpecializations);
        builder.startIf();
        String sep = "";
        for (BitSet s : this.multiState.getSets()) {
            if (!s.contains(query)) continue;
            builder.string(sep);
            builder.string(FlatNodeGenFactory.getSetOldName(s), " != 0");
            sep = " || ";
        }
        builder.end();
        builder.startBlock();
        builder.startStatement();
        builder.startCall(this.createName(CHECK_FOR_POLYMORPHIC_SPECIALIZE));
        if (frameState.isInlinedNode()) {
            builder.tree(frameState.getValue(0).createReference());
        }
        for (BitSet s : this.multiState.getSets()) {
            if (!s.contains(query)) continue;
            builder.string(FlatNodeGenFactory.getSetOldName(s));
        }
        if (this.requiresCacheCheck(reportPolymorphismAction)) {
            builder.string(OLD_CACHE_COUNT);
        }
        builder.end().end().end();
    }

    private void generateSaveOldPolymorphismState(CodeTreeBuilder builder, FrameState frameState, ReportPolymorphismAction reportPolymorphismAction) {
        SpecializationData[] specializations = (SpecializationData[])this.node.getReachableSpecializations().stream().filter(SpecializationData::isReportPolymorphism).toArray(SpecializationData[]::new);
        StateQuery specializationActive = StateQuery.create(BitStateList.SpecializationActive.class, specializations);
        StateQuery specializationExcluded = StateQuery.create(BitStateList.SpecializationExcluded.class, specializations);
        for (BitSet s : this.multiState.getSets()) {
            StateQuery localSpecializationActive = s.filter(specializationActive);
            StateQuery localExclude = s.filter(specializationExcluded);
            if (localSpecializationActive.isEmpty() && localExclude.isEmpty()) continue;
            builder.declaration(s.getType(), FlatNodeGenFactory.getSetOldName(s), s.createMaskedReference(frameState, localSpecializationActive, localExclude));
        }
        if (this.requiresCacheCheck(reportPolymorphismAction)) {
            builder.startStatement();
            builder.type(this.context.getType(Integer.TYPE)).string(" ", OLD_CACHE_COUNT, " = ");
            builder.startCall(this.createName(COUNT_CACHES));
            if (frameState.isInlinedNode()) {
                builder.tree(frameState.getValue(0).createReference());
            }
            builder.end();
            builder.end();
        }
    }

    private static String getSetOldName(BitSet bitSet) {
        return OLD_PREFIX + ElementUtils.firstLetterUpperCase(bitSet.getName());
    }

    private static String getSetNewName(BitSet bitSet) {
        return "new" + ElementUtils.firstLetterUpperCase(bitSet.getName());
    }

    private CodeTree createThrowUnsupported(CodeTreeBuilder parent, FrameState frameState) {
        CodeTreeBuilder builder = parent.create();
        builder.startThrow().startNew(this.types.UnsupportedSpecializationException);
        ExecutableElement method = parent.findMethod();
        if (method != null && method.getModifiers().contains((Object)Modifier.STATIC)) {
            builder.string("null");
        } else {
            builder.string("this");
        }
        builder.startNewArray(new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Node), null);
        ArrayList<CodeTree> values = new ArrayList<CodeTree>();
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            NodeChildData child = execution.getChild();
            LocalVariable var = frameState.getValue(execution);
            if (child != null && !frameState.getMode().isUncached()) {
                builder.string(FlatNodeGenFactory.accessNodeField(execution));
            } else {
                builder.string("null");
            }
            if (var == null) continue;
            values.add(var.createReference());
        }
        builder.end();
        builder.trees(values.toArray(new CodeTree[0]));
        builder.end().end();
        return builder.build();
    }

    private CodeTree createFastPath(CodeTreeBuilder parent, List<SpecializationData> allSpecializations, SpecializationGroup originalGroup, ExecutableTypeData currentType, FrameState frameState) {
        List<BoxingSplit> boxingSplits;
        CodeTreeBuilder builder = parent.create();
        boolean needsRewrites = this.needsRewrites();
        if (needsRewrites) {
            builder.tree(this.multiState.createLoadFastPath(frameState, allSpecializations));
        }
        int sharedExecutes = 0;
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            boolean canExecuteChild = execution.getIndex() < currentType.getEvaluatedCount();
            for (SpecializationGroup.TypeGuard checkedGuard : originalGroup.getTypeGuards()) {
                if (checkedGuard.getSignatureIndex() != execution.getIndex()) continue;
                canExecuteChild = true;
                break;
            }
            if (!canExecuteChild) break;
            for (SpecializationGroup.TypeGuard checkedGuard : originalGroup.getTypeGuards()) {
                if (this.resolveOptimizedImplicitSourceTypes(execution, checkedGuard.getType()).size() <= 1) continue;
                canExecuteChild = false;
                break;
            }
            if (!canExecuteChild) break;
            builder.tree(this.createFastPathExecuteChild(builder, frameState.copy(), frameState, currentType, originalGroup, execution));
            ++sharedExecutes;
        }
        if ((boxingSplits = this.parameterBoxingElimination(originalGroup, sharedExecutes)).isEmpty()) {
            builder.tree(this.executeFastPathGroup(builder, frameState, currentType, originalGroup, sharedExecutes, null));
            this.addExplodeLoop(builder, originalGroup);
        } else {
            FrameState originalFrameState = frameState.copy();
            StateQuery allSpecializationQuery = StateQuery.create(BitStateList.SpecializationActive.class, allSpecializations);
            boolean elseIf = false;
            for (BoxingSplit split : boxingSplits) {
                elseIf = builder.startIf(elseIf);
                builder.startGroup();
                List<SpecializationData> specializations = split.group.collectSpecializations();
                StateQuery specializationQuery = StateQuery.create(BitStateList.SpecializationActive.class, specializations);
                CodeTree tree = this.multiState.createContainsOnly(frameState, 0, -1, specializationQuery, allSpecializationQuery);
                if (!tree.isEmpty()) {
                    builder.tree(tree);
                    builder.string(" && ");
                }
                builder.tree(this.multiState.createIsNotAny(frameState, allSpecializationQuery));
                builder.end();
                builder.end().startBlock();
                builder.tree(this.wrapInAMethod(builder, specializations, split.group, originalFrameState, split.getName(), this.executeFastPathGroup(builder, frameState.copy(), currentType, split.group, sharedExecutes, specializations)));
                builder.end();
            }
            builder.startElseBlock();
            builder.tree(this.wrapInAMethod(builder, allSpecializations, originalGroup, originalFrameState, "generic", this.executeFastPathGroup(builder, frameState, currentType, originalGroup, sharedExecutes, null)));
            builder.end();
        }
        return builder.build();
    }

    private void addExplodeLoop(CodeTreeBuilder builder, SpecializationGroup originalGroup) {
        for (SpecializationData implemented : originalGroup.collectSpecializations()) {
            if (implemented.getMaximumNumberOfInstances() <= 1) continue;
            ((CodeExecutableElement)builder.findMethod()).getAnnotationMirrors().add(this.createExplodeLoop());
            break;
        }
    }

    private CodeTree wrapInAMethod(CodeTreeBuilder parent, List<SpecializationData> specializations, SpecializationGroup group, FrameState frameState, String suffix, CodeTree codeTree) {
        CodeExecutableElement parentMethod = (CodeExecutableElement)parent.findMethod();
        CodeTypeElement parentClass = (CodeTypeElement)parentMethod.getEnclosingElement();
        String name = parentMethod.getSimpleName().toString() + NAME_SUFFIX + suffix + this.boxingSplitIndex++;
        CodeExecutableElement method = parentClass.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), parentMethod.getReturnType(), name, new CodeVariableElement[0]));
        this.multiState.addParametersTo(frameState, method);
        frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE);
        CodeTreeBuilder builder = method.createBuilder();
        int parameterIndex = 0;
        for (BitSet set : this.multiState.getSets()) {
            LocalVariable local = frameState.get(set.getName());
            if (local == null || !MultiStateBitSet.isRelevantForFastPath(set, specializations)) continue;
            CodeVariableElement var = (CodeVariableElement)method.getParameters().get(parameterIndex);
            String oldName = var.getName();
            String newName = var.getName() + "__";
            var.setName(newName);
            builder.declaration(var.getType(), oldName, newName);
            ++parameterIndex;
        }
        builder.tree(codeTree);
        method.getThrownTypes().addAll(parentMethod.getThrownTypes());
        this.addExplodeLoop(builder, group);
        CodeTreeBuilder parentBuilder = parent.create();
        parentBuilder.startReturn();
        parentBuilder.startCall(method.getSimpleName().toString());
        this.multiState.addReferencesTo(frameState, parentBuilder);
        frameState.addReferencesTo(parentBuilder, FRAME_VALUE);
        parentBuilder.end();
        parentBuilder.end();
        return parentBuilder.build();
    }

    private CodeTree executeFastPathGroup(CodeTreeBuilder parent, FrameState frameState, ExecutableTypeData currentType, SpecializationGroup group, int sharedExecutes, List<SpecializationData> allowedSpecializations) {
        CodeTreeBuilder builder = parent.create();
        if (currentType.getMethod() != null && currentType.getMethod().isVarArgs()) {
            int readVarargsCount = this.node.getSignatureSize() - (currentType.getEvaluatedCount() - 1);
            int offset = this.node.getSignatureSize() - 1;
            for (int i = 0; i < readVarargsCount; ++i) {
                NodeExecutionData execution = this.node.getChildExecutions().get(offset + i);
                LocalVariable var = frameState.getValue(execution);
                if (var == null) continue;
                builder.tree(var.createDeclaration(var.createReference()));
                frameState.setValue(execution, var.accessWith(null));
            }
        }
        FrameState originalFrameState = frameState.copy();
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            if (execution.getIndex() < sharedExecutes) continue;
            builder.tree(this.createFastPathExecuteChild(builder, originalFrameState, frameState, currentType, group, execution));
        }
        this.generateTraceOnEnterCall(builder, frameState);
        this.generateTraceOnExceptionStart(builder);
        if (FlatNodeGenFactory.needsAOTReset(this.node, this.sharingNodes) && this.node.needsRewrites(this.context)) {
            builder.startIf();
            builder.startStaticCall(ElementUtils.findMethod(this.types.CompilerDirectives, "inInterpreter")).end();
            builder.string(" && ");
            builder.tree(this.allMultiState.createContains(frameState, AOT_PREPARED));
            builder.end().startBlock();
            builder.tree(this.createCallExecuteAndSpecialize(currentType, originalFrameState));
            builder.end();
        }
        builder.tree(this.visitSpecializationGroup(builder, null, group, currentType, frameState, allowedSpecializations));
        if (group.hasFallthrough()) {
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            builder.tree(this.createCallExecuteAndSpecialize(currentType, originalFrameState));
        }
        this.generateTraceOnExceptionEnd(builder);
        return builder.build();
    }

    private List<BoxingSplit> parameterBoxingElimination(SpecializationGroup group, int evaluatedcount) {
        if (!this.boxingEliminationEnabled) {
            return Collections.emptyList();
        }
        List<SpecializationData> allSpecializations = group.collectSpecializations();
        ArrayList signatures = new ArrayList();
        ArrayList signatureSpecializations = new ArrayList();
        for (SpecializationData specialization : allSpecializations) {
            int index = -1;
            ArrayList<SpecializationGroup.TypeGuard> guards = new ArrayList<SpecializationGroup.TypeGuard>();
            for (Parameter p : specialization.getSignatureParameters()) {
                NodeChildData child;
                if (!ElementUtils.isPrimitive(p.getType()) || ++index < evaluatedcount || (child = p.getSpecification().getExecution().getChild()) != null && child.findExecutableType(p.getType()) == null) continue;
                guards.add(new SpecializationGroup.TypeGuard(this.typeSystem, p.getType(), index));
            }
            if (guards.isEmpty()) continue;
            boolean directFound = false;
            for (int i = 0; i < signatures.size(); ++i) {
                if (!guards.containsAll((Collection)signatures.get(i))) continue;
                if (((Set)signatures.get(i)).containsAll(guards)) {
                    directFound = true;
                }
                ((List)signatureSpecializations.get(i)).add(specialization);
            }
            if (directFound) continue;
            signatures.add(new LinkedHashSet(guards));
            ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>();
            specializations.add(specialization);
            signatureSpecializations.add(specializations);
        }
        ArrayList<BoxingSplit> groups = new ArrayList<BoxingSplit>();
        for (int i = 0; i < signatureSpecializations.size(); ++i) {
            List groupedSpecialization = (List)signatureSpecializations.get(i);
            if (allSpecializations.size() == groupedSpecialization.size()) continue;
            Set signature = (Set)signatures.get(i);
            TypeMirror[] signatureMirrors = new TypeMirror[signature.size()];
            int index = 0;
            for (SpecializationGroup.TypeGuard typeGuard : signature) {
                signatureMirrors[index] = typeGuard.getType();
                ++index;
            }
            groups.add(new BoxingSplit(SpecializationGroup.create(groupedSpecialization), signatureMirrors));
        }
        Collections.sort(groups, new Comparator<BoxingSplit>(){

            @Override
            public int compare(BoxingSplit o1, BoxingSplit o2) {
                return Integer.compare(o2.primitiveSignature.length, o1.primitiveSignature.length);
            }
        });
        return groups;
    }

    private CodeTree createFastPathExecuteChild(CodeTreeBuilder parent, FrameState originalFrameState, FrameState frameState, ExecutableTypeData currentType, SpecializationGroup group, NodeExecutionData execution) {
        CodeTreeBuilder builder = parent.create();
        LocalVariable var = frameState.getValue(execution);
        if (var == null) {
            LocalVariable fallbackVar;
            TypeMirror targetType;
            SpecializationGroup.TypeGuard eliminatedGuard = null;
            if (this.boxingEliminationEnabled) {
                for (SpecializationGroup.TypeGuard checkedGuard : group.getTypeGuards()) {
                    if (!ElementUtils.isPrimitive(checkedGuard.getType()) || this.node.getChildExecutions().get(checkedGuard.getSignatureIndex()).getChild().findExecutableType(checkedGuard.getType()) == null || checkedGuard.getSignatureIndex() != execution.getIndex()) continue;
                    eliminatedGuard = checkedGuard;
                    break;
                }
            }
            if (eliminatedGuard != null) {
                group.getTypeGuards().remove(eliminatedGuard);
                targetType = eliminatedGuard.getType();
            } else {
                targetType = execution.getChild().findAnyGenericExecutableType(this.context).getReturnType();
            }
            var = frameState.createValue(execution, targetType).nextName();
            ArrayList<TypeMirror> originalSourceTypes = new ArrayList<TypeMirror>(this.typeSystem.lookupSourceTypes(targetType));
            List<TypeMirror> sourceTypes = this.resolveOptimizedImplicitSourceTypes(execution, targetType);
            if (sourceTypes.size() > 1) {
                SpecializationGroup.TypeGuard typeGuard = new SpecializationGroup.TypeGuard(this.typeSystem, targetType, execution.getIndex());
                TypeMirror generic = this.node.getPolymorphicExecutable().getParameterTypeOrDie(execution);
                fallbackVar = originalFrameState.createValue(execution, generic);
                Collections.reverse(sourceTypes);
                CodeTree access = var.createReference();
                boolean first = true;
                for (TypeMirror sType : sourceTypes) {
                    if (ElementUtils.typeEquals(sType, targetType)) continue;
                    String localName = FlatNodeGenFactory.createSourceTypeLocalName(var, sType);
                    builder.declaration(sType, localName, CodeTreeBuilder.createBuilder().defaultValue(sType).build());
                    CodeTreeBuilder accessBuilder = builder.create();
                    accessBuilder.startParantheses();
                    CodeTree containsOnly = this.multiState.createContainsOnly(frameState, originalSourceTypes.indexOf(sType), 1, StateQuery.create(BitStateList.ImplicitCastState.class, typeGuard), StateQuery.create(BitStateList.ImplicitCastState.class, typeGuard));
                    if (!containsOnly.isEmpty()) {
                        accessBuilder.tree(containsOnly);
                        accessBuilder.string(" && ");
                    }
                    accessBuilder.tree(this.multiState.createIsNotAny(frameState, StateQuery.create(BitStateList.SpecializationActive.class, this.node.getReachableSpecializations())));
                    accessBuilder.string(" ? ");
                    if (ElementUtils.isPrimitive(sType)) {
                        accessBuilder.string("(").type(generic).string(") ");
                    }
                    accessBuilder.string(localName);
                    accessBuilder.string(" : ");
                    if (first && ElementUtils.isPrimitive(targetType)) {
                        accessBuilder.string("(").type(generic).string(") ");
                    }
                    accessBuilder.tree(access);
                    accessBuilder.end();
                    access = accessBuilder.build();
                    first = false;
                }
                fallbackVar = fallbackVar.accessWith(access);
            } else {
                fallbackVar = var;
            }
            builder.tree(this.createAssignExecuteChild(originalFrameState, frameState, builder, execution, currentType, var));
            frameState.setValue(execution, var);
            originalFrameState.setValue(execution, fallbackVar);
        }
        return builder.build();
    }

    private CodeTree createAssignExecuteChild(FrameState originalFrameState, FrameState frameState, CodeTreeBuilder parent, NodeExecutionData execution, ExecutableTypeData forType, LocalVariable targetValue) {
        CodeTreeBuilder builder = parent.create();
        ChildExecutionResult executeChild = this.createExecuteChild(builder, originalFrameState, frameState, execution, targetValue);
        builder.tree(FlatNodeGenFactory.createTryExecuteChild(targetValue, executeChild.code, true, executeChild.throwsUnexpectedResult));
        builder.end();
        if (executeChild.throwsUnexpectedResult) {
            builder.startCatchBlock(this.types.UnexpectedResultException, "ex");
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            FrameState slowPathFrameState = originalFrameState.copy();
            slowPathFrameState.setValue(execution, targetValue.makeGeneric(this.context).accessWith(CodeTreeBuilder.singleString("ex.getResult()")));
            ExecutableTypeData delegateType = this.node.getGenericExecutableType(forType);
            boolean found = false;
            for (NodeExecutionData otherExecution : this.node.getChildExecutions()) {
                if (found) {
                    LocalVariable childEvaluatedValue = slowPathFrameState.createValue(otherExecution, this.genericType);
                    builder.tree(this.createAssignExecuteChild(slowPathFrameState.copy(), slowPathFrameState, builder, otherExecution, delegateType, childEvaluatedValue));
                    slowPathFrameState.setValue(otherExecution, childEvaluatedValue);
                    continue;
                }
                found = execution == otherExecution;
            }
            builder.tree(this.createCallExecuteAndSpecialize(forType, slowPathFrameState));
            builder.end();
        }
        return builder.build();
    }

    private static String createSourceTypeLocalName(LocalVariable targetValue, TypeMirror sType) {
        return targetValue.getName() + ElementUtils.getSimpleName(sType);
    }

    private ChildExecutionResult createCallSingleChildExecute(NodeExecutionData execution, LocalVariable target, FrameState frameState, ExecutableTypeData executableType) {
        CodeTree execute = this.callChildExecuteMethod(execution, executableType, frameState);
        TypeMirror sourceType = executableType.getReturnType();
        TypeMirror targetType = target.getTypeMirror();
        CodeTree result = this.expect(sourceType, targetType, execute);
        return new ChildExecutionResult(result, executableType.hasUnexpectedValue() || ElementUtils.needsCastTo(sourceType, targetType));
    }

    private ChildExecutionResult createExecuteChild(CodeTreeBuilder parent, FrameState originalFrameState, FrameState frameState, NodeExecutionData execution, LocalVariable target) {
        ChildExecutionResult result;
        if (!this.typeSystem.hasImplicitSourceTypes(target.getTypeMirror())) {
            ExecutableTypeData targetExecutable = this.resolveTargetExecutable(execution, target.typeMirror);
            CodeTreeBuilder builder = parent.create();
            result = this.createCallSingleChildExecute(execution, target, frameState, targetExecutable);
            builder.string(target.getName()).string(" = ");
            builder.tree(result.code);
            result.code = builder.build();
        } else {
            result = this.createExecuteChildImplicitCast(parent.create(), originalFrameState, frameState, execution, target);
        }
        return result;
    }

    private CodeExecutableElement createNodeConstructor(CodeTypeElement clazz, ExecutableElement superConstructor) {
        HashSet<String> ignoreConstructorFields = new HashSet<String>();
        for (NodeFieldData field : this.node.getFields()) {
            if (!field.isSettable()) continue;
            ignoreConstructorFields.add(field.getName());
        }
        CodeExecutableElement constructor = GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), clazz, superConstructor, ignoreConstructorFields);
        ElementUtils.setVisibility(constructor.getModifiers(), ElementUtils.getVisibility(superConstructor.getModifiers()));
        constructor.setVarArgs(superConstructor.isVarArgs());
        ArrayList<CodeVariableElement> childParameters = new ArrayList<CodeVariableElement>();
        for (NodeChildData child : this.node.getChildren()) {
            if (!child.needsGeneratedField() || child.isImplicit()) continue;
            childParameters.add(new CodeVariableElement(child.getOriginalType(), child.getName()));
        }
        constructor.getParameters().addAll(superConstructor.getParameters().size(), childParameters);
        CodeTreeBuilder builder = constructor.appendBuilder();
        ArrayList<String> childValues = new ArrayList<String>(this.node.getChildren().size());
        if (!this.node.getChildExecutions().isEmpty()) {
            for (NodeChildData child : this.node.getChildren()) {
                CreateCastData createCast;
                if (!child.needsGeneratedField()) continue;
                Object name = child.getName();
                if (child.getCardinality().isMany() && (createCast = this.node.findCast(child.getName())) != null) {
                    CodeTree nameTree = CodeTreeBuilder.singleString((String)name);
                    CodeTreeBuilder callBuilder = builder.create();
                    callBuilder.string((String)name).string(" != null ? ");
                    callBuilder.tree(FlatNodeGenFactory.callMethod(null, null, createCast.getMethod(), nameTree));
                    callBuilder.string(" : null");
                    name = (String)name + NAME_SUFFIX;
                    builder.declaration(child.getNodeType(), (String)name, callBuilder.build());
                }
                childValues.add((String)name);
            }
        }
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            CodeTree accessor;
            if (execution.getChild() == null || !execution.getChild().needsGeneratedField()) continue;
            CreateCastData createCast = this.node.findCast(execution.getChild().getName());
            builder.startStatement();
            builder.string("this.").string(FlatNodeGenFactory.nodeFieldName(execution)).string(" = ");
            String name = (String)childValues.get(this.node.getChildren().indexOf(execution.getChild()));
            if (execution.getChild().isImplicit()) {
                accessor = DSLExpressionGenerator.write(execution.getChild().getImplicitCreateExpression(), null, null);
            } else {
                CodeTreeBuilder accessorBuilder = builder.create();
                accessorBuilder.string(name);
                if (execution.hasChildArrayIndex()) {
                    accessorBuilder.string("[").string(String.valueOf(execution.getChildArrayIndex())).string("]");
                }
                accessor = accessorBuilder.build();
            }
            if (createCast != null && execution.getChild().getCardinality().isOne()) {
                accessor = FlatNodeGenFactory.callMethod(null, null, createCast.getMethod(), accessor);
            }
            if (execution.hasChildArrayIndex() && !execution.getChild().isImplicit()) {
                CodeTreeBuilder nullCheck = builder.create();
                nullCheck.string(name).string(" != null && ").string(String.valueOf(execution.getChildArrayIndex())).string(" < ").string(name).string(".length").string(" ? ");
                nullCheck.tree(accessor);
                nullCheck.string(" : null");
                accessor = nullCheck.build();
            }
            builder.tree(accessor);
            builder.end();
        }
        return constructor;
    }

    private List<ExecutableTypeData> filterExecutableTypes(List<ExecutableTypeData> executableTypes, List<SpecializationData> specializations) {
        HashSet<TypeMirror> specializedReturnTypes = new HashSet<TypeMirror>();
        for (SpecializationData specialization : specializations) {
            specializedReturnTypes.add(specialization.getReturnType().getType());
        }
        ArrayList<ExecutableTypeData> filteredTypes = new ArrayList<ExecutableTypeData>();
        block1: for (ExecutableTypeData executable : executableTypes) {
            if (executable.getMethod() == null) continue;
            if (executable.isAbstract()) {
                filteredTypes.add(executable);
                continue;
            }
            if (executable.isFinal()) continue;
            if (!executable.hasUnexpectedValue()) {
                filteredTypes.add(executable);
                continue;
            }
            TypeMirror returnType = executable.getReturnType();
            if (!this.boxingEliminationEnabled || !ElementUtils.isVoid(returnType) && !ElementUtils.isPrimitive(returnType)) continue;
            for (TypeMirror specializedReturnType : specializedReturnTypes) {
                if (!ElementUtils.isSubtypeBoxed(this.context, specializedReturnType, returnType)) continue;
                filteredTypes.add(executable);
                continue block1;
            }
        }
        Collections.sort(filteredTypes);
        return filteredTypes;
    }

    private Element createGetCostMethod(boolean uncached) {
        DeclaredType returnType = this.types.NodeCost;
        CodeExecutableElement executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnType, "getCost", new CodeVariableElement[0]);
        executable.getAnnotationMirrors().add(new CodeAnnotationMirror(this.context.getDeclaredType(Override.class)));
        CodeTreeBuilder builder = executable.createBuilder();
        if (uncached) {
            builder.startReturn().staticReference(this.types.NodeCost, "MEGAMORPHIC").end();
        } else if (this.node.needsRewrites(this.context)) {
            FrameState frameState = FrameState.load(this, NodeExecutionMode.UNCACHED, executable);
            StateQuery allSpecializationQuery = StateQuery.create(BitStateList.SpecializationActive.class, this.node.getReachableSpecializations());
            StateQuery noSpecializationQuery = StateQuery.create(BitStateList.SpecializationActive.class, new SpecializationData[0]);
            builder.tree(this.multiState.createLoad(frameState, allSpecializationQuery));
            builder.startIf().tree(this.multiState.createIs(frameState, noSpecializationQuery, allSpecializationQuery)).end();
            builder.startBlock();
            builder.startReturn().staticReference(this.types.NodeCost, "UNINITIALIZED").end();
            builder.end();
            if (this.node.getReachableSpecializations().size() == 1 && !this.node.getReachableSpecializations().iterator().next().hasMultipleInstances()) {
                builder.startElseBlock();
                builder.startReturn().staticReference(this.types.NodeCost, "MONOMORPHIC").end();
                builder.end();
            } else {
                builder.startElseBlock();
                if (this.multiState.getSets().size() == 1) {
                    builder.startIf();
                    builder.tree(this.multiState.getSets().get(0).createIsOneBitOf(frameState, allSpecializationQuery));
                    builder.end().startBlock();
                } else {
                    builder.declaration("int", "counter", "0");
                    for (BitSet set : this.multiState.getSets()) {
                        StateQuery filtered = set.filter(allSpecializationQuery);
                        if (filtered.isEmpty()) continue;
                        builder.startStatement();
                        builder.string("counter += ");
                        builder.startStaticCall(ElementUtils.findMethod(Integer.class, "bitCount"));
                        builder.tree(set.createMaskedReference(frameState, filtered));
                        builder.end();
                        builder.end();
                    }
                    builder.startIf();
                    builder.string("counter == 1");
                    builder.end().startBlock();
                }
                ArrayList<CodeTree> additionalChecks = new ArrayList<CodeTree>();
                for (SpecializationData specialization : this.node.getReachableSpecializations()) {
                    if (!FlatNodeGenFactory.useSpecializationClass(specialization) || specialization.getMaximumNumberOfInstances() <= 1) continue;
                    String typeName = this.createSpecializationTypeName(specialization);
                    String fieldName = this.createSpecializationFieldName(specialization);
                    String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                    builder.declaration(typeName, localName, "this." + fieldName);
                    CodeTree check = builder.create().startParantheses().string(localName, " == null || ", localName, ".next_ == null").end().build();
                    additionalChecks.add(check);
                }
                if (!additionalChecks.isEmpty()) {
                    builder.startIf().tree(FlatNodeGenFactory.combineTrees(" && ", additionalChecks.toArray(new CodeTree[0]))).end().startBlock();
                }
                builder.startReturn().staticReference(this.types.NodeCost, "MONOMORPHIC").end();
                if (!additionalChecks.isEmpty()) {
                    builder.end();
                }
                builder.end();
                builder.end();
                builder.startReturn().staticReference(this.types.NodeCost, "POLYMORPHIC").end();
            }
        } else {
            builder.startReturn().staticReference(this.types.NodeCost, "MONOMORPHIC").end();
        }
        return executable;
    }

    private static boolean isUndeclaredOrOverrideable(TypeElement sourceType, String methodName) {
        List<ExecutableElement> elements = ElementUtils.getDeclaredMethodsInSuperTypes(sourceType, methodName, new TypeMirror[0]);
        return elements.isEmpty() || !elements.iterator().next().getModifiers().contains((Object)Modifier.FINAL);
    }

    private ExecutableElement createAccessChildMethod(NodeChildData child, boolean uncached) {
        if (child.getAccessElement() != null && child.getAccessElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            ExecutableElement getter = (ExecutableElement)child.getAccessElement();
            CodeExecutableElement method = CodeExecutableElement.clone(getter);
            method.getModifiers().remove((Object)Modifier.ABSTRACT);
            ArrayList<NodeExecutionData> executions = new ArrayList<NodeExecutionData>();
            for (NodeExecutionData execution : this.node.getChildExecutions()) {
                if (execution.getChild() != child) continue;
                executions.add(execution);
            }
            CodeTreeBuilder builder = method.createBuilder();
            if (uncached) {
                if (child.isAllowUncached()) {
                    CodeTree uncachedNode = DSLExpressionGenerator.write(child.getUncachedExpression(), null, null);
                    builder.startReturn().tree(uncachedNode).end();
                } else {
                    GeneratorUtils.addBoundaryOrTransferToInterpreter(method, null);
                    builder.tree(GeneratorUtils.createShouldNotReachHere("This getter method cannot be used for uncached node versions as it requires child nodes to be present."));
                }
            } else if (child.getCardinality().isMany()) {
                builder.startReturn().startNewArray((ArrayType)child.getOriginalType(), null);
                for (NodeExecutionData execution : executions) {
                    builder.string(FlatNodeGenFactory.accessNodeField(execution));
                }
                builder.end().end();
            } else {
                Iterator iterator = executions.iterator();
                if (iterator.hasNext()) {
                    NodeExecutionData execution = (NodeExecutionData)iterator.next();
                    builder.startReturn().string(FlatNodeGenFactory.accessNodeField(execution)).end();
                }
            }
            return method;
        }
        return null;
    }

    private TypeMirror getType(Class<?> clazz) {
        return this.context.getType(clazz);
    }

    static CodeVariableElement createNodeField(Modifier visibility, TypeMirror type, String name, DeclaredType annotationClass, Modifier ... modifiers) {
        CodeVariableElement childField = new CodeVariableElement(ElementUtils.modifiers(modifiers), type, name);
        if (annotationClass != null) {
            if (annotationClass == ProcessorContext.getInstance().getTypes().CompilerDirectives_CompilationFinal) {
                FlatNodeGenFactory.addCompilationFinalAnnotation(childField, 0);
            } else {
                childField.getAnnotationMirrors().add(new CodeAnnotationMirror(annotationClass));
            }
        }
        ElementUtils.setVisibility(childField.getModifiers(), visibility);
        return childField;
    }

    private static CodeTree callMethod(FrameState frameState, CodeTree receiver, ExecutableElement method, CodeTree ... boundValues) {
        VariableElement receiverVar;
        if (frameState != null) {
            frameState.addThrownExceptions(method);
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        List<? extends VariableElement> parameters = method.getParameters();
        CodeTree useReceiver = receiver;
        boolean staticMethod = method.getModifiers().contains((Object)Modifier.STATIC);
        int boundValueIndex = -1;
        if (!method.getParameters().isEmpty() && staticMethod && (receiverVar = method.getParameters().get(0)).getSimpleName().toString().equals("this")) {
            useReceiver = boundValues[0];
            parameters = parameters.subList(1, parameters.size());
            boundValueIndex = 0;
            staticMethod = false;
        }
        if (staticMethod) {
            builder.startStaticCall(method);
        } else {
            builder.startCall(useReceiver, method.getSimpleName().toString());
        }
        for (VariableElement variableElement : parameters) {
            CodeTree tree;
            if (++boundValueIndex < boundValues.length && (tree = boundValues[boundValueIndex]) != null) {
                builder.tree(tree);
                continue;
            }
            builder.defaultValue(variableElement.asType());
        }
        builder.end();
        return builder.build();
    }

    private CodeTree[] bindExecuteMethodParameters(NodeExecutionData execution, ExecutableTypeData method, FrameState frameState) {
        List<NodeExecutionData> executeWith = execution != null ? execution.getChild().getExecuteWith() : null;
        ArrayList<CodeTree> values = new ArrayList<CodeTree>();
        if (method.getFrameParameter() != null) {
            LocalVariable frameLocal = frameState.get(FRAME_VALUE);
            if (frameLocal == null) {
                throw new AssertionError((Object)(method.getName() + " requires a frame parameter."));
            }
            values.add(this.createParameterReference(frameLocal, method.getMethod(), 0));
        }
        int evaluatedIndex = 0;
        for (int executionIndex = 0; executionIndex < this.node.getExecutionCount(); ++executionIndex) {
            NodeExecutionData parameterExecution = executeWith != null && executionIndex < executeWith.size() ? executeWith.get(executionIndex) : this.node.getChildExecutions().get(executionIndex);
            if (evaluatedIndex >= method.getEvaluatedCount()) continue;
            TypeMirror targetType = method.getEvaluatedParameters().get(evaluatedIndex);
            LocalVariable value = frameState.getValue(parameterExecution);
            if (value != null) {
                int parameterIndex = method.getParameterIndex(evaluatedIndex);
                values.add(this.createParameterReference(value, method.getMethod(), parameterIndex));
            } else {
                values.add(CodeTreeBuilder.createBuilder().defaultValue(targetType).build());
            }
            ++evaluatedIndex;
        }
        return values.toArray(new CodeTree[values.size()]);
    }

    private CodeTree callChildExecuteMethod(NodeExecutionData execution, ExecutableTypeData method, FrameState frameState) {
        return FlatNodeGenFactory.callMethod(frameState, CodeTreeBuilder.singleString(FlatNodeGenFactory.accessNodeField(execution)), method.getMethod(), this.bindExecuteMethodParameters(execution, method, frameState));
    }

    private CodeTree callUncachedChildExecuteMethod(NodeExecutionData execution, ExecutableTypeData method, FrameState frameState) {
        assert (execution.getChild().isAllowUncached());
        CodeTree uncachedNode = DSLExpressionGenerator.write(execution.getChild().getUncachedExpression(), null, null);
        return FlatNodeGenFactory.callMethod(frameState, uncachedNode, method.getMethod(), this.bindExecuteMethodParameters(execution, method, frameState));
    }

    private CodeTree createParameterReference(LocalVariable sourceVariable, ExecutableElement targetMethod, int targetIndex) {
        CodeTree valueReference = sourceVariable.createReference();
        TypeMirror sourceType = sourceVariable.getTypeMirror();
        VariableElement targetParameter = targetMethod.getParameters().get(targetIndex);
        TypeMirror targetType = targetParameter.asType();
        if (targetType == null || sourceType == null) {
            return valueReference;
        }
        boolean hasCast = false;
        if (ElementUtils.needsCastTo(sourceType, targetType)) {
            CodeTree castValue = TypeSystemCodeGenerator.cast(this.typeSystem, targetType, valueReference);
            hasCast = valueReference != castValue;
            valueReference = castValue;
        }
        if (!ElementUtils.typeEquals(sourceType, targetType) && !hasCast) {
            Element element = targetMethod.getEnclosingElement();
            boolean needsOverloadCast = false;
            if (element != null) {
                for (ExecutableElement executable : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    TypeMirror overloadedTarget;
                    if (ElementUtils.executableEquals(executable, targetMethod) || !executable.getSimpleName().toString().equals(targetMethod.getSimpleName().toString()) || executable.getParameters().size() != targetMethod.getParameters().size() || ElementUtils.needsCastTo(sourceType, overloadedTarget = executable.getParameters().get(targetIndex).asType())) continue;
                    needsOverloadCast = true;
                    break;
                }
            }
            if (needsOverloadCast) {
                valueReference = TypeSystemCodeGenerator.cast(this.typeSystem, targetType, valueReference);
            }
        }
        return valueReference;
    }

    private SpecializationGroup createSpecializationGroups() {
        return SpecializationGroup.create(this.node.getReachableSpecializations());
    }

    private CodeTree expectOrCast(TypeMirror sourceType, ExecutableTypeData targetType, CodeTree content) {
        if (this.needsUnexpectedResultException(targetType)) {
            return this.expect(sourceType, targetType.getReturnType(), content);
        }
        return this.cast(sourceType, targetType.getReturnType(), content);
    }

    private CodeTree cast(TypeMirror sourceType, TypeMirror targetType, CodeTree content) {
        if (ElementUtils.needsCastTo(sourceType, targetType) && !ElementUtils.isVoid(sourceType)) {
            return TypeSystemCodeGenerator.cast(this.typeSystem, targetType, content);
        }
        return content;
    }

    private CodeTree expect(TypeMirror sourceType, TypeMirror forType, CodeTree tree) {
        if (sourceType == null || ElementUtils.needsCastTo(sourceType, forType)) {
            this.expectedTypes.add(forType);
            return TypeSystemCodeGenerator.expect(this.typeSystem, forType, tree);
        }
        return tree;
    }

    private CodeExecutableElement createExecuteMethod(ExecutableTypeData executedType) {
        CodeExecutableElement executable;
        TypeMirror returnType = executedType.getReturnType();
        String methodName = executedType.getMethod() != null ? executedType.getMethod().getSimpleName().toString() : executedType.getUniqueName();
        if (executedType.getMethod() != null) {
            executable = CodeExecutableElement.clone(executedType.getMethod());
            executable.getAnnotationMirrors().clear();
            executable.getModifiers().remove((Object)Modifier.ABSTRACT);
            for (VariableElement var : executable.getParameters()) {
                ((CodeVariableElement)var).getAnnotationMirrors().clear();
            }
            executable.renameArguments(FRAME_VALUE);
            if (executable.isVarArgs()) {
                ((CodeVariableElement)executable.getParameters().get(executable.getParameters().size() - 1)).setName(VARARGS_NAME);
            }
        } else {
            executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnType, methodName, new CodeVariableElement[0]);
        }
        DeclaredType unexpectedResult = this.types.UnexpectedResultException;
        Iterator<TypeMirror> thrownTypes = executable.getThrownTypes().iterator();
        while (thrownTypes.hasNext()) {
            if (!ElementUtils.typeEquals(unexpectedResult, thrownTypes.next())) continue;
            thrownTypes.remove();
        }
        if (this.needsUnexpectedResultException(executedType)) {
            executable.getThrownTypes().add(unexpectedResult);
        }
        return executable;
    }

    private void renameOriginalParameters(ExecutableTypeData executedType, CodeExecutableElement executable, FrameState frameState) {
        int evaluatedIndex = 0;
        for (int executionIndex = 0; executionIndex < this.node.getExecutionCount(); ++executionIndex) {
            NodeExecutionData execution = this.node.getChildExecutions().get(executionIndex);
            if (evaluatedIndex >= executedType.getEvaluatedCount()) continue;
            TypeMirror evaluatedType = executedType.getEvaluatedParameters().get(evaluatedIndex);
            LocalVariable value = frameState.getValue(execution);
            if (value != null) {
                frameState.setValue(execution, FlatNodeGenFactory.renameExecutableTypeParameter(executable, executedType, evaluatedIndex, evaluatedType, value));
            }
            ++evaluatedIndex;
        }
    }

    private static LocalVariable renameExecutableTypeParameter(CodeExecutableElement method, ExecutableTypeData executedType, int evaluatedIndex, TypeMirror targetType, LocalVariable var) {
        int parameterIndex = executedType.getParameterIndex(evaluatedIndex);
        int varArgsIndex = executedType.getVarArgsIndex(parameterIndex);
        LocalVariable returnVar = var;
        if (varArgsIndex >= 0) {
            returnVar = returnVar.accessWith(CodeTreeBuilder.singleString("args[" + varArgsIndex + "]"));
        } else {
            ((CodeVariableElement)method.getParameters().get(parameterIndex)).setName(returnVar.getName());
        }
        if (!ElementUtils.isObject(targetType)) {
            returnVar = returnVar.newType(targetType);
        }
        return returnVar;
    }

    private boolean needsUnexpectedResultException(ExecutableTypeData executedType) {
        if (!executedType.hasUnexpectedValue()) {
            return false;
        }
        return !ElementUtils.isSubtypeBoxed(this.context, this.executeAndSpecializeType.getReturnType(), executedType.getReturnType());
    }

    private CodeTree createFastPathExecute(CodeTreeBuilder parent, ExecutableTypeData forType, SpecializationData specialization, FrameState frameState) {
        CodeTreeBuilder builder = parent.create();
        int ifCount = 0;
        if (specialization.isFallback()) {
            StateQuery fallbackActive = StateQuery.create(BitStateList.SpecializationActive.class, this.getFallbackSpecializations());
            StateQuery fallbackGuardsActive = StateQuery.create(BitStateList.GuardActive.class, this.getFallbackGuards());
            if (this.fallbackNeedsState) {
                builder.tree(this.multiState.createLoad(frameState, fallbackActive, fallbackGuardsActive));
            }
            builder.startIf().startCall(this.createFallbackName());
            if (this.fallbackNeedsState) {
                this.multiState.addReferencesTo(frameState, builder, fallbackActive, fallbackGuardsActive);
            }
            if (this.fallbackNeedsFrame) {
                if (frameState.get(FRAME_VALUE) != null) {
                    builder.string(FRAME_VALUE);
                } else {
                    builder.nullLiteral();
                }
            }
            frameState.addReferencesTo(builder, new String[0]);
            builder.end();
            builder.end();
            builder.startBlock();
            ++ifCount;
        }
        builder.tree(this.createCallSpecialization(builder, frameState, forType, specialization));
        builder.end(ifCount);
        return builder.build();
    }

    private CodeTree createCallSpecialization(CodeTreeBuilder parent, FrameState parentState, ExecutableTypeData forType, SpecializationData specialization) {
        ExecutableElement targetMethod;
        CodeTreeBuilder builder = parent.create();
        FrameState frameState = parentState.copy();
        for (SpecializationThrowsData throwsData : specialization.getExceptions()) {
            frameState.addCaughtException(throwsData.getJavaClass());
        }
        Set<String> suppressed = TruffleSuppressedWarnings.getWarnings(specialization.getMethod());
        if (!suppressed.isEmpty()) {
            suppressed.retainAll(Arrays.asList("deprecated", "all"));
            GeneratorUtils.mergeSuppressWarnings(frameState.method, suppressed.toArray(new String[suppressed.size()]));
        }
        if ((targetMethod = specialization.getMethod()) == null) {
            builder.tree(this.createThrowUnsupported(builder, frameState));
        } else {
            CodeTree[] bindings = new CodeTree[targetMethod.getParameters().size()];
            TypeMirror[] bindingTypes = new TypeMirror[targetMethod.getParameters().size()];
            for (int i = 0; i < bindings.length; ++i) {
                Parameter parameter = specialization.findByVariable(targetMethod.getParameters().get(i));
                if (parameter == null) continue;
                if (parameter.getSpecification().isCached()) {
                    CacheExpression cache = specialization.findCache(parameter);
                    LocalVariable var = frameState.get(this.createFieldName(specialization, cache));
                    bindings[i] = var != null ? var.createReference() : this.createCacheAccess(frameState, specialization, cache, null);
                    bindingTypes[i] = parameter.getType();
                    continue;
                }
                LocalVariable variable = this.bindExpressionVariable(frameState, specialization, parameter);
                if (variable != null) {
                    bindings[i] = this.createParameterReference(variable, specialization.getMethod(), i);
                    bindingTypes[i] = variable.getTypeMirror();
                    continue;
                }
                bindingTypes[i] = parameter.getType();
            }
            if (this.isGenerateStatistics()) {
                CodeTreeBuilder statistics = builder.create();
                statistics.startStatement();
                statistics.startCall("statistics_", "acceptExecute");
                statistics.string(String.valueOf(specialization.getIntrospectionIndex()));
                for (int i = 0; i < bindings.length; ++i) {
                    Parameter parameter = specialization.getParameters().get(i);
                    if (!parameter.getSpecification().isSignature()) continue;
                    TypeMirror type = bindingTypes[i];
                    if (ElementUtils.isFinal(type)) {
                        statistics.typeLiteral(type);
                        continue;
                    }
                    statistics.startCall("statistics_", "resolveValueClass");
                    statistics.tree(bindings[i]);
                    statistics.end();
                }
                statistics.end();
                statistics.end();
                builder.tree(statistics.build());
            }
            if (frameState.isInlinedNode() && !FlatNodeGenFactory.substituteNodeWithSpecializationClass(specialization)) {
                ArrayList<CodeTree> usedFields = new ArrayList<CodeTree>();
                for (CacheExpression cache : specialization.getCaches()) {
                    if (cache.getSharedGroup() != null || cache.getInlinedNode() == null) continue;
                    for (InlineFieldData field : cache.getInlinedNode().getFields()) {
                        CodeTreeBuilder inner = builder.create();
                        if (field.isState()) {
                            BitSet bitSet = this.state.activeState.findSet(BitStateList.InlinedNodeState.class, field);
                            if (bitSet == null) continue;
                            inner.string("this.", bitSet.getName(), NAME_SUFFIX);
                            usedFields.add(inner.build());
                            continue;
                        }
                        inner.string("this.", this.createCachedInlinedFieldName(specialization, cache, field));
                        usedFields.add(inner.build());
                    }
                }
                if (!usedFields.isEmpty()) {
                    builder.startAssert();
                    builder.startStaticCall(this.types.InlineSupport, "validate");
                    builder.tree(FlatNodeGenFactory.createNodeAccess(frameState, specialization));
                    for (CodeTree field : usedFields) {
                        builder.tree(field);
                    }
                    builder.end();
                    builder.end();
                }
            }
            CodeTree specializationCall = FlatNodeGenFactory.callMethod(frameState, null, specialization.getMethod(), bindings);
            if (ElementUtils.isVoid(specialization.getMethod().getReturnType())) {
                builder.statement(specializationCall);
                if (ElementUtils.isVoid(forType.getReturnType())) {
                    builder.returnStatement();
                } else {
                    builder.startReturn().defaultValue(forType.getReturnType()).end();
                }
            } else {
                builder.startReturn();
                builder.tree(this.expectOrCast(specialization.getReturnType().getType(), forType, specializationCall));
                builder.end();
            }
        }
        return this.createCatchRewriteException(builder, specialization, forType, frameState, builder.build());
    }

    public static boolean guardNeedsStateBit(SpecializationData specialization, GuardExpression guard) {
        return FlatNodeGenFactory.guardNeedsSpecializationStateBit(specialization, guard) || FlatNodeGenFactory.guardNeedsNodeStateBit(specialization, guard);
    }

    public static boolean guardNeedsNodeStateBit(SpecializationData specialization, GuardExpression guard) {
        return specialization.isReachesFallback() && !FlatNodeGenFactory.useSpecializationClass(specialization) && specialization.isGuardBoundWithCache(guard);
    }

    public static boolean guardNeedsSpecializationStateBit(SpecializationData specialization, GuardExpression guard) {
        return specialization.isReachesFallback() && FlatNodeGenFactory.useSpecializationClass(specialization) && specialization.isGuardBoundWithCache(guard);
    }

    private static GuardExpression getGuardThatNeedsStateBit(SpecializationData specialization, GuardExpression guard) {
        if (FlatNodeGenFactory.guardNeedsStateBit(specialization, guard)) {
            return guard;
        }
        List<GuardExpression> guards = specialization.getGuards();
        int index = guards.indexOf(guard);
        if (index < 0) {
            throw new AssertionError((Object)"guard must be contained");
        }
        for (int i = index - 1; i >= 0; --i) {
            GuardExpression otherGuard = guards.get(i);
            if (!FlatNodeGenFactory.guardNeedsStateBit(specialization, otherGuard)) continue;
            return otherGuard;
        }
        return null;
    }

    private CodeTree visitSpecializationGroup(CodeTreeBuilder parent, SpecializationGroup originalPrev, SpecializationGroup group, ExecutableTypeData forType, FrameState frameState, Collection<SpecializationData> allowedSpecializations) {
        boolean useSpecializationClass;
        CodeTreeBuilder builder = parent.create();
        SpecializationGroup prev = originalPrev;
        NodeExecutionMode mode = frameState.getMode();
        boolean hasFallthrough = false;
        boolean hasImplicitCast = false;
        List<IfTriple> cachedTriples = new ArrayList<IfTriple>();
        for (SpecializationGroup.TypeGuard guard : group.getTypeGuards()) {
            IfTriple triple = this.createTypeCheckOrCast(frameState, group, guard, mode, false, true);
            if (triple != null) {
                cachedTriples.add(triple);
            }
            boolean bl = hasImplicitCast = hasImplicitCast || this.node.getTypeSystem().hasImplicitSourceTypes(guard.getType());
            if (mode.isGuardFallback() || (triple = this.createTypeCheckOrCast(frameState, group, guard, mode, true, true)) == null) continue;
            cachedTriples.add(triple);
        }
        SpecializationData specialization = group.getSpecialization();
        ArrayList<GuardExpression> remainingGuards = new ArrayList<GuardExpression>(group.getGuards());
        if (specialization != null && specialization.hasMultipleInstances()) {
            GuardExpression guard;
            ArrayList<GuardExpression> unboundGuards = new ArrayList<GuardExpression>();
            Iterator iterator = remainingGuards.iterator();
            while (iterator.hasNext() && !specialization.isGuardBoundWithCache(guard = (GuardExpression)iterator.next())) {
                unboundGuards.add(guard);
            }
            cachedTriples.addAll(this.createMethodGuardChecks(frameState, group, unboundGuards, mode));
            remainingGuards.removeAll(unboundGuards);
        }
        boolean bl = useSpecializationClass = specialization != null && FlatNodeGenFactory.useSpecializationClass(specialization);
        if (mode.isFastPath()) {
            ifCount = BlockState.NONE;
            cachedTriples.addAll(0, this.createSpecializationActive(frameState, group, allowedSpecializations));
            ifCount = ifCount.add(IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false));
            if (specialization == null) {
                prev = this.visitSpecializationGroupChildren(builder, frameState.copy(), prev, group, forType, allowedSpecializations);
            } else {
                hasFallthrough |= this.buildSpecializationFastPath(builder, frameState, prev, group, forType, remainingGuards);
            }
            builder.end(ifCount.blockCount);
            hasFallthrough |= ifCount.ifCount > 0;
        } else if (mode.isSlowPath()) {
            if (specialization == null) {
                BlockState outerIfCount = BlockState.NONE;
                cachedTriples.addAll(this.createMethodGuardChecks(frameState, group, remainingGuards, mode));
                outerIfCount = outerIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false));
                prev = this.visitSpecializationGroupChildren(builder, frameState, prev, group, forType, allowedSpecializations);
                builder.end(outerIfCount.blockCount);
                hasFallthrough |= outerIfCount.ifCount > 0;
            } else {
                hasFallthrough |= this.buildSpecializationSlowPath(builder, frameState, group, mode, cachedTriples, remainingGuards);
            }
        } else if (mode.isGuardFallback()) {
            ifCount = BlockState.NONE;
            if (specialization != null && specialization.hasMultipleInstances()) {
                throw new AssertionError((Object)"unsupported path. should be caught by the parser.");
            }
            innerIfCount = BlockState.NONE;
            if (useSpecializationClass) {
                block2: for (GuardExpression guard : specialization.getGuards()) {
                    for (CacheExpression cache : specialization.getBoundCaches(guard.getExpression(), true)) {
                        if (!FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache)) continue;
                        cachedTriples.add(new IfTriple(this.loadSpecializationClass(frameState, specialization, false), null, null));
                        break block2;
                    }
                }
            }
            cachedTriples.addAll(this.createMethodGuardChecks(frameState, group, remainingGuards, mode));
            cachedTriples.addAll(this.createAssumptionCheck(frameState, specialization, NodeExecutionMode.FALLBACK_GUARD, true));
            cachedTriples = IfTriple.optimize(cachedTriples);
            if (specialization != null && !hasImplicitCast) {
                IfTriple singleCondition = null;
                if (cachedTriples.size() == 1) {
                    singleCondition = cachedTriples.get(0);
                }
                if (singleCondition != null) {
                    int index = cachedTriples.indexOf(singleCondition);
                    CodeTreeBuilder b = new CodeTreeBuilder(parent);
                    b.string("!(");
                    b.tree(this.createSpecializationActiveCheck(frameState, Arrays.asList(specialization)));
                    b.string(")");
                    cachedTriples.set(index, new IfTriple(singleCondition.prepare, FlatNodeGenFactory.combineTrees(" && ", b.build(), singleCondition.condition), singleCondition.statements));
                    this.fallbackNeedsState = true;
                }
            }
            innerIfCount = innerIfCount.add(IfTriple.materialize(builder, cachedTriples, false));
            prev = this.visitSpecializationGroupChildren(builder, frameState, prev, group, forType, allowedSpecializations);
            if (specialization != null && (prev == null || prev.hasFallthrough())) {
                builder.returnFalse();
            }
            builder.end(innerIfCount.blockCount);
            builder.end(ifCount.blockCount);
            hasFallthrough |= ifCount.ifCount > 0 || innerIfCount.ifCount > 0;
        } else if (mode.isUncached()) {
            ifCount = BlockState.NONE;
            cachedTriples.addAll(this.createAssumptionCheck(frameState, specialization, NodeExecutionMode.UNCACHED, true));
            ifCount = ifCount.add(IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false));
            cachedTriples = this.createMethodGuardChecks(frameState, group, remainingGuards, mode);
            innerIfCount = IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false);
            prev = this.visitSpecializationGroupChildren(builder, frameState, prev, group, forType, allowedSpecializations);
            if (specialization != null && (prev == null || prev.hasFallthrough())) {
                builder.tree(this.createCallSpecialization(builder, frameState, forType, specialization));
            }
            builder.end(innerIfCount.blockCount);
            builder.end(ifCount.blockCount);
            hasFallthrough |= ifCount.ifCount > 0 || innerIfCount.ifCount > 0;
        } else {
            throw new AssertionError((Object)"unexpected path");
        }
        group.setFallthrough(hasFallthrough);
        return builder.build();
    }

    private boolean buildSpecializationFastPath(CodeTreeBuilder builder, FrameState frameState, SpecializationGroup prev, SpecializationGroup group, ExecutableTypeData forType, List<GuardExpression> guardExpressions) {
        CodeTreeBuilder innerBuilder;
        boolean hasFallthrough = false;
        SpecializationData specialization = group.getSpecialization();
        BlockState ifCount = BlockState.NONE;
        if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
            builder.tree(this.loadSpecializationClass(frameState, specialization, false));
            if (specialization.hasMultipleInstances()) {
                builder.startWhile();
            } else {
                builder.startIf();
            }
            builder.tree(this.createGetSpecializationClass(frameState, specialization, true)).string(" != null");
            builder.end();
            builder.startBlock();
            ifCount = ifCount.incrementIf();
        }
        if (!specialization.getAssumptionExpressions().isEmpty()) {
            BlockState blockState = IfTriple.materialize(builder, this.createAssumptionCheck(frameState, specialization, NodeExecutionMode.FAST_PATH, false), false);
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            builder.tree(this.createRemoveThis(builder, frameState, forType, specialization));
            builder.end(blockState.blockCount);
        }
        boolean libraryInGuard = specialization.isAnyLibraryBoundInGuard();
        boolean pushEncapsulatingNode = specialization.needsPushEncapsulatingNode();
        boolean extractInBoundary = specialization.needsTruffleBoundary();
        if (extractInBoundary && specialization.needsVirtualFrame()) {
            extractInBoundary = false;
        }
        ArrayList<IfTriple> nonBoundaryGuards = new ArrayList<IfTriple>();
        ArrayList<GuardExpression> nonBoundaryGuardExpressions = new ArrayList<GuardExpression>();
        Iterator<GuardExpression> iterator = guardExpressions.iterator();
        block0: while (iterator.hasNext()) {
            GuardExpression guard = iterator.next();
            Set<CacheExpression> caches = group.getSpecialization().getBoundCaches(guard.getExpression(), true);
            for (CacheExpression cacheExpression : caches) {
                if (!cacheExpression.isAlwaysInitialized() || !cacheExpression.isRequiresBoundary()) continue;
                break block0;
            }
            nonBoundaryGuardExpressions.add(guard);
            iterator.remove();
        }
        nonBoundaryGuards.addAll(this.createFastPathNeverDefaultGuards(frameState, group.getSpecialization()));
        nonBoundaryGuards.addAll(this.createMethodGuardChecks(frameState, group, nonBoundaryGuardExpressions, NodeExecutionMode.FAST_PATH));
        if (pushEncapsulatingNode && libraryInGuard) {
            GeneratorUtils.pushEncapsulatingNode(builder, FlatNodeGenFactory.createNodeAccess(frameState));
            builder.startTryBlock();
        }
        nonBoundaryGuards.addAll(this.createMethodGuardChecks(frameState, group, guardExpressions, NodeExecutionMode.FAST_PATH));
        FrameState innerFrameState = frameState;
        BlockState nonBoundaryIfCount = BlockState.NONE;
        ArrayList<IfTriple> cachedTriples = new ArrayList<IfTriple>();
        if (extractInBoundary) {
            innerFrameState = frameState.copy();
            for (CacheExpression cache : specialization.getCaches()) {
                if (!cache.isAlwaysInitialized()) continue;
                this.setCacheInitialized(innerFrameState, specialization, cache, false);
            }
            nonBoundaryIfCount = nonBoundaryIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(nonBoundaryGuards), false));
            innerBuilder = this.extractInBoundaryMethod(builder, frameState, specialization);
            for (NodeExecutionData execution : specialization.getNode().getChildExecutions()) {
                int index = forType.getVarArgsIndex(forType.getParameterIndex(execution.getIndex()));
                if (index == -1) continue;
                LocalVariable var = innerFrameState.getValue(execution);
                innerFrameState.set(execution, var.accessWith(CodeTreeBuilder.singleString(var.getName())));
            }
        } else if (pushEncapsulatingNode) {
            innerBuilder = builder;
            nonBoundaryIfCount = IfTriple.materialize(innerBuilder, IfTriple.optimize(nonBoundaryGuards), false);
        } else {
            innerBuilder = builder;
            cachedTriples.addAll(0, nonBoundaryGuards);
        }
        cachedTriples.addAll(this.initializeCaches(innerFrameState, frameState.getMode(), group, specialization.getCaches(), true, false));
        if (pushEncapsulatingNode && !libraryInGuard) {
            GeneratorUtils.pushEncapsulatingNode(innerBuilder, FlatNodeGenFactory.createNodeAccess(frameState));
            innerBuilder.startTryBlock();
        }
        BlockState blockState2 = BlockState.NONE;
        blockState2 = blockState2.add(IfTriple.materialize(innerBuilder, IfTriple.optimize(cachedTriples), false));
        if (prev == null || prev.hasFallthrough()) {
            innerBuilder.tree(this.createFastPathExecute(builder, forType, specialization, innerFrameState));
        }
        innerBuilder.end(blockState2.blockCount);
        if (pushEncapsulatingNode && !libraryInGuard) {
            innerBuilder.end().startFinallyBlock();
            GeneratorUtils.popEncapsulatingNode(innerBuilder);
            innerBuilder.end();
        }
        hasFallthrough |= blockState2.ifCount > 0;
        builder.end(nonBoundaryIfCount.blockCount);
        if (pushEncapsulatingNode && libraryInGuard) {
            builder.end().startFinallyBlock();
            GeneratorUtils.popEncapsulatingNode(builder);
            builder.end();
        }
        if (FlatNodeGenFactory.useSpecializationClass(specialization) && specialization.hasMultipleInstances()) {
            String name = FlatNodeGenFactory.createSpecializationLocalName(specialization);
            builder.startStatement().string(name, " = ", name, ".next_").end();
        }
        builder.end(ifCount.blockCount);
        return hasFallthrough |= ifCount.ifCount > 0;
    }

    private List<IfTriple> createSpecializationActive(FrameState frameState, SpecializationGroup group, Collection<SpecializationData> allowedSpecializations) {
        boolean stateGuaranteed;
        List<SpecializationData> specializations = group.collectSpecializations();
        boolean bl = stateGuaranteed = group.isLast() && allowedSpecializations != null && allowedSpecializations.size() == 1 && group.getAllSpecializations().size() == allowedSpecializations.size();
        if (this.needsRewrites()) {
            CodeTree stateCheck = this.createSpecializationActiveCheck(frameState, specializations);
            CodeTree assertCheck = null;
            CodeTree stateGuard = null;
            if (stateGuaranteed) {
                assertCheck = CodeTreeBuilder.createBuilder().startAssert().tree(stateCheck).end().build();
            } else {
                stateGuard = stateCheck;
            }
            return Arrays.asList(new IfTriple(null, stateGuard, assertCheck));
        }
        return Collections.emptyList();
    }

    private CodeTree createSpecializationActiveCheck(FrameState frameState, List<SpecializationData> specializations) {
        Set<SpecializationData> replacedBy;
        StateQuery query = StateQuery.create(BitStateList.SpecializationActive.class, specializations);
        CodeTree stateCheck = this.multiState.createContains(frameState, query);
        if (specializations.size() == 1 && !(replacedBy = specializations.get(0).getReplacedBy()).isEmpty()) {
            BitSet set = this.multiState.findSet(query);
            CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
            b.tree(stateCheck);
            LinkedHashSet<BitSet> checkBitSets = new LinkedHashSet<BitSet>();
            for (SpecializationData replaced : replacedBy) {
                StateQuery replacedQuery = StateQuery.create(BitStateList.SpecializationActive.class, replaced);
                BitSet bitSet = this.multiState.findSet(replacedQuery);
                if (bitSet.equals(set)) continue;
                checkBitSets.add(bitSet);
            }
            StateQuery replacedQuery = StateQuery.create(BitStateList.SpecializationActive.class, replacedBy);
            for (BitSet bitSet : checkBitSets) {
                b.string(" && ");
                b.tree(bitSet.createNotContains(frameState, replacedQuery));
            }
            stateCheck = b.build();
        }
        return stateCheck;
    }

    private boolean buildSpecializationSlowPath(CodeTreeBuilder builder, FrameState frameState, SpecializationGroup group, NodeExecutionMode mode, List<IfTriple> outerTriples, List<GuardExpression> guardExpressions) throws AssertionError {
        CodeTree excludeCheck;
        SpecializationData specialization = group.getSpecialization();
        Objects.requireNonNull(specialization);
        if (FlatNodeGenFactory.hasExcludeBit(specialization)) {
            excludeCheck = this.multiState.createNotContains(frameState, StateQuery.create(BitStateList.SpecializationExcluded.class, specialization));
            outerTriples.add(0, new IfTriple(null, excludeCheck, null));
        }
        if (FlatNodeGenFactory.hasExcludes(specialization)) {
            excludeCheck = this.multiState.createNotContains(frameState, StateQuery.create(BitStateList.SpecializationActive.class, specialization.getReplacedBy()));
            outerTriples.add(0, new IfTriple(null, excludeCheck, null));
        }
        boolean hasFallthrough = false;
        BlockState outerIfCount = BlockState.NONE;
        for (CacheExpression cache : specialization.getCaches()) {
            if (!cache.isAlwaysInitialized()) continue;
            CodeTree prepare = CodeTreeBuilder.createBuilder().declarationDefault(cache.getParameter().getType(), this.createCacheLocalName(cache)).build();
            outerTriples.add(0, new IfTriple(prepare, null, null));
        }
        outerIfCount = outerIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(outerTriples), false));
        String countName = specialization != null ? "count" + specialization.getIndex() + NAME_SUFFIX : null;
        boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
        boolean multipleInstances = specialization.hasMultipleInstances();
        boolean needsDuplicationCheck = FlatNodeGenFactory.needsDuplicationCheck(specialization);
        boolean useDuplicateFlag = specialization.isGuardBindsCache() && !useSpecializationClass;
        String duplicateFoundName = specialization.getId() + "_duplicateFound_";
        boolean pushBoundary = specialization.needsPushEncapsulatingNode();
        if (pushBoundary) {
            builder.startBlock();
            GeneratorUtils.pushEncapsulatingNode(builder, FlatNodeGenFactory.createNodeAccess(frameState));
            builder.startTryBlock();
        }
        BlockState innerIfCount = BlockState.NONE;
        String specializationLocalName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
        if (needsDuplicationCheck) {
            builder.startWhile().string("true").end();
            builder.startBlock();
            builder.tree(this.createDuplicationCheck(builder, frameState, group, guardExpressions, useDuplicateFlag, countName, duplicateFoundName, specializationLocalName));
            builder.startIf();
            if (useDuplicateFlag) {
                builder.string("!", duplicateFoundName);
            } else {
                builder.string(FlatNodeGenFactory.createSpecializationLocalName(specialization), " == null");
                if (!multipleInstances) {
                    builder.string(" && ", countName, " < 1");
                }
            }
            builder.end().startBlock();
            innerIfCount = innerIfCount.incrementIf();
        }
        FrameState innerFrameState = frameState.copy();
        ArrayList<IfTriple> innerTripples = new ArrayList<IfTriple>();
        innerTripples.addAll(this.createMethodGuardChecks(innerFrameState, group, guardExpressions, mode));
        List<AssumptionExpression> assumptions = specialization.getAssumptionExpressions();
        if (!assumptions.isEmpty()) {
            for (AssumptionExpression assumption : assumptions) {
                innerTripples.addAll(this.createAssumptionSlowPathTriples(innerFrameState, group, assumption));
            }
        }
        CodeTree specializeElseBranch = null;
        if (needsDuplicationCheck && useSpecializationClass) {
            if (multipleInstances) {
                DSLExpression limit = this.optimizeExpression(specialization.getLimitExpression());
                Set<CacheExpression> caches = specialization.getBoundCaches(limit, true);
                innerTripples.addAll(this.initializeCaches(innerFrameState, innerFrameState.getMode(), group, caches, true, false));
                CodeTree limitExpression = this.writeExpression(innerFrameState, specialization, limit);
                CodeTreeBuilder limitBuilder = CodeTreeBuilder.createBuilder();
                limitBuilder.string(countName).string(" < ").tree(limitExpression);
                if (specialization.hasUnroll() && !specialization.isUnrolled()) {
                    limitBuilder.string(" - ").string(String.valueOf(specialization.getUnroll()));
                }
                innerTripples.add(new IfTriple(null, limitBuilder.build(), null));
            }
        } else if (needsDuplicationCheck) {
            innerTripples.add(new IfTriple(null, this.multiState.createNotContains(innerFrameState, StateQuery.create(BitStateList.SpecializationActive.class, specialization)), null));
        }
        if (innerFrameState.isSpecializationClassInitialized(specialization)) {
            specializeElseBranch = builder.create().startStatement().string(FlatNodeGenFactory.createSpecializationLocalName(specialization)).string(" = null").end().build();
        }
        int innerIfCountDiff = innerIfCount.ifCount;
        innerIfCount = innerIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(innerTripples), false));
        innerIfCountDiff = innerIfCount.ifCount - innerIfCountDiff;
        MultiBitSet.StateTransaction stateTransaction = new MultiBitSet.StateTransaction();
        builder.tree(this.createSpecialize(builder, innerFrameState, stateTransaction, group, specialization, false));
        CodeTree updateImplicitCast = this.createUpdateImplicitCastState(builder, innerFrameState, stateTransaction, specialization);
        if (updateImplicitCast != null) {
            builder.tree(updateImplicitCast);
        }
        for (CacheExpression cache : specialization.getCaches()) {
            BitSet bitSet;
            if (!cache.isEncodedEnum() || cache.getSharedGroup() != null || (bitSet = this.multiState.findSet(BitStateList.EncodedEnumState.class, cache)) == null) continue;
            builder.tree(bitSet.createLoad(innerFrameState));
            stateTransaction.markModified(bitSet);
        }
        builder.tree(this.multiState.createSet(innerFrameState, stateTransaction, StateQuery.create(BitStateList.SpecializationActive.class, specialization), true, false));
        builder.tree(this.multiState.persistTransaction(innerFrameState, stateTransaction));
        if (this.types.SlowPathListener != null && ElementUtils.isAssignable(specialization.getNode().getTemplateType().asType(), this.types.SlowPathListener)) {
            builder.startStatement().startCall("afterSpecialize").end().end();
        }
        if (needsDuplicationCheck) {
            hasFallthrough = true;
            if (useDuplicateFlag) {
                builder.startStatement().string(duplicateFoundName, " = true").end();
            }
            FlatNodeGenFactory.endAndElse(builder, innerIfCountDiff, specializeElseBranch);
            builder.end(innerIfCount.blockCount - innerIfCountDiff);
            for (CacheExpression cache : specialization.getCaches()) {
                if (!cache.isAlwaysInitialized()) continue;
                this.setCacheInitialized(frameState, specialization, cache, true);
            }
            if (updateImplicitCast != null) {
                builder.startElseBlock();
                stateTransaction = new MultiBitSet.StateTransaction();
                builder.tree(this.createUpdateImplicitCastState(builder, frameState, stateTransaction, specialization));
                builder.tree(this.multiState.createSet(frameState, stateTransaction, StateQuery.create(BitStateList.SpecializationActive.class, specialization), true, false));
                builder.tree(this.multiState.persistTransaction(innerFrameState, stateTransaction));
                builder.end();
            }
            builder.startIf();
            if (useDuplicateFlag) {
                builder.string(duplicateFoundName);
            } else {
                builder.string(FlatNodeGenFactory.createSpecializationLocalName(specialization), " != null");
            }
            builder.end().startBlock();
            builder.tree(this.createCallSpecialization(builder, frameState, this.executeAndSpecializeType, specialization));
            builder.end();
            builder.statement("break");
            builder.end();
        } else {
            builder.tree(this.createCallSpecialization(builder, innerFrameState, this.executeAndSpecializeType, specialization));
            builder.end(innerIfCount.blockCount);
            hasFallthrough |= innerIfCount.ifCount > 0;
        }
        if (pushBoundary) {
            builder.end().startFinallyBlock();
            GeneratorUtils.popEncapsulatingNode(builder);
            builder.end();
            builder.end();
        }
        builder.end(outerIfCount.blockCount);
        return hasFallthrough |= outerIfCount.ifCount > 0;
    }

    static void endAndElse(CodeTreeBuilder b, int endCount, CodeTree elseBranch) {
        for (int i = 0; i < endCount; ++i) {
            b.end();
            if (elseBranch == null) continue;
            b.startElseBlock();
            b.tree(elseBranch);
            b.end();
        }
    }

    private static boolean specializationNeedsInitializedBit(SpecializationData specialization) {
        if (FlatNodeGenFactory.useSpecializationClass(specialization) && specialization.isReachesFallback() && !specialization.getCaches().isEmpty()) {
            for (GuardExpression guard : specialization.getGuards()) {
                if (!FlatNodeGenFactory.guardNeedsStateBit(specialization, guard)) continue;
                return true;
            }
        }
        return false;
    }

    private List<IfTriple> createFastPathNeverDefaultGuards(FrameState frameState, SpecializationData specialization) {
        List<CacheExpression> caches = specialization.getCaches();
        if (specialization == null || caches.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        if (FlatNodeGenFactory.specializationNeedsInitializedBit(specialization)) {
            StateQuery query = StateQuery.create(BitStateList.SpecializationCachesInitialized.class, specialization);
            SpecializationStateReference ref = this.createStateReference(frameState, specialization, query);
            triples.add(new IfTriple(null, ref.bitSet.createContains(ref.reference, query), null));
        }
        for (CacheExpression cache : caches) {
            boolean needsNeverDefaultCheck;
            if (cache.isBind() || cache.isAlwaysInitialized() || cache.getInlinedNode() != null || cache.isEagerInitialize()) continue;
            boolean bl = needsNeverDefaultCheck = cache.getSharedGroup() != null || !FlatNodeGenFactory.useSpecializationClass(specialization);
            if (!needsNeverDefaultCheck && !FlatNodeGenFactory.isCacheNullDueToFallback(specialization, cache)) continue;
            triples.add(this.createNeverDefaultGuard(frameState, specialization, cache, " != "));
        }
        return triples;
    }

    private static boolean isCacheNullDueToFallback(SpecializationData specialization, CacheExpression cache) {
        if (!specialization.isReachesFallback()) {
            return false;
        }
        for (GuardExpression guard : specialization.getGuards()) {
            if (!FlatNodeGenFactory.getNullCachesDueToFallback(specialization, guard).contains(cache)) continue;
            return true;
        }
        return false;
    }

    private static Collection<CacheExpression> getNullCachesDueToFallback(SpecializationData specialization, GuardExpression guard) {
        if (!specialization.isReachesFallback()) {
            return Collections.emptyList();
        }
        Set<CacheExpression> boundCaches = specialization.getBoundCaches(guard.getExpression(), false);
        if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
            LinkedHashSet<CacheExpression> filteredCaches = new LinkedHashSet<CacheExpression>();
            for (CacheExpression cache : boundCaches) {
                if (cache.getSharedGroup() == null) continue;
                filteredCaches.add(cache);
            }
            return filteredCaches;
        }
        return boundCaches;
    }

    private IfTriple createNeverDefaultGuard(FrameState frameState, SpecializationData specialization, CacheExpression cache, String operator) {
        CodeTreeBuilder prepare = CodeTreeBuilder.createBuilder();
        CodeTreeBuilder condition = CodeTreeBuilder.createBuilder();
        if (cache.isEncodedEnum()) {
            CacheExpression sharedCache = this.lookupSharedCacheKey(cache);
            condition.startGroup();
            StateQuery query = StateQuery.create(BitStateList.EncodedEnumState.class, sharedCache);
            SpecializationStateReference ref = this.createStateReference(frameState, specialization, query);
            condition.tree(ref.bitSet.createExtractInteger(ref.reference, query));
            condition.string(" ", operator, " 0");
            condition.end();
        } else {
            LocalVariable wrapper = this.createCacheClassAccess(frameState, prepare, cache);
            String localName = this.createCacheLocalName(cache);
            CodeTree tree = this.createCacheAccess(frameState, specialization, cache, null);
            if (wrapper == null) {
                prepare.declaration(cache.getParameter().getType(), localName, tree);
                condition.string(localName).string(operator).defaultValue(cache.getParameter().getType());
                this.setCacheInitialized(frameState, specialization, cache, true);
            } else {
                condition.tree(wrapper.createReference()).string(operator, "null");
            }
        }
        return new IfTriple(prepare.build(), condition.build(), null);
    }

    private SpecializationGroup visitSpecializationGroupChildren(CodeTreeBuilder builder, FrameState frameState, SpecializationGroup prev, SpecializationGroup group, ExecutableTypeData forType, Collection<SpecializationData> allowedSpecializations) {
        SpecializationGroup currentPrev = prev;
        for (SpecializationGroup child : group.getChildren()) {
            if (currentPrev != null && !currentPrev.hasFallthrough()) break;
            builder.tree(this.visitSpecializationGroup(builder, prev, child, forType, frameState.copy(), allowedSpecializations));
            currentPrev = child;
        }
        return currentPrev;
    }

    private CodeTreeBuilder extractInBoundaryMethod(CodeTreeBuilder builder, FrameState frameState, SpecializationData specialization) {
        CodeExecutableElement parentMethod = (CodeExecutableElement)builder.findMethod();
        Object boundaryMethodName = this.generatorMode.equals((Object)GeneratorMode.EXPORTED_MESSAGE) ? String.format("%s_%sBoundary", this.node.getNodeId(), specialization.getId()) : String.format("%sBoundary", specialization.getId());
        if (this.usedBoundaryNames.contains(boundaryMethodName = ElementUtils.firstLetterLowerCase((String)boundaryMethodName))) {
            boundaryMethodName = (String)boundaryMethodName + this.boundaryIndex++;
        }
        this.usedBoundaryNames.add((String)boundaryMethodName);
        String includeFrameParameter = null;
        if (specialization.getFrame() != null) {
            if (ElementUtils.typeEquals(this.types.MaterializedFrame, specialization.getFrame().getType())) {
                includeFrameParameter = FRAME_VALUE;
            } else {
                includeFrameParameter = "frameValueMaterialized";
                CodeTreeBuilder read = builder.create().startCall(FRAME_VALUE, "materialize").end();
                LocalVariable materializedFrame = new LocalVariable(this.types.MaterializedFrame, FRAME_VALUE, read.build());
                frameState.set(includeFrameParameter, materializedFrame);
            }
        }
        CodeExecutableElement boundaryMethod = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), parentMethod.getReturnType(), (String)boundaryMethodName, new CodeVariableElement[0]);
        GeneratorUtils.mergeSuppressWarnings(boundaryMethod, "static-method");
        this.multiState.addParametersTo(frameState, boundaryMethod);
        frameState.addParametersTo(boundaryMethod, Integer.MAX_VALUE, includeFrameParameter, FlatNodeGenFactory.createSpecializationLocalName(specialization));
        boundaryMethod.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
        boundaryMethod.getThrownTypes().addAll(parentMethod.getThrownTypes());
        CodeTreeBuilder innerBuilder = boundaryMethod.createBuilder();
        ((CodeTypeElement)parentMethod.getEnclosingElement()).add(boundaryMethod);
        builder.startReturn().startCall("this", boundaryMethod);
        this.multiState.addReferencesTo(frameState, builder);
        frameState.addReferencesTo(builder, includeFrameParameter, FlatNodeGenFactory.createSpecializationLocalName(specialization));
        for (CacheExpression cache : specialization.getCaches()) {
            if (cache.isAlwaysInitialized()) continue;
            LocalVariable var = frameState.getCacheInitialized(specialization, cache);
            if (var != null) {
                CodeVariableElement v = var.createParameter();
                v.setName(this.createCacheLocalName(cache));
                boundaryMethod.addParameter(v);
                builder.tree(var.createReference());
                continue;
            }
            var = frameState.getCacheClassInitialized(cache);
            if (var == null) continue;
            boundaryMethod.addParameter(var.createParameter());
            builder.tree(var.createReference());
        }
        builder.end().end();
        return innerBuilder;
    }

    private List<IfTriple> createAssumptionCheck(FrameState frameState, SpecializationData specialization, NodeExecutionMode mode, boolean testValid) {
        if (specialization == null || specialization.getAssumptionExpressions().isEmpty()) {
            return Collections.emptyList();
        }
        boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (AssumptionExpression assumption : specialization.getAssumptionExpressions()) {
            CodeTree nullCheckReference;
            CodeTree assumptionReference;
            boolean needsCaching = assumption.needsCaching();
            if (mode.isUncached() || !needsCaching) {
                DSLExpression.Variable v;
                assumptionReference = this.writeExpression(frameState, specialization, assumption.getExpression());
                DSLExpression e = assumption.getExpression();
                while (e instanceof DSLExpression.Variable && (v = (DSLExpression.Variable)e).getReceiver() != null) {
                    e = v.getReceiver();
                }
                nullCheckReference = this.writeExpression(frameState, specialization, e);
                if (!FlatNodeGenFactory.useSpecializationClass(specialization)) {
                    assumptionReference = FlatNodeGenFactory.createInlinedAccess(frameState, specialization, assumptionReference, null);
                    nullCheckReference = FlatNodeGenFactory.createInlinedAccess(frameState, specialization, nullCheckReference, null);
                }
            } else {
                nullCheckReference = assumptionReference = this.createAssumptionReference(frameState, specialization, assumption);
            }
            if (testValid) {
                if (!builder.isEmpty()) {
                    builder.string(" && ");
                }
                if (mode.isGuardFallback()) {
                    builder.string("(");
                    if (useSpecializationClass) {
                        builder.tree(this.createGetSpecializationClass(frameState, specialization, true));
                        builder.string(" == null || ");
                    }
                    builder.tree(nullCheckReference);
                    builder.string(" == null || ");
                    builder.tree(this.createAssumptionGuard(assumptionReference));
                    builder.string(")");
                    continue;
                }
                builder.tree(this.createAssumptionGuard(assumptionReference));
                continue;
            }
            if (!builder.isEmpty()) {
                builder.string(" || ");
            }
            builder.string("!");
            builder.tree(this.createAssumptionGuard(assumptionReference));
        }
        triples.add(new IfTriple(null, builder.build(), null));
        return triples;
    }

    private CodeTree writeExpression(final FrameState frameState, SpecializationData specialization, DSLExpression expression) throws AssertionError {
        expression.accept(new DSLExpression.AbstractDSLExpressionVisitor(){

            @Override
            public void visitCall(DSLExpression.Call binary) {
                frameState.addThrownExceptions(binary.getResolvedMethod());
                if (ElementUtils.isDeprecated(binary.getResolvedMethod())) {
                    GeneratorUtils.mergeSuppressWarnings(frameState.method, "deprecation");
                }
            }
        });
        return DSLExpressionGenerator.write(this.optimizeExpression(expression), null, FlatNodeGenFactory.castBoundTypes(this.bindExpressionValues(frameState, expression, specialization)));
    }

    private List<IfTriple> createAssumptionSlowPathTriples(FrameState frameState, SpecializationGroup group, AssumptionExpression assumption) throws AssertionError {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        LocalVariable var = frameState.get(assumption.getId());
        CodeTree declaration = null;
        if (var == null) {
            triples.addAll(this.initializeCaches(frameState, frameState.getMode(), group, group.getSpecialization().getBoundCaches(assumption.getExpression(), true), true, false));
            CodeTree assumptionExpressions = this.writeExpression(frameState, group.getSpecialization(), assumption.getExpression());
            String name = FlatNodeGenFactory.createAssumptionFieldName(group.getSpecialization(), assumption);
            var = new LocalVariable(assumption.getExpression().getResolvedType(), name.substring(0, name.length() - 1), null);
            frameState.set(assumption.getId(), var);
            declaration = var.createDeclaration(assumptionExpressions);
        }
        triples.add(new IfTriple(declaration, this.createAssumptionGuard(var.createReference()), null));
        return triples;
    }

    private CodeTree createDuplicationCheck(CodeTreeBuilder parent, FrameState frameState, SpecializationGroup group, List<GuardExpression> guardExpressions, boolean useDuplicate, String countName, String duplicateFoundName, String specializationLocalName) {
        SpecializationData specialization = group.getSpecialization();
        CodeTreeBuilder builder = parent.create();
        boolean multipleInstances = specialization.hasMultipleInstances();
        boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
        if (useSpecializationClass) {
            builder.declaration("int", countName, CodeTreeBuilder.singleString("0"));
        }
        if (useSpecializationClass) {
            builder.tree(this.loadSpecializationClass(frameState, specialization, true));
            builder.declaration(this.createSpecializationClassReferenceType(specialization), FlatNodeGenFactory.createSpecializationLocalOriginalName(specialization), this.createGetSpecializationClass(frameState, specialization, true));
        }
        if (useDuplicate) {
            builder.declaration("boolean", duplicateFoundName, CodeTreeBuilder.singleString("false"));
        }
        for (CacheExpression cache : specialization.getCaches()) {
            this.createCacheClassAccess(frameState, builder, cache);
        }
        FrameState innerFrameState = frameState.copy();
        ArrayList<IfTriple> duplicationTriples = new ArrayList<IfTriple>();
        if (useSpecializationClass) {
            builder.startWhile().string(specializationLocalName, " != null").end().startBlock();
        } else {
            duplicationTriples.add(new IfTriple(null, this.createSpecializationActiveCheck(innerFrameState, Arrays.asList(specialization)), null));
        }
        duplicationTriples.addAll(this.createFastPathNeverDefaultGuards(innerFrameState, group.getSpecialization()));
        duplicationTriples.addAll(this.createMethodGuardChecks(innerFrameState, group, guardExpressions, NodeExecutionMode.FAST_PATH));
        duplicationTriples.addAll(this.createAssumptionCheck(innerFrameState, specialization, NodeExecutionMode.SLOW_PATH, true));
        BlockState duplicationIfCount = IfTriple.materialize(builder, IfTriple.optimize(duplicationTriples), false);
        if (useDuplicate) {
            builder.startStatement().string(duplicateFoundName, " = true").end();
        }
        ArrayList<CacheExpression> cachesToInitialize = new ArrayList<CacheExpression>();
        for (CacheExpression cache : specialization.getCaches()) {
            if (!cache.isAlwaysInitialized() || FlatNodeGenFactory.isCacheInitialized(innerFrameState, specialization, cache)) continue;
            cachesToInitialize.add(cache);
        }
        if (!cachesToInitialize.isEmpty()) {
            List<IfTriple> triples = this.initializeCaches(innerFrameState, NodeExecutionMode.FAST_PATH, group, cachesToInitialize, true, false);
            IfTriple.materialize(builder, IfTriple.optimize(triples), true);
        }
        if (useSpecializationClass) {
            builder.statement("break");
        }
        builder.end(duplicationIfCount.blockCount);
        if (useSpecializationClass) {
            if (multipleInstances) {
                builder.statement(countName + "++");
                builder.startStatement().string(specializationLocalName, " = ", specializationLocalName, ".next_").end();
            } else {
                if (FlatNodeGenFactory.specializationNeedsInitializedBit(specialization)) {
                    StateQuery initializedQuery = StateQuery.create(BitStateList.SpecializationCachesInitialized.class, specialization);
                    SpecializationStateReference ref = this.createStateReference(frameState, specialization, initializedQuery);
                    builder.startIf().tree(ref.bitSet.createContains(ref.reference, initializedQuery)).end().startBlock();
                    builder.statement(countName + "++");
                    builder.end();
                } else {
                    builder.statement(countName + "++");
                }
                builder.statement(specializationLocalName, " = null");
                builder.statement("break");
            }
            builder.end();
        }
        builder.end();
        return builder.build();
    }

    private CodeTree createSpecialize(CodeTreeBuilder parent, FrameState frameState, MultiBitSet.StateTransaction transaction, SpecializationGroup group, SpecializationData specialization, boolean aotSpecialize) {
        CodeTreeBuilder b;
        CodeTreeBuilder builder = parent.create();
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        triples.add(new IfTriple(this.initializeSpecializationClass(frameState, specialization, aotSpecialize), null, null));
        triples.addAll(this.initializeCaches(frameState, frameState.getMode(), group, specialization.getCaches(), false, true));
        triples.addAll(this.persistAssumptions(frameState, specialization));
        if (aotSpecialize) {
            for (CacheExpression cache : specialization.getCaches()) {
                if (cache.isAlwaysInitialized() || this.types.Profile == null || !ElementUtils.isAssignable(cache.getParameter().getType(), this.types.Profile) && !ElementUtils.isAssignable(cache.getParameter().getType(), this.types.InlinedProfile)) continue;
                b = builder.create();
                b.startStatement();
                b.tree(this.createCacheAccess(frameState, specialization, cache, null));
                b.startCall(".disable");
                if (cache.getInlinedNode() != null) {
                    b.tree(FlatNodeGenFactory.createNodeAccess(frameState, specialization));
                }
                b.end();
                b.end();
                triples.add(new IfTriple(null, null, b.build()));
            }
        }
        if (FlatNodeGenFactory.specializationNeedsInitializedBit(specialization)) {
            StateQuery query = StateQuery.create(BitStateList.SpecializationCachesInitialized.class, specialization);
            SpecializationStateReference stateRef = this.createStateReference(frameState, specialization, query);
            b = CodeTreeBuilder.createBuilder();
            b.startStatement();
            b.tree(stateRef.reference).string(" = ");
            b.tree(stateRef.bitSet.createSetExpression(stateRef.reference, query, true));
            b.end();
            triples.add(new IfTriple(null, null, b.build()));
        }
        triples.addAll(this.persistSpecializationClass(frameState, specialization, aotSpecialize));
        builder.end(IfTriple.materialize((CodeTreeBuilder)builder, triples, (boolean)true).blockCount);
        ArrayList<SpecializationData> excludesSpecializations = new ArrayList<SpecializationData>();
        for (SpecializationData otherSpeciailzation : this.node.getReachableSpecializations()) {
            if (otherSpeciailzation == specialization || !otherSpeciailzation.getReplacedBy().contains(specialization)) continue;
            excludesSpecializations.add(otherSpeciailzation);
        }
        if (!excludesSpecializations.isEmpty()) {
            HashSet<String> clearedGroups = new HashSet<String>();
            for (SpecializationData excludes : excludesSpecializations) {
                if (FlatNodeGenFactory.useSpecializationClass(excludes)) {
                    builder.startStatement();
                    builder.tree(this.createSpecializationFieldAccess(frameState, excludes, true, true, null, CodeTreeBuilder.singleString("null")));
                    builder.end();
                    continue;
                }
                for (CacheExpression cache : excludes.getCaches()) {
                    if (cache.isEncodedEnum() || cache.getInlinedNode() != null || cache.isAlwaysInitialized() || cache.isMergedLibrary() || ElementUtils.isPrimitive(cache.getParameter().getType())) continue;
                    String sharedGroup = cache.getSharedGroup();
                    if (sharedGroup != null) {
                        if (clearedGroups.contains(sharedGroup)) continue;
                        clearedGroups.add(sharedGroup);
                        if (!this.isSharedExclusivelyIn(sharedGroup, excludesSpecializations)) continue;
                    }
                    builder.startStatement();
                    builder.tree(this.createSpecializationFieldAccess(frameState, excludes, true, true, this.createFieldName(excludes, cache), CodeTreeBuilder.singleString("null")));
                    builder.end();
                }
            }
            builder.tree(this.multiState.createSet(frameState, transaction, StateQuery.create(BitStateList.SpecializationActive.class, excludesSpecializations), false, transaction == null));
        }
        return builder.build();
    }

    private boolean isSharedExclusivelyIn(String sharedKey, List<SpecializationData> specializations) {
        HashSet<SpecializationData> specializationSet = new HashSet<SpecializationData>(specializations);
        for (NodeData n : this.sharingNodes) {
            for (SpecializationData otherSpecialization : n.getReachableSpecializations()) {
                if (specializationSet.contains(otherSpecialization)) continue;
                for (CacheExpression cache : otherSpecialization.getCaches()) {
                    if (cache.getSharedGroup() == null || !cache.getSharedGroup().equals(sharedKey)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private List<IfTriple> persistAssumptions(FrameState frameState, SpecializationData specialization) {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (AssumptionExpression assumption : specialization.getAssumptionExpressions()) {
            if (!assumption.needsCaching()) continue;
            LocalVariable var = frameState.get(assumption.getId());
            String name = FlatNodeGenFactory.createAssumptionFieldName(specialization, assumption);
            CodeTreeBuilder builder = new CodeTreeBuilder(null);
            builder.startStatement();
            builder.tree(this.createSpecializationFieldAccess(frameState, specialization, true, true, name, var.createReference()));
            builder.end();
            triples.add(new IfTriple(builder.build(), null, null));
        }
        return triples;
    }

    private CodeTree loadSpecializationClass(FrameState frameState, SpecializationData specialization, boolean useUpdater) {
        if (!FlatNodeGenFactory.useSpecializationClass(specialization)) {
            throw new AssertionError((Object)"Not using specialization class.");
        }
        String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
        String typeName = this.createSpecializationTypeName(specialization);
        LocalVariable var = frameState.get(localName);
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        builder.startStatement();
        if (var == null) {
            builder.string(typeName);
            builder.string(" ");
        }
        builder.string(localName);
        builder.string(" = ");
        if (useUpdater) {
            if (frameState.isInlinedNode()) {
                builder.string("this.", this.createSpecializationFieldName(specialization)).startCall(".getVolatile");
                builder.tree(frameState.getValue(0).createReference());
                builder.end();
            } else {
                builder.string(this.createSpecializationClassUpdaterName(specialization)).string(".getVolatile(this)");
            }
        } else {
            builder.tree(this.createSpecializationFieldAccess(frameState, specialization, true, true, null, null));
        }
        builder.end();
        if (var == null) {
            frameState.set(localName, new LocalVariable(this.createSpecializationClassReferenceType(specialization), localName, null));
        }
        return builder.build();
    }

    private Collection<IfTriple> persistSpecializationClass(FrameState frameState, SpecializationData specialization, boolean aotSpecialize) {
        if (!FlatNodeGenFactory.useSpecializationClass(specialization)) {
            return Collections.emptyList();
        }
        String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
        LocalVariable var = frameState.get(localName);
        if (var == null) {
            return Collections.emptyList();
        }
        String persistFrameState = FlatNodeGenFactory.createSpecializationClassPersisted(specialization);
        if (frameState.getBoolean(persistFrameState, false)) {
            return Collections.emptyList();
        }
        frameState.setBoolean(persistFrameState, true);
        CodeTree ref = var.createReference();
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        if (!aotSpecialize && FlatNodeGenFactory.needsDuplicationCheck(specialization)) {
            builder.startIf();
            if (frameState.isInlinedNode()) {
                String fieldName = this.createSpecializationFieldName(specialization);
                builder.string("!this.", fieldName);
                builder.startCall(".compareAndSet");
                builder.tree(frameState.getValue(0).createReference());
                builder.string(FlatNodeGenFactory.createSpecializationLocalOriginalName(specialization));
                builder.tree(ref);
                builder.end();
            } else {
                builder.string("!").string(this.createSpecializationClassUpdaterName(specialization)).startCall(".compareAndSet");
                builder.string("this");
                builder.string(FlatNodeGenFactory.createSpecializationLocalOriginalName(specialization));
                builder.tree(ref);
                builder.end();
            }
            builder.end().startBlock();
            builder.statement("continue");
            builder.end();
        } else {
            builder.startStatement();
            builder.startStaticCall(this.context.getType(VarHandle.class), "storeStoreFence").end();
            builder.end();
            builder.startStatement();
            builder.tree(this.createSpecializationFieldAccess(frameState, specialization, true, true, null, ref));
            builder.end();
        }
        return Arrays.asList(new IfTriple(builder.build(), null, null));
    }

    private static String createSpecializationClassPersisted(SpecializationData specialization) {
        return FlatNodeGenFactory.createSpecializationLocalName(specialization) + "$persisted";
    }

    private CodeTree initializeSpecializationClass(FrameState frameState, SpecializationData specialization, boolean aotInitialize) {
        boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
        if (useSpecializationClass) {
            String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
            String typeName = this.createSpecializationTypeName(specialization);
            if (!frameState.isSpecializationClassInitialized(specialization)) {
                if (frameState.getMode().isFastPath()) {
                    throw new AssertionError((Object)"Must never initialize the specialization cache on the fast-path.");
                }
                TypeMirror type = this.createSpecializationClassReferenceType(specialization);
                CodeTreeBuilder initBuilder = new CodeTreeBuilder(null);
                boolean isNode = FlatNodeGenFactory.specializationClassIsNode(specialization);
                if (isNode) {
                    if (frameState.isInlinedNode()) {
                        initBuilder.startCall(frameState.getValue(0).createReference(), "insert");
                    } else {
                        initBuilder.startCall("this.insert");
                    }
                }
                initBuilder.startNew(typeName);
                if (specialization.hasMultipleInstances()) {
                    if (aotInitialize) {
                        initBuilder.tree(this.createSpecializationFieldAccess(frameState, specialization, true, false, null, null));
                    } else {
                        initBuilder.string(FlatNodeGenFactory.createSpecializationLocalOriginalName(specialization));
                    }
                }
                initBuilder.end();
                if (isNode) {
                    initBuilder.end();
                }
                CodeTree init = initBuilder.build();
                CodeTreeBuilder builder = new CodeTreeBuilder(null);
                builder.startStatement();
                if (frameState.get(localName) == null) {
                    builder.string(typeName);
                    builder.string(" ");
                }
                builder.string(localName);
                builder.string(" = ");
                builder.tree(init);
                builder.end();
                frameState.setSpecializationClassInitialized(specialization, true);
                frameState.set(localName, new LocalVariable(type, localName, CodeTreeBuilder.singleString(localName)));
                return builder.build();
            }
        }
        return null;
    }

    private CodeTree createUpdateImplicitCastState(CodeTreeBuilder parent, FrameState frameState, MultiBitSet.StateTransaction transaction, SpecializationData specialization) {
        CodeTreeBuilder builder = null;
        int signatureIndex = 0;
        for (Parameter p : specialization.getSignatureParameters()) {
            TypeMirror targetType = p.getType();
            TypeMirror polymorphicType = this.node.getPolymorphicExecutable().getParameterTypeOrDie(p.getSpecification().getExecution());
            if (this.typeSystem.hasImplicitSourceTypes(targetType) && ElementUtils.needsCastTo(polymorphicType, targetType)) {
                String implicitFieldName = FlatNodeGenFactory.createImplicitTypeStateLocalName(p);
                if (builder == null) {
                    builder = parent.create();
                }
                StateQuery implicitCastState = StateQuery.create(BitStateList.ImplicitCastState.class, new SpecializationGroup.TypeGuard(this.typeSystem, p.getType(), signatureIndex));
                builder.startStatement();
                builder.tree(this.multiState.createSetInteger(frameState, transaction, implicitCastState, CodeTreeBuilder.singleString(implicitFieldName)));
                builder.end();
            }
            ++signatureIndex;
        }
        return builder == null ? null : builder.build();
    }

    private CodeTree createAssumptionGuard(CodeTree assumptionValue) {
        return CodeTreeBuilder.createBuilder().startStaticCall(this.types.Assumption, "isValidAssumption").tree(assumptionValue).end().build();
    }

    private static CodeTree combineTrees(String sep, CodeTree ... trees) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String s = "";
        for (CodeTree tree : trees) {
            if (tree == null || tree.isEmpty()) continue;
            if (sep != null) {
                builder.string(s);
            }
            builder.tree(tree);
            s = sep;
        }
        return builder.build();
    }

    private static CodeTree createTryExecuteChild(LocalVariable value, CodeTree executeChild, boolean needDeclaration, boolean hasTry) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        boolean hasDeclaration = false;
        if ((hasTry || !executeChild.isSingleLine()) && needDeclaration) {
            builder.tree(value.createDeclaration(null));
            hasDeclaration = true;
        }
        if (hasTry) {
            builder.startTryBlock();
        } else {
            builder.startGroup();
        }
        if (executeChild.isSingleLine()) {
            builder.startStatement();
            if (hasDeclaration || !needDeclaration) {
                builder.tree(executeChild);
            } else {
                builder.type(value.getTypeMirror()).string(" ").tree(executeChild);
            }
            builder.end();
        } else {
            builder.tree(executeChild);
        }
        builder.end();
        return builder.build();
    }

    private ExecutableTypeData resolveTargetExecutable(NodeExecutionData execution, TypeMirror target) {
        NodeChildData child = execution.getChild();
        if (child == null) {
            return null;
        }
        ExecutableTypeData targetExecutable = child.findExecutableType(target);
        if (targetExecutable == null) {
            targetExecutable = child.findAnyGenericExecutableType(this.context);
        }
        return targetExecutable;
    }

    private CodeTree createCatchRewriteException(CodeTreeBuilder parent, SpecializationData specialization, ExecutableTypeData forType, FrameState frameState, CodeTree execution) {
        if (specialization.getExceptions().isEmpty()) {
            return execution;
        }
        CodeTreeBuilder builder = parent.create();
        builder.startTryBlock();
        builder.tree(execution);
        TypeMirror[] exceptionTypes = new TypeMirror[specialization.getExceptions().size()];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            TypeMirror type;
            exceptionTypes[i] = type = specialization.getExceptions().get(i).getJavaClass();
        }
        builder.end().startCatchBlock(exceptionTypes, "ex");
        builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        builder.tree(this.createExcludeThis(builder, frameState, forType, specialization));
        builder.end();
        return builder.build();
    }

    private CodeTree createExcludeThis(CodeTreeBuilder parent, FrameState frameState, ExecutableTypeData forType, SpecializationData specialization) {
        boolean hasReexecutingRewrite;
        CodeTreeBuilder builder = parent.create();
        ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>();
        specializations.add(specialization);
        if (specialization.getUncachedSpecialization() != null) {
            specializations.add(specialization.getUncachedSpecialization());
        }
        FrameState innerFrameState = frameState.copy();
        StateQuery excludedQuery = StateQuery.create(BitStateList.SpecializationExcluded.class, specializations);
        StateQuery activeQuery = StateQuery.create(BitStateList.SpecializationActive.class, specializations);
        builder.tree(this.multiState.createForceLoad(innerFrameState, activeQuery, excludedQuery));
        MultiBitSet.StateTransaction transaction = new MultiBitSet.StateTransaction();
        builder.tree(this.multiState.createSet(innerFrameState, transaction, activeQuery, false, false));
        builder.tree(this.multiState.createSet(innerFrameState, transaction, excludedQuery, true, false));
        builder.tree(this.multiState.persistTransaction(innerFrameState, transaction));
        for (SpecializationData removeSpecialization : specializations) {
            if (!FlatNodeGenFactory.useSpecializationClass(removeSpecialization)) continue;
            builder.startStatement();
            builder.tree(this.createSpecializationFieldAccess(innerFrameState, specialization, true, false, null, CodeTreeBuilder.singleString("null")));
            builder.end();
        }
        boolean hasUnexpectedResultRewrite = specialization.hasUnexpectedResultRewrite();
        boolean bl = hasReexecutingRewrite = !hasUnexpectedResultRewrite || specialization.getExceptions().size() > 1;
        if (hasReexecutingRewrite) {
            if (hasUnexpectedResultRewrite) {
                builder.startIf().string("ex").instanceOf(this.types.UnexpectedResultException).end().startBlock();
                builder.tree(this.createReturnUnexpectedResult(forType, true));
                builder.end().startElseBlock();
                builder.tree(this.createCallExecuteAndSpecialize(forType, frameState));
                builder.end();
            } else {
                builder.tree(this.createCallExecuteAndSpecialize(forType, frameState));
            }
        } else {
            assert (hasUnexpectedResultRewrite);
            builder.tree(this.createReturnUnexpectedResult(forType, false));
        }
        builder.end();
        return builder.build();
    }

    private CodeTree createRemoveThis(CodeTreeBuilder parent, FrameState outerFrameState, ExecutableTypeData forType, SpecializationData specialization) {
        CodeTreeBuilder builder;
        CodeExecutableElement method = this.removeThisMethods.get(specialization);
        String specializationLocalName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
        FrameState frameState = outerFrameState.copy();
        this.multiState.clearLoaded(frameState);
        TypeMirror specializationType = this.createSpecializationClassReferenceType(specialization);
        boolean useSpecializationClass = FlatNodeGenFactory.useSpecializationClass(specialization);
        boolean inline = frameState.isInlinedNode();
        if (method == null) {
            method = new CodeExecutableElement(this.context.getType(Void.TYPE), "remove" + specialization.getId() + NAME_SUFFIX);
            if (inline) {
                method.addParameter(frameState.getValue(0).createParameter());
            }
            if (useSpecializationClass) {
                method.addParameter(new CodeVariableElement(specializationType, specializationLocalName));
            }
            builder = method.createBuilder();
            if (!useSpecializationClass || !specialization.hasMultipleInstances()) {
                builder.tree(this.multiState.createSet(frameState, null, StateQuery.create(BitStateList.SpecializationActive.class, specialization), false, true));
                if (useSpecializationClass) {
                    builder.startStatement();
                    builder.tree(this.createSpecializationFieldAccess(frameState, specialization, true, true, null, CodeTreeBuilder.singleString("null")));
                    builder.end();
                }
            } else {
                builder.startWhile().string("true").end().startBlock();
                String typeName = this.createSpecializationTypeName(specialization);
                boolean specializedIsNode = FlatNodeGenFactory.specializationClassIsNode(specialization);
                builder.declaration(typeName, "cur", this.createSpecializationFieldAccess(frameState, specialization, true, false, null, null));
                builder.declaration(typeName, "original", "cur");
                builder.declaration(typeName, "update", "null");
                builder.startWhile().string("cur != null").end().startBlock();
                builder.startIf().string("cur == ").string(specializationLocalName).end().startBlock();
                builder.startIf().string("cur == original").end().startBlock();
                builder.statement("update = cur.next_");
                builder.end().startElseBlock();
                builder.statement("update = original.remove(", specializationLocalName, ")");
                builder.end();
                builder.statement("break");
                builder.end();
                builder.statement("cur = cur.next_");
                builder.end();
                builder.startIf();
                builder.string("cur != null && ");
                if (frameState.isInlinedNode()) {
                    String fieldName = this.createSpecializationFieldName(specialization);
                    builder.string("!this.", fieldName);
                    builder.startCall(".compareAndSet");
                    builder.tree(frameState.getValue(0).createReference());
                } else {
                    builder.string("!").string(this.createSpecializationClassUpdaterName(specialization)).startCall(".compareAndSet");
                    builder.string("this");
                }
                builder.string("original");
                builder.string("update");
                builder.end();
                builder.end().startBlock();
                builder.statement("continue");
                builder.end();
                builder.statement("break");
                builder.end();
                builder.end();
                if (specializedIsNode) {
                    builder.statement("this.adoptChildren()");
                }
            }
            this.removeThisMethods.put(specialization, method);
        }
        builder = parent.create();
        builder.startStatement().startCall(method.getSimpleName().toString());
        if (inline) {
            builder.tree(frameState.getValue(0).createReference());
        }
        if (useSpecializationClass) {
            builder.string(specializationLocalName);
        }
        builder.end().end();
        builder.tree(this.createCallExecuteAndSpecialize(forType, frameState));
        return builder.build();
    }

    private CodeTree createCallExecute(ExecutableTypeData forType, ExecutableTypeData targetType, FrameState frameState) {
        TypeMirror returnType = targetType.getReturnType();
        ArrayList<CodeTree> bindings = new ArrayList<CodeTree>();
        List<TypeMirror> sourceTypes = forType.getSignatureParameters();
        List<TypeMirror> targetTypes = targetType.getSignatureParameters();
        if (sourceTypes.size() != targetTypes.size()) {
            throw new IllegalArgumentException();
        }
        if (targetType.getFrameParameter() != null) {
            LocalVariable parameterLocal = frameState.get(FRAME_VALUE);
            TypeMirror parameterTargetType = targetType.getFrameParameter();
            if (parameterLocal == null) {
                bindings.add(CodeTreeBuilder.createBuilder().defaultValue(parameterTargetType).build());
            } else {
                bindings.add(parameterLocal.createReference());
            }
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            LocalVariable parameterLocal = frameState.getValue(i);
            TypeMirror parameterTargetType = targetTypes.get(i);
            if (parameterLocal == null) {
                bindings.add(CodeTreeBuilder.createBuilder().defaultValue(parameterTargetType).build());
                continue;
            }
            bindings.add(parameterLocal.createReference());
        }
        CodeTree call = FlatNodeGenFactory.callMethod(frameState, null, targetType.getMethod(), bindings.toArray(new CodeTree[0]));
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder = builder.create();
        if (ElementUtils.isVoid(forType.getReturnType())) {
            builder.statement(call);
            builder.returnStatement();
        } else {
            builder.startReturn();
            builder.tree(this.expectOrCast(returnType, forType, call));
            builder.end();
        }
        return builder.build();
    }

    private CodeTree createCallExecuteAndSpecialize(ExecutableTypeData forType, FrameState frameState) {
        TypeMirror returnType = this.node.getPolymorphicExecutable().getReturnType();
        String frame = null;
        if (FlatNodeGenFactory.needsFrameToExecute(this.node.getReachableSpecializations())) {
            frame = FRAME_VALUE;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startCall(this.createExecuteAndSpecializeName());
        frameState.addReferencesTo(builder, frame);
        builder.end();
        CodeTree call = builder.build();
        builder = builder.create();
        if (ElementUtils.isVoid(forType.getReturnType())) {
            builder.statement(call);
            builder.returnStatement();
        } else {
            builder.startReturn();
            builder.tree(this.expectOrCast(returnType, forType, call));
            builder.end();
        }
        return builder.build();
    }

    private CodeTree createReturnUnexpectedResult(ExecutableTypeData forType, boolean needsCast) {
        TypeMirror returnType = this.context.getType(Object.class);
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startCall(needsCast ? "((UnexpectedResultException) ex)" : "ex", "getResult").end();
        CodeTree call = builder.build();
        builder = builder.create();
        if (ElementUtils.isVoid(forType.getReturnType())) {
            builder.statement(call);
            builder.returnStatement();
        } else {
            builder.startReturn();
            builder.tree(this.expectOrCast(returnType, forType, call));
            builder.end();
        }
        return builder.build();
    }

    private List<IfTriple> createMethodGuardChecks(FrameState frameState, SpecializationGroup group, Collection<GuardExpression> guardExpressions, NodeExecutionMode mode) {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        SpecializationData specialization = group.getSpecialization();
        for (GuardExpression guard : guardExpressions) {
            switch (mode) {
                case SLOW_PATH: {
                    triples.addAll(this.initializeCachesForSlowPathGuard(frameState, mode, group, guard));
                    break;
                }
                case FAST_PATH: {
                    triples.addAll(this.initializeCaches(frameState, mode, group, specialization.getBoundCaches(guard.getExpression(), true), true, false));
                    break;
                }
                case FALLBACK_GUARD: {
                    triples.addAll(this.initializeCasts(frameState, group, guard.getExpression(), mode));
                    break;
                }
                case UNCACHED: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unhandled mode");
                }
            }
            triples.add(this.createMethodGuardCheck(frameState, specialization, guard, mode));
        }
        return triples;
    }

    private List<IfTriple> initializeCachesForSlowPathGuard(FrameState frameState, NodeExecutionMode mode, SpecializationGroup group, GuardExpression guard) {
        SpecializationData specialization = group.getSpecialization();
        boolean guardStateBit = FlatNodeGenFactory.guardNeedsStateBit(specialization, guard);
        if (!guardStateBit && guard.isConstantTrueInSlowPath(mode.isUncached())) {
            return Collections.emptyList();
        }
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        StateQuery query = StateQuery.create(BitStateList.GuardActive.class, guard);
        SpecializationStateReference stateRef = null;
        if (guardStateBit) {
            if (specialization == null) {
                throw new AssertionError();
            }
            builder.tree(this.initializeSpecializationClass(frameState, group.getSpecialization(), false));
            stateRef = this.createStateReference(frameState, specialization, query);
        }
        Set<CacheExpression> boundCaches = group.getSpecialization().getBoundCaches(guard.getExpression(), true);
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        triples.addAll(this.initializeCaches(frameState, mode, group, boundCaches, true, false));
        triples.addAll(this.initializeCasts(frameState, group, guard.getExpression(), mode));
        IfTriple.materialize(builder, triples, true);
        FrameState innerFrameState = frameState;
        if (guardStateBit) {
            ArrayList<IfTriple> innerTriples = new ArrayList<IfTriple>();
            innerFrameState = frameState.copy();
            builder.startIf().tree(stateRef.bitSet.createNotContains(stateRef.reference, StateQuery.create(BitStateList.GuardActive.class, guard))).end().startBlock();
            triples = new ArrayList();
            triples.addAll(this.initializeCaches(innerFrameState, mode, group, boundCaches, false, true));
            triples.addAll(this.initializeCasts(innerFrameState, group, guard.getExpression(), mode));
            IfTriple.materialize(builder, triples, true);
            builder.startStatement();
            builder.tree(stateRef.reference).string(" = ");
            builder.tree(stateRef.bitSet.createSetExpression(stateRef.reference, query, true));
            builder.end();
            innerTriples.addAll(this.persistSpecializationClass(innerFrameState, group.getSpecialization(), false));
            if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
                CodeTreeBuilder b;
                if (FlatNodeGenFactory.needsDuplicationCheck(specialization)) {
                    b = builder.create();
                    b.startStatement();
                    b.string(FlatNodeGenFactory.createSpecializationLocalOriginalName(specialization));
                    b.string(" = ");
                    b.tree(this.createGetSpecializationClass(frameState, specialization, true));
                    b.end();
                    innerTriples.add(new IfTriple(null, null, b.build()));
                }
                b = builder.create();
                b.startStatement();
                String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                b.string(localName).string(" = ");
                boolean isNode = FlatNodeGenFactory.specializationClassIsNode(specialization);
                if (isNode) {
                    if (frameState.isInlinedNode()) {
                        b.startCall(frameState.getValue(0).createReference(), "insert");
                    } else {
                        b.startCall("this.insert");
                    }
                }
                if (!FlatNodeGenFactory.specializationClassNeedsCopyConstructor(specialization)) {
                    throw new AssertionError((Object)"Inconsistent copy constructor condition.");
                }
                b.startNew(this.createSpecializationClassReferenceType(specialization));
                b.string(localName);
                b.end();
                if (isNode) {
                    b.end();
                }
                b.end();
                innerTriples.add(new IfTriple(null, null, b.build()));
            }
            IfTriple.materialize(builder, innerTriples, true);
            builder.end();
        }
        return Arrays.asList(new IfTriple(builder.build(), null, null));
    }

    private static boolean specializationClassNeedsCopyConstructor(SpecializationData specialization) {
        if (!FlatNodeGenFactory.useSpecializationClass(specialization)) {
            return false;
        }
        if (!specialization.isReachesFallback()) {
            return false;
        }
        for (GuardExpression guard : specialization.getGuards()) {
            boolean guardStateBit = FlatNodeGenFactory.guardNeedsStateBit(specialization, guard);
            if (!guardStateBit) continue;
            return true;
        }
        return false;
    }

    private List<IfTriple> initializeCaches(FrameState frameState, NodeExecutionMode mode, SpecializationGroup group, Collection<CacheExpression> caches, boolean store, boolean forcePersist) {
        if (group.getSpecialization() == null || caches.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (CacheExpression cache : caches) {
            if (cache.isEagerInitialize()) {
                triples.addAll(this.createLoadCacheClass(frameState, cache));
                continue;
            }
            if (mode.isFastPath() && !cache.isAlwaysInitialized()) {
                triples.addAll(this.createLoadCacheClass(frameState, cache));
                continue;
            }
            if (mode.isUncached() && cache.isWeakReference()) continue;
            boolean useStore = store;
            if (cache.isAlwaysInitialized() || this.sharedCaches.containsKey(cache)) {
                useStore = true;
            }
            triples.addAll(this.initializeCasts(frameState, group, cache.getDefaultExpression(), mode));
            triples.addAll(this.persistAndInitializeCache(frameState, mode, group.getSpecialization(), cache, useStore, forcePersist));
        }
        return triples;
    }

    private List<IfTriple> createLoadCacheClass(FrameState frameState, CacheExpression cache) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        this.createCacheClassAccess(frameState, b, cache);
        if (!b.isEmpty()) {
            return Arrays.asList(new IfTriple(b.build(), null, null));
        }
        return Collections.emptyList();
    }

    private Collection<IfTriple> persistAndInitializeCache(FrameState frameState, NodeExecutionMode mode, SpecializationData specialization, CacheExpression cache, boolean store, boolean persist) {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        CodeTree init = this.initializeCache(frameState, specialization, cache);
        if (store) {
            triples.addAll(this.storeCache(frameState, mode, specialization, cache, init));
        }
        if (persist) {
            triples.addAll(this.persistCache(frameState, specialization, cache, init));
        }
        return triples;
    }

    private Collection<IfTriple> persistCache(FrameState frameState, SpecializationData specialization, CacheExpression cache, CodeTree cacheValue) {
        boolean defaultCheck;
        CodeTree value;
        if (cache.isAlwaysInitialized()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        String name = this.createFieldName(specialization, cache);
        LocalVariable local = frameState.get(name);
        if (local != null) {
            value = local.createReference();
        } else {
            if (cacheValue == null) {
                return Collections.emptyList();
            }
            value = cacheValue;
        }
        String frameStateInitialized = name + "$initialized";
        if (frameState.getBoolean(frameStateInitialized, false)) {
            return Collections.emptyList();
        }
        frameState.setBoolean(frameStateInitialized, true);
        CodeTree storeFence = null;
        if (!(ElementUtils.isPrimitive(cache.getParameter().getType()) || FlatNodeGenFactory.needsDuplicationCheck(specialization) || FlatNodeGenFactory.useSpecializationClass(specialization))) {
            CodeTreeBuilder storeFenceBuilder = CodeTreeBuilder.createBuilder();
            storeFenceBuilder.startStatement();
            storeFenceBuilder.startStaticCall(this.context.getType(VarHandle.class), "storeStoreFence").end();
            storeFenceBuilder.end();
            storeFence = storeFenceBuilder.build();
        }
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        value = this.createInsertNode(frameState, specialization, cache, value);
        boolean sharedCheck = this.sharedCaches.containsKey(cache);
        boolean bl = defaultCheck = !cache.isWeakReference() && cache.isNeverDefault() && !cache.isNeverDefaultGuaranteed();
        if (sharedCheck || defaultCheck) {
            String localName = this.createCacheLocalName(cache);
            String defaultValue = ElementUtils.defaultValue(cache.getParameter().getType());
            boolean cacheInitialized = FlatNodeGenFactory.isCacheInitialized(frameState, specialization, cache);
            if (sharedCheck) {
                LocalVariable cacheClass;
                if (!cacheInitialized) {
                    builder.declaration(cache.getParameter().getType(), localName, value);
                }
                if ((cacheClass = this.createCacheClassAccess(frameState, builder, cache)) != null) {
                    builder.startIf().tree(cacheClass.createReference()).string(" == null").end().startBlock();
                    builder.startStatement();
                    builder.string(cacheClass.getName(), " = ");
                    builder.tree(this.createInsertNode(frameState, specialization, cache, builder.create().startNew(FlatNodeGenFactory.createCacheClassType(cache)).end().build()));
                    builder.end();
                    builder.startStatement();
                    if (storeFence != null) {
                        builder.tree(storeFence);
                    }
                    builder.tree(this.createCacheAccess(frameState, specialization, cache, CodeTreeBuilder.singleString(localName)));
                    builder.end();
                    builder.startStatement();
                    builder.startStaticCall(this.context.getType(VarHandle.class), "storeStoreFence").end();
                    builder.end();
                    builder.startStatement();
                    builder.tree(FlatNodeGenFactory.createInlinedAccess(frameState, null, CodeTreeBuilder.singleString("this." + name), cacheClass.createReference()));
                    builder.end();
                    builder.end();
                } else {
                    if (!cache.isEagerInitialize()) {
                        if (cache.isEncodedEnum()) {
                            IfTriple triple = this.createNeverDefaultGuard(frameState, specialization, cache, " == ");
                            builder.startIf().tree(triple.condition).end().startBlock();
                        } else {
                            builder.startIf().tree(this.createCacheAccess(frameState, specialization, cache, null)).string(" == ").string(defaultValue).end().startBlock();
                        }
                    }
                    if (!cacheInitialized) {
                        this.checkSharedCacheNull(builder, localName, specialization, cache);
                    }
                    if (storeFence != null) {
                        builder.tree(storeFence);
                    }
                    builder.startStatement();
                    builder.tree(this.createCacheAccess(frameState, specialization, cache, CodeTreeBuilder.singleString(localName)));
                    builder.end();
                    if (!cache.isEagerInitialize()) {
                        builder.end();
                    }
                }
                builder.end();
                builder.end();
            } else if (defaultCheck) {
                if (cacheInitialized) {
                    GeneratorUtils.mergeSuppressWarnings(frameState.method, "unused");
                } else {
                    builder.declaration(cache.getParameter().getType(), localName, value);
                    value = CodeTreeBuilder.singleString(localName);
                }
                String message = String.format("Specialization '%s' cache '%s' returned a '%s' default value. The cache initializer must never return a default value for this cache. Use @%s(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns '%s'.", ElementUtils.getReadableSignature(specialization.getMethod()), cache.getParameter().getLocalName(), defaultValue, ElementUtils.getSimpleName(this.types.Cached), defaultValue);
                if (ElementUtils.isPrimitive(cache.getParameter().getType())) {
                    builder.startIf().tree(value).string(" == ").string(defaultValue).end().startBlock();
                    builder.startThrow().startNew(this.context.getType(NullPointerException.class)).doubleQuote(message).end().end();
                    builder.end();
                } else {
                    builder.startStatement().startStaticCall(this.context.getType(Objects.class), "requireNonNull").tree(value).doubleQuote(message).end().end();
                }
                builder.end();
                if (storeFence != null) {
                    builder.tree(storeFence);
                }
                builder.startStatement().tree(this.createCacheAccess(frameState, specialization, cache, CodeTreeBuilder.singleString(localName))).end();
            } else {
                throw new AssertionError();
            }
            this.setCacheInitialized(frameState, specialization, cache, true);
        } else {
            if (storeFence != null) {
                builder.tree(storeFence);
            }
            builder.startStatement().tree(this.createCacheAccess(frameState, specialization, cache, value)).end();
        }
        triples.add(new IfTriple(builder.build(), null, null));
        return triples;
    }

    private CodeTree createInsertNode(FrameState frameState, SpecializationData specialization, CacheExpression cache, CodeTree value) {
        boolean isNodeInterfaceArray;
        if (cache.isAlwaysInitialized()) {
            return value;
        }
        if (cache.isBind()) {
            return value;
        }
        if (!cache.isAdopt()) {
            return value;
        }
        Parameter parameter = cache.getParameter();
        TypeMirror type = parameter.getType();
        DeclaredType nodeType = this.types.Node;
        CodeTypeMirror.ArrayCodeTypeMirror nodeArrayType = new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Node);
        boolean isNode = ElementUtils.isAssignable(parameter.getType(), nodeType);
        boolean isNodeInterface = isNode || ElementUtils.isAssignable(type, this.types.NodeInterface);
        boolean isNodeArray = ElementUtils.isAssignable(type, nodeArrayType);
        boolean bl = isNodeInterfaceArray = isNodeArray || FlatNodeGenFactory.isNodeArray(type);
        if (isNodeInterface || isNodeInterfaceArray) {
            ReferenceType castType;
            CodeTree insertTarget = frameState.isSpecializationClassInitialized(specialization) && FlatNodeGenFactory.specializationClassIsNode(specialization) ? CodeTreeBuilder.singleString(FlatNodeGenFactory.createSpecializationLocalName(specialization)) : FlatNodeGenFactory.createNodeAccess(frameState);
            if (isNodeInterface) {
                castType = isNode ? null : nodeType;
            } else {
                assert (isNodeInterfaceArray);
                castType = isNodeArray ? null : nodeArrayType;
            }
            CodeTreeBuilder noCast = new CodeTreeBuilder(null);
            if (castType == null) {
                noCast.startCall(insertTarget, "insert");
            } else {
                noCast.startStaticCall(this.types.DSLSupport, "maybeInsert");
                noCast.tree(insertTarget);
            }
            noCast.tree(value);
            noCast.end();
            return noCast.build();
        }
        return value;
    }

    private static CodeTree createNodeAccess(FrameState frameState, SpecializationData specialization) {
        if (specialization != null && FlatNodeGenFactory.substituteNodeWithSpecializationClass(specialization) && !frameState.getMode().isUncached()) {
            return CodeTreeBuilder.singleString(FlatNodeGenFactory.createSpecializationLocalName(specialization));
        }
        return FlatNodeGenFactory.createNodeAccess(frameState);
    }

    private static CodeTree createNodeAccess(FrameState frameState) {
        if (frameState.isInlinedNode()) {
            return frameState.getValue(0).createReference();
        }
        return CodeTreeBuilder.singleString("this");
    }

    private Collection<IfTriple> storeCache(FrameState frameState, NodeExecutionMode mode, SpecializationData specialization, CacheExpression cache, CodeTree value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (FlatNodeGenFactory.isCacheInitialized(frameState, specialization, cache)) {
            return Collections.emptyList();
        }
        TypeMirror type = cache.getParameter().getType();
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        String refName = this.createCacheLocalName(cache);
        if (mode.isSlowPath() && FlatNodeGenFactory.cacheNeedsSpecializationClass(frameState, specialization, cache)) {
            builder.tree(this.initializeSpecializationClass(frameState, specialization, false));
        }
        CodeTree useValue = this.createInsertNode(frameState, specialization, cache, value);
        if (this.sharedCaches.containsKey(cache)) {
            builder.declaration(type, refName, (CodeTree)null);
            LocalVariable cacheClass = this.createCacheClassAccess(frameState, builder, cache);
            if (cacheClass != null) {
                builder.startIf().tree(cacheClass.createReference()).string(" != null").end().startBlock();
                builder.startStatement();
                builder.string(refName).string(" = ").tree(this.createCacheAccess(frameState, specialization, cache, null));
                builder.end();
                builder.end().startElseBlock();
                builder.startStatement();
                builder.string(refName).string(" = ").tree(useValue);
                builder.end();
            } else {
                String sharedName = refName + "_shared";
                builder.declaration(type, sharedName, this.createCacheAccess(frameState, specialization, cache, null));
                builder.startIf().string(sharedName).string(" != ").string(ElementUtils.defaultValue(cache.getParameter().getType())).end().startBlock();
                builder.startStatement();
                builder.string(refName).string(" = ").string(sharedName);
                builder.end();
                builder.end().startElseBlock();
                builder.startStatement();
                builder.string(refName).string(" = ").tree(useValue);
                builder.end();
                this.checkSharedCacheNull(builder, refName, specialization, cache);
            }
            builder.end();
            builder.end();
            CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
            b.tree(this.createCacheAccess(frameState, specialization, cache, null));
            b.string(" == ");
            b.string(ElementUtils.defaultValue(cache.getParameter().getType()));
            b.string(" ? ");
            b.tree(useValue);
            b.string(" : ");
            b.tree(this.createCacheAccess(frameState, specialization, cache, null));
            useValue = b.build();
        } else if (cache.isAlwaysInitialized() && frameState.getMode().isSlowPath()) {
            builder.startStatement().string(refName, " = ").tree(useValue).end();
        } else {
            builder.declaration(type, refName, useValue);
        }
        this.setCacheInitialized(frameState, specialization, cache, true);
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        triples.add(new IfTriple(builder.build(), null, null));
        return triples;
    }

    private static boolean cacheNeedsSpecializationClass(FrameState frameState, SpecializationData specialization, CacheExpression cache) {
        return frameState.getMode().isSlowPath() && FlatNodeGenFactory.substituteNodeWithSpecializationClass(specialization) && specialization.isNodeReceiverBound(cache.getDefaultExpression());
    }

    private void checkSharedCacheNull(CodeTreeBuilder builder, String refName, SpecializationData specialization, CacheExpression cache) {
        if (FlatNodeGenFactory.useCacheClass(specialization, cache)) {
            return;
        }
        if (cache.isEagerInitialize()) {
            return;
        }
        builder.startIf().string(refName).string(" == ").string(ElementUtils.defaultValue(cache.getParameter().getType())).end().startBlock();
        String message = String.format("Specialization '%s' contains a shared cache with name '%s' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.", ElementUtils.getReadableSignature(specialization.getMethod()), cache.getParameter().getLocalName());
        builder.startThrow().startNew(this.context.getType(IllegalStateException.class)).doubleQuote(message).end().end();
        builder.end();
    }

    private static boolean isCacheInitialized(FrameState frameState, SpecializationData specialization, CacheExpression cache) {
        return frameState.getCacheInitialized(specialization, cache) != null;
    }

    private void setCacheInitialized(FrameState frameState, SpecializationData specialization, CacheExpression cache, boolean initialized) {
        String name = this.createFieldName(specialization, cache);
        if (initialized) {
            frameState.set(name, new LocalVariable(cache.getParameter().getType(), name, CodeTreeBuilder.singleString(this.createCacheLocalName(cache))));
        } else {
            frameState.set(name, null);
        }
    }

    private String createCacheLocalName(CacheExpression cache) {
        String refName;
        List variables;
        int index;
        Object name = this.sharedCaches.get(cache);
        if (name == null) {
            name = ElementUtils.firstLetterLowerCase(cache.getParameter().getLocalName()) + NAME_SUFFIX;
        }
        if ((index = (variables = this.uniqueCachedParameterLocalNames.computeIfAbsent(refName = (String)name + NAME_SUFFIX, v -> new ArrayList())).indexOf(cache.getParameter())) == -1) {
            index = variables.size();
            variables.add(cache.getParameter());
        }
        if (index != 0) {
            refName = (String)name + NAME_SUFFIX + index;
        }
        return refName;
    }

    private CodeTree initializeCache(FrameState frameState, SpecializationData specialization, CacheExpression cache) {
        CodeTree tree;
        String name = this.createFieldName(specialization, cache);
        if (frameState.get(name) != null) {
            return null;
        }
        boolean aot = frameState.getBoolean(AOT_STATE, false);
        if (cache.isMergedLibrary()) {
            if (frameState.getMode().isUncached()) {
                CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
                builder.staticReference(FlatNodeGenFactory.createLibraryConstant(this.constants, cache.getParameter().getType()));
                builder.startCall(".getUncached");
                builder.tree(this.writeExpression(frameState, specialization, cache.getDefaultExpression()));
                builder.end();
                tree = builder.build();
            } else {
                tree = CodeTreeBuilder.singleString("this." + cache.getMergedLibraryIdentifier());
            }
        } else {
            DSLExpression expression;
            if (frameState.getMode().isUncached()) {
                expression = cache.getUncachedExpression();
            } else {
                expression = cache.getDefaultExpression();
                if (aot && expression != null) {
                    expression = this.substituteManualToAutoDispatch(expression);
                }
                if (cache.getInlinedNode() != null) {
                    return null;
                }
                if (specialization.needsTruffleBoundary() && (specialization.isAnyLibraryBoundInGuard() || specialization.needsVirtualFrame())) {
                    expression = this.substituteToDispatchedUncached(expression);
                }
            }
            tree = this.writeExpression(frameState, specialization, expression);
        }
        return tree;
    }

    private DSLExpression substituteManualToAutoDispatch(DSLExpression expression) {
        return expression.reduce(new DSLExpression.DSLExpressionReducer(){

            @Override
            public DSLExpression visitVariable(DSLExpression.Variable binary) {
                return binary;
            }

            @Override
            public DSLExpression visitNegate(DSLExpression.Negate negate) {
                return negate;
            }

            @Override
            public DSLExpression visitCall(DSLExpression.Call call) {
                if (call.getName().equals("create") && ElementUtils.typeEquals(call.getResolvedMethod().getEnclosingElement().asType(), FlatNodeGenFactory.this.types.LibraryFactory)) {
                    DSLExpression.Call newCall = new DSLExpression.Call(call.getReceiver(), call.getName(), Arrays.asList(new DSLExpression.IntLiteral("2")));
                    newCall.setResolvedMethod(ElementUtils.findExecutableElement(FlatNodeGenFactory.this.types.LibraryFactory, "createDispatched", 1));
                    newCall.setResolvedTargetType(call.getResolvedTargetType());
                    return newCall;
                }
                return call;
            }

            @Override
            public DSLExpression visitBinary(DSLExpression.Binary binary) {
                return binary;
            }
        });
    }

    private DSLExpression substituteToDispatchedUncached(DSLExpression expression) {
        return expression.reduce(new DSLExpression.DSLExpressionReducer(){

            @Override
            public DSLExpression visitVariable(DSLExpression.Variable binary) {
                return binary;
            }

            @Override
            public DSLExpression visitNegate(DSLExpression.Negate negate) {
                return negate;
            }

            @Override
            public DSLExpression visitCall(DSLExpression.Call call) {
                if (call.getName().equals("getUncached") && ElementUtils.typeEquals(call.getResolvedMethod().getEnclosingElement().asType(), FlatNodeGenFactory.this.types.LibraryFactory)) {
                    DSLExpression.Call newCall = new DSLExpression.Call(call.getReceiver(), call.getName(), Collections.emptyList());
                    newCall.setResolvedMethod(ElementUtils.findExecutableElement(FlatNodeGenFactory.this.types.LibraryFactory, "getUncached", 0));
                    newCall.setResolvedTargetType(call.getResolvedTargetType());
                    return newCall;
                }
                return call;
            }

            @Override
            public DSLExpression visitBinary(DSLExpression.Binary binary) {
                return binary;
            }
        });
    }

    private IfTriple createMethodGuardCheck(FrameState frameState, SpecializationData specialization, GuardExpression guard, NodeExecutionMode mode) {
        CodeTreeBuilder init = CodeTreeBuilder.createBuilder();
        CodeTreeBuilder condition = CodeTreeBuilder.createBuilder();
        DSLExpression expression = this.optimizeExpression(guard.getExpression());
        CodeTree assertion = null;
        if (mode.isFastPath()) {
            CodeTree guardExpression = this.writeExpression(frameState, specialization, expression);
            if (guard.isFastPathIdempotent()) {
                assertion = CodeTreeBuilder.createBuilder().startAssert().startStaticCall(this.types.DSLSupport, "assertIdempotence").tree(guardExpression).end().end().build();
            } else {
                condition.tree(guardExpression);
            }
        } else if (mode.isSlowPath() || mode.isUncached()) {
            if (mode.isSlowPath() && specialization.isNodeReceiverBound(expression) && FlatNodeGenFactory.substituteNodeWithSpecializationClass(specialization)) {
                init.tree(this.initializeSpecializationClass(frameState, specialization, false));
            }
            CodeTree guardExpression = this.writeExpression(frameState, specialization, expression);
            if (guard.isConstantTrueInSlowPath(mode.isUncached())) {
                assertion = CodeTreeBuilder.createBuilder().startStatement().string("// assert ").tree(guardExpression).end().build();
            } else {
                condition.tree(guardExpression);
            }
        } else if (mode.isGuardFallback()) {
            GuardExpression guardWithBit = FlatNodeGenFactory.getGuardThatNeedsStateBit(specialization, guard);
            if (guardWithBit != null) {
                condition.string("(");
                StateQuery query = StateQuery.create(BitStateList.GuardActive.class, guardWithBit);
                SpecializationStateReference ref = this.createStateReference(frameState, specialization, StateQuery.create(BitStateList.GuardActive.class, guardWithBit));
                if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
                    condition.tree(this.createGetSpecializationClass(frameState, specialization, true));
                    condition.string(" == null || ");
                }
                condition.tree(ref.bitSet.createNotContains(ref.reference, query));
                condition.string(" || ");
                for (CacheExpression cache : FlatNodeGenFactory.getNullCachesDueToFallback(specialization, guard)) {
                    String localName = this.createCacheLocalName(cache);
                    LocalVariable cacheWrapper = this.createCacheClassAccess(frameState, init, cache);
                    if (cacheWrapper == null) {
                        if (!FlatNodeGenFactory.isCacheInitialized(frameState, specialization, cache)) {
                            init.startStatement();
                            init.type(cache.getParameter().getType());
                            init.string(" ", localName, " = ");
                            if (FlatNodeGenFactory.useSpecializationClass(specialization) && cache.getSharedGroup() == null) {
                                init.tree(this.createGetSpecializationClass(frameState, specialization, true));
                                init.string(" == null ? null : ");
                            }
                            init.tree(this.createCacheAccess(frameState, specialization, cache, null));
                            init.end();
                            this.setCacheInitialized(frameState, specialization, cache, true);
                        }
                        condition.string(localName).string(" == ").defaultValue(cache.getParameter().getType());
                        condition.string(" || ");
                        continue;
                    }
                    condition.tree(cacheWrapper.createReference()).string(" == null");
                    condition.string(" || ");
                }
                condition.tree(this.writeExpression(frameState, specialization, expression));
                condition.string(")");
                this.fallbackNeedsState = true;
            } else {
                condition.tree(this.writeExpression(frameState, specialization, expression));
            }
        }
        return new IfTriple(init.build(), condition.build(), assertion);
    }

    private static Map<DSLExpression.Variable, CodeTree> castBoundTypes(Map<DSLExpression.Variable, LocalVariable> bindings) {
        HashMap<DSLExpression.Variable, CodeTree> resolvedBindings = new HashMap<DSLExpression.Variable, CodeTree>();
        for (DSLExpression.Variable variable : bindings.keySet()) {
            LocalVariable localVariable = bindings.get(variable);
            CodeTree resolved = localVariable.createReference();
            TypeMirror sourceType = localVariable.getTypeMirror();
            TypeMirror targetType = variable.getResolvedTargetType();
            if (targetType == null) {
                targetType = variable.getResolvedType();
            }
            if (!ElementUtils.isAssignable(sourceType, targetType)) {
                resolved = CodeTreeBuilder.createBuilder().startParantheses().cast(targetType, resolved).end().build();
            }
            resolvedBindings.put(variable, resolved);
        }
        return resolvedBindings;
    }

    private Map<DSLExpression.Variable, LocalVariable> bindExpressionValues(FrameState frameState, DSLExpression expression, SpecializationData specialization) throws AssertionError {
        HashMap<DSLExpression.Variable, LocalVariable> bindings = new HashMap<DSLExpression.Variable, LocalVariable>();
        Set<DSLExpression.Variable> boundVariables = expression.findBoundVariables();
        if (specialization == null && !boundVariables.isEmpty()) {
            throw new AssertionError((Object)"Cannot bind guard variable in non-specialization group. yet.");
        }
        for (DSLExpression.Variable variable : boundVariables) {
            Parameter resolvedParameter = specialization.findByVariable(variable.getResolvedVariable());
            if (resolvedParameter != null) {
                LocalVariable localVariable = this.bindExpressionVariable(frameState, specialization, resolvedParameter);
                if (localVariable == null) continue;
                bindings.put(variable, localVariable);
                continue;
            }
            if (!specialization.isNodeReceiverVariable(variable.getResolvedVariable())) continue;
            CodeTree accessor = FlatNodeGenFactory.createNodeAccess(frameState, specialization);
            if (FlatNodeGenFactory.substituteNodeWithSpecializationClass(specialization) && !frameState.mode.isUncached()) {
                String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                bindings.put(variable, new LocalVariable(this.types.Node, localName, accessor));
                continue;
            }
            bindings.put(variable, new LocalVariable(variable.getResolvedType(), "this", accessor));
        }
        return bindings;
    }

    private LocalVariable bindExpressionVariable(FrameState frameState, SpecializationData specialization, Parameter resolvedParameter) {
        LocalVariable localVariable;
        if (resolvedParameter.getSpecification().isCached()) {
            CacheExpression cache = specialization.findCache(resolvedParameter);
            String cachedMemberName = this.createFieldName(specialization, cache);
            localVariable = frameState.get(cachedMemberName);
            CodeTree ref = localVariable == null ? this.createCacheAccess(frameState, specialization, cache, null) : localVariable.createReference();
            localVariable = new LocalVariable(resolvedParameter.getType(), cachedMemberName, ref);
        } else if (resolvedParameter.getSpecification().isSignature()) {
            NodeExecutionData execution = resolvedParameter.getSpecification().getExecution();
            if (!frameState.getMode().isUncached() && specialization.isNodeReceiverVariable(resolvedParameter.getVariableElement())) {
                if (FlatNodeGenFactory.substituteNodeWithSpecializationClass(specialization)) {
                    String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                    localVariable = new LocalVariable(this.types.Node, localName, this.createGetSpecializationClass(frameState, specialization, true));
                } else {
                    localVariable = frameState.isInlinedNode() ? frameState.getValue(execution) : new LocalVariable(this.types.Node, "this", CodeTreeBuilder.singleString("this"));
                }
            } else {
                localVariable = frameState.getValue(execution);
            }
        } else {
            localVariable = frameState.get(resolvedParameter.getLocalName());
        }
        return localVariable;
    }

    private static boolean substituteNodeWithSpecializationClass(SpecializationData specialization) {
        if (!FlatNodeGenFactory.useSpecializationClass(specialization)) {
            return false;
        }
        if (!FlatNodeGenFactory.specializationClassIsNode(specialization)) {
            return false;
        }
        if (FlatNodeGenFactory.useParentInlinedAccess(specialization)) {
            return true;
        }
        if (FlatNodeGenFactory.hasSharedInlinedCache(specialization)) {
            return false;
        }
        if (specialization.hasMultipleInstances()) {
            return true;
        }
        for (CacheExpression cache : specialization.getCaches()) {
            if (cache.getSharedGroup() != null || cache.getInlinedNode() == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSharedInlinedCache(SpecializationData specialization) {
        boolean hasSharedInlined = false;
        for (CacheExpression cache : specialization.getCaches()) {
            if (cache.getInlinedNode() == null || FlatNodeGenFactory.canCacheBeStoredInSpecialializationClass(cache) || cache.getSharedGroup() == null) continue;
            hasSharedInlined = true;
            break;
        }
        return hasSharedInlined;
    }

    private CodeTree createSpecializationFieldAccess(FrameState frameState, SpecializationData specialization, boolean useSpecializationClass, boolean useSpecializationClassLocal, String fieldName, CodeTree value) {
        CodeTree specializationClass;
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        if (value != null && fieldName == null) {
            if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
                builder.string("this.", this.createSpecializationFieldName(specialization));
                return FlatNodeGenFactory.createInlinedAccess(frameState, null, builder.build(), value);
            }
            throw new AssertionError((Object)"Cannot set this");
        }
        CodeTree codeTree = specializationClass = useSpecializationClass ? this.createGetSpecializationClass(frameState, specialization, useSpecializationClassLocal) : null;
        if (specializationClass != null) {
            builder.tree(specializationClass);
            if (fieldName != null) {
                builder.string(".");
                builder.string(fieldName);
            }
            if (value != null) {
                builder.string(" = ").tree(value);
            }
        } else {
            if (fieldName == null) {
                throw new AssertionError((Object)"Invalid specialization field access.");
            }
            builder.string("this.");
            builder.string(fieldName);
            return FlatNodeGenFactory.createInlinedAccess(frameState, specialization, builder.build(), value);
        }
        return builder.build();
    }

    private CodeTree createGetSpecializationClass(FrameState frameState, SpecializationData specialization, boolean useLocal) {
        if (FlatNodeGenFactory.useSpecializationClass(specialization)) {
            LocalVariable var;
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
            LocalVariable localVariable = var = useLocal ? frameState.get(localName) : null;
            if (var != null) {
                builder.string(localName);
                return builder.build();
            }
            builder.string("this.", this.createSpecializationFieldName(specialization));
            return FlatNodeGenFactory.createInlinedAccess(frameState, null, builder.build(), null);
        }
        return null;
    }

    private LocalVariable createCacheClassAccess(FrameState frameState, CodeTreeBuilder builder, CacheExpression cache) {
        if (cache.getSharedGroup() == null) {
            return null;
        }
        if (!FlatNodeGenFactory.useCacheClass(null, cache)) {
            return null;
        }
        LocalVariable var = frameState.getCacheClassInitialized(cache);
        if (var != null) {
            return var;
        }
        if (builder != null) {
            TypeMirror type = FlatNodeGenFactory.createCacheClassType(cache);
            String name = this.createFieldName(null, cache);
            String localName = name + "_wrapper";
            builder.declaration(type, localName, FlatNodeGenFactory.createInlinedAccess(frameState, null, CodeTreeBuilder.singleString("this." + name), null));
            var = new LocalVariable(type, localName, CodeTreeBuilder.singleString(localName));
            frameState.set(frameState.createCacheClassInitializedKey(cache), var);
        }
        return var;
    }

    private CodeTree createCacheAccess(FrameState frameState, SpecializationData specialization, CacheExpression cache, CodeTree value) {
        if (cache == null) {
            return CodeTreeBuilder.singleString("null /* cache not resolved */");
        }
        if (frameState.getMode().isUncached() || cache.isAlwaysInitialized()) {
            return this.initializeCache(frameState, specialization, cache);
        }
        if (cache.getInlinedNode() != null) {
            if (frameState.isInlinedNode()) {
                CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
                String cacheFieldName = this.createLocalCachedInlinedName(specialization, cache);
                builder.string("this.", cacheFieldName);
                if (value != null) {
                    throw new AssertionError((Object)"Cannot set inlined field.");
                }
                return builder.build();
            }
            return CodeTreeBuilder.singleString(this.createStaticInlinedCacheName(specialization, cache));
        }
        if (cache.isEncodedEnum()) {
            if (value == null) {
                return this.createDecodeEnum(frameState, specialization, cache);
            }
            return this.createEncodeEnum(frameState, specialization, cache, value);
        }
        if (cache.getSharedGroup() != null) {
            String cacheFieldName = this.createFieldName(specialization, cache);
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            LocalVariable cacheClass = this.createCacheClassAccess(frameState, null, cache);
            if (cacheClass != null) {
                builder.tree(cacheClass.createReference()).string(".delegate");
                if (value != null) {
                    builder.string(" = ").tree(value);
                }
                return builder.build();
            }
            builder.string("this.").string(cacheFieldName);
            if (FlatNodeGenFactory.useCacheClass(specialization, cache)) {
                builder.string(".delegate");
            }
            CodeTree nodeAccess = FlatNodeGenFactory.createNodeAccess(frameState);
            return FlatNodeGenFactory.createInlinedAccess(frameState, specialization, builder.build(), value, nodeAccess);
        }
        String cacheFieldName = this.createLocalCachedInlinedName(specialization, cache);
        return this.createSpecializationFieldAccess(frameState, specialization, true, true, cacheFieldName, value);
    }

    private CodeTree createEncodeEnum(FrameState frameState, SpecializationData specialization, CacheExpression cache, CodeTree value) {
        CodeTreeBuilder innerValue = CodeTreeBuilder.createBuilder();
        innerValue.startGroup().string("(");
        if (cache.isNeverDefaultGuaranteed()) {
            innerValue.tree(value);
            innerValue.string(".ordinal()");
        } else {
            CodeExecutableElement method = this.lookupEncodeEnum(cache.getParameter().getType());
            innerValue.startCall(method.getSimpleName().toString());
            innerValue.tree(value);
            innerValue.end();
        }
        innerValue.string(" + ").string(FlatNodeGenFactory.getEncodedEnumOffset(cache));
        innerValue.string(")").end();
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        StateQuery query = StateQuery.create(BitStateList.EncodedEnumState.class, this.lookupSharedCacheKey(cache));
        SpecializationStateReference ref = this.createStateReference(frameState, specialization, query);
        if (cache.getSharedGroup() != null && !cache.isEagerInitialize()) {
            CodeTree stateRef = CodeTreeBuilder.createBuilder().string("this.", ref.bitSet.getName(), NAME_SUFFIX).build();
            builder.tree(FlatNodeGenFactory.createInlinedAccess(frameState, specialization, stateRef, ref.bitSet.createSetInteger(ref.reference, query, innerValue.build())));
        } else {
            builder.tree(ref.bitSet.createSetInteger(ref.reference, query, innerValue.build()));
        }
        return builder.build();
    }

    private static int getEncodedEnumOffset(CacheExpression cache) {
        if (cache.isNeverDefault()) {
            return 1;
        }
        return 2;
    }

    private CodeTree createDecodeEnum(FrameState frameState, SpecializationData specialization, CacheExpression cache) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        CodeExecutableElement decodeMethod = this.lookupDecodeEnum(cache.getParameter().getType());
        StateQuery query = StateQuery.create(BitStateList.EncodedEnumState.class, this.lookupSharedCacheKey(cache));
        builder.startCall(decodeMethod.getSimpleName().toString());
        builder.startGroup().string("(");
        SpecializationStateReference reference = this.createStateReference(frameState, specialization, query);
        builder.tree(reference.bitSet.createExtractInteger(reference.reference, query));
        builder.string(")");
        builder.string(" - ").string(FlatNodeGenFactory.getEncodedEnumOffset(cache));
        builder.end();
        builder.end();
        return builder.build();
    }

    private SpecializationStateReference createStateReference(FrameState frameState, SpecializationData specialization, StateQuery query) {
        CodeTree reference;
        MultiStateBitSet multiSet = specialization != null ? this.lookupSpecializationState(specialization) : null;
        BitSet foundSet = null;
        if (multiSet != null) {
            foundSet = multiSet.findSet(query);
        }
        if (foundSet == null) {
            multiSet = this.multiState;
            foundSet = multiSet.findSet(query);
            if (foundSet == null) {
                throw new AssertionError((Object)"Could not find state.");
            }
            reference = foundSet.createReference(frameState);
        } else {
            CodeTreeBuilder inner = CodeTreeBuilder.createBuilder();
            inner.tree(this.createGetSpecializationClass(frameState, specialization, true));
            inner.string(".", foundSet.getName(), NAME_SUFFIX);
            reference = inner.build();
        }
        return new SpecializationStateReference(foundSet, reference);
    }

    private CodeExecutableElement lookupEncodeEnum(TypeMirror mirror) {
        String typeId = ElementUtils.getUniqueIdentifier(mirror);
        CodeExecutableElement method = this.constants.encodeConstants.get(typeId);
        if (method == null) {
            String methodName = this.constants.reserveSymbol(mirror, "encode" + ElementUtils.firstLetterUpperCase(ElementUtils.getTypeId(mirror)));
            method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC), this.context.getType(Integer.TYPE), methodName, new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(mirror, "e"));
            CodeTreeBuilder builder = method.createBuilder();
            builder.startIf().string("e != null").end().startBlock();
            builder.statement("return e.ordinal()");
            builder.end().startElseBlock();
            builder.statement("return -1");
            builder.end();
            this.constants.encodeConstants.put(typeId, method);
        }
        return method;
    }

    private CodeExecutableElement lookupDecodeEnum(TypeMirror mirror) {
        String typeId = ElementUtils.getUniqueIdentifier(mirror);
        CodeExecutableElement method = this.constants.decodeConstants.get(typeId);
        if (method == null) {
            String methodName = this.constants.reserveSymbol(mirror, "decode" + ElementUtils.firstLetterUpperCase(ElementUtils.getTypeId(mirror)));
            method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC), mirror, methodName, new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(this.context.getType(Integer.TYPE), "state"));
            CodeTreeBuilder builder = method.createBuilder();
            builder.startIf().string("state >= 0").end().startBlock();
            builder.startReturn().string(this.lookupEnumConstants(mirror).getName()).string("[state]").end();
            builder.end().startElseBlock();
            builder.statement("return null");
            builder.end();
            this.constants.decodeConstants.put(typeId, method);
        }
        return method;
    }

    private CodeVariableElement lookupEnumConstants(TypeMirror mirror) {
        String typeId = ElementUtils.getUniqueIdentifier(mirror);
        CodeVariableElement var = this.constants.enumValues.get(typeId);
        if (var == null) {
            String constantName = this.constants.reserveSymbol(mirror, ElementUtils.createConstantName(ElementUtils.getTypeId(mirror)) + "_VALUES");
            var = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), new CodeTypeMirror.ArrayCodeTypeMirror(mirror), constantName);
            FlatNodeGenFactory.addCompilationFinalAnnotation(var, 1);
            CodeTreeBuilder init = var.createInitBuilder();
            init.startStaticCall(this.types.DSLSupport, "lookupEnumConstants").typeLiteral(mirror).end();
            this.constants.enumValues.put(typeId, var);
        }
        return var;
    }

    static CodeTree createInlinedAccess(FrameState frameState, SpecializationData specialization, CodeTree reference, CodeTree value, CodeTree nodeReference) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(reference);
        if (frameState != null && frameState.isInlinedNode()) {
            if (value == null) {
                builder.startCall(".get").tree(nodeReference).end();
            } else {
                builder.startCall(".set").tree(nodeReference).tree(value).end();
            }
        } else if (value != null) {
            builder.string(" = ").tree(value);
        }
        return builder.build();
    }

    static CodeTree createInlinedAccess(FrameState frameState, SpecializationData specialization, CodeTree reference, CodeTree value) {
        return FlatNodeGenFactory.createInlinedAccess(frameState, specialization, reference, value, FlatNodeGenFactory.createNodeAccess(frameState, specialization));
    }

    private CodeTree createAssumptionReference(FrameState frameState, SpecializationData s, AssumptionExpression a) {
        String assumptionFieldName = FlatNodeGenFactory.createAssumptionFieldName(s, a);
        return this.createSpecializationFieldAccess(frameState, s, true, true, assumptionFieldName, null);
    }

    private IfTriple createTypeCheckOrCast(FrameState frameState, SpecializationGroup group, SpecializationGroup.TypeGuard typeGuard, NodeExecutionMode specializationExecution, boolean castOnly, boolean forceImplicitCast) {
        CodeTreeBuilder prepareBuilder = CodeTreeBuilder.createBuilder();
        CodeTreeBuilder checkBuilder = CodeTreeBuilder.createBuilder();
        int signatureIndex = typeGuard.getSignatureIndex();
        LocalVariable value = frameState.getValue(signatureIndex);
        TypeMirror targetType = typeGuard.getType();
        if (value == null) {
            return null;
        }
        if (!ElementUtils.needsCastTo(value.getTypeMirror(), targetType)) {
            Parameter parameter = this.node.getFallbackSpecialization().findParameter(this.node.getChildExecutions().get(signatureIndex));
            if (parameter == null || ElementUtils.typeEquals(value.getTypeMirror(), parameter.getType())) {
                return null;
            }
            boolean foundImplicitSubType = false;
            if (forceImplicitCast) {
                List<ImplicitCastData> casts = this.typeSystem.lookupByTargetType(targetType);
                for (ImplicitCastData cast : casts) {
                    if (!ElementUtils.isSubtype(cast.getSourceType(), targetType)) continue;
                    foundImplicitSubType = true;
                    break;
                }
            }
            if (!foundImplicitSubType) {
                return null;
            }
        }
        NodeExecutionData execution = this.node.getChildExecutions().get(signatureIndex);
        CodeTreeBuilder castBuilder = prepareBuilder.create();
        List<ImplicitCastData> sourceTypes = this.typeSystem.lookupByTargetType(targetType);
        CodeTree valueReference = value.createReference();
        if (sourceTypes.isEmpty()) {
            checkBuilder.tree(TypeSystemCodeGenerator.check(this.typeSystem, targetType, valueReference));
            castBuilder.tree(TypeSystemCodeGenerator.cast(this.typeSystem, targetType, valueReference));
        } else {
            List<SpecializationData> specializations = group.collectSpecializations();
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (SpecializationData otherSpecialization : specializations) {
                parameters.add(otherSpecialization.findParameterOrDie(execution));
            }
            if (specializationExecution.isFastPath() || specializationExecution.isGuardFallback() || specializationExecution.isUncached()) {
                CodeTree implicitState = specializationExecution.isGuardFallback() || specializationExecution.isUncached() ? null : this.multiState.createExtractInteger(frameState, StateQuery.create(BitStateList.ImplicitCastState.class, typeGuard));
                checkBuilder.tree(TypeSystemCodeGenerator.implicitCheckFlat(this.typeSystem, targetType, valueReference, implicitState));
                castBuilder.tree(TypeSystemCodeGenerator.implicitCastFlat(this.typeSystem, targetType, valueReference, implicitState));
            } else {
                Parameter parameter = (Parameter)parameters.get(0);
                String implicitStateName = FlatNodeGenFactory.createImplicitTypeStateLocalName(parameter);
                CodeTree defaultValue = null;
                prepareBuilder.declaration(this.context.getType(Integer.TYPE), implicitStateName, defaultValue);
                CodeTree specializeCall = TypeSystemCodeGenerator.implicitSpecializeFlat(this.typeSystem, targetType, valueReference);
                checkBuilder.startParantheses();
                checkBuilder.string(implicitStateName, " = ").tree(specializeCall);
                checkBuilder.end();
                checkBuilder.string(" != 0");
                castBuilder.tree(TypeSystemCodeGenerator.implicitCastFlat(this.typeSystem, targetType, valueReference, CodeTreeBuilder.singleString(implicitStateName)));
            }
        }
        if (castOnly) {
            LocalVariable currentValue = frameState.getValue(execution);
            CodeTreeBuilder localsBuilder = CodeTreeBuilder.createBuilder();
            LocalVariable castVariable = currentValue.nextName().newType(typeGuard.getType()).accessWith(null);
            frameState.setValue(execution, castVariable);
            localsBuilder.tree(castVariable.createDeclaration(castBuilder.build()));
            return new IfTriple(localsBuilder.build(), null, null);
        }
        return new IfTriple(prepareBuilder.build(), checkBuilder.build(), null);
    }

    private List<IfTriple> initializeCasts(FrameState frameState, SpecializationGroup group, DSLExpression expression, NodeExecutionMode specializationExecution) {
        if (expression == null) {
            return Collections.emptyList();
        }
        Set<VariableElement> boundElements = expression.findBoundVariableElements();
        if (boundElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (VariableElement variable : boundElements) {
            IfTriple triple;
            LocalVariable var;
            NodeExecutionData execution;
            Parameter p = group.getSpecialization().findByVariable(variable);
            if (p == null || (execution = p.getSpecification().getExecution()) == null || (var = frameState.getValue(execution)) == null || (triple = this.createTypeCheckOrCast(frameState, group, new SpecializationGroup.TypeGuard(this.typeSystem, p.getType(), execution.getIndex()), specializationExecution, true, false)) == null) continue;
            triples.add(triple);
        }
        return triples;
    }

    private ExecutableTypeData createExecuteAndSpecializeType() {
        if (this.node.getPolymorphicExecutable() == null) {
            return null;
        }
        TypeMirror polymorphicType = this.node.getPolymorphicExecutable().getReturnType();
        ArrayList<TypeMirror> parameters = new ArrayList<TypeMirror>();
        for (TypeMirror param : this.node.getPolymorphicExecutable().getSignatureParameters()) {
            parameters.add(param);
        }
        return new ExecutableTypeData(this.node, polymorphicType, this.createExecuteAndSpecializeName(), this.node.getFrameType(), parameters);
    }

    private List<TypeMirror> resolveOptimizedImplicitSourceTypes(NodeExecutionData execution, TypeMirror targetType) {
        Collection<TypeMirror> allSourceTypes = this.typeSystem.lookupSourceTypes(targetType);
        ArrayList<TypeMirror> filteredSourceTypes = new ArrayList<TypeMirror>();
        for (TypeMirror sourceType : allSourceTypes) {
            ExecutableTypeData executableType = this.resolveTargetExecutable(execution, sourceType);
            if (executableType == null || !ElementUtils.isPrimitive(sourceType) || !this.boxingEliminationEnabled || !ElementUtils.typeEquals(executableType.getReturnType(), sourceType)) continue;
            filteredSourceTypes.add(sourceType);
        }
        return filteredSourceTypes;
    }

    private ChildExecutionResult createExecuteChildImplicitCast(CodeTreeBuilder parent, FrameState originalFrameState, FrameState frameState, NodeExecutionData execution, LocalVariable target) {
        CodeTreeBuilder builder = parent.create();
        ArrayList<TypeMirror> originalSourceTypes = new ArrayList<TypeMirror>(this.typeSystem.lookupSourceTypes(target.getTypeMirror()));
        List<TypeMirror> sourceTypes = this.resolveOptimizedImplicitSourceTypes(execution, target.getTypeMirror());
        StateQuery implicitTypeGuardQuery = StateQuery.create(BitStateList.ImplicitCastState.class, new SpecializationGroup.TypeGuard(this.typeSystem, target.getTypeMirror(), execution.getIndex()));
        boolean throwsUnexpected = false;
        boolean elseIf = false;
        for (TypeMirror sourceType : sourceTypes) {
            ExecutableTypeData executableType = this.resolveTargetExecutable(execution, sourceType);
            elseIf = builder.startIf(elseIf);
            throwsUnexpected |= executableType.hasUnexpectedValue();
            builder.startGroup();
            CodeTree tree = this.multiState.createContainsOnly(frameState, originalSourceTypes.indexOf(sourceType), 1, implicitTypeGuardQuery, implicitTypeGuardQuery);
            if (!tree.isEmpty()) {
                builder.tree(tree);
                builder.string(" && ");
            }
            builder.tree(this.multiState.createIsNotAny(frameState, StateQuery.create(BitStateList.SpecializationActive.class, this.node.getReachableSpecializations())));
            builder.end();
            builder.end();
            builder.startBlock();
            CodeTree value = this.callChildExecuteMethod(execution, executableType, frameState);
            value = this.expect(executableType.getReturnType(), sourceType, value);
            throwsUnexpected |= ElementUtils.needsCastTo(executableType.getReturnType(), sourceType);
            ImplicitCastData cast = this.typeSystem.lookupCast(sourceType, target.getTypeMirror());
            if (cast != null) {
                String localName = FlatNodeGenFactory.createSourceTypeLocalName(target, sourceType);
                builder.startStatement().string(localName).string(" = ").tree(value).end();
                value = FlatNodeGenFactory.callMethod(frameState, null, cast.getMethod(), CodeTreeBuilder.singleString(localName));
            }
            builder.startStatement().string(target.getName()).string(" = ").tree(value).end();
            builder.end();
        }
        if (elseIf) {
            builder.startElseBlock();
        }
        LocalVariable genericValue = target.makeGeneric(this.context).nextName();
        builder.tree(this.createAssignExecuteChild(originalFrameState, frameState, builder, execution, this.node.getGenericExecutableType(null), genericValue));
        builder.startStatement().string(target.getName()).string(" = ");
        CodeTree implicitState = this.multiState.createExtractInteger(frameState, implicitTypeGuardQuery);
        builder.tree(TypeSystemCodeGenerator.implicitExpectFlat(this.typeSystem, target.getTypeMirror(), genericValue.createReference(), implicitState));
        builder.end();
        if (!sourceTypes.isEmpty()) {
            builder.end();
        }
        return new ChildExecutionResult(builder.build(), throwsUnexpected);
    }

    private void generateTraceOnEnterCall(CodeTreeBuilder builder, FrameState frameState) {
        if (this.node.isGenerateTraceOnEnter()) {
            CodeTypeMirror.ArrayCodeTypeMirror objectArray = new CodeTypeMirror.ArrayCodeTypeMirror(this.context.getType(Object.class));
            builder.startIf().startCall("isTracingEnabled").end(2);
            builder.startBlock().startStatement().startCall("traceOnEnter").startNewArray(objectArray, null);
            frameState.addReferencesTo(builder, new String[0]);
            builder.end(4);
        }
    }

    private void generateTraceOnExceptionStart(CodeTreeBuilder builder) {
        if (this.node.isGenerateTraceOnException()) {
            builder.startTryBlock();
        }
    }

    private void generateTraceOnExceptionEnd(CodeTreeBuilder builder) {
        if (this.node.isGenerateTraceOnException()) {
            builder.end();
            builder.startCatchBlock(this.context.getType(Throwable.class), "traceThrowable");
            builder.startIf().startCall("isTracingEnabled").end(2);
            builder.startBlock().startStatement().startCall("traceOnException").startGroup().string("traceThrowable").end(4);
            builder.startThrow().string("traceThrowable").end();
            builder.end();
        }
    }

    private void wrapWithTraceOnReturn(CodeExecutableElement method) {
        if (this.node.isGenerateTraceOnReturn()) {
            CodeTypeElement enclosingClass = (CodeTypeElement)method.getEnclosingElement();
            CodeExecutableElement traceMethod = CodeExecutableElement.cloneNoAnnotations(method);
            method.setSimpleName(CodeNames.of(method.getSimpleName().toString() + "Traced"));
            method.setVisibility(Modifier.PRIVATE);
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.startCall(method.getSimpleName().toString());
            for (VariableElement param : traceMethod.getParameters()) {
                builder.string(param.getSimpleName().toString());
            }
            builder.end();
            CodeTree initExpression = builder.build();
            builder = traceMethod.createBuilder();
            if (ElementUtils.isVoid(method.getReturnType())) {
                builder.startStatement().tree(initExpression).end();
                builder.startIf().startCall("isTracingEnabled").end(2);
                builder.startBlock().startStatement().startCall("traceOnReturn").string("null").end(3);
            } else {
                builder.declaration(method.getReturnType(), "traceValue", initExpression);
                builder.startIf().startCall("isTracingEnabled").end(2);
                builder.startBlock().startStatement().startCall("traceOnReturn").string("traceValue").end(3);
                builder.startReturn().string("traceValue").end();
            }
            enclosingClass.add(traceMethod);
        }
    }

    public static enum GeneratorMode {
        DEFAULT,
        EXPORTED_MESSAGE;

    }

    private static final class ParentInlineData {
        final Set<CacheExpression> foundSharedParentAccess = new LinkedHashSet<CacheExpression>();
        final Set<CacheExpression> foundSharedDirectAccess = new LinkedHashSet<CacheExpression>();

        private ParentInlineData() {
        }
    }

    private static final class NodeStateResult {
        final MultiStateBitSet activeState;
        final MultiStateBitSet allState;

        NodeStateResult(MultiStateBitSet state, MultiStateBitSet allState) {
            this.activeState = state;
            this.allState = allState;
        }
    }

    static final class MultiStateBitSet
    extends MultiBitSet {
        private final List<BitSet> all;

        MultiStateBitSet(List<BitSet> all, List<BitSet> active) {
            super(active);
            this.all = all;
        }

        public void clearLoaded(FrameState frameState) {
            for (BitSet state : this.all) {
                state.clearLoaded(frameState);
            }
        }

        <T> BitSet findSet(StateQuery query) {
            for (BitSet state : this.all) {
                if (!state.contains(query)) continue;
                return state;
            }
            return null;
        }

        <T> BitSet findSet(Class<? extends BitStateList.State<T>> clazz, T param) {
            return this.findSet(StateQuery.create(clazz, param));
        }

        int getAllCapacity() {
            int length = 0;
            for (BitSet a : this.all) {
                length += a.getBitCount();
            }
            return length;
        }

        CodeTree createContainsAll(FrameState frameState, StateQuery elements) {
            return MultiStateBitSet.createContainsImpl(this.all, frameState, elements);
        }

        List<CodeVariableElement> createCachedFields() {
            ArrayList<CodeVariableElement> variables = new ArrayList<CodeVariableElement>();
            for (BitSet bitSet : this.all) {
                variables.add(MultiStateBitSet.createCachedField(bitSet));
            }
            return variables;
        }

        static CodeVariableElement createCachedField(BitSet bitSet) {
            CodeVariableElement var = FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, bitSet.getType(), bitSet.getName() + FlatNodeGenFactory.NAME_SUFFIX, ProcessorContext.getInstance().getTypes().CompilerDirectives_CompilationFinal, new Modifier[0]);
            CodeTreeBuilder docBuilder = var.createDocBuilder();
            for (BitStateList.BitRangedState state : bitSet.getStates().getEntries()) {
                if (!state.state.isInlined()) continue;
                GeneratorUtils.markUnsafeAccessed(var);
            }
            docBuilder.startJavadoc();
            FlatNodeGenFactory.addStateDoc(docBuilder, bitSet);
            docBuilder.end();
            return var;
        }

        void addParametersTo(FrameState frameState, CodeExecutableElement targetMethod) {
            for (BitSet set : this.getSets()) {
                LocalVariable local = frameState.get(set.getName());
                if (local == null) continue;
                targetMethod.addParameter(local.createParameter());
            }
        }

        void removeParametersFrom(CodeExecutableElement targetMethod) {
            for (VariableElement var : targetMethod.getParameters().toArray(new VariableElement[0])) {
                for (BitSet set : this.getSets()) {
                    if (!var.getSimpleName().toString().equals(set.getName())) continue;
                    targetMethod.getParameters().remove(var);
                }
            }
        }

        void addReferencesTo(FrameState frameState, CodeTreeBuilder builder) {
            for (BitSet set : this.getSets()) {
                LocalVariable local = frameState.get(set.getName());
                if (local == null) continue;
                builder.tree(local.createReference());
            }
        }

        void addReferencesTo(FrameState frameState, CodeTreeBuilder builder, StateQuery ... relevantQuery) {
            for (BitSet set : this.getSets()) {
                LocalVariable local = frameState.get(set.getName());
                if (local == null || !set.contains(relevantQuery)) continue;
                builder.tree(local.createReference());
            }
        }

        CodeTree createLoad(FrameState frameState, StateQuery ... relevantQuery) {
            return MultiStateBitSet.createLoadImpl(this.getSets(), frameState, false, relevantQuery);
        }

        CodeTree createForceLoad(FrameState frameState, StateQuery ... relevantQuery) {
            return MultiStateBitSet.createLoadImpl(this.getSets(), frameState, true, relevantQuery);
        }

        private static CodeTree createLoadImpl(List<? extends BitSet> sets, FrameState frameState, boolean force, StateQuery ... relevantQuery) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            for (BitSet bitSet : sets) {
                if (!bitSet.contains(relevantQuery)) continue;
                builder.tree(bitSet.createLoad(frameState, force));
            }
            return builder.build();
        }

        CodeTree createLoadAll(FrameState frameState, StateQuery relevantQuery) {
            return MultiStateBitSet.createLoadImpl(this.all, frameState, false, relevantQuery);
        }

        CodeTree createLoadFastPath(FrameState frameState, List<SpecializationData> specializations) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            for (BitSet bitSet : this.getSets()) {
                if (!MultiStateBitSet.isRelevantForFastPath(bitSet, specializations)) continue;
                builder.tree(bitSet.createLoad(frameState));
            }
            return builder.build();
        }

        CodeTree createLoadSlowPath(FrameState frameState, List<SpecializationData> specializations, boolean force) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            for (BitSet bitSet : this.getSets()) {
                if (!MultiStateBitSet.isRelevantForSlowPath(bitSet, specializations)) continue;
                builder.tree(bitSet.createLoad(frameState, force));
            }
            return builder.build();
        }

        static boolean isRelevantForFastPath(BitSet bitSet, Collection<SpecializationData> usedSpecializations) {
            if (bitSet.getStates().contains(StateQuery.create(BitStateList.SpecializationActive.class, usedSpecializations))) {
                return true;
            }
            if (bitSet.getStates().contains(AOT_PREPARED)) {
                return true;
            }
            for (SpecializationData specialization : usedSpecializations) {
                if (!bitSet.getStates().contains(StateQuery.create(BitStateList.EncodedEnumState.class, specialization.getCaches()))) continue;
                return true;
            }
            return false;
        }

        static boolean isRelevantForSlowPath(BitSet bitSet, Collection<SpecializationData> usedSpecializations) {
            if (bitSet.getStates().contains(StateQuery.create(BitStateList.SpecializationActive.class, usedSpecializations))) {
                return true;
            }
            if (bitSet.getStates().contains(StateQuery.create(BitStateList.SpecializationExcluded.class, usedSpecializations))) {
                return true;
            }
            for (BitStateList.GuardActive guardActive : bitSet.getStates().queryStates(BitStateList.GuardActive.class)) {
                if (!usedSpecializations.contains(guardActive.getDependentSpecialization())) continue;
                return true;
            }
            for (SpecializationData specializationData : usedSpecializations) {
                if (!bitSet.contains(StateQuery.create(BitStateList.EncodedEnumState.class, specializationData.getCaches()))) continue;
                return true;
            }
            for (BitStateList.ImplicitCastState implicitCastState : bitSet.getStates().queryStates(BitStateList.ImplicitCastState.class)) {
                if (!FlatNodeGenFactory.isImplicitCastUsed(implicitCastState.node.getPolymorphicExecutable(), usedSpecializations, (SpecializationGroup.TypeGuard)implicitCastState.key)) continue;
                return true;
            }
            return false;
        }
    }

    static class SpecializationClassSizeEstimate {
        final int sizeWithClass;
        final int sizeWithoutClass;

        SpecializationClassSizeEstimate(int sizeWithClass, int sizeWithoutClass) {
            this.sizeWithClass = sizeWithClass;
            this.sizeWithoutClass = sizeWithoutClass;
        }
    }

    private static final class ReportPolymorphismAction {
        final boolean polymorphism;
        final boolean megamorphism;

        ReportPolymorphismAction(boolean polymorphism, boolean megamorphism) {
            this.polymorphism = polymorphism;
            this.megamorphism = megamorphism;
        }

        public boolean required() {
            return this.polymorphism || this.megamorphism;
        }
    }

    static enum NodeExecutionMode {
        FAST_PATH,
        SLOW_PATH,
        UNCACHED,
        FALLBACK_GUARD;


        public boolean isGuardFallback() {
            return this == FALLBACK_GUARD;
        }

        public boolean isUncached() {
            return this == UNCACHED;
        }

        public boolean isSlowPath() {
            return this == SLOW_PATH;
        }

        public final boolean isFastPath() {
            return this == FAST_PATH;
        }
    }

    static final class FrameState {
        private final FlatNodeGenFactory factory;
        private final Map<String, LocalVariable> values = new HashMap<String, LocalVariable>();
        private final Map<String, Boolean> directValues = new HashMap<String, Boolean>();
        private final NodeExecutionMode mode;
        private final CodeExecutableElement method;
        private final List<TypeMirror> caughtTypes = new ArrayList<TypeMirror>();

        private FrameState(FlatNodeGenFactory factory, NodeExecutionMode mode, CodeExecutableElement method) {
            this.factory = factory;
            this.mode = mode;
            this.method = method;
        }

        public void addCaughtException(TypeMirror exceptionType) {
            this.caughtTypes.add(exceptionType);
        }

        public void addThrownExceptions(ExecutableElement calledMethod) {
            TruffleTypes types = ProcessorContext.getInstance().getTypes();
            block0: for (TypeMirror typeMirror : calledMethod.getThrownTypes()) {
                if (ElementUtils.isAssignable(typeMirror, ProcessorContext.getInstance().getType(RuntimeException.class)) || this.factory.generatorMode != GeneratorMode.EXPORTED_MESSAGE && ElementUtils.isAssignable(typeMirror, types.UnexpectedResultException)) continue;
                for (TypeMirror caughtType : this.caughtTypes) {
                    if (!ElementUtils.typeEquals(caughtType, typeMirror)) continue;
                    continue block0;
                }
                boolean found = false;
                for (TypeMirror foundType : this.method.getThrownTypes()) {
                    if (!ElementUtils.typeEquals(typeMirror, foundType)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.method.getThrownTypes().add(typeMirror);
            }
        }

        public boolean isInlinedNode() {
            return this.getBoolean("$inlinedNode", false);
        }

        public void setInlinedNode(boolean b) {
            this.setBoolean("$inlinedNode", b);
        }

        public NodeExecutionMode getMode() {
            return this.mode;
        }

        public void setBoolean(String name, boolean value) {
            this.directValues.put(name, value);
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            Boolean bool = this.directValues.get(name);
            if (bool == null) {
                return defaultValue;
            }
            return bool;
        }

        public boolean isSpecializationClassInitialized(SpecializationData specialization) {
            return this.getBoolean(FrameState.createSpecializationClassInitialized(specialization), false);
        }

        public void setSpecializationClassInitialized(SpecializationData specialization, boolean b) {
            this.setBoolean(FrameState.createSpecializationClassInitialized(specialization), b);
        }

        private static String createSpecializationClassInitialized(SpecializationData specialization) {
            return FlatNodeGenFactory.createSpecializationLocalName(specialization) + "$initialized";
        }

        public static FrameState load(FlatNodeGenFactory factory, ExecutableTypeData type, int varargsThreshold, NodeExecutionMode mode, CodeExecutableElement method) {
            FrameState context = new FrameState(factory, mode, method);
            context.loadEvaluatedValues(type, varargsThreshold);
            return context;
        }

        private void loadEvaluatedValues(ExecutableTypeData executedType, int varargsThreshold) {
            TypeMirror frame = executedType.getFrameParameter();
            if (frame == null) {
                this.removeValue(FlatNodeGenFactory.FRAME_VALUE);
            } else {
                this.set(FlatNodeGenFactory.FRAME_VALUE, new LocalVariable(frame, FlatNodeGenFactory.FRAME_VALUE, null));
            }
            for (NodeFieldData field : this.factory.node.getFields()) {
                String fieldName = FrameState.fieldValueName(field);
                CodeTree lookupValue = this.getMode().isUncached() ? CodeTreeBuilder.createBuilder().defaultValue(field.getType()).build() : CodeTreeBuilder.createBuilder().string("this.", field.getName()).build();
                this.values.put(fieldName, new LocalVariable(field.getType(), fieldName, lookupValue));
            }
            boolean varargs = this.needsVarargs(false, varargsThreshold);
            List<TypeMirror> evaluatedParameter = executedType.getEvaluatedParameters();
            int evaluatedIndex = 0;
            for (int executionIndex = 0; executionIndex < this.factory.node.getExecutionCount(); ++executionIndex) {
                NodeExecutionData execution = this.factory.node.getChildExecutions().get(executionIndex);
                if (evaluatedIndex >= executedType.getEvaluatedCount()) continue;
                TypeMirror evaluatedType = evaluatedParameter.get(evaluatedIndex);
                LocalVariable value = this.createValue(execution, evaluatedType);
                if (varargs) {
                    value = value.accessWith(FrameState.createReadVarargs(evaluatedIndex));
                }
                this.values.put(value.getName(), value.makeOriginal());
                ++evaluatedIndex;
            }
        }

        public static FrameState load(FlatNodeGenFactory factory, NodeExecutionMode mode, CodeExecutableElement method) {
            return FrameState.load(factory, factory.createExecuteAndSpecializeType(), Integer.MAX_VALUE, mode, method);
        }

        public FrameState copy() {
            FrameState copy = new FrameState(this.factory, this.mode, this.method);
            copy.values.putAll(this.values);
            copy.caughtTypes.addAll(this.caughtTypes);
            copy.directValues.putAll(this.directValues);
            return copy;
        }

        private static String fieldValueName(NodeFieldData field) {
            return field.getName() + "Value";
        }

        public LocalVariable createValue(NodeExecutionData execution, TypeMirror type) {
            return new LocalVariable(type, FrameState.valueName(execution), null);
        }

        public static String valueName(NodeExecutionData execution) {
            return execution.getName() + "Value";
        }

        public void set(String id, LocalVariable var) {
            this.values.put(id, var);
        }

        public void clear(String id) {
            this.values.remove(id);
        }

        public void set(NodeExecutionData execution, LocalVariable var) {
            this.set(FrameState.valueName(execution), var);
        }

        public LocalVariable getCacheInitialized(SpecializationData specialization, CacheExpression cache) {
            String name = this.factory.createFieldName(specialization, cache);
            return this.get(name);
        }

        public LocalVariable getCacheClassInitialized(CacheExpression cache) {
            if (cache.getSharedGroup() == null) {
                return null;
            }
            return this.get(this.createCacheClassInitializedKey(cache));
        }

        private String createCacheClassInitializedKey(CacheExpression cache) {
            String name = this.factory.createFieldName(null, cache);
            String key = name + "$wrapper";
            return key;
        }

        public LocalVariable get(String id) {
            return this.values.get(id);
        }

        public LocalVariable getValue(NodeExecutionData execution) {
            return this.get(FrameState.valueName(execution));
        }

        public LocalVariable getValue(int signatureIndex) {
            List<NodeExecutionData> childExecutions = this.factory.node.getChildExecutions();
            if (signatureIndex < childExecutions.size()) {
                return this.getValue(childExecutions.get(signatureIndex));
            }
            return null;
        }

        public void removeValue(String id) {
            this.values.remove(id);
        }

        public void setValue(NodeExecutionData execution, LocalVariable var) {
            this.values.put(FrameState.valueName(execution), var);
        }

        private boolean needsVarargs(boolean requireLoaded, int varArgsThreshold) {
            int size = 0;
            for (NodeExecutionData execution : this.factory.node.getChildExecutions()) {
                if (requireLoaded && this.getValue(execution) == null) continue;
                ++size;
            }
            return size >= varArgsThreshold;
        }

        private static CodeTree createReadVarargs(int i) {
            return CodeTreeBuilder.createBuilder().string("args_[").string(String.valueOf(i)).string("]").build();
        }

        public void addReferencesTo(CodeTreeBuilder builder, String ... optionalNames) {
            for (String string : optionalNames) {
                LocalVariable local = this.values.get(string);
                if (local == null) continue;
                builder.tree(local.createReference());
            }
            List<NodeExecutionData> executions = this.factory.node.getChildExecutions();
            for (NodeExecutionData execution : executions) {
                LocalVariable localVariable = this.getValue(execution);
                if (localVariable == null) continue;
                builder.startGroup().tree(localVariable.createReference()).end();
            }
        }

        public void addParametersTo(CodeExecutableElement targetMethod, int varArgsThreshold, String ... optionalNames) {
            for (String var : optionalNames) {
                LocalVariable local = this.values.get(var);
                if (local == null) continue;
                targetMethod.addParameter(local.createParameter());
            }
            if (this.needsVarargs(true, varArgsThreshold)) {
                targetMethod.addParameter(new CodeVariableElement(this.factory.getType(Object[].class), "args_"));
                targetMethod.setVarArgs(true);
            } else {
                for (NodeExecutionData execution : this.factory.node.getChildExecutions()) {
                    LocalVariable var = this.getValue(execution);
                    if (var == null) continue;
                    targetMethod.addParameter(var.createParameter());
                }
            }
        }

        public String toString() {
            return "LocalContext [values=" + this.values + "]";
        }
    }

    static final class LocalVariable {
        private final TypeMirror typeMirror;
        private final CodeTree accessorTree;
        private final String name;

        LocalVariable(TypeMirror typeMirror, String name, CodeTree accessorTree) {
            Objects.requireNonNull(typeMirror);
            this.typeMirror = typeMirror;
            this.accessorTree = accessorTree;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static String createNextName(String name) {
            return name + FlatNodeGenFactory.NAME_SUFFIX;
        }

        public TypeMirror getTypeMirror() {
            return this.typeMirror;
        }

        public CodeVariableElement createParameter() {
            return new CodeVariableElement(this.getTypeMirror(), this.getName());
        }

        public CodeTree createDeclaration(CodeTree init) {
            return CodeTreeBuilder.createBuilder().declaration(this.getTypeMirror(), this.getName(), init).build();
        }

        public CodeTree createReference() {
            if (this.accessorTree != null) {
                return this.accessorTree;
            }
            return CodeTreeBuilder.singleString(this.getName());
        }

        public LocalVariable newType(TypeMirror newType) {
            return new LocalVariable(newType, this.name, this.accessorTree);
        }

        public LocalVariable accessWith(CodeTree tree) {
            return new LocalVariable(this.typeMirror, this.name, tree);
        }

        public LocalVariable nextName() {
            return new LocalVariable(this.typeMirror, LocalVariable.createNextName(this.name), this.accessorTree);
        }

        public LocalVariable makeOriginal() {
            return new LocalVariable(this.typeMirror, this.name, this.accessorTree);
        }

        public LocalVariable makeGeneric(ProcessorContext context) {
            return this.newType(context.getType(Object.class));
        }

        public String toString() {
            return "Local[type = " + this.getTypeMirror() + ", name = " + this.name + ", accessWith = " + this.accessorTree + "]";
        }
    }

    private static class IfTriple {
        private CodeTree prepare;
        private CodeTree condition;
        private CodeTree statements;

        IfTriple(CodeTree prepare, CodeTree condition, CodeTree statements) {
            this.prepare = prepare;
            this.condition = condition;
            this.statements = statements;
        }

        private boolean canBeMerged(IfTriple triple) {
            boolean prepareSet = !IfTriple.isEmpty(triple.prepare) || !IfTriple.isEmpty(this.prepare);
            boolean conditionSet = !IfTriple.isEmpty(triple.condition) || !IfTriple.isEmpty(this.condition);
            boolean statementsSet = !IfTriple.isEmpty(triple.statements) || !IfTriple.isEmpty(this.statements);
            return conditionSet ^ (prepareSet || statementsSet);
        }

        private static boolean isEmpty(CodeTree e) {
            return e == null || e.isEmpty();
        }

        public String toString() {
            CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
            b.startGroup();
            if (!IfTriple.isEmpty(this.prepare)) {
                b.tree(this.prepare);
            }
            if (!IfTriple.isEmpty(this.condition)) {
                b.startIf().tree(this.condition).end().startBlock();
            }
            if (!IfTriple.isEmpty(this.statements)) {
                b.tree(this.statements);
            }
            if (!IfTriple.isEmpty(this.condition)) {
                b.end();
            }
            b.end();
            return b.build().toString();
        }

        private static IfTriple merge(String conditionSep, Set<IfTriple> triples) {
            if (triples.isEmpty()) {
                throw new AssertionError();
            }
            if (triples.size() == 1) {
                return triples.iterator().next();
            }
            CodeTree[] prepareTrees = new CodeTree[triples.size()];
            CodeTree[] conditionTrees = new CodeTree[triples.size()];
            CodeTree[] statementTrees = new CodeTree[triples.size()];
            int index = 0;
            for (IfTriple triple : triples) {
                prepareTrees[index] = triple.prepare;
                conditionTrees[index] = triple.condition;
                statementTrees[index] = triple.statements;
                ++index;
            }
            return new IfTriple(FlatNodeGenFactory.combineTrees(null, prepareTrees), FlatNodeGenFactory.combineTrees(conditionSep, conditionTrees), FlatNodeGenFactory.combineTrees(null, statementTrees));
        }

        public static List<IfTriple> optimize(List<IfTriple> triples) {
            ArrayList<IfTriple> newTriples = new ArrayList<IfTriple>();
            LinkedHashSet<IfTriple> mergable = new LinkedHashSet<IfTriple>();
            IfTriple prev = null;
            for (IfTriple triple : triples) {
                if (prev != null) {
                    if (prev.canBeMerged(triple)) {
                        mergable.add(triple);
                    } else {
                        newTriples.add(IfTriple.merge(" && ", mergable));
                        mergable.clear();
                    }
                }
                prev = triple;
                mergable.add(prev);
            }
            if (prev != null) {
                newTriples.add(IfTriple.merge(" && ", mergable));
            }
            return newTriples;
        }

        public static BlockState materialize(CodeTreeBuilder builder, Collection<IfTriple> triples, boolean forceNoBlocks) {
            int blockCount = 0;
            int ifCount = 0;
            boolean otherPrepare = false;
            for (IfTriple triple : triples) {
                if (triple.prepare != null && !triple.prepare.isEmpty()) {
                    if (!otherPrepare) {
                        if (blockCount == 0 && !forceNoBlocks) {
                            builder.startBlock();
                            ++blockCount;
                        }
                        otherPrepare = true;
                    }
                    builder.tree(triple.prepare);
                }
                if (triple.condition != null && !triple.condition.isEmpty()) {
                    if (forceNoBlocks) {
                        throw new AssertionError((Object)"no blocks forced but block required");
                    }
                    builder.startIf().tree(triple.condition).end().startBlock();
                    ++blockCount;
                    ++ifCount;
                }
                if (triple.statements == null || triple.statements.isEmpty()) continue;
                builder.tree(triple.statements);
            }
            return BlockState.create(ifCount, blockCount);
        }
    }

    static final class BlockState {
        static final BlockState NONE = new BlockState(0, 0);
        final int ifCount;
        final int blockCount;

        private BlockState(int ifCount, int blockCount) {
            this.ifCount = ifCount;
            this.blockCount = blockCount;
        }

        BlockState add(BlockState state) {
            return new BlockState(this.ifCount + state.ifCount, this.blockCount + state.blockCount);
        }

        BlockState incrementIf() {
            return new BlockState(this.ifCount + 1, this.blockCount + 1);
        }

        static BlockState create(int ifCount, int blockCount) {
            if (ifCount == 0 && blockCount == 0) {
                return NONE;
            }
            return new BlockState(ifCount, blockCount);
        }
    }

    private static class ExecuteDelegationResult {
        public final CodeTree tree;
        public final boolean hasFallthrough;

        ExecuteDelegationResult(CodeTree tree, boolean hasFallthrough) {
            this.tree = tree;
            this.hasFallthrough = hasFallthrough;
        }
    }

    private static class BoxingSplit {
        private final SpecializationGroup group;
        private final TypeMirror[] primitiveSignature;

        BoxingSplit(SpecializationGroup group, TypeMirror[] primitiveSignature) {
            this.group = group;
            this.primitiveSignature = primitiveSignature;
        }

        public String getName() {
            StringBuilder b = new StringBuilder();
            String sep = "";
            for (TypeMirror typeMirror : this.primitiveSignature) {
                b.append(sep).append(ElementUtils.firstLetterLowerCase(ElementUtils.getSimpleName(typeMirror)));
                sep = FlatNodeGenFactory.NAME_SUFFIX;
            }
            return b.toString();
        }
    }

    private static class ChildExecutionResult {
        CodeTree code;
        final boolean throwsUnexpectedResult;

        ChildExecutionResult(CodeTree code, boolean throwsUnexpectedResult) {
            this.code = code;
            this.throwsUnexpectedResult = throwsUnexpectedResult;
        }
    }

    static class SpecializationStateReference {
        final BitSet bitSet;
        final CodeTree reference;

        SpecializationStateReference(BitSet set, CodeTree reference) {
            Objects.requireNonNull(set);
            Objects.requireNonNull(reference);
            this.bitSet = set;
            this.reference = reference;
        }
    }
}

