/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.instrumentation.GenerateWrapper"})
public final class InstrumentableProcessor
extends AbstractProcessor {
    private static final String CLASS_SUFFIX = "Wrapper";
    private static final String EXECUTE_METHOD_PREFIX = "execute";
    private static final String PARAM_YIELD_EXCEPTIONS = "yieldExceptions";
    private static final String PARAM_RESUME_METHOD_PREFIX = "resumeMethodPrefix";
    private static final String CONSTANT_REENTER = "ProbeNode.UNWIND_ACTION_REENTER";
    private static final String METHOD_GET_NODE_COST = "getCost";
    private static final String METHOD_ON_RETURN_EXCEPTIONAL_OR_UNWIND = "onReturnExceptionalOrUnwind";
    private static final String METHOD_ON_RETURN_VALUE = "onReturnValue";
    private static final String METHOD_ON_ENTER = "onEnter";
    private static final String METHOD_ON_YIELD = "onYield";
    private static final String METHOD_ON_RESUME = "onResume";
    private static final String FIELD_DELEGATE = "delegateNode";
    private static final String FIELD_PROBE = "probeNode";
    private static final String VAR_RETURN_CALLED = "wasOnReturnExecuted";
    private static final String CREATE_WRAPPER_NAME = "createWrapper";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        try (ProcessorContext context = ProcessorContext.enter(this.processingEnv);){
            TruffleTypes types = context.getTypes();
            DeclaredType instrumentableNode = types.InstrumentableNode;
            ExecutableElement createWrapper = ElementUtils.findExecutableElement(instrumentableNode, CREATE_WRAPPER_NAME);
            block7: for (Element element : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.GenerateWrapper))) {
                String packageName;
                if (!element.getKind().isClass() && !element.getKind().isInterface() || (packageName = ElementUtils.getPackageName(element)) != null && packageName.equals(ElementUtils.getPackageName(types.GenerateWrapper))) continue;
                try {
                    if (element.getKind() != ElementKind.CLASS) {
                        this.emitError(element, String.format("Only classes can be annotated with %s.", types.GenerateWrapper.asElement().getSimpleName()));
                        continue;
                    }
                    if (createWrapper == null) {
                        this.emitError(element, String.format("Fatal %s.%s not found.", types.InstrumentableNode.asElement().getSimpleName(), CREATE_WRAPPER_NAME));
                        continue;
                    }
                    if (!ElementUtils.isAssignable(element.asType(), instrumentableNode)) {
                        this.emitError(element, String.format("Classes annotated with @%s must implement %s.", types.GenerateWrapper.asElement().getSimpleName(), types.InstrumentableNode.asElement().getSimpleName().toString()));
                        continue;
                    }
                    boolean createWrapperFound = false;
                    for (ExecutableElement declaredMethod : ElementFilter.methodsIn(element.getEnclosedElements())) {
                        if (!ElementUtils.signatureEquals(declaredMethod, createWrapper)) continue;
                        createWrapperFound = true;
                        break;
                    }
                    if (!createWrapperFound) {
                        this.emitError(element, String.format("Classes annotated with @%s must declare/override %s.%s and return a new instance of the generated wrapper class called %s. You may copy the following generated implementation: %n  @Override public %s createWrapper(%s probeNode) {%n    return new %s(this, probeNode);%n  }", types.GenerateWrapper.asElement().getSimpleName(), types.InstrumentableNode.asElement().getSimpleName(), CREATE_WRAPPER_NAME, InstrumentableProcessor.createWrapperClassName((TypeElement)element), types.InstrumentableNode_WrapperNode.asElement().getSimpleName(), types.ProbeNode.asElement().getSimpleName(), InstrumentableProcessor.createWrapperClassName((TypeElement)element)));
                        continue;
                    }
                    if (!ElementUtils.isAssignable(element.asType(), types.Node)) {
                        this.emitError(element, String.format("Classes annotated with @%s must extend %s.", types.GenerateWrapper.asElement().getSimpleName(), types.Node.asElement().getSimpleName()));
                        continue;
                    }
                    AnnotationMirror generateWrapperMirror = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), (TypeMirror)types.GenerateWrapper);
                    if (generateWrapperMirror == null) continue;
                    List<TypeMirror> yieldExceptionMirrors = ElementUtils.getAnnotationValueList(TypeMirror.class, generateWrapperMirror, PARAM_YIELD_EXCEPTIONS);
                    int numExc = yieldExceptionMirrors.size();
                    if (numExc == 0) {
                        yieldExceptions = Collections.emptyList();
                    } else {
                        yieldExceptions = new ArrayList(numExc);
                        TypeMirror throwable = context.getType(Throwable.class);
                        for (int i = 0; i < numExc; ++i) {
                            TypeMirror excMirror = yieldExceptionMirrors.get(i);
                            Element excElement = context.getEnvironment().getTypeUtils().asElement(excMirror);
                            if (!context.getEnvironment().getTypeUtils().isAssignable(excMirror, throwable)) {
                                this.emitError(element, String.format("%s in `yieldExceptions` must extend %s.", excElement.getSimpleName(), Throwable.class.getName()));
                                continue block7;
                            }
                            if (!context.getEnvironment().getTypeUtils().isAssignable(excMirror, types.GenerateWrapper_YieldException)) {
                                this.emitError(element, String.format("%s in `yieldExceptions` must implement %s.", excElement.getSimpleName(), "com.oracle.truffle.api.instrumentation.GenerateWrapper.YieldException"));
                                continue block7;
                            }
                            yieldExceptions.add(((TypeElement)excElement).getQualifiedName());
                        }
                    }
                    AnnotationValue resumeMethodPrefixValue = ElementUtils.getAnnotationValue(generateWrapperMirror, PARAM_RESUME_METHOD_PREFIX);
                    String resumeMethodPrefix = resumeMethodPrefixValue != null ? (String)resumeMethodPrefixValue.getValue() : null;
                    CodeTypeElement unit = this.generateWrapperOnly(context, element, yieldExceptionMirrors, resumeMethodPrefix);
                    if (unit == null) continue;
                    DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
                    unit.accept(new GenerateOverrideVisitor(overrideType), null);
                    unit.accept(new FixWarningsVisitor(overrideType), null);
                    unit.accept(new CodeWriter(context.getEnvironment(), element), null);
                }
                catch (Throwable e) {
                    this.handleThrowable(e, element);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private void handleThrowable(Throwable t, Element e) {
        String message = "Uncaught error in " + this.getClass().getSimpleName() + " while processing " + String.valueOf(e) + " ";
        ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(t), e);
    }

    private CodeTypeElement generateWrapperOnly(ProcessorContext context, Element e, List<TypeMirror> yieldExceptions, String resumeMethodPrefix) {
        CodeTypeElement wrapper = this.generateWrapper(context, e, true, yieldExceptions, resumeMethodPrefix);
        if (wrapper == null) {
            return null;
        }
        InstrumentableProcessor.assertNoErrorExpected(e);
        return wrapper;
    }

    private static String createWrapperClassName(TypeElement sourceType) {
        return sourceType.getSimpleName().toString() + CLASS_SUFFIX;
    }

    private static boolean hasUnexpectedResult(ProcessorContext context, ExecutableElement element) {
        DeclaredType unexpectedResult = context.getTypes().UnexpectedResultException;
        for (TypeMirror typeMirror : element.getThrownTypes()) {
            if (!ElementUtils.typeEquals(typeMirror, unexpectedResult)) continue;
            return true;
        }
        return false;
    }

    private CodeTypeElement generateWrapper(ProcessorContext context, Element e, boolean topLevelClass, List<TypeMirror> yieldExceptions, String resumeMethodPrefix) {
        CodeExecutableElement wrappedExecute;
        Set<Modifier> typeModifiers;
        VariableElement firstParameter;
        if (!e.getKind().isClass()) {
            return null;
        }
        if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.emitError(e, "Class must not be private to generate a wrapper.");
            return null;
        }
        if (e.getModifiers().contains((Object)Modifier.FINAL)) {
            this.emitError(e, "Class must not be final to generate a wrapper.");
            return null;
        }
        if (e.getEnclosingElement().getKind() != ElementKind.PACKAGE && !e.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitError(e, "Inner class must be static to generate a wrapper.");
            return null;
        }
        TruffleTypes types = context.getTypes();
        TypeElement sourceType = (TypeElement)e;
        ExecutableElement constructor = null;
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(e.getEnclosedElements());
        if (constructors.isEmpty()) {
            constructors.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), null, e.getSimpleName().toString(), new CodeVariableElement[0]));
        }
        Iterator<ExecutableElement> iterator = constructors.listIterator();
        while (iterator.hasNext()) {
            ExecutableElement c = iterator.next();
            Modifier modifier = ElementUtils.getVisibility(c.getModifiers());
            if (modifier == Modifier.PRIVATE) {
                iterator.remove();
                continue;
            }
            if (!c.getParameters().isEmpty()) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            for (ExecutableElement c : constructors) {
                firstParameter = c.getParameters().iterator().next();
                if (!ElementUtils.typeEquals(firstParameter.asType(), sourceType.asType())) continue;
                constructor = c;
                break;
            }
        }
        if (constructor == null) {
            for (ExecutableElement c : constructors) {
                firstParameter = c.getParameters().iterator().next();
                if (!ElementUtils.typeEquals(firstParameter.asType(), types.SourceSection)) continue;
                constructor = c;
                break;
            }
        }
        if (constructor == null) {
            this.emitError(sourceType, "No suiteable constructor found for wrapper factory generation. At least one default or copy constructor must be visible.");
            return null;
        }
        PackageElement pack = context.getEnvironment().getElementUtils().getPackageOf(sourceType);
        Object wrapperClassName = InstrumentableProcessor.createWrapperClassName(sourceType);
        if (topLevelClass) {
            typeModifiers = ElementUtils.modifiers(Modifier.FINAL);
        } else {
            typeModifiers = ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL);
            wrapperClassName = (String)wrapperClassName + "0";
        }
        CodeTypeElement wrapperType = new CodeTypeElement(typeModifiers, ElementKind.CLASS, pack, (String)wrapperClassName);
        TypeMirror resolvedSuperType = sourceType.asType();
        wrapperType.setSuperClass(resolvedSuperType);
        wrapperType.getImplements().add(types.InstrumentableNode_WrapperNode);
        GeneratorUtils.addGeneratedBy(context, wrapperType, sourceType);
        wrapperType.add(InstrumentableProcessor.createNodeChild(context, sourceType.asType(), FIELD_DELEGATE));
        wrapperType.add(InstrumentableProcessor.createNodeChild(context, types.ProbeNode, FIELD_PROBE));
        Set<Modifier> constructorModifiers = topLevelClass ? ElementUtils.modifiers(new Modifier[0]) : ElementUtils.modifiers(Modifier.PRIVATE);
        CodeExecutableElement wrappedConstructor = GeneratorUtils.createConstructorUsingFields(constructorModifiers, wrapperType, constructor);
        wrapperType.add(wrappedConstructor);
        for (VariableElement field : wrapperType.getFields()) {
            CodeExecutableElement getter = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), field.asType(), "get" + ElementUtils.firstLetterUpperCase(field.getSimpleName().toString()), new CodeVariableElement[0]);
            getter.createBuilder().startReturn().string(field.getSimpleName().toString()).end();
            wrapperType.add(getter);
        }
        boolean isResume = resumeMethodPrefix != null && !resumeMethodPrefix.isEmpty();
        ArrayList<ExecutableElement> wrappedMethods = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> wrappedExecuteMethods = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> wrappedResumeMethods = isResume ? new ArrayList<ExecutableElement>() : Collections.emptyList();
        List<? extends Element> elementList = CompilerFactory.getCompiler(sourceType).getAllMembersInDeclarationOrder(context.getEnvironment(), sourceType);
        ExecutableElement genericExecuteDelegate = null;
        ExecutableElement genericResumeDelegate = null;
        for (ExecutableElement method : ElementFilter.methodsIn(elementList)) {
            if (!InstrumentableProcessor.isOverridable(method)) continue;
            if (InstrumentableProcessor.hasMethodPrefix(method, types, EXECUTE_METHOD_PREFIX)) {
                if (topLevelClass && !this.testFirstParamIsVirtualFrame(e, types, method)) {
                    return null;
                }
                if (ElementUtils.isObject(method.getReturnType()) && method.getParameters().size() == 1 && genericExecuteDelegate == null) {
                    genericExecuteDelegate = method;
                }
                wrappedExecuteMethods.add(method);
                continue;
            }
            if (isResume && InstrumentableProcessor.hasMethodPrefix(method, types, resumeMethodPrefix)) {
                if (topLevelClass && !this.testFirstParamIsVirtualFrame(e, types, method)) {
                    return null;
                }
                if (ElementUtils.isObject(method.getReturnType()) && method.getParameters().size() == 1 && genericResumeDelegate == null) {
                    genericResumeDelegate = method;
                }
                wrappedResumeMethods.add(method);
                continue;
            }
            String methodName = method.getSimpleName().toString();
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT) || methodName.equals(METHOD_GET_NODE_COST) || InstrumentableProcessor.hasUnexpectedResult(context, method)) continue;
            wrappedMethods.add(method);
        }
        ExecutableElement incomingConverterMethod = null;
        ExecutableElement outgoingConverterMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(elementList)) {
            AnnotationMirror incomingConverter = ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)types.GenerateWrapper_IncomingConverter);
            AnnotationMirror outgoingConverter = ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)types.GenerateWrapper_OutgoingConverter);
            if (incomingConverter != null) {
                if (incomingConverterMethod != null) {
                    this.emitError(sourceType, String.format("Only one @%s method allowed, found multiple.", types.GenerateWrapper_IncomingConverter.asElement().getSimpleName()));
                    return null;
                }
                if (!this.verifyConverter(method, types.GenerateWrapper_IncomingConverter)) continue;
                incomingConverterMethod = method;
            }
            if (outgoingConverter == null) continue;
            if (outgoingConverterMethod != null) {
                this.emitError(sourceType, String.format("Only one @%s method allowed, found multiple.", types.GenerateWrapper_OutgoingConverter.asElement().getSimpleName()));
                return null;
            }
            if (!this.verifyConverter(method, types.GenerateWrapper_OutgoingConverter)) continue;
            outgoingConverterMethod = method;
        }
        if (wrappedExecuteMethods.isEmpty() && wrappedResumeMethods.isEmpty()) {
            if (isResume) {
                this.emitError(sourceType, String.format("No methods starting with name %s or %s found to wrap.", EXECUTE_METHOD_PREFIX, resumeMethodPrefix));
            } else {
                this.emitError(sourceType, String.format("No methods starting with name %s found to wrap.", EXECUTE_METHOD_PREFIX));
            }
            return null;
        }
        Comparator<ExecutableElement> methodComparator = new Comparator<ExecutableElement>(){

            @Override
            public int compare(ExecutableElement o1, ExecutableElement o2) {
                return ElementUtils.compareMethod(o1, o2);
            }
        };
        Collections.sort(wrappedExecuteMethods, methodComparator);
        for (ExecutableElement method : wrappedExecuteMethods) {
            wrappedExecute = InstrumentableProcessor.wrapExecutable(method, false, genericExecuteDelegate, context, yieldExceptions, incomingConverterMethod, outgoingConverterMethod);
            wrapperType.add(wrappedExecute);
        }
        Collections.sort(wrappedResumeMethods, methodComparator);
        for (ExecutableElement method : wrappedResumeMethods) {
            wrappedExecute = InstrumentableProcessor.wrapExecutable(method, true, genericResumeDelegate, context, yieldExceptions, incomingConverterMethod, outgoingConverterMethod);
            wrapperType.add(wrappedExecute);
        }
        for (ExecutableElement delegateMethod : wrappedMethods) {
            CodeExecutableElement generatedMethod = CodeExecutableElement.clone(delegateMethod);
            generatedMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
            generatedMethod.getModifiers().remove((Object)Modifier.DEFAULT);
            CodeTreeBuilder callDelegate = generatedMethod.createBuilder();
            if (ElementUtils.isVoid(delegateMethod.getReturnType())) {
                callDelegate.startStatement();
            } else {
                callDelegate.startReturn();
            }
            callDelegate.startCall("this.delegateNode", generatedMethod.getSimpleName().toString());
            for (VariableElement parameter : generatedMethod.getParameters()) {
                callDelegate.string(parameter.getSimpleName().toString());
            }
            callDelegate.end().end();
            wrapperType.add(generatedMethod);
        }
        return wrapperType;
    }

    private boolean testFirstParamIsVirtualFrame(Element e, TruffleTypes types, ExecutableElement method) {
        VariableElement firstParam;
        VariableElement variableElement = firstParam = method.getParameters().isEmpty() ? null : method.getParameters().get(0);
        if (firstParam == null || !ElementUtils.isAssignable(firstParam.asType(), types.VirtualFrame)) {
            this.emitError(e, String.format("Wrapped method %s must have VirtualFrame as first parameter.", method.getSimpleName()));
            return false;
        }
        return true;
    }

    private static CodeExecutableElement wrapExecutable(ExecutableElement method, boolean isResume, ExecutableElement genericExecuteDelegate, ProcessorContext context, List<TypeMirror> yieldExceptions, ExecutableElement incomingConverterMethod, ExecutableElement outgoingConverterMethod) {
        String returnName;
        ExecutableElement executeMethod = method;
        CodeExecutableElement wrappedExecute = CodeExecutableElement.clone(executeMethod);
        wrappedExecute.getModifiers().remove((Object)Modifier.ABSTRACT);
        wrappedExecute.getModifiers().remove((Object)Modifier.DEFAULT);
        wrappedExecute.getAnnotationMirrors().clear();
        TruffleTypes types = context.getTypes();
        String frameParameterName = "null";
        for (VariableElement parameter : wrappedExecute.getParameters()) {
            if (!ElementUtils.typeEquals(types.VirtualFrame, parameter.asType())) continue;
            frameParameterName = parameter.getSimpleName().toString();
            break;
        }
        CodeTreeBuilder builder = wrappedExecute.createBuilder();
        TypeMirror returnTypeMirror = executeMethod.getReturnType();
        boolean executeReturnsVoid = ElementUtils.isVoid(returnTypeMirror);
        if (executeReturnsVoid && genericExecuteDelegate != null && executeMethod.getParameters().size() == genericExecuteDelegate.getParameters().size()) {
            executeMethod = genericExecuteDelegate;
            returnTypeMirror = genericExecuteDelegate.getReturnType();
            executeReturnsVoid = false;
        }
        if (!executeReturnsVoid) {
            returnName = "returnValue";
            builder.declaration(returnTypeMirror, returnName, (CodeTree)null);
        } else {
            returnName = "null";
        }
        builder.startFor().startGroup().string(";;").end().end().startBlock();
        builder.declaration("boolean", VAR_RETURN_CALLED, "false");
        builder.startTryBlock();
        boolean hasUnexpectedResult = InstrumentableProcessor.hasUnexpectedResult(context, wrappedExecute);
        if (hasUnexpectedResult) {
            builder.startTryBlock();
        }
        if (isResume) {
            builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_RESUME).string(frameParameterName).end().end();
        } else {
            builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_ENTER).string(frameParameterName).end().end();
        }
        CodeTreeBuilder callDelegate = builder.create();
        callDelegate.startCall(FIELD_DELEGATE, executeMethod.getSimpleName().toString());
        for (VariableElement parameter : wrappedExecute.getParameters()) {
            callDelegate.string(parameter.getSimpleName().toString());
        }
        callDelegate.end();
        if (executeReturnsVoid) {
            builder.statement(callDelegate.build());
        } else {
            builder.startStatement().string(returnName).string(" = ").tree(callDelegate.build()).end();
        }
        builder.startStatement().string(VAR_RETURN_CALLED).string(" = true").end();
        builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_RETURN_VALUE).string(frameParameterName);
        if (outgoingConverterMethod == null || executeReturnsVoid) {
            builder.string(returnName);
        } else {
            builder.tree(InstrumentableProcessor.createCallConverter(outgoingConverterMethod, frameParameterName, CodeTreeBuilder.singleString(returnName)));
        }
        builder.end().end();
        builder.statement("break");
        if (hasUnexpectedResult) {
            builder.end().startCatchBlock(types.UnexpectedResultException, "e");
            builder.startStatement().string(VAR_RETURN_CALLED).string(" = true").end();
            builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_RETURN_VALUE).string(frameParameterName);
            if (outgoingConverterMethod == null || executeReturnsVoid) {
                builder.string("e.getResult()");
            } else {
                builder.tree(InstrumentableProcessor.createCallConverter(outgoingConverterMethod, frameParameterName, CodeTreeBuilder.singleString("e.getResult()")));
            }
            builder.end().end();
            builder.startThrow().string("e").end().end();
        }
        for (TypeMirror yieldException : yieldExceptions) {
            builder.end().startCatchBlock(yieldException, "e");
            builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_YIELD).string(frameParameterName).string("e.getYieldValue()");
            builder.end().end();
            builder.startThrow().string("e").end();
        }
        builder.end().startCatchBlock(context.getType(Throwable.class), "t");
        CodeTreeBuilder callExOrUnwind = builder.create();
        callExOrUnwind.startCall(FIELD_PROBE, METHOD_ON_RETURN_EXCEPTIONAL_OR_UNWIND).string(frameParameterName).string("t").string(VAR_RETURN_CALLED).end();
        builder.declaration("Object", "result", callExOrUnwind.build());
        builder.startIf().string("result == ").string(CONSTANT_REENTER).end();
        builder.startBlock();
        builder.statement("continue");
        if (ElementUtils.isVoid(wrappedExecute.getReturnType())) {
            builder.end().startElseIf();
            builder.string("result != null").end();
            builder.startBlock();
            builder.statement("break");
        } else {
            boolean objectReturnType = "java.lang.Object".equals(ElementUtils.getQualifiedName(returnTypeMirror)) && returnTypeMirror.getKind() != TypeKind.ARRAY;
            boolean throwsUnexpectedResult = InstrumentableProcessor.hasUnexpectedResult(context, wrappedExecute);
            if (objectReturnType || !throwsUnexpectedResult) {
                builder.end().startElseIf();
                builder.string("result != null").end();
                builder.startBlock();
                builder.startStatement().string(returnName).string(" = ");
                if (!objectReturnType) {
                    builder.string("(").string(ElementUtils.getSimpleName(returnTypeMirror)).string(") ");
                }
                if (incomingConverterMethod == null) {
                    builder.string("result");
                } else {
                    builder.tree(InstrumentableProcessor.createCallConverter(incomingConverterMethod, frameParameterName, CodeTreeBuilder.singleString("result")));
                }
                builder.end();
                builder.statement("break");
            } else {
                builder.end();
                if (incomingConverterMethod != null) {
                    builder.startIf().string("result != null").end().startBlock();
                    builder.startStatement();
                    builder.string("result = ");
                    builder.tree(InstrumentableProcessor.createCallConverter(incomingConverterMethod, frameParameterName, CodeTreeBuilder.singleString("result")));
                    builder.end();
                    builder.end();
                }
                builder.startIf();
                builder.string("result").instanceOf(InstrumentableProcessor.boxed(returnTypeMirror, context.getEnvironment().getTypeUtils())).end();
                builder.startBlock();
                builder.startStatement().string(returnName).string(" = ");
                builder.string("(").string(ElementUtils.getSimpleName(returnTypeMirror)).string(") ");
                builder.string("result");
                builder.end();
                builder.statement("break");
                builder.end();
                builder.startElseIf().string("result != null").end();
                builder.startBlock();
                builder.startThrow().startNew(types.UnexpectedResultException);
                builder.string("result");
                builder.end().end();
            }
        }
        builder.end();
        builder.startThrow().string("t").end();
        builder.end(2);
        if (!ElementUtils.isVoid(wrappedExecute.getReturnType())) {
            builder.startReturn().string(returnName).end();
        }
        return wrappedExecute;
    }

    private static boolean hasMethodPrefix(ExecutableElement method, TruffleTypes types, String prefix) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith(prefix) && !InstrumentableProcessor.isIgnored(method, types);
    }

    private static boolean isIgnored(ExecutableElement method, TruffleTypes types) {
        return ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)types.GenerateWrapper_Ignore) != null;
    }

    private static boolean isOverridable(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            return false;
        }
        Modifier visibility = ElementUtils.getVisibility(modifiers);
        return visibility != Modifier.PRIVATE;
    }

    private static CodeTree createCallConverter(ExecutableElement converterMethod, String frameParameterName, CodeTree returnName) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        if (converterMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            builder.startStaticCall(converterMethod);
        } else {
            builder.startCall("this.delegateNode", converterMethod.getSimpleName().toString());
        }
        if (converterMethod.getParameters().size() == 1) {
            builder.tree(returnName);
        } else {
            if (converterMethod.getParameters().size() != 2) {
                throw new AssertionError();
            }
            builder.string(frameParameterName);
            builder.tree(returnName);
        }
        builder.end();
        return builder.build();
    }

    private boolean verifyConverter(ExecutableElement method, DeclaredType annotationClass) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.emitError(method, String.format("Method annotated with @%s must not be private.", ElementUtils.getSimpleName(annotationClass)));
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.emitError(method, String.format("Method annotated with @%s must not be abstract.", ElementUtils.getSimpleName(annotationClass)));
            return false;
        }
        ProcessorContext context = ProcessorContext.getInstance();
        DeclaredType frameClass = context.getTypes().VirtualFrame;
        DeclaredType objectClass = context.getDeclaredType(Object.class);
        boolean valid = true;
        if (method.getParameters().size() == 1) {
            TypeMirror firstType = method.getParameters().get(0).asType();
            if (!ElementUtils.typeEquals(firstType, objectClass)) {
                valid = false;
            }
        } else if (method.getParameters().size() == 2) {
            TypeMirror secondType;
            TypeMirror firstType = method.getParameters().get(0).asType();
            if (!ElementUtils.typeEquals(firstType, frameClass)) {
                valid = false;
            }
            if (!ElementUtils.typeEquals(secondType = method.getParameters().get(1).asType(), objectClass)) {
                valid = false;
            }
        } else {
            valid = false;
        }
        if (!ElementUtils.typeEquals(method.getReturnType(), objectClass)) {
            valid = false;
        }
        if (!valid) {
            this.emitError(method, String.format("Invalid @%s method signature. Must be either Object converter(Object) or Object converter(%s, Object)", ElementUtils.getSimpleName(annotationClass), context.getTypes().VirtualFrame.asElement().getSimpleName()));
            return false;
        }
        return true;
    }

    private static TypeMirror boxed(TypeMirror type, Types types) {
        if (type.getKind().isPrimitive()) {
            return types.boxedClass((PrimitiveType)type).asType();
        }
        return type;
    }

    private static CodeVariableElement createNodeChild(ProcessorContext context, TypeMirror type, String name) {
        CodeVariableElement var = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), type, name);
        var.addAnnotationMirror(new CodeAnnotationMirror(context.getTypes().Node_Child));
        return var;
    }

    static void assertNoErrorExpected(Element e) {
        ExpectError.assertNoErrorExpected(e);
    }

    void emitError(Element e, String msg) {
        if (ExpectError.isExpectedError(e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    void emitError(Element e, AnnotationMirror annotation, String msg) {
        if (ExpectError.isExpectedError(e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e, annotation);
    }
}

