/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.expression;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleSuppressedWarnings;
import com.oracle.truffle.dsl.processor.expression.DSLExpressionResolver;
import com.oracle.truffle.dsl.processor.expression.ExpressionLexer;
import com.oracle.truffle.dsl.processor.expression.ExpressionParser;
import com.oracle.truffle.dsl.processor.expression.InvalidExpressionException;
import com.oracle.truffle.dsl.processor.generator.DSLExpressionGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public abstract class DSLExpression {
    private TypeMirror resolvedTargetType;

    private DSLExpression() {
    }

    public List<DSLExpression> flatten() {
        final ArrayList<DSLExpression> expressions = new ArrayList<DSLExpression>();
        this.accept(new DSLExpressionVisitor(){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitVariable(Variable binary) {
                expressions.add(binary);
            }

            @Override
            public void visitNegate(Negate negate) {
                expressions.add(negate);
            }

            @Override
            public void visitIntLiteral(IntLiteral binary) {
                expressions.add(binary);
            }

            @Override
            public void visitClassLiteral(ClassLiteral classLiteral) {
                expressions.add(classLiteral);
            }

            @Override
            public void visitCall(Call binary) {
                expressions.add(binary);
            }

            @Override
            public void visitBooleanLiteral(BooleanLiteral binary) {
                expressions.add(binary);
            }

            @Override
            public void visitBinary(Binary binary) {
                expressions.add(binary);
            }

            @Override
            public void visitCast(Cast cast) {
                expressions.add(cast);
            }
        });
        return expressions;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean mayAllocate() {
        final AtomicBoolean mayAllocate = new AtomicBoolean(false);
        this.accept(new AbstractDSLExpressionVisitor(this){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitCall(Call binary) {
                mayAllocate.set(true);
            }
        });
        return mayAllocate.get();
    }

    public boolean isNodeReceiverBound() {
        final AtomicBoolean bindsReceiver = new AtomicBoolean(false);
        this.accept(new AbstractDSLExpressionVisitor(this){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitVariable(Variable var) {
                String name;
                VariableElement resolvedVar;
                if (!(var.getReceiver() != null || (resolvedVar = var.getResolvedVariable()) == null || resolvedVar.getModifiers().contains((Object)Modifier.STATIC) || resolvedVar.getEnclosingElement() != null && resolvedVar.getEnclosingElement().getKind() == ElementKind.METHOD || (name = resolvedVar.getSimpleName().toString()).equals("null"))) {
                    bindsReceiver.set(true);
                }
            }

            @Override
            public void visitCall(Call binary) {
                ExecutableElement method;
                if (binary.getReceiver() == null && (method = binary.getResolvedMethod()) != null && method.getKind() != ElementKind.CONSTRUCTOR && !method.getModifiers().contains((Object)Modifier.STATIC)) {
                    bindsReceiver.set(true);
                }
            }
        });
        return bindsReceiver.get();
    }

    public boolean isNodeReceiverImplicitlyBound() {
        final AtomicBoolean bindsReceiver = new AtomicBoolean(false);
        this.accept(new AbstractDSLExpressionVisitor(this){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitVariable(Variable var) {
                String name;
                VariableElement resolvedVar;
                if (!(var.getReceiver() != null || (resolvedVar = var.getResolvedVariable()) == null || resolvedVar.getModifiers().contains((Object)Modifier.STATIC) || resolvedVar.getEnclosingElement() != null && resolvedVar.getEnclosingElement().getKind() == ElementKind.METHOD || (name = resolvedVar.getSimpleName().toString()).equals("null") || name.equals("this") || name.equals("$node"))) {
                    bindsReceiver.set(true);
                }
            }

            @Override
            public void visitCall(Call binary) {
                ExecutableElement method;
                if (binary.getReceiver() == null && (method = binary.getResolvedMethod()) != null && method.getKind() != ElementKind.CONSTRUCTOR && !method.getModifiers().contains((Object)Modifier.STATIC)) {
                    bindsReceiver.set(true);
                }
            }
        });
        return bindsReceiver.get();
    }

    public static DSLExpression resolve(DSLExpressionResolver resolver, MessageContainer container, String annotationValueName, DSLExpression expression, String originalString) {
        try {
            expression.accept(resolver);
            List<Element> deprecatedElements = expression.findBoundDeprecatedElements();
            if (!deprecatedElements.isEmpty() && !TruffleSuppressedWarnings.isSuppressed(container.getMessageElement(), "deprecated")) {
                AnnotationMirror mirror = container.getMessageAnnotation();
                AnnotationValue value = null;
                if (mirror != null && annotationValueName != null) {
                    value = ElementUtils.getAnnotationValue(mirror, annotationValueName);
                }
                StringBuilder b = new StringBuilder();
                b.append(String.format("The expression '%s' binds the following deprecated elements and should be updated:", originalString));
                for (Element deprecatedElement : deprecatedElements) {
                    String relativeName = ElementUtils.getReadableReference(container.getMessageElement(), deprecatedElement);
                    b.append(String.format("%n  - ", new Object[0]));
                    b.append(relativeName);
                }
                b.append(String.format("%nUpdate the usage of the elements or suppress the warning with @SuppressWarnings(\"deprecated\").", new Object[0]));
                container.addWarning(value, b.toString(), new Object[0]);
            }
            return expression;
        }
        catch (InvalidExpressionException e) {
            AnnotationMirror mirror = container.getMessageAnnotation();
            AnnotationValue value = null;
            if (mirror != null && annotationValueName != null) {
                value = ElementUtils.getAnnotationValue(mirror, annotationValueName);
            }
            container.addError(value, "Error parsing expression '%s': %s", originalString, e.getMessage());
            return null;
        }
    }

    public static DSLExpression parseAndResolve(DSLExpressionResolver resolver, MessageContainer container, String annotationValueName, String string) {
        DSLExpression expression = DSLExpression.parse(container, annotationValueName, string);
        if (expression == null) {
            return null;
        }
        return DSLExpression.resolve(resolver, container, annotationValueName, expression, string);
    }

    public static DSLExpression parse(MessageContainer container, String annotationValueName, String input) {
        ExpressionLexer lexer = new ExpressionLexer(CharStreams.fromString(input));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ExpressionParser parser = new ExpressionParser(tokens);
        parser.setBuildParseTree(false);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(DSLErrorListener.INSTANCE);
        parser.addErrorListener(DSLErrorListener.INSTANCE);
        try {
            return parser.expression().result;
        }
        catch (InvalidExpressionException | RecognitionException e) {
            AnnotationMirror mirror = container.getMessageAnnotation();
            AnnotationValue value = null;
            if (mirror != null && annotationValueName != null) {
                value = ElementUtils.getAnnotationValue(mirror, annotationValueName);
            }
            container.addError(value, "Error parsing expression '%s': %s", input, e.getMessage());
            return null;
        }
    }

    public final Set<ExecutableElement> findBoundExecutableElements() {
        final HashSet<ExecutableElement> methods = new HashSet<ExecutableElement>();
        this.accept(new AbstractDSLExpressionVisitor(this){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitCall(Call binary) {
                if (binary.getResolvedMethod() != null) {
                    methods.add(binary.getResolvedMethod());
                }
            }
        });
        return methods;
    }

    public final Set<VariableElement> findBoundVariableElements() {
        final HashSet<VariableElement> variables = new HashSet<VariableElement>();
        this.accept(new AbstractDSLExpressionVisitor(this){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitVariable(Variable variable) {
                if (variable.getReceiver() == null) {
                    variables.add(variable.getResolvedVariable());
                }
            }
        });
        return variables;
    }

    public final Set<Variable> findBoundVariables() {
        final HashSet<Variable> variables = new HashSet<Variable>();
        this.accept(new AbstractDSLExpressionVisitor(this){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitVariable(Variable variable) {
                if (variable.getReceiver() == null) {
                    variables.add(variable);
                }
            }
        });
        return variables;
    }

    private List<Element> findBoundDeprecatedElements() {
        final ArrayList<Element> deprecatedElements = new ArrayList<Element>();
        this.accept(new AbstractDSLExpressionVisitor(this){
            final /* synthetic */ DSLExpression this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitCall(Call n) {
                this.visitElement(n.getResolvedMethod());
            }

            @Override
            public void visitVariable(Variable n) {
                this.visitElement(n.getResolvedVariable());
            }

            @Override
            public void visitClassLiteral(ClassLiteral n) {
                this.visitElement(ElementUtils.castTypeElement(n.getLiteral()));
            }

            @Override
            public void visitCast(Cast n) {
                this.visitElement(ElementUtils.castTypeElement(n.getCastType()));
            }

            private void visitElement(Element element) {
                if (element != null && ElementUtils.isDeprecated(element)) {
                    deprecatedElements.add(element);
                }
            }
        });
        return deprecatedElements;
    }

    public Object resolveConstant() {
        return null;
    }

    public ExecutableElement resolveExecutable() {
        return null;
    }

    public VariableElement resolveVariable() {
        return null;
    }

    public void setResolvedTargetType(TypeMirror resolvedTargetType) {
        this.resolvedTargetType = resolvedTargetType;
    }

    public TypeMirror getResolvedTargetType() {
        return this.resolvedTargetType;
    }

    public String asString() {
        CodeTree tree = DSLExpressionGenerator.write(this, null, new HashMap<Variable, CodeTree>());
        return tree.toString();
    }

    public abstract TypeMirror getResolvedType();

    public abstract void accept(DSLExpressionVisitor var1);

    public abstract DSLExpression reduce(DSLExpressionReducer var1);

    private DSLExpression reduceImpl(DSLExpressionReducer reducer) {
        DSLExpression expression = this.reduce(reducer);
        if (expression == null) {
            return this;
        }
        return expression;
    }

    public static interface DSLExpressionVisitor {
        public void visitBinary(Binary var1);

        public void visitClassLiteral(ClassLiteral var1);

        public void visitNegate(Negate var1);

        public void visitCall(Call var1);

        public void visitVariable(Variable var1);

        public void visitIntLiteral(IntLiteral var1);

        public void visitBooleanLiteral(BooleanLiteral var1);

        public void visitCast(Cast var1);
    }

    private static final class DSLErrorListener
    extends BaseErrorListener {
        static final DSLErrorListener INSTANCE = new DSLErrorListener();

        private DSLErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new InvalidExpressionException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }

    public static interface DSLExpressionReducer {
        public DSLExpression visitBinary(Binary var1);

        public DSLExpression visitNegate(Negate var1);

        public DSLExpression visitCall(Call var1);

        public DSLExpression visitVariable(Variable var1);
    }

    public static abstract class AbstractDSLExpressionReducer
    implements DSLExpressionReducer {
        @Override
        public DSLExpression visitBinary(Binary binary) {
            return binary;
        }

        @Override
        public DSLExpression visitCall(Call binary) {
            return binary;
        }

        @Override
        public DSLExpression visitNegate(Negate negate) {
            return negate;
        }

        @Override
        public DSLExpression visitVariable(Variable binary) {
            return binary;
        }
    }

    public static abstract class AbstractDSLExpressionVisitor
    implements DSLExpressionVisitor {
        @Override
        public void visitBinary(Binary n) {
        }

        @Override
        public void visitCall(Call n) {
        }

        @Override
        public void visitIntLiteral(IntLiteral n) {
        }

        @Override
        public void visitClassLiteral(ClassLiteral n) {
        }

        @Override
        public void visitNegate(Negate n) {
        }

        @Override
        public void visitVariable(Variable n) {
        }

        @Override
        public void visitBooleanLiteral(BooleanLiteral n) {
        }

        @Override
        public void visitCast(Cast n) {
        }
    }

    public static final class BooleanLiteral
    extends DSLExpression {
        private final boolean literal;
        private TypeMirror resolvedType;

        public BooleanLiteral(boolean literal) {
            this.literal = literal;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BooleanLiteral) {
                BooleanLiteral other = (BooleanLiteral)obj;
                return this.literal == other.literal;
            }
            return false;
        }

        @Override
        public Object resolveConstant() {
            return this.literal;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.literal);
        }

        public boolean getLiteral() {
            return this.literal;
        }

        @Override
        public TypeMirror getResolvedType() {
            return this.resolvedType;
        }

        public void setResolvedType(TypeMirror resolvedType) {
            this.resolvedType = resolvedType;
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            visitor.visitBooleanLiteral(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer reducer) {
            return this;
        }

        public String toString() {
            return "BooleanLiteral [literal=" + this.literal + ", resolvedType=" + String.valueOf(this.resolvedType) + "]";
        }
    }

    public static final class IntLiteral
    extends DSLExpression {
        private final String literal;
        private int resolvedValueInt;
        private TypeMirror resolvedType;

        public IntLiteral(String literal) {
            this.literal = literal;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IntLiteral) {
                IntLiteral other = (IntLiteral)obj;
                return this.resolvedValueInt == other.resolvedValueInt;
            }
            return false;
        }

        @Override
        public Object resolveConstant() {
            return this.resolvedValueInt;
        }

        @Override
        public int hashCode() {
            return this.resolvedValueInt;
        }

        public String getLiteral() {
            return this.literal;
        }

        public int getResolvedValueInt() {
            return this.resolvedValueInt;
        }

        public void setResolvedValueInt(int resolved) {
            this.resolvedValueInt = resolved;
        }

        @Override
        public TypeMirror getResolvedType() {
            return this.resolvedType;
        }

        public void setResolvedType(TypeMirror resolvedType) {
            this.resolvedType = resolvedType;
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            visitor.visitIntLiteral(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer reducer) {
            return this;
        }

        public String toString() {
            return "IntLiteral [literal=" + this.literal + ", resolvedValueInt=" + this.resolvedValueInt + ", resolvedType=" + String.valueOf(this.resolvedType) + "]";
        }
    }

    public static final class Variable
    extends DSLExpression {
        private final DSLExpression receiver;
        private final String name;
        private VariableElement resolvedVariable;

        public Variable(DSLExpression receiver, String name) {
            this.receiver = receiver;
            this.name = name;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Variable) {
                Variable other = (Variable)obj;
                return ElementUtils.variableEquals(this.resolvedVariable, other.resolvedVariable) && Objects.equals(this.receiver, other.receiver);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.resolvedVariable, this.receiver);
        }

        public DSLExpression getReceiver() {
            return this.receiver;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            visitor.visitVariable(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer reducer) {
            DSLExpression newReceiver = null;
            if (this.receiver != null) {
                newReceiver = this.receiver.reduceImpl(reducer);
            }
            Variable c = this;
            if (newReceiver != this.receiver) {
                c = new Variable(newReceiver, this.getName());
                c.setResolvedTargetType(this.getResolvedTargetType());
                c.setResolvedVariable(this.getResolvedVariable());
            }
            return reducer.visitVariable(c);
        }

        @Override
        public Object resolveConstant() {
            return super.resolveConstant();
        }

        @Override
        public VariableElement resolveVariable() {
            if (this.resolvedVariable != null) {
                return this.resolvedVariable;
            }
            return null;
        }

        @Override
        public TypeMirror getResolvedType() {
            return this.resolvedVariable != null ? this.resolvedVariable.asType() : null;
        }

        public void setResolvedVariable(VariableElement resolvedVariable) {
            this.resolvedVariable = resolvedVariable;
        }

        public VariableElement getResolvedVariable() {
            return this.resolvedVariable;
        }

        public String toString() {
            return "Variable [receiver=" + String.valueOf(this.receiver) + ", name=" + this.name + ", resolvedVariable=" + String.valueOf(this.resolvedVariable) + "]";
        }

        public boolean isCompilationFinalField() {
            VariableElement v = this.getResolvedVariable();
            if (v == null) {
                throw new IllegalStateException("not resolved yet");
            }
            if (v.getKind() != ElementKind.FIELD) {
                return false;
            }
            if (v.getModifiers().contains((Object)Modifier.FINAL)) {
                return true;
            }
            return ElementUtils.findAnnotationMirror((Element)v, (TypeMirror)ProcessorContext.getInstance().getTypes().CompilerDirectives_CompilationFinal) != null;
        }
    }

    public static final class Call
    extends DSLExpression {
        private final DSLExpression receiver;
        private final String name;
        private final List<DSLExpression> parameters;
        private ExecutableElement resolvedMethod;

        public Call(DSLExpression receiver, String name, List<DSLExpression> parameters) {
            this.receiver = receiver;
            this.name = name;
            this.parameters = parameters;
            for (DSLExpression parameter : parameters) {
                if (parameter != null) continue;
                throw new NullPointerException();
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Call) {
                Call other = (Call)obj;
                return Objects.equals(this.receiver, other.receiver) && this.name.equals(other.name) && this.parameters.equals(other.parameters);
            }
            return false;
        }

        public List<TypeMirror> getResolvedParameterTypes() {
            ArrayList<TypeMirror> types = new ArrayList<TypeMirror>(this.parameters.size());
            for (DSLExpression parameter : this.parameters) {
                types.add(parameter.getResolvedType());
            }
            return types;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.receiver, this.name, this.parameters);
        }

        public DSLExpression getReceiver() {
            return this.receiver;
        }

        public String getName() {
            return this.name;
        }

        public List<DSLExpression> getParameters() {
            return this.parameters;
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            for (DSLExpression parameter : this.getParameters()) {
                parameter.accept(visitor);
            }
            visitor.visitCall(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer reducer) {
            DSLExpression newReceiver = null;
            if (this.receiver != null) {
                newReceiver = this.receiver.reduceImpl(reducer);
            }
            boolean parameterChanged = false;
            ArrayList<DSLExpression> newParameters = new ArrayList<DSLExpression>();
            for (DSLExpression param : this.getParameters()) {
                DSLExpression newParam = param.reduceImpl(reducer);
                if (newParam != param) {
                    parameterChanged = true;
                    newParameters.add(newParam);
                    continue;
                }
                newParameters.add(param);
            }
            Call c = this;
            if (newReceiver != this.receiver || parameterChanged) {
                c = new Call(newReceiver, this.getName(), newParameters);
                c.setResolvedMethod(this.getResolvedMethod());
                c.setResolvedTargetType(this.getResolvedTargetType());
            }
            return reducer.visitCall(c);
        }

        @Override
        public ExecutableElement resolveExecutable() {
            if (this.resolvedMethod != null) {
                return this.resolvedMethod;
            }
            return null;
        }

        @Override
        public TypeMirror getResolvedType() {
            TypeMirror receiverType;
            if (this.resolvedMethod == null) {
                return null;
            }
            if (this.resolvedMethod.getKind() == ElementKind.CONSTRUCTOR) {
                return this.resolvedMethod.getEnclosingElement().asType();
            }
            TypeMirror type = this.resolvedMethod.getReturnType();
            TypeMirror typeMirror = receiverType = this.receiver != null ? this.receiver.getResolvedType() : null;
            if (receiverType != null && type.getKind() == TypeKind.TYPEVAR && receiverType.getKind() == TypeKind.DECLARED) {
                List<? extends TypeMirror> list;
                TypeVariable variable = (TypeVariable)type;
                TypeElement receiverTypeElement = ElementUtils.fromTypeMirror(receiverType);
                Element variableElement = variable.asElement();
                int foundIndex = -1;
                int index = 0;
                for (TypeParameterElement typeParameterElement : receiverTypeElement.getTypeParameters()) {
                    if (ElementUtils.elementEquals(typeParameterElement, variableElement)) {
                        foundIndex = index;
                        break;
                    }
                    ++index;
                }
                DeclaredType declaredReceiverType = (DeclaredType)receiverType;
                if (foundIndex != -1 && foundIndex < (list = declaredReceiverType.getTypeArguments()).size()) {
                    return list.get(foundIndex);
                }
            }
            return this.resolvedMethod.getReturnType();
        }

        public ExecutableElement getResolvedMethod() {
            return this.resolvedMethod;
        }

        public void setResolvedMethod(ExecutableElement resolvedMethod) {
            this.resolvedMethod = resolvedMethod;
        }

        public String toString() {
            return "Call [receiver=" + String.valueOf(this.receiver) + ", name=" + this.name + ", parameters=" + String.valueOf(this.parameters) + ", resolvedMethod=" + String.valueOf(this.resolvedMethod) + "]";
        }
    }

    public static final class ClassLiteral
    extends DSLExpression {
        private final TypeMirror literal;

        public ClassLiteral(TypeMirror literal) {
            this.literal = literal;
        }

        public TypeMirror getLiteral() {
            return this.literal;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ClassLiteral)) {
                return false;
            }
            return ElementUtils.typeEquals(this.literal, ((ClassLiteral)obj).literal);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.literal);
        }

        @Override
        public TypeMirror getResolvedType() {
            return ProcessorContext.getInstance().getType(Class.class);
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            visitor.visitClassLiteral(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer visitor) {
            return this;
        }
    }

    public static final class Binary
    extends DSLExpression {
        private final String operator;
        private final DSLExpression left;
        private final DSLExpression right;
        private TypeMirror resolvedType;

        public Binary(String operator, DSLExpression left, DSLExpression right) {
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        public boolean isComparison() {
            return DSLExpressionResolver.COMPARABLE_OPERATORS.contains(this.operator) || DSLExpressionResolver.IDENTITY_OPERATORS.contains(this.operator);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Binary) {
                Binary other = (Binary)obj;
                return this.operator.equals(other.operator) && this.left.equals(other.left) && this.right.equals(other.right);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.operator, this.left, this.right);
        }

        public String getOperator() {
            return this.operator;
        }

        public DSLExpression getLeft() {
            return this.left;
        }

        public DSLExpression getRight() {
            return this.right;
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
            visitor.visitBinary(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer reducer) {
            DSLExpression newLeft = this.left.reduceImpl(reducer);
            DSLExpression newRight = this.right.reduceImpl(reducer);
            Binary b = this;
            if (newLeft != this.left || newRight != this.right) {
                b = new Binary(this.getOperator(), newLeft, newRight);
                b.setResolvedTargetType(this.getResolvedTargetType());
                b.setResolvedType(this.getResolvedType());
            }
            return reducer.visitBinary(b);
        }

        @Override
        public TypeMirror getResolvedType() {
            return this.resolvedType;
        }

        public void setResolvedType(TypeMirror resolvedType) {
            this.resolvedType = resolvedType;
        }

        public String toString() {
            return "Binary [left=" + String.valueOf(this.left) + ", operator=" + this.operator + ", right=" + String.valueOf(this.right) + ", resolvedType=" + String.valueOf(this.resolvedType) + "]";
        }
    }

    public static final class Cast
    extends DSLExpression {
        private final DSLExpression receiver;
        private final TypeMirror castType;

        public Cast(DSLExpression receiver, TypeMirror castType) {
            Objects.requireNonNull(receiver);
            this.receiver = receiver;
            this.castType = castType;
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            this.receiver.accept(visitor);
            visitor.visitCast(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer visitor) {
            DSLExpression newReceiver = this.receiver.reduceImpl(visitor);
            Cast negate = this;
            if (newReceiver != this.receiver) {
                negate = new Cast(newReceiver, this.castType);
                negate.setResolvedTargetType(this.getResolvedTargetType());
            }
            return negate;
        }

        @Override
        public ExecutableElement resolveExecutable() {
            return this.receiver.resolveExecutable();
        }

        @Override
        public VariableElement resolveVariable() {
            return this.receiver.resolveVariable();
        }

        public TypeMirror getCastType() {
            return this.castType;
        }

        public DSLExpression getReceiver() {
            return this.receiver;
        }

        @Override
        public TypeMirror getResolvedType() {
            return this.castType;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Cast) {
                Cast otherCast = (Cast)obj;
                return this.receiver.equals(otherCast.receiver) && ElementUtils.typeEquals(this.castType, otherCast.castType);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.receiver, this.castType);
        }
    }

    public static final class Negate
    extends DSLExpression {
        private final DSLExpression receiver;

        public Negate(DSLExpression receiver) {
            this.receiver = receiver;
        }

        @Override
        public void accept(DSLExpressionVisitor visitor) {
            this.receiver.accept(visitor);
            visitor.visitNegate(this);
        }

        @Override
        public DSLExpression reduce(DSLExpressionReducer visitor) {
            DSLExpression newReceiver = this.receiver.reduceImpl(visitor);
            Negate negate = this;
            if (newReceiver != this.receiver) {
                negate = new Negate(newReceiver);
                negate.setResolvedTargetType(this.getResolvedTargetType());
            }
            return negate;
        }

        public DSLExpression getReceiver() {
            return this.receiver;
        }

        @Override
        public ExecutableElement resolveExecutable() {
            return this.receiver.resolveExecutable();
        }

        @Override
        public VariableElement resolveVariable() {
            return this.receiver.resolveVariable();
        }

        @Override
        public Object resolveConstant() {
            Object constant = this.receiver.resolveConstant();
            if (constant instanceof Integer) {
                return -((Integer)constant).intValue();
            }
            return super.resolveConstant();
        }

        @Override
        public TypeMirror getResolvedType() {
            return this.receiver.getResolvedType();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Negate) {
                return this.receiver.equals(((Negate)obj).receiver);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.receiver.hashCode();
        }
    }
}

