/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.transform;

import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElementScanner;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class FixWarningsVisitor
extends CodeElementScanner<Void, Void> {
    private final Set<String> symbolsUsed = new HashSet<String>();
    private final DeclaredType overrideType;
    private Set<String> suppressedWarnings = new HashSet<String>();
    private boolean computeSymbols = false;
    private boolean seenDeprecatedElement = false;

    public FixWarningsVisitor(DeclaredType overrideType) {
        this.overrideType = overrideType;
    }

    @Override
    public Void visitType(CodeTypeElement e, Void p) {
        boolean rootType;
        boolean bl = rootType = e.getEnclosingClass() == null;
        if (rootType) {
            this.suppressedWarnings.clear();
        }
        List<TypeElement> superTypes = ElementUtils.getSuperTypes(e);
        for (TypeElement type : superTypes) {
            String qualifiedName = ElementUtils.getQualifiedName(type);
            if (!qualifiedName.equals(Serializable.class.getCanonicalName())) continue;
            if (e.containsField("serialVersionUID")) break;
            this.suppressedWarnings.add("serial");
            break;
        }
        if (e.getDocTree() != null) {
            this.suppressedWarnings.add("javadoc");
        }
        if (ElementUtils.isPackageDeprecated(e)) {
            this.suppressedWarnings.add("deprecation");
        }
        super.visitType(e, p);
        if (this.seenDeprecatedElement && rootType) {
            this.suppressedWarnings.add("deprecation");
        }
        if (rootType && !this.suppressedWarnings.isEmpty()) {
            GeneratorUtils.mergeSuppressWarnings(e, this.suppressedWarnings.toArray(new String[0]));
        }
        return null;
    }

    @Override
    public Void visitVariable(VariableElement e, Void p) {
        CodeVariableElement var;
        if (e instanceof CodeVariableElement && (var = (CodeVariableElement)e).getDocTree() != null) {
            this.suppressedWarnings.add("javadoc");
        }
        return (Void)super.visitVariable(e, p);
    }

    @Override
    public Void visitExecutable(CodeExecutableElement e, Void p) {
        boolean checkIgnored;
        boolean bl = checkIgnored = !this.suppressedWarnings.contains("unused");
        if (e.getParameters().isEmpty()) {
            checkIgnored = false;
        } else if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            checkIgnored = false;
        } else if (this.containsOverride(e)) {
            checkIgnored = false;
        }
        if (e.getDocTree() != null) {
            this.suppressedWarnings.add("javadoc");
        }
        this.symbolsUsed.clear();
        this.computeSymbols = checkIgnored;
        super.visitExecutable(e, p);
        this.checkDeprecated(e.getReturnType());
        for (VariableElement parameter : e.getParameters()) {
            this.checkDeprecated(parameter.asType());
        }
        if (checkIgnored) {
            for (VariableElement parameter : e.getParameters()) {
                if (this.symbolsUsed.contains(parameter.getSimpleName().toString())) continue;
                this.suppressedWarnings.add("unused");
                break;
            }
        }
        return null;
    }

    private void checkDeprecated(TypeMirror mirror) {
        if (ElementUtils.isDeprecated(mirror)) {
            this.seenDeprecatedElement = true;
        }
    }

    private boolean containsOverride(CodeExecutableElement e) {
        for (AnnotationMirror mirror : e.getAnnotationMirrors()) {
            if (!ElementUtils.typeEquals(this.overrideType, mirror.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitTree(CodeTree e, Void p, Element enclosingElement) {
        if (this.computeSymbols && e.getString() != null) {
            this.computeSymbols(e.getString());
        }
        if (e.getType() != null) {
            this.checkDeprecated(e.getType());
        }
        super.visitTree(e, p, enclosingElement);
    }

    private void computeSymbols(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ".= :,()[];{}\"\"'' ", false);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            this.symbolsUsed.add(token);
        }
    }
}

