/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentLibrary;
import com.oracle.truffle.nfi.backend.libffi.NativePointer;
import com.oracle.truffle.nfi.backend.libffi.NativeString;

abstract class ClosureArgumentNode
extends Node {
    ClosureArgumentNode() {
    }

    public abstract Object execute(VirtualFrame var1);

    static class InjectedClosureArgumentNode
    extends ClosureArgumentNode {
        InjectedClosureArgumentNode() {
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return new NativePointer(0L);
        }
    }

    @NodeChild(value="argument", type=ClosureArgumentNode.class)
    static abstract class StringClosureArgumentNode
    extends ClosureArgumentNode {
        StringClosureArgumentNode() {
        }

        @Specialization(guards={"arg == null"})
        Object doNull(Object arg) {
            return new NativeString(0L);
        }

        @Fallback
        Object doString(Object arg) {
            return arg;
        }
    }

    @NodeChild(value="argument", type=ClosureArgumentNode.class)
    static abstract class ObjectClosureArgumentNode
    extends ClosureArgumentNode {
        ObjectClosureArgumentNode() {
        }

        @Specialization(guards={"arg == null"})
        Object doNull(Object arg) {
            return NativePointer.create(LibFFILanguage.get(this), 0L);
        }

        @Fallback
        Object doObject(Object arg) {
            return arg;
        }
    }

    @NodeChild(value="argument", type=ClosureArgumentNode.class)
    static abstract class BufferClosureArgumentNode
    extends ClosureArgumentNode {
        final LibFFIType.CachedTypeInfo type;

        BufferClosureArgumentNode(LibFFIType.CachedTypeInfo type) {
            this.type = type;
        }

        @Specialization
        Object doBuffer(NativeArgumentBuffer.Pointer arg, @CachedLibrary(value="type") NativeArgumentLibrary nativeArguments) {
            NativeArgumentBuffer.Direct buffer = new NativeArgumentBuffer.Direct(arg, 0);
            return nativeArguments.deserialize(this.type, buffer);
        }
    }

    static final class GetArgumentNode
    extends ClosureArgumentNode {
        private final int index;

        GetArgumentNode(int index) {
            this.index = index;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return frame.getArguments()[this.index];
        }
    }

    static final class ConstArgumentNode
    extends ClosureArgumentNode {
        private final Object value;

        ConstArgumentNode(Object value) {
            this.value = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.value;
        }
    }
}

