/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.libffi.ClosureArgumentNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFIClosure.class)
final class LibFFIClosureFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    LibFFIClosureFactory() {
    }

    @GeneratedBy(value=LibFFIClosure.UnboxStringNode.class)
    static final class UnboxStringNodeGen
    extends LibFFIClosure.UnboxStringNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private NativeString0Data nativeString0_cache;

        private UnboxStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        protected Object execute(Object arg0Value) throws UnsupportedTypeException {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    NativeString0Data s0_ = this.nativeString0_cache;
                    while (s0_ != null) {
                        if (s0_.serialize_.accepts(arg0Value)) {
                            return this.nativeString(arg0Value, s0_.serialize_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.nativeString1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object nativeString1Boundary(int state_0, Object arg0Value) throws UnsupportedTypeException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                SerializeArgumentLibrary nativeString1_serialize__ = (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg0Value);
                Object object = this.nativeString(arg0Value, nativeString1_serialize__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                Object object;
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if (exclude == 0) {
                    int count0_ = 0;
                    NativeString0Data s0_ = this.nativeString0_cache;
                    if ((state_0 & 1) != 0) {
                        while (s0_ != null && !s0_.serialize_.accepts(arg0Value)) {
                            s0_ = s0_.next_;
                            ++count0_;
                        }
                    }
                    if (s0_ == null && count0_ < 3) {
                        s0_ = (NativeString0Data)super.insert((Node)new NativeString0Data(this.nativeString0_cache));
                        s0_.serialize_ = (SerializeArgumentLibrary)s0_.insertAccessor(SERIALIZE_ARGUMENT_LIBRARY_.create(arg0Value));
                        MemoryFence.storeStore();
                        this.nativeString0_cache = s0_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.nativeString(arg0Value, s0_.serialize_);
                        return object2;
                    }
                }
                SerializeArgumentLibrary nativeString1_serialize__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    nativeString1_serialize__ = (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg0Value);
                    this.exclude_ = exclude |= 1;
                    this.nativeString0_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.nativeString(arg0Value, nativeString1_serialize__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            NativeString0Data s0_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.nativeString0_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LibFFIClosure.UnboxStringNode create() {
            return new UnboxStringNodeGen();
        }

        @GeneratedBy(value=LibFFIClosure.UnboxStringNode.class)
        private static final class NativeString0Data
        extends Node {
            @Node.Child
            NativeString0Data next_;
            @Node.Child
            SerializeArgumentLibrary serialize_;

            NativeString0Data(NativeString0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LibFFIClosure.BufferRetClosureRootNode.class)
    static final class BufferRetClosureRootNodeGen
    extends LibFFIClosure.BufferRetClosureRootNode {
        @Node.Child
        private ClosureArgumentNode retBuffer_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private BufferRetClosureRootNodeGen(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver, ClosureArgumentNode retBuffer) {
            super(lang, signature, receiver);
            this.retBuffer_ = retBuffer;
        }

        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object retBufferValue_ = this.retBuffer_.execute(frameValue);
            if (state_0 != 0 && retBufferValue_ instanceof NativeArgumentBuffer.Pointer) {
                NativeArgumentBuffer.Pointer retBufferValue__ = (NativeArgumentBuffer.Pointer)retBufferValue_;
                return this.doBufferRet(frameValue, retBufferValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, retBufferValue_);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object retBufferValue) {
            int state_0 = this.state_0_;
            if (retBufferValue instanceof NativeArgumentBuffer.Pointer) {
                NativeArgumentBuffer.Pointer retBufferValue_ = (NativeArgumentBuffer.Pointer)retBufferValue;
                this.state_0_ = state_0 |= 1;
                return this.doBufferRet(frameValue, retBufferValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retBuffer_}, new Object[]{retBufferValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LibFFIClosure.BufferRetClosureRootNode create(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver, ClosureArgumentNode retBuffer) {
            return new BufferRetClosureRootNodeGen(lang, signature, receiver, retBuffer);
        }
    }

    @GeneratedBy(value=LibFFIClosure.CallClosureNode.class)
    static final class CallClosureNodeGen
    extends LibFFIClosure.CallClosureNode {
        @Node.Child
        private ClosureArgumentNode receiver_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private Call0Data call0_cache;

        private CallClosureNodeGen(LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super(signature);
            this.receiver_ = receiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        protected Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object receiverValue_ = this.receiver_.execute(frameValue);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    Call0Data s0_ = this.call0_cache;
                    while (s0_ != null) {
                        if (s0_.interop_.accepts(receiverValue_)) {
                            return this.doCall(frameValue, receiverValue_, s0_.interop_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        InteropLibrary call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                        Object object = this.doCall(frameValue, receiverValue_, call1_interop__);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, receiverValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(VirtualFrame frameValue, Object receiverValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                Object object;
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if (exclude == 0) {
                    int count0_ = 0;
                    Call0Data s0_ = this.call0_cache;
                    if ((state_0 & 1) != 0) {
                        while (s0_ != null && !s0_.interop_.accepts(receiverValue)) {
                            s0_ = s0_.next_;
                            ++count0_;
                        }
                    }
                    if (s0_ == null && count0_ < 3) {
                        s0_ = (Call0Data)super.insert((Node)new Call0Data(this.call0_cache));
                        s0_.interop_ = (InteropLibrary)s0_.insertAccessor(INTEROP_LIBRARY_.create(receiverValue));
                        MemoryFence.storeStore();
                        this.call0_cache = s0_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.doCall(frameValue, receiverValue, s0_.interop_);
                        return object2;
                    }
                }
                InteropLibrary call1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    this.exclude_ = exclude |= 1;
                    this.call0_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.doCall(frameValue, receiverValue, call1_interop__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Call0Data s0_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.call0_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LibFFIClosure.CallClosureNode create(LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            return new CallClosureNodeGen(signature, receiver);
        }

        @GeneratedBy(value=LibFFIClosure.CallClosureNode.class)
        private static final class Call0Data
        extends Node {
            @Node.Child
            Call0Data next_;
            @Node.Child
            InteropLibrary interop_;

            Call0Data(Call0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

