/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.libffi.LibFFINFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFINFIBackend.class)
final class LibFFINFIBackendGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private LibFFINFIBackendGen() {
    }

    static {
        LibraryExport.register(LibFFINFIBackend.class, (LibraryExport[])new LibraryExport[]{new NFIBackendLibraryExports()});
    }

    @GeneratedBy(value=LibFFINFIBackend.class)
    private static final class NFIBackendLibraryExports
    extends LibraryExport<NFIBackendLibrary> {
        private NFIBackendLibraryExports() {
            super(NFIBackendLibrary.class, LibFFINFIBackend.class, false, false, 0);
        }

        protected NFIBackendLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFINFIBackend);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected NFIBackendLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFINFIBackend);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LibFFINFIBackend.class)
        private static final class Uncached
        extends NFIBackendLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFINFIBackend) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFINFIBackend;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                return arg0Value.getSimpleType(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value));
            }

            @CompilerDirectives.TruffleBoundary
            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                return arg0Value.getArrayType(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value));
            }

            @CompilerDirectives.TruffleBoundary
            public Object getEnvType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                return arg0Value.getEnvType((InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value));
            }

            @CompilerDirectives.TruffleBoundary
            public Object createSignatureBuilder(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                return arg0Value.createSignatureBuilder(this, ProfiledArrayBuilder.ArrayBuilderFactory.getUncached());
            }
        }

        @GeneratedBy(value=LibFFINFIBackend.class)
        private static final class Cached
        extends NFIBackendLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private ProfiledArrayBuilder.ArrayBuilderFactory createSignatureBuilderNode__createSignatureBuilder_builderFactory_;

            protected Cached(Object receiver) {
                LibFFINFIBackend castReceiver = (LibFFINFIBackend)receiver;
                this.receiverInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFINFIBackend) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LibFFINFIBackend)) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (arg0Value_ instanceof LibFFINFIBackend) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                InteropLibrary getSimpleTypeNode__getSimpleType_self__ = this.receiverInteropLibrary_;
                return arg0Value.getSimpleType(arg1Value, getSimpleTypeNode__getSimpleType_self__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (arg0Value_ instanceof LibFFINFIBackend) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                InteropLibrary getArrayTypeNode__getArrayType_self__ = this.receiverInteropLibrary_;
                return arg0Value.getArrayType(arg1Value, getArrayTypeNode__getArrayType_self__);
            }

            public Object getEnvType(Object arg0Value_) {
                assert (arg0Value_ instanceof LibFFINFIBackend) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                InteropLibrary getEnvTypeNode__getEnvType_self__ = this.receiverInteropLibrary_;
                return arg0Value.getEnvType(getEnvTypeNode__getEnvType_self__);
            }

            public Object createSignatureBuilder(Object arg0Value_) {
                assert (arg0Value_ instanceof LibFFINFIBackend) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFINFIBackend arg0Value = (LibFFINFIBackend)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    Cached createSignatureBuilderNode__createSignatureBuilder_self__ = this;
                    return arg0Value.createSignatureBuilder(createSignatureBuilderNode__createSignatureBuilder_self__, this.createSignatureBuilderNode__createSignatureBuilder_builderFactory_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.createSignatureBuilderNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object createSignatureBuilderNode_AndSpecialize(LibFFINFIBackend arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    Cached createSignatureBuilderNode__createSignatureBuilder_self__ = null;
                    createSignatureBuilderNode__createSignatureBuilder_self__ = this;
                    this.createSignatureBuilderNode__createSignatureBuilder_builderFactory_ = ProfiledArrayBuilder.ArrayBuilderFactory.create();
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.createSignatureBuilder(createSignatureBuilderNode__createSignatureBuilder_self__, this.createSignatureBuilderNode__createSignatureBuilder_builderFactory_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

