/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.EagerExportProvider;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.backend.libffi.FunctionExecuteNode;
import com.oracle.truffle.nfi.backend.libffi.FunctionExecuteNodeGen;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LibFFISignature.class)
public final class LibFFISignatureGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private LibFFISignatureGen() {
    }

    private static void init() {
    }

    static {
        LibraryExport.register(LibFFISignature.class, (LibraryExport[])new LibraryExport[]{new NFIBackendSignatureLibraryExports()});
    }

    @GeneratedBy(value=LibFFISignature.class)
    private static final class NFIBackendSignatureLibraryExports
    extends LibraryExport<NFIBackendSignatureLibrary> {
        private NFIBackendSignatureLibraryExports() {
            super(NFIBackendSignatureLibrary.class, LibFFISignature.class, false, true, 1);
        }

        protected NFIBackendSignatureLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFISignature);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected NFIBackendSignatureLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFISignature || receiver instanceof LibraryExport);
            return new Cached();
        }

        @GeneratedBy(value=LibFFISignature.class)
        private static final class Uncached
        extends NFIBackendSignatureLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                return LibFFISignature.CreateClosure.createClosure(arg0Value, arg1Value, this);
            }

            @CompilerDirectives.TruffleBoundary
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                return LibFFISignature.call(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), BranchProfile.getUncached(), BranchProfile.getUncached(), FunctionExecuteNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=LibFFISignature.class)
        private static final class Cached
        extends NFIBackendSignatureLibrary
        implements GenerateAOT.Provider {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private CreateClosureCachedExecutableData createClosure_cachedExecutable_cache;
            @Node.Child
            private CreateClosureCachedSignatureData createClosure_cachedSignature_cache;
            @Node.Child
            private CallNode_Call0Data callNode__call0_cache;
            @CompilerDirectives.CompilationFinal
            private BranchProfile callNode__call1_toNative_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile callNode__call1_error_;
            @Node.Child
            private FunctionExecuteNode callNode__call1_functionExecute_;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            @ExplodeLoop
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.createClosureAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0xE) != 0) {
                    if ((state_0 & 2) != 0) {
                        CreateClosureCachedExecutableData s0_ = this.createClosure_cachedExecutable_cache;
                        while (s0_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s0_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeCachedExecutable_((Object)s0_);
                                return this.createClosureAndSpecialize(arg0Value, arg1Value);
                            }
                            if (arg0Value.signatureInfo == s0_.cachedSignatureInfo_ && arg1Value == s0_.cachedExecutable_) {
                                Cached self__ = this;
                                return LibFFISignature.CreateClosure.doCachedExecutable(arg0Value, arg1Value, s0_.cachedSignatureInfo_, s0_.cachedExecutable_, self__, s0_.cachedClosureInfo_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        CreateClosureCachedSignatureData s1_ = this.createClosure_cachedSignature_cache;
                        while (s1_ != null) {
                            if (arg0Value.signatureInfo == s1_.cachedSignatureInfo_) {
                                Cached self__1 = this;
                                return LibFFISignature.CreateClosure.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignatureInfo_, self__1, s1_.cachedClosureInfo_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        Cached createClosure_createClosure_self__ = this;
                        return LibFFISignature.CreateClosure.createClosure(arg0Value, arg1Value, createClosure_createClosure_self__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.createClosureAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LibFFIClosure createClosureAndSpecialize(LibFFISignature arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    LibFFIClosure libFFIClosure;
                    if ((this.state_0_ & 1) != 0) {
                        this.resetAOT_();
                    }
                    int state_0 = this.state_0_;
                    int exclude = this.exclude_;
                    Cached self__ = null;
                    if ((exclude & 1) == 0) {
                        Assumption assumption0;
                        int count0_ = 0;
                        CreateClosureCachedExecutableData s0_ = this.createClosure_cachedExecutable_cache;
                        if ((state_0 & 2) != 0) {
                            while (s0_ != null) {
                                if (arg0Value.signatureInfo == s0_.cachedSignatureInfo_ && arg1Value == s0_.cachedExecutable_ && (s0_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s0_.assumption0_))) {
                                    self__ = this;
                                    break;
                                }
                                s0_ = s0_.next_;
                                ++count0_;
                            }
                        }
                        if (s0_ == null && Assumption.isValidAssumption((Assumption)(assumption0 = LibFFILanguage.getSingleContextAssumption())) && count0_ < 3) {
                            s0_ = (CreateClosureCachedExecutableData)super.insert((Node)new CreateClosureCachedExecutableData(this.createClosure_cachedExecutable_cache));
                            s0_.cachedSignatureInfo_ = arg0Value.signatureInfo;
                            s0_.cachedExecutable_ = arg1Value;
                            self__ = this;
                            s0_.cachedClosureInfo_ = LibFFIClosure.MonomorphicClosureInfo.create(s0_.cachedSignatureInfo_, s0_.cachedExecutable_);
                            s0_.assumption0_ = assumption0;
                            MemoryFence.storeStore();
                            this.createClosure_cachedExecutable_cache = s0_;
                            this.state_0_ = state_0 |= 2;
                        }
                        if (s0_ != null) {
                            lock.unlock();
                            hasLock = false;
                            libFFIClosure = LibFFISignature.CreateClosure.doCachedExecutable(arg0Value, arg1Value, s0_.cachedSignatureInfo_, s0_.cachedExecutable_, self__, s0_.cachedClosureInfo_);
                            return libFFIClosure;
                        }
                    }
                    Cached self__1 = null;
                    if ((exclude & 2) == 0) {
                        int count1_ = 0;
                        CreateClosureCachedSignatureData s1_ = this.createClosure_cachedSignature_cache;
                        if ((state_0 & 4) != 0) {
                            while (s1_ != null) {
                                if (arg0Value.signatureInfo == s1_.cachedSignatureInfo_) {
                                    self__1 = this;
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = (CreateClosureCachedSignatureData)super.insert((Node)new CreateClosureCachedSignatureData(this.createClosure_cachedSignature_cache));
                            s1_.cachedSignatureInfo_ = arg0Value.signatureInfo;
                            self__1 = this;
                            s1_.cachedClosureInfo_ = LibFFIClosure.PolymorphicClosureInfo.create(s1_.cachedSignatureInfo_);
                            MemoryFence.storeStore();
                            this.createClosure_cachedSignature_cache = s1_;
                            this.exclude_ = exclude |= 1;
                            this.createClosure_cachedExecutable_cache = null;
                            state_0 &= 0xFFFFFFFD;
                            this.state_0_ = state_0 |= 4;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            libFFIClosure = LibFFISignature.CreateClosure.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignatureInfo_, self__1, s1_.cachedClosureInfo_);
                            return libFFIClosure;
                        }
                    }
                    Cached createClosure_createClosure_self__ = null;
                    createClosure_createClosure_self__ = this;
                    this.exclude_ = exclude |= 3;
                    this.createClosure_cachedExecutable_cache = null;
                    this.createClosure_cachedSignature_cache = null;
                    state_0 &= 0xFFFFFFF9;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    LibFFIClosure libFFIClosure2 = LibFFISignature.CreateClosure.createClosure(arg0Value, arg1Value, createClosure_createClosure_self__);
                    return libFFIClosure2;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xE) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xE & (state_0 & 0xE) - 1) == 0) {
                    CreateClosureCachedExecutableData s0_ = this.createClosure_cachedExecutable_cache;
                    CreateClosureCachedSignatureData s1_ = this.createClosure_cachedSignature_cache;
                    if (!(s0_ != null && s0_.next_ != null || s1_ != null && s1_.next_ != null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeCachedExecutable_(Object s0_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    CreateClosureCachedExecutableData prev = null;
                    CreateClosureCachedExecutableData cur = this.createClosure_cachedExecutable_cache;
                    while (cur != null) {
                        if (cur == s0_) {
                            if (prev == null) {
                                this.createClosure_cachedExecutable_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.createClosure_cachedExecutable_cache == null) {
                        this.state_0_ &= 0xFFFFFFFD;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    return;
                }
                this.exclude_ |= 3;
                this.createClosure_cachedExecutable_cache = null;
                this.createClosure_cachedSignature_cache = null;
                state_0 &= 0xFFFFFFF9;
                this.state_0_ = state_0 |= 9;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.exclude_ = 0;
            }

            @ExplodeLoop
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                }
                if ((state_0 & 0x30) != 0) {
                    if ((state_0 & 0x10) != 0) {
                        CallNode_Call0Data s0_ = this.callNode__call0_cache;
                        while (s0_ != null) {
                            if (s0_.interop_.accepts(arg1Value)) {
                                return LibFFISignature.call(arg0Value, arg1Value, arg2Value, s0_.interop_, s0_.toNative_, s0_.error_, s0_.functionExecute_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0x20) != 0) {
                        return this.call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object call1Boundary(int state_0, LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary callNode__call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                    Object object = LibFFISignature.call(arg0Value, arg1Value, arg2Value, callNode__call1_interop__, this.callNode__call1_toNative_, this.callNode__call1_error_, this.callNode__call1_functionExecute_);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object callNode_AndSpecialize(LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    Object object;
                    if ((this.state_0_ & 1) != 0) {
                        this.resetAOT_();
                    }
                    int state_0 = this.state_0_;
                    int exclude = this.exclude_;
                    if ((exclude & 4) == 0) {
                        int count0_ = 0;
                        CallNode_Call0Data s0_ = this.callNode__call0_cache;
                        if ((state_0 & 0x10) != 0) {
                            while (s0_ != null && !s0_.interop_.accepts(arg1Value)) {
                                s0_ = s0_.next_;
                                ++count0_;
                            }
                        }
                        if (s0_ == null && count0_ < 3) {
                            s0_ = (CallNode_Call0Data)super.insert((Node)new CallNode_Call0Data(this.callNode__call0_cache));
                            s0_.interop_ = (InteropLibrary)s0_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                            s0_.toNative_ = BranchProfile.create();
                            s0_.error_ = BranchProfile.create();
                            s0_.functionExecute_ = s0_.insertAccessor(FunctionExecuteNodeGen.create());
                            MemoryFence.storeStore();
                            this.callNode__call0_cache = s0_;
                            this.state_0_ = state_0 |= 0x10;
                        }
                        if (s0_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object2 = LibFFISignature.call(arg0Value, arg1Value, arg2Value, s0_.interop_, s0_.toNative_, s0_.error_, s0_.functionExecute_);
                            return object2;
                        }
                    }
                    InteropLibrary callNode__call1_interop__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        callNode__call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                        this.callNode__call1_toNative_ = BranchProfile.create();
                        this.callNode__call1_error_ = BranchProfile.create();
                        this.callNode__call1_functionExecute_ = (FunctionExecuteNode)super.insert((Node)FunctionExecuteNodeGen.create());
                        this.exclude_ = exclude |= 4;
                        this.callNode__call0_cache = null;
                        state_0 &= 0xFFFFFFEF;
                        this.state_0_ = state_0 |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        object = LibFFISignature.call(arg0Value, arg1Value, arg2Value, callNode__call1_interop__, this.callNode__call1_toNative_, this.callNode__call1_error_, this.callNode__call1_functionExecute_);
                    }
                    catch (Throwable throwable) {
                        encapsulating_.set(prev_);
                        throw throwable;
                    }
                    encapsulating_.set(prev_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @GeneratedBy(value=LibFFISignature.class)
            private static final class CallNode_Call0Data
            extends Node {
                @Node.Child
                CallNode_Call0Data next_;
                @Node.Child
                InteropLibrary interop_;
                @CompilerDirectives.CompilationFinal
                BranchProfile toNative_;
                @CompilerDirectives.CompilationFinal
                BranchProfile error_;
                @Node.Child
                FunctionExecuteNode functionExecute_;

                CallNode_Call0Data(CallNode_Call0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }

            @GeneratedBy(value=LibFFISignature.class)
            private static final class CreateClosureCachedSignatureData
            extends Node {
                @Node.Child
                CreateClosureCachedSignatureData next_;
                @CompilerDirectives.CompilationFinal
                LibFFISignature.CachedSignatureInfo cachedSignatureInfo_;
                @CompilerDirectives.CompilationFinal
                LibFFIClosure.PolymorphicClosureInfo cachedClosureInfo_;

                CreateClosureCachedSignatureData(CreateClosureCachedSignatureData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }

            @GeneratedBy(value=LibFFISignature.class)
            private static final class CreateClosureCachedExecutableData
            extends Node {
                @Node.Child
                CreateClosureCachedExecutableData next_;
                @CompilerDirectives.CompilationFinal
                LibFFISignature.CachedSignatureInfo cachedSignatureInfo_;
                @CompilerDirectives.CompilationFinal
                Object cachedExecutable_;
                @CompilerDirectives.CompilationFinal
                LibFFIClosure.MonomorphicClosureInfo cachedClosureInfo_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                CreateClosureCachedExecutableData(CreateClosureCachedExecutableData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=LibFFISignature.class)
    public static final class NFIBackendSignatureLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            LibFFISignatureGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary";
        }
    }
}

