/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.backend.libffi.ClosureArgumentNode;
import com.oracle.truffle.nfi.backend.libffi.ClosureArgumentNodeFactory;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFITypeFactory;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentLibrary;
import com.oracle.truffle.nfi.backend.libffi.NativePointer;
import com.oracle.truffle.nfi.backend.libffi.NativeString;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import java.lang.reflect.Array;
import java.nio.ByteOrder;

final class LibFFIType {
    protected final long type;
    protected final CachedTypeInfo typeInfo;

    static CachedTypeInfo createSimpleTypeInfo(LibFFILanguage language, NativeSimpleType simpleType, int size, int alignment) {
        switch (simpleType) {
            case VOID: {
                return new VoidType(language, size, alignment);
            }
            case UINT8: 
            case SINT8: 
            case UINT16: 
            case SINT16: 
            case UINT32: 
            case SINT32: 
            case UINT64: 
            case SINT64: 
            case FLOAT: 
            case DOUBLE: 
            case POINTER: {
                return new SimpleType(language, simpleType, size, alignment);
            }
            case STRING: {
                return new StringType(language, size, alignment);
            }
            case OBJECT: {
                return new ObjectType(language, size, alignment);
            }
            case NULLABLE: {
                return new NullableType(language, size, alignment);
            }
        }
        throw new AssertionError((Object)simpleType.name());
    }

    static CachedTypeInfo createArrayTypeInfo(CachedTypeInfo ptrType, NativeSimpleType simpleType) {
        switch (simpleType) {
            case UINT8: 
            case SINT8: 
            case UINT16: 
            case SINT16: 
            case UINT32: 
            case SINT32: 
            case UINT64: 
            case SINT64: 
            case FLOAT: 
            case DOUBLE: {
                return new ArrayType(ptrType, simpleType);
            }
        }
        return null;
    }

    protected LibFFIType(CachedTypeInfo typeInfo, long type) {
        this.typeInfo = typeInfo;
        this.type = type;
    }

    @ExportLibrary(value=NativeArgumentLibrary.class)
    static final class EnvType
    extends BasePointerType {
        EnvType(CachedTypeInfo pointerType) {
            super(pointerType, Direction.BOTH, true);
        }

        @ExportMessage
        protected void serialize(NativeArgumentBuffer buffer, Object value) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.ENV, null, this.size);
        }

        @ExportMessage(name="deserialize")
        public Object deserialize(NativeArgumentBuffer buffer) {
            return this.deserializeRet(null, buffer);
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"environment pointer can not be used as return type");
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return new ClosureArgumentNode.InjectedClosureArgumentNode();
        }
    }

    @ExportLibrary(value=NativeArgumentLibrary.class)
    static final class ArrayType
    extends BasePointerType {
        final NativeSimpleType elementType;
        final HostObjectHelperNode uncachedHelper;

        ArrayType(CachedTypeInfo pointerType, NativeSimpleType elementType) {
            super(pointerType, Direction.JAVA_TO_NATIVE_ONLY, false);
            switch (elementType) {
                case UINT8: 
                case SINT8: 
                case UINT16: 
                case SINT16: 
                case UINT32: 
                case SINT32: 
                case UINT64: 
                case SINT64: 
                case FLOAT: 
                case DOUBLE: {
                    this.elementType = elementType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("only primitive array types are supported, got [%s]", elementType));
                }
            }
            this.uncachedHelper = new UncachedHostObjectHelperNode(this.size, elementType);
        }

        @ExportMessage
        boolean accepts(@Cached(value="this.elementType") NativeSimpleType cachedType) {
            return cachedType == this.elementType;
        }

        @ExportMessage
        void serialize(NativeArgumentBuffer buffer, Object value, @Cached SerializeHelperNode serializeHelper) throws UnsupportedTypeException {
            buffer.align(this.alignment);
            serializeHelper.execute(this, buffer, value);
        }

        @ExportMessage
        public Object deserialize(NativeArgumentBuffer buffer) {
            return this.deserializeRet(null, buffer);
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"Arrays can only be passed from Java to native");
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            throw new AssertionError((Object)"Arrays can only be passed from Java to native");
        }

        static final class UncachedHostObjectHelperNode
        extends HostObjectHelperNode {
            private final SerializeArgumentLibrary uncachedLib1;
            private final SerializeArgumentLibrary uncachedLib2;

            UncachedHostObjectHelperNode(int size, NativeSimpleType elementType) {
                super(size, elementType);
                this.uncachedLib1 = this.arrayClass1 != null ? (SerializeArgumentLibrary)SerializeArgumentLibrary.getFactory().getUncached(Array.newInstance(this.arrayClass1.getComponentType(), 0)) : null;
                this.uncachedLib2 = this.arrayClass2 != null ? (SerializeArgumentLibrary)SerializeArgumentLibrary.getFactory().getUncached(Array.newInstance(this.arrayClass2.getComponentType(), 0)) : null;
            }

            @Override
            void execute(NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException, HostObjectHelperNode.WrongTypeException {
                if (CompilerDirectives.isExact((Object)value, (Class)this.arrayClass1)) {
                    assert (this.uncachedLib1.accepts(value));
                    this.uncachedLib1.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass1), buffer, this.size);
                } else if (CompilerDirectives.isExact((Object)value, (Class)this.arrayClass2)) {
                    assert (this.uncachedLib2.accepts(value));
                    this.uncachedLib2.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass2), buffer, this.size);
                } else {
                    throw new HostObjectHelperNode.WrongTypeException();
                }
            }
        }

        static abstract class CachedHostObjectHelperNode
        extends HostObjectHelperNode {
            protected CachedHostObjectHelperNode(int size, NativeSimpleType elementType) {
                super(size, elementType);
            }

            @Specialization(guards={"arrayClass1 == value.getClass()"}, limit="1")
            void doHostArray1(NativeArgumentBuffer buffer, Object value, @Cached.Exclusive @CachedLibrary(value="value") SerializeArgumentLibrary lib) throws UnsupportedTypeException {
                lib.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass1), buffer, this.size);
            }

            @Specialization(guards={"arrayClass2 == value.getClass()"}, limit="1")
            void doHostArray2(NativeArgumentBuffer buffer, Object value, @Cached.Exclusive @CachedLibrary(value="value") SerializeArgumentLibrary lib) throws UnsupportedTypeException {
                lib.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass2), buffer, this.size);
            }

            @Fallback
            void doOther(NativeArgumentBuffer buffer, Object value) throws HostObjectHelperNode.WrongTypeException {
                throw new HostObjectHelperNode.WrongTypeException();
            }
        }

        static abstract class HostObjectHelperNode
        extends Node {
            final int size;
            final Class<?> arrayClass1;
            final Class<?> arrayClass2;

            static HostObjectHelperNode create(ArrayType type) {
                return LibFFITypeFactory.ArrayTypeFactory.CachedHostObjectHelperNodeGen.create(type.size, type.elementType);
            }

            static HostObjectHelperNode getUncached(ArrayType type) {
                return type.uncachedHelper;
            }

            protected HostObjectHelperNode(int size, NativeSimpleType elementType) {
                this.size = size;
                switch (elementType) {
                    case UINT8: 
                    case SINT8: {
                        this.arrayClass1 = byte[].class;
                        this.arrayClass2 = boolean[].class;
                        break;
                    }
                    case UINT16: 
                    case SINT16: {
                        this.arrayClass1 = short[].class;
                        this.arrayClass2 = char[].class;
                        break;
                    }
                    case UINT32: 
                    case SINT32: {
                        this.arrayClass1 = int[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    case UINT64: 
                    case SINT64: {
                        this.arrayClass1 = long[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    case FLOAT: {
                        this.arrayClass1 = float[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    case DOUBLE: {
                        this.arrayClass1 = double[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    default: {
                        this.arrayClass1 = null;
                        this.arrayClass2 = null;
                    }
                }
            }

            abstract void execute(NativeArgumentBuffer var1, Object var2) throws UnsupportedTypeException, WrongTypeException;

            final class WrongTypeException
            extends ControlFlowException {
                private static final long serialVersionUID = 1L;

                WrongTypeException() {
                }
            }
        }

        @ImportStatic(value={LibFFILanguage.class})
        @GenerateUncached
        static abstract class SerializeHelperNode
        extends Node {
            SerializeHelperNode() {
            }

            abstract void execute(ArrayType var1, NativeArgumentBuffer var2, Object var3) throws UnsupportedTypeException;

            final boolean isHostObject(Object value) {
                LibFFIContext ctx = LibFFIContext.get(this);
                return ctx.env.isHostObject(value) && ctx.env.asHostObject(value) != null;
            }

            @Specialization(guards={"isHostObject(value)"}, rewriteOn={HostObjectHelperNode.WrongTypeException.class})
            final void doHostObject(ArrayType type, NativeArgumentBuffer buffer, Object value, @Cached(parameters={"type"}) HostObjectHelperNode helper) throws UnsupportedTypeException, HostObjectHelperNode.WrongTypeException {
                Object hostObject = LibFFIContext.get((Node)this).env.asHostObject(value);
                helper.execute(buffer, hostObject);
            }

            @Specialization(guards={"!isHostObject(value)"}, limit="3")
            static void doInteropObject(ArrayType type, NativeArgumentBuffer buffer, Object value, @CachedLibrary(value="value") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
                serialize.putPointer(value, buffer, type.size);
            }

            @Specialization(limit="3", replaces={"doHostObject", "doInteropObject"})
            final void doGeneric(ArrayType type, NativeArgumentBuffer buffer, Object value, @CachedLibrary(value="value") SerializeArgumentLibrary serialize, @Cached(parameters={"type"}) HostObjectHelperNode helper) throws UnsupportedTypeException {
                if (this.isHostObject(value)) {
                    try {
                        this.doHostObject(type, buffer, value, helper);
                        return;
                    }
                    catch (HostObjectHelperNode.WrongTypeException wrongTypeException) {
                        // empty catch block
                    }
                }
                SerializeHelperNode.doInteropObject(type, buffer, value, serialize);
            }
        }
    }

    static abstract class BasePointerType
    extends CachedTypeInfo {
        protected BasePointerType(CachedTypeInfo pointerType, Direction direction, boolean injectedArgument) {
            super(pointerType.size, pointerType.alignment, 1, direction, injectedArgument);
        }
    }

    static final class NullableType
    extends BasicType {
        NullableType(LibFFILanguage language, int size, int alignment) {
            super(language, NativeSimpleType.NULLABLE, size, alignment, 1, Direction.JAVA_TO_NATIVE_ONLY);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.ObjectClosureArgumentNodeGen.create(arg);
        }
    }

    static final class ObjectType
    extends BasicType {
        ObjectType(LibFFILanguage language, int size, int alignment) {
            super(language, NativeSimpleType.OBJECT, size, alignment, 1);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.ObjectClosureArgumentNodeGen.create(arg);
        }
    }

    static final class StringType
    extends BasicType {
        private StringType(LibFFILanguage language, int size, int alignment) {
            super(language, NativeSimpleType.STRING, size, alignment, 1);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.StringClosureArgumentNodeGen.create(arg);
        }
    }

    static final class VoidType
    extends BasicType {
        private VoidType(LibFFILanguage language, int size, int alignment) {
            super(language, NativeSimpleType.VOID, size, alignment, 0);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            throw new AssertionError((Object)"invalid argument type VOID");
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            return NativePointer.NULL;
        }
    }

    static final class SimpleType
    extends BasicType {
        SimpleType(LibFFILanguage language, NativeSimpleType simpleType, int size, int alignment) {
            super(language, simpleType, size, alignment, simpleType == NativeSimpleType.POINTER ? 1 : 0);
        }

        public Object fromPrimitive(long primitive) {
            switch (this.simpleType) {
                case VOID: {
                    return NativePointer.NULL;
                }
                case UINT8: {
                    return primitive & 0xFFL;
                }
                case SINT8: {
                    return (byte)primitive;
                }
                case UINT16: {
                    return primitive & 0xFFFFL;
                }
                case SINT16: {
                    return (short)primitive;
                }
                case UINT32: {
                    return primitive & 0xFFFFFFFFL;
                }
                case SINT32: {
                    return (int)primitive;
                }
                case UINT64: 
                case SINT64: {
                    return primitive;
                }
                case FLOAT: {
                    int ret = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? (int)(primitive >>> 32) : (int)primitive;
                    return Float.valueOf(Float.intBitsToFloat(ret));
                }
                case DOUBLE: {
                    return Double.longBitsToDouble(primitive);
                }
                case POINTER: {
                    return NativePointer.create(this.nfiLanguage, primitive);
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)this.simpleType.name());
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.BufferClosureArgumentNodeGen.create(this, arg);
        }

        @Override
        public CachedTypeInfo overrideClosureRetType() {
            switch (this.simpleType) {
                case UINT8: 
                case UINT16: 
                case UINT32: {
                    return this.nfiLanguage.lookupSimpleTypeInfo(NativeSimpleType.UINT64);
                }
                case SINT8: 
                case SINT16: 
                case SINT32: {
                    return this.nfiLanguage.lookupSimpleTypeInfo(NativeSimpleType.SINT64);
                }
            }
            return this;
        }

        public String toString() {
            return this.simpleType.toString();
        }
    }

    @ExportLibrary(value=NativeArgumentLibrary.class)
    static abstract class BasicType
    extends CachedTypeInfo {
        final LibFFILanguage nfiLanguage;
        final NativeSimpleType simpleType;

        BasicType(LibFFILanguage language, NativeSimpleType simpleType, int size, int alignment, int objectCount, Direction direction) {
            super(size, alignment, objectCount, direction, false);
            this.nfiLanguage = language;
            this.simpleType = simpleType;
        }

        BasicType(LibFFILanguage language, NativeSimpleType simpleType, int size, int alignment, int objectCount) {
            this(language, simpleType, size, alignment, objectCount, Direction.BOTH);
        }

        @ExportMessage
        boolean accepts(@Cached.Shared(value="cachedType") @Cached(value="this.simpleType") NativeSimpleType cachedType) {
            return cachedType == this.simpleType;
        }

        @ExportMessage
        void serialize(NativeArgumentBuffer buffer, Object value, @Cached.Shared(value="cachedType") @Cached(value="this.simpleType") NativeSimpleType cachedType, @CachedLibrary(limit="3") SerializeArgumentLibrary serialize, @CachedLibrary(limit="1") InteropLibrary interop) throws UnsupportedTypeException {
            buffer.align(this.alignment);
            switch (cachedType) {
                case UINT8: {
                    serialize.putUByte(value, buffer);
                    break;
                }
                case SINT8: {
                    serialize.putByte(value, buffer);
                    break;
                }
                case UINT16: {
                    serialize.putUShort(value, buffer);
                    break;
                }
                case SINT16: {
                    serialize.putShort(value, buffer);
                    break;
                }
                case UINT32: {
                    serialize.putUInt(value, buffer);
                    break;
                }
                case SINT32: {
                    serialize.putInt(value, buffer);
                    break;
                }
                case UINT64: {
                    serialize.putULong(value, buffer);
                    break;
                }
                case SINT64: {
                    serialize.putLong(value, buffer);
                    break;
                }
                case FLOAT: {
                    serialize.putFloat(value, buffer);
                    break;
                }
                case DOUBLE: {
                    serialize.putDouble(value, buffer);
                    break;
                }
                case POINTER: {
                    serialize.putPointer(value, buffer, this.size);
                    break;
                }
                case STRING: {
                    serialize.putString(value, buffer, this.size);
                    break;
                }
                case OBJECT: {
                    buffer.putObject(NativeArgumentBuffer.TypeTag.OBJECT, value, this.size);
                    break;
                }
                case NULLABLE: {
                    if (interop.isNull(value)) {
                        buffer.putPointer(0L, this.size);
                        break;
                    }
                    buffer.putObject(NativeArgumentBuffer.TypeTag.OBJECT, value, this.size);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw new AssertionError((Object)this.simpleType.name());
                }
            }
        }

        @ExportMessage
        Object deserialize(NativeArgumentBuffer buffer, @CachedLibrary(value="this") NativeArgumentLibrary self, @Cached.Shared(value="cachedType") @Cached(value="this.simpleType") NativeSimpleType cachedType) {
            return this.deserializeImpl(buffer, (Node)self, cachedType);
        }

        private Object deserializeImpl(NativeArgumentBuffer buffer, Node node, NativeSimpleType cachedType) throws AssertionError {
            buffer.align(this.alignment);
            switch (cachedType) {
                case VOID: {
                    return null;
                }
                case UINT8: {
                    return buffer.getInt8() & 0xFF;
                }
                case SINT8: {
                    return buffer.getInt8();
                }
                case UINT16: {
                    return buffer.getInt16() & 0xFFFF;
                }
                case SINT16: {
                    return buffer.getInt16();
                }
                case UINT32: {
                    return (long)buffer.getInt32() & 0xFFFFFFFFL;
                }
                case SINT32: {
                    return buffer.getInt32();
                }
                case UINT64: 
                case SINT64: {
                    return buffer.getInt64();
                }
                case FLOAT: {
                    return Float.valueOf(buffer.getFloat());
                }
                case DOUBLE: {
                    return buffer.getDouble();
                }
                case POINTER: {
                    return NativePointer.create(LibFFILanguage.get(node), buffer.getPointer(this.size));
                }
                case STRING: {
                    return new NativeString(buffer.getPointer(this.size));
                }
                case OBJECT: 
                case NULLABLE: {
                    Object ret = buffer.getObject(this.size);
                    if (ret == null) {
                        return NativePointer.create(LibFFILanguage.get(node), 0L);
                    }
                    return ret;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)this.simpleType.name());
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            return this.deserializeImpl(buffer, node, this.simpleType);
        }
    }

    static abstract class CachedTypeInfo {
        protected final int size;
        protected final int alignment;
        protected final int objectCount;
        protected final Direction allowedDataFlowDirection;
        protected final boolean injectedArgument;

        protected CachedTypeInfo(int size, int alignment, int objectCount, Direction direction, boolean injectedArgument) {
            this.size = size;
            this.alignment = alignment;
            this.objectCount = objectCount;
            this.allowedDataFlowDirection = direction;
            this.injectedArgument = injectedArgument;
        }

        public abstract ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode var1);

        public abstract Object deserializeRet(Node var1, NativeArgumentBuffer var2);

        public CachedTypeInfo overrideClosureRetType() {
            return this;
        }
    }

    static enum Direction {
        JAVA_TO_NATIVE_ONLY,
        NATIVE_TO_JAVA_ONLY,
        BOTH;


        Direction reverse() {
            switch (this) {
                case JAVA_TO_NATIVE_ONLY: {
                    return NATIVE_TO_JAVA_ONLY;
                }
                case NATIVE_TO_JAVA_ONLY: {
                    return JAVA_TO_NATIVE_ONLY;
                }
                case BOTH: {
                    return BOTH;
                }
            }
            return null;
        }
    }
}

