/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=SerializeArgumentLibrary.class)})
class NativePointer
implements TruffleObject {
    static final NativePointer NULL = new NativePointer(0L);
    final long nativePointer;

    static Object create(LibFFILanguage language, long nativePointer) {
        return language.getTools().createBindableSymbol((Object)new NativePointer(nativePointer));
    }

    NativePointer(long nativePointer) {
        this.nativePointer = nativePointer;
    }

    public String toString() {
        return String.valueOf(this.nativePointer);
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer;
    }

    @ExportMessage
    boolean isNull() {
        return this.nativePointer == 0L;
    }

    @ExportMessage
    void putPointer(NativeArgumentBuffer buffer, int ptrSize) {
        buffer.putPointer(this.nativePointer, ptrSize);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return LibFFILanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "NativePointer(" + this.nativePointer + ")";
    }
}

