/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.NativePointer;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentLibrary;

@GeneratedBy(value=NativePointer.class)
final class NativePointerGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativePointerGen() {
    }

    static {
        LibraryExport.register(NativePointer.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new SerializeArgumentLibraryExports()});
    }

    @GeneratedBy(value=NativePointer.class)
    static class SerializeArgumentLibraryExports
    extends LibraryExport<SerializeArgumentLibrary> {
        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, NativePointer.class, false, false, 0);
        }

        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativePointer);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointer.class)
        static class Uncached
        extends SerializeArgumentLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public final boolean isAdoptable() {
                return false;
            }

            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativePointer)receiver).putPointer(buffer, ptrSize);
            }
        }

        @GeneratedBy(value=NativePointer.class)
        static class Cached
        extends SerializeArgumentLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            protected Cached(Object receiver) {
                NativePointer castReceiver = (NativePointer)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).putPointer(buffer, ptrSize);
            }
        }
    }

    @GeneratedBy(value=NativePointer.class)
    static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NativePointer.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativePointer);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointer.class)
        static class Uncached
        extends InteropLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public final boolean isAdoptable() {
                return false;
            }

            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).isNull();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=NativePointer.class)
        static class Cached
        extends InteropLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            protected Cached(Object receiver) {
                NativePointer castReceiver = (NativePointer)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asPointer();
            }

            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isNull();
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).toDisplayString(allowSideEffects);
            }
        }
    }
}

