/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=SerializeArgumentLibrary.class)})
class NativeString
implements TruffleObject {
    final long nativePointer;

    NativeString(long nativePointer) {
        this.nativePointer = nativePointer;
    }

    @CompilerDirectives.TruffleBoundary
    private static native String toJavaString(long var0);

    @ExportMessage
    boolean isNull() {
        return this.nativePointer == 0L;
    }

    @ExportMessage
    boolean isString() {
        return this.nativePointer != 0L;
    }

    @ExportMessage
    String asString() {
        return NativeString.toJavaString(this.nativePointer);
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer;
    }

    @ExportMessage
    NativeString toNative() {
        return this;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="putPointer"), @ExportMessage(name="putString")})
    void putPointer(NativeArgumentBuffer buffer, int ptrSize) {
        buffer.putPointer(this.nativePointer, ptrSize);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return LibFFILanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "NativeString(" + this.asString() + ")";
    }
}

