// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.EagerExportProvider;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure.MonomorphicClosureInfo;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure.PolymorphicClosureInfo;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature.CachedSignatureInfo;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature.Call;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature.CreateClosure;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LibFFISignature.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LibFFISignatureGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(LibFFISignature.class, new NFIBackendSignatureLibraryExports());
    }

    private LibFFISignatureGen() {
    }

    private static void init() {
        // This method is intended to ensure class initialization.
    }

    @GeneratedBy(LibFFISignature.class)
    public static final class NFIBackendSignatureLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            LibFFISignatureGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary";
        }

    }
    @GeneratedBy(LibFFISignature.class)
    private static final class NFIBackendSignatureLibraryExports extends LibraryExport<NFIBackendSignatureLibrary> {

        private NFIBackendSignatureLibraryExports() {
            super(NFIBackendSignatureLibrary.class, LibFFISignature.class, false, true, 1);
        }

        @Override
        protected NFIBackendSignatureLibrary createUncached(Object receiver) {
            assert receiver instanceof LibFFISignature;
            NFIBackendSignatureLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendSignatureLibrary createCached(Object receiver) {
            assert receiver instanceof LibFFISignature || receiver instanceof LibraryExport<?>;
            return new Cached();
        }

        @GeneratedBy(LibFFISignature.class)
        private static final class Cached extends NFIBackendSignatureLibrary implements GenerateAOT.Provider {

            static final ReferenceField<CallCallGeneric0Data> CALL_CALL_GENERIC0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "call_callGeneric0_cache", CallCallGeneric0Data.class);
            static final ReferenceField<CreateClosureCachedExecutableData> CREATE_CLOSURE_CACHED_EXECUTABLE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "createClosure_cachedExecutable_cache", CreateClosureCachedExecutableData.class);
            static final ReferenceField<CreateClosureCachedSignatureData> CREATE_CLOSURE_CACHED_SIGNATURE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "createClosure_cachedSignature_cache", CreateClosureCachedSignatureData.class);

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link Call#callLibFFI}
             *   2: SpecializationActive {@link Call#callGeneric}
             *   3: SpecializationActive {@link Call#callGeneric}
             *   4: SpecializationActive {@link CreateClosure#doCachedExecutable}
             *   5: SpecializationActive {@link CreateClosure#doCachedSignature}
             *   6: SpecializationActive {@link CreateClosure#createClosure}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Call#callLibFFI}
             *   Parameter: {@link FunctionExecuteNode} functionExecute</pre>
             */
            @Child private FunctionExecuteNode call_callLibFFI_functionExecute_;
            @UnsafeAccessedField @Child private CallCallGeneric0Data call_callGeneric0_cache;
            @Child private CallCallGeneric1Data call_callGeneric1_cache;
            @UnsafeAccessedField @CompilationFinal private CreateClosureCachedExecutableData createClosure_cachedExecutable_cache;
            @UnsafeAccessedField @CompilationFinal private CreateClosureCachedSignatureData createClosure_cachedSignature_cache;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Call#callLibFFI}
             *     Activation probability: 0.24167
             *     With/without class size: 8/4 bytes
             *   Specialization {@link Call#callGeneric}
             *     Activation probability: 0.16667
             *     With/without class size: 10/20 bytes
             *   Specialization {@link Call#callGeneric}
             *     Activation probability: 0.09167
             *     With/without class size: 6/16 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid library usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return callAndSpecialize(arg0Value, arg1Value, arg2Value);
                }
                if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LibFFISignature.Call.callLibFFI(LibFFISignature, LibFFISymbol, Object[], FunctionExecuteNode)] || SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] || SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LibFFISignature.Call.callLibFFI(LibFFISignature, LibFFISymbol, Object[], FunctionExecuteNode)] */ && arg1Value instanceof LibFFISymbol) {
                        LibFFISymbol arg1Value_ = (LibFFISymbol) arg1Value;
                        {
                            FunctionExecuteNode functionExecute__ = this.call_callLibFFI_functionExecute_;
                            if (functionExecute__ != null) {
                                return Call.callLibFFI(arg0Value, arg1Value_, arg2Value, functionExecute__);
                            }
                        }
                    }
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] || SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */) {
                            CallCallGeneric0Data s1_ = this.call_callGeneric0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value))) {
                                    return Call.callGeneric(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.isExecutable_, s1_.toNative_, s1_.error_, s1_.functionExecute_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */) {
                            CallCallGeneric1Data s2_ = this.call_callGeneric1_cache;
                            if (s2_ != null) {
                                return this.call_CallGeneric1Boundary(state_0, s2_, arg0Value, arg1Value, arg2Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return callAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object call_CallGeneric1Boundary(int state_0, CallCallGeneric1Data s2_, LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        return Call.callGeneric(arg0Value, arg1Value, arg2Value, interop__, s2_.isExecutable_, s2_.toNative_, s2_.error_, s2_.functionExecute_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object callAndSpecialize(LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof LibFFISymbol) {
                    LibFFISymbol arg1Value_ = (LibFFISymbol) arg1Value;
                    FunctionExecuteNode functionExecute__ = this.insert((FunctionExecuteNodeGen.create()));
                    Objects.requireNonNull(functionExecute__, "Specialization 'callLibFFI(LibFFISignature, LibFFISymbol, Object[], FunctionExecuteNode)' cache 'functionExecute' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.call_callLibFFI_functionExecute_ = functionExecute__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LibFFISignature.Call.callLibFFI(LibFFISignature, LibFFISymbol, Object[], FunctionExecuteNode)] */;
                    this.state_0_ = state_0;
                    return Call.callLibFFI(arg0Value, arg1Value_, arg2Value, functionExecute__);
                }
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */) {
                    while (true) {
                        int count1_ = 0;
                        CallCallGeneric0Data s1_ = CALL_CALL_GENERIC0_CACHE_UPDATER.getVolatile(this);
                        CallCallGeneric0Data s1_original = s1_;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value))) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            // assert (s1_.interop_.accepts(arg1Value));
                            if (count1_ < (3)) {
                                s1_ = this.insert(new CallCallGeneric0Data(s1_original));
                                InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                Objects.requireNonNull(interop__, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.interop_ = interop__;
                                BranchProfile isExecutable__ = (BranchProfile.create());
                                Objects.requireNonNull(isExecutable__, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'isExecutable' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.isExecutable_ = isExecutable__;
                                BranchProfile toNative__ = (BranchProfile.create());
                                Objects.requireNonNull(toNative__, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.toNative_ = toNative__;
                                BranchProfile error__ = (BranchProfile.create());
                                Objects.requireNonNull(error__, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'error' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.error_ = error__;
                                FunctionExecuteNode functionExecute__1 = s1_.insert((FunctionExecuteNodeGen.create()));
                                Objects.requireNonNull(functionExecute__1, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'functionExecute' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.functionExecute_ = functionExecute__1;
                                if (!CALL_CALL_GENERIC0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s1_ != null) {
                            return Call.callGeneric(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.isExecutable_, s1_.toNative_, s1_.error_, s1_.functionExecute_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            CallCallGeneric1Data s2_ = this.insert(new CallCallGeneric1Data());
                            interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                            BranchProfile isExecutable__ = (BranchProfile.create());
                            Objects.requireNonNull(isExecutable__, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'isExecutable' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s2_.isExecutable_ = isExecutable__;
                            BranchProfile toNative__ = (BranchProfile.create());
                            Objects.requireNonNull(toNative__, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s2_.toNative_ = toNative__;
                            BranchProfile error__ = (BranchProfile.create());
                            Objects.requireNonNull(error__, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'error' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s2_.error_ = error__;
                            FunctionExecuteNode functionExecute__1 = s2_.insert((FunctionExecuteNodeGen.create()));
                            Objects.requireNonNull(functionExecute__1, "Specialization 'callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)' cache 'functionExecute' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s2_.functionExecute_ = functionExecute__1;
                            VarHandle.storeStoreFence();
                            this.call_callGeneric1_cache = s2_;
                            this.call_callGeneric0_cache = null;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LibFFISignature.Call.callGeneric(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, BranchProfile, FunctionExecuteNode)] */;
                            this.state_0_ = state_0;
                            return Call.callGeneric(arg0Value, arg1Value, arg2Value, interop__, isExecutable__, toNative__, error__, functionExecute__1);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1110) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                        CallCallGeneric0Data s1_ = this.call_callGeneric0_cache;
                        if ((s1_ == null || s1_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    FunctionExecuteNode functionExecute__ = this.insert((FunctionExecuteNodeGen.create()));
                    Objects.requireNonNull(functionExecute__, "Specialization 'callLibFFI(LibFFISignature, LibFFISymbol, Object[], FunctionExecuteNode)' cache 'functionExecute' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.call_callLibFFI_functionExecute_ = functionExecute__;
                    assert NodeUtil.assertRecursion(this.call_callLibFFI_functionExecute_, 1);
                    ((GenerateAOT.Provider) this.call_callLibFFI_functionExecute_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LibFFISignature.Call.callLibFFI(LibFFISignature, LibFFISymbol, Object[], FunctionExecuteNode)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LibFFISignature.CreateClosure.createClosure(LibFFISignature, Object, NFIBackendSignatureLibrary)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.call_callLibFFI_functionExecute_ = null;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link CreateClosure#doCachedExecutable}
             *     Activation probability: 0.24167
             *     With/without class size: 10/12 bytes
             *   Specialization {@link CreateClosure#doCachedSignature}
             *     Activation probability: 0.16667
             *     With/without class size: 8/8 bytes
             *   Specialization {@link CreateClosure#createClosure}
             *     Activation probability: 0.09167
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid library usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return createClosureAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1110000) != 0 /* is SpecializationActive[LibFFISignature.CreateClosure.doCachedExecutable(LibFFISignature, Object, CachedSignatureInfo, Object, NFIBackendSignatureLibrary, MonomorphicClosureInfo)] || SpecializationActive[LibFFISignature.CreateClosure.doCachedSignature(LibFFISignature, Object, CachedSignatureInfo, NFIBackendSignatureLibrary, PolymorphicClosureInfo)] || SpecializationActive[LibFFISignature.CreateClosure.createClosure(LibFFISignature, Object, NFIBackendSignatureLibrary)] */) {
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LibFFISignature.CreateClosure.doCachedExecutable(LibFFISignature, Object, CachedSignatureInfo, Object, NFIBackendSignatureLibrary, MonomorphicClosureInfo)] */) {
                        CreateClosureCachedExecutableData s0_ = this.createClosure_cachedExecutable_cache;
                        while (s0_ != null) {
                            if (!Assumption.isValidAssumption(s0_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                removeCachedExecutable_(s0_);
                                return createClosureAndSpecialize(arg0Value, arg1Value);
                            }
                            if ((arg0Value.signatureInfo == s0_.cachedSignatureInfo_) && (arg1Value == s0_.cachedExecutable_)) {
                                NFIBackendSignatureLibrary self__ = (this);
                                return CreateClosure.doCachedExecutable(arg0Value, arg1Value, s0_.cachedSignatureInfo_, s0_.cachedExecutable_, self__, s0_.cachedClosureInfo_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LibFFISignature.CreateClosure.doCachedSignature(LibFFISignature, Object, CachedSignatureInfo, NFIBackendSignatureLibrary, PolymorphicClosureInfo)] */) {
                        CreateClosureCachedSignatureData s1_ = this.createClosure_cachedSignature_cache;
                        while (s1_ != null) {
                            if ((arg0Value.signatureInfo == s1_.cachedSignatureInfo_)) {
                                NFIBackendSignatureLibrary self__1 = (this);
                                return CreateClosure.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignatureInfo_, self__1, s1_.cachedClosureInfo_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LibFFISignature.CreateClosure.createClosure(LibFFISignature, Object, NFIBackendSignatureLibrary)] */) {
                        {
                            NFIBackendSignatureLibrary self__2 = (this);
                            return CreateClosure.createClosure(arg0Value, arg1Value, self__2);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return createClosureAndSpecialize(arg0Value, arg1Value);
            }

            private LibFFIClosure createClosureAndSpecialize(LibFFISignature arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    NFIBackendSignatureLibrary self__ = null;
                    if (((state_0 & 0b1100000)) == 0 /* is-not SpecializationActive[LibFFISignature.CreateClosure.doCachedSignature(LibFFISignature, Object, CachedSignatureInfo, NFIBackendSignatureLibrary, PolymorphicClosureInfo)] && SpecializationActive[LibFFISignature.CreateClosure.createClosure(LibFFISignature, Object, NFIBackendSignatureLibrary)] */) {
                        while (true) {
                            int count0_ = 0;
                            CreateClosureCachedExecutableData s0_ = CREATE_CLOSURE_CACHED_EXECUTABLE_CACHE_UPDATER.getVolatile(this);
                            CreateClosureCachedExecutableData s0_original = s0_;
                            while (s0_ != null) {
                                if ((arg0Value.signatureInfo == s0_.cachedSignatureInfo_) && (arg1Value == s0_.cachedExecutable_) && Assumption.isValidAssumption(s0_.assumption0_)) {
                                    self__ = (this);
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                // assert (arg0Value.signatureInfo == s0_.cachedSignatureInfo_);
                                // assert (arg1Value == s0_.cachedExecutable_);
                                {
                                    Assumption assumption0 = (LibFFILanguage.getSingleContextAssumption());
                                    if (Assumption.isValidAssumption(assumption0)) {
                                        if (count0_ < (3)) {
                                            s0_ = new CreateClosureCachedExecutableData(s0_original);
                                            s0_.cachedSignatureInfo_ = (arg0Value.signatureInfo);
                                            s0_.cachedExecutable_ = (arg1Value);
                                            self__ = (this);
                                            s0_.cachedClosureInfo_ = (MonomorphicClosureInfo.create(s0_.cachedSignatureInfo_, s0_.cachedExecutable_));
                                            s0_.assumption0_ = assumption0;
                                            if (!CREATE_CLOSURE_CACHED_EXECUTABLE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LibFFISignature.CreateClosure.doCachedExecutable(LibFFISignature, Object, CachedSignatureInfo, Object, NFIBackendSignatureLibrary, MonomorphicClosureInfo)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                            if (s0_ != null) {
                                return CreateClosure.doCachedExecutable(arg0Value, arg1Value, s0_.cachedSignatureInfo_, s0_.cachedExecutable_, self__, s0_.cachedClosureInfo_);
                            }
                            break;
                        }
                    }
                }
                {
                    NFIBackendSignatureLibrary self__1 = null;
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LibFFISignature.CreateClosure.createClosure(LibFFISignature, Object, NFIBackendSignatureLibrary)] */) {
                        while (true) {
                            int count1_ = 0;
                            CreateClosureCachedSignatureData s1_ = CREATE_CLOSURE_CACHED_SIGNATURE_CACHE_UPDATER.getVolatile(this);
                            CreateClosureCachedSignatureData s1_original = s1_;
                            while (s1_ != null) {
                                if ((arg0Value.signatureInfo == s1_.cachedSignatureInfo_)) {
                                    self__1 = (this);
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (arg0Value.signatureInfo == s1_.cachedSignatureInfo_);
                                if (count1_ < (3)) {
                                    s1_ = new CreateClosureCachedSignatureData(s1_original);
                                    s1_.cachedSignatureInfo_ = (arg0Value.signatureInfo);
                                    self__1 = (this);
                                    s1_.cachedClosureInfo_ = (PolymorphicClosureInfo.create(s1_.cachedSignatureInfo_));
                                    if (!CREATE_CLOSURE_CACHED_SIGNATURE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    this.createClosure_cachedExecutable_cache = null;
                                    state_0 = state_0 & 0xffffffef /* remove SpecializationActive[LibFFISignature.CreateClosure.doCachedExecutable(LibFFISignature, Object, CachedSignatureInfo, Object, NFIBackendSignatureLibrary, MonomorphicClosureInfo)] */;
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LibFFISignature.CreateClosure.doCachedSignature(LibFFISignature, Object, CachedSignatureInfo, NFIBackendSignatureLibrary, PolymorphicClosureInfo)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return CreateClosure.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignatureInfo_, self__1, s1_.cachedClosureInfo_);
                            }
                            break;
                        }
                    }
                }
                {
                    NFIBackendSignatureLibrary self__2 = null;
                    self__2 = (this);
                    this.createClosure_cachedExecutable_cache = null;
                    this.createClosure_cachedSignature_cache = null;
                    state_0 = state_0 & 0xffffffcf /* remove SpecializationActive[LibFFISignature.CreateClosure.doCachedExecutable(LibFFISignature, Object, CachedSignatureInfo, Object, NFIBackendSignatureLibrary, MonomorphicClosureInfo)], SpecializationActive[LibFFISignature.CreateClosure.doCachedSignature(LibFFISignature, Object, CachedSignatureInfo, NFIBackendSignatureLibrary, PolymorphicClosureInfo)] */;
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LibFFISignature.CreateClosure.createClosure(LibFFISignature, Object, NFIBackendSignatureLibrary)] */;
                    this.state_0_ = state_0;
                    return CreateClosure.createClosure(arg0Value, arg1Value, self__2);
                }
            }

            void removeCachedExecutable_(CreateClosureCachedExecutableData s0_) {
                while (true) {
                    CreateClosureCachedExecutableData cur = this.createClosure_cachedExecutable_cache;
                    CreateClosureCachedExecutableData original = cur;
                    CreateClosureCachedExecutableData update = null;
                    while (cur != null) {
                        if (cur == s0_) {
                            if (cur == original) {
                                update = cur.next_;
                            } else {
                                update = original.remove(s0_);
                            }
                            break;
                        }
                        cur = cur.next_;
                    }
                    if (cur != null && !CREATE_CLOSURE_CACHED_EXECUTABLE_CACHE_UPDATER.compareAndSet(this, original, update)) {
                        continue;
                    }
                    break;
                }
            }

            @GeneratedBy(LibFFISignature.class)
            @DenyReplace
            private static final class CallCallGeneric0Data extends Node {

                @Child CallCallGeneric0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link InteropLibrary} interop</pre>
                 */
                @Child InteropLibrary interop_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link BranchProfile} isExecutable</pre>
                 */
                @CompilationFinal BranchProfile isExecutable_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link BranchProfile} toNative</pre>
                 */
                @CompilationFinal BranchProfile toNative_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link BranchProfile} error</pre>
                 */
                @CompilationFinal BranchProfile error_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link FunctionExecuteNode} functionExecute</pre>
                 */
                @Child FunctionExecuteNode functionExecute_;

                CallCallGeneric0Data(CallCallGeneric0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
            @GeneratedBy(LibFFISignature.class)
            @DenyReplace
            private static final class CallCallGeneric1Data extends Node {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link BranchProfile} isExecutable</pre>
                 */
                @CompilationFinal BranchProfile isExecutable_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link BranchProfile} toNative</pre>
                 */
                @CompilationFinal BranchProfile toNative_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link BranchProfile} error</pre>
                 */
                @CompilationFinal BranchProfile error_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Call#callGeneric}
                 *   Parameter: {@link FunctionExecuteNode} functionExecute</pre>
                 */
                @Child FunctionExecuteNode functionExecute_;

                CallCallGeneric1Data() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
            @GeneratedBy(LibFFISignature.class)
            @DenyReplace
            private static final class CreateClosureCachedExecutableData {

                @CompilationFinal final CreateClosureCachedExecutableData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCachedExecutable}
                 *   Parameter: {@link CachedSignatureInfo} cachedSignatureInfo</pre>
                 */
                @CompilationFinal CachedSignatureInfo cachedSignatureInfo_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCachedExecutable}
                 *   Parameter: {@link Object} cachedExecutable</pre>
                 */
                @CompilationFinal Object cachedExecutable_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCachedExecutable}
                 *   Parameter: {@link MonomorphicClosureInfo} cachedClosureInfo</pre>
                 */
                @CompilationFinal MonomorphicClosureInfo cachedClosureInfo_;
                @CompilationFinal Assumption assumption0_;

                CreateClosureCachedExecutableData(CreateClosureCachedExecutableData next_) {
                    this.next_ = next_;
                }

                CreateClosureCachedExecutableData remove(CreateClosureCachedExecutableData search) {
                    CreateClosureCachedExecutableData newNext = this.next_;
                    if (newNext != null) {
                        if (search == newNext) {
                            newNext = newNext.next_;
                        } else {
                            newNext = newNext.remove(search);
                        }
                    }
                    CreateClosureCachedExecutableData copy = new CreateClosureCachedExecutableData(newNext);
                    copy.cachedSignatureInfo_ = this.cachedSignatureInfo_;
                    copy.cachedExecutable_ = this.cachedExecutable_;
                    copy.cachedClosureInfo_ = this.cachedClosureInfo_;
                    copy.assumption0_ = this.assumption0_;
                    return copy;
                }

            }
            @GeneratedBy(LibFFISignature.class)
            @DenyReplace
            private static final class CreateClosureCachedSignatureData {

                @CompilationFinal final CreateClosureCachedSignatureData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCachedSignature}
                 *   Parameter: {@link CachedSignatureInfo} cachedSignatureInfo</pre>
                 */
                @CompilationFinal CachedSignatureInfo cachedSignatureInfo_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCachedSignature}
                 *   Parameter: {@link PolymorphicClosureInfo} cachedClosureInfo</pre>
                 */
                @CompilationFinal PolymorphicClosureInfo cachedClosureInfo_;

                CreateClosureCachedSignatureData(CreateClosureCachedSignatureData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(LibFFISignature.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendSignatureLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                if (arg1Value instanceof LibFFISymbol) {
                    LibFFISymbol arg1Value_ = (LibFFISymbol) arg1Value;
                    return Call.callLibFFI(arg0Value, arg1Value_, arg2Value, (FunctionExecuteNodeGen.getUncached()));
                }
                return Call.callGeneric(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (BranchProfile.getUncached()), (BranchProfile.getUncached()), (BranchProfile.getUncached()), (FunctionExecuteNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                return CreateClosure.createClosure(arg0Value, arg1Value, (this));
            }

        }
    }
}
