// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature.CachedSignatureInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link FunctionExecuteNode#cachedSignature}
 *     Activation probability: 0.65000
 *     With/without class size: 22/8 bytes
 *   Specialization {@link FunctionExecuteNode#genericExecute}
 *     Activation probability: 0.35000
 *     With/without class size: 11/4 bytes
 * </pre>
 */
@GeneratedBy(FunctionExecuteNode.class)
@SuppressWarnings("javadoc")
final class FunctionExecuteNodeGen extends FunctionExecuteNode implements GenerateAOT.Provider {

    static final ReferenceField<CachedSignatureData> CACHED_SIGNATURE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedSignature_cache", CachedSignatureData.class);
    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link FunctionExecuteNode#cachedSignature}
     *   2: SpecializationActive {@link FunctionExecuteNode#genericExecute}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private CachedSignatureData cachedSignature_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link FunctionExecuteNode#genericExecute}
     *   Parameter: {@link IndirectCallNode} execute</pre>
     */
    @Child private IndirectCallNode genericExecute_execute_;

    private FunctionExecuteNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(long arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] || SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */) {
                CachedSignatureData s0_ = this.cachedSignature_cache;
                while (s0_ != null) {
                    if ((arg1Value.signatureInfo == s0_.cachedInfo_)) {
                        return cachedSignature(arg0Value, arg1Value, arg2Value, s0_.cachedInfo_, s0_.execute_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */) {
                {
                    IndirectCallNode execute__ = this.genericExecute_execute_;
                    if (execute__ != null) {
                        return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, execute__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(long arg0Value, LibFFISignature arg1Value, Object[] arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */) {
            while (true) {
                int count0_ = 0;
                CachedSignatureData s0_ = CACHED_SIGNATURE_CACHE_UPDATER.getVolatile(this);
                CachedSignatureData s0_original = s0_;
                while (s0_ != null) {
                    if ((arg1Value.signatureInfo == s0_.cachedInfo_)) {
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    // assert (arg1Value.signatureInfo == s0_.cachedInfo_);
                    if (count0_ < (3)) {
                        s0_ = this.insert(new CachedSignatureData(s0_original));
                        s0_.cachedInfo_ = (arg1Value.signatureInfo);
                        s0_.execute_ = s0_.insert((FunctionExecuteNode.createCachedSignatureCall(s0_.cachedInfo_)));
                        if (!CACHED_SIGNATURE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s0_ != null) {
                    return cachedSignature(arg0Value, arg1Value, arg2Value, s0_.cachedInfo_, s0_.execute_);
                }
                break;
            }
        }
        VarHandle.storeStoreFence();
        this.genericExecute_execute_ = this.insert((IndirectCallNode.create()));
        this.cachedSignature_cache = null;
        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */;
        state_0 = state_0 | 0b100 /* add SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */;
        this.state_0_ = state_0;
        return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, this.genericExecute_execute_);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                CachedSignatureData s0_ = this.cachedSignature_cache;
                if ((s0_ == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            VarHandle.storeStoreFence();
            this.genericExecute_execute_ = this.insert((IndirectCallNode.create()));
            this.cachedSignature_cache = null;
            this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */;
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.genericExecute_execute_ = null;
    }

    @NeverDefault
    public static FunctionExecuteNode create() {
        return new FunctionExecuteNodeGen();
    }

    @NeverDefault
    public static FunctionExecuteNode getUncached() {
        return FunctionExecuteNodeGen.UNCACHED;
    }

    @GeneratedBy(FunctionExecuteNode.class)
    @DenyReplace
    private static final class CachedSignatureData extends Node {

        @Child CachedSignatureData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link FunctionExecuteNode#cachedSignature}
         *   Parameter: {@link CachedSignatureInfo} cachedInfo</pre>
         */
        @CompilationFinal CachedSignatureInfo cachedInfo_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link FunctionExecuteNode#cachedSignature}
         *   Parameter: {@link DirectCallNode} execute</pre>
         */
        @Child DirectCallNode execute_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(FunctionExecuteNode.class)
    @DenyReplace
    private static final class Uncached extends FunctionExecuteNode {

        @TruffleBoundary
        @Override
        public Object execute(long arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
            return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, (IndirectCallNode.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
