// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure.BufferRetClosureRootNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure.CallClosureNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure.UnboxStringNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature.CachedSignatureInfo;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType.CachedTypeInfo;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer.Pointer;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

@GeneratedBy(LibFFIClosure.class)
@SuppressWarnings("javadoc")
final class LibFFIClosureFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link CallClosureNode#doCall}
     *     Activation probability: 0.65000
     *     With/without class size: 19/4 bytes
     *   Specialization {@link CallClosureNode#doCall}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(CallClosureNode.class)
    @SuppressWarnings("javadoc")
    static final class CallClosureNodeGen extends CallClosureNode {

        static final ReferenceField<Call0Data> CALL0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "call0_cache", Call0Data.class);

        @Child private ClosureArgumentNode receiver_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link CallClosureNode#doCall}
         *   1: SpecializationActive {@link CallClosureNode#doCall}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Call0Data call0_cache;

        private CallClosureNodeGen(CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super(signature);
            this.receiver_ = receiver;
        }

        @ExplodeLoop
        @Override
        protected Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object receiverValue_ = this.receiver_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] || SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] */) {
                    Call0Data s0_ = this.call0_cache;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(receiverValue_))) {
                            return doCall(frameValue, receiverValue_, s0_.interop_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] */) {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        {
                            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                            return doCall(frameValue, receiverValue_, interop__);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, receiverValue_);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object receiverValue) {
            int state_0 = this.state_0_;
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] */) {
                while (true) {
                    int count0_ = 0;
                    Call0Data s0_ = CALL0_CACHE_UPDATER.getVolatile(this);
                    Call0Data s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(receiverValue))) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        // assert (s0_.interop_.accepts(receiverValue));
                        if (count0_ < (3)) {
                            s0_ = this.insert(new Call0Data(s0_original));
                            InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(receiverValue)));
                            Objects.requireNonNull(interop__, "Specialization 'doCall(VirtualFrame, Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s0_.interop_ = interop__;
                            if (!CALL0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s0_ != null) {
                        return doCall(frameValue, receiverValue, s0_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        interop__ = (INTEROP_LIBRARY_.getUncached());
                        this.call0_cache = null;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LibFFIClosure.CallClosureNode.doCall(VirtualFrame, Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doCall(frameValue, receiverValue, interop__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                    Call0Data s0_ = this.call0_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static CallClosureNode create(CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            return new CallClosureNodeGen(signature, receiver);
        }

        @GeneratedBy(CallClosureNode.class)
        @DenyReplace
        private static final class Call0Data extends Node {

            @Child Call0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CallClosureNode#doCall}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Call0Data(Call0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link BufferRetClosureRootNode#doBufferRet}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(BufferRetClosureRootNode.class)
    @SuppressWarnings("javadoc")
    static final class BufferRetClosureRootNodeGen extends BufferRetClosureRootNode {

        @Child private ClosureArgumentNode retBuffer_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link BufferRetClosureRootNode#doBufferRet}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private BufferRetClosureRootNodeGen(LibFFILanguage lang, CachedSignatureInfo signature, ClosureArgumentNode receiver, ClosureArgumentNode retBuffer) {
            super(lang, signature, receiver);
            this.retBuffer_ = retBuffer;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object retBufferValue_ = this.retBuffer_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[LibFFIClosure.BufferRetClosureRootNode.doBufferRet(VirtualFrame, Pointer)] */ && retBufferValue_ instanceof Pointer) {
                Pointer retBufferValue__ = (Pointer) retBufferValue_;
                return doBufferRet(frameValue, retBufferValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, retBufferValue_);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object retBufferValue) {
            int state_0 = this.state_0_;
            if (retBufferValue instanceof Pointer) {
                Pointer retBufferValue_ = (Pointer) retBufferValue;
                state_0 = state_0 | 0b1 /* add SpecializationActive[LibFFIClosure.BufferRetClosureRootNode.doBufferRet(VirtualFrame, Pointer)] */;
                this.state_0_ = state_0;
                return doBufferRet(frameValue, retBufferValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retBuffer_}, retBufferValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @NeverDefault
        public static BufferRetClosureRootNode create(LibFFILanguage lang, CachedSignatureInfo signature, ClosureArgumentNode receiver, ClosureArgumentNode retBuffer) {
            return new BufferRetClosureRootNodeGen(lang, signature, receiver, retBuffer);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link UnboxStringNode#nativeString}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(UnboxStringNode.class)
    @SuppressWarnings("javadoc")
    static final class UnboxStringNodeGen extends UnboxStringNode {

        private UnboxStringNodeGen(CachedTypeInfo strType) {
            super(strType);
        }

        @Override
        protected Object execute(Object arg0Value) throws UnsupportedTypeException {
            return nativeString(arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static UnboxStringNode create(CachedTypeInfo strType) {
            return new UnboxStringNodeGen(strType);
        }

    }
}
