/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.panama.ArgumentNode;
import com.oracle.truffle.nfi.backend.panama.ErrorContext;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.panama.PanamaSignature;
import com.oracle.truffle.nfi.backend.panama.PanamaType;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Reference;

@GenerateUncached
@ImportStatic(value={PanamaNFILanguage.class})
@GenerateAOT
@GenerateInline(value=false)
abstract class FunctionExecuteNode
extends Node {
    FunctionExecuteNode() {
    }

    public abstract Object execute(long var1, PanamaSignature var3, Object[] var4) throws ArityException, UnsupportedTypeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"signature.signatureInfo == cachedInfo"}, limit="3")
    @GenerateAOT.Exclude
    protected Object cachedSignature(long receiver, PanamaSignature signature, Object[] args, @Cached(value="signature.signatureInfo") PanamaSignature.CachedSignatureInfo cachedInfo, @Cached(value="createCachedSignatureCall(cachedInfo)") DirectCallNode execute) {
        try {
            Object object = execute.call(new Object[]{receiver, args, signature});
            return object;
        }
        finally {
            Reference.reachabilityFence(args);
        }
    }

    protected static DirectCallNode createCachedSignatureCall(PanamaSignature.CachedSignatureInfo signature) {
        DirectCallNode callNode = DirectCallNode.create((CallTarget)signature.callTarget);
        callNode.forceInlining();
        return callNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(replaces={"cachedSignature"})
    static Object genericExecute(long receiver, PanamaSignature signature, Object[] args, @Cached IndirectCallNode execute) {
        try {
            Object object = execute.call(signature.signatureInfo.callTarget, new Object[]{receiver, args, signature});
            return object;
        }
        finally {
            Reference.reachabilityFence(args);
        }
    }

    static abstract class SignatureExecuteNode
    extends RootNode {
        final PanamaSignature.CachedSignatureInfo signatureInfo;
        @Node.Children
        ArgumentNode[] argNodes;

        SignatureExecuteNode(PanamaNFILanguage language, PanamaSignature.CachedSignatureInfo signatureInfo) {
            super((TruffleLanguage)language);
            this.signatureInfo = signatureInfo;
            PanamaType[] argTypes = signatureInfo.getArgTypes();
            this.argNodes = new ArgumentNode[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                this.argNodes[i] = argTypes[i].createArgumentNode();
            }
        }

        public abstract Object execute(VirtualFrame var1);

        MemorySegment getAddress(VirtualFrame frame) {
            return MemorySegment.ofAddress((Long)frame.getArguments()[0]);
        }

        Object[] getArgs(VirtualFrame frame) {
            return (Object[])frame.getArguments()[1];
        }

        PanamaSignature getSig(VirtualFrame frame) {
            return (PanamaSignature)frame.getArguments()[2];
        }

        @Specialization
        @ExplodeLoop
        public Object doGeneric(VirtualFrame frame) {
            Object[] args = this.getArgs(frame);
            MemorySegment address = this.getAddress(frame);
            PanamaSignature signature = this.getSig(frame);
            if (args.length != this.argNodes.length) {
                throw SignatureExecuteNode.silenceException(RuntimeException.class, (Exception)ArityException.create((int)this.argNodes.length, (int)this.argNodes.length, (int)args.length));
            }
            try {
                PanamaType[] types = this.signatureInfo.getArgTypes();
                assert (this.argNodes.length == types.length);
                for (int i = 0; i < this.argNodes.length; ++i) {
                    args[i] = this.argNodes[i].execute(args[i]);
                }
            }
            catch (UnsupportedTypeException ex) {
                throw SignatureExecuteNode.silenceException(RuntimeException.class, (Exception)((Object)ex));
            }
            Object ret = this.signatureInfo.execute(signature, args, address);
            ((ErrorContext)PanamaNFILanguage.get((Node)this).errorContext.get()).handleThrowables();
            return ret;
        }

        static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
            throw ex;
        }
    }
}

