/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.panama.ErrorContext;
import com.oracle.truffle.nfi.backend.panama.PanamaNFIBackend;
import com.oracle.truffle.nfi.backend.panama.PanamaNFIContext;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendFactory;

@TruffleLanguage.Registration(id="internal/nfi-panama", name="nfi-panama", version="0.1", characterMimeTypes={"trufflenfi/panama"}, internal=true, services={NFIBackendFactory.class}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
public class PanamaNFILanguage
extends TruffleLanguage<PanamaNFIContext> {
    public static final String MIME_TYPE = "trufflenfi/panama";
    @CompilerDirectives.CompilationFinal
    private PanamaNFIBackend backend;
    private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("panama backend single context");
    public final ContextThreadLocal<ErrorContext> errorContext = this.createErrorContext();
    private static final TruffleLanguage.LanguageReference<PanamaNFILanguage> REFERENCE = TruffleLanguage.LanguageReference.create(PanamaNFILanguage.class);

    static Assumption getSingleContextAssumption() {
        return PanamaNFILanguage.get(null).singleContextAssumption;
    }

    protected void initializeMultipleContexts() {
        super.initializeMultipleContexts();
        this.singleContextAssumption.invalidate();
    }

    protected PanamaNFIContext createContext(TruffleLanguage.Env env) {
        env.registerService((Object)new NFIBackendFactory(){

            public String getBackendId() {
                return "panama";
            }

            public NFIBackend createBackend() {
                if (PanamaNFILanguage.this.backend == null) {
                    PanamaNFILanguage.this.backend = new PanamaNFIBackend(PanamaNFILanguage.this);
                }
                return PanamaNFILanguage.this.backend;
            }
        });
        try {
            return new PanamaNFIContext(this, env);
        }
        catch (UnsupportedClassVersionError e) {
            return null;
        }
    }

    public final ContextThreadLocal<ErrorContext> createErrorContext() {
        try {
            return this.locals.createContextThreadLocal(ErrorContext::new);
        }
        catch (UnsupportedClassVersionError e) {
            return null;
        }
    }

    protected void initializeContext(PanamaNFIContext context) throws Exception {
        context.initialize();
        ((ErrorContext)this.errorContext.get()).initialize();
    }

    protected boolean patchContext(PanamaNFIContext context, TruffleLanguage.Env newEnv) {
        context.patchEnv(newEnv);
        context.initialize();
        return true;
    }

    protected void disposeContext(PanamaNFIContext context) {
        if (context == null) {
            return;
        }
        context.dispose();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        RootNode ret = new RootNode(this, this){

            public Object execute(VirtualFrame frame) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException("illegal access to internal language");
            }
        };
        return ret.getCallTarget();
    }

    static PanamaNFILanguage get(Node node) {
        return (PanamaNFILanguage)REFERENCE.get(node);
    }
}

