/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.nfi.backend.panama.PanamaNFIContext;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;

public class ErrorContext {
    private static final String ERRNO_LOCATION = switch (InternalResource.OS.getCurrent()) {
        default -> throw new MatchException(null, null);
        case InternalResource.OS.DARWIN -> "__error";
        case InternalResource.OS.LINUX -> "__errno_location";
        case InternalResource.OS.WINDOWS -> "_errno";
    };
    private Throwable throwable = null;
    private MemorySegment errnoLocation;
    private Integer nativeErrno = null;
    final PanamaNFIContext ctx;

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    void handleThrowables() {
        if (this.throwable != null) {
            Throwable temp = this.throwable;
            this.throwable = null;
            throw ErrorContext.silenceThrowable(RuntimeException.class, temp);
        }
    }

    public boolean nativeErrnoSet() {
        return this.nativeErrno != null;
    }

    public int getNativeErrno() {
        return this.nativeErrno;
    }

    public void setNativeErrno(int nativeErrno) {
        this.nativeErrno = nativeErrno;
    }

    MemorySegment getErrnoLocation() {
        Linker linker = Linker.nativeLinker();
        FunctionDescriptor desc = FunctionDescriptor.of(ValueLayout.JAVA_LONG, new MemoryLayout[0]);
        MemorySegment t = linker.defaultLookup().find(ERRNO_LOCATION).get();
        MethodHandle handle = linker.downcallHandle(desc, new Linker.Option[0]);
        try {
            return MemorySegment.ofAddress(handle.invokeExact(t)).reinterpret(4L);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    void initialize() {
        this.errnoLocation = this.getErrnoLocation();
    }

    int getErrno() {
        return this.errnoLocation.get(ValueLayout.JAVA_INT, 0L);
    }

    void setErrno(int newErrno) {
        this.errnoLocation.set(ValueLayout.JAVA_INT, 0L, newErrno);
    }

    ErrorContext(PanamaNFIContext ctx, Thread thread) {
        this.ctx = ctx;
    }

    static <E extends Throwable> RuntimeException silenceThrowable(Class<E> type, Throwable t) throws E {
        throw t;
    }
}

