/*
 * Decompiled with CFR 0.152.
 */
package grails.core;

import grails.core.ArtefactHandler;
import grails.core.ArtefactInfo;
import grails.core.GrailsClass;
import grails.util.GrailsNameUtils;
import groovy.lang.Closure;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.core.exceptions.GrailsRuntimeException;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;
import org.grails.io.support.UrlResource;

public class ArtefactHandlerAdapter
implements ArtefactHandler {
    protected final String type;
    protected final Class<?> grailsClassType;
    protected final Class<?> grailsClassImpl;
    protected boolean allowAbstract;
    protected final String artefactSuffix;

    public ArtefactHandlerAdapter(String type, Class<? extends GrailsClass> grailsClassType, Class<?> grailsClassImpl, String artefactSuffix) {
        this.artefactSuffix = artefactSuffix;
        this.type = type;
        this.grailsClassType = grailsClassType;
        this.grailsClassImpl = grailsClassImpl;
    }

    public ArtefactHandlerAdapter(String type, Class<? extends GrailsClass> grailsClassType, Class<?> grailsClassImpl, String artefactSuffix, boolean allowAbstract) {
        this.artefactSuffix = artefactSuffix;
        this.type = type;
        this.grailsClassType = grailsClassType;
        this.grailsClassImpl = grailsClassImpl;
        this.allowAbstract = allowAbstract;
    }

    @Override
    public String getPluginName() {
        return GrailsNameUtils.getPropertyName((String)this.type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isArtefact(ClassNode classNode) {
        SourceUnit source = classNode.getModule().getContext();
        String filename = source.getName();
        if (filename == null) {
            return false;
        }
        URL url = null;
        FileSystemResource resource = new FileSystemResource(filename);
        if (resource.exists()) {
            try {
                url = resource.getURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (url == null) {
            return false;
        }
        try {
            UrlResource urlResource = new UrlResource(url);
            if (!this.isArtefactResource((Resource)urlResource)) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        int modifiers = classNode.getModifiers();
        String name = classNode.getName();
        if (this.isValidArtefactClassNode(classNode, modifiers)) {
            return name != null && this.artefactSuffix != null && name.endsWith(this.artefactSuffix);
        }
        return false;
    }

    protected boolean isValidArtefactClassNode(ClassNode classNode, int modifiers) {
        return !classNode.isEnum() && !classNode.isInterface() && !(classNode instanceof InnerClassNode);
    }

    protected boolean isArtefactResource(Resource resource) throws IOException {
        return GrailsResourceUtils.isGrailsResource((Resource)resource);
    }

    @Override
    public final boolean isArtefact(Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        try {
            if (this.isArtefactClass(aClass)) {
                return true;
            }
        }
        catch (Throwable t) {
            throw new GrailsRuntimeException("Failed to introspect class: " + aClass, t);
        }
        return false;
    }

    public boolean isArtefactClass(Class<?> clazz) {
        boolean ok;
        if (clazz == null) {
            return false;
        }
        boolean bl = ok = clazz.getName().endsWith(this.artefactSuffix) && !Closure.class.isAssignableFrom(clazz);
        if (ok && !this.allowAbstract) {
            ok = !Modifier.isAbstract(clazz.getModifiers());
        }
        return ok;
    }

    @Override
    public GrailsClass newArtefactClass(Class<?> artefactClass) {
        try {
            Constructor<?> c = this.grailsClassImpl.getDeclaredConstructor(Class.class);
            return (GrailsClass)c.newInstance(artefactClass);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new GrailsRuntimeException("Unable to locate constructor with Class parameter for " + artefactClass, e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new GrailsRuntimeException("Error instantiated artefact class [" + artefactClass + "] of type [" + this.grailsClassImpl + "]: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()), e);
        }
    }

    @Override
    public void initialize(ArtefactInfo artefacts) {
    }

    @Override
    public GrailsClass getArtefactForFeature(Object feature) {
        return null;
    }

    @Override
    public boolean isArtefactGrailsClass(GrailsClass artefactGrailsClass) {
        return this.grailsClassType.isAssignableFrom(artefactGrailsClass.getClass());
    }
}

