/*
 * Decompiled with CFR 0.152.
 */
package grails.core;

import grails.core.ArtefactInfo;
import grails.core.GrailsClass;
import grails.core.InjectableGrailsClass;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class DefaultArtefactInfo
implements ArtefactInfo {
    private final LinkedList<GrailsClass> grailsClasses = new LinkedList();
    private Class<?>[] classes;
    private Map<String, GrailsClass> grailsClassesByName = new LinkedHashMap<String, GrailsClass>();
    private Map<String, Class<?>> classesByName = new LinkedHashMap();
    private final Map<String, GrailsClass> logicalPropertyNameToClassMap = new HashMap<String, GrailsClass>();
    private GrailsClass[] grailsClassesArray;

    public synchronized void addGrailsClass(GrailsClass artefactClass) {
        this.addGrailsClassInternal(artefactClass, false);
    }

    private void addGrailsClassInternal(GrailsClass artefactClass, boolean atStart) {
        this.grailsClassesByName = new LinkedHashMap<String, GrailsClass>(this.grailsClassesByName);
        this.classesByName = new LinkedHashMap(this.classesByName);
        Class<?> actualClass = artefactClass.getClazz();
        boolean addToGrailsClasses = true;
        if (artefactClass instanceof InjectableGrailsClass) {
            addToGrailsClasses = ((InjectableGrailsClass)artefactClass).getAvailable();
        }
        if (addToGrailsClasses) {
            GrailsClass oldVersion = this.grailsClassesByName.put(actualClass.getName(), artefactClass);
            this.grailsClasses.remove(oldVersion);
        }
        this.classesByName.put(actualClass.getName(), actualClass);
        this.logicalPropertyNameToClassMap.put(artefactClass.getLogicalPropertyName(), artefactClass);
        if (!this.grailsClasses.contains(artefactClass)) {
            if (atStart) {
                this.grailsClasses.addFirst(artefactClass);
            } else {
                this.grailsClasses.addLast(artefactClass);
            }
        }
    }

    public synchronized void updateComplete() {
        this.grailsClassesByName = Collections.unmodifiableMap(this.grailsClassesByName);
        this.classesByName = Collections.unmodifiableMap(this.classesByName);
        this.grailsClassesArray = this.grailsClasses.toArray(new GrailsClass[0]);
        this.classes = this.classesByName.values().toArray(new Class[0]);
    }

    @Override
    public Class<?>[] getClasses() {
        return this.classes;
    }

    @Override
    public GrailsClass[] getGrailsClasses() {
        return this.grailsClassesArray;
    }

    @Override
    public Map<String, Class<?>> getClassesByName() {
        return this.classesByName;
    }

    @Override
    public Map<String, GrailsClass> getGrailsClassesByName() {
        return this.grailsClassesByName;
    }

    @Override
    public GrailsClass getGrailsClass(String name) {
        return this.grailsClassesByName.get(name);
    }

    @Override
    public GrailsClass getGrailsClassByLogicalPropertyName(String logicalName) {
        return this.logicalPropertyNameToClassMap.get(logicalName);
    }

    public void addOverridableGrailsClass(GrailsClass artefactGrailsClass) {
        this.addGrailsClassInternal(artefactGrailsClass, true);
    }
}

