/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config;

import grails.config.Config;
import grails.util.GrailsStringUtils;
import groovy.util.ConfigObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.config.NavigableMap;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public abstract class NavigableMapConfig
implements Config {
    protected static final Logger logger = LoggerFactory.getLogger(NavigableMapConfig.class);
    protected ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    protected ConfigurableConversionService conversionService = new DefaultConversionService();
    protected NavigableMap configMap = new NavigableMap(){

        @Override
        protected Object mergeMapEntry(NavigableMap targetMap, String sourceKey, Object newValue) {
            if (newValue instanceof CharSequence) {
                newValue = NavigableMapConfig.this.resolvePlaceholders(newValue.toString());
            }
            return super.mergeMapEntry(targetMap, sourceKey, newValue);
        }
    };

    @Override
    public int hashCode() {
        return this.configMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NavigableMapConfig) {
            return this.configMap.equals(((NavigableMapConfig)obj).configMap);
        }
        return false;
    }

    public String toString() {
        return this.configMap.toString();
    }

    @Override
    public Object getAt(Object key) {
        return this.get(key);
    }

    @Override
    public void setAt(Object key, Object value) {
        this.configMap.put(key.toString(), value);
    }

    @Override
    public int size() {
        return this.configMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.configMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsProperty(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.configMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.configMap.getProperty(key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        return this.configMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.configMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.configMap.putAll((Map<? extends String, ? extends Object>)m);
    }

    @Override
    public void clear() {
        this.configMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.configMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.configMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.configMap.entrySet();
    }

    @Override
    @Deprecated
    public Map<String, Object> flatten() {
        if (logger.isWarnEnabled()) {
            logger.warn("A plugin or your application called the flatten() method which can degrade startup performance");
        }
        return this.configMap;
    }

    @Override
    public Properties toProperties() {
        return this.configMap.toProperties();
    }

    @Override
    public Object navigate(String ... path) {
        return this.configMap.navigate(path);
    }

    @Override
    public Config merge(Map<String, Object> toMerge) {
        this.configMap.merge(toMerge, true);
        return this;
    }

    public Object asType(Class c) {
        if (c == Boolean.class || c == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return DefaultGroovyMethods.iterator((Object)this.configMap);
    }

    public boolean containsProperty(String key) {
        return this.getProperty(key, Object.class) != null;
    }

    public String getProperty(String key) {
        return this.getProperty(key, String.class);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key, String.class, defaultValue);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType) {
        return this.getProperty(key, targetType, null);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue, List<T> allowedValues) {
        T value = this.getProperty(key, targetType, defaultValue);
        if (!allowedValues.contains(value)) {
            throw new GrailsConfigurationException("Invalid configuration value [$value] for key [${key}]. Possible values $allowedValues");
        }
        return value;
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        Object value = this.findInSystemEnvironment(key);
        if (value == null) {
            value = this.getValueWithDotNotatedKeySupport(this.configMap, key);
        }
        if (value == null) {
            value = this.configMap.get(key);
        }
        return this.convertValueIfNecessary(value, targetType, defaultValue);
    }

    private Object findInSystemEnvironment(String key) {
        String propertyName = this.resolvePropertyName(key);
        return propertyName != null ? System.getenv(propertyName) : null;
    }

    private String resolvePropertyName(String name) {
        String resolvedName = this.checkPropertyName(name);
        if (resolvedName != null) {
            return resolvedName;
        }
        String uppercasedName = name.toUpperCase();
        if (!name.equals(uppercasedName) && (resolvedName = this.checkPropertyName(uppercasedName)) != null) {
            return resolvedName;
        }
        return name;
    }

    private String checkPropertyName(String name) {
        if (this.containsKey(name)) {
            return name;
        }
        String noDotName = name.replace('.', '_');
        if (!name.equals(noDotName) && this.containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name.replace('-', '_');
        if (!name.equals(noHyphenName) && this.containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noDotNoHyphenName = noDotName.replace('-', '_');
        if (!noDotName.equals(noDotNoHyphenName) && this.containsKey(noDotNoHyphenName)) {
            return noDotNoHyphenName;
        }
        return null;
    }

    private boolean containsKey(String name) {
        return System.getenv(name) != null;
    }

    private Map<Object, Object> convertToMap(NavigableMap from, IdentityHashMap<NavigableMap, Map<Object, Object>> cache) {
        if (cache.containsKey(from)) {
            return cache.get(from);
        }
        LinkedHashMap<Object, Object> to = new LinkedHashMap<Object, Object>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (entry.getValue() instanceof NavigableMap) {
                to.put(entry.getKey(), this.convertToMap((NavigableMap)entry.getValue(), cache));
                continue;
            }
            if (entry.getValue() instanceof List) {
                ArrayList<Map<Object, Object>> newList = new ArrayList<Map<Object, Object>>();
                for (Object o : (List)entry.getValue()) {
                    if (o instanceof NavigableMap) {
                        newList.add(this.convertToMap((NavigableMap)o, cache));
                        continue;
                    }
                    newList.add((Map<Object, Object>)o);
                }
                to.put(entry.getKey(), newList);
                continue;
            }
            to.put(entry.getKey(), entry.getValue());
        }
        cache.put(from, to);
        return to;
    }

    private ConfigObject convertPropsToMap(ConfigObject config) {
        for (Map.Entry entry : config.entrySet()) {
            IdentityHashMap<NavigableMap, Map<Object, Object>> cache = new IdentityHashMap<NavigableMap, Map<Object, Object>>();
            if (entry.getValue() instanceof NavigableMap) {
                config.setProperty((String)entry.getKey(), this.convertToMap((NavigableMap)entry.getValue(), cache));
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            ArrayList<Map<Object, Object>> newList = new ArrayList<Map<Object, Object>>();
            for (Object o : (List)entry.getValue()) {
                if (o instanceof NavigableMap) {
                    newList.add(this.convertToMap((NavigableMap)o, cache));
                    continue;
                }
                newList.add((Map<Object, Object>)o);
            }
            config.setProperty((String)entry.getKey(), newList);
        }
        return config;
    }

    private <T> T convertValueIfNecessary(Object originalValue, Class<T> targetType, T defaultValue) {
        block9: {
            if (originalValue != null) {
                if (targetType.isInstance(originalValue)) {
                    if (originalValue instanceof NavigableMap && targetType.equals(Map.class)) {
                        IdentityHashMap<NavigableMap, Map<Object, Object>> cache = new IdentityHashMap<NavigableMap, Map<Object, Object>>();
                        return (T)this.convertToMap((NavigableMap)originalValue, cache);
                    }
                    return (T)originalValue;
                }
                if (!(originalValue instanceof NavigableMap) || Map.class.isAssignableFrom(targetType)) {
                    try {
                        Object value = this.conversionService.convert(originalValue, targetType);
                        if (value instanceof ConfigObject) {
                            this.convertPropsToMap((ConfigObject)value);
                        }
                        return (T)(DefaultGroovyMethods.asBoolean((Object)value) ? value : defaultValue);
                    }
                    catch (ConversionException e) {
                        if (!targetType.isEnum()) break block9;
                        String stringValue = originalValue.toString();
                        try {
                            Object value = this.toEnumValue(targetType, stringValue);
                            return (T)value;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return defaultValue;
    }

    private Object toEnumValue(Class targetType, String stringValue) {
        return Enum.valueOf(targetType, stringValue.toUpperCase());
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.getProperty(key);
        if (GrailsStringUtils.isBlank((String)value)) {
            throw new IllegalStateException("Value for key [" + key + "] cannot be resolved");
        }
        return value;
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(key, targetType);
        if (value == null) {
            throw new IllegalStateException("Value for key [" + key + "] cannot be resolved");
        }
        return value;
    }

    private Object getValueWithDotNotatedKeySupport(NavigableMap configMap, String key) {
        if (key == null || configMap == null) {
            return null;
        }
        List<String> keys = this.convertTokensIntoArrayList(new StringTokenizer(key, "."));
        if (keys.size() == 0) {
            return null;
        }
        Object value = null;
        for (int i = 0; i < keys.size(); ++i) {
            if (i == 0) {
                value = configMap.get(keys.get(i));
                continue;
            }
            if (!(value instanceof Map)) continue;
            value = ((Map)value).get(keys.get(i));
        }
        return value;
    }

    private List<String> convertTokensIntoArrayList(StringTokenizer st) {
        ArrayList<String> elements = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            elements.add(st.nextToken());
        }
        return elements;
    }

    public static class ClassConversionException
    extends ConversionException {
        public ClassConversionException(Class<?> actual, Class<?> expected) {
            super(String.format("Actual type %s is not assignable to expected type %s", actual.getName(), expected.getName()));
        }

        public ClassConversionException(String actual, Class<?> expected, Exception ex) {
            super(String.format("Could not find/load class %s during attempt to convert to %s", actual, expected.getName()), (Throwable)ex);
        }
    }
}

