/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.web.controllers;

import grails.config.Config;
import grails.config.Settings;
import grails.core.GrailsApplication;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.grails.web.errors.GrailsExceptionResolver;
import org.grails.web.filters.HiddenHttpMethodFilter;
import org.grails.web.filters.OrderedHiddenHttpMethodFilter;
import org.grails.web.servlet.mvc.GrailsDispatcherServlet;
import org.grails.web.servlet.mvc.GrailsWebRequestFilter;
import org.grails.web.servlet.mvc.ParameterCreationListener;
import org.grails.web.servlet.mvc.TokenResponseActionResultTransformer;
import org.grails.web.servlet.view.CompositeViewResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletRegistrationBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class, DispatcherServletAutoConfiguration.class})
public class ControllersPluginConfiguration {
    @Bean
    public TokenResponseActionResultTransformer tokenResponseActionResultTransformer() {
        return new TokenResponseActionResultTransformer();
    }

    @Bean
    public FilterRegistrationBean<GrailsWebRequestFilter> grailsWebRequestFilter(ObjectProvider<ParameterCreationListener> parameterCreationListenerProvider) {
        GrailsWebRequestFilter filter = new GrailsWebRequestFilter();
        filter.setParameterCreationListeners((Collection)parameterCreationListenerProvider.stream().collect(Collectors.toList()));
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.INCLUDE});
        registration.setOrder(30);
        return registration;
    }

    @Bean
    public GrailsExceptionResolver exceptionHandler() {
        GrailsExceptionResolver exceptionResolver = new GrailsExceptionResolver();
        Properties exceptionMappings = new Properties();
        exceptionMappings.put("java.lang.Exception", "/error");
        exceptionResolver.setExceptionMappings(exceptionMappings);
        return exceptionResolver;
    }

    @Bean(name={"dispatcherServlet"})
    public GrailsDispatcherServlet dispatcherServlet() {
        return new GrailsDispatcherServlet();
    }

    @Bean(name={"dispatcherServletRegistration"})
    public DispatcherServletRegistrationBean dispatcherServletRegistration(ObjectProvider<GrailsApplication> grailsApplicationProvider, GrailsDispatcherServlet dispatcherServlet) {
        GrailsApplication grailsApplication = (GrailsApplication)grailsApplicationProvider.getIfAvailable();
        Config config = grailsApplication.getConfig();
        boolean isTomcat = ClassUtils.isPresent((String)"org.apache.catalina.startup.Tomcat", (ClassLoader)grailsApplication.getClassLoader());
        String grailsServletPath = config.getProperty("grails.web.servlet.path", isTomcat ? Settings.DEFAULT_TOMCAT_SERVLET_PATH : "/*");
        DispatcherServletRegistrationBean registration = new DispatcherServletRegistrationBean((DispatcherServlet)dispatcherServlet, grailsServletPath);
        registration.setLoadOnStartup(2);
        registration.setAsyncSupported(true);
        return registration;
    }

    @Bean
    public CompositeViewResolver compositeViewResolver(ObjectProvider<ViewResolver> viewResolverProviders) {
        CompositeViewResolver compositeViewResolver = new CompositeViewResolver();
        compositeViewResolver.setViewResolvers(viewResolverProviders.orderedStream().collect(Collectors.toList()));
        return compositeViewResolver;
    }

    @Bean
    public WebMvcConfigurer webMvcConfig(ObjectProvider<GrailsApplication> grailsApplicationProvider) {
        GrailsApplication grailsApplication = (GrailsApplication)grailsApplicationProvider.getIfAvailable();
        Config config = grailsApplication.getConfig();
        int resourcesCachePeriod = (Integer)config.getProperty("grails.resources.cachePeriod", Integer.class, (Object)0);
        boolean resourcesEnabled = (Boolean)config.getProperty("grails.resources.enabled", Boolean.class, (Object)true);
        String resourcesPattern = (String)config.getProperty("grails.resources.pattern", String.class, (Object)"/static/**");
        GrailsWebMvcConfigurer webMvcConfigurer = new GrailsWebMvcConfigurer(resourcesCachePeriod, resourcesEnabled, resourcesPattern);
        return webMvcConfigurer;
    }

    @Bean
    @ConditionalOnMissingBean(value={HiddenHttpMethodFilter.class})
    @ConditionalOnProperty(prefix="grails.web.hiddenmethod.filter", name={"enabled"}, matchIfMissing=true)
    public OrderedHiddenHttpMethodFilter hiddenHttpMethodFilter() {
        return new OrderedHiddenHttpMethodFilter();
    }

    static class GrailsWebMvcConfigurer
    implements WebMvcConfigurer {
        private static final String[] SERVLET_RESOURCE_LOCATIONS = new String[]{"/"};
        private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/resources/", "classpath:/resources/", "classpath:/static/", "classpath:/public/"};
        private static final String[] RESOURCE_LOCATIONS = new String[CLASSPATH_RESOURCE_LOCATIONS.length + SERVLET_RESOURCE_LOCATIONS.length];
        boolean addMappings = true;
        Integer cachePeriod;
        String resourcesPattern = "/static/**";

        GrailsWebMvcConfigurer(Integer cachePeriod, boolean addMappings, String resourcesPattern) {
            this.addMappings = addMappings;
            this.cachePeriod = cachePeriod;
            this.resourcesPattern = resourcesPattern;
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            if (!this.addMappings) {
                return;
            }
            if (!registry.hasMappingForPattern("/webjars/**")) {
                registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).setCachePeriod(this.cachePeriod);
            }
            if (!registry.hasMappingForPattern(this.resourcesPattern)) {
                registry.addResourceHandler(new String[]{this.resourcesPattern}).addResourceLocations(RESOURCE_LOCATIONS).setCachePeriod(this.cachePeriod);
            }
        }

        static {
            System.arraycopy(SERVLET_RESOURCE_LOCATIONS, 0, RESOURCE_LOCATIONS, 0, SERVLET_RESOURCE_LOCATIONS.length);
            System.arraycopy(CLASSPATH_RESOURCE_LOCATIONS, 0, RESOURCE_LOCATIONS, SERVLET_RESOURCE_LOCATIONS.length, CLASSPATH_RESOURCE_LOCATIONS.length);
        }
    }
}

