/*
 * Decompiled with CFR 0.152.
 */
package grails.rest.render.atom;

import grails.converters.XML;
import grails.rest.Link;
import grails.rest.render.RenderContext;
import grails.rest.render.hal.HalXmlRenderer;
import grails.web.mime.MimeType;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.web.xml.PrettyPrintXMLStreamWriter;
import org.grails.web.xml.StreamingMarkupWriter;
import org.grails.web.xml.XMLStreamWriter;
import org.springframework.http.HttpMethod;

public class AtomRenderer<T>
extends HalXmlRenderer<T> {
    public static final MimeType MIME_TYPE;
    public static final SimpleDateFormat ATOM_DATE_FORMAT;
    public static final String FEED_TAG = "feed";
    public static final String ENTRY_TAG = "entry";
    public static final String XMLNS_ATTRIBUTE = "xmlns";
    public static final String PUBLISHED_TAG = "published";
    public static final String UPDATED_TAG = "updated";
    public static final String ID_TAG = "id";
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final SimpleDateFormat ID_DATE_FORMAT;
    public static final String RELATIONSHIP_ALTERNATE = "alternate";
    public static final MimeType[] DEFAULT_ATOM_MIME_TYPES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AtomRenderer(Class<T> targetType) {
        super(targetType, DEFAULT_ATOM_MIME_TYPES);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void renderInternal(T object, RenderContext context) {
        StreamingMarkupWriter streamingWriter = new StreamingMarkupWriter(context.getWriter(), this.getEncoding());
        PrettyPrintXMLStreamWriter w = this.isPrettyPrint() ? new PrettyPrintXMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter) : new XMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter);
        XML xml = new XML((XMLStreamWriter)w);
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(object.getClass().getName());
        boolean isDomain = entity != null;
        CallSite writtenObjects = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        w.startDocument(this.getEncoding(), "1.0");
        if (isDomain) {
            this.writeDomainWithEmbeddedAndLinks(entity, object, context, xml, (Set)((Object)writtenObjects));
        } else if (object instanceof Collection) {
            Locale locale = context.getLocale();
            String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uri", context.getResourcePath(), "method", HttpMethod.GET, "absolute", true}));
            String title = this.getResourceTitle(context.getResourcePath(), locale);
            XMLStreamWriter writer = xml.getWriter();
            writer.startNode(FEED_TAG).attribute(XMLNS_ATTRIBUTE, ATOM_NAMESPACE).startNode(TITLE_ATTRIBUTE).characters(title).end().startNode(ID_TAG).characters(this.generateIdForURI(resourceHref)).end();
            Link linkSelf = new Link(RELATIONSHIP_SELF, resourceHref);
            String string = title;
            linkSelf.setTitle(string);
            String string2 = ((MimeType)BytecodeInterface8.objectArrayGet((Object[])this.getMimeTypes(), (int)0)).getName();
            linkSelf.setContentType(string2);
            Locale locale2 = locale;
            linkSelf.setHreflang(locale2);
            this.writeLink(linkSelf, locale, xml);
            Link linkAlt = new Link(RELATIONSHIP_ALTERNATE, resourceHref);
            String string3 = title;
            linkAlt.setTitle(string3);
            Locale locale3 = locale;
            linkAlt.setHreflang(locale3);
            this.writeLink(linkAlt, locale, xml);
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, object);
            Object o = null;
            Iterator iterator = callSite != null ? callSite.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    o = iterator.next();
                    PersistentEntity currentEntity = this.getMappingContext().getPersistentEntity(o.getClass().getName());
                    PersistentEntity persistentEntity = currentEntity;
                    if ((persistentEntity == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentEntity)) != false) {
                        this.writeDomainWithEmbeddedAndLinks(currentEntity, o, context, xml, (Set)((Object)writtenObjects), false);
                        continue;
                    }
                    throw (Throwable)new IllegalArgumentException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{o}, new String[]{"Cannot render object [", "] using Atom. "}).plus("The AtomRenderer can only be used with domain classes that specify 'dateCreated' and 'lastUpdated' properties"))));
                }
            }
            writer.end();
            context.getWriter().flush();
        } else {
            throw (Throwable)new IllegalArgumentException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{object}, new String[]{"Cannot render object [", "] using Atom. "}).plus("The AtomRenderer can only be used with domain classes that specify 'dateCreated' and 'lastUpdated' properties"))));
        }
    }

    public String generateIdForURI(String url, Date dateCreated, Object id) {
        if (((String)url).startsWith("http")) {
            url = ((String)url).substring(((String)url).indexOf("//") + 2, ((String)url).length());
        }
        url = ((String)url).replace("#", "/");
        int i = ((String)url).indexOf("/");
        if (i > -1) {
            Object object;
            Object dateCreatedId = "";
            Date date = dateCreated;
            if ((date == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, date)) != false) {
                dateCreatedId = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{ID_DATE_FORMAT.format(dateCreated)}, new String[]{",", ""}));
            }
            url = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((String)url).substring(0, i), dateCreatedId, IndyInterface.bootstrap("cast", "()", 0, object = id) != false ? object : ((String)url).substring(i, ((String)url).length())}, new String[]{"", "", ":", ""}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{url}, new String[]{"tag:", ""}));
    }

    protected void writeDomainWithEmbeddedAndLinks(PersistentEntity entity, Object object, RenderContext context, XML xml, Set writtenObjects, boolean isFirst) {
        PersistentProperty persistentProperty = entity.getPropertyByName("lastUpdated");
        if ((persistentProperty == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentProperty)) == false) {
            throw (Throwable)new IllegalArgumentException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{object}, new String[]{"Cannot render object [", "] using Atom. "}).plus("The AtomRenderer can only be used with domain classes that specify 'dateCreated' and 'lastUpdated' properties"))));
        }
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"resource", object, "method", HttpMethod.GET, "absolute", true}));
        String title = this.getLinkTitle(entity, locale);
        XMLStreamWriter writer = xml.getWriter();
        writer.startNode(isFirst ? FEED_TAG : ENTRY_TAG);
        if (isFirst) {
            writer.attribute(XMLNS_ATTRIBUTE, ATOM_NAMESPACE);
        }
        PersistentProperty persistentProperty2 = entity.getPropertyByName(TITLE_ATTRIBUTE);
        if ((persistentProperty2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentProperty2)) == false) {
            writer.startNode(TITLE_ATTRIBUTE).characters(DefaultGroovyMethods.toString((Object)object)).end();
        }
        String dateCreated = this.formatDateCreated(object);
        String string = dateCreated;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            writer.startNode(PUBLISHED_TAG).characters(dateCreated).end();
        }
        String lastUpdated = this.formatLastUpdated(object);
        String string2 = lastUpdated;
        if ((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false) {
            writer.startNode(UPDATED_TAG).characters(lastUpdated).end();
        }
        writer.startNode(ID_TAG).characters(this.getObjectId(entity, object)).end();
        Link linkSelf = new Link(RELATIONSHIP_SELF, resourceHref);
        String string3 = title;
        linkSelf.setTitle(string3);
        String string4 = ((MimeType)BytecodeInterface8.objectArrayGet((Object[])this.getMimeTypes(), (int)0)).getName();
        linkSelf.setContentType(string4);
        Locale locale2 = locale;
        linkSelf.setHreflang(locale2);
        this.writeLink(linkSelf, locale, xml);
        Link linkAlt = new Link(RELATIONSHIP_ALTERNATE, resourceHref);
        String string5 = title;
        linkAlt.setTitle(string5);
        Locale locale3 = locale;
        linkAlt.setHreflang(locale3);
        this.writeLink(linkAlt, locale, xml);
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(entity.getJavaClass());
        Map<Association, Object> associationMap = this.writeAssociationLinks(context, object, locale, xml, entity, metaClass);
        this.writeDomain(context, metaClass, entity, object, xml);
        Map<Association, Object> map = associationMap;
        if ((map == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, map)) != false) {
            Set<Map.Entry<Association, Object>> set = associationMap.entrySet();
            Iterator<Map.Entry<Association, Object>> iterator = set != null ? set.iterator() : null;
            Map.Entry<Association, Object> entry = null;
            Iterator<Map.Entry<Association, Object>> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    CallSite property = IndyInterface.bootstrap("cast", "()", 0, entry.getKey());
                    boolean isSingleEnded = property instanceof ToOne;
                    if (isSingleEnded) {
                        Object value = entry.getValue();
                        if (writtenObjects.contains(value) || !(value != null)) continue;
                        PersistentEntity associatedEntity = property.getAssociatedEntity();
                        PersistentEntity persistentEntity = associatedEntity;
                        if ((persistentEntity == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentEntity)) == false) continue;
                        DefaultGroovyMethods.leftShift((Set)writtenObjects, (Object)value);
                        this.writeDomainWithEmbeddedAndLinks(associatedEntity, value, context, xml, writtenObjects, false);
                        continue;
                    }
                    PersistentEntity associatedEntity = property.getAssociatedEntity();
                    PersistentEntity persistentEntity = associatedEntity;
                    if ((persistentEntity == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentEntity)) == false) continue;
                    writer.startNode(property.getName());
                    Object obj = null;
                    Iterator iterator3 = DefaultGroovyMethods.iterator((Object)entry.getValue());
                    if (iterator3 != null) {
                        while (iterator3.hasNext()) {
                            obj = iterator3.next();
                            DefaultGroovyMethods.leftShift((Set)writtenObjects, obj);
                            this.writeDomainWithEmbeddedAndLinks(associatedEntity, obj, context, xml, writtenObjects, false);
                        }
                    }
                    writer.end();
                }
            }
        }
        writer.end();
    }

    public String getObjectId(PersistentEntity entity, Object object) {
        CallSite name = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "identity", 0, entity)));
        CallSite objectId = IndyInterface.bootstrap("invoke", "getAt", 0, object, name);
        CallSite dateCreated = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "dateCreated", 0, object));
        CallSite url = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "link", 0, IndyInterface.bootstrap("getProperty", "linkGenerator", 12, this), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"resource", object, "method", IndyInterface.bootstrap("getProperty", "GET", 0, HttpMethod.class), "absolute", true})));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "generateIdForURI", 2, this, url, dateCreated, objectId));
    }

    protected String formatDateCreated(Object object) {
        CallSite dateCreated = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "dateCreated", 0, object));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)dateCreated, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatAtomDate", 2, this, dateCreated));
        }
        return null;
    }

    protected String formatLastUpdated(Object object) {
        CallSite lastUpdated = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "lastUpdated", 0, object));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)lastUpdated, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatAtomDate", 2, this, lastUpdated));
        }
        return null;
    }

    protected String formatAtomDate(Date dateCreated) {
        String dateFormat = ATOM_DATE_FORMAT.format(dateCreated);
        return StringGroovyMethods.plus((String)dateFormat.substring(0, 19), (CharSequence)dateFormat.substring(22, dateFormat.length()));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AtomRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public String generateIdForURI(String url, Date dateCreated) {
        return this.generateIdForURI(url, dateCreated, null);
    }

    @Generated
    public String generateIdForURI(String url) {
        return this.generateIdForURI(url, null, null);
    }

    @Override
    @Generated
    protected void writeDomainWithEmbeddedAndLinks(PersistentEntity entity, Object object, RenderContext context, XML xml, Set writtenObjects) {
        this.writeDomainWithEmbeddedAndLinks(entity, object, context, xml, writtenObjects, true);
    }

    static {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        MimeType mimeType;
        MIME_TYPE = mimeType = MimeType.ATOM_XML;
        ATOM_DATE_FORMAT = simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        ID_DATE_FORMAT = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        MimeType[] mimeTypeArray = new MimeType[]{MIME_TYPE};
        DEFAULT_ATOM_MIME_TYPES = mimeTypeArray;
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$5$renderInternal(Object object, RenderContext renderContext) {
        super.renderInternal(object, renderContext);
    }

    public /* synthetic */ void super$5$writeDomainWithEmbeddedAndLinks(PersistentEntity persistentEntity, Object object, RenderContext renderContext, XML xML, Set set) {
        super.writeDomainWithEmbeddedAndLinks(persistentEntity, object, renderContext, xML, set);
    }
}

