/*
 * Decompiled with CFR 0.152.
 */
package grails.rest.render.hal;

import grails.converters.XML;
import grails.rest.Link;
import grails.rest.render.RenderContext;
import grails.rest.render.util.AbstractLinkingRenderer;
import grails.web.mime.MimeType;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.beans.PropertyDescriptor;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.web.xml.PrettyPrintXMLStreamWriter;
import org.grails.web.xml.StreamingMarkupWriter;
import org.grails.web.xml.XMLStreamWriter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.http.HttpMethod;

public class HalXmlRenderer<T>
extends AbstractLinkingRenderer<T> {
    public static final MimeType MIME_TYPE;
    public static final String RESOURCE_TAG = "resource";
    public static final String LINK_TAG = "link";
    public static final String RELATIONSHIP_ATTRIBUTE = "rel";
    private static final MimeType[] DEFAULT_MIME_TYPES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public HalXmlRenderer(Class<T> targetType) {
        super(targetType, DEFAULT_MIME_TYPES);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public HalXmlRenderer(Class<T> targetType, MimeType mimeType) {
        super(targetType, mimeType);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public HalXmlRenderer(Class<T> targetType, MimeType ... mimeTypes) {
        super(targetType, mimeTypes);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void renderInternal(T object, RenderContext context) {
        StreamingMarkupWriter streamingWriter = new StreamingMarkupWriter(context.getWriter(), this.getEncoding());
        PrettyPrintXMLStreamWriter w = this.isPrettyPrint() ? new PrettyPrintXMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter) : new XMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter);
        XML xml = new XML((XMLStreamWriter)w);
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(object.getClass().getName());
        boolean isDomain = entity != null;
        CallSite writtenObjects = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        w.startDocument(this.getEncoding(), "1.0");
        if (isDomain) {
            this.writeDomainWithEmbeddedAndLinks(entity, object, context, xml, (Set)((Object)writtenObjects));
        } else if (object instanceof Collection) {
            XMLStreamWriter writer = xml.getWriter();
            this.startResourceTagForCurrentPath(context, writer);
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, object);
            Object o = null;
            Iterator iterator = callSite != null ? callSite.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    o = iterator.next();
                    PersistentEntity currentEntity = this.getMappingContext().getPersistentEntity(o.getClass().getName());
                    PersistentEntity persistentEntity = currentEntity;
                    if ((persistentEntity == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentEntity)) == false) continue;
                    this.writeDomainWithEmbeddedAndLinks(currentEntity, o, context, xml, (Set)((Object)writtenObjects));
                }
            }
            writer.end();
        } else {
            XMLStreamWriter writer = xml.getWriter();
            this.startResourceTagForCurrentPath(context, writer);
            this.writeExtraLinks(object, context.getLocale(), xml);
            BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess(object);
            PropertyDescriptor[] propertyDescriptors = bean.getPropertyDescriptors();
            PropertyDescriptor pd2 = null;
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
            if (propertyDescriptors != null) {
                for (PropertyDescriptor pd2 : propertyDescriptorArray) {
                    String propertyName = pd2.getName();
                    if (DEFAULT_EXCLUDES.contains(propertyName) || !this.shouldIncludeProperty(context, object, propertyName) || !(DefaultTypeTransformation.booleanUnbox((Object)pd2.getReadMethod()) && DefaultTypeTransformation.booleanUnbox((Object)pd2.getWriteMethod()))) continue;
                    writer.startNode(propertyName);
                    xml.convertAnother(bean.getPropertyValue(propertyName));
                    writer.end();
                }
            }
            writer.end();
        }
    }

    protected void startResourceTagForCurrentPath(RenderContext context, XMLStreamWriter writer) {
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uri", context.getResourcePath(), "method", HttpMethod.GET, "absolute", this.isAbsoluteLinks()}));
        String title = this.getResourceTitle(context.getResourcePath(), locale);
        this.startResourceTag(writer, resourceHref, locale, title);
    }

    protected void writeDomainWithEmbeddedAndLinks(PersistentEntity entity, Object object, RenderContext context, XML xml, Set writtenObjects) {
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{RESOURCE_TAG, object, "method", HttpMethod.GET, "absolute", this.isAbsoluteLinks()}));
        String title = this.getLinkTitle(entity, locale);
        XMLStreamWriter writer = xml.getWriter();
        this.startResourceTag(writer, resourceHref, locale, title);
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(entity.getJavaClass());
        Map<Association, Object> associationMap = this.writeAssociationLinks(context, object, locale, xml, entity, metaClass);
        this.writeDomain(context, metaClass, entity, object, xml);
        Map<Association, Object> map = associationMap;
        if ((map == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, map)) != false) {
            Set<Map.Entry<Association, Object>> set = associationMap.entrySet();
            Iterator<Map.Entry<Association, Object>> iterator = set != null ? set.iterator() : null;
            Map.Entry<Association, Object> entry = null;
            Iterator<Map.Entry<Association, Object>> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    CallSite property = IndyInterface.bootstrap("cast", "()", 0, entry.getKey());
                    boolean isSingleEnded = property instanceof ToOne;
                    if (isSingleEnded) {
                        Object value = entry.getValue();
                        if (writtenObjects.contains(value) || !(value != null)) continue;
                        PersistentEntity associatedEntity = property.getAssociatedEntity();
                        PersistentEntity persistentEntity = associatedEntity;
                        if ((persistentEntity == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentEntity)) == false) continue;
                        DefaultGroovyMethods.leftShift((Set)writtenObjects, (Object)value);
                        this.writeDomainWithEmbeddedAndLinks(associatedEntity, value, context, xml, writtenObjects);
                        continue;
                    }
                    PersistentEntity associatedEntity = property.getAssociatedEntity();
                    PersistentEntity persistentEntity = associatedEntity;
                    if ((persistentEntity == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, persistentEntity)) == false) continue;
                    Object obj = null;
                    Iterator iterator3 = DefaultGroovyMethods.iterator((Object)entry.getValue());
                    if (iterator3 == null) continue;
                    while (iterator3.hasNext()) {
                        obj = iterator3.next();
                        DefaultGroovyMethods.leftShift((Set)writtenObjects, obj);
                        this.writeDomainWithEmbeddedAndLinks(associatedEntity, obj, context, xml, writtenObjects);
                    }
                }
            }
        }
        writer.end();
    }

    protected void startResourceTag(XMLStreamWriter writer, String resourceHref, Locale locale, String title) {
        writer.startNode(RESOURCE_TAG).attribute(HREF_ATTRIBUTE, resourceHref).attribute(HREFLANG_ATTRIBUTE, locale.getLanguage());
        String string = title;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            writer.attribute(TITLE_ATTRIBUTE, title);
        }
    }

    @Override
    public void writeLink(Link link, Locale locale, Object writerObject) {
        Locale locale2;
        XMLStreamWriter writer = IndyInterface.bootstrap("cast", "()", 0, writerObject).getWriter();
        writer.startNode(LINK_TAG).attribute(RELATIONSHIP_ATTRIBUTE, link.getRel()).attribute(HREF_ATTRIBUTE, link.getHref()).attribute(HREFLANG_ATTRIBUTE, (IndyInterface.bootstrap("cast", "()", 0, locale2 = link.getHreflang()) != false ? locale2 : locale).getLanguage());
        String title = link.getTitle();
        String string = title;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            writer.attribute(TITLE_ATTRIBUTE, title);
        }
        String contentType = link.getContentType();
        String string2 = contentType;
        if ((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false) {
            writer.attribute(TYPE_ATTRIBUTE, contentType);
        }
        if (link.isTemplated()) {
            writer.attribute(TEMPLATED_ATTRIBUTE, "true");
        }
        if (link.isDeprecated()) {
            writer.attribute(DEPRECATED_ATTRIBUTE, "true");
        }
        writer.end();
    }

    @Override
    protected void writeDomainProperty(Object value, String propertyName, Object writerObject) {
        CallSite xml = IndyInterface.bootstrap("cast", "()", 0, writerObject);
        XMLStreamWriter writer = xml.getWriter();
        writer.startNode(propertyName);
        xml.convertAnother(value);
        writer.end();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HalXmlRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        MimeType mimeType;
        MIME_TYPE = mimeType = MimeType.HAL_XML;
        MimeType[] mimeTypeArray = new MimeType[]{MIME_TYPE};
        DEFAULT_MIME_TYPES = mimeTypeArray;
    }
}

