/*
 * Decompiled with CFR 0.152.
 */
package grails.validation;

import grails.compiler.ast.GrailsArtefactClassInjector;
import grails.gorm.validation.ConstrainedProperty;
import grails.util.GrailsNameUtils;
import grails.validation.ASTValidateableHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.syntax.Token;
import org.grails.compiler.injection.ASTValidationErrorsHelper;
import org.grails.web.plugins.support.ValidationSupport;

public class DefaultASTValidateableHelper
implements ASTValidateableHelper {
    private static final String CONSTRAINED_PROPERTIES_PROPERTY_NAME = "$constraints";
    private static final String VALIDATE_METHOD_NAME = "validate";

    @Override
    public void injectValidateableCode(ClassNode classNode, boolean defaultNullable) {
        ASTValidationErrorsHelper errorsHelper = new ASTValidationErrorsHelper();
        errorsHelper.injectErrorsCode(classNode);
        this.addConstraintsField(classNode);
        this.addStaticInitializer(classNode);
        this.addGetConstraintsMethod(classNode, defaultNullable);
        this.addValidateMethod(classNode);
    }

    protected void addConstraintsField(ClassNode classNode) {
        FieldNode field = classNode.getField(CONSTRAINED_PROPERTIES_PROPERTY_NAME);
        if (field == null || !field.getDeclaringClass().equals((Object)classNode)) {
            classNode.addField(CONSTRAINED_PROPERTIES_PROPERTY_NAME, 10, new ClassNode(Map.class), (Expression)new ConstantExpression(null));
        }
    }

    private void addStaticInitializer(ClassNode classNode) {
        BinaryExpression nullOutConstrainedPropertiesExpression = new BinaryExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new ConstantExpression(null));
        ArrayList<ExpressionStatement> statements = new ArrayList<ExpressionStatement>();
        statements.add(new ExpressionStatement((Expression)nullOutConstrainedPropertiesExpression));
        classNode.addStaticInitializerStatements(statements, true);
    }

    protected void addGetConstraintsMethod(ClassNode classNode, boolean defaultNullable) {
        String getConstraintsMethodName = "getConstraints";
        MethodNode getConstraintsMethod = classNode.getMethod(getConstraintsMethodName, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (getConstraintsMethod == null || !getConstraintsMethod.getDeclaringClass().equals((Object)classNode)) {
            BooleanExpression isConstraintsPropertyNull = new BooleanExpression((Expression)new BinaryExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol((int)123, (int)0, (int)0), (Expression)new ConstantExpression(null)));
            BlockStatement ifConstraintsPropertyIsNullBlockStatement = new BlockStatement();
            ArgumentListExpression getConstrainedPropertiesForClassArguments = new ArgumentListExpression();
            getConstrainedPropertiesForClassArguments.addExpression((Expression)new VariableExpression("this"));
            getConstrainedPropertiesForClassArguments.addExpression((Expression)new ConstantExpression((Object)defaultNullable));
            StaticMethodCallExpression getConstraintsMethodCall = new StaticMethodCallExpression(ClassHelper.make(ValidationSupport.class), "getConstrainedPropertiesForClass", (Expression)getConstrainedPropertiesForClassArguments);
            BinaryExpression initializeConstraintsFieldExpression = new BinaryExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol((int)100, (int)0, (int)0), (Expression)getConstraintsMethodCall);
            IfStatement ifConstraintsPropertyIsNullStatement = new IfStatement(isConstraintsPropertyNull, (Statement)ifConstraintsPropertyIsNullBlockStatement, (Statement)new ExpressionStatement((Expression)new EmptyExpression()));
            ifConstraintsPropertyIsNullBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)initializeConstraintsFieldExpression));
            if (!defaultNullable) {
                Map<String, ClassNode> propertiesToConstrain = this.getPropertiesToEnsureConstraintsFor(classNode);
                for (Map.Entry<String, ClassNode> entry : propertiesToConstrain.entrySet()) {
                    String propertyName = entry.getKey();
                    ClassNode propertyType = entry.getValue();
                    String cpName = "$" + propertyName + "$constrainedProperty";
                    ArgumentListExpression constrainedPropertyConstructorArgumentList = new ArgumentListExpression();
                    constrainedPropertyConstructorArgumentList.addExpression((Expression)new ClassExpression(classNode));
                    constrainedPropertyConstructorArgumentList.addExpression((Expression)new ConstantExpression((Object)propertyName));
                    constrainedPropertyConstructorArgumentList.addExpression((Expression)new ClassExpression(propertyType));
                    ConstructorCallExpression constrainedPropertyCtorCallExpression = new ConstructorCallExpression(new ClassNode(ConstrainedProperty.class), (Expression)constrainedPropertyConstructorArgumentList);
                    DeclarationExpression declareConstrainedPropertyExpression = new DeclarationExpression(new VariableExpression(cpName, ClassHelper.OBJECT_TYPE), Token.newSymbol((int)100, (int)0, (int)0), (Expression)constrainedPropertyCtorCallExpression);
                    ArgumentListExpression applyConstraintMethodArgumentList = new ArgumentListExpression();
                    applyConstraintMethodArgumentList.addExpression((Expression)new ConstantExpression((Object)"nullable"));
                    applyConstraintMethodArgumentList.addExpression((Expression)new ConstantExpression((Object)defaultNullable));
                    MethodCallExpression applyNullableConstraintMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(cpName), "applyConstraint", (Expression)applyConstraintMethodArgumentList);
                    ArgumentListExpression putMethodArgumentList = new ArgumentListExpression();
                    putMethodArgumentList.addExpression((Expression)new ConstantExpression((Object)propertyName));
                    putMethodArgumentList.addExpression((Expression)new VariableExpression(cpName));
                    MethodCallExpression addToConstraintsMapExpression = new MethodCallExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), "put", (Expression)putMethodArgumentList);
                    BlockStatement addNullableConstraintBlock = new BlockStatement();
                    addNullableConstraintBlock.addStatement((Statement)new ExpressionStatement((Expression)declareConstrainedPropertyExpression));
                    addNullableConstraintBlock.addStatement((Statement)new ExpressionStatement((Expression)applyNullableConstraintMethodCallExpression));
                    addNullableConstraintBlock.addStatement((Statement)new ExpressionStatement((Expression)addToConstraintsMapExpression));
                    MethodCallExpression constraintsMapContainsKeyExpression = new MethodCallExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME, ClassHelper.make(Map.class)), "containsKey", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)propertyName)));
                    BooleanExpression ifPropertyIsAlreadyConstrainedExpression = new BooleanExpression((Expression)constraintsMapContainsKeyExpression);
                    IfStatement ifPropertyIsAlreadyConstrainedStatement = new IfStatement(ifPropertyIsAlreadyConstrainedExpression, (Statement)new ExpressionStatement((Expression)new EmptyExpression()), (Statement)addNullableConstraintBlock);
                    ifConstraintsPropertyIsNullBlockStatement.addStatement((Statement)ifPropertyIsAlreadyConstrainedStatement);
                }
            }
            BlockStatement methodBlockStatement = new BlockStatement();
            methodBlockStatement.addStatement((Statement)ifConstraintsPropertyIsNullStatement);
            ReturnStatement returnStatement = new ReturnStatement((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME));
            methodBlockStatement.addStatement((Statement)returnStatement);
            MethodNode methodNode = new MethodNode(getConstraintsMethodName, 9, new ClassNode(Map.class), GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)methodBlockStatement);
            if (classNode.redirect() == null) {
                classNode.addMethod(methodNode);
                AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)methodNode);
            } else {
                classNode.redirect().addMethod(methodNode);
                AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode.redirect(), (AnnotatedNode)methodNode);
            }
        }
    }

    protected Map<String, ClassNode> getPropertiesToEnsureConstraintsFor(ClassNode classNode) {
        HashMap<String, ClassNode> fieldsToConstrain = new HashMap<String, ClassNode>();
        List allFields = classNode.getFields();
        for (Object field : allFields) {
            PropertyNode propertyNode;
            if (field.isStatic() || (propertyNode = classNode.getProperty(field.getName())) == null) continue;
            fieldsToConstrain.put(field.getName(), field.getType());
        }
        Map declaredMethodsMap = classNode.getDeclaredMethodsMap();
        for (Map.Entry entry : declaredMethodsMap.entrySet()) {
            String methodName;
            Parameter[] parameters;
            MethodNode value = (MethodNode)entry.getValue();
            if (value.isStatic() || !value.isPublic() || !classNode.equals((Object)value.getDeclaringClass()) || value.getLineNumber() <= 0 || (parameters = value.getParameters()) != null && parameters.length != 0 || !(methodName = value.getName()).startsWith("get")) continue;
            ClassNode returnType = value.getReturnType();
            String restOfMethodName = methodName.substring(3);
            String propertyName = GrailsNameUtils.getPropertyName((String)restOfMethodName);
            fieldsToConstrain.put(propertyName, returnType);
        }
        ClassNode superClass = classNode.getSuperClass();
        if (!superClass.equals((Object)new ClassNode(Object.class))) {
            fieldsToConstrain.putAll(this.getPropertiesToEnsureConstraintsFor(superClass));
        }
        return fieldsToConstrain;
    }

    protected void addValidateMethod(ClassNode classNode) {
        MethodNode noArgValidateMethod;
        String fieldsToValidateParameterName = "$fieldsToValidate";
        MethodNode listArgValidateMethod = classNode.getMethod(VALIDATE_METHOD_NAME, new Parameter[]{new Parameter(new ClassNode(List.class), fieldsToValidateParameterName)});
        if (listArgValidateMethod == null) {
            BlockStatement validateMethodCode = new BlockStatement();
            ArgumentListExpression validateInstanceArguments = new ArgumentListExpression();
            validateInstanceArguments.addExpression((Expression)new VariableExpression("this"));
            validateInstanceArguments.addExpression((Expression)new VariableExpression(fieldsToValidateParameterName, ClassHelper.LIST_TYPE));
            ClassNode validationSupportClassNode = ClassHelper.make(ValidationSupport.class);
            StaticMethodCallExpression invokeValidateInstanceExpression = new StaticMethodCallExpression(validationSupportClassNode, "validateInstance", (Expression)validateInstanceArguments);
            validateMethodCode.addStatement((Statement)new ExpressionStatement((Expression)invokeValidateInstanceExpression));
            Parameter fieldsToValidateParameter = new Parameter(new ClassNode(List.class), fieldsToValidateParameterName);
            MethodNode methodNode = new MethodNode(VALIDATE_METHOD_NAME, 1, ClassHelper.boolean_TYPE, new Parameter[]{fieldsToValidateParameter}, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)validateMethodCode);
            classNode.addMethod(methodNode);
            AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)methodNode);
        }
        if ((noArgValidateMethod = classNode.getMethod(VALIDATE_METHOD_NAME, GrailsArtefactClassInjector.ZERO_PARAMETERS)) == null) {
            BlockStatement validateMethodCode = new BlockStatement();
            ArgumentListExpression validateInstanceArguments = new ArgumentListExpression();
            validateInstanceArguments.addExpression((Expression)new CastExpression(new ClassNode(List.class), (Expression)new ConstantExpression(null)));
            MethodCallExpression callListArgValidateMethod = new MethodCallExpression((Expression)new VariableExpression("this"), VALIDATE_METHOD_NAME, (Expression)validateInstanceArguments);
            validateMethodCode.addStatement((Statement)new ReturnStatement((Expression)callListArgValidateMethod));
            MethodNode methodNode = new MethodNode(VALIDATE_METHOD_NAME, 1, ClassHelper.boolean_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)validateMethodCode);
            classNode.addMethod(methodNode);
            AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)methodNode);
        }
    }
}

