/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring.context.support;

import grails.core.GrailsApplication;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.PriorityOrdered;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public class GrailsBeanPropertyOverrideConfigurer
implements BeanFactoryPostProcessor,
PriorityOrdered {
    private final GrailsApplication grailsApplication;
    private int order = Integer.MAX_VALUE;

    public GrailsBeanPropertyOverrideConfigurer(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) {
        Map<String, Object> beans = this.getBeansConfig();
        if (beans == null) {
            return;
        }
        for (String beanName : beans.keySet()) {
            Object beanProperties = beans.get(beanName);
            if (beanProperties instanceof Map) {
                Map beanPropertiesMap = (Map)beanProperties;
                for (Object beanPropertyName : beanPropertiesMap.keySet()) {
                    String beanPropertyValue = beanPropertiesMap.get(beanPropertyName).toString();
                    this.applyPropertyValue(factory, beanName, beanPropertyName.toString(), beanPropertyValue);
                }
                continue;
            }
            throw new IllegalArgumentException("Entry in bean config for bean '$beanName' must be a Map");
        }
    }

    protected Map<String, Object> getBeansConfig() {
        return (Map)this.grailsApplication.getConfig().getProperty("beans", Map.class);
    }

    protected void applyPropertyValue(ConfigurableListableBeanFactory factory, String beanName, String property, String value) {
        BeanDefinition bd;
        BeanDefinition bdToUse = bd = this.getTargetBeanDefinition(factory, beanName);
        while (bd != null) {
            bdToUse = bd;
            bd = bd.getOriginatingBeanDefinition();
        }
        PropertyValue pv = new PropertyValue(property, (Object)value);
        pv.setOptional(true);
        if (bdToUse != null) {
            bdToUse.getPropertyValues().addPropertyValue(pv);
        }
    }

    protected BeanDefinition getTargetBeanDefinition(ConfigurableListableBeanFactory factory, String beanName) {
        if (factory.containsBeanDefinition(beanName)) {
            return this.getTargetBeanDefinition(factory, beanName, factory.getBeanDefinition(beanName));
        }
        return null;
    }

    protected BeanDefinition getTargetBeanDefinition(ConfigurableListableBeanFactory factory, String beanName, BeanDefinition beanDefinition) {
        if (beanDefinition.getFactoryBeanName() != null) {
            return beanDefinition;
        }
        try {
            Class<?> factoryBeanClass = this.grailsApplication.getClassLoader().loadClass(beanDefinition.getBeanClassName());
            return this.getTargetBeanDefinition(factory, beanName, beanDefinition, factoryBeanClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected BeanDefinition getTargetBeanDefinition(ConfigurableListableBeanFactory factory, String beanName, BeanDefinition beanDefinition, Class<?> beanClass) {
        if (FactoryBean.class.isAssignableFrom(beanClass)) {
            return this.getTargetBeanDefinitionForFactoryBean(factory, beanName, beanDefinition, beanClass);
        }
        return beanDefinition;
    }

    protected BeanDefinition getTargetBeanDefinitionForFactoryBean(ConfigurableListableBeanFactory factory, String beanName, BeanDefinition beanDefinition, Class<?> beanClass) {
        if (TransactionProxyFactoryBean.class.isAssignableFrom(beanClass)) {
            return this.getTargetBeanDefinition(factory, beanName, (BeanDefinition)Objects.requireNonNull(beanDefinition.getPropertyValues().getPropertyValue("target").getValue()));
        }
        return beanDefinition;
    }
}

