/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.errors;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import grails.util.Environment;
import grails.web.mapping.UrlMappingInfo;
import grails.web.mapping.UrlMappingsHolder;
import grails.web.mapping.exceptions.UrlMappingException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.grails.core.exceptions.GrailsRuntimeException;
import org.grails.exceptions.ExceptionUtils;
import org.grails.exceptions.reporting.DefaultStackTraceFilterer;
import org.grails.exceptions.reporting.StackTraceFilterer;
import org.grails.web.errors.GrailsWrappedRuntimeException;
import org.grails.web.mapping.DefaultUrlMappingInfo;
import org.grails.web.mapping.UrlMappingUtils;
import org.grails.web.servlet.mvc.exceptions.GrailsMVCException;
import org.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.grails.web.util.WebUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class GrailsExceptionResolver
extends SimpleMappingExceptionResolver
implements ServletContextAware,
GrailsApplicationAware {
    public static final String EXCEPTION_ATTRIBUTE = "exception";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected ServletContext servletContext;
    protected GrailsApplication grailsApplication;
    protected StackTraceFilterer stackFilterer;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        request.removeAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE");
        ex = this.findWrappedException(ex);
        this.filterStackTrace(ex);
        ModelAndView mv = super.resolveException(request, response, handler, ex);
        this.setStatus(request, response, mv, ex);
        this.logStackTrace(ex, request);
        UrlMappingsHolder urlMappings = this.lookupUrlMappings();
        if (urlMappings != null) {
            mv = this.resolveViewOrForward(ex, urlMappings, request, response, mv);
        }
        return mv;
    }

    public String getRequestLogMessage(Throwable e, HttpServletRequest request) {
        Throwable cause = GrailsExceptionResolver.getRootCause(e);
        String exceptionName = cause.getClass().getSimpleName();
        return this.getRequestLogMessage(exceptionName, request, cause.getMessage());
    }

    public String getRequestLogMessage(HttpServletRequest request) {
        return this.getRequestLogMessage("Exception", request, null);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
        this.createStackFilterer();
    }

    public static Throwable getRootCause(Throwable ex) {
        return ExceptionUtils.getRootCause((Throwable)ex);
    }

    public static int extractLineNumber(CompilationFailedException e) {
        return ExceptionUtils.extractLineNumber((CompilationFailedException)e);
    }

    public static RuntimeException getFirstRuntimeException(Throwable e) {
        return ExceptionUtils.getFirstRuntimeException((Throwable)e);
    }

    protected void filterStackTrace(Exception e) {
        this.stackFilterer.filter((Throwable)e, true);
    }

    protected void setStatus(HttpServletRequest request, HttpServletResponse response, ModelAndView mv, Exception e) {
        response.setStatus(500);
        request.setAttribute("jakarta.servlet.error.status_code", (Object)500);
        GrailsWrappedRuntimeException gwre = new GrailsWrappedRuntimeException(this.servletContext, (Throwable)e);
        mv.addObject("jakarta.servlet.error.exception", (Object)gwre);
        mv.addObject(EXCEPTION_ATTRIBUTE, (Object)gwre);
    }

    protected UrlMappingsHolder lookupUrlMappings() {
        try {
            return UrlMappingUtils.lookupUrlMappings((ServletContext)this.servletContext);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    Map extractRequestParamsWithUrlMappingHolder(UrlMappingsHolder urlMappings, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            UrlMappingInfo requestInfo = urlMappings.match(request.getRequestURI());
            if (requestInfo != null) {
                params.putAll(UrlMappingUtils.findAllParamsNotInUrlMappingKeywords((Map)requestInfo.getParameters()));
            }
        }
        catch (UrlMappingException ulrMappingException) {
            this.logger.debug((Object)("Could not find urlMapping which matches: " + request.getRequestURI()));
        }
        return params;
    }

    protected ModelAndView resolveViewOrForward(Exception ex, UrlMappingsHolder urlMappings, HttpServletRequest request, HttpServletResponse response, ModelAndView mv) {
        Map params;
        UrlMappingInfo info = this.matchStatusCode(ex, urlMappings);
        if (info != null && (params = this.extractRequestParamsWithUrlMappingHolder(urlMappings, request)) != null && !params.isEmpty()) {
            Map infoParams = info.getParameters();
            if (infoParams != null) {
                params.putAll(info.getParameters());
            }
            info = new DefaultUrlMappingInfo(info, params, this.grailsApplication);
        }
        try {
            if (info != null && info.getViewName() != null) {
                this.resolveView(request, info, mv);
            } else if (info != null && info.getControllerName() != null) {
                String uri = this.determineUri(request);
                if (!response.isCommitted()) {
                    if (response instanceof GrailsContentBufferingResponse) {
                        ((GrailsContentBufferingResponse)response).deactivateSitemesh();
                    }
                    this.forwardRequest(info, request, response, mv, uri);
                    return new ModelAndView();
                }
            }
            return mv;
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to render errors view: " + e.getMessage()), (Throwable)e);
            throw new GrailsRuntimeException((Throwable)e);
        }
    }

    protected void forwardRequest(UrlMappingInfo info, HttpServletRequest request, HttpServletResponse response, ModelAndView mv, String uri) throws ServletException, IOException {
        info.configure(WebUtils.retrieveGrailsWebRequest());
        String forwardUrl = UrlMappingUtils.forwardRequestForUrlMappingInfo((HttpServletRequest)request, (HttpServletResponse)response, (UrlMappingInfo)info, (Map)mv.getModel(), (boolean)true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Matched URI [" + uri + "] to URL mapping [" + info + "], forwarding to [" + forwardUrl + "] with response [" + response.getClass() + "]"));
        }
    }

    protected String determineUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("jakarta.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return uri;
    }

    protected void resolveView(HttpServletRequest request, UrlMappingInfo info, ModelAndView mv) throws Exception {
        ViewResolver viewResolver = WebUtils.lookupViewResolver((ServletContext)this.servletContext);
        View v = UrlMappingUtils.resolveView((HttpServletRequest)request, (UrlMappingInfo)info, (String)info.getViewName(), (ViewResolver)viewResolver);
        if (v != null) {
            mv.setView(v);
        }
    }

    protected UrlMappingInfo matchStatusCode(Exception ex, UrlMappingsHolder urlMappings) {
        UrlMappingInfo info = urlMappings.matchStatusCode(500, (Throwable)ex);
        if (info == null) {
            info = urlMappings.matchStatusCode(500, GrailsExceptionResolver.getRootCause(ex));
        }
        if (info == null) {
            info = urlMappings.matchStatusCode(500);
        }
        return info;
    }

    protected void logStackTrace(Exception e, HttpServletRequest request) {
        this.logger.error((Object)this.getRequestLogMessage(e, request), (Throwable)e);
    }

    protected Exception findWrappedException(Exception e) {
        Throwable t;
        if ((e instanceof InvokerInvocationException || e instanceof GrailsMVCException) && (t = GrailsExceptionResolver.getRootCause(e)) instanceof Exception) {
            e = (Exception)t;
        }
        return e;
    }

    protected String getRequestLogMessage(String exceptionName, HttpServletRequest request, String message) {
        Enumeration params;
        boolean shouldLogRequestParameters;
        Config config;
        StringBuilder sb = new StringBuilder();
        sb.append(exceptionName).append(" occurred when processing request: ").append("[").append(request.getMethod().toUpperCase()).append("] ");
        if (request.getAttribute("jakarta.servlet.forward.request_uri") != null) {
            sb.append(request.getAttribute("jakarta.servlet.forward.request_uri"));
        } else {
            sb.append(request.getRequestURI());
        }
        Config config2 = config = this.grailsApplication != null ? this.grailsApplication.getConfig() : null;
        boolean bl = config != null ? (Boolean)config.getProperty("grails.exceptionresolver.logRequestParameters", Boolean.class, (Object)(Environment.getCurrent() == Environment.DEVELOPMENT ? 1 : 0)) : (shouldLogRequestParameters = false);
        if (shouldLogRequestParameters && (params = request.getParameterNames()).hasMoreElements()) {
            sb.append(" - parameters:");
            List blackList = (List)config.getProperty("grails.exceptionresolver.params.exclude", List.class, Collections.emptyList());
            if (blackList == null) {
                blackList = Collections.emptyList();
            }
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                String[] values = request.getParameterValues(param);
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    sb.append(LINE_SEPARATOR).append(param).append(": ");
                    if (blackList.contains(param)) {
                        sb.append("***");
                        continue;
                    }
                    sb.append(values[i]);
                }
            }
        }
        sb.append(LINE_SEPARATOR);
        if (message != null) {
            sb.append(message).append(". ");
        }
        sb.append("Stacktrace follows:");
        return sb.toString();
    }

    protected void createStackFilterer() {
        try {
            Class filtererClass = (Class)this.grailsApplication.getConfig().getProperty("grails.logging.stackTraceFiltererClass", Class.class, DefaultStackTraceFilterer.class);
            this.stackFilterer = (StackTraceFilterer)BeanUtils.instantiateClass((Class)filtererClass, StackTraceFilterer.class);
        }
        catch (Throwable t) {
            this.logger.error((Object)("Problem instantiating StackTracePrinter class, using default: " + t.getMessage()));
            this.stackFilterer = new DefaultStackTraceFilterer();
        }
    }
}

