/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.core.GrailsApplication;
import grails.gorm.validation.Constrained;
import grails.gorm.validation.ConstrainedProperty;
import grails.web.mapping.UrlMapping;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractUrlMapping
implements UrlMapping {
    protected final ConstrainedProperty[] constraints;
    protected Object controllerName;
    protected Object actionName;
    protected Object namespace;
    protected Object pluginName;
    protected Object viewName;
    protected Object forwardURI;
    protected Object redirectInfo;
    protected ServletContext servletContext;
    protected GrailsApplication grailsApplication;
    protected Map parameterValues = Collections.emptyMap();
    protected boolean parseRequest;
    protected String mappingName;
    protected String httpMethod = "*";
    protected String version = "*";
    protected Integer pluginIndex;

    public AbstractUrlMapping(Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, ConstrainedProperty[] constraints, GrailsApplication grailsApplication) {
        this.controllerName = controllerName;
        this.actionName = actionName;
        this.namespace = namespace;
        this.pluginName = pluginName;
        this.constraints = constraints;
        this.viewName = viewName;
        this.setGrailsApplication(grailsApplication);
        this.redirectInfo = redirectInfo;
    }

    private void setGrailsApplication(GrailsApplication grailsApplication) {
        ApplicationContext applicationContext;
        this.grailsApplication = grailsApplication;
        if (grailsApplication != null && (applicationContext = grailsApplication.getMainContext()) instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
        }
    }

    protected AbstractUrlMapping(Object viewName, ConstrainedProperty[] constraints, GrailsApplication grailsApplication) {
        this.viewName = viewName;
        this.constraints = constraints;
        this.grailsApplication = grailsApplication;
        this.setGrailsApplication(grailsApplication);
    }

    protected AbstractUrlMapping(URI uri, ConstrainedProperty[] constraints, GrailsApplication grailsApplication) {
        this.forwardURI = uri;
        this.constraints = constraints;
        this.grailsApplication = grailsApplication;
        this.setGrailsApplication(grailsApplication);
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Constrained[] getConstraints() {
        return this.constraints;
    }

    @Override
    public Object getControllerName() {
        return this.controllerName;
    }

    @Override
    public Object getActionName() {
        return this.actionName;
    }

    @Override
    public Object getPluginName() {
        return this.pluginName;
    }

    @Override
    public Object getNamespace() {
        return this.namespace;
    }

    @Override
    public Object getViewName() {
        return this.viewName;
    }

    @Override
    public void setParameterValues(Map parameterValues) {
        this.parameterValues = Collections.unmodifiableMap(parameterValues);
    }

    @Override
    public void setParseRequest(boolean shouldParse) {
        this.parseRequest = shouldParse;
    }

    @Override
    public String getMappingName() {
        return this.mappingName;
    }

    @Override
    public void setMappingName(String name) {
        this.mappingName = name;
    }

    @Override
    public boolean hasRuntimeVariable(String name) {
        if (this.constraints != null) {
            for (ConstrainedProperty cp : this.constraints) {
                if (!cp.getPropertyName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getRedirectInfo() {
        return this.redirectInfo;
    }

    @Override
    public void setPluginIndex(int pluginIndex) {
        this.pluginIndex = pluginIndex;
    }

    @Override
    public Integer getPluginIndex() {
        return this.pluginIndex;
    }

    @Override
    public boolean isDefinedInPlugin() {
        return this.pluginIndex != null;
    }
}

