/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import grails.util.GrailsMetaClassUtils;
import grails.util.GrailsStringUtils;
import grails.web.servlet.mvc.GrailsParameterMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.web.mapping.DefaultLinkGenerator;
import org.grails.web.servlet.mvc.GrailsWebRequest;

public class CachingLinkGenerator
extends DefaultLinkGenerator {
    private static final int MAX_SIZE = 5000;
    public static final String LINK_PREFIX = "link";
    public static final String RESOURCE_PREFIX = "resource";
    public static final String USED_ATTRIBUTES_SUFFIX = "-used-attributes";
    public static final String EMPTY_MAP_STRING = "[:]";
    private static final String OPENING_BRACKET = "[";
    private static final String CLOSING_BRACKET = "]";
    private static final String COMMA_SEPARATOR = ", ";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String THIS_MAP = "(this Map)";
    private final Cache<String, Object> linkCache = this.createDefaultCache();

    public CachingLinkGenerator(String serverBaseURL, String contextPath) {
        super(serverBaseURL, contextPath);
    }

    public CachingLinkGenerator(String serverBaseURL) {
        super(serverBaseURL);
    }

    @Override
    public String link(Map attrs, String encoding) {
        if (!this.isCacheable(attrs)) {
            return super.link(attrs, encoding);
        }
        String key = this.makeKey(LINK_PREFIX, attrs);
        Object resourceLink = this.linkCache.getIfPresent((Object)key);
        if (resourceLink == null) {
            resourceLink = super.link(attrs, encoding);
            this.linkCache.put((Object)key, resourceLink);
        }
        return resourceLink.toString();
    }

    protected boolean isCacheable(Map attrs) {
        if (attrs.get("params") instanceof GrailsParameterMap) {
            return false;
        }
        Object urlAttr = attrs.get("url");
        if (urlAttr instanceof Map) {
            return this.isCacheable((Map)urlAttr);
        }
        return attrs.get("controller") != null || attrs.get("action") != null || urlAttr != null || attrs.get("uri") != null;
    }

    protected void appendMapKey(StringBuilder buffer, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            buffer.append(EMPTY_MAP_STRING);
            buffer.append(OPENING_BRACKET);
        } else {
            String namespace;
            buffer.append(OPENING_BRACKET);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(params);
            String requestControllerName = this.getRequestStateLookupStrategy().getControllerName();
            if (map.get("action") != null && map.get("controller") == null && map.get(RESOURCE_PREFIX) == null) {
                Object action = map.remove("action");
                map.put("controller", requestControllerName);
                map.put("action", action);
            }
            if (map.get("namespace") == null && map.get("controller") == requestControllerName && GrailsStringUtils.isNotEmpty((String)(namespace = this.getRequestStateLookupStrategy().getControllerNamespace()))) {
                map.put("namespace", namespace);
            }
            boolean first = true;
            for (Map.Entry o : map.entrySet()) {
                Map.Entry entry = o;
                Object value = entry.getValue();
                if (value == null) continue;
                first = this.appendCommaIfNotFirst(buffer, first);
                Object key = entry.getKey();
                if (RESOURCE_PREFIX.equals(key)) {
                    value = this.getCacheKeyValueForResource(value);
                }
                this.appendKeyValue(buffer, map, key, value);
            }
        }
        buffer.append(CLOSING_BRACKET);
    }

    protected String getCacheKeyValueForResource(Object o) {
        StringBuilder builder = new StringBuilder(o.getClass().getName());
        builder.append("->");
        Object idValue = GrailsMetaClassUtils.invokeMethodIfExists((Object)o, (String)"ident", (Object[])new Object[0]);
        if (idValue != null) {
            builder.append(idValue);
        } else {
            builder.append(o);
        }
        return builder.toString();
    }

    private boolean appendCommaIfNotFirst(StringBuilder buffer, boolean first) {
        if (first) {
            first = false;
        } else {
            buffer.append(COMMA_SEPARATOR);
        }
        return first;
    }

    protected void appendKeyValue(StringBuilder buffer, Map map, Object key, Object value) {
        buffer.append(key).append(KEY_VALUE_SEPARATOR);
        if (value == map) {
            buffer.append(THIS_MAP);
        } else {
            buffer.append(DefaultGroovyMethods.toString((Object)value));
        }
    }

    @Override
    public String resource(Map attrs) {
        String key = this.makeKey(RESOURCE_PREFIX, attrs);
        Object resourceLink = this.linkCache.getIfPresent((Object)key);
        if (resourceLink == null) {
            resourceLink = super.resource(attrs);
            this.linkCache.put((Object)key, resourceLink);
        }
        return resourceLink.toString();
    }

    protected String makeKey(String prefix, Map attrs) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (this.getConfiguredServerBaseURL() == null && this.isAbsolute(attrs)) {
            if (attrs.get("base") != null) {
                sb.append(attrs.get("base"));
            } else {
                GrailsWebRequest webRequest = GrailsWebRequest.lookup();
                if (webRequest != null) {
                    sb.append(webRequest.getBaseUrl());
                }
            }
        }
        this.appendMapKey(sb, attrs);
        return sb.toString();
    }

    private Cache<String, Object> createDefaultCache() {
        return Caffeine.newBuilder().maximumSize(5000L).build();
    }

    public void clearCache() {
        this.linkCache.invalidateAll();
    }
}

