/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.util.GrailsStringUtils;
import grails.web.mapping.LinkGenerator;
import grails.web.mapping.UrlMapping;
import grails.web.mapping.UrlMappingInfo;
import grails.web.mapping.UrlMappingsHolder;
import groovy.lang.Binding;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.grails.web.servlet.WrappedResponseHolder;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.grails.web.util.IncludeResponseWrapper;
import org.grails.web.util.IncludedContent;
import org.grails.web.util.WebUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public final class UrlMappingUtils {
    private UrlMappingUtils() {
    }

    public static Map findAllParamsNotInUrlMappingKeywords(Map params) {
        return UrlMappingUtils.findAllParamsNotInKeys(params, UrlMapping.KEYWORDS);
    }

    public static Map findAllParamsNotInKeys(Map params, Set keys) {
        HashMap urlParams = new HashMap();
        if (params != null && keys != null) {
            for (Object key : params.keySet()) {
                if (keys.contains(key)) continue;
                urlParams.put(key, params.get(key));
            }
        }
        return urlParams;
    }

    public static UrlMappingsHolder lookupUrlMappings(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (UrlMappingsHolder)wac.getBean("grailsUrlMappingsHolder");
    }

    public static View resolveView(HttpServletRequest request, UrlMappingInfo info, String viewName, ViewResolver viewResolver) throws Exception {
        String controllerName = info.getControllerName();
        return WebUtils.resolveView((HttpServletRequest)request, (String)viewName, (String)controllerName, (ViewResolver)viewResolver);
    }

    public static String buildDispatchUrlForMapping(UrlMappingInfo info) {
        return UrlMappingUtils.buildDispatchUrlForMapping(info, false);
    }

    private static String buildDispatchUrlForMapping(UrlMappingInfo info, boolean includeParams) {
        if (info.getURI() != null) {
            return info.getURI();
        }
        StringBuilder forwardUrl = new StringBuilder();
        if (info.getViewName() != null) {
            String viewName = info.getViewName();
            if (viewName.startsWith("/")) {
                forwardUrl.append(viewName);
            } else {
                forwardUrl.append('/').append(viewName);
            }
        } else {
            forwardUrl.append('/').append(info.getControllerName());
            if (!GrailsStringUtils.isBlank((String)info.getActionName())) {
                forwardUrl.append('/').append(info.getActionName());
            }
        }
        Map parameters = UrlMappingUtils.findAllParamsNotInUrlMappingKeywords(info.getParameters());
        if (parameters != null && !parameters.isEmpty() && includeParams) {
            try {
                forwardUrl.append(WebUtils.toQueryString((Map)parameters));
            }
            catch (UnsupportedEncodingException e) {
                throw new ControllerExecutionException("Unable to include ");
            }
        }
        return forwardUrl.toString();
    }

    private static String buildDispatchUrlForMapping(UrlMappingInfo info, boolean includeParams, LinkGenerator linkGenerator) {
        if (info.getURI() != null) {
            return info.getURI();
        }
        StringBuilder forwardUrl = new StringBuilder();
        if (info.getViewName() != null) {
            String viewName = info.getViewName();
            if (viewName.startsWith("/")) {
                forwardUrl.append(viewName);
            } else {
                forwardUrl.append('/').append(viewName);
            }
        } else {
            HashMap<String, Object> urlAttrs = new HashMap<String, Object>();
            urlAttrs.put("controller", info.getControllerName());
            urlAttrs.put("action", info.getActionName());
            urlAttrs.put("includeContext", false);
            forwardUrl.append(linkGenerator.link(urlAttrs));
        }
        Map parameters = UrlMappingUtils.findAllParamsNotInUrlMappingKeywords(info.getParameters());
        if (parameters != null && !parameters.isEmpty() && includeParams) {
            try {
                forwardUrl.append(WebUtils.toQueryString((Map)parameters));
            }
            catch (UnsupportedEncodingException e) {
                throw new ControllerExecutionException("Unable to include ");
            }
        }
        return forwardUrl.toString();
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info) throws ServletException, IOException {
        return UrlMappingUtils.forwardRequestForUrlMappingInfo(request, response, info, Collections.emptyMap());
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) throws ServletException, IOException {
        return UrlMappingUtils.forwardRequestForUrlMappingInfo(request, response, info, model, false);
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map<String, Object> model, boolean includeParams) throws ServletException, IOException {
        String forwardUrl = UrlMappingUtils.buildDispatchUrlForMapping(info, includeParams);
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardUrl);
        GrailsWebRequest webRequest = GrailsWebRequest.lookup((HttpServletRequest)request);
        webRequest.removeAttribute("org.grails.MODEL_AND_VIEW", 0);
        info.configure(webRequest);
        webRequest.removeAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", 0);
        webRequest.removeAttribute("org.grails.url.match.info", 0);
        webRequest.removeAttribute("grailsWebRequestFilter.FILTERED", 0);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        return forwardUrl;
    }

    public static IncludedContent includeForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) {
        String includeUrl = UrlMappingUtils.buildDispatchUrlForMapping(info, true);
        return UrlMappingUtils.includeForUrlMappingInfoHelper(includeUrl, request, response, info, model);
    }

    public static IncludedContent includeForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model, LinkGenerator linkGenerator) {
        String includeUrl = UrlMappingUtils.buildDispatchUrlForMapping(info, true, linkGenerator);
        return UrlMappingUtils.includeForUrlMappingInfoHelper(includeUrl, request, response, info, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IncludedContent includeForUrlMappingInfoHelper(String includeUrl, HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) {
        IncludedContent includedContent;
        block17: {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup((HttpServletRequest)request);
            String currentController = null;
            String currentAction = null;
            String currentId = null;
            ModelAndView currentMv = null;
            Binding currentPageBinding = null;
            HashMap currentParams = null;
            Object currentLayoutAttribute = null;
            Object currentRenderingView = null;
            if (webRequest != null) {
                currentPageBinding = (Binding)webRequest.getAttribute("org.grails.PAGE_SCOPE", 0);
                webRequest.removeAttribute("org.grails.PAGE_SCOPE", 0);
                currentLayoutAttribute = webRequest.getAttribute("org.grails.layout.name", 0);
                if (currentLayoutAttribute != null) {
                    webRequest.removeAttribute("org.grails.layout.name", 0);
                }
                if ((currentRenderingView = webRequest.getAttribute("org.grails.rendering.view", 0)) != null) {
                    webRequest.removeAttribute("org.grails.rendering.view", 0);
                }
                currentController = webRequest.getControllerName();
                currentAction = webRequest.getActionName();
                currentId = webRequest.getId();
                currentParams = new HashMap(webRequest.getParameterMap());
                currentMv = (ModelAndView)webRequest.getAttribute("org.grails.MODEL_AND_VIEW", 0);
            }
            try {
                if (webRequest != null) {
                    webRequest.getParameterMap().clear();
                    info.configure(webRequest);
                    webRequest.getParameterMap().putAll(info.getParameters());
                    webRequest.removeAttribute("org.grails.MODEL_AND_VIEW", 0);
                }
                includedContent = UrlMappingUtils.includeForUrl(includeUrl, request, response, model);
                if (webRequest == null) break block17;
            }
            catch (Throwable throwable) {
                if (webRequest != null) {
                    if (webRequest.isActive()) {
                        webRequest.setAttribute("org.grails.PAGE_SCOPE", (Object)currentPageBinding, 0);
                        if (currentLayoutAttribute != null) {
                            webRequest.setAttribute("org.grails.layout.name", currentLayoutAttribute, 0);
                        }
                        if (currentRenderingView != null) {
                            webRequest.setAttribute("org.grails.rendering.view", currentRenderingView, 0);
                        }
                        webRequest.getParameterMap().clear();
                        webRequest.getParameterMap().putAll(currentParams);
                        webRequest.setId(currentId);
                        webRequest.setControllerName(currentController);
                        webRequest.setActionName(currentAction);
                        if (currentMv != null) {
                            webRequest.setAttribute("org.grails.MODEL_AND_VIEW", currentMv, 0);
                        }
                    } else {
                        RequestContextHolder.setRequestAttributes(null);
                    }
                }
                throw throwable;
            }
            if (webRequest.isActive()) {
                webRequest.setAttribute("org.grails.PAGE_SCOPE", (Object)currentPageBinding, 0);
                if (currentLayoutAttribute != null) {
                    webRequest.setAttribute("org.grails.layout.name", currentLayoutAttribute, 0);
                }
                if (currentRenderingView != null) {
                    webRequest.setAttribute("org.grails.rendering.view", currentRenderingView, 0);
                }
                webRequest.getParameterMap().clear();
                webRequest.getParameterMap().putAll(currentParams);
                webRequest.setId((Object)currentId);
                webRequest.setControllerName(currentController);
                webRequest.setActionName(currentAction);
                if (currentMv != null) {
                    webRequest.setAttribute("org.grails.MODEL_AND_VIEW", (Object)currentMv, 0);
                }
            } else {
                RequestContextHolder.setRequestAttributes(null);
            }
        }
        return includedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncludedContent includeForUrl(String includeUrl, HttpServletRequest request, HttpServletResponse response, Map model) {
        RequestDispatcher dispatcher = request.getRequestDispatcher(includeUrl);
        HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
        response = wrapped != null ? wrapped : response;
        WebUtils.exposeIncludeRequestAttributes((HttpServletRequest)request);
        Map toRestore = WebUtils.exposeRequestAttributesAndReturnOldValues((HttpServletRequest)request, (Map)model);
        GrailsWebRequest webRequest = GrailsWebRequest.lookup((HttpServletRequest)request);
        boolean hasPreviousWebRequest = webRequest != null;
        Object previousControllerClass = hasPreviousWebRequest ? webRequest.getAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", 0) : null;
        Object previousMatchedRequest = hasPreviousWebRequest ? webRequest.getAttribute("org.grails.url.match.info", 0) : null;
        try {
            IncludedContent includedContent;
            block17: {
                IncludeResponseWrapper responseWrapper;
                block15: {
                    IncludedContent includedContent2;
                    block16: {
                        if (hasPreviousWebRequest) {
                            webRequest.removeAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", 0);
                            webRequest.removeAttribute("org.grails.url.match.info", 0);
                            webRequest.removeAttribute("grailsWebRequestFilter.FILTERED", 0);
                        }
                        responseWrapper = new IncludeResponseWrapper(response);
                        try {
                            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)responseWrapper);
                            WebUtils.clearGrailsWebRequest();
                            dispatcher.include((ServletRequest)request, (ServletResponse)responseWrapper);
                            if (responseWrapper.getRedirectURL() == null) break block15;
                            includedContent2 = new IncludedContent(responseWrapper.getRedirectURL());
                            if (!hasPreviousWebRequest) break block16;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (hasPreviousWebRequest) {
                                    WebUtils.storeGrailsWebRequest((GrailsWebRequest)webRequest);
                                    if (webRequest.isActive()) {
                                        webRequest.setAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", previousControllerClass, 0);
                                        webRequest.setAttribute("org.grails.url.match.info", previousMatchedRequest, 0);
                                    }
                                }
                                WrappedResponseHolder.setWrappedResponse((HttpServletResponse)wrapped);
                                throw throwable;
                            }
                            catch (Exception e) {
                                throw new ControllerExecutionException("Unable to execute include: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        WebUtils.storeGrailsWebRequest((GrailsWebRequest)webRequest);
                        if (webRequest.isActive()) {
                            webRequest.setAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", previousControllerClass, 0);
                            webRequest.setAttribute("org.grails.url.match.info", previousMatchedRequest, 0);
                        }
                    }
                    WrappedResponseHolder.setWrappedResponse((HttpServletResponse)wrapped);
                    return includedContent2;
                }
                includedContent = new IncludedContent(responseWrapper.getContentType(), responseWrapper.getContent());
                if (!hasPreviousWebRequest) break block17;
                WebUtils.storeGrailsWebRequest((GrailsWebRequest)webRequest);
                if (webRequest.isActive()) {
                    webRequest.setAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", previousControllerClass, 0);
                    webRequest.setAttribute("org.grails.url.match.info", previousMatchedRequest, 0);
                }
            }
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)wrapped);
            return includedContent;
        }
        finally {
            WebUtils.cleanupIncludeRequestAttributes((HttpServletRequest)request, (Map)toRestore);
        }
    }
}

