/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsControllerClass;
import grails.core.GrailsUrlMappingsClass;
import grails.core.support.GrailsApplicationAware;
import grails.plugins.GrailsPluginManager;
import grails.plugins.PluginManagerAware;
import grails.util.GrailsStringUtils;
import grails.web.UrlConverter;
import grails.web.mapping.UrlMapping;
import grails.web.mapping.UrlMappings;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import org.grails.web.mapping.DefaultUrlMappingEvaluator;
import org.grails.web.mapping.DefaultUrlMappings;
import org.grails.web.mapping.DefaultUrlMappingsHolder;
import org.grails.web.mapping.mvc.GrailsControllerUrlMappings;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;

public class UrlMappingsHolderFactoryBean
implements FactoryBean<UrlMappings>,
InitializingBean,
ApplicationContextAware,
GrailsApplicationAware,
PluginManagerAware {
    private static final String URL_MAPPING_CACHE_MAX_SIZE = "grails.urlmapping.cache.maxsize";
    private static final String URL_CREATOR_CACHE_MAX_SIZE = "grails.urlcreator.cache.maxsize";
    private GrailsApplication grailsApplication;
    private UrlMappings urlMappingsHolder;
    private GrailsPluginManager pluginManager;
    private ApplicationContext applicationContext;
    private UrlConverter grailsUrlConverter;

    public UrlMappings getObject() throws Exception {
        return this.urlMappingsHolder;
    }

    public Class<UrlMappings> getObjectType() {
        return UrlMappings.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Integer urlCreatorCacheSize;
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"Property [applicationContext] must be set!");
        Assert.state((this.grailsApplication != null ? 1 : 0) != 0, (String)"Property [grailsApplication] must be set!");
        ArrayList<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
        ArrayList excludePatterns = new ArrayList();
        GrailsClass[] mappings = this.grailsApplication.getArtefacts("UrlMappings");
        DefaultUrlMappingEvaluator mappingEvaluator = new DefaultUrlMappingEvaluator(this.applicationContext);
        mappingEvaluator.setPluginManager(this.pluginManager);
        if (mappings.length == 0) {
            urlMappings.addAll(mappingEvaluator.evaluateMappings(DefaultUrlMappings.getMappings()));
        } else {
            for (int i = 0; i < mappings.length; ++i) {
                GrailsClass mapping = mappings[i];
                GrailsUrlMappingsClass mappingClass = (GrailsUrlMappingsClass)mapping;
                List<UrlMapping> grailsClassMappings = Script.class.isAssignableFrom(mappingClass.getClazz()) ? mappingEvaluator.evaluateMappings(mappingClass.getClazz()) : mappingEvaluator.evaluateMappings(mappingClass.getMappingsClosure());
                if (GrailsStringUtils.isNotEmpty((String)mapping.getPluginName())) {
                    for (UrlMapping grailsClassMapping : grailsClassMappings) {
                        grailsClassMapping.setPluginIndex(i);
                    }
                }
                urlMappings.addAll(grailsClassMappings);
                if (mappingClass.getExcludePatterns() == null) continue;
                excludePatterns.addAll(mappingClass.getExcludePatterns());
            }
        }
        DefaultUrlMappingsHolder defaultUrlMappingsHolder = new DefaultUrlMappingsHolder(urlMappings, excludePatterns, true);
        Config config = this.grailsApplication.getConfig();
        Integer cacheSize = (Integer)config.getProperty(URL_MAPPING_CACHE_MAX_SIZE, Integer.class, null);
        if (cacheSize != null) {
            defaultUrlMappingsHolder.setMaxWeightedCacheCapacity(cacheSize);
        }
        if ((urlCreatorCacheSize = (Integer)config.getProperty(URL_CREATOR_CACHE_MAX_SIZE, Integer.class, null)) != null) {
            defaultUrlMappingsHolder.setUrlCreatorMaxWeightedCacheCapacity(urlCreatorCacheSize);
        }
        defaultUrlMappingsHolder.initialize();
        GrailsControllerUrlMappings grailsControllerUrlMappings = new GrailsControllerUrlMappings(this.grailsApplication, defaultUrlMappingsHolder, this.grailsUrlConverter);
        ((ConfigurableApplicationContext)this.applicationContext).addApplicationListener(event -> {
            GrailsClass artefact = event.getArtefact();
            if (artefact instanceof GrailsControllerClass) {
                grailsControllerUrlMappings.registerController((GrailsControllerClass)artefact);
            }
        });
        this.urlMappingsHolder = grailsControllerUrlMappings;
    }

    public void setUrlConverter(UrlConverter urlConverter) {
        this.grailsUrlConverter = urlConverter;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.setGrailsApplication((GrailsApplication)applicationContext.getBean("grailsApplication", GrailsApplication.class));
        this.setPluginManager(applicationContext.containsBean("pluginManager") ? (GrailsPluginManager)applicationContext.getBean("pluginManager", GrailsPluginManager.class) : null);
    }
}

