/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;
import org.granite.binding.collection.CollectionChangeSupport;
import org.granite.binding.collection.ObservableSet;

public class ObservableSetWrapper<E>
implements ObservableSet<E> {
    protected CollectionChangeSupport ccs = new CollectionChangeSupport(this);
    private final Set<E> wrappedSet;

    public ObservableSetWrapper(Set<E> set) {
        this.wrappedSet = set;
    }

    public Set<E> getWrappedObservable() {
        return this.wrappedSet;
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.addCollectionChangeListener(listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.removeCollectionChangeListener(listener);
    }

    @Override
    public boolean add(E element) {
        boolean added = this.wrappedSet.add(element);
        if (added) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, null, new Object[]{element});
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        boolean added = this.wrappedSet.addAll(elements);
        if (added) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, null, elements.toArray());
        }
        return added;
    }

    @Override
    public boolean remove(Object element) {
        boolean removed = this.wrappedSet.remove(element);
        if (removed) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, null, new Object[]{removed});
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean removed = false;
        for (Object element : collection) {
            if (!this.remove(element)) continue;
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            if (this.wrappedSet.contains(element) || !this.remove(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        if (this.wrappedSet.size() == 0) {
            return;
        }
        Object[] elements = this.wrappedSet.toArray();
        this.wrappedSet.clear();
        this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.CLEAR, null, elements);
    }

    @Override
    public boolean contains(Object element) {
        return this.wrappedSet.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.wrappedSet.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.wrappedSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.wrappedSet.toArray(array);
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorWrapper(this.wrappedSet.iterator());
    }

    private class IteratorWrapper
    implements Iterator<E> {
        private final Iterator<E> wrappedIterator;
        private E element;

        public IteratorWrapper(Iterator<E> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public E next() {
            this.element = this.wrappedIterator.next();
            return this.element;
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
            ObservableSetWrapper.this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, null, new Object[]{this.element});
        }
    }
}

