/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.collection;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;
import org.granite.binding.collection.CollectionChangeSupport;
import org.granite.binding.collection.ObservableMap;

public class ObservableStringMapWrapper<V>
implements ObservableMap<String, V> {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected CollectionChangeSupport ccs = new CollectionChangeSupport(this);
    private final Map<String, V> wrappedMap;

    public ObservableStringMapWrapper(Map<String, V> map) {
        this.wrappedMap = map;
    }

    public Map<String, V> getWrappedObservable() {
        return this.wrappedMap;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(property, listener);
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.addCollectionChangeListener(listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.removeCollectionChangeListener(listener);
    }

    @Override
    public V put(String key, V value) {
        V oldValue = this.wrappedMap.put(key, value);
        this.pcs.firePropertyChange(key, oldValue, value);
        if (oldValue != null) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REPLACE, key, new Object[]{new Object[]{key, value}});
        } else {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, key, new Object[]{new Object[]{key, value}});
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> me : map.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.wrappedMap.remove(key);
        if (oldValue != null) {
            this.pcs.firePropertyChange((String)key, oldValue, null);
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, key, new Object[]{new Object[]{key, oldValue}});
        }
        return oldValue;
    }

    @Override
    public void clear() {
        if (this.wrappedMap.size() == 0) {
            return;
        }
        Object[][] elements = new Object[this.wrappedMap.size()][];
        int i = 0;
        for (Map.Entry<String, V> me : this.wrappedMap.entrySet()) {
            elements[i++] = new Object[]{me.getKey(), me.getValue()};
        }
        this.wrappedMap.clear();
        for (Object[] element : elements) {
            this.pcs.firePropertyChange((String)element[0], element[1], null);
        }
        this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.CLEAR, null, (Object[])elements);
    }

    @Override
    public V get(Object key) {
        return this.wrappedMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.wrappedMap.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.wrappedMap.entrySet();
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }
}

