/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.cdi;

import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.granite.client.tide.Application;
import org.granite.client.tide.Context;
import org.granite.client.tide.EventBus;
import org.granite.client.tide.cdi.CDIInstanceStoreFactory;
import org.granite.client.tide.cdi.TideApplicationEvent;
import org.granite.client.tide.data.Conflicts;
import org.granite.client.tide.data.DataConflictListener;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.tide.impl.SimpleContextManager;

@ApplicationScoped
public class CDIContextManager
extends SimpleContextManager {
    @Inject
    private BeanManager beanManager;

    protected CDIContextManager() {
    }

    @Inject
    public CDIContextManager(Application application, EventBus eventBus) {
        super(application, eventBus);
    }

    @PostConstruct
    public void init() {
        this.setInstanceStoreFactory(new CDIInstanceStoreFactory(this.beanManager));
        this.getContext().getEntityManager().addListener(new CDIDataConflictListener());
    }

    @Override
    @Produces
    public Context getContext() {
        return this.getContext(null);
    }

    @Produces
    public EntityManager getEntityManager() {
        return this.getContext(null).getEntityManager();
    }

    @Produces
    public DataManager getDataManager() {
        return this.getContext(null).getDataManager();
    }

    private final class CDIDataConflictListener
    implements DataConflictListener {
        private CDIDataConflictListener() {
        }

        @Override
        public void onConflict(EntityManager entityManager, Conflicts conflicts) {
            TideApplicationEvent event = new TideApplicationEvent(CDIContextManager.this.getContext(null), EntityManager.UpdateKind.CONFLICT.eventName(), conflicts);
            CDIContextManager.this.beanManager.fireEvent((Object)event, new Annotation[0]);
        }
    }
}

