/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;
import org.granite.binding.collection.CollectionChangeSupport;
import org.granite.binding.collection.ObservableList;
import org.granite.binding.collection.ObservableListWrapper;
import org.granite.binding.collection.ObservableMap;
import org.granite.binding.collection.ObservableStringMapWrapper;
import org.granite.client.tide.collection.AbstractPagedCollection;
import org.granite.client.tide.collection.PageFilterFinder;
import org.granite.client.tide.collection.SimpleFilterFinder;
import org.granite.client.tide.server.Component;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideRpcEvent;

@Named
public class PagedQuery<E, F>
extends AbstractPagedCollection<E, F>
implements ObservableList<E> {
    protected CollectionChangeSupport ccs = new CollectionChangeSupport(this);
    private List<E> internalWrappedList = new ArrayList();
    protected ObservableList<E> wrappedList;
    private Map<String, Object> internalFilterMap;
    private ObservableMap<String, Object> filterMap;
    private F filter;

    protected PagedQuery() {
    }

    public PagedQuery(ServerSession serverSession) {
        super(serverSession);
        this.initWrappedList();
    }

    public PagedQuery(Component remoteComponent, String methodName, int maxResults) {
        super(remoteComponent, methodName, maxResults);
        this.initWrappedList();
    }

    public PagedQuery(Component remoteComponent, PageFilterFinder<E> finder, int maxResults) {
        super(remoteComponent, finder, maxResults);
        this.initWrappedList();
    }

    public PagedQuery(Component remoteComponent, SimpleFilterFinder<E> finder, int maxResults) {
        super(remoteComponent, finder, maxResults);
        this.initWrappedList();
    }

    @Override
    protected List<E> getInternalWrappedList() {
        return this.internalWrappedList;
    }

    @Override
    protected List<E> getWrappedList() {
        return this.wrappedList;
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.addCollectionChangeListener(listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.removeCollectionChangeListener(listener);
    }

    private void initWrappedList() {
        this.wrappedList = new ObservableListWrapper<E>(this.internalWrappedList);
        this.wrappedList.addCollectionChangeListener(new WrappedListCollectionChangeListener());
    }

    @Override
    protected void initFilter() {
        this.internalFilterMap = new HashMap<String, Object>();
        this.filterMap = new ObservableStringMapWrapper<Object>(Collections.synchronizedMap(this.internalFilterMap));
        this.filterMap.addCollectionChangeListener(new CollectionChangeListener(){

            @Override
            public void collectionChange(CollectionChangeEvent event) {
                PagedQuery.this.fullRefresh = true;
                PagedQuery.this.filterRefresh = true;
            }
        });
        this.filter = null;
    }

    @Override
    public F getFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        try {
            return (F)this.filterMap;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public void setFilter(F filter) {
        if (filter == null) {
            this.internalFilterMap.clear();
        } else {
            this.filter = filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected F cloneFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        Map<String, Object> map = this.internalFilterMap;
        synchronized (map) {
            return (F)new HashMap<String, Object>(this.internalFilterMap);
        }
    }

    @Override
    @PreDestroy
    public void clear() {
        super.clear();
        this.ccs = new CollectionChangeSupport(this);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void firePageChange(TideRpcEvent event, int previousFirst, int previousLast, List<E> savedSnapshot) {
        this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.PAGE_CHANGE, event, null);
    }

    public class WrappedListCollectionChangeListener
    implements CollectionChangeListener {
        @Override
        public void collectionChange(CollectionChangeEvent event) {
            PagedQuery.this.ccs.fireCollectionChangeEvent(event.getKind(), event.getKey(), event.getValues());
        }
    }
}

