/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.util.Map;
import org.granite.client.persistence.Entity;
import org.granite.client.persistence.Id;
import org.granite.client.persistence.Uid;
import org.granite.client.persistence.Version;
import org.granite.client.tide.data.EntityProxy;

@Entity
public class ChangeProxy
implements EntityProxy {
    private String uidPropertyName;
    @Uid
    private String uid;
    private String idPropertyName;
    @Id
    private Object id;
    private String versionPropertyName;
    @Version
    private Number version;
    private Map<String, Object> changes;
    private Object templateObject;

    public ChangeProxy(String uidPropertyName, String uid, String idPropertyName, Object id, String versionPropertyName, Number version, Map<String, Object> changes, Object templateObject) {
        this.uidPropertyName = uidPropertyName;
        this.uid = uid;
        this.idPropertyName = idPropertyName;
        this.id = id;
        this.versionPropertyName = versionPropertyName;
        this.version = version;
        this.changes = changes;
        this.templateObject = templateObject;
    }

    @Override
    public Object getProperty(String propName) {
        if (propName.equals(this.idPropertyName)) {
            return this.id;
        }
        if (propName.equals(this.versionPropertyName)) {
            return this.version;
        }
        if (propName.equals(this.uidPropertyName)) {
            return this.uid;
        }
        if (this.changes.containsKey(propName)) {
            return this.changes.get(propName);
        }
        return null;
    }

    @Override
    public boolean hasProperty(String propName) {
        if (propName.equals(this.idPropertyName)) {
            return true;
        }
        if (propName.equals(this.versionPropertyName)) {
            return true;
        }
        if (propName.equals(this.uidPropertyName)) {
            return true;
        }
        return this.changes.containsKey(propName);
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getClassName() {
        return this.templateObject.getClass().getName();
    }

    @Override
    public Object getWrappedObject() {
        return this.templateObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getClassName().indexOf(".") > 0) {
            sb.append(this.getClassName().substring(this.getClassName().lastIndexOf(".") + 1));
        } else {
            sb.append(this.getClassName());
        }
        sb.append(':').append(this.getUid()).append(":").append(this.getId()).append(':').append(this.version).append("={");
        boolean first = true;
        for (Map.Entry<String, Object> change : this.changes.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(change.getKey()).append(": ").append(change.getValue());
        }
        sb.append("}");
        return sb.toString();
    }
}

