/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.granite.client.persistence.collection.PersistentCollection;
import org.granite.client.tide.Context;
import org.granite.client.tide.collection.CollectionLoader;
import org.granite.client.tide.data.Conflict;
import org.granite.client.tide.data.DataConflictListener;
import org.granite.client.tide.data.DataMerger;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.PersistenceManager;
import org.granite.client.tide.data.RemoteInitializer;
import org.granite.client.tide.data.RemoteValidator;
import org.granite.client.tide.data.Value;
import org.granite.client.tide.data.impl.DirtyCheckContextImpl;
import org.granite.client.tide.data.impl.JavaBeanDataManager;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.data.impl.UIDWeakSet;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.tide.data.spi.DirtyCheckContext;
import org.granite.client.tide.data.spi.EntityRef;
import org.granite.client.tide.data.spi.MergeContext;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.util.WeakIdentityHashMap;
import org.granite.logging.Logger;
import org.granite.util.TypeUtil;

public class EntityManagerImpl
implements EntityManager {
    private static final Logger log = Logger.getLogger(EntityManagerImpl.class);
    private String id;
    private boolean active = false;
    private DataManager dataManager = null;
    private DataManager.TrackingHandler trackingHandler = new DefaultTrackingHandler();
    private DirtyCheckContext dirtyCheckContext = null;
    private UIDWeakSet entitiesByUid = null;
    private WeakIdentityHashMap<Object, List<Object>> entityReferences = new WeakIdentityHashMap();
    private DataMerger[] customMergers = null;
    private boolean uninitializeAllowed = true;
    private EntityManager.Propagation entityManagerPropagation = null;
    private static int tmpEntityManagerId = 1;
    private List<DataConflictListener> dataConflictListeners = new ArrayList<DataConflictListener>();
    private RemoteInitializer remoteInitializer = null;

    public EntityManagerImpl(String id, DataManager dataManager) {
        this.id = id;
        this.active = true;
        this.dataManager = dataManager != null ? dataManager : new JavaBeanDataManager();
        this.dataManager.setTrackingHandler(this.trackingHandler);
        this.entitiesByUid = new UIDWeakSet(this.dataManager);
        this.dirtyCheckContext = new DirtyCheckContextImpl(this.dataManager);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void clear() {
        this.entitiesByUid.apply(new UIDWeakSet.Operation(){

            @Override
            public void apply(Object o) {
                PersistenceManager.setEntityManager(o, null);
            }
        });
        this.entitiesByUid.clear();
        this.entityReferences.clear();
        this.dirtyCheckContext.clear(false);
        this.dataManager.clear();
        this.active = true;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public DataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public DataManager.TrackingHandler getTrackingHandler() {
        return this.trackingHandler;
    }

    public void setCustomMergers(DataMerger[] customMergers) {
        this.customMergers = customMergers != null && customMergers.length > 0 ? customMergers : null;
    }

    @Override
    public void setUninitializeAllowed(boolean uninitializeAllowed) {
        this.uninitializeAllowed = uninitializeAllowed;
    }

    @Override
    public boolean isUninitializeAllowed() {
        return this.uninitializeAllowed;
    }

    @Override
    public void setEntityManagerPropagation(EntityManager.Propagation propagation) {
        this.entityManagerPropagation = propagation;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setDirtyCheckContext(DirtyCheckContext dirtyCheckContext) {
        if (dirtyCheckContext == null) {
            throw new IllegalArgumentException("Dirty check context cannot be null");
        }
        this.dirtyCheckContext = dirtyCheckContext;
    }

    @Override
    public EntityManager newTemporaryEntityManager() {
        try {
            DataManager tmpDataManager = (DataManager)TypeUtil.newInstance(this.dataManager.getClass(), DataManager.class);
            return new EntityManagerImpl("$$TMP$$" + tmpEntityManagerId++, tmpDataManager);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create temporaty entity manager", e);
        }
    }

    public void attachEntity(Object entity) {
        this.attachEntity(entity, true);
    }

    public void attachEntity(Object entity, boolean putInCache) {
        EntityManager em = PersistenceManager.getEntityManager(entity);
        if (em != null && em != this && !em.isActive()) {
            throw new Error("The entity instance " + entity + " cannot be attached to two contexts (current: " + em.getId() + ", new: " + this.id + ")");
        }
        PersistenceManager.setEntityManager(entity, this);
        if (putInCache && this.entitiesByUid.put(entity) == null) {
            this.dirtyCheckContext.addUnsaved(entity);
        }
    }

    public void detachEntity(Object entity, boolean removeFromCache, boolean forceRemove) {
        if (!forceRemove && this.dataManager.hasVersionProperty(entity) && this.dataManager.getVersion(entity) != null) {
            return;
        }
        this.dirtyCheckContext.markNotDirty(entity, entity);
        PersistenceManager.setEntityManager(entity, null);
        if (removeFromCache) {
            this.entitiesByUid.remove(this.dataManager.getCacheKey(entity));
        }
    }

    @Override
    public void attach(Object object) {
        this.internalAttach(object, new IdentityHashMap<Object, Object>());
    }

    private void internalAttach(Object object, IdentityHashMap<Object, Object> cache) {
        if (object == null || EntityManagerImpl.isSimple(object)) {
            return;
        }
        if (cache.containsKey(object)) {
            return;
        }
        cache.put(object, object);
        if (this.isEntity(object)) {
            this.attachEntity(object);
        }
        for (Map.Entry<String, Object> me : this.dataManager.getPropertyValues(object, false, true).entrySet()) {
            Object val = me.getValue();
            if (val != null && !this.dataManager.isInitialized(val)) continue;
            if (val instanceof Collection) {
                for (Object e : (Collection)val) {
                    this.internalAttach(e, cache);
                }
                continue;
            }
            if (val instanceof Map) {
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    this.internalAttach(entry.getKey(), cache);
                    this.internalAttach(entry.getValue(), cache);
                }
                continue;
            }
            if (EntityManagerImpl.isSimple(val)) continue;
            this.internalAttach(val, cache);
        }
    }

    public static boolean isSimple(Object object) {
        return ObjectUtil.isSimple(object) || object instanceof Enum || object instanceof byte[] || object instanceof Value;
    }

    @Override
    public boolean isPersisted(Object entity) {
        return this.dataManager.hasVersionProperty(entity) && this.dataManager.getVersion(entity) != null;
    }

    private boolean isInitialized(Object entity) {
        return this.dataManager.isInitialized(entity);
    }

    private boolean isEntity(Object entity) {
        return this.dataManager.isEntity(entity);
    }

    public void detach(Object object, IdentityHashMap<Object, Object> cache, boolean forceRemove) {
        if (object == null || ObjectUtil.isSimple(object)) {
            return;
        }
        if (!this.dataManager.isInitialized(object)) {
            return;
        }
        if (cache.containsKey(object)) {
            return;
        }
        cache.put(object, object);
        Map<String, Object> values = this.dataManager.getPropertyValues(object, true, true, false);
        if (this.isEntity(object) && this.entityReferences.containsKey(object)) {
            this.detachEntity(object, true, forceRemove);
            for (Map.Entry<String, Object> me : values.entrySet()) {
                this.removeReference(me.getValue(), object, me.getKey());
            }
        }
    }

    @Override
    public Object getCachedObject(Object object, boolean nullIfAbsent) {
        Object entity = null;
        if (this.isEntity(object)) {
            entity = this.entitiesByUid.get(this.dataManager.getCacheKey(object));
        } else if (object instanceof EntityRef) {
            entity = this.entitiesByUid.get(((EntityRef)object).getClassName() + ":" + ((EntityRef)object).getUid());
        } else if (object instanceof String) {
            entity = this.entitiesByUid.get((String)object);
        }
        if (entity != null) {
            return entity;
        }
        if (nullIfAbsent) {
            return null;
        }
        return object;
    }

    @Override
    public Object[] getOwnerEntity(Object object) {
        List refs = (List)this.entityReferences.get(object);
        if (refs == null) {
            return null;
        }
        for (int i = 0; i < refs.size(); ++i) {
            if (!(refs.get(i) instanceof Object[]) || !(((Object[])refs.get(i))[0] instanceof String)) continue;
            return new Object[]{this.entitiesByUid.get((String)((Object[])refs.get(i))[0]), ((Object[])refs.get(i))[1]};
        }
        return null;
    }

    public List<Object[]> getOwnerEntities(Object object) {
        List refs = (List)this.entityReferences.get(object);
        if (refs == null) {
            return null;
        }
        ArrayList<Object[]> owners = new ArrayList<Object[]>();
        for (int i = 0; i < refs.size(); ++i) {
            Object owner;
            if (!(refs.get(i) instanceof Object[]) || !(((Object[])refs.get(i))[0] instanceof String) || (owner = this.entitiesByUid.get((String)((Object[])refs.get(i))[0])) == null) continue;
            owners.add(new Object[]{owner, ((Object[])refs.get(i))[1]});
        }
        return owners;
    }

    private List<Object> initRefs(Object obj) {
        ArrayList refs = (ArrayList)this.entityReferences.get(obj);
        if (refs == null) {
            refs = new ArrayList();
            this.entityReferences.put(obj, refs);
        }
        return refs;
    }

    @Override
    public void addReference(Object obj, Object parent, String propName) {
        if (this.isEntity(obj)) {
            this.attachEntity(obj);
        }
        this.dataManager.startTracking(obj, parent);
        List<Object> refs = (List<Object>)this.entityReferences.get(obj);
        boolean found = false;
        if (this.isEntity(parent)) {
            String ref = this.dataManager.getCacheKey(parent);
            if (refs == null) {
                refs = this.initRefs(obj);
            } else {
                for (int i = 0; i < refs.size(); ++i) {
                    if (!(refs.get(i) instanceof Object[]) || !((Object[])refs.get(i))[0].equals(ref)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                refs.add(new Object[]{ref, propName});
            }
        } else if (parent != null) {
            if (refs == null) {
                refs = this.initRefs(obj);
            } else {
                for (int i = 0; i < refs.size(); ++i) {
                    if (!(refs.get(i) instanceof Object[]) || !((Object[])refs.get(i))[0].equals(parent)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                refs.add(new Object[]{parent, propName});
            }
        }
    }

    @Override
    public boolean removeReference(Object obj, Object parent, String propName) {
        boolean removed;
        block15: {
            block16: {
                block14: {
                    int i;
                    List refs = (List)this.entityReferences.get(obj);
                    if (refs == null) {
                        return true;
                    }
                    int idx = -1;
                    if (this.isEntity(parent)) {
                        for (i = 0; i < refs.size(); ++i) {
                            if (!(refs.get(i) instanceof Object[]) || !((Object[])refs.get(i))[0].equals(this.dataManager.getCacheKey(parent))) continue;
                            idx = i;
                            break;
                        }
                    } else if (parent != null) {
                        for (i = 0; i < refs.size(); ++i) {
                            if (!(refs.get(i) instanceof Object[]) || !((Object[])refs.get(i))[0].equals(parent)) continue;
                            idx = i;
                            break;
                        }
                    }
                    if (idx >= 0) {
                        refs.remove(idx);
                    }
                    removed = false;
                    if (refs.size() == 0) {
                        this.entityReferences.remove(obj);
                        removed = true;
                        if (this.isEntity(obj)) {
                            this.detachEntity(obj, true, false);
                        }
                        this.dataManager.stopTracking(obj, parent);
                    }
                    if (obj instanceof PersistentCollection && !((PersistentCollection)obj).wasInitialized()) {
                        return removed;
                    }
                    if (!(obj instanceof Iterable)) break block14;
                    for (Object elt : (Iterable)obj) {
                        this.removeReference(elt, parent, propName);
                    }
                    break block15;
                }
                if (obj == null || !obj.getClass().isArray()) break block16;
                for (int i = 0; i < Array.getLength(obj); ++i) {
                    this.removeReference(Array.get(obj, i), parent, propName);
                }
                break block15;
            }
            if (!(obj instanceof Map)) break block15;
            for (Map.Entry me : ((Map)obj).entrySet()) {
                this.removeReference(me.getKey(), parent, propName);
                this.removeReference(me.getValue(), parent, propName);
            }
        }
        return removed;
    }

    @Override
    public MergeContext initMerge(ServerSession serverSession) {
        if (serverSession != null) {
            DataMerger[] customMergers = serverSession.getContext().allByType(DataMerger.class);
            this.setCustomMergers(customMergers);
        }
        return new MergeContext(this, this.dirtyCheckContext, serverSession);
    }

    @Override
    public Object mergeExternal(final MergeContext mergeContext, Object obj, Object previous, Object parent, String propertyName, boolean forceUpdate) {
        mergeContext.initMerge();
        boolean saveMergeUpdate = mergeContext.isMergeUpdate();
        boolean saveMerging = mergeContext.isMerging();
        try {
            mergeContext.setMerging(true);
            int stackSize = mergeContext.getMergeStackSize();
            boolean addRef = false;
            boolean fromCache = false;
            Object prev = mergeContext.getFromCache(obj);
            Object next = obj;
            if (prev != null) {
                next = prev;
                fromCache = true;
            } else {
                this.dataManager.stopTracking(previous, parent);
                if (obj == null) {
                    next = null;
                } else if ((obj instanceof PersistentCollection && !((PersistentCollection)obj).wasInitialized() || obj instanceof PersistentCollection && !(previous instanceof PersistentCollection)) && this.isEntity(parent) && propertyName != null) {
                    next = this.mergePersistentCollection(mergeContext, (PersistentCollection)obj, previous, parent, propertyName);
                    addRef = true;
                } else if (obj instanceof List) {
                    next = this.mergeList(mergeContext, (List<Object>)obj, previous, parent, propertyName);
                    addRef = true;
                } else if (obj instanceof Set) {
                    next = this.mergeSet(mergeContext, (Set)((Object)obj), previous, parent, propertyName);
                    addRef = true;
                } else if (obj instanceof Map) {
                    next = this.mergeMap(mergeContext, (Map)((Object)obj), previous, parent, propertyName);
                    addRef = true;
                } else if (obj.getClass().isArray()) {
                    next = this.mergeArray(mergeContext, obj, previous, parent, propertyName);
                    addRef = true;
                } else if (this.isEntity(obj)) {
                    next = this.mergeEntity(mergeContext, obj, previous, parent, propertyName);
                    addRef = true;
                } else {
                    boolean merged = false;
                    if (this.customMergers != null) {
                        for (DataMerger merger : this.customMergers) {
                            if (!merger.accepts(obj)) continue;
                            next = merger.merge(mergeContext, obj, previous, parent, propertyName);
                            this.dataManager.startTracking(previous, parent);
                            merged = true;
                            addRef = true;
                        }
                    }
                    if (!(merged || ObjectUtil.isSimple(obj) || obj instanceof Enum || obj instanceof Value || obj instanceof byte[])) {
                        next = this.mergeEntity(mergeContext, obj, previous, parent, propertyName);
                        addRef = true;
                    }
                }
            }
            if (next != null && !fromCache && addRef && prev == null && parent != null) {
                this.addReference(next, parent, propertyName);
            }
            mergeContext.setMergeUpdate(saveMergeUpdate);
            if (this.entityManagerPropagation != null && (mergeContext.isMergeUpdate() || forceUpdate) && !fromCache && this.isEntity(obj)) {
                this.entityManagerPropagation.propagate(obj, new EntityManager.Function(){

                    @Override
                    public void execute(EntityManager entityManager, Object entity) {
                        if (entityManager == mergeContext.getSourceEntityManager()) {
                            return;
                        }
                        if (entityManager.getCachedObject(entity, true) != null) {
                            entityManager.mergeFromEntityManager(entityManager, mergeContext.getServerSession(), entity, mergeContext.getExternalDataSessionId(), mergeContext.isUninitializing());
                        }
                    }
                });
            }
            if (mergeContext.getMergeStackSize() > stackSize) {
                mergeContext.popMerge();
            }
            List<?> list = next;
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Merge error", e);
        }
        finally {
            mergeContext.setMerging(saveMerging);
        }
    }

    private Object mergeEntity(MergeContext mergeContext, final Object obj, Object previous, Object parent, String propertyName) {
        boolean fromCache;
        if (obj != null || previous != null) {
            log.debug("mergeEntity: %s previous %s%s", new Object[]{ObjectUtil.toString(obj), ObjectUtil.toString(previous), obj == previous ? " (same)" : ""});
        }
        Object dest = obj;
        Object p = null;
        if (!this.isInitialized(obj)) {
            if (this.dataManager.hasIdProperty(obj) && (p = this.entitiesByUid.find(new UIDWeakSet.Matcher(){

                @Override
                public boolean match(Object o) {
                    return o.getClass().getName().equals(obj.getClass().getName()) && ObjectUtil.objectEquals(EntityManagerImpl.this.dataManager, EntityManagerImpl.this.dataManager.getId(obj), EntityManagerImpl.this.dataManager.getId(o));
                }
            })) != null) {
                dest = previous = p;
            }
        } else if (this.dataManager.isEntity(obj) && (p = this.entitiesByUid.get(this.dataManager.getCacheKey(obj))) != null) {
            if (obj == p) {
                return obj;
            }
            dest = previous = p;
        }
        if (dest != previous && previous != null && (ObjectUtil.objectEquals(this.dataManager, previous, obj) || !this.isEntity(previous))) {
            dest = previous;
        }
        if (dest == obj && p == null && obj != null && mergeContext.getSourceEntityManager() != null) {
            try {
                dest = TypeUtil.newInstance(obj.getClass(), Object.class);
                this.dataManager.copyUid(dest, obj);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create class " + obj.getClass(), e);
            }
        }
        if (!this.isInitialized(obj) && ObjectUtil.objectEquals(this.dataManager, previous, obj)) {
            log.debug("ignored received uninitialized proxy", new Object[0]);
            return previous;
        }
        if (!this.isInitialized(dest)) {
            log.debug("initialize lazy entity: %s", new Object[]{dest.toString()});
        }
        if (dest != null && this.isEntity(dest) && dest == obj) {
            log.debug("received entity %s used as destination (ctx: %s)", new Object[]{obj.toString(), this.id});
        }
        boolean bl = fromCache = p != null && dest == p;
        if (!fromCache && this.isEntity(dest)) {
            this.entitiesByUid.put(dest);
        }
        mergeContext.pushMerge(obj, dest);
        boolean tracking = false;
        if (mergeContext.isResolvingConflict()) {
            this.dataManager.startTracking(dest, parent);
            tracking = true;
        }
        boolean ignore = false;
        if (this.isEntity(dest)) {
            if (mergeContext.isUninitializing() && this.isEntity(parent) && propertyName != null && this.dataManager.hasVersionProperty(dest) && this.dataManager.getVersion(obj) != null && this.dataManager.isLazyProperty(parent, propertyName) && this.dataManager.defineProxy(dest, obj)) {
                return dest;
            }
            this.attachEntity(dest, false);
            if (previous != null && dest == previous) {
                if (this.dataManager.hasVersionProperty(dest) && !mergeContext.isResolvingConflict()) {
                    Number newVersion = (Number)this.dataManager.getVersion(obj);
                    Number oldVersion = (Number)this.dataManager.getVersion(dest);
                    if (newVersion != null && oldVersion != null && newVersion.longValue() < oldVersion.longValue() || newVersion == null && oldVersion != null) {
                        log.warn("ignored merge of older version of %s (current: %d, received: %d)", new Object[]{dest.toString(), oldVersion, newVersion});
                        ignore = true;
                    } else if (newVersion != null && oldVersion != null && newVersion.longValue() > oldVersion.longValue() || newVersion != null && oldVersion == null) {
                        mergeContext.markVersionChanged(dest);
                        boolean entityChanged = this.dirtyCheckContext.isEntityChanged(dest);
                        if (mergeContext.getExternalDataSessionId() != null && entityChanged && this.dirtyCheckContext.checkAndMarkNotDirty(mergeContext, dest, obj, null)) {
                            log.warn("conflict with external data detected on %s (current: %d, received: %d)", new Object[]{dest.toString(), oldVersion, newVersion});
                            Map<String, Object> save = this.dirtyCheckContext.getSavedProperties(dest);
                            ArrayList<String> properties = new ArrayList<String>(save.keySet());
                            properties.remove(this.dataManager.getVersionPropertyName(dest));
                            Collections.sort(properties);
                            mergeContext.addConflict(dest, obj, properties);
                            ignore = true;
                        } else {
                            mergeContext.setMergeUpdate(true);
                        }
                    } else if (this.dirtyCheckContext.isEntityChanged(dest)) {
                        mergeContext.setMergeUpdate(false);
                    } else {
                        mergeContext.setMergeUpdate(true);
                    }
                } else if (!mergeContext.isResolvingConflict()) {
                    mergeContext.markVersionChanged(dest);
                }
            } else {
                mergeContext.markVersionChanged(dest);
            }
            if (!ignore) {
                this.defaultMerge(mergeContext, obj, dest, parent, propertyName);
            }
        } else {
            this.defaultMerge(mergeContext, obj, dest, parent, propertyName);
        }
        if (!(dest == null || ignore || mergeContext.isSkipDirtyCheck() || mergeContext.isResolvingConflict())) {
            this.dirtyCheckContext.checkAndMarkNotDirty(mergeContext, dest, obj, this.isEntity(parent) && !this.isEntity(dest) ? parent : null);
        }
        if (dest != null) {
            log.debug("mergeEntity result: %s", new Object[]{dest.toString()});
        }
        if (!tracking) {
            this.dataManager.startTracking(dest, parent);
        }
        return dest;
    }

    private Object mergeArray(MergeContext mergeContext, Object array, Object previous, Object parent, String propertyName) {
        Object dest = mergeContext.getSourceEntityManager() == null ? array : Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
        mergeContext.pushMerge(array, dest);
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object obj = Array.get(array, i);
            obj = this.mergeExternal(mergeContext, obj, null, propertyName != null ? parent : null, propertyName, false);
            if (!mergeContext.isMergeUpdate()) continue;
            Array.set(dest, i, obj);
        }
        return dest;
    }

    private List<?> mergeList(MergeContext mergeContext, List<Object> coll, Object previous, Object parent, String propertyName) {
        int j;
        Object obj;
        int i;
        List prevColl;
        log.debug("mergeList: %s previous %s", new Object[]{ObjectUtil.toString(coll), ObjectUtil.toString(previous)});
        if (mergeContext.isUninitializing() && this.isEntity(parent) && propertyName != null && this.dataManager.hasVersionProperty(parent) && this.dataManager.getVersion(parent) != null && this.dataManager.isLazyProperty(parent, propertyName)) {
            mergeContext.pushMerge(coll, previous);
            if (previous instanceof PersistentCollection && ((PersistentCollection)previous).wasInitialized()) {
                log.debug("uninitialize lazy collection %s", new Object[]{ObjectUtil.toString(previous)});
                ((PersistentCollection)previous).uninitialize();
            }
            return (List)previous;
        }
        if (previous != null && previous instanceof PersistentCollection && !((PersistentCollection)previous).wasInitialized()) {
            log.debug("initialize lazy collection %s", new Object[]{ObjectUtil.toString(previous)});
            mergeContext.pushMerge(coll, previous);
            ((PersistentCollection)previous).initializing();
            ArrayList added = new ArrayList(coll.size());
            for (int i2 = 0; i2 < coll.size(); ++i2) {
                Object obj2 = coll.get(i2);
                obj2 = this.mergeExternal(mergeContext, obj2, null, propertyName != null ? parent : null, propertyName, false);
                added.add(obj2);
            }
            ((PersistentCollection)previous).initialize(added, null);
            this.dataManager.startTracking(previous, parent);
            return (List)previous;
        }
        boolean tracking = false;
        List nextList = null;
        List list = null;
        if (previous != null && previous instanceof List) {
            list = (List)previous;
        } else if (mergeContext.getSourceEntityManager() != null) {
            try {
                list = (List)coll.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create class " + coll.getClass());
            }
        } else {
            list = coll;
        }
        mergeContext.pushMerge(coll, list);
        List destColl = prevColl = list != coll ? list : null;
        if (prevColl != null && mergeContext.isMergeUpdate()) {
            if (mergeContext.isResolvingConflict()) {
                this.dataManager.startTracking(prevColl, parent);
                tracking = true;
            }
            for (i = 0; i < destColl.size(); ++i) {
                obj = destColl.get(i);
                boolean found = false;
                for (j = 0; j < coll.size(); ++j) {
                    Object next = coll.get(j);
                    if (!ObjectUtil.objectEquals(this.dataManager, next, obj)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                destColl.remove(i);
                --i;
            }
        }
        for (i = 0; i < coll.size(); ++i) {
            obj = coll.get(i);
            if (destColl != null) {
                boolean found = false;
                for (j = i; j < destColl.size(); ++j) {
                    Object prev = destColl.get(j);
                    if (i >= destColl.size() || !ObjectUtil.objectEquals(this.dataManager, prev, obj)) continue;
                    obj = this.mergeExternal(mergeContext, obj, prev, propertyName != null ? parent : null, propertyName, false);
                    if (j != i) {
                        destColl.remove(j);
                        if (i < destColl.size()) {
                            destColl.add(i, obj);
                        } else {
                            destColl.add(obj);
                        }
                        if (i > j) {
                            --j;
                        }
                    } else if (obj != prev) {
                        destColl.set(i, obj);
                    }
                    found = true;
                }
                if (found) continue;
                obj = this.mergeExternal(mergeContext, obj, null, propertyName != null ? parent : null, propertyName, false);
                if (!mergeContext.isMergeUpdate()) continue;
                if (i < prevColl.size()) {
                    destColl.add(i, obj);
                    continue;
                }
                destColl.add(obj);
                continue;
            }
            Object prev = obj;
            if ((obj = this.mergeExternal(mergeContext, obj, null, propertyName != null ? parent : null, propertyName, false)) == prev) continue;
            coll.set(i, obj);
        }
        if (destColl != null && mergeContext.isMergeUpdate()) {
            if (!mergeContext.isResolvingConflict() && !mergeContext.isSkipDirtyCheck()) {
                this.dirtyCheckContext.markNotDirty(previous, parent);
            }
            nextList = prevColl;
        } else {
            nextList = prevColl instanceof PersistentCollection && !mergeContext.isMergeUpdate() ? prevColl : coll;
        }
        if (this.isEntity(parent) && propertyName != null && nextList instanceof PersistentCollection && !(((PersistentCollection)nextList).getLoader() instanceof CollectionLoader)) {
            log.debug("instrument persistent collection from %s", new Object[]{ObjectUtil.toString(nextList)});
            ((PersistentCollection)nextList).setLoader(new CollectionLoader(mergeContext.getServerSession(), parent, propertyName));
        } else {
            log.debug("mergeList result: %s", new Object[]{ObjectUtil.toString(nextList)});
        }
        mergeContext.pushMerge(coll, nextList, false);
        if (!tracking) {
            this.dataManager.startTracking(nextList, parent);
        }
        return nextList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Set<?> mergeSet(MergeContext mergeContext, Set<Object> coll, Object previous, Object parent, String propertyName) {
        EntityManagerImpl.log.debug("mergeSet: %s previous %s", new Object[]{ObjectUtil.toString(coll), ObjectUtil.toString(previous)});
        if (mergeContext.isUninitializing() && this.isEntity(parent) && propertyName != null && this.dataManager.hasVersionProperty(parent) && this.dataManager.getVersion(parent) != null && this.dataManager.isLazyProperty(parent, propertyName)) {
            mergeContext.pushMerge(coll, previous);
            if (previous instanceof PersistentCollection && ((PersistentCollection)previous).wasInitialized()) {
                EntityManagerImpl.log.debug("uninitialize lazy collection %s", new Object[]{ObjectUtil.toString(previous)});
                ((PersistentCollection)previous).uninitialize();
            }
            return (Set)previous;
        }
        if (previous != null && previous instanceof PersistentCollection && !((PersistentCollection)previous).wasInitialized()) {
            EntityManagerImpl.log.debug("initialize lazy collection %s", new Object[]{ObjectUtil.toString(previous)});
            mergeContext.pushMerge(coll, previous);
            ((PersistentCollection)previous).initializing();
            added = new HashSet<E>(coll.size());
            for (E obj : coll) {
                obj /* !! */  = this.mergeExternal(mergeContext, obj /* !! */ , null, propertyName != null ? parent : null, propertyName, false);
                added.add(obj /* !! */ );
            }
            ((PersistentCollection)previous).initialize(added, null);
            this.dataManager.startTracking(previous, parent);
            return (Set)previous;
        }
        tracking = false;
        nextSet = null;
        set = null;
        if (previous != null && previous instanceof Set) {
            set = (Set<E>)previous;
        } else if (mergeContext.getSourceEntityManager() != null) {
            try {
                if (coll instanceof SortedSet) {
                    try {
                        set = (Set)coll.getClass().getConstructor(new Class[]{Comparator.class}).newInstance(new Object[]{((SortedSet)coll).comparator()});
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
                if (set != null) ** GOTO lbl41
                set = (Set)coll.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create class " + coll.getClass());
            }
        } else {
            set = coll;
        }
lbl41:
        // 4 sources

        mergeContext.pushMerge(coll, set);
        destColl = prevColl = set != coll ? set : null;
        if (prevColl != null && mergeContext.isMergeUpdate()) {
            if (mergeContext.isResolvingConflict()) {
                this.dataManager.startTracking(prevColl, parent);
                tracking = true;
            }
            ic = destColl.iterator();
            while (ic.hasNext()) {
                obj = ic.next();
                found = false;
                for (E next : coll) {
                    if (!ObjectUtil.objectEquals(this.dataManager, next, obj)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ic.remove();
            }
        }
        changed = new HashSet<E>();
        ic = coll.iterator();
        while (ic.hasNext()) {
            obj /* !! */  = ic.next();
            if (destColl != null) {
                found = false;
                for (E prev : destColl) {
                    if (!ObjectUtil.objectEquals(this.dataManager, prev, obj /* !! */ )) continue;
                    if ((obj /* !! */  = this.mergeExternal(mergeContext, obj /* !! */ , prev, propertyName != null ? parent : null, propertyName, false)) != prev) {
                        ic.remove();
                        changed.add(obj /* !! */ );
                    }
                    found = true;
                }
                if (found) continue;
                obj /* !! */  = this.mergeExternal(mergeContext, obj /* !! */ , null, propertyName != null ? parent : null, propertyName, false);
                if (!mergeContext.isMergeUpdate()) continue;
                destColl.add(obj /* !! */ );
                continue;
            }
            prev = obj /* !! */ ;
            if ((obj /* !! */  = this.mergeExternal(mergeContext, obj /* !! */ , null, propertyName != null ? parent : null, propertyName, false)) == prev) continue;
            ic.remove();
            changed.add(obj /* !! */ );
        }
        if (destColl != null) {
            destColl.addAll(changed);
        } else {
            coll.addAll(changed);
        }
        if (destColl != null && mergeContext.isMergeUpdate()) {
            if (!mergeContext.isResolvingConflict() && !mergeContext.isSkipDirtyCheck()) {
                this.dirtyCheckContext.markNotDirty(previous, parent);
            }
            nextSet = prevColl;
        } else {
            nextSet = prevColl instanceof PersistentCollection != false && mergeContext.isMergeUpdate() == false ? prevColl : coll;
        }
        if (this.isEntity(parent) && propertyName != null && nextSet instanceof PersistentCollection && !(((PersistentCollection)nextSet).getLoader() instanceof CollectionLoader)) {
            EntityManagerImpl.log.debug("instrument persistent collection from %s", new Object[]{ObjectUtil.toString(nextSet)});
            ((PersistentCollection)nextSet).setLoader(new CollectionLoader<C>(mergeContext.getServerSession(), parent, propertyName));
        } else {
            EntityManagerImpl.log.debug("mergeSet result: %s", new Object[]{ObjectUtil.toString(nextSet)});
        }
        mergeContext.pushMerge(coll, nextSet, false);
        if (!tracking) {
            this.dataManager.startTracking(nextSet, parent);
        }
        return nextSet;
    }

    /*
     * Unable to fully structure code
     */
    private Map<?, ?> mergeMap(MergeContext mergeContext, Map<Object, Object> map, Object previous, Object parent, String propertyName) {
        EntityManagerImpl.log.debug("mergeMap: %s previous %s", new Object[]{ObjectUtil.toString(map), ObjectUtil.toString(previous)});
        if (mergeContext.isUninitializing() && this.isEntity(parent) && propertyName != null && this.dataManager.hasVersionProperty(parent) && this.dataManager.getVersion(parent) != null && this.dataManager.isLazyProperty(parent, propertyName)) {
            mergeContext.pushMerge(map, previous);
            if (previous instanceof PersistentCollection && ((PersistentCollection)previous).wasInitialized()) {
                EntityManagerImpl.log.debug("uninitialize lazy map %s", new Object[]{ObjectUtil.toString(previous)});
                ((PersistentCollection)previous).uninitialize();
            }
            return (Map)previous;
        }
        if (previous != null && previous instanceof PersistentCollection && !((PersistentCollection)previous).wasInitialized()) {
            EntityManagerImpl.log.debug("initialize lazy map %s", new Object[]{ObjectUtil.toString(previous)});
            mergeContext.pushMerge(map, previous);
            ((PersistentCollection)previous).initializing();
            added = new HashMap<Object, Object>();
            for (Map.Entry<K, V> me : map.entrySet()) {
                key = this.mergeExternal(mergeContext, me.getKey(), null, propertyName != null ? parent : null, propertyName, false);
                value = this.mergeExternal(mergeContext, me.getValue(), null, propertyName != null ? parent : null, propertyName, false);
                added.put(key, value);
            }
            ((PersistentCollection)previous).initialize(added, null);
            this.dataManager.startTracking(previous, parent);
            return (Map)previous;
        }
        tracking = false;
        nextMap = null;
        m = null;
        if (previous != null && previous instanceof Map) {
            m = (Map<Object, Object>)previous;
        } else if (mergeContext.getSourceEntityManager() != null) {
            try {
                if (map instanceof SortedMap) {
                    try {
                        m = (Map)map.getClass().getConstructor(new Class[]{Comparator.class}).newInstance(new Object[]{((SortedMap)map).comparator()});
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
                if (m != null) ** GOTO lbl42
                m = (Map)TypeUtil.newInstance(map.getClass(), Map.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create class " + map.getClass());
            }
        } else {
            m = map;
        }
lbl42:
        // 4 sources

        mergeContext.pushMerge(map, m);
        v0 = prevMap = m != map ? m : null;
        if (prevMap != null) {
            if (mergeContext.isResolvingConflict()) {
                this.dataManager.startTracking(prevMap, parent);
                tracking = true;
            }
            if (map != prevMap) {
                for (Map.Entry<K, V> me : map.entrySet()) {
                    newKey = this.mergeExternal(mergeContext, me.getKey(), null, parent, propertyName, false);
                    prevValue = prevMap.get(newKey);
                    value = this.mergeExternal(mergeContext, me.getValue(), prevValue, parent, propertyName, false);
                    if (!mergeContext.isMergeUpdate() && !prevMap.containsKey(newKey)) continue;
                    prevMap.put(newKey, value);
                }
                if (mergeContext.isMergeUpdate()) {
                    imap = prevMap.keySet().iterator();
                    while (imap.hasNext()) {
                        key = imap.next();
                        found = false;
                        for (K k : map.keySet()) {
                            if (!ObjectUtil.objectEquals(this.dataManager, k, key)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        imap.remove();
                    }
                }
            }
            if (mergeContext.isMergeUpdate() && !mergeContext.isResolvingConflict() && !mergeContext.isSkipDirtyCheck()) {
                this.dirtyCheckContext.markNotDirty(previous, parent);
            }
            nextMap = prevMap;
        } else {
            addedToMap = new ArrayList<Object[]>();
            for (Map.Entry<K, V> me : map.entrySet()) {
                value = this.mergeExternal(mergeContext, me.getValue(), null, parent, propertyName, false);
                key = this.mergeExternal(mergeContext, me.getKey(), null, parent, propertyName, false);
                addedToMap.add(new Object[]{key, value});
            }
            map.clear();
            for (Object[] obj : addedToMap) {
                map.put(obj[0], obj[1]);
            }
            nextMap = map;
        }
        if (this.isEntity(parent) && propertyName != null && nextMap instanceof PersistentCollection && !(((PersistentCollection)nextMap).getLoader() instanceof CollectionLoader)) {
            EntityManagerImpl.log.debug("instrument persistent map from %s", new Object[]{ObjectUtil.toString(nextMap)});
            ((PersistentCollection)nextMap).setLoader(new CollectionLoader<C>(mergeContext.getServerSession(), parent, propertyName));
        } else {
            EntityManagerImpl.log.debug("mergeMap result: %s", new Object[]{ObjectUtil.toString(nextMap)});
        }
        mergeContext.pushMerge(map, nextMap, false);
        if (!tracking) {
            this.dataManager.startTracking(nextMap, parent);
        }
        return nextMap;
    }

    protected Object mergePersistentCollection(MergeContext mergeContext, PersistentCollection<?> coll, Object previous, Object parent, String propertyName) {
        if (previous instanceof PersistentCollection) {
            mergeContext.pushMerge(coll, previous);
            if (((PersistentCollection)previous).wasInitialized()) {
                if (mergeContext.isUninitializeAllowed() && mergeContext.hasVersionChanged(parent)) {
                    log.debug("uninitialize lazy collection %s", new Object[]{ObjectUtil.toString(previous)});
                    ((PersistentCollection)previous).uninitialize();
                } else {
                    log.debug("keep initialized collection %s", new Object[]{ObjectUtil.toString(previous)});
                }
            }
            if (!(((PersistentCollection)previous).getLoader() instanceof CollectionLoader)) {
                log.debug("instrument persistent collection from %s", new Object[]{ObjectUtil.toString(previous)});
                ((PersistentCollection)previous).setLoader(new CollectionLoader(mergeContext.getServerSession(), parent, propertyName));
            }
            this.dataManager.startTracking(previous, parent);
            return previous;
        }
        PersistentCollection<?> pcoll = coll;
        if (previous instanceof PersistentCollection) {
            pcoll = (PersistentCollection<?>)previous;
        }
        if (coll.getLoader() instanceof CollectionLoader) {
            pcoll = this.duplicatePersistentCollection(mergeContext, coll, parent, propertyName);
        } else if (mergeContext.getSourceEntityManager() != null) {
            pcoll = this.duplicatePersistentCollection(mergeContext, pcoll, parent, propertyName);
        }
        mergeContext.pushMerge(coll, pcoll);
        if (pcoll.wasInitialized()) {
            if (pcoll instanceof List) {
                List plist = (List)pcoll;
                for (int i = 0; i < plist.size(); ++i) {
                    Object obj = this.mergeExternal(mergeContext, plist.get(i), null, parent, propertyName, false);
                    if (obj == plist.get(i)) continue;
                    plist.set(i, obj);
                }
            } else {
                Collection pset = (Collection)pcoll;
                ArrayList<Object> toAdd = new ArrayList<Object>();
                Iterator iset = pset.iterator();
                while (iset.hasNext()) {
                    Object obj = iset.next();
                    Object merged = this.mergeExternal(mergeContext, obj, null, parent, propertyName, false);
                    if (merged == obj) continue;
                    iset.remove();
                    toAdd.add(merged);
                }
                pset.addAll(toAdd);
            }
            this.dataManager.startTracking(pcoll, parent);
        } else if (this.isEntity(parent) && propertyName != null) {
            this.dataManager.setLazyProperty(parent, propertyName);
        }
        if (!(coll.getLoader() instanceof CollectionLoader)) {
            log.debug("instrument persistent collection from %s", new Object[]{ObjectUtil.toString(pcoll)});
            pcoll.setLoader(new CollectionLoader(mergeContext.getServerSession(), parent, propertyName));
        }
        return pcoll;
    }

    private PersistentCollection<?> duplicatePersistentCollection(MergeContext mergeContext, Object coll, Object parent, String propertyName) {
        if (!(coll instanceof PersistentCollection)) {
            throw new RuntimeException("Not a persistent collection/map " + ObjectUtil.toString(coll));
        }
        PersistentCollection ccoll = ((PersistentCollection)coll).clone(mergeContext.isUninitializing());
        if (mergeContext.isUninitializing() && parent != null && propertyName != null && this.dataManager.hasVersionProperty(parent) && this.dataManager.getVersion(parent) != null && this.dataManager.isLazyProperty(parent, propertyName)) {
            ccoll.uninitialize();
        }
        return ccoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object mergeFromEntityManager(EntityManager sourceEntityManager, ServerSession serverSession, Object obj, String externalDataSessionId, boolean uninitializing) {
        try {
            Object next;
            MergeContext mergeContext = new MergeContext(this, this.dirtyCheckContext, serverSession);
            mergeContext.setSourceEntityManager(sourceEntityManager);
            mergeContext.setUninitializing(uninitializing);
            mergeContext.setExternalDataSessionId(externalDataSessionId);
            Object object = next = externalDataSessionId != null ? this.internalMergeExternalData(mergeContext, obj, null, null, null) : this.mergeExternal(mergeContext, obj, null, null, null, false);
            return object;
        }
        finally {
            MergeContext.destroy(this);
        }
    }

    @Override
    public Object mergeExternalData(Object obj) {
        return this.mergeExternalData(null, obj, null, null, null, null);
    }

    @Override
    public Object mergeExternalData(ServerSession serverSession, Object obj) {
        return this.mergeExternalData(serverSession, obj, null, null, null, null);
    }

    @Override
    public Object mergeExternalData(Object obj, Object prev, String externalDataSessionId, List<Object> removals, List<Object> persists) {
        return this.mergeExternalData(null, obj, prev, externalDataSessionId, removals, persists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object mergeExternalData(ServerSession serverSession, Object obj, Object prev, String externalDataSessionId, List<Object> removals, List<Object> persists) {
        try {
            MergeContext mergeContext = new MergeContext(this, this.dirtyCheckContext, serverSession);
            mergeContext.setExternalDataSessionId(externalDataSessionId);
            Object object = this.internalMergeExternalData(mergeContext, obj, prev, removals, persists);
            return object;
        }
        finally {
            MergeContext.destroy(this);
        }
    }

    public Object internalMergeExternalData(MergeContext mergeContext, Object obj, Object prev, List<Object> removals, List<Object> persists) {
        Object next = this.mergeExternal(mergeContext, obj, prev, null, null, false);
        if (removals != null) {
            this.handleRemovalsAndPersists(mergeContext, removals, persists);
        }
        if (mergeContext.getExternalDataSessionId() != null) {
            this.handleMergeConflicts(mergeContext);
            this.clearCache();
        }
        return next;
    }

    @Override
    public void mergeInEntityManager(final EntityManager entityManager, final ServerSession serverSession) {
        final HashSet cache = new HashSet();
        final EntityManagerImpl sourceEntityManager = this;
        this.entitiesByUid.apply(new UIDWeakSet.Operation(){

            @Override
            public void apply(Object obj) {
                if (EntityManagerImpl.this.isEntity(obj)) {
                    EntityManagerImpl.this.resetEntity(obj, cache);
                }
                entityManager.mergeFromEntityManager(sourceEntityManager, serverSession, obj, null, false);
            }
        });
    }

    @Override
    public boolean isDirty() {
        return this.dataManager.isDirty();
    }

    @Override
    public boolean isDirtyEntity(Object entity) {
        return this.dirtyCheckContext.isEntityChanged(entity);
    }

    @Override
    public boolean isDeepDirtyEntity(Object entity) {
        return this.dirtyCheckContext.isEntityDeepChanged(entity);
    }

    public boolean isSavedEntity(Object entity) {
        return this.dirtyCheckContext.getSavedProperties(entity) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemovalsAndPersists(MergeContext mergeContext, List<Object> removals, List<Object> persists) {
        for (Object removal : removals) {
            Object entity = this.getCachedObject(removal, true);
            if (entity == null) continue;
            if (mergeContext.getExternalDataSessionId() != null && !mergeContext.isResolvingConflict() && this.dirtyCheckContext.isEntityChanged(entity)) {
                log.error("conflict with external data removal detected on %s", new Object[]{ObjectUtil.toString(entity)});
                mergeContext.addConflict(entity, null, null);
                continue;
            }
            boolean saveMerging = mergeContext.isMerging();
            try {
                mergeContext.setMerging(true);
                List<Object[]> owners = this.getOwnerEntities(entity);
                if (owners != null) {
                    for (Object[] owner : owners) {
                        Object val = this.dataManager.getPropertyValue(owner[0], (String)owner[1]);
                        if (val instanceof PersistentCollection && !((PersistentCollection)val).wasInitialized()) continue;
                        if (val instanceof List) {
                            List list = (List)val;
                            int idx = list.indexOf(entity);
                            if (idx < 0) continue;
                            list.remove(idx);
                            continue;
                        }
                        if (val instanceof Collection) {
                            Collection coll = (Collection)val;
                            if (!coll.contains(entity)) continue;
                            coll.remove(entity);
                            continue;
                        }
                        if (!(val instanceof Map)) continue;
                        Map map = (Map)val;
                        if (map.containsKey(entity)) {
                            map.remove(entity);
                        }
                        Iterator ikey = map.keySet().iterator();
                        while (ikey.hasNext()) {
                            Object key = ikey.next();
                            if (!ObjectUtil.objectEquals(this.dataManager, map.get(key), entity)) continue;
                            ikey.remove();
                        }
                    }
                }
                Map<String, Object> pvalues = this.dataManager.getPropertyValues(entity, false, true);
                for (Object val : pvalues.values()) {
                    if (!(val instanceof Collection) && !(val instanceof Map) && (val == null || !val.getClass().isArray())) continue;
                    this.entityReferences.remove(val);
                }
                this.entityReferences.remove(entity);
                this.detach(entity, new IdentityHashMap<Object, Object>(), true);
            }
            finally {
                mergeContext.setMerging(saveMerging);
            }
        }
        this.dirtyCheckContext.fixRemovalsAndPersists(mergeContext, removals, persists);
    }

    @Override
    public void addListener(DataConflictListener listener) {
        this.dataConflictListeners.add(listener);
    }

    @Override
    public void removeListener(DataConflictListener listener) {
        this.dataConflictListeners.remove(listener);
    }

    public void handleMergeConflicts(MergeContext mergeContext) {
        mergeContext.initMergeConflicts();
        if (mergeContext.getMergeConflicts() != null) {
            for (DataConflictListener listener : this.dataConflictListeners) {
                listener.onConflict(this, mergeContext.getMergeConflicts());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveMergeConflicts(MergeContext mergeContext, Object modifiedEntity, Object localEntity, boolean resolving) {
        try {
            mergeContext.setResolvingConflict(resolving);
            if (modifiedEntity == null) {
                this.handleRemovalsAndPersists(mergeContext, Collections.singletonList(localEntity), Collections.<Object>emptyList());
            } else {
                this.mergeExternal(mergeContext, modifiedEntity, localEntity, null, null, false);
            }
            mergeContext.checkConflictsResolved();
        }
        finally {
            mergeContext.setResolvingConflict(false);
        }
    }

    @Override
    public Map<Object, Map<String, Object>> getSavedProperties() {
        return this.dirtyCheckContext.getSavedProperties();
    }

    @Override
    public Map<String, Object> getSavedProperties(Object entity) {
        Object localEntity = this.getCachedObject(entity, true);
        if (localEntity == null) {
            return null;
        }
        return this.dirtyCheckContext.getSavedProperties(localEntity);
    }

    public void defaultMerge(MergeContext mergeContext, Object obj, Object dest, Object parent, String propertyName) {
        Object d;
        Object o;
        String propName;
        if (this.isEntity(obj)) {
            this.dataManager.copyProxyState(dest, obj);
        }
        Map<String, Object> pval = this.dataManager.getPropertyValues(obj, mergeContext.isResolvingConflict(), false);
        ArrayList<String> rw = new ArrayList<String>();
        boolean isEmbedded = this.isEntity(parent) && !this.isEntity(obj);
        for (Map.Entry<String, Object> mval : pval.entrySet()) {
            propName = mval.getKey();
            o = mval.getValue();
            d = this.dataManager.getPropertyValue(dest, propName);
            if ((o = this.mergeExternal(mergeContext, o, d, isEmbedded ? parent : dest, isEmbedded ? propertyName + "." + propName : propName, false)) != d && mergeContext.isMergeUpdate()) {
                this.dataManager.setPropertyValue(dest, propName, o);
            }
            rw.add(propName);
        }
        pval = this.dataManager.getPropertyValues(obj, mergeContext.isResolvingConflict(), true);
        for (Map.Entry<String, Object> mval : pval.entrySet()) {
            if (rw.contains(mval.getKey())) continue;
            propName = mval.getKey();
            o = mval.getValue();
            d = this.dataManager.getPropertyValue(dest, propName);
            if (this.isEntity(o) || this.isEntity(d)) {
                throw new IllegalStateException("Cannot merge the read-only property " + propName + " on bean " + obj + " with an Identifiable value, this will break local unicity and caching. Change property access to read-write.");
            }
            this.mergeExternal(mergeContext, o, d, parent != null ? parent : dest, propertyName != null ? propertyName + '.' + propName : propName, false);
        }
    }

    public boolean isEntityChanged(Object entity) {
        return this.dirtyCheckContext.isEntityChanged(entity);
    }

    public boolean isEntityDeepChanged(Object entity) {
        return this.dirtyCheckContext.isEntityDeepChanged(entity);
    }

    @Override
    public void resetEntity(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        EntityManager em = PersistenceManager.getEntityManager(entity);
        if (em == null) {
            return;
        }
        if (em != this) {
            throw new IllegalArgumentException("Cannot reset an entity attached to another entity manager " + entity);
        }
        HashSet<Object> cache = new HashSet<Object>();
        this.resetEntity(entity, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEntity(Object entity, Set<Object> cache) {
        try {
            MergeContext mergeContext = new MergeContext(this, this.dirtyCheckContext, null);
            mergeContext.setMerging(true);
            this.dirtyCheckContext.resetEntity(mergeContext, entity, entity, cache);
        }
        finally {
            MergeContext.destroy(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllEntities() {
        try {
            HashSet<Object> cache = new HashSet<Object>();
            MergeContext mergeContext = new MergeContext(this, this.dirtyCheckContext, null);
            mergeContext.setMerging(true);
            this.dirtyCheckContext.resetAllEntities(mergeContext, cache);
        }
        finally {
            MergeContext.destroy(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptConflict(Conflict conflict, boolean client) {
        Object modifiedEntity = null;
        if (client) {
            EntityManager entityManager = PersistenceManager.getEntityManager(conflict.getLocalEntity());
            EntityManager tmp = entityManager.newTemporaryEntityManager();
            modifiedEntity = tmp.mergeFromEntityManager(entityManager, conflict.getServerSession(), conflict.getLocalEntity(), null, false);
            tmp.clear();
        } else {
            modifiedEntity = conflict.getReceivedEntity();
        }
        try {
            MergeContext mergeContext = new MergeContext(this, this.dirtyCheckContext, null);
            this.resetEntity(conflict.getLocalEntity());
            if (client && conflict.getReceivedEntity() != null) {
                this.mergeExternal(mergeContext, conflict.getReceivedEntity(), conflict.getLocalEntity(), null, null, false);
            }
            this.resolveMergeConflicts(mergeContext, modifiedEntity, conflict.getLocalEntity(), client);
        }
        finally {
            MergeContext.destroy(this);
        }
    }

    @Override
    public void setRemoteInitializer(RemoteInitializer remoteInitializer) {
        this.remoteInitializer = remoteInitializer;
    }

    @Override
    public boolean initializeObject(ServerSession serverSession, Object entity, String propertyName, Object object) {
        boolean initialize = false;
        if (this.remoteInitializer != null) {
            initialize = this.remoteInitializer.initializeObject(serverSession, entity, propertyName, object);
        }
        return initialize;
    }

    @Override
    public void handleUpdates(MergeContext mergeContext, String sourceSessionId, List<EntityManager.Update> updates) {
        ArrayList<Object> merges = new ArrayList<Object>();
        ArrayList<Object> removals = new ArrayList<Object>();
        ArrayList<Object> persists = new ArrayList<Object>();
        for (EntityManager.Update update : updates) {
            if (update.getKind() == EntityManager.UpdateKind.PERSIST || update.getKind() == EntityManager.UpdateKind.UPDATE) {
                merges.add(update.getEntity());
            } else if (update.getKind() == EntityManager.UpdateKind.REMOVE) {
                removals.add(update.getEntity());
            }
            if (update.getKind() != EntityManager.UpdateKind.PERSIST) continue;
            persists.add(update.getEntity());
        }
        mergeContext.setExternalDataSessionId(sourceSessionId);
        if (merges.size() == 1) {
            this.internalMergeExternalData(mergeContext, merges.get(0), null, removals, persists);
        } else if (merges.size() > 1) {
            this.internalMergeExternalData(mergeContext, merges, null, removals, persists);
        } else if (!removals.isEmpty() || !persists.isEmpty()) {
            this.internalMergeExternalData(mergeContext, null, null, removals, persists);
        }
        for (EntityManager.Update update : updates) {
            Object entity;
            if (update.getEntity() instanceof String || (entity = this.getCachedObject(update.getEntity(), update.getKind() != EntityManager.UpdateKind.REMOVE)) == null) continue;
            update.setEntity(entity);
        }
    }

    @Override
    public void raiseUpdateEvents(Context context, List<EntityManager.Update> updates) {
        ArrayList<String> refreshes = new ArrayList<String>();
        for (EntityManager.Update update : updates) {
            String entityName;
            Object entity = update.getEntity();
            if (update.getKind() == EntityManager.UpdateKind.REFRESH) {
                entityName = EntityManagerImpl.getUnqualifiedClassName((String)entity);
                refreshes.add(entityName);
                continue;
            }
            if (entity == null) continue;
            entityName = entity instanceof EntityRef ? EntityManagerImpl.getUnqualifiedClassName(((EntityRef)entity).getClassName()) : entity.getClass().getSimpleName();
            String eventType = update.getKind().eventName() + "." + entityName;
            context.getEventBus().raiseEvent(context, eventType, entity);
            if (!EntityManager.UpdateKind.PERSIST.equals((Object)update.getKind()) && !EntityManager.UpdateKind.REMOVE.equals((Object)update.getKind()) || refreshes.contains(entityName)) continue;
            refreshes.add(entityName);
        }
        for (String refresh : refreshes) {
            context.getEventBus().raiseEvent(context, EntityManager.UpdateKind.REFRESH.eventName() + "." + refresh, new Object[0]);
        }
    }

    private static String getUnqualifiedClassName(String className) {
        int idx = className.lastIndexOf(".");
        return idx >= 0 ? className.substring(idx + 1) : className;
    }

    @Override
    public void setRemoteValidator(RemoteValidator remoteValidator) {
    }

    @Override
    public boolean validateObject(Object object, String property, Object value) {
        return false;
    }

    public class DefaultTrackingHandler
    implements DataManager.TrackingHandler {
        @Override
        public void entityPropertyChangeHandler(Object target, String property, Object oldValue, Object newValue) {
            MergeContext mergeContext = MergeContext.get(PersistenceManager.getEntityManager(target));
            if (mergeContext != null && mergeContext.getSourceEntityManager() == this || !EntityManagerImpl.this.isActive()) {
                return;
            }
            if (newValue != oldValue) {
                if (EntityManagerImpl.this.isEntity(oldValue) || oldValue instanceof Collection || oldValue instanceof Map) {
                    EntityManagerImpl.this.removeReference(oldValue, target, property);
                    EntityManagerImpl.this.dataManager.stopTracking(oldValue, target);
                }
                if (EntityManagerImpl.this.isEntity(newValue) || newValue instanceof Collection || newValue instanceof Map) {
                    EntityManagerImpl.this.addReference(newValue, target, property);
                    EntityManagerImpl.this.dataManager.startTracking(newValue, target);
                }
            }
            log.debug("property changed: %s %s", new Object[]{ObjectUtil.toString(target), property});
            if (mergeContext == null || !mergeContext.isMerging() || mergeContext.isResolvingConflict()) {
                Object[] owner;
                Object[] objectArray = owner = EntityManagerImpl.this.isEntity(target) ? null : EntityManagerImpl.this.getOwnerEntity(target);
                if (owner == null) {
                    EntityManagerImpl.this.dirtyCheckContext.entityPropertyChangeHandler(target, target, property, oldValue, newValue);
                } else if (owner instanceof Object[] && EntityManagerImpl.this.isEntity(owner[0])) {
                    EntityManagerImpl.this.dirtyCheckContext.entityPropertyChangeHandler(owner[0], target, property, oldValue, newValue);
                }
            }
        }

        @Override
        public void collectionChangeHandler(DataManager.ChangeKind kind, Object target, Integer location, Object[] items) {
        }

        @Override
        public void entityCollectionChangeHandler(DataManager.ChangeKind kind, Object target, Integer location, Object[] items) {
            MergeContext mergeContext = MergeContext.get(PersistenceManager.getEntityManager(target));
            if (mergeContext != null && mergeContext.getSourceEntityManager() == this || !EntityManagerImpl.this.isActive()) {
                return;
            }
            int i = 0;
            Object[] parent = null;
            if (kind == DataManager.ChangeKind.ADD && items != null && items.length > 0) {
                parent = EntityManagerImpl.this.getOwnerEntity(target);
                for (i = 0; i < items.length; ++i) {
                    if (!EntityManagerImpl.this.isEntity(items[i])) continue;
                    if (parent != null) {
                        EntityManagerImpl.this.addReference(items[i], parent[0], (String)parent[1]);
                    } else {
                        EntityManagerImpl.this.attachEntity(items[i]);
                    }
                    EntityManagerImpl.this.dataManager.startTracking(items[i], parent != null ? parent[0] : null);
                }
            } else if (kind == DataManager.ChangeKind.REMOVE && items != null && items.length > 0) {
                parent = EntityManagerImpl.this.getOwnerEntity(target);
                if (parent != null) {
                    for (i = 0; i < items.length; ++i) {
                        if (!EntityManagerImpl.this.isEntity(items[i])) continue;
                        EntityManagerImpl.this.removeReference(items[i], parent[0], (String)parent[1]);
                    }
                }
            } else if (kind == DataManager.ChangeKind.REPLACE && items != null && items.length > 0) {
                parent = EntityManagerImpl.this.getOwnerEntity(target);
                for (i = 0; i < items.length; ++i) {
                    Object newValue = ((Object[])items[i])[1];
                    if (!EntityManagerImpl.this.isEntity(newValue)) continue;
                    if (parent != null) {
                        EntityManagerImpl.this.addReference(newValue, parent[0], (String)parent[1]);
                    } else {
                        EntityManagerImpl.this.attachEntity(newValue);
                    }
                    EntityManagerImpl.this.dataManager.startTracking(newValue, parent != null ? parent[0] : null);
                }
            }
            if (kind != DataManager.ChangeKind.ADD && kind != DataManager.ChangeKind.REMOVE && kind != DataManager.ChangeKind.REPLACE) {
                return;
            }
            log.debug("collection changed: %s %s", new Object[]{kind, ObjectUtil.toString(target)});
            if (mergeContext == null || !mergeContext.isMerging() || mergeContext.isResolvingConflict()) {
                if (parent == null) {
                    log.warn("Owner entity not found for collection %s, cannot process dirty checking", new Object[]{ObjectUtil.toString(target)});
                } else {
                    EntityManagerImpl.this.dirtyCheckContext.entityCollectionChangeHandler(parent[0], (String)parent[1], (Collection)target, kind, location, items);
                }
            }
        }

        @Override
        public void mapChangeHandler(DataManager.ChangeKind kind, Object target, Integer location, Object[] items) {
        }

        @Override
        public void entityMapChangeHandler(DataManager.ChangeKind kind, Object target, Integer location, Object[] items) {
            MergeContext mergeContext = MergeContext.get(PersistenceManager.getEntityManager(target));
            if (mergeContext != null && mergeContext.getSourceEntityManager() == this || !EntityManagerImpl.this.isActive()) {
                return;
            }
            Object[] parent = null;
            if (kind == DataManager.ChangeKind.ADD && items != null && items.length > 0) {
                parent = EntityManagerImpl.this.getOwnerEntity(target);
                for (int i = 0; i < items.length; ++i) {
                    if (EntityManagerImpl.this.isEntity(items[i])) {
                        if (parent != null) {
                            EntityManagerImpl.this.addReference(items[i], parent[0], (String)parent[1]);
                        } else {
                            EntityManagerImpl.this.attachEntity(items[i]);
                        }
                        EntityManagerImpl.this.dataManager.startTracking(items[i], parent != null ? parent[0] : null);
                        continue;
                    }
                    if (!(items[i] instanceof Object[])) continue;
                    Object[] obj = (Object[])items[i];
                    if (EntityManagerImpl.this.isEntity(obj[0])) {
                        if (parent != null) {
                            EntityManagerImpl.this.addReference(obj[0], parent[0], (String)parent[1]);
                        } else {
                            EntityManagerImpl.this.attachEntity(obj[0]);
                        }
                        EntityManagerImpl.this.dataManager.startTracking(obj[0], parent != null ? parent[0] : null);
                    }
                    if (!EntityManagerImpl.this.isEntity(obj[1])) continue;
                    if (parent != null) {
                        EntityManagerImpl.this.addReference(obj[1], parent[0], (String)parent[1]);
                    } else {
                        EntityManagerImpl.this.attachEntity(obj[1]);
                    }
                    EntityManagerImpl.this.dataManager.startTracking(obj[1], parent != null ? parent[0] : null);
                }
            } else if (kind == DataManager.ChangeKind.REMOVE && items != null && items.length > 0) {
                parent = EntityManagerImpl.this.getOwnerEntity(target);
                if (parent != null) {
                    for (int i = 0; i < items.length; ++i) {
                        if (EntityManagerImpl.this.isEntity(items[i])) {
                            EntityManagerImpl.this.removeReference(items[i], parent[0], (String)parent[1]);
                            continue;
                        }
                        if (!(items[i] instanceof Object[])) continue;
                        Object[] obj = (Object[])items[i];
                        if (EntityManagerImpl.this.isEntity(obj[0])) {
                            EntityManagerImpl.this.removeReference(obj[0], parent[0], (String)parent[1]);
                        }
                        if (!EntityManagerImpl.this.isEntity(obj[1])) continue;
                        EntityManagerImpl.this.removeReference(obj[1], parent[0], (String)parent[1]);
                    }
                }
            } else if (kind == DataManager.ChangeKind.REPLACE && items != null && items.length > 0) {
                parent = EntityManagerImpl.this.getOwnerEntity(target);
                for (int i = 0; i < items.length; ++i) {
                    Object[] item = (Object[])items[i];
                    if (EntityManagerImpl.this.isEntity(item[1]) && parent != null) {
                        EntityManagerImpl.this.removeReference(item[1], parent[0], (String)parent[1]);
                    }
                    if (!EntityManagerImpl.this.isEntity(item[2])) continue;
                    if (parent != null) {
                        EntityManagerImpl.this.addReference(item[2], parent[0], (String)parent[1]);
                    } else {
                        EntityManagerImpl.this.attachEntity(item[2]);
                    }
                    EntityManagerImpl.this.dataManager.startTracking(item[2], parent != null ? parent[0] : null);
                }
            }
            if (kind != DataManager.ChangeKind.ADD && kind != DataManager.ChangeKind.REMOVE && kind != DataManager.ChangeKind.REPLACE) {
                return;
            }
            log.debug("map changed: %s %s", new Object[]{kind, ObjectUtil.toString(target)});
            if (mergeContext == null || !mergeContext.isMerging() || mergeContext.isResolvingConflict()) {
                if (parent == null) {
                    log.warn("Owner entity not found for collection %s, cannot process dirty checking", new Object[]{ObjectUtil.toString(target)});
                } else {
                    EntityManagerImpl.this.dirtyCheckContext.entityMapChangeHandler(parent[0], (String)parent[1], (Map)target, kind, items);
                }
            }
        }
    }
}

