/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.granite.client.messaging.RemoteAlias;
import org.granite.client.messaging.RemoteService;
import org.granite.client.messaging.ResponseListener;
import org.granite.client.messaging.channel.ResponseMessageFuture;
import org.granite.client.messaging.events.CancelledEvent;
import org.granite.client.messaging.events.FailureEvent;
import org.granite.client.messaging.events.FaultEvent;
import org.granite.client.messaging.events.IssueEvent;
import org.granite.client.messaging.events.ResultEvent;
import org.granite.client.messaging.events.TimeoutEvent;
import org.granite.client.tide.Context;
import org.granite.client.tide.impl.ComponentImpl;
import org.granite.client.tide.impl.FutureResult;
import org.granite.client.tide.server.Component;
import org.granite.client.tide.server.ComponentListener;
import org.granite.client.tide.server.FaultException;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideResponder;
import org.granite.tide.invocation.InvocationCall;

public class ComponentListenerImpl<T>
implements ComponentListener<T> {
    private Context sourceContext;
    private Component component;
    private String componentName;
    private String operation;
    private Object[] args;
    private ComponentListener.Handler<T> handler;
    private TideResponder<T> tideResponder;
    private Object info;
    private boolean waiting = false;
    private Runnable responseHandler = null;
    private T result = null;
    private Exception exception = null;

    public ComponentListenerImpl(Context sourceContext, ComponentListener.Handler<T> handler, Component component, String operation, Object[] args, Object info, TideResponder<T> tideResponder) {
        this.sourceContext = sourceContext;
        this.handler = handler;
        this.component = component;
        this.componentName = component != null ? component.getName() : null;
        this.operation = operation;
        this.args = args;
        this.tideResponder = tideResponder;
        this.info = info;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public void setArgs(Object[] args) {
        this.args = args;
    }

    @Override
    public Context getSourceContext() {
        return this.sourceContext;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getResult() throws InterruptedException, ExecutionException {
        ComponentListenerImpl componentListenerImpl = this;
        synchronized (componentListenerImpl) {
            if (this.responseHandler == null && this.exception == null) {
                this.waiting = true;
                this.wait();
            }
            if (this.responseHandler != null) {
                this.responseHandler.run();
            }
        }
        if (this.exception instanceof ExecutionException) {
            throw (ExecutionException)this.exception;
        }
        if (this.exception instanceof InterruptedException) {
            throw (InterruptedException)this.exception;
        }
        return this.result;
    }

    @Override
    public void setResult(T result) {
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(ResultEvent event) {
        Runnable h = this.handler.result(this.sourceContext, event, this.info, this.componentName, this.operation, this.tideResponder, this);
        ComponentListenerImpl componentListenerImpl = this;
        synchronized (componentListenerImpl) {
            this.responseHandler = h;
            if (this.waiting) {
                this.notifyAll();
            } else {
                this.sourceContext.callLater(h);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFault(FaultEvent event) {
        Runnable h = this.handler.fault(this.sourceContext, event, this.info, this.componentName, this.operation, this.tideResponder, this);
        ComponentListenerImpl componentListenerImpl = this;
        synchronized (componentListenerImpl) {
            this.responseHandler = h;
            this.exception = new FaultException(event);
            if (this.waiting) {
                this.notifyAll();
            } else {
                this.sourceContext.callLater(h);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(FailureEvent event) {
        Runnable h = this.handler.issue(this.sourceContext, (IssueEvent)event, this.info, this.componentName, this.operation, this.tideResponder, this);
        ComponentListenerImpl componentListenerImpl = this;
        synchronized (componentListenerImpl) {
            this.exception = new ExecutionException(event.getCause());
            if (this.waiting) {
                this.notifyAll();
            } else {
                this.sourceContext.callLater(h);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeout(TimeoutEvent event) {
        Runnable h = this.handler.issue(this.sourceContext, (IssueEvent)event, this.info, this.componentName, this.operation, this.tideResponder, this);
        ComponentListenerImpl componentListenerImpl = this;
        synchronized (componentListenerImpl) {
            this.exception = new InterruptedException("timeout");
            if (this.waiting) {
                this.notifyAll();
            } else {
                this.sourceContext.callLater(h);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCancelled(CancelledEvent event) {
        Runnable h = this.handler.issue(this.sourceContext, (IssueEvent)event, this.info, this.componentName, this.operation, this.tideResponder, this);
        ComponentListenerImpl componentListenerImpl = this;
        synchronized (componentListenerImpl) {
            this.exception = new InterruptedException("cancel");
            if (this.waiting) {
                this.notifyAll();
            } else {
                this.sourceContext.callLater(h);
            }
        }
    }

    @Override
    public Future<T> invoke(ServerSession serverSession) {
        Object[] call = new Object[5];
        call[0] = this.getComponent().getName();
        String componentClassName = null;
        if (this.getComponent().getClass() != ComponentImpl.class) {
            RemoteAlias remoteAlias = this.getComponent().getClass().getAnnotation(RemoteAlias.class);
            componentClassName = remoteAlias != null ? remoteAlias.value() : this.getComponent().getClass().getName();
        }
        call[1] = componentClassName;
        call[2] = this.getOperation();
        call[3] = this.getArgs();
        call[4] = new InvocationCall();
        RemoteService ro = serverSession.getRemoteService();
        ResponseMessageFuture rmf = ro.newInvocation("invokeComponent", call).addListener((ResponseListener)this).invoke();
        serverSession.checkWaitForLogout();
        return new FutureResult(rmf, this);
    }
}

