/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.util.Map;
import org.granite.client.messaging.events.FaultEvent;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.server.ComponentListener;
import org.granite.client.tide.server.ExceptionHandler;
import org.granite.client.tide.server.Fault;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.logging.Logger;

public class IssueHandler<T>
implements Runnable {
    private static final Logger log = Logger.getLogger(IssueHandler.class);
    private final ServerSession serverSession;
    private final Context sourceContext;
    private final String componentName;
    private final String operation;
    private final FaultEvent event;
    private final Object info;
    private final TideResponder<T> tideResponder;
    private final ComponentListener<T> componentResponder;
    private boolean executed = false;

    public IssueHandler(ServerSession serverSession, Context sourceContext, String componentName, String operation, FaultEvent event, Object info, TideResponder<T> tideResponder, ComponentListener<T> componentResponder) {
        this.serverSession = serverSession;
        this.sourceContext = sourceContext;
        this.componentName = componentName;
        this.operation = operation;
        this.event = event;
        this.info = info;
        this.tideResponder = tideResponder;
        this.componentResponder = componentResponder;
    }

    @Override
    public void run() {
        Map extendedData;
        FaultMessage emsg;
        if (this.executed) {
            return;
        }
        this.executed = true;
        log.error("fault %s", new Object[]{this.event.toString()});
        Context context = this.sourceContext.getContextManager().retrieveContext(this.sourceContext, null, false, false);
        Object m = emsg = (FaultMessage)this.event.getMessage();
        Map map = extendedData = emsg != null ? emsg.getExtended() : null;
        do {
            if (m == null || m.getCode() == null || !m.isSecurityFault()) continue;
            emsg = m;
            extendedData = emsg != null ? emsg.getExtended() : null;
            break;
        } while ((m = m != null && m.getCause() instanceof FaultEvent ? (FaultMessage)((FaultEvent)m.getCause()).getCause() : (m.getCause() instanceof FaultMessage ? (FaultMessage)m.getCause() : null)) != null);
        this.serverSession.onFaultEvent(this.event, emsg);
        this.handleIssue(context, emsg);
        boolean handled = false;
        Fault fault = new Fault(emsg.getCode(), emsg.getDescription(), emsg.getDetails());
        fault.setContent(this.event.getMessage());
        fault.setCause(this.event.getCause());
        TideFaultEvent faultEvent = new TideFaultEvent(context, this.serverSession, this.componentResponder, fault, extendedData);
        if (this.tideResponder != null) {
            this.tideResponder.fault(faultEvent);
            if (faultEvent.isDefaultPrevented()) {
                handled = true;
            }
        }
        if (!handled) {
            ExceptionHandler[] exceptionHandlers = context.getContextManager().getContext(null).allByType(ExceptionHandler.class);
            if (exceptionHandlers != null && emsg != null) {
                for (ExceptionHandler handler : exceptionHandlers) {
                    if (!handler.accepts(emsg)) continue;
                    handler.handle(context, emsg, faultEvent);
                    handled = true;
                    break;
                }
                if (!handled) {
                    log.error("Unhandled fault: " + emsg.getCode() + ": " + emsg.getDescription(), new Object[0]);
                }
            } else if (exceptionHandlers != null && exceptionHandlers.length > 0) {
                exceptionHandlers[0].handle(context, (FaultMessage)this.event.getMessage(), faultEvent);
            } else {
                log.error("Unknown fault: " + this.event.toString(), new Object[0]);
            }
        }
        if (!handled && !this.serverSession.isLogoutInProgress()) {
            context.getEventBus().raiseEvent(context, "org.granite.tide.fault", this.event.getMessage());
        }
        this.serverSession.tryLogout();
    }

    public void handleIssue(Context context, FaultMessage emsg) {
    }
}

