/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.client.tide.Context;
import org.granite.client.tide.Factory;
import org.granite.client.tide.InstanceStore;
import org.granite.client.tide.impl.InstanceFactory;
import org.granite.client.tide.server.Component;

public class SimpleInstanceStore
implements InstanceStore {
    protected final Context context;
    protected final InstanceFactory instanceFactory;
    private static final String TYPED = "__TYPED__";
    private Map<String, Object> instances = new LinkedHashMap<String, Object>();
    private Set<Factory<?>> appliedFactories = new HashSet();
    private int NUM_TYPED_INSTANCE = 1;

    public SimpleInstanceStore(Context context, InstanceFactory instanceFactory) {
        this.context = context;
        this.instanceFactory = instanceFactory;
    }

    @Override
    public void init() {
        this.instances.put("context", this.context);
        this.instances.put("entityManager", this.context.getEntityManager());
        this.instances.put("dataManager", this.context.getDataManager());
        this.instances.put("eventBus", this.context.getEventBus());
        for (Map.Entry<String, Object> eb : this.context.getInitialBeans().entrySet()) {
            this.instances.put(eb.getKey(), eb.getValue());
        }
    }

    @Override
    public <T> T set(String name, T instance) {
        this.context.initInstance(instance, name);
        this.instances.put(name, instance);
        return instance;
    }

    @Override
    public <T> T set(T instance) {
        if (instance == null) {
            throw new NullPointerException("Cannot register null component instance");
        }
        this.context.initInstance(instance, null);
        if (!this.instances.containsValue(instance)) {
            this.instances.put(TYPED + this.NUM_TYPED_INSTANCE++, instance);
        }
        return instance;
    }

    @Override
    public void remove(String name) {
        this.context.destroyInstance(this.instances.remove(name));
    }

    @Override
    public void remove(Object instance) {
        Iterator<Map.Entry<String, Object>> ie = this.instances.entrySet().iterator();
        while (ie.hasNext()) {
            Map.Entry<String, Object> e = ie.next();
            if (e.getValue() != instance) continue;
            ie.remove();
            break;
        }
        this.context.destroyInstance(instance);
    }

    @Override
    public void clear() {
        for (Object instance : this.instances.values()) {
            this.context.destroyInstance(instance);
        }
        this.instances.clear();
        this.appliedFactories.clear();
    }

    @Override
    public List<String> allNames() {
        ArrayList<String> names = new ArrayList<String>(this.instances.size());
        for (String name : this.instances.keySet()) {
            if (name.startsWith(TYPED)) continue;
            names.add(name);
        }
        return names;
    }

    @Override
    public <T> T getNoProxy(String name, Context context) {
        Object instance = this.instances.get(name);
        if (instance instanceof Component) {
            return null;
        }
        return (T)instance;
    }

    @Override
    public boolean exists(String name) {
        return this.instances.containsKey(name);
    }

    @Override
    public <T> T byName(String name, Context context) {
        Factory<?> factory;
        Object instance = this.instances.get(name);
        if (instance == null && (factory = this.instanceFactory.forName(name, context.isGlobal())) != null) {
            if (factory.isSingleton() && !context.isGlobal()) {
                return context.getContextManager().getContext().byName(name);
            }
            instance = factory.create(context);
            context.initInstance(instance, name);
            this.instances.put(name, instance);
        }
        return (T)instance;
    }

    protected Object createInstance() {
        return null;
    }

    @Override
    public <T> T byType(Class<T> type, Context context) {
        Object instance = null;
        for (Object i : this.instances.values()) {
            if (!type.isInstance(i)) continue;
            if (instance == null) {
                instance = i;
                continue;
            }
            throw new RuntimeException("Ambiguous component definition for class " + type);
        }
        if (instance == null) {
            List<Factory<?>> factories = this.instanceFactory.forType(type, context.isGlobal());
            if (factories.size() > 1) {
                throw new RuntimeException("Ambiguous component definition for class " + type);
            }
            if (!factories.isEmpty()) {
                if (factories.get(0).isSingleton() && !context.isGlobal()) {
                    return context.getContextManager().getContext().byType(type);
                }
                if (this.appliedFactories.contains(factories.get(0))) {
                    throw new IllegalStateException("Instance for type " + type + " already created by factory but not found");
                }
                instance = factories.get(0).create(context);
                if (!this.instances.containsValue(instance)) {
                    context.initInstance(instance, factories.get(0).getName());
                    String name = factories.get(0).getName() != null ? factories.get(0).getName() : TYPED + this.NUM_TYPED_INSTANCE++;
                    this.instances.put(name, instance);
                    this.appliedFactories.add(factories.get(0));
                }
            }
        }
        return (T)instance;
    }

    @Override
    public <T> T[] allByType(Class<T> type, Context context, boolean create) {
        List<Factory<?>> factories = this.instanceFactory.forType(type, context.isGlobal());
        if (!factories.isEmpty() && !context.isGlobal() && factories.get(0).isSingleton()) {
            return context.getContextManager().getContext().allByType(type, create);
        }
        if (create) {
            for (Factory<?> factory : factories) {
                if (this.appliedFactories.contains(factory)) continue;
                String name = null;
                Object instance = null;
                if (factory.getName() != null) {
                    name = factory.getName();
                    instance = factory.create(context);
                    context.initInstance(instance, factory.getName());
                } else {
                    name = TYPED + this.NUM_TYPED_INSTANCE++;
                    instance = factory.create(context);
                    context.initInstance(instance, null);
                }
                this.instances.put(name, instance);
                this.appliedFactories.add(factory);
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object instance : this.instances.values()) {
            if (!type.isInstance(instance)) continue;
            list.add(instance);
        }
        Object[] all = (Object[])Array.newInstance(type, list.size());
        return list.size() > 0 ? list.toArray(all) : null;
    }

    @Override
    public Map<String, Object> allByAnnotatedWith(Class<? extends Annotation> annotationClass, Context context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.instances.entrySet()) {
            if (!entry.getValue().getClass().isAnnotationPresent(annotationClass)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map.isEmpty() ? null : map;
    }

    @Override
    public void inject(Object target, String componentName, Map<String, Object> properties) {
    }
}

