/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.server;

import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideFaultHandler;
import org.granite.client.tide.server.TideMergeResponder;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;
import org.granite.client.tide.server.TideResultHandler;

public class TideResponders {
    public static <T> TideResponder<T> noop() {
        return new EmptyTideResponder<Object>(null);
    }

    public static <T> TideMergeResponder<T> mergeWith(T mergeWith) {
        return new EmptyTideResponder<T>(mergeWith);
    }

    public static <T> TideMergeResponder<T> of(TideResultHandler<T> resultHandler) {
        return new LambdaTideResponder<Object>(resultHandler, null, null);
    }

    public static <T> TideMergeResponder<T> mergeWith(T mergeWith, TideFaultHandler faultHandler) {
        return new LambdaTideResponder<T>(null, faultHandler, mergeWith);
    }

    public static <T> TideMergeResponder<T> mergeWith(TideResultHandler<T> resultHandler, T mergeWith) {
        return new LambdaTideResponder<T>(resultHandler, null, mergeWith);
    }

    public static <T> TideMergeResponder<T> of(TideResultHandler<T> resultHandler, TideFaultHandler faultHandler) {
        return new LambdaTideResponder<Object>(resultHandler, faultHandler, null);
    }

    public static <T> TideMergeResponder<T> mergeWith(TideResultHandler<T> resultHandler, T mergeWith, TideFaultHandler faultHandler) {
        return new LambdaTideResponder<T>(resultHandler, faultHandler, mergeWith);
    }

    private static class LambdaTideResponder<T>
    implements TideMergeResponder<T> {
        private final TideResultHandler<T> resultHandler;
        private final TideFaultHandler faultHandler;
        private final T mergeWith;

        public LambdaTideResponder(TideResultHandler<T> resultHandler, TideFaultHandler faultHandler, T mergeWith) {
            this.resultHandler = resultHandler;
            this.faultHandler = faultHandler;
            this.mergeWith = mergeWith;
        }

        @Override
        public final void result(TideResultEvent<T> event) {
            if (this.resultHandler != null) {
                this.resultHandler.call(event);
            }
        }

        @Override
        public final void fault(TideFaultEvent event) {
            if (this.faultHandler != null) {
                this.faultHandler.call(event);
            }
        }

        @Override
        public T getMergeResultWith() {
            return this.mergeWith;
        }
    }

    private static class EmptyTideResponder<T>
    implements TideMergeResponder<T> {
        private final T mergeWith;

        public EmptyTideResponder(T mergeWith) {
            this.mergeWith = mergeWith;
        }

        @Override
        public final void result(TideResultEvent<T> event) {
        }

        @Override
        public final void fault(TideFaultEvent event) {
        }

        @Override
        public T getMergeResultWith() {
            return this.mergeWith;
        }
    }
}

