/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.spring;

import java.util.Map;
import org.granite.client.tide.Application;
import org.granite.client.tide.ApplicationConfigurable;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.EventBus;
import org.granite.client.tide.NameAware;
import org.granite.client.tide.data.Conflicts;
import org.granite.client.tide.data.DataConflictListener;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.impl.SimpleContextManager;
import org.granite.client.tide.spring.SpringEventBus;
import org.granite.client.tide.spring.SpringInstanceStoreFactory;
import org.granite.client.tide.spring.TideApplicationEvent;
import org.granite.client.tide.spring.ViewScope;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringContextManager
extends SimpleContextManager
implements ApplicationContextAware,
BeanPostProcessor,
BeanFactoryPostProcessor {
    private ApplicationContext applicationContext;

    public SpringContextManager(Application application) {
        super(application, new SpringEventBus());
    }

    public SpringContextManager(Application application, EventBus eventBus) {
        super(application, eventBus);
    }

    public SpringContextManager(ConfigurableApplicationContext applicationContext, Application application) {
        super(application, new SpringEventBus());
        this.setApplicationContext((ApplicationContext)applicationContext);
    }

    public SpringContextManager(ConfigurableApplicationContext applicationContext, Application application, EventBus eventBus) {
        super(application, eventBus);
        this.setApplicationContext((ApplicationContext)applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.setInstanceStoreFactory(new SpringInstanceStoreFactory(applicationContext));
        if (this.eventBus instanceof SpringEventBus) {
            ((SpringEventBus)this.eventBus).setApplicationContext(applicationContext);
        }
    }

    public Object postProcessBeforeInitialization(Object instance, String name) throws BeansException {
        if (name != null && instance instanceof NameAware) {
            ((NameAware)instance).setName(name);
        }
        if (instance instanceof ContextAware) {
            ((ContextAware)instance).setContext(this.getContext());
        }
        if (instance.getClass().isAnnotationPresent(ApplicationConfigurable.class)) {
            this.application.configure(instance);
        }
        return instance;
    }

    public Object postProcessAfterInitialization(Object instance, String name) throws BeansException {
        return instance;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!beanFactory.containsSingleton("context")) {
            beanFactory.registerSingleton("context", (Object)this.getContext());
        }
        if (!beanFactory.containsSingleton("entityManager")) {
            EntityManager entityManager = this.getContext().getEntityManager();
            entityManager.addListener(new SpringDataConflictListener());
            beanFactory.registerSingleton("entityManager", (Object)entityManager);
        }
        if (!beanFactory.containsSingleton("eventBus")) {
            beanFactory.registerSingleton("eventBus", (Object)this.eventBus);
        }
        if (!beanFactory.containsSingleton("dataManager")) {
            beanFactory.registerSingleton("dataManager", (Object)this.getContext().getDataManager());
        }
        for (Map.Entry<String, Object> entry : this.getContext().getInitialBeans().entrySet()) {
            if (beanFactory.containsSingleton(entry.getKey())) continue;
            beanFactory.registerSingleton(entry.getKey(), entry.getValue());
        }
        if (beanFactory.getRegisteredScope("view") == null) {
            beanFactory.registerScope("view", (Scope)new ViewScope());
        }
    }

    public static SpringContextManager configure(ConfigurableApplicationContext applicationContext, Application application) {
        final SpringContextManager contextManager = new SpringContextManager(applicationContext, application);
        applicationContext.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                if (!beanFactory.containsSingleton(SpringContextManager.class.getName())) {
                    beanFactory.registerSingleton(SpringContextManager.class.getName(), (Object)contextManager);
                }
            }
        });
        return contextManager;
    }

    private final class SpringDataConflictListener
    implements DataConflictListener {
        private SpringDataConflictListener() {
        }

        @Override
        public void onConflict(EntityManager entityManager, Conflicts conflicts) {
            TideApplicationEvent event = new TideApplicationEvent(SpringContextManager.this.getContext(null), EntityManager.UpdateKind.CONFLICT.eventName(), conflicts);
            SpringContextManager.this.applicationContext.publishEvent((ApplicationEvent)event);
        }
    }
}

